/*
The MIT License (MIT)

Copyright (c) 2016-2020 Containous SAS; 2020-2026 Traefik Labs

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	traefikiov1alpha1 "github.com/traefik/traefik/v3/pkg/provider/kubernetes/crd/traefikio/v1alpha1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// MiddlewareLister helps list Middlewares.
// All objects returned here must be treated as read-only.
type MiddlewareLister interface {
	// List lists all Middlewares in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*traefikiov1alpha1.Middleware, err error)
	// Middlewares returns an object that can list and get Middlewares.
	Middlewares(namespace string) MiddlewareNamespaceLister
	MiddlewareListerExpansion
}

// middlewareLister implements the MiddlewareLister interface.
type middlewareLister struct {
	listers.ResourceIndexer[*traefikiov1alpha1.Middleware]
}

// NewMiddlewareLister returns a new MiddlewareLister.
func NewMiddlewareLister(indexer cache.Indexer) MiddlewareLister {
	return &middlewareLister{listers.New[*traefikiov1alpha1.Middleware](indexer, traefikiov1alpha1.Resource("middleware"))}
}

// Middlewares returns an object that can list and get Middlewares.
func (s *middlewareLister) Middlewares(namespace string) MiddlewareNamespaceLister {
	return middlewareNamespaceLister{listers.NewNamespaced[*traefikiov1alpha1.Middleware](s.ResourceIndexer, namespace)}
}

// MiddlewareNamespaceLister helps list and get Middlewares.
// All objects returned here must be treated as read-only.
type MiddlewareNamespaceLister interface {
	// List lists all Middlewares in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*traefikiov1alpha1.Middleware, err error)
	// Get retrieves the Middleware from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*traefikiov1alpha1.Middleware, error)
	MiddlewareNamespaceListerExpansion
}

// middlewareNamespaceLister implements the MiddlewareNamespaceLister
// interface.
type middlewareNamespaceLister struct {
	listers.ResourceIndexer[*traefikiov1alpha1.Middleware]
}
