# scc

> Count lines of code. Written in Go.
> More information: <https://github.com/boyter/scc#usage>.

- Print lines of code in the current directory:

`scc`

- Print lines of code in the target directory:

`scc {{path/to/directory}}`

- Display output for every file:

`scc --by-file`

- Display output using a specific output format (defaults to `tabular`):

`scc {{[-f|--format]}} {{tabular|wide|json|csv|cloc-yaml|html|html-table}}`

- Only count files with specific file extensions:

`scc {{[-i|--include-ext]}} {{go,java,js}}`

- Exclude directories from being counted:

`scc --exclude-dir {{.git,.hg}}`

- Display output and sort by column (defaults to by files):

`scc {{[-s|--sort]}} {{files|name|lines|blanks|code|comments|complexity}}`

- Display help:

`scc {{[-h|--help]}}`
