# dnf

> Утилита управления пакетами для RHEL, Fedora и CentOS (заменяет yum).
> Некоторые подкоманды, такие как `group` и `config-manager`, имеют свою собственную документацию по использованию.
> Эквивалентные команды в других пакетных менеджерах смотрите в <https://wiki.archlinux.org/title/Pacman/Rosetta>.
> Больше информации: <https://dnf.readthedocs.io/en/latest/command_ref.html>.

- Обновить установленные пакеты до новейших доступных версий:

`sudo dnf {{[up|upgrade]}}`

- Поиск пакетов по ключевым словам:

`dnf {{[se|search]}} {{ключевое_слово1 ключевое_слово2 ...}}`

- Отобразить подробную информацию о пакете:

`dnf {{[if|info]}} {{пакет}}`

- Установить новый пакет (используйте --assumeyes для автоматического подтверждения всех запросов):

`sudo dnf {{[in|install]}} {{пакет1 пакет2 ...}}`

- Удалить пакет:

`sudo dnf {{[rm|remove]}} {{пакет1 пакет2 ...}}`

- Список установленных пакетов:

`dnf {{[ls|list]}} --installed`

- Найти какие пакеты предоставляют данную команду:

`dnf {{[wp|provides]}} {{команда}}`

- Просмотр всех прошлых операций:

`dnf {{[hist|history]}}`
