char *tt_gui = "#line quiet #port init gui 0\n"

"#function gui_link\n"
"{\n"
"	#format gui[link] {%+11h} {%3};\n"
"	#replace gui[link] {#} { };\n"
"	#line sub esc #var gui[link] {\e]68;2;%1;%2\a\e[4;24m$gui[link]\e[24m};\n"
"	#return $gui[link]\n"
"}\n"

"#function gui_profile_link\n"
"{\n"
"	#format gui[link] {%-24.24s} {%3};\n"

"	#line sub esc #var gui[link] {\e]68;2;%1;%2\a\e[4;24m$gui[link]\e[24m};\n"
"	#return $gui[link]\n"
"}\n"

"#event {PRESSED SECURE LINK COMMAND MOUSE BUTTON ONE} {%4}\n"

"#event {PRESSED SECURE LINK COMMAND MOUSE BUTTON THREE}\n"
"{\n"
"	#line ignore #showme {<138>Group<178>: %6 <138>Command<178>: %4}\n"
"}\n"

"#event {PRESSED SECURE LINK WORLD MOUSE BUTTON ONE}\n"
"{\n"
"	world_click {%4}\n"
"}\n"

"#event {PRESSED SECURE LINK WORLD MOUSE BUTTON THREE}\n"
"{\n"
"	#line ignore #showme {<138>Group<178>: %6 <138>Command<178>: %4}\n"
"}\n"

"#event {DOUBLE-CLICKED SECURE LINK WORLD MOUSE BUTTON ONE} {gui_connect}\n"

"#button {-2 28 -2 -28;PRESSED MOUSE BUTTON ONE}\n"
"{\n"
"	profile_tab_update;\n"

"	#screen inputregion -2 28 -2 -28 profile_tab_INPUT;\n"

"	profile_tab_set INPUT\n"
"}\n"

"#alias {gui_worlds}   {world_tab worlds}\n"
"#alias {gui_sponsors} {world_tab sponsors}\n"

"#alias {world_tab}\n"
"{\n"
"	#var gui[world_tab] %1;\n"

"	#class world_tab kill;\n"

"	#if {{$gui[world_tab]} == {worlds}}\n"
"	{\n"
"		#draw jade Yellow rounded calign box 1  1 3 13 {@gui_link{COMMAND;{profile_tab_cancel;world_tab worlds;draw_worlds};worlds}};\n"
"		#draw jade Azure  rounded calign box 1 14 3 26 {@gui_link{COMMAND;{profile_tab_cancel;world_tab sponsors;draw_sponsors};sponsors}}\n"
"	};\n"
"	#else\n"
"	{\n"
"		#draw jade Azure  rounded calign box 1  1 3 13 {@gui_link{COMMAND;{profile_tab_cancel;world_tab worlds;draw_worlds};worlds}};\n"
"		#draw jade Yellow rounded calign box 1 14 3 26 {@gui_link{COMMAND;{profile_tab_cancel;world_tab sponsors;draw_sponsors};sponsors}}\n"
"	};\n"

"	#draw jade Green rounded calign box -3  1 -1 13 {@gui_link{COMMAND;gui_new;new}};\n"
"	#draw jade Green rounded calign box -3 14 -1 26 {@gui_link{COMMAND;#delay 0 #end;exit}}\n"
"}\n"

"#alias {draw_world}\n"
"{\n"
"	#if {{%2} == {%3}}\n"
"	{\n"
"		#draw jade Yellow rounded TALIGN tile %1*2+3 2 %1*2+3 25 @gui_profile_link{WORLD;%2;%2};\n"
"	};\n"
"	#else\n"
"	{\n"
"		#draw jade  Azure rounded TALIGN tile %1*2+3 2 %1*2+3 25 @gui_profile_link{WORLD;%2;%2}\n"
"	}\n"
"}\n"

"#alias {world_click}\n"
"{\n"
"	#var gui[active] {%1};\n"

"	#nop profile_tab_cancel;\n"

"	#if {{$gui[world_tab]} == {worlds}}\n"
"	{\n"
"		#var gui[new] {$worldlist[%1]};\n"

"		draw_worlds\n"
"	};\n"
"	#else\n"
"	{\n"
"		#var gui[new] {$info[BANNERS][%1]} {{SSL}{off}} {{FILE}{}} {{CHARACTER}{}} {{PASSWORD}{}} {{INPUT}{}};\n"

"		draw_sponsors\n"
"	};\n"
"	reload_profile_tab;\n"

"	#buffer end\n"
"}\n"

"#function {gui_size_left}\n"
"{\n"
"	#if {{$gui[world_tab]} == {worlds}}\n"
"	{\n"
"		#return &worldlist[];\n"
"	};\n"
"	#else\n"
"	{\n"
"		#return &info[BANNERS][];\n"
"	}\n"
"}\n"

"#alias {gui_draw_left}\n"
"{\n"
"	#if {{$gui[world_tab]} == {worlds}}\n"
"	{\n"
"		draw_worlds\n"
"	};\n"
"	#else\n"
"	{\n"
"		draw_sponsors\n"
"	}\n"
"}\n"

"#alias {draw_worlds}\n"
"{\n"
"	#class world_tab kill;\n"
"	#class profile_tab kill;\n"

"	#draw tile 4 1 -4 26 { };\n"

"	#if {&worldlist[] == 0}\n"
"	{\n"
"		#return;\n"
"	};\n"

"	#local index $gui[index];\n"
"	#local offset 1;\n"
"       #local rows 0;\n"

"       #if {&worldlist[] * 2 - $index * 2 > $gui[rows] - 9}\n"
"       {\n"
"		#math rows ($gui[rows] - 3) & ~1;\n"
"	}\n"
"	{\n"
"		#math rows 6 + &worldlist[] * 2 - $index * 2;\n"
"	};\n"

"       #draw jade Azure rounded grid table 4 1 $rows 26 { }$worldlist[];\n"

"	#loop $gui[index] &worldlist[] index\n"
"	{\n"
"		draw_world {$offset} {$worldlist[+$index][NAME]} {$gui[active]};\n"

"		#math offset $offset + 1;\n"

"		#if {$offset * 2 + 1 > $gui[rows] - 6}\n"
"		{\n"
"			#break;\n"
"		};\n"
"	}\n"
"}\n"

"#alias {draw_sponsors}\n"
"{\n"
"	#class world_tab kill;\n"
"	#class profile_tab kill;\n"

"	#draw tile 4 1 -4 26 { };\n"

"	#if {&info[BANNERS][] == 0}\n"
"	{\n"
"		#line ignore #showme <faa>Sponsors: No banners found.;\n"
"		#return;\n"
"	};\n"

"	#local index $gui[index];\n"
"	#local offset 1;\n"
"       #local rows 0;\n"

"       #if {&info[BANNERS][] * 2 - $index * 2 > $gui[rows] - 9}\n"
"       {\n"
"		#math rows ($gui[rows] - 3) & ~1;\n"
"	}\n"
"	{\n"
"		#math rows 6 + &info[BANNERS][] * 2 - $index * 2;\n"
"	};\n"

"       #draw jade Azure rounded grid table 4 1 $rows 26 { }$info[BANNERS][];\n"

"	#loop $gui[index] &info[BANNERS][] index\n"
"	{\n"
"		draw_world {$offset} {$info[BANNERS][+$index][NAME]} {$gui[active]};\n"

"		#math offset $offset + 1;\n"

"		#if {$offset * 2 + 1 > $gui[rows] - 6}\n"
"		{\n"
"			#break\n"
"		}\n"
"	}\n"
"}\n"

"#alias {gui_tab_forward}\n"
"{\n"
"	#screen get INPUT_NAME input_name;\n"

"	#switch {{$input_name}}\n"
"	{\n"
"		#case {{profile_tab_NAME}}      {profile_tab_cycle ALIAS NAME};\n"
"		#case {{profile_tab_ALIAS}}     {profile_tab_cycle HOST ALIAS};\n"
"		#case {{profile_tab_HOST}}      {profile_tab_cycle PORT HOST};\n"
"		#case {{profile_tab_PORT}}      {profile_tab_cycle FILE PORT};\n"
"		#case {{profile_tab_FILE}}      {profile_tab_cycle CHARACTER FILE};\n"
"		#case {{profile_tab_CHARACTER}} {profile_tab_cycle PASSWORD CHARACTER};\n"
"		#case {{profile_tab_PASSWORD}}  {profile_tab_cycle INPUT PASSWORD};\n"
"		#case {{profile_tab_INPUT}}     {profile_tab_cycle NAME INPUT};\n"
"	}\n"
"}\n"

"#alias {gui_tab_backward}\n"
"{\n"
"	#screen get INPUT_NAME input_name;\n"

"	#switch {{$input_name}}\n"
"	{\n"
"		#case {{profile_tab_NAME}}      {profile_tab_cycle INPUT NAME};\n"
"		#case {{profile_tab_ALIAS}}     {profile_tab_cycle NAME ALIAS};\n"
"		#case {{profile_tab_HOST}}      {profile_tab_cycle ALIAS HOST};\n"
"		#case {{profile_tab_PORT}}      {profile_tab_cycle HOST PORT};\n"
"		#case {{profile_tab_FILE}}      {profile_tab_cycle PORT FILE};\n"
"		#case {{profile_tab_CHARACTER}} {profile_tab_cycle FILE CHARACTER};\n"
"		#case {{profile_tab_PASSWORD}}  {profile_tab_cycle CHARACTER PASSWORD};\n"
"		#case {{profile_tab_INPUT}}     {profile_tab_cycle PASSWORD INPUT};\n"
"	}\n"
"}\n"

"#alias {profile_tab_cycle}\n"
"{\n"
"	profile_tab_pull %2;\n"

"	#screen inputregion $gui[input][%1][top_row] $gui[input][%1][top_col] $gui[input][%1][bot_row] $gui[input][%1][bot_col] profile_tab_%1;\n"

"	profile_tab_set %1;\n"
"}\n"

"#alias {profile_tab_pull}\n"
"{\n"
"	#if {{%1} == {PASSWORD}}\n"
"	{\n"
"		#cursor get temp;\n"
"		#var gui[new][%1] {@b64z{$temp}};\n"
"		#unvar temp\n"
"	};\n"
"	#else\n"
"	{\n"
"		#cursor get {gui[new][%1]};\n"
"	};\n"
"	#cursor clear;\n"
"	profile_tab %1\n"
"}\n"

"#alias {profile_tab_update}\n"
"{\n"
"	#screen get INPUT_NAME input_name;\n"

"	#regex {$input_name} {profile_tab_{NAME|ALIAS|INPUT|HOST|PORT|FILE|CHARACTER|PASSWORD}}\n"
"	{\n"
"		profile_tab_pull &1\n"
"	}\n"
"}\n"

"#function gui_toggle\n"
"{\n"
"	#if {{%1} == {%2}}\n"
"	{\n"
"		#return %3\n"
"	};\n"
"	#return %2\n"
"}\n"

"#alias {profile_tab_set}\n"
"{\n"
"	#if {{%1} == {PASSWORD}}\n"
"	{\n"
"		#local temp {};\n"
"		#format temp %+64Z {$gui[new][%1]};\n"
"		#cursor set {$temp}\n"
"	};\n"
"	#else\n"
"	{\n"
"		#cursor set {$gui[new][%1]};\n"
"	}\n"
"}\n"

"#alias {profile_tab_input}\n"
"{\n"
"	#var gui[input][%5] {{top_row}{%1}{top_col}{%2}{bot_row}{%3}{bot_col}{%4}};\n"

"	#if {{%6} == {toggle}}\n"
"	{\n"
"		#button {%1 %2 %3 %4;PRESSED MOUSE BUTTON ONE}\n"
"		{\n"
"			#var gui[new][%5] @gui_toggle{$gui[new][%5];on;off};\n"
"			profile_tab %5\n"
"		}\n"
"	};\n"
"	#else\n"
"	{\n"
"		#button {%1 %2 %3 %4;PRESSED MOUSE BUTTON ONE}\n"
"		{\n"
"			profile_tab_update;\n"
"			#screen inputregion %1 %2 %3 %4 profile_tab_%5;\n"
"			profile_tab_set %5;\n"
"		};\n"
"		#event {CATCH RECEIVED INPUT profile_tab_%5}\n"
"		{\n"
"			profile_tab_pull %5;\n"
"			#screen inputregion -2 28 -2 -28 profile_tab_INPUT;\n"
"		}\n"
"	}\n"
"}\n"

"#function b64z\n"
"{\n"
"	#if {{%0} === {}}\n"
"	{\n"
"		#return {}\n"
"	};\n"
"	#local temp {};\n"
"	#format temp %+64z {%0};\n"
"	#return $temp\n"
"}\n"

"#function b64Z\n"
"{\n"
"	#if {{%0} === {}}\n"
"	{\n"
"		#return {}\n"
"	};\n"
"	#local temp {};\n"
"	#format temp %+64Z {%0};\n"
"	#return $temp\n"
"}\n"

"#function starout\n"
"{\n"
"	#local temp {%0};\n"
"	#replace temp {%.} {*};\n"
"	#return $temp\n"
"}\n"

"#alias {profile_tab_draw}\n"
"{\n"
"	#if {{%5} == {PASSWORD}}\n"
"	{\n"
"		#var temp @b64Z{$gui[new][%5]};\n"
"		#draw jade Silver rounded talign box %1 %2 %3 %4 {@starout{$temp}};\n"
"		#unvar temp\n"
"	};\n"
"	#else\n"
"	{\n"
"		#draw jade Silver rounded talign box %1 %2 %3 %4 {$gui[new][%5]};\n"
"	};\n"
"	#draw jade Azure scaled tile %1 %2+2 %1 %2+3 *gui[new][%5];\n"
"	#class profile_tab assign\n"
"	{\n"
"		profile_tab_input %1+1 %2+1 %1+1 %4-1 %5 %6\n"
"	};\n"
"}\n"

"#alias {profile_tab}\n"
"{\n"
"	#switch {{%1}}\n"
"	{\n"
"		#case {{NAME}}      {profile_tab_draw 1 -26 3 -1 NAME};\n"
"		#case {{ALIAS}}     {profile_tab_draw 4 -26 6 -1 ALIAS};\n"
"		#case {{HOST}}      {profile_tab_draw 7 -26 9 -1 HOST};\n"
"		#case {{PORT}}      {profile_tab_draw 10 -26 12 -9 PORT};\n"
"		#case {{SSL}}       {profile_tab_draw 10 -7 12 -1 SSL toggle};\n"
"		#case {{FILE}}      {profile_tab_draw 13 -26 15 -1 FILE};\n"
"		#case {{CHARACTER}} {profile_tab_draw 16 -26 18 -1 CHARACTER};\n"
"		#case {{PASSWORD}}  {profile_tab_draw 19 -26 21 -1 PASSWORD}\n"
"	};\n"
"}\n"

"#alias {profile_tab_cancel}\n"
"{\n"
"	#screen get INPUT_NAME input_name;\n"

"	#regex {$input_name} {profile_tab_{NAME|ALIAS|HOST|PORT|SSL|FILE|CHARACTER|PASSWORD}}\n"
"	{\n"
"		profile_tab_cycle INPUT &1\n"
"	};\n"

"	#screen clear square 1 -26 -1 -1;\n"
"	#var gui[profile_tab] 0;\n"
"	#math gui[index] 1\n"
"}\n"

"#alias {profile_tab_save}\n"
"{\n"
"	#screen get INPUT_NAME input_name;\n"

"	#regex {$input_name} {profile_tab_{NAME|ALIAS|INPUT|HOST|PORT|SSL|FILE|CHARACTER|PASSWORD}}\n"
"	{\n"
"		profile_tab_pull &1\n"
"	}\n"
"}\n"

"#alias {gui_new}\n"
"{\n"
"	#class profile_tab kill;\n"

"	#var gui[new] {{NAME}{} {ALIAS}{} {HOST}{} {PORT}{} {SSL}{off} {FILE}{} {CHARACTER}{} {PASSWORD}{} {INPUT}{}};\n"

"	reload_profile_tab\n"
"}\n"

"#alias {gui_connect}\n"
"{\n"
"	#if {&gui[new] == 0}\n"
"	{\n"
"		#line ignore #showme <faa>Connect: No world selected;#return;\n"
"	};\n"

"	profile_tab_update;\n"
"	#screen inputregion -2 28 -2 -28 profile_tab_INPUT;\n"
"	#cursor clear;\n"

"	#if {{$gui[new][ALIAS]} == {}}\n"
"	{\n"
"		#line ignore #showme <faa>Connect: No alias set;\n"
"		#return\n"
"	};\n"

"	#if {{$gui[new][HOST]} == {}}\n"
"	{\n"
"		#line ignore #showme <faa>Connect: No host set;\n"
"		#return\n"
"	};\n"

"	#if {{$gui[new][PORT]} == {}}\n"
"	{\n"
"		#line ignore #showme <faa>Connect: No port set;\n"
"		#return\n"
"	};\n"

"	#line ignore #showme {<acf>Connecting to <ffa>$gui[new][NAME]<acf>..};\n"

"	#config mouse off;\n"

"	#buffer refresh;\n"

"	#if {{$gui[new][SSL]} == {off}}\n"
"	{\n"
"		#session $gui[new][ALIAS] $gui[new][HOST] $gui[new][PORT] $gui[new][FILE];\n"
"	};\n"
"	#else\n"
"	{\n"
"		#ssl $gui[new][ALIAS] $gui[new][HOST] $gui[new][PORT] $gui[new][FILE];\n"
"	};\n"

"	#info SESSION save;\n"

"	#if {{$info[SESSION][NAME]} !== {gui}}\n"
"	{\n"
"		#if {{@gui{$gui[new][CHARACTER]}} !== {}}\n"
"		{\n"
"			@gui{$gui[new][CHARACTER]};\n"

"			#if {{@gui{$gui[new][PASSWORD]}} !== {}}\n"
"			{\n"
"				@gui{@b64Z{$gui[new][PASSWORD]}}\n"
"			}\n"
"		}\n"
"	};\n"
"	#else\n"
"	{\n"
"		#line ignore #showme <faa>Connect: Failed to connect to <ffa>$gui[new][NAME]<faa>.\n"
"	}\n"
"}\n"

"#alias {gui_save}\n"
"{\n"
"	#if {&gui[new] == 0}\n"
"	{\n"
"		#CLASS WORLDS WRITE $info[SYSTEM][TINTIN]/worlds.tin;\n"
"		#showme {<acf>Saving worlds.};\n"
"		#return;\n"
"	};\n"

"	profile_tab_update;\n"

"	#if {{$gui[new][NAME]} === {}}\n"
"	{\n"
"		#showme {<faa>Save: No profile name set.};\n"
"		#return;\n"
"	};\n"

"	#screen inputregion -2 28 -2 -28 profile_tab_INPUT;\n"

"	#var {worldlist[$gui[new][NAME]]} {$gui[new]};\n"

"	#unvar {worldlist[$gui[new][NAME]][DESC]};\n"

"	gui_worlds;\n"

"	draw_worlds;\n"

"	reload_profile_tab;\n"

"	#line ignore #showme {<acf>World <ffa>$gui[new][NAME]<acf> saved.};\n"

"	#CLASS WORLDS WRITE $info[SYSTEM][TINTIN]/worlds.tin;\n"
"}\n"

"#alias {gui_remove}\n"
"{\n"
"	#if {&gui[new] == 0}\n"
"	{\n"
"		#showme {<faa>Remove: No profile loaded.};\n"
"		#return;\n"
"	};\n"
"	#if {{$gui[new][NAME]} === {}}\n"
"	{\n"
"		#showme {<faa>Remove: No profile name set.};\n"
"		#return;\n"
"	};\n"

"	profile_tab_save;\n"

"	#unvar {worldlist[$gui[new][NAME]]};\n"

"	profile_tab_cancel;\n"

"	draw_worlds;\n"


"	#line ignore #showme {<acf>World <ffa>$gui[new][NAME]<acf> removed.};\n"

"	#CLASS WORLDS WRITE $info[SYSTEM][TINTIN]/worlds.tin;\n"
"}\n"


"#alias {reload_profile_tab}\n"
"{\n"
"	#var gui[profile_tab] 1;\n"

"	profile_tab NAME;\n"
"	profile_tab ALIAS;\n"
"	profile_tab HOST;\n"
"	profile_tab PORT;\n"
"	profile_tab SSL;\n"
"	profile_tab FILE;\n"
"	profile_tab CHARACTER;\n"
"	profile_tab PASSWORD;\n"

"	#buffer clear;\n"

"	#if {&gui[new][DESC] && $gui[cols] >= 26}\n"
"	{\n"
//"		#draw jade bumped ualign rounded scaled calign scroll box 1 1 1 $gui[cols] {<ffa>$gui[new][NAME] <fff>- <ffa>$gui[new][WEBSITE]};\n"
"		#draw jade bumped ualign rounded scaled calign scroll box 1 1 1 $gui[cols] {<ffa>$gui[new][NAME] <fff>- <ffa>\e]8;;$gui[new][WEBSITE]\a\e[04m$gui[new][WEBSITE]\e[24m\e]8;;\a};\n"
"		#draw jade Silver ualign rounded scaled scroll box 1 1 1 $gui[cols] {$gui[new][DESC]}\n"
"	};\n"

"	#draw jade Green rounded calign box -3 14 -1 26 {@gui_link{COMMAND;gui_connect;connect}};\n"

"	#draw jade Green rounded calign box -3 -26 -1 -14 {@gui_link{COMMAND;gui_save;save}};\n"

"	#if {{$gui[world_tab]} !== {sponsors}}\n"
"	{\n"
"		#draw jade Green rounded calign box -3 -13 -1 -1  {@gui_link{COMMAND;gui_remove;remove}};\n"
"	};\n"
"	#macro {\\t} {gui_tab_forward};\n"
"	#macro {\\e[Z} {gui_tab_backward};\n"
"}\n"

"#event {SESSION ACTIVATED}\n"
"{\n"
"	gui_reload\n"
"}\n"

"#alias {gui_reload}\n"
"{\n"
"	#split 1 3 27 27;\n"
"	#config mouse on;\n"

"	#screen clear split;\n"
"	#screen inputregion -2 28 -2 -28 profile_tab_INPUT;\n"

"	#screen get rows gui[rows];\n"
"	#screen get cols gui[cols];\n"

"	#math gui[cols] $gui[cols] - 54;\n"

"	#var gui[index] 1;\n"

"	#draw Orange rounded box -3 27 -1 -27;\n"
"	#draw Orange rounded box 1 27 -4 -27;\n"

"	world_tab $gui[world_tab];\n"

"	#switch {{$gui[world_tab]}}\n"
"	{\n"
"		#case {{worlds}}   {draw_worlds};\n"
"		#case {{sponsors}} {draw_sponsors}\n"
"	};\n"

"	#if {$gui[profile_tab] == 1}\n"
"	{\n"
"		reload_profile_tab\n"
"	}\n"
"}\n"

"#alias {gui_init}\n"
"{\n"
"	#config scroll_lock off;\n"

"	#class WORLDS assign #variable {worldlist} {};\n"

"	#info system save;\n"

"	#banner save;\n"

"	#line quiet #read $info[SYSTEM][TINTIN]/worlds.tin;\n"

"	#var gui[pause] 0;\n"
"	#var gui[profile_tab] 0;\n"
"	#var gui[world_tab] worlds;\n"

"	#screen inputregion -2 28 -2 -28 profile_tab_INPUT;\n"

"	#var gui[input][INPUT] {{top_row}{-2}{top_col}{28}{bot_row}{-2}{bot_col}{-28}};\n"

"	gui_reload;\n"

"	#if {$gui[cols] > 75}\n"
"	{\n"
"		#draw Silver huge traced scroll tile 1 1 6 73 { TINTIN++};\n"
"		#draw Silver calign scroll tile 1 1 2 75 {}{$info[SYSTEM][CLIENT_VERSION]};\n"
"		#draw Silver calign scroll tile 1 1 3 75 {}{Code by Peter Unold, Bill Reiss, and Igor van den Hoven}\n"
"	};\n"
"	#elseif {$gui[cols] > 40}\n"
"	{\n"
"		#draw Silver huge traced scroll tile 1 1 6 40 { TT++};\n"
"		#draw Silver calign scroll tile 1 1 2 40 {}{$info[SYSTEM][CLIENT_VERSION]};\n"
"		#draw Silver calign scroll tile 1 1 4 40 {}{Code by Peter Unold, Bill Reiss,}{}{and Igor van den Hoven}\n"
"	};\n"
"	#elseif {$gui[cols] > 18}\n"
"	{\n"
"		#draw Silver calign scroll tile 1 1 14 $gui[cols] {T I N T I N + +}{}{$info[SYSTEM][CLIENT_VERSION]}{}{Code by}{}{Peter Unold}{}{Bill Reiss}{}{and}{}{Igor van den Hoven};\n"
"	};\n"
"	#elseif {$gui[cols] > 8}\n"
"	{\n"
"		#draw Silver huge traced scroll tile 1 1 6 9 {T};\n"
"		#draw Silver huge traced scroll tile 1 1 6 9 {T};\n"
"		#draw Silver huge traced scroll tile 1 1 6 9 {+};\n"
"		#draw Silver huge traced scroll tile 1 1 6 9 {+};\n"
"		#draw Silver calign scroll tile 1 1 1 9 {$info[SYSTEM][CLIENT_VERSION]}\n"
"	};\n"
"	#elseif {$gui[cols] > 1}\n"
"	{\n"
"		#draw Silver calign scroll tile 1 1 8 $gui[cols] {T}{i}{n}{T}{i}{n}{+}{+}\n"
"	}\n"
"}\n"

"#EVENT {SCREEN RESIZE}\n"
"{\n"
"	#delay {gui_reload} {gui_reload;#buffer end} {0.1}\n"
"}\n"

"#EVENT {SESSION DESTROYED} {#gts #delay 0 #end}\n"

"#event {SCROLLED MOUSE WHEEL UP}\n"
"{\n"
"	#if {%1 <= 26}\n"
"	{\n"
"		#if {$gui[profile_tab] >= 0 && $gui[index] > 1}\n"
"		{\n"
"			#math gui[index] $gui[index] - 1;\n"
"			gui_draw_left\n"
"		}\n"
"	};\n"
"	#elseif {$gui[profile_tab] && %3 >= -26}\n"
"	{\n"
"		#if {$gui[pause] == 1}\n"
"		{\n"
"			#return;\n"
"		};\n"
"		gui_tab_backward;\n"
"		#var gui[pause] 1;\n"
"		#delay 0.2 #var gui[pause] 0\n"
"	};\n"
"	#else\n"
"	{\n"
"		#buffer up 1\n"
"	}\n"
"}\n"

"#event {SCROLLED MOUSE WHEEL DOWN}\n"
"{\n"
"	#if {%1 <= 26}\n"
"	{\n"
"		#if {$gui[profile_tab] >= 0 && $gui[index] < @gui_size_left{} && @gui_size_left{} > $gui[rows] / 3 - 6}\n"
"		{\n"
"			#math gui[index] $gui[index] + 1;\n"
"			gui_draw_left\n"
"		}\n"
"	};\n"
"	#elseif {$gui[profile_tab] && %3 >= -26}\n"
"	{\n"
"		#if {$gui[pause] == 1}\n"
"		{\n"
"			#return;\n"
"		};\n"
"		gui_tab_forward;\n"
"		#var gui[pause] 1;\n"
"		#delay 0.2 #var gui[pause] 0\n"
"	};\n"
"	#else\n"
"	{\n"
"		#buffer down 1;\n"
"	}\n"
"}\n"

"#delay 0 gui_init\n";


char *tt_regex = "#event {PROGRAM START}\n"
"{\n"
"	#var tab {{i}{0}{0}{}{1}{}};\n"
"	#info matches save;\n"
"	draw_gui;\n"
"	#config mouse on\n"
"}\n"
"\n"
"#event {SCREEN RESIZE}\n"
"{\n"
"	draw_gui;\n"
"	#buffer end\n"
"}\n"
"\n"
"#alias {draw_gui}\n"
"{\n"
"	#screen clear scroll;\n"
"	#screen scroll 7 1 -4 -1;\n"
"	#draw jade Silver rounded talign box 1 1 3 -1;\n"
"	#draw jade Azure scaled tile 1 3 1 6 {REGULAR EXPRESSION};\n"
"	#draw jade Silver rounded talign box 4 1 6 -1;\n"
"	#draw jade Azure scaled tile 4 3 4 6 {TEST STRING};\n"
"	#draw jade Green rounded calign box -3 -6 -1 -1 {exit};\n"
"	#draw jade Green rounded calign box -3 -12 -1 -7 {help};\n"
"\n"
"	#screen inputregion 5 2 5 -2 TAB_2;\n"
"	next_tab;\n"
"	next_tab\n"
"}\n"
"\n"
"#alias {next_tab}\n"
"{\n"
"	#if {$tab[i] == 0}\n"
"	{\n"
"		#screen inputregion 5 2 5 -2 TAB_2;\n"
"		#cursor clear;\n"
"		#cursor set $tab[1];\n"
"	};\n"
"	#if {$tab[i] == 1}\n"
"	{\n"
"		#screen inputregion 2 2 2 -2 TAB_1;\n"
"		#cursor clear;\n"
"		#cursor set $tab[0];\n"
"	};\n"
"	#math tab[i] ($tab[i] + 1) % 2;\n"
"}\n"
"\n"
"#alias {mouse_tab}\n"
"{\n"
"	#var tab[i] %1;\n"
"	#if {%1 == 0}\n"
"	{\n"
"		#screen inputregion 2 2 2 -2;\n"
"		#cursor clear;\n"
"		#cursor set $tab[0]\n"
"	};\n"
"	#if {%1 == 1}\n"
"	{\n"
"		#screen inputregion 5 2 5 -2;\n"
"		#cursor clear;\n"
"		#cursor set $tab[1]\n"
"	};\n"
"	#cursor position %2\n"
"}\n"
"\n"
"#button {2;2;2;-2;PRESSED MOUSE BUTTON ONE} {mouse_tab 0 %3-1}\n"
"#button {5;2;5;-2;PRESSED MOUSE BUTTON ONE} {mouse_tab 1 %3-1}\n"
"#button {-3;-6;-1;-1} {#end}\n"
"#button {-3;-12;-1;-7} {#buffer clear;#help regex}\n"
"\n"
"#event {SCROLLED MOUSE WHEEL DOWN} {#buffer down 3}\n"
"#event {SCROLLED MOUSE WHEEL UP} {#buffer up 3}\n"
"\n"
"#macro {\t}\n"
"{\n"
"	next_tab\n"
"}\n"
"\n"
"#alias {matches}\n"
"{\n"
"	#var result {};\n"
"\n"
"	#foreach {*info[MATCHES][]} {index}\n"
"	{\n"
"		#format temp {\\n%+3s %s} {<138>%$index} {<178>$info[MATCHES][$index]};\n"
"		#cat result {$temp}\n"
"	};\n"
"	#if {{$last} === {$result}}\n"
"	{\n"
"		#return\n"
"	};\n"
"	#buffer clear;\n"
"	#screen clear scroll;\n"
"	#line ignore #showme {$result};\n"
"\n"
"	#var last {$result}\n"
"}\n"
"\n"
"#event {GAG NO SESSION ACTIVE} {#nop}\n"
"\n"
"#event {PROCESSED KEYPRESS}\n"
"{\n"
"	#cursor get temp;\n"
"	#replace temp {\\\\x7B%*\\\\x7D} {{&1}};\n"
"	#replace temp {\\\\x7B%*\\\\x7D} {{&1}};\n"
"\n"
"	#if {{$temp} !== {$tab[$tab[i]]}}\n"
"	{\n"
"		#cursor get tab[$tab[i]];\n"
"		#delay {input} {input_update} {0.1}\n"
"	}\n"
"}\n"
"\n"
"#alias {input_update}\n"
"{\n"
"	#replace tab[0] {\\\\x7B%*\\\\x7D} {{&1}};\n"
"	#replace tab[0] {\\\\x7B%*\\\\x7D} {{&1}};\n"
"	#replace tab[1] {\\\\x7B%*\\\\x7D} {{&1}};\n"
"	#replace tab[1] {\\\\x7B%*\\\\x7D} {{&1}};\n"
"\n"
"	#regex {$tab[1]} {$tab[0]}\n"
"	{\n"
"		#info matches save\n"
"	}\n"
"	{\n"
"		#if {{$last} !== {}}\n"
"		{\n"
"			#buffer clear;\n"
"			#screen clear scroll;\n"
"			#line ignore #showme {<118>The regular expression does not match the test string.\n};\n"
"			#var last {}\n"
"		};\n"
"		#return\n"
"	};\n"
"	matches\n"
"}\n";
