
///////////////////////////////////////////////////////////
//                                                       //
//                         SAGA                          //
//                                                       //
//      System for Automated Geoscientific Analyses      //
//                                                       //
//                    User Interface                     //
//                                                       //
//                    Program: SAGA                      //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//                    DLG_Date.cpp                       //
//                                                       //
//          Copyright (C) 2025 by Olaf Conrad            //
//                                                       //
//-------------------------------------------------------//
//                                                       //
// This file is part of 'SAGA - System for Automated     //
// Geoscientific Analyses'. SAGA is free software; you   //
// can redistribute it and/or modify it under the terms  //
// of the GNU General Public License as published by the //
// Free Software Foundation, either version 2 of the     //
// License, or (at your option) any later version.       //
//                                                       //
// SAGA is distributed in the hope that it will be       //
// useful, but WITHOUT ANY WARRANTY; without even the    //
// implied warranty of MERCHANTABILITY or FITNESS FOR A  //
// PARTICULAR PURPOSE. See the GNU General Public        //
// License for more details.                             //
//                                                       //
// You should have received a copy of the GNU General    //
// Public License along with this program; if not, see   //
// <http://www.gnu.org/licenses/>.                       //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//    contact:    Olaf Conrad                            //
//                Institute of Geography                 //
//                University of Hamburg                  //
//                Germany                                //
//                                                       //
//    e-mail:     oconrad@saga-gis.org                   //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
#include <wx/panel.h>
#include <wx/calctrl.h>

#include "res_controls.h"
#include "res_dialogs.h"

#include "helper.h"

#include "dlg_date.h"


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
IMPLEMENT_CLASS(CDLG_Date, CDLG_Base)

//---------------------------------------------------------
BEGIN_EVENT_TABLE(CDLG_Date, CDLG_Base)
	EVT_BUTTON(ID_BTN_DATE_NOW, CDLG_Date::On_Now)
END_EVENT_TABLE()


///////////////////////////////////////////////////////////
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
CDLG_Date::CDLG_Date(const wxString &Caption, CSG_DateTime &Date)
	: CDLG_Base(-1, Caption)
{
	m_pDate    = &Date;

	m_pControl = new wxCalendarCtrl(this, wxID_ANY, wxDateTime(m_pDate->Get_JDN()), wxDefaultPosition, wxDefaultSize);//wxSUNKEN_BORDER);

	Add_Button(ID_BTN_DATE_NOW);

	wxRect r(GetRect()); wxSize s(m_pControl->GetSize()); s.x += 50 + 70; s.y += 50;

	SetSize(
		r.x + r.width  / 2 - s.x / 2,
		r.y + r.height / 2 - s.y / 2, s.x, s.y
	);

	Set_Positions();
}


///////////////////////////////////////////////////////////
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
void CDLG_Date::Save_Changes(void)
{
	if( m_pDate )
	{
		m_pDate->Set(m_pControl->GetDate().GetJDN());
	}
}


///////////////////////////////////////////////////////////
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
void CDLG_Date::Set_Position(wxRect r)
{
	m_pControl->SetPosition(wxPoint(
		r.x + r.width  / 2 - m_pControl->GetSize().x / 2,
		r.y + r.height / 2 - m_pControl->GetSize().y / 2
	));
}


///////////////////////////////////////////////////////////
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
void CDLG_Date::On_Now(wxCommandEvent &event)
{
	m_pControl->SetDate(wxDateTime::Today());
}


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
IMPLEMENT_CLASS(CDLG_Date_Picker, wxDialog)

//---------------------------------------------------------
BEGIN_EVENT_TABLE(CDLG_Date_Picker, wxDialog)
	EVT_CALENDAR_DAY(wxID_ANY, CDLG_Date_Picker::On_Changed)
END_EVENT_TABLE()


///////////////////////////////////////////////////////////
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
CDLG_Date_Picker::CDLG_Date_Picker(wxWindow *pParent, const wxString &Caption, CSG_DateTime &Date)
	: wxDialog(pParent, wxID_ANY, Caption, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE)
{
	m_pDate    = &Date;

	m_pControl = new wxCalendarCtrl(this, wxID_ANY, wxDateTime(m_pDate->Get_JDN()), wxDefaultPosition, wxDefaultSize);//wxSUNKEN_BORDER);

	int caption_y = wxSystemSettings::GetMetric(wxSYS_CAPTION_Y, m_pControl);

	wxRect r(pParent->GetScreenRect()); wxSize s(m_pControl->GetSize()); s.x += 20; s.y += 20 + caption_y;

	SetSize(r.x - s.x, r.y + r.height, s.x, s.y);
}


///////////////////////////////////////////////////////////
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
void CDLG_Date_Picker::On_Changed(wxCalendarEvent &event)
{
	if( m_pDate )
	{
		m_pDate->Set(m_pControl->GetDate().GetJDN());
	}

	EndModal(wxID_OK);
}


///////////////////////////////////////////////////////////
//                                                       //
//                                                       //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
