/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 1 "parser.ypp"
 /* -*- mode: c++; indent-tabs-mode: nil -*-

    parser.ypp

    Qore Programming Language

    Copyright (C) 2003 - 2024 Qore Technologies, s.r.o.

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.

    Note that the Qore library is released under a choice of three open-source
    licenses: MIT (as above), LGPL 2+, or GPL 2+; see README-LICENSE for more
    information.
*/

#include "qore/Qore.h"
#include "qore/intern/BreakStatement.h"
#include "qore/intern/ContinueStatement.h"
#include "qore/intern/ReturnStatement.h"
#include "qore/intern/RethrowStatement.h"
#include "qore/intern/ThreadExitStatement.h"
#include "qore/intern/ExpressionStatement.h"
#include "qore/intern/DoWhileStatement.h"
#include "qore/intern/SummarizeStatement.h"
#include "qore/intern/ContextStatement.h"
#include "qore/intern/IfStatement.h"
#include "qore/intern/WhileStatement.h"
#include "qore/intern/ForStatement.h"
#include "qore/intern/ForEachStatement.h"
#include "qore/intern/TryStatement.h"
#include "qore/intern/ThrowStatement.h"
#include "qore/intern/StatementBlock.h"
#include "qore/intern/ParserSupport.h"
#include "qore/intern/SwitchStatement.h"
#include "qore/intern/CaseNodeWithOperator.h"
#include "qore/intern/CaseNodeRegex.h"
#include "qore/intern/OnBlockExitStatement.h"
#include "qore/intern/ConstantList.h"
#include "qore/intern/GlobalVariableList.h"
#include "qore/intern/QoreNamespaceIntern.h"
#include "qore/intern/QoreParseHashNode.h"
#include "qore/intern/QoreParseListNode.h"
#include "qore/intern/ModuleInfo.h"

#include "parser.hpp"

#include "qore/intern/QoreClassIntern.h"
#include "qore/intern/QoreParseClass.h"
#include "qore/intern/qore_program_private.h"
#include "qore/intern/typed_hash_decl_private.h"
#include "qore/intern/qore_list_private.h"

#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <memory>
#include <sstream>
#include <utility>
#include <vector>

#define YYINITDEPTH 300
//#define YYDEBUG 1

#define YYLLOC_DEFAULT(Current, Rhs, N)                         \
    do {                                                        \
        if (N) {                                                \
            (Current).first_line = YYRHSLOC(Rhs, 1).first_line; \
            (Current).first_col  = YYRHSLOC(Rhs, 1).first_col;  \
            (Current).last_line  = YYRHSLOC(Rhs, N).last_line;  \
            (Current).last_col   = YYRHSLOC(Rhs, N).last_col;   \
        } else {                                                \
            (Current).first_line = (Current).last_line =        \
                YYRHSLOC(Rhs, 0).last_line;                     \
            (Current).first_col = (Current).last_col =          \
                YYRHSLOC(Rhs, 0).last_col;                      \
        }                                                       \
    } while (0)

// to fix the start location of an expression
static void fix_start_location(int val, QoreParserLocation& loc, QoreParserLocation& exp_loc) {
    if (!val) {
        loc.first_col = exp_loc.first_col;
        loc.first_line = exp_loc.first_line;
        loc.last_col = exp_loc.last_col;
        loc.last_line = exp_loc.last_line;
    }
}

static void fix_start_location(void* val, QoreParserLocation& loc, QoreParserLocation& exp_loc) {
    fix_start_location(val ? 1 : 0, loc, exp_loc);
}

class HashElement {
public:
    QoreValue key;
    QoreValue value;
    const QoreProgramLocation* loc;

    DLLLOCAL HashElement(QoreValue k, QoreValue v, int sl, int el) : key(k), value(v), loc(qore_program_private::get(*getProgram())->getLocation(sl, el)) {
        //traceout("HashElement::HashElement()");
    }

    DLLLOCAL ~HashElement() {
        key.discard(nullptr);
        value.discard(nullptr);
    }

    DLLLOCAL void addDelete(QoreParseHashNode* h) {
        h->add(key, value, loc);
        key.clear();
        value.clear();
        delete this;
    }
};

// for constant definitions
class ConstNode {
public:
    const QoreProgramLocation* loc;
    NamedScope name;
    QoreValue value;
    bool pub;

    DLLLOCAL ConstNode(const QoreProgramLocation* loc, char* n, QoreValue v, bool p = false) : loc(loc), name(n), value(v), pub(p) {
        // see if constant definitions are allowed
        if (parse_check_parse_option(PO_NO_CONSTANT_DEFS))
            parse_error(*loc, "illegal constant definition \"%s\" (conflicts with parse option PO_NO_CONSTANT_DEFS)", n);
    }
    DLLLOCAL QoreValue takeValue() {
        QoreValue rv = value;
        value.clear();
        return rv;
    }
    DLLLOCAL const char* getName() const {
        return name.getIdentifier();
    }
    DLLLOCAL bool isPublic() const {
        return pub;
    }
};

class ObjClassDef {
public:
    const QoreProgramLocation* loc;
    NamedScope* name;
    QoreClass* oc;

    DLLLOCAL ObjClassDef(const QoreProgramLocation* loc, NamedScope *n, QoreClass* o) : loc(loc), name(n), oc(o) {
        checkName();
        // override class declaration location
        qore_class_private::get(*o)->loc = loc;
    }

    DLLLOCAL ObjClassDef(const QoreProgramLocation* loc, char* n, QoreClass* o) : loc(loc), name(new NamedScope(n)), oc(o) {
        checkName();
        // override class declaration location
        qore_class_private::get(*o)->loc = loc;
    }

    DLLLOCAL ~ObjClassDef() {
        delete name;
    }

    DLLLOCAL void checkName() {
        if (!strcmp(name->getIdentifier(), "auto"))
            parse_error(*loc, "a class may not have the name 'auto'; this name has a special meaning in complex types; please choose another name for your class");
    }
};

class HashDeclDef {
public:
    const QoreProgramLocation* loc;
    NamedScope* name;
    TypedHashDecl* hashdecl;

    DLLLOCAL HashDeclDef(const QoreProgramLocation* loc, NamedScope *n, typed_hash_decl_private* hp) :
            loc(loc), name(n), hashdecl(hp->newTypedHashDecl(name->getIdentifier())) {
        checkName();
    }

    DLLLOCAL HashDeclDef(const QoreProgramLocation* loc, char* n, typed_hash_decl_private* hp) :
            loc(loc), name(new NamedScope(n)), hashdecl(hp->newTypedHashDecl(name->getIdentifier())) {
        checkName();
    }

    DLLLOCAL ~HashDeclDef() {
        delete name;
        if (hashdecl)
            typed_hash_decl_private::get(*hashdecl)->deref();
    }

    DLLLOCAL void checkName() {
        if (!strcmp(name->getIdentifier(), "auto"))
            parse_error(*loc, "a hashdecl may not have the name 'auto'; this name has a special meaning in complex types; please choose another name for your hashdecl");
    }

    DLLLOCAL TypedHashDecl* takeHashDecl() {
        TypedHashDecl* rv = hashdecl;
        hashdecl = nullptr;
        return rv;
    }
};

class ParseUserFunctionBase {
public:
    const QoreProgramLocation* loc;
    UserFunctionVariant* variant;

    DLLLOCAL ParseUserFunctionBase(const QoreProgramLocation* loc, UserFunctionVariant* v) : loc(loc), variant(v) {
    }

    DLLLOCAL ~ParseUserFunctionBase() {
        if (variant)
            variant->deref();
    }

    DLLLOCAL void setPublic() {
        variant->setModulePublic();
    }
};

class ParseUserFunction : public ParseUserFunctionBase {
public:
    char* name;

    DLLLOCAL ParseUserFunction(const QoreProgramLocation* loc, char* n_name, UserFunctionVariant* n_variant) : ParseUserFunctionBase(loc, n_variant), name(n_name) {
    }

    DLLLOCAL ~ParseUserFunction() {
        if (name)
            free(name);
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        qore_root_ns_private::addPendingVariant(ns, name, variant);
        variant = 0;
        // make sure definition was legal
        if (parse_check_parse_option(PO_NO_SUBROUTINE_DEFS)) {
            const char* nsn = ns.name.c_str();
            parse_error(*loc, "function '%s%s%s()' cannot be defined (conflicts with parse option PO_NO_SUBROUTINE_DEFS)", nsn[0] ? nsn : "", nsn[0] ? "::" : "", name);
        }

        delete this;
    }
};

class ParseScopedUserFunction : public ParseUserFunctionBase {
public:
    NamedScope name;

    DLLLOCAL ParseScopedUserFunction(const QoreProgramLocation* loc, char* n_name, UserFunctionVariant* n_variant) : ParseUserFunctionBase(loc, n_variant), name(n_name) {
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        qore_root_ns_private::addPendingVariant(ns, name, variant);
        variant = 0;
        // make sure definition was legal
        if (parse_check_parse_option(PO_NO_SUBROUTINE_DEFS))
            parse_error(*loc, "function '%s()' cannot be defined (conflicts with parse option PO_NO_SUBROUTINE_DEFS)", name.ostr);

        delete this;
    }
};

struct GVarDecl {
    const QoreProgramLocation* loc;
    bool pub;

    DLLLOCAL GVarDecl(const QoreProgramLocation* loc, bool p) : loc(loc), pub(p) {
    }

    DLLLOCAL virtual ~GVarDecl() {
    }

    DLLLOCAL virtual void add(qore_ns_private& ns) = 0;

    DLLLOCAL virtual AbstractQoreNode* makeVar() = 0;
};

struct GVarSingleDecl : public GVarDecl {
    char* name;
    const QoreTypeInfo* typeInfo;
    QoreParseTypeInfo* parseTypeInfo;
    qore_var_t type;

    DLLLOCAL GVarSingleDecl(const QoreProgramLocation* loc, char* n, const QoreTypeInfo* ti, QoreParseTypeInfo* pti,
            bool p, bool bare, qore_var_t type = VT_GLOBAL) : GVarDecl(loc, p), name(n), typeInfo(ti), parseTypeInfo(pti),
            type(type) {
        //printd(5, "GVarSingleDecl::GVarSingleDecl() '%s' %d-%d\n", n, loc.start_line, loc.end_line);
        if (bare) {
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "%s variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set",
                    type == VT_GLOBAL ? "global" : "thread_local", n);
        } else {
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to %s variable '$%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set",
                    type == VT_GLOBAL ? "global" : "thread_local", n);
        }
        if (qore_program_private::get(*getProgram())->expression_mode) {
            parse_error(*loc, "%s variable declaration '%s' not allowed in expressions' is set",
                type == VT_GLOBAL ? "global" : "thread_local", n);
        }
    }

    DLLLOCAL virtual ~GVarSingleDecl() {
        if (name)
            free(name);

        delete parseTypeInfo;
    }

    DLLLOCAL char* takeName() {
        char* rv = name;
        name = 0;
        return rv;
    }

    DLLLOCAL QoreParseTypeInfo* takeParseTypeInfo() {
        QoreParseTypeInfo* rv = parseTypeInfo;
        parseTypeInfo = nullptr;
        return rv;
    }

    DLLLOCAL virtual void add(qore_ns_private& ns) {
        ns.parseAddGlobalVarDecl(loc, takeName(), typeInfo, takeParseTypeInfo(), pub, type);
        delete this;
    }

    DLLLOCAL virtual AbstractQoreNode* makeVar() {
        GlobalVarRefNode* gv = typeInfo
            ? new GlobalVarRefNode(loc, takeName(), typeInfo, type)
            : new GlobalVarRefNode(loc, takeName(), takeParseTypeInfo(), type);
        if (pub)
            gv->setPublic();

        delete this;
        return gv;
    }
};

struct GVarListDecl : public GVarDecl {
    QoreParseListNode* l;
    qore_var_t type;

    DLLLOCAL GVarListDecl(const QoreProgramLocation* loc, QoreParseListNode* list, bool p,
            qore_var_t type = VT_GLOBAL)
            : GVarDecl(loc, p), l(list), type(type) {
        bool bareok = parse_check_parse_option(PO_ALLOW_BARE_REFS);

        QoreParseListNode::nvec_t& vl = l->getValues();
        for (unsigned i = 0; i < vl.size(); ++i) {
            QoreValue n = vl[i];
            qore_type_t t = n.getType();
            if (t == NT_BAREWORD) {
                BarewordNode* b = n.get<BarewordNode>();
                if (!bareok)
                    parse_error(*loc, "variable '%s' in %s variable declaration list declared without '$' " \
                        "prefix, but parse option 'allow-bare-refs' is not set", b->str,
                        type == VT_GLOBAL ? "global" : "thread_local");
            } else if (t == NT_VARREF) {
                VarRefNode* vrn = n.get<VarRefNode>();
                if (vrn->explicitScope()) {
                    if (vrn->getType() == VT_LOCAL)
                        parse_error(*loc, "illegal use of 'my %s' in %s variable declaration list", vrn->getName(),
                            type == VT_GLOBAL ? "global" : "thread_local");
                    else if (vrn->getType() == VT_GLOBAL)
                        parse_error(*loc, "illegal use of 'our %s' in %s variable declaration list", vrn->getName(),
                            type == VT_GLOBAL ? "global" : "thread_local");
                }
            } else
                parse_error(*loc, "element %d in list following '%s' is not a variable reference (%s)", i,
                    type == VT_GLOBAL ? "our" : "thread_local", n.getTypeName());
        }
    }

    DLLLOCAL virtual ~GVarListDecl() {
        if (l) {
            l->deref(nullptr);
        }
    }

    DLLLOCAL QoreParseListNode* takeList() {
        QoreParseListNode* rv = l;
        l = nullptr;
        return rv;
    }

    DLLLOCAL virtual void add(qore_ns_private& ns) {
        QoreParseListNode::nvec_t& vl = l->getValues();
        for (unsigned i = 0; i < vl.size(); ++i) {
            QoreValue n = vl[i];
            qore_type_t t = n.getType();
            if (t == NT_BAREWORD) {
                BarewordNode* b = n.get<BarewordNode>();
                ns.parseAddGlobalVarDecl(loc, b->takeString(), 0, 0, pub, type);
            } else if (t == NT_VARREF) {
                VarRefNode* vrn = n.get<VarRefNode>();
                if (!vrn->explicitScope()) {
                    VarRefDeclNode* vrdn = dynamic_cast<VarRefDeclNode*>(vrn);
                    if (vrdn) {
                        ns.parseAddGlobalVarDecl(loc, vrn->takeName(), vrdn->getTypeInfo(),
                            vrdn->takeParseTypeInfo(), pub, type);
                    } else {
                        ns.parseAddGlobalVarDecl(loc, vrn->takeName(), 0, 0, pub, type);
                    }
                }
            }
        }

        delete this;
    }

    DLLLOCAL virtual AbstractQoreNode* makeVar() {
        l->setVariableList();
        QoreParseListNode::nvec_t& vl = l->getValues();
        for (unsigned i = 0; i < vl.size(); ++i) {
            QoreValue& n = vl[i];
            qore_type_t t = n.getType();
            VarRefNode* vrn = nullptr;
            if (t == NT_BAREWORD) {
                BarewordNode* b = n.get<BarewordNode>();
                GlobalVarRefNode* v = new GlobalVarRefNode(loc, b->takeString(), (const QoreTypeInfo*)nullptr, type);
                b->deref();
                n = vrn = v;
            } else if (t == NT_VARREF) {
                vrn = n.get<VarRefNode>();
                if (!vrn->explicitScope()) {
                    vrn->makeGlobal(type);
                    vrn->setExplicitScope();
                    //printd(5, "GVarListDecl::makeVar() '%s' t: %d set global with explicit scope\n",
                    //  vrn ? vrn->getName() : "n/a", type);
                }
            }

            if (vrn && pub)
                vrn->setPublic();
        }

        QoreParseListNode* rv = takeList();
        delete this;
        return rv;
    }
};

static int check_method(const QoreProgramLocation* loc, const char* name, BCAList* bcal,
        RetTypeInfo* returnTypeInfo) {
    bool con = !strcmp(name, "constructor");
    bool dst = !con && !strcmp(name, "destructor");

    // see if a return type is given for special methods
    if (returnTypeInfo && (con || dst)) {
        parse_error(*loc, "%s methods may not declare a return type", name);
        return -1;
    }

    if (bcal && !con) {
        parse_error(*loc, "base class constructor lists are only legal when defining constructor() methods");
        return -1;
    }

    return 0;
}

#define OFM_PUBLIC     (1 << 0)
#define OFM_PRIVATE    (1 << 1)
#define OFM_INTERNAL   (1 << 2)
#define OFM_SYNCED     (1 << 3)
#define OFM_STATIC     (1 << 4)
#define OFM_DEPRECATED (1 << 5)
#define OFM_FINAL      (1 << 6)
#define OFM_ABSTRACT   (1 << 7)

static inline MethodVariantBase* new_method_variant(const QoreProgramLocation* loc, const char* name, int mod, int n_sig_first_line, int n_sig_last_line, QoreValue params, BCAList* bcal, RetTypeInfo* returnTypeInfo, StatementBlock *b) {
    //printd(5, "new_method_variant() '%s' b: %p\n", name, b);

    int64 flags = QCF_NO_FLAGS;

    if (get_pop_argv_ref())
        flags |= QCF_USES_EXTRA_ARGS;

    ClassAccess access = Public;
    if (mod & OFM_PRIVATE) {
        if (mod & OFM_INTERNAL)
            parse_error(*loc, "%s() methods cannot be both private:hierarchy and private:internal", name);
        if (mod & OFM_PUBLIC)
            parse_error(*loc, "%s() methods cannot be both public and private", name);
        access = Private;
    } else if (mod & OFM_INTERNAL) {
        if (mod & OFM_PUBLIC)
            parse_error(*loc, "%s() methods cannot be both public and private", name);
        access = Internal;
    }

    if (mod & OFM_DEPRECATED)
        flags |= QCF_DEPRECATED;

    if (!strcmp(name, "constructor")) {
        if (mod & OFM_SYNCED)
            parse_error(*loc, "%s() methods cannot be synchronized", name);
        if (mod & OFM_FINAL)
            parse_error(*loc, "%s() methods cannot be declared final; declare the class final instead", name);
        if (mod & OFM_ABSTRACT)
            parse_error(*loc, "%s() methods cannot be declared abstract", name);
        if (returnTypeInfo) {
            parse_error(*loc, "return type information cannot be defined for %s() methods", name);
            delete returnTypeInfo;
        }
        return new UserConstructorVariant(access, b, n_sig_first_line, n_sig_last_line, params, bcal, flags);
    }
    if (bcal) {
        parse_error(*loc, "only constructors may have base class constructor arguments");
        delete bcal;
        bcal = 0;
    }
    if (!strcmp(name, "destructor")) {
        if (params) {
            parse_error(*loc, "parameters cannot be defined for destructors");
            params.discard(nullptr);
        }
        if (mod & OFM_SYNCED)
            parse_error(*loc, "%s() methods cannot be synchronized", name);
        if (mod & OFM_FINAL)
            parse_error(*loc, "%s() methods cannot be declared final; declare the class final instead", name);
        if (mod & OFM_ABSTRACT)
            parse_error(*loc, "%s() methods cannot be declared abstract", name);
        if (returnTypeInfo) {
            parse_error(*loc, "return type information cannot be defined for %s() methods", name);
            delete returnTypeInfo;
        }
        if (access > Public)
            parse_error(*loc, "destructors cannot be private");
        return new UserDestructorVariant(b, n_sig_first_line, n_sig_last_line);
    }
    if (!strcmp(name, "copy")) {
        if (mod & OFM_FINAL) {
            parse_error(*loc, "%s() methods cannot be declared final; declare the class final instead", name);
        }
        if (mod & OFM_ABSTRACT) {
            parse_error(*loc, "%s() methods cannot be declared abstract", name);
        }
        return new UserCopyVariant(access, b, n_sig_first_line, n_sig_last_line, params, returnTypeInfo, mod & OFM_SYNCED);
    }

    if (!strcmp(name, "methodGate") || !strcmp(name, "memberGate") || !strcmp(name, "memberNotification")) {
        if (mod & OFM_FINAL) {
            parse_error(*loc, "%s() methods cannot be declared final; they are not inherited anyway", name);
        }
    }

    if (mod & OFM_FINAL && mod & OFM_ABSTRACT)
        parse_error(*loc, "method '%s()' is declared both final and abstract", name);

    return new UserMethodVariant(access, mod & OFM_FINAL, b, n_sig_first_line, n_sig_last_line, params, returnTypeInfo, mod & OFM_SYNCED, flags, mod & OFM_ABSTRACT);
}

struct MethodDef {
    const QoreProgramLocation* loc;
    MethodVariantBase* m;
    NamedScope name;
    bool static_flag;

    DLLLOCAL MethodDef(const QoreProgramLocation* loc, int mod, char* n, int n_sig_first_line, int n_sig_last_line, QoreValue params, BCAList* bcal, RetTypeInfo* returnTypeInfo, StatementBlock *b) : loc(loc), m(0), name(n), static_flag(mod & OFM_STATIC) {
        if (check_method(loc, name.getIdentifier(), bcal, returnTypeInfo)) {
            params.discard(nullptr);
            delete bcal;
            delete b;
            delete returnTypeInfo;
            return;
        }

        m = new_method_variant(loc, name.getIdentifier(), mod, n_sig_first_line, n_sig_last_line, params, bcal, returnTypeInfo, b);
    }

    DLLLOCAL ~MethodDef() {
        delete m;
    }

    DLLLOCAL void parseAddToClassAndDel() {
        if (m) {
            // if there are any errors, the function below will delete memory
            // the following method takes ownership of "m" unconditionally
            qore_root_ns_private::parseAddMethodToClass(loc, name, m, static_flag);
            m = 0;
        }
        delete this;
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        // the following method takes ownership of "m" unconditionally
        ns.parseAddMethodToClass(loc, name, m, static_flag);
        m = 0;
    }
};

static QoreValue parse_hash_map(const QoreProgramLocation* loc, QoreParseHashNode* exp, QoreParseListNode* l) {
    assert(l && (l->size() == 1 || l->size() == 2));
    ReferenceHolder<> exph(exp, nullptr);
    ReferenceHolder<> lh(l, nullptr);

    // check hash expression
    size_t len = exp->size();

    if (len == 0) {
        qore_program_private::makeParseWarning(getProgram(), *loc, QP_WARN_INVALID_OPERATION, "INVALID-OPERATION",
                "empty hash as an argument to the hash map operator, this expression will always evaluate to an empty hash");
        return new QoreHashNode(autoTypeInfo);
    }

    if (len != 1) {
        parse_error(*loc, "invalid initial argument to hash map operator, expected a single key value pair; got %d hash elements instead", len);
        return QoreValue();
    }

    if (l->size() == 1) {
        QoreValue iter = l->shift();
        return new QoreHashMapOperatorNode(loc, exp->takeFirstKey(), exp->takeFirstValue(), iter);
    }

    QoreValue iter = l->shift();
    QoreValue select = l->shift();
    return new QoreHashMapSelectOperatorNode(loc, exp->takeFirstKey(), exp->takeFirstValue(), iter, select);
}

static AbstractQoreNode* parse_map(const QoreProgramLocation* loc, QoreValue exp, QoreParseListNode* l) {
    assert(l && (l->size() == 1 || l->size() == 2));
    ReferenceHolder<> lh(l, 0);

    if (l->size() == 1) {
        QoreValue arg = l->shift();
        return new QoreMapOperatorNode(loc, exp, arg);
    }

    QoreValue iterator_exp = l->shift();
    QoreValue select_exp = l->shift();
    return new QoreMapSelectOperatorNode(loc, exp, iterator_exp, select_exp);
}

#define NSN_NONE     0
#define NSN_OCD      1
#define NSN_HASHDECL 2
#define NSN_CONST    3
#define NSN_NS       4
#define NSN_FUNC     5
#define NSN_SFUNC    6
#define NSN_VAR      7
#define NSN_METH     8

struct NSNode {
    int type;
    union {
        ObjClassDef* ocd;
        HashDeclDef* hashdecl;
        ConstNode* cn;
        QoreNamespace* ns;
        ParseUserFunction* func;
        ParseScopedUserFunction* sfunc;
        GVarDecl* gv;
        MethodDef* meth;
    } n;

    DLLLOCAL NSNode(ObjClassDef* o) { type = NSN_OCD; n.ocd = o; }
    DLLLOCAL NSNode(HashDeclDef* h) { type = NSN_HASHDECL; n.hashdecl = h; }
    DLLLOCAL NSNode(ConstNode* c) { type = NSN_CONST; n.cn = c; }
    DLLLOCAL NSNode(QoreNamespace* s) { type = NSN_NS; n.ns = s; }
    DLLLOCAL NSNode(ParseUserFunction* f) : type(NSN_FUNC) {
        n.func = f;
    }
    DLLLOCAL NSNode(ParseScopedUserFunction* f) : type(NSN_SFUNC) {
        n.sfunc = f;
    }

    DLLLOCAL NSNode(GVarDecl* gv) : type(NSN_VAR) {
        n.gv = gv;
    }

    DLLLOCAL NSNode(MethodDef* m) : type(NSN_METH) {
        n.meth = m;
    }

    DLLLOCAL void deref() {
        switch (type) {
            case NSN_OCD:
                delete n.ocd;
                break;
            case NSN_HASHDECL:
                delete n.hashdecl;
                break;
            case NSN_CONST:
                delete n.cn;
                break;
            case NSN_NS:
                delete n.ns;
                break;
            case NSN_FUNC:
                delete n.func;
                break;
            case NSN_SFUNC:
                delete n.sfunc;
                break;
            case NSN_VAR:
                delete n.gv;
                break;
            case NSN_METH:
                delete n.meth;
                break;
            default:
                assert(false);
                // no break
        }
        delete this;
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        switch (type) {
            case NSN_OCD:
                //printd(5, "ocd: %s %d-%d c: %d-%d\n", n.ocd->oc->getName(), n.ocd->loc.start_line, n.ocd->loc.end_line, qore_class_private::get(*n.ocd->oc)->loc.start_line, qore_class_private::get(*n.ocd->oc)->loc.end_line);
                ns.parseAddPendingClass(n.ocd->loc, *(n.ocd->name), n.ocd->oc);
                delete n.ocd;
                break;
            case NSN_HASHDECL:
                ns.parseAddPendingHashDecl(n.hashdecl->loc, *(n.hashdecl->name), n.hashdecl->takeHashDecl());
                delete n.hashdecl;
                break;
            case NSN_CONST:
                ns.parseAddConstant(n.cn->loc, n.cn->name, n.cn->value, n.cn->pub);
                delete n.cn;
                break;
            case NSN_NS:
                ns.parseAddNamespace(n.ns);
                break;
            case NSN_FUNC:
                n.func->add(ns);
                break;
            case NSN_SFUNC:
                n.sfunc->add(ns);
                break;
            case NSN_VAR:
                n.gv->add(ns);
                break;
            case NSN_METH:
                n.meth->add(ns);
                delete n.meth;
                break;
            default:
                assert(false);
                // no break
        }
        delete this;
    }
};

typedef std::vector<NSNode*>nsnode_list_t;

struct NSNodeList : public nsnode_list_t {
    DLLLOCAL void deref() {
        for (nsnode_list_t::iterator i = begin(), e = end(); i != e; ++i)
            (*i)->deref();

        delete this;
    }

    DLLLOCAL void add(qore_ns_private& ns) {
        for (nsnode_list_t::iterator i = begin(), e = end(); i != e; ++i)
            (*i)->add(ns);
    }
};

static QoreParseListNode* splice_expressions(QoreValue a1, QoreValue a2, const QoreProgramLocation* loc1,
        const QoreProgramLocation* loc2) {
    //tracein("splice_expressions()");
    if (a1.getType() == NT_PARSE_LIST) {
        QoreParseListNode* l = a1.get<QoreParseListNode>();
        if (!l->isFinalized()) {
            //printd(5, "LIST x\n");
            l->add(a2, loc2);
            return l;
        }
    }
    QoreParseListNode* l = new QoreParseListNode(qore_program_private::get(*getProgram())->getLocation(*loc1,
        loc2->start_line, loc2->end_line));
    l->add(a1, loc1);
    l->add(a2, loc2);
    return l;
}

typedef std::pair<char*, QoreMemberInfo*> member_pair_t;
typedef std::pair<char*, QoreVarInfo*> var_pair_t;
typedef std::pair<char*, HashDeclMemberInfo*> hashmem_pair_t;

#define MI_Member 0
#define MI_Constant 1
#define MI_Var 2
#define MI_HashMem 3

struct MemberInfo {
protected:
    DLLLOCAL MemberInfo(const QoreProgramLocation* loc) : loc(loc) {
    }

public:
    const QoreProgramLocation* loc;
    char* name;
    unsigned char type;
    union {
        QoreMemberInfo* memberInfo;
        QoreVarInfo* varInfo;
        HashDeclMemberInfo* hashMemberInfo;
        QoreSimpleValue exp;
    } u;

    DLLLOCAL MemberInfo(char* n, QoreMemberInfo* mi) : loc(mi->loc), name(n), type(MI_Member) {
        u.memberInfo = mi;
        if (!(mi && mi->parseHasTypeInfo()) && parse_check_parse_option(PO_REQUIRE_TYPES))
            parse_error(*mi->loc, "member '%s' declared without type information, but parse options require type information for all declarations", name);
    }

    DLLLOCAL MemberInfo(const QoreProgramLocation* loc, char* n, QoreValue exp) : loc(loc), name(n), type(MI_Constant) {
        u.exp = exp;
    }

    DLLLOCAL MemberInfo(char* n, HashDeclMemberInfo* mi) : loc(mi->loc), name(n), type(MI_HashMem) {
        u.hashMemberInfo = mi;
    }

    DLLLOCAL ~MemberInfo() {
        if (name)
            free(name);
        switch (type) {
            case MI_Member:
                delete u.memberInfo;
                break;
            case MI_Var:
                delete u.varInfo;
                break;
            case MI_HashMem:
                delete u.hashMemberInfo;
                break;
            case MI_Constant:
                u.exp.discard(nullptr);
                break;
        }
    }

    DLLLOCAL member_pair_t getPair() {
        assert(type == MI_Member);
        member_pair_t m = std::make_pair(name, u.memberInfo);
        name = nullptr;
        u.memberInfo = nullptr;
        return m;
    }

    DLLLOCAL var_pair_t getVarPair() {
        assert(type == MI_Var);
        var_pair_t m = std::make_pair(name, u.varInfo);
        name = nullptr;
        u.varInfo = nullptr;
        return m;
    }

    DLLLOCAL hashmem_pair_t getHashMemPair() {
        assert(type == MI_HashMem);
        hashmem_pair_t m = std::make_pair(name, u.hashMemberInfo);
        name = nullptr;
        u.hashMemberInfo = nullptr;
        return m;
    }

    DLLLOCAL QoreValue takeExp() {
        assert(type == MI_Constant);
        QoreValue rv = u.exp;
        u.exp.clear();
        return rv;
    }

    DLLLOCAL void setTransient() {
        assert(type == MI_Member);
        u.memberInfo->setTransient();
    }
};

struct ClassVarInfo : public MemberInfo {
    DLLLOCAL ClassVarInfo(char* n, QoreVarInfo* vi) : MemberInfo(vi->loc) {
        name = n;
        type = MI_Var;
        u.varInfo = vi;
        if (!(vi && vi->parseHasTypeInfo()) && parse_check_parse_option(PO_REQUIRE_TYPES))
            parse_error(*vi->loc, "class static variable '%s' declared without type information, but parse options require type information for all declarations", name);
    }

    DLLLOCAL char* takeName() {
        char* n = name;
        name = nullptr;
        return n;
    }
};

class MemberList {
protected:
    // for new class members
    QoreMemberMap mmap;
    // for new class constants
    ConstantList cmap;
    // for new class static variables
    QoreVarMap vmap;

    DLLLOCAL MemberList() : cmap((qore_class_private*)0) {
    }

public:
    DLLLOCAL MemberList(MemberInfo* member) : cmap((qore_class_private*)0) {
        if (!member)
            return;

        if (member->type == MI_Member)
            mmap.addNoCheck(member->getPair());
        else if (member->type == MI_Constant)
            cmap.parseAdd(member->loc, member->name, member->takeExp());
        else
            vmap.addNoCheck(member->getVarPair());

        delete member;
    }

    DLLLOCAL ~MemberList() {
    }

    // takes over ownership of name and typeInfo
    DLLLOCAL int add(MemberInfo* member) {
        if (!member)
            return -1;

        if (member->type == MI_Member) {
            if (mmap.inList(member->name)) {
                parse_error(*member->loc, "duplicate member declaration '%s'", member->name);
                delete member;
                return -1;
            }

            // add new member to list
            mmap.addNoCheck(member->getPair());
            delete member;
        } else if (member->type == MI_Constant) {
            if (cmap.inList(member->name)) {
                parse_error(*member->loc, "duplicate constant declaration '%s'", member->name);
                delete member;
                return -1;
            }
            if (vmap.find(member->name)) {
                parse_error(*member->loc, "constant declaration collides with static class variable declaration '%s'", member->name);
                delete member;
                return -1;
            }

            // add new constant to list
            cmap.parseAdd(member->loc, member->name, member->takeExp());
            delete member;
        } else {
            assert(member->type == MI_Var);
            if (vmap.find(member->name)) {
                parse_error(*member->loc, "duplicate static class variable declaration '%s'", member->name);
                delete member;
                return -1;
            }
            if (cmap.inList(member->name)) {
                parse_error(*member->loc, "static class variable declaration collides with constant declaration '%s'", member->name);
                delete member;
                return -1;
            }

            // add new member to list
            vmap.addNoCheck(member->getVarPair());
            delete member;
        }

        return 0;
    }

    DLLLOCAL void merge(QoreClass* qc, ClassAccess access) {
        mmap.moveAllTo(qc, access);
        vmap.moveAllTo(qc, access);

        // merge constants
        qore_class_private::get(*qc)->parseAssimilateConstants(cmap, access);
    }
};

class EmptyMemberList : public MemberList {
public:
   DLLLOCAL EmptyMemberList() {
   }
};

struct ParserTypeStruct {
protected:
    DLLLOCAL ParserTypeStruct() {
    }

public:
    const QoreTypeInfo* typeInfo = nullptr;
    QoreParseTypeInfo* parseTypeInfo = nullptr;

    DLLLOCAL ParserTypeStruct(QoreParseTypeInfo* n_parseTypeInfo) : parseTypeInfo(n_parseTypeInfo) {
    }

    DLLLOCAL ParserTypeStruct(char* id, bool or_nothing) : typeInfo(or_nothing ? getBuiltinUserOrNothingTypeInfo(id) : getBuiltinUserTypeInfo(id)) {
        //printd(0, "ParserTypeStruct::ParserTypeStruct('%s', %d) t: %p %s\n", id, or_nothing, typeInfo, QoreTypeInfo::getName(typeInfo));
        if (typeInfo) {
            free(id);
            return;
        }

        parseTypeInfo = new QoreParseTypeInfo(id, or_nothing);
    }

    DLLLOCAL ~ParserTypeStruct() {
        delete parseTypeInfo;
    }

    DLLLOCAL const QoreTypeInfo* getTypeInfo() const {
        return typeInfo;
    }

    // static version of method, checking for null pointer
    DLLLOCAL static const QoreTypeInfo* getTypeInfo(ParserTypeStruct* pts) {
        return pts ? pts->getTypeInfo() : nullptr;
    }

    DLLLOCAL QoreParseTypeInfo* getParseTypeInfo() {
        QoreParseTypeInfo* rv = parseTypeInfo;
        parseTypeInfo = nullptr;
        return rv;
    }

    // static version of method, checking for null pointer
    DLLLOCAL static QoreParseTypeInfo* getParseTypeInfo(ParserTypeStruct* pts) {
        return pts ? pts->getParseTypeInfo() : nullptr;
    }

    DLLLOCAL const char* getClassName() {
        assert(parseTypeInfo);
        return parseTypeInfo->cscope->ostr;
    }

    DLLLOCAL static ParserTypeStruct* getType(const QoreProgramLocation* loc, char* id, bool or_nothing) {
        return new ParserTypeStruct(getParseType(loc, id, or_nothing));
    }

    DLLLOCAL static void getSubTypes(const QoreProgramLocation* loc, const char* str, parse_type_vec_t& subtypes, bool raise_error = true) {
        QoreString buf;
        bool or_nothing = false;
        bool comma = false;

        const char* p = str;
        while (true) {
            if (*p == '\0') {
                if (buf.empty()) {
                    if (comma && raise_error)
                        parse_error(*loc, "empty subtype specification in type");
                }
                else
                    subtypes.push_back(getParseType(loc, buf.giveBuffer(), or_nothing));
                break;
            }
            switch (*p) {
                case '<': {
                    if (buf.empty()) {
                        if (raise_error)
                            parse_error(*loc, "invalid subtype specification in '%s'", str);
                        return;
                    }
                    const char* e = strrchr(str, '>');
                    if (!e || e < p) {
                        if (raise_error)
                            parse_error(*loc, "unbalanced angle brackets in subtype specification in '%s'", str);
                        return;
                    }
                    buf.concat(p, e - p + 1);
                    //printd(5, "ST: '%s' (str: '%s') p: %p '%s'\n", buf.c_str(), str, p, p);
                    subtypes.push_back(getParseType(loc, buf.giveBuffer(), or_nothing));
                    buf.reset();
                    or_nothing = false;
                    //printd(5, "ST: p: %p -> %p\n", p, e);
                    p = e;
                    break;
                }
                case ',':
                    buf.trim();
                    if (buf.empty()) {
                        if (raise_error)
                            parse_error(*loc, "invalid subtype specification in '%s'", str);
                        return;
                    }
                    subtypes.push_back(getParseType(loc, buf.giveBuffer(), or_nothing, raise_error));
                    buf.reset();
                    or_nothing = false;
                    comma = true;
                break;
                case '*': {
                    if (buf.empty())
                        or_nothing = true;
                    else
                        buf.concat('*');
                    if (comma)
                        comma = false;
                    break;
                }
                case ' ':
                case '\t':
                    if (!buf.empty())
                        buf.concat(*p);
                    break;
                default:
                    buf.concat(*p);
                    if (comma)
                        comma = false;
                break;
            }
            ++p;
        }
    }

    DLLLOCAL static QoreParseTypeInfo* getParseType(const QoreProgramLocation* loc, char* id, bool or_nothing, bool raise_error = true) {
        //printd(0, "gPT() '%s'\n", id);
        char* p0 = strchr(id, '<');
        if (p0) {
            char* p1 = strrchr(id, '>');
            if (p1 > (p0 + 1)) {
                // terminate main type string
                *p0 = '\0';
                // terminate type args
                *p1 = '\0';

                parse_type_vec_t subtypes;
                getSubTypes(loc, p0 + 1, subtypes, raise_error);
                return new QoreParseTypeInfo(id, or_nothing, std::move(subtypes));
            }
        }
        return new QoreParseTypeInfo(id, or_nothing);
    }

    DLLLOCAL static const QoreTypeInfo* getRuntimeType(const char* str) {
        assert(str);
        assert(str[0]);
        char* p;
        bool or_nothing;
        if (str[0] == '*') {
            or_nothing = true;
            p = strdup(str + 1);
        } else {
            or_nothing = false;
            p = strdup(str);
        }
        std::unique_ptr<QoreParseTypeInfo> pt(ParserTypeStruct::getParseType(&loc_builtin, p, or_nothing, false));
        return QoreParseTypeInfo::resolveRuntime(pt.get());
    }
};

const QoreTypeInfo* qore_get_type_from_string_intern(const char* str) {
    // issue #3318: does not use ProgramRuntimeParseAccessHelper as it is normally not needed, if this is
    // necessary, then the call to this function must be wrapped using this class
    return ParserTypeStruct::getRuntimeType(str);
}

static AbstractQoreNode* process_dot(int sline, int eline, QoreValue l, QoreValue r) {
    qore_type_t rtype = r.getType();
    const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation(sline, eline);
    switch (rtype) {
        case NT_BAREWORD: {
            BarewordNode* b = r.get<BarewordNode>();
            if (!b->isFinalized()) {
                AbstractQoreNode* rv = new QoreHashObjectDereferenceOperatorNode(loc, l, b->makeQoreStringNode());
                b->deref();
                return rv;
            }
            break;
        }

        case NT_FUNCTION_CALL: {
            FunctionCallNode* f = r.get<FunctionCallNode>();
            assert(!f->getFunction());
            if (!f->isFinalized()) {
                MethodCallNode* m = new MethodCallNode(loc, f->takeName(), f->takeParseArgs());
                f->deref();

                return new QoreDotEvalOperatorNode(loc, l, m);
            }
            break;
        }
    }

    return new QoreHashObjectDereferenceOperatorNode(loc, l, r);
}

static int check_strong_encapsulation(const QoreProgramLocation* loc, const char* type, const char* name) {
    if (parse_check_parse_option(PO_STRONG_ENCAPSULATION)) {
        parse_error(*loc, "illegal out of line %s definition \"%s\" (conflicts with parse option PO_STRONG_ENCAPSULATION)", type, name);
        return -1;
    }
    return 0;
}

static int check_case(const QoreProgramLocation* loc, const char* op, QoreValue exp) {
    // ignore if NULL (= NOTHING)
    if (exp.hasEffect()) {
        if (op)
            parse_error(*loc, "case expression with '%s' needs run-time evaluation", op);
        else
            parse_error(*loc, "case expression needs run-time evaluation", op);
        return -1;
    }
    return 0;
}

static void check_funcmod(const QoreProgramLocation* loc, int mod) {
    if (mod & (OFM_PRIVATE|OFM_INTERNAL))
        parse_error(*loc, "illegal 'private' modifier in function declaration");
    if (mod & OFM_STATIC)
        parse_error(*loc, "illegal 'static' modifier in function declaration");
    if (mod & OFM_FINAL)
        parse_error(*loc, "illegal 'final' modifier in function declaration");
    if (mod & OFM_ABSTRACT)
        parse_error(*loc, "illegal 'abstract' modifier in function declaration");
}

static void check_classmod(const QoreProgramLocation* loc, int mod, QoreClass& qc) {
   if (mod & (OFM_PRIVATE|OFM_INTERNAL))
      parse_error(*loc, "illegal 'private' modifier in class declaration");
   if (mod & OFM_SYNCED)
      parse_error(*loc, "illegal 'synchronized' modifier in class declaration");
   if (mod & OFM_STATIC)
      parse_error(*loc, "illegal 'static' modifier in class declaration");
   if (mod & OFM_PUBLIC)
      qore_class_private::setPublic(qc);
   if (mod & OFM_DEPRECATED)
      parse_error(*loc, "illegal 'deprecated' modifier in class declaration");
   if (mod & OFM_FINAL)
      qore_class_private::setFinal(qc);
   if (mod & OFM_ABSTRACT)
      parse_error(*loc, "illegal 'abstract' modifier in class declaration");
}

static void check_hashdeclmod(const QoreProgramLocation* loc, int mod, typed_hash_decl_private& hashdecl) {
   if (mod & (OFM_PRIVATE|OFM_INTERNAL))
      parse_error(*loc, "illegal 'private' modifier in hashdecl");
   if (mod & OFM_SYNCED)
      parse_error(*loc, "illegal 'synchronized' modifier in hashdecl");
   if (mod & OFM_STATIC)
      parse_error(*loc, "illegal 'static' modifier in hashdecl");
   if (mod & OFM_PUBLIC)
      hashdecl.setPublic();
   if (mod & OFM_DEPRECATED)
      parse_error(*loc, "illegal 'deprecated' modifier in hashdecl");
   if (mod & OFM_FINAL)
      parse_error(*loc, "illegal 'final' modifier in hashdecl");
   if (mod & OFM_ABSTRACT)
      parse_error(*loc, "illegal 'abstract' modifier in hashdecl");
}

static void check_nsmod(const QoreProgramLocation* loc, int mod, qore_ns_private& ns) {
   if (mod & (OFM_PRIVATE|OFM_INTERNAL))
      parse_error(*loc, "illegal 'private' modifier in namespace declaration");
   if (mod & OFM_SYNCED)
      parse_error(*loc, "illegal 'synchronized' modifier in namespace declaration");
   if (mod & OFM_STATIC)
      parse_error(*loc, "illegal 'static' modifier in namespace declaration");
   if (mod & OFM_PUBLIC)
      ns.setPublic();
   if (mod & OFM_DEPRECATED)
      parse_error(*loc, "illegal 'deprecated' modifier in namespace declaration");
   if (mod & OFM_FINAL)
      parse_error(*loc, "illegal 'final' modifier in namespace declaration");
   if (mod & OFM_ABSTRACT)
      parse_error(*loc, "illegal 'abstract' modifier in namespace declaration");
}

bool node_has_effect(const AbstractQoreNode* n) {
    if (!n || n->is_value())
        return false;

    if (n->getType() == NT_OPERATOR)
        return reinterpret_cast<const QoreOperatorNode*>(n)->hasEffect();

    const ParseNode* pn = dynamic_cast<const ParseNode*>(n);
    // if pn is a function node it's effect actually cannot be evaluated
    // at this moment because the function flags have not yet been set
    // and so has_effect() always returns 'true'
    return pn ? pn->has_effect() : true;
}

bool node_has_effect_as_root(const AbstractQoreNode* n) {
    if (!n || n->is_value())
        return false;

    if (n->getType() == NT_OPERATOR)
        return reinterpret_cast<const QoreOperatorNode*>(n)->hasEffectAsRoot();

    const ParseNode* pn = dynamic_cast<const ParseNode*>(n);
    // the same comment as in the above function node_has_effect() applies also here
    return pn ? pn->has_effect_as_root() : true;
}

bool value_has_effect_as_root(const QoreValue& n) {
    return node_has_effect_as_root(n.getInternalNode());
}

struct MethodNode {
public:
   // name of method
   char* name;
   // method variant to add to class
   MethodVariantBase *m;
   // static flag
   bool static_flag;

   DLLLOCAL MethodNode(char* mname, MethodVariantBase *v, bool n_static) : name(mname), m(v), static_flag(n_static) {
   }

   DLLLOCAL ~MethodNode() {
      free(name);
      delete m;
   }

   DLLLOCAL void addAndDelete(QoreClass* qc) {
      qore_class_private::addUserMethod(*qc, name, m, static_flag);
      m = 0;
      delete this;
   }

   DLLLOCAL const QoreProgramLocation* getLoc() const {
      return m->getUserVariantBase()->getUserSignature()->getParseLocation();
   }
};

static QoreValue is_rewritable_op(QoreValue n) {
    qore_type_t nt = n.getType();
    if (nt == NT_OPERATOR) {
        QoreBinaryLValueOperatorNode* op = dynamic_cast<QoreBinaryLValueOperatorNode*>(n.getInternalNode());
        if (op)
            return op->getRight();
    }

    return QoreValue();
}

static QoreValue check_rewrite_list(QoreParseListNode* l) {
    if (!parse_check_parse_option(PO_BROKEN_LIST_PARSING))
        return l;

    // rewrite expression if it's a list without parentheses and
    // the first expression has one of the following operators:
    // =, +=, -=
    if (l->isFinalized())
        return l;

    QoreValue e0 = l->get(0);

    QoreValue r = is_rewritable_op(e0);
    if (!r.isNothing()) {
        QoreValue last = e0;
        QoreValue top = e0;
        while (true) {
            QoreValue nr = is_rewritable_op(r);
            if (nr.isNothing()) {
                break;
            }
            last = r;
            r = nr;
        }
        assert(dynamic_cast<QoreBinaryLValueOperatorNode*>(last.getInternalNode()));
        // take first element from list (the tree) and make it the new expression
        QoreBinaryLValueOperatorNode* op = last.get<QoreBinaryLValueOperatorNode>();
        l->swap(0, op->swapRight(l));
        return top;
    }

    return l;
}

// cannot be static
void ignore_return_value(QoreSimpleValue& n) {
    qore_type_t t = n.getType();
    if (t == NT_OPERATOR) {
        n.get<QoreOperatorNode>()->ignoreReturnValue();
    }
}

static qore_var_t get_var_type() {
   return parse_check_parse_option(PO_ASSUME_LOCAL) ? VT_LOCAL : VT_UNRESOLVED;
}

static QoreOperatorNode* process_assignment(int sline, int eline, QoreValue $1, QoreValue $3) {
    const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation(sline, eline);
    return ($1.getType() == NT_PARSE_LIST)
        ? static_cast<QoreOperatorNode*>(new QoreListAssignmentOperatorNode(loc, $1, $3))
        : static_cast<QoreOperatorNode*>(new QoreAssignmentOperatorNode(loc, $1, $3));
}

static QoreOperatorNode* process_weak_assignment(const QoreProgramLocation* loc, QoreValue $1, QoreValue $3) {
   if ($1.getType() == NT_LIST) {
       parse_error(*loc, "the ':=' operator is not valid with list assignments");
       return static_cast<QoreOperatorNode*>(new QoreAssignmentOperatorNode(loc, $1, $3));
   }
   return static_cast<QoreOperatorNode*>(new QoreWeakAssignmentOperatorNode(loc, $1, $3));
}

static AbstractQoreNode* processCall(int sline, int eline, QoreValue $1, QoreValue $3, const QoreProgramLocation* argloc) {
    AbstractQoreNode* $$;
    const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation(sline, eline);

    //printd(5, "1: %s, 3: %s\n", $1.getTypeName(), $3.getTypeName());
    qore_type_t t = $1.getType();
    if (t == NT_BAREWORD) {
        BarewordNode* b = $1.get<BarewordNode>();
        // take string from node and delete node
        char* str = b->takeString();
        b->deref();
        printd(5, "parsing call %s() args: %s\n", str, $3.getTypeName());
        $$ = new FunctionCallNode(loc, str, make_args(argloc, $3));
    } else if (t == NT_CONSTANT) {
        ScopedRefNode* c = $1.get<ScopedRefNode>();
        // take NamedScope from node and delete node
        NamedScope *ns = c->takeName();
        c->deref();
        assert(ns->size() > 1);
        printd(5, "parsing scoped call (static method, new object call, or program function call) %s()\n", ns->ostr);
        $$ = new StaticMethodCallNode(loc, ns, make_args(argloc, $3));
    } else if (t == NT_SELF_VARREF) {
        SelfVarrefNode* v = $1.get<SelfVarrefNode>();
        // take string from node and delete node
        char* str = v->takeString();
        v->deref();
        //printd(5, "parsing in-object method call %s()\n", str);
        $$ = new SelfFunctionCallNode(loc, str, make_args(argloc, $3));
    } else {
        QoreHashObjectDereferenceOperatorNode* hodon;

        if (t == NT_OPERATOR) {
            hodon = dynamic_cast<QoreHashObjectDereferenceOperatorNode*>($1.getInternalNode());
            if (hodon) {
                QoreValue r = hodon->getRight();
                if (r.getType() != NT_STRING)
                    hodon = nullptr;
            }
        } else
            hodon = nullptr;

        if (hodon) {
            // create an object method call node
            // take the string
            QoreStringNode* str = hodon->swapRight(QoreValue()).get<QoreStringNode>();
            assert(str->getEncoding() == QCS_DEFAULT);
            char* cstr = str->giveBuffer();
            assert(cstr);
            str->deref();

            MethodCallNode* mc = new MethodCallNode(loc, cstr, make_args(argloc, $3));

            // destroy the original operator and create a new operator object
            assert(hodon->is_unique());
            QoreValue l = hodon->swapLeft(QoreValue());
            hodon->deref(nullptr);

            $$ = new QoreDotEvalOperatorNode(loc, l, mc);
        } else {
            $$ = nullptr;
            if ($1.getType() == NT_VARREF) {
                VarRefNode* r = $1.get<VarRefNode>();
                qore_var_t vartype = r->getType();

                if (vartype != VT_UNRESOLVED) {
                    $$ = r->makeNewCall($3);
                    //printd(5, "makeNewCall(%p) returned %p (%s)\n", $3, $$, get_type_name($$));
                    if (!$$) {
                        parseException(*loc, "INVALID-CODE-REFERENCE-CALL", "%s variable '%s' declared as a function reference call", r->getType() == VT_GLOBAL ? "global" : "local", r->getName());
                    }
                }
            }
            if (!$$) {
                $$ = new CallReferenceCallNode(loc, $1, make_args(argloc, $3));
                printd(5, "made new CallReferenceCallNode: %p exp: %s\n", $$, $1.getTypeName());
            }
        }
    }
    return $$;
}

static void check_operator(const QoreProgramLocation* loc, const QoreOperatorNode* n, const char* parent, const char* child) {
    if (parse_check_parse_option(PO_BROKEN_LOGIC_PRECEDENCE)) {
        if (!n->getInParentheses()) {
            qore_program_private::makeParseWarning(getProgram(), *loc, QP_WARN_BROKEN_LOGIC_PRECEDENCE, "BROKEN-LOGIC-PRECEDENCE", "%s gets under %s in the parse tree as an impact of broken-logic-precedence flag being set - please consider using parenthesis to enforce the desired operator precedence", child, parent);
        }
    }
}

static void check_operator_log_or(const QoreProgramLocation* loc, QoreValue n, const char* parent) {
    if (dynamic_cast<const QoreLogicalOrOperatorNode*>(n.getInternalNode())) {
        check_operator(loc, static_cast<const QoreOperatorNode*>(n.getInternalNode()), parent, "logical OR");
    }
}

static void check_operator_bin_or(const QoreProgramLocation* loc, QoreValue n, const char* parent) {
    if (dynamic_cast<const QoreBinaryOrOperatorNode*>(n.getInternalNode())) {
        check_operator(loc, static_cast<const QoreOperatorNode*>(n.getInternalNode()), parent, "binary OR");
    }
}

static void check_operator_bin_xor(const QoreProgramLocation* loc, QoreValue n, const char* parent) {
    if (dynamic_cast<const QoreBinaryXorOperatorNode*>(n.getInternalNode())) {
        check_operator(loc, static_cast<const QoreOperatorNode*>(n.getInternalNode()), parent, "binary XOR");
    }
}


#line 1601 "parser.cpp"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_YY_PARSER_HPP_INCLUDED
# define YY_YY_PARSER_HPP_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    YYEOF = 0,                     /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    TOK_RETURN = 258,              /* "return"  */
    TOK_RETURNS = 259,             /* "returns"  */
    TOK_THREAD_LOCAL = 260,        /* "thread_local"  */
    TOK_MY = 261,                  /* "my"  */
    TOK_DO = 262,                  /* "do"  */
    TOK_TRY = 263,                 /* "try"  */
    TOK_THROW = 264,               /* "throw"  */
    TOK_CATCH = 265,               /* "catch"  */
    TOK_WHERE = 266,               /* "where"  */
    TOK_WHILE = 267,               /* "while"  */
    TOK_IF = 268,                  /* "if"  */
    TOK_FOR = 269,                 /* "for"  */
    TOK_SUB = 270,                 /* "sub"  */
    TOK_THREAD_EXIT = 271,         /* "thread_exit"  */
    TOK_BREAK = 272,               /* "break"  */
    TOK_CONTINUE = 273,            /* "continue"  */
    TOK_CONTEXT_ROW = 274,         /* "%%"  */
    TOK_FIND = 275,                /* "find"  */
    TOK_FOREACH = 276,             /* "foreach"  */
    TOK_IN = 277,                  /* "in"  */
    TOK_DELETE = 278,              /* "delete"  */
    TOK_REMOVE = 279,              /* "remove"  */
    TOK_PRIVATE = 280,             /* "private"  */
    TOK_PRIVATEINTERNAL = 281,     /* "private:internal"  */
    TOK_PRIVATEHIERARCHY = 282,    /* "private:hierarchy"  */
    TOK_PUBLIC = 283,              /* "public"  */
    TOK_SYNCHRONIZED = 284,        /* "synchronized"  */
    TOK_DEPRECATED = 285,          /* "deprecated"  */
    TOK_CONTEXT = 286,             /* "context"  */
    TOK_SORT_BY = 287,             /* "sortBy"  */
    TOK_SORT_DESCENDING_BY = 288,  /* "sortDescendingBy"  */
    TOK_SUB_CONTEXT = 289,         /* "subcontext"  */
    TOK_CONST = 290,               /* "const"  */
    TOK_SUMMARIZE = 291,           /* "summarize"  */
    TOK_BY = 292,                  /* "by"  */
    TOK_OUR = 293,                 /* "our"  */
    TOK_RETHROW = 294,             /* "rethrow"  */
    TOK_SWITCH = 295,              /* "switch"  */
    TOK_CASE = 296,                /* "case"  */
    TOK_DEFAULT = 297,             /* "default"  */
    TOK_INHERITS = 298,            /* "inherits"  */
    TOK_ELSE = 299,                /* "else"  */
    TOK_STATIC = 300,              /* "static"  */
    TOK_NAMESPACE = 301,           /* "namespace"  */
    TOK_MODULE = 302,              /* "module"  */
    TOK_FINAL = 303,               /* "final"  */
    TOK_ABSTRACT = 304,            /* "abstract"  */
    TOK_HASHDECL = 305,            /* "hashdecl"  */
    TOK_TRANSIENT = 306,           /* "transient"  */
    TOK_NULL = 307,                /* "NULL"  */
    TOK_NOTHING = 308,             /* "NOTHING"  */
    TOK_TRUE = 309,                /* "True"  */
    TOK_FALSE = 310,               /* "False"  */
    TOK_UNREFERENCE = 311,         /* "unreference"  */
    P_INCREMENT = 312,             /* "++ operator"  */
    P_DECREMENT = 313,             /* "-- operator"  */
    PLUS_EQUALS = 314,             /* "+= operator"  */
    MINUS_EQUALS = 315,            /* "-= operator"  */
    AND_EQUALS = 316,              /* "&= operator"  */
    OR_EQUALS = 317,               /* "|= operator"  */
    MODULA_EQUALS = 318,           /* "%= operator"  */
    MULTIPLY_EQUALS = 319,         /* "*= operator"  */
    DIVIDE_EQUALS = 320,           /* "/= operator"  */
    XOR_EQUALS = 321,              /* "^= operator"  */
    SHIFT_LEFT_EQUALS = 322,       /* "<<= operator"  */
    SHIFT_RIGHT_EQUALS = 323,      /* ">>= operator"  */
    TOK_UNSHIFT = 324,             /* "unshift"  */
    TOK_PUSH = 325,                /* "push"  */
    TOK_POP = 326,                 /* "pop"  */
    TOK_SHIFT = 327,               /* "shift"  */
    TOK_CHOMP = 328,               /* "chomp"  */
    TOK_TRIM = 329,                /* "trim"  */
    LOGICAL_AND = 330,             /* "&& operator"  */
    LOGICAL_OR = 331,              /* "|| operator"  */
    BROKEN_LOGICAL_OR = 332,       /* "|| operator (compat)"  */
    BROKEN_BINARY_OR = 333,        /* "| operator (compat)"  */
    BROKEN_BINARY_XOR = 334,       /* "^ operator (compat)"  */
    LOGICAL_EQ = 335,              /* "== operator"  */
    LOGICAL_NE = 336,              /* "!= operator"  */
    LOGICAL_LE = 337,              /* "<= operator"  */
    LOGICAL_GE = 338,              /* ">= operator"  */
    LOGICAL_CMP = 339,             /* "<=> operator"  */
    ABSOLUTE_EQ = 340,             /* "=== operator"  */
    ABSOLUTE_NE = 341,             /* "!== operator"  */
    REGEX_MATCH = 342,             /* "=~ operator"  */
    REGEX_NMATCH = 343,            /* "!~ operator"  */
    TOK_EXISTS = 344,              /* "exists"  */
    TOK_INSTANCEOF = 345,          /* "instanceof"  */
    SHIFT_RIGHT = 346,             /* ">> operator"  */
    SHIFT_LEFT = 347,              /* "<< operator"  */
    TOK_ELEMENTS = 348,            /* "elements"  */
    TOK_KEYS = 349,                /* "keys"  */
    TOK_NEW = 350,                 /* "new"  */
    TOK_BACKGROUND = 351,          /* "background"  */
    TOK_ON_EXIT = 352,             /* "on_exit"  */
    TOK_ON_SUCCESS = 353,          /* "on_success"  */
    TOK_ON_ERROR = 354,            /* "on_error"  */
    TOK_MAP = 355,                 /* "map"  */
    TOK_FOLDR = 356,               /* "foldr"  */
    TOK_FOLDL = 357,               /* "foldl"  */
    TOK_SELECT = 358,              /* "select"  */
    TOK_SPLICE = 359,              /* "splice"  */
    TOK_EXTRACT = 360,             /* "extract"  */
    IMPLICIT_ELEMENT = 361,        /* "$# operator"  */
    NULL_COALESCING = 362,         /* "?? operator"  */
    VALUE_COALESCING = 363,        /* "?* operator"  */
    WEAK_ASSIGNMENT = 364,         /* ":= operator"  */
    RANGE = 365,                   /* ".. operator"  */
    ELLIPSES = 366,                /* "... marker"  */
    INTEGER = 367,                 /* "integer value"  */
    QFLOAT = 368,                  /* "floating-point value"  */
    NUMBER = 369,                  /* "arbitrary-precision number"  */
    IDENTIFIER = 370,              /* "identifier"  */
    HASHDECL_IDENTIFIER_OPENCURLY = 371, /* "typed hash identifier"  */
    ANGLE_IDENTIFIER = 372,        /* "complex type identifier"  */
    VAR_REF = 373,                 /* "variable reference"  */
    BACKQUOTE = 374,               /* "backquote expression"  */
    SELF_REF = 375,                /* "in-object member reference"  */
    KW_IDENTIFIER_OPENPAREN = 376, /* "identifier or keyword used as function or method identifier"  */
    SCOPED_REF = 377,              /* "namespace or class-scoped reference"  */
    SCOPED_VREF = 378,             /* "namespace-scoped global variable reference"  */
    CONTEXT_REF = 379,             /* "context reference"  */
    COMPLEX_CONTEXT_REF = 380,     /* "named context reference"  */
    QORE_CAST = 381,               /* "cast operator"  */
    QORE_OR_NOTHING_CAST = 382,    /* "cast (or nothing) operator"  */
    CLASS_STRING = 383,            /* "simple class declaration"  */
    DATETIME = 384,                /* "date/time value"  */
    QUOTED_WORD = 385,             /* "quoted string"  */
    BINARY = 386,                  /* "binary constant value"  */
    REGEX_SUBST = 387,             /* "regular expression substitution expression"  */
    REGEX_TRANS = 388,             /* "transliteration expression"  */
    CLASS_SCOPED_REF = 389,        /* "scoped class declaration"  */
    BASE_CLASS_CALL = 390,         /* "call to base class method"  */
    REGEX = 391,                   /* "regular expression"  */
    REGEX_EXTRACT = 392,           /* "regular expression extraction expression"  */
    IMPLICIT_ARG_REF = 393,        /* "implicit argument reference"  */
    DOT_KW_IDENTIFIER = 394,       /* "keyword used as hash key or object member reference"  */
    TRY_MODULE_ERROR = 395,        /* "%try-module error token"  */
    IFX = 396,                     /* IFX  */
    NEG = 397,                     /* NEG  */
    UPLUS = 398                    /* UPLUS  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif
/* Token kinds.  */
#define YYEMPTY -2
#define YYEOF 0
#define YYerror 256
#define YYUNDEF 257
#define TOK_RETURN 258
#define TOK_RETURNS 259
#define TOK_THREAD_LOCAL 260
#define TOK_MY 261
#define TOK_DO 262
#define TOK_TRY 263
#define TOK_THROW 264
#define TOK_CATCH 265
#define TOK_WHERE 266
#define TOK_WHILE 267
#define TOK_IF 268
#define TOK_FOR 269
#define TOK_SUB 270
#define TOK_THREAD_EXIT 271
#define TOK_BREAK 272
#define TOK_CONTINUE 273
#define TOK_CONTEXT_ROW 274
#define TOK_FIND 275
#define TOK_FOREACH 276
#define TOK_IN 277
#define TOK_DELETE 278
#define TOK_REMOVE 279
#define TOK_PRIVATE 280
#define TOK_PRIVATEINTERNAL 281
#define TOK_PRIVATEHIERARCHY 282
#define TOK_PUBLIC 283
#define TOK_SYNCHRONIZED 284
#define TOK_DEPRECATED 285
#define TOK_CONTEXT 286
#define TOK_SORT_BY 287
#define TOK_SORT_DESCENDING_BY 288
#define TOK_SUB_CONTEXT 289
#define TOK_CONST 290
#define TOK_SUMMARIZE 291
#define TOK_BY 292
#define TOK_OUR 293
#define TOK_RETHROW 294
#define TOK_SWITCH 295
#define TOK_CASE 296
#define TOK_DEFAULT 297
#define TOK_INHERITS 298
#define TOK_ELSE 299
#define TOK_STATIC 300
#define TOK_NAMESPACE 301
#define TOK_MODULE 302
#define TOK_FINAL 303
#define TOK_ABSTRACT 304
#define TOK_HASHDECL 305
#define TOK_TRANSIENT 306
#define TOK_NULL 307
#define TOK_NOTHING 308
#define TOK_TRUE 309
#define TOK_FALSE 310
#define TOK_UNREFERENCE 311
#define P_INCREMENT 312
#define P_DECREMENT 313
#define PLUS_EQUALS 314
#define MINUS_EQUALS 315
#define AND_EQUALS 316
#define OR_EQUALS 317
#define MODULA_EQUALS 318
#define MULTIPLY_EQUALS 319
#define DIVIDE_EQUALS 320
#define XOR_EQUALS 321
#define SHIFT_LEFT_EQUALS 322
#define SHIFT_RIGHT_EQUALS 323
#define TOK_UNSHIFT 324
#define TOK_PUSH 325
#define TOK_POP 326
#define TOK_SHIFT 327
#define TOK_CHOMP 328
#define TOK_TRIM 329
#define LOGICAL_AND 330
#define LOGICAL_OR 331
#define BROKEN_LOGICAL_OR 332
#define BROKEN_BINARY_OR 333
#define BROKEN_BINARY_XOR 334
#define LOGICAL_EQ 335
#define LOGICAL_NE 336
#define LOGICAL_LE 337
#define LOGICAL_GE 338
#define LOGICAL_CMP 339
#define ABSOLUTE_EQ 340
#define ABSOLUTE_NE 341
#define REGEX_MATCH 342
#define REGEX_NMATCH 343
#define TOK_EXISTS 344
#define TOK_INSTANCEOF 345
#define SHIFT_RIGHT 346
#define SHIFT_LEFT 347
#define TOK_ELEMENTS 348
#define TOK_KEYS 349
#define TOK_NEW 350
#define TOK_BACKGROUND 351
#define TOK_ON_EXIT 352
#define TOK_ON_SUCCESS 353
#define TOK_ON_ERROR 354
#define TOK_MAP 355
#define TOK_FOLDR 356
#define TOK_FOLDL 357
#define TOK_SELECT 358
#define TOK_SPLICE 359
#define TOK_EXTRACT 360
#define IMPLICIT_ELEMENT 361
#define NULL_COALESCING 362
#define VALUE_COALESCING 363
#define WEAK_ASSIGNMENT 364
#define RANGE 365
#define ELLIPSES 366
#define INTEGER 367
#define QFLOAT 368
#define NUMBER 369
#define IDENTIFIER 370
#define HASHDECL_IDENTIFIER_OPENCURLY 371
#define ANGLE_IDENTIFIER 372
#define VAR_REF 373
#define BACKQUOTE 374
#define SELF_REF 375
#define KW_IDENTIFIER_OPENPAREN 376
#define SCOPED_REF 377
#define SCOPED_VREF 378
#define CONTEXT_REF 379
#define COMPLEX_CONTEXT_REF 380
#define QORE_CAST 381
#define QORE_OR_NOTHING_CAST 382
#define CLASS_STRING 383
#define DATETIME 384
#define QUOTED_WORD 385
#define BINARY 386
#define REGEX_SUBST 387
#define REGEX_TRANS 388
#define CLASS_SCOPED_REF 389
#define BASE_CLASS_CALL 390
#define REGEX 391
#define REGEX_EXTRACT 392
#define IMPLICIT_ARG_REF 393
#define DOT_KW_IDENTIFIER 394
#define TRY_MODULE_ERROR 395
#define IFX 396
#define NEG 397
#define UPLUS 398

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
union YYSTYPE
{
#line 1541 "parser.ypp"

    QoreSimpleValue qv;
    bool b;
    int i4;
    int64 integer;
    double decimal;
    QoreStringNode* String;
    char* string;
    BinaryNode* binary;
    AbstractQoreNode* node;
    QoreParseHashNode* hash;
    QoreParseListNode* parse_list;
    AbstractStatement* statement;
    struct MemberInfo* memberinfo;
    struct ClassVarInfo* classvarinfo;
    StatementBlock *sblock;
    ContextModList* cmods;
    ContextMod *cmod;
    class HashElement* hashelement;
    QoreFunction* userfunc;
    struct MethodNode* methodnode;
    class MemberList* memberlist;
    QoreClass* qoreclass;
    typed_hash_decl_private* hashdeclpriv;
    class ConstNode* constnode;
    QoreNamespace *ns;
    struct NSNodeList* nsnlist;
    struct NSNode* nsn;
    class ObjClassDef* classdef;
    class HashDeclDef* hashdecldef;
    DateTimeNode* datetime;
    QoreRegexSubst* RegexSubst;
    QoreTransliteration* Trans;
    SwitchStatement* switchstmt;
    CaseNode* casenode;
    BCList* sclist;
    class BCNode* sclnode;
    BCAList* bcalist;
    BCANode* bcanode;
    NamedScope *nscope;
    QoreRegex* Regex;
    QoreImplicitArgumentNode* implicit_arg;
    RetTypeInfo* returnTypeInfo;
    struct ParserTypeStruct* parsertype;
    class ParseUserFunction* parsefunc;
    class ParseScopedUserFunction* sparsefunc;
    struct GVarDecl* gv;
    QoreNumberNode* num;
    TryModuleError* trymod;
    struct MethodDef* methoddef;

#line 1992 "parser.cpp"

};
typedef union YYSTYPE YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif

/* Location type.  */
#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE YYLTYPE;
struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif




int yyparse (yyscan_t yyscanner);


#endif /* !YY_YY_PARSER_HPP_INCLUDED  */
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_TOK_RETURN = 3,                 /* "return"  */
  YYSYMBOL_TOK_RETURNS = 4,                /* "returns"  */
  YYSYMBOL_TOK_THREAD_LOCAL = 5,           /* "thread_local"  */
  YYSYMBOL_TOK_MY = 6,                     /* "my"  */
  YYSYMBOL_TOK_DO = 7,                     /* "do"  */
  YYSYMBOL_TOK_TRY = 8,                    /* "try"  */
  YYSYMBOL_TOK_THROW = 9,                  /* "throw"  */
  YYSYMBOL_TOK_CATCH = 10,                 /* "catch"  */
  YYSYMBOL_TOK_WHERE = 11,                 /* "where"  */
  YYSYMBOL_TOK_WHILE = 12,                 /* "while"  */
  YYSYMBOL_TOK_IF = 13,                    /* "if"  */
  YYSYMBOL_TOK_FOR = 14,                   /* "for"  */
  YYSYMBOL_TOK_SUB = 15,                   /* "sub"  */
  YYSYMBOL_TOK_THREAD_EXIT = 16,           /* "thread_exit"  */
  YYSYMBOL_TOK_BREAK = 17,                 /* "break"  */
  YYSYMBOL_TOK_CONTINUE = 18,              /* "continue"  */
  YYSYMBOL_TOK_CONTEXT_ROW = 19,           /* "%%"  */
  YYSYMBOL_TOK_FIND = 20,                  /* "find"  */
  YYSYMBOL_TOK_FOREACH = 21,               /* "foreach"  */
  YYSYMBOL_TOK_IN = 22,                    /* "in"  */
  YYSYMBOL_TOK_DELETE = 23,                /* "delete"  */
  YYSYMBOL_TOK_REMOVE = 24,                /* "remove"  */
  YYSYMBOL_TOK_PRIVATE = 25,               /* "private"  */
  YYSYMBOL_TOK_PRIVATEINTERNAL = 26,       /* "private:internal"  */
  YYSYMBOL_TOK_PRIVATEHIERARCHY = 27,      /* "private:hierarchy"  */
  YYSYMBOL_TOK_PUBLIC = 28,                /* "public"  */
  YYSYMBOL_TOK_SYNCHRONIZED = 29,          /* "synchronized"  */
  YYSYMBOL_TOK_DEPRECATED = 30,            /* "deprecated"  */
  YYSYMBOL_TOK_CONTEXT = 31,               /* "context"  */
  YYSYMBOL_TOK_SORT_BY = 32,               /* "sortBy"  */
  YYSYMBOL_TOK_SORT_DESCENDING_BY = 33,    /* "sortDescendingBy"  */
  YYSYMBOL_TOK_SUB_CONTEXT = 34,           /* "subcontext"  */
  YYSYMBOL_TOK_CONST = 35,                 /* "const"  */
  YYSYMBOL_TOK_SUMMARIZE = 36,             /* "summarize"  */
  YYSYMBOL_TOK_BY = 37,                    /* "by"  */
  YYSYMBOL_TOK_OUR = 38,                   /* "our"  */
  YYSYMBOL_TOK_RETHROW = 39,               /* "rethrow"  */
  YYSYMBOL_TOK_SWITCH = 40,                /* "switch"  */
  YYSYMBOL_TOK_CASE = 41,                  /* "case"  */
  YYSYMBOL_TOK_DEFAULT = 42,               /* "default"  */
  YYSYMBOL_TOK_INHERITS = 43,              /* "inherits"  */
  YYSYMBOL_TOK_ELSE = 44,                  /* "else"  */
  YYSYMBOL_TOK_STATIC = 45,                /* "static"  */
  YYSYMBOL_TOK_NAMESPACE = 46,             /* "namespace"  */
  YYSYMBOL_TOK_MODULE = 47,                /* "module"  */
  YYSYMBOL_TOK_FINAL = 48,                 /* "final"  */
  YYSYMBOL_TOK_ABSTRACT = 49,              /* "abstract"  */
  YYSYMBOL_TOK_HASHDECL = 50,              /* "hashdecl"  */
  YYSYMBOL_TOK_TRANSIENT = 51,             /* "transient"  */
  YYSYMBOL_TOK_NULL = 52,                  /* "NULL"  */
  YYSYMBOL_TOK_NOTHING = 53,               /* "NOTHING"  */
  YYSYMBOL_TOK_TRUE = 54,                  /* "True"  */
  YYSYMBOL_TOK_FALSE = 55,                 /* "False"  */
  YYSYMBOL_TOK_UNREFERENCE = 56,           /* "unreference"  */
  YYSYMBOL_P_INCREMENT = 57,               /* "++ operator"  */
  YYSYMBOL_P_DECREMENT = 58,               /* "-- operator"  */
  YYSYMBOL_PLUS_EQUALS = 59,               /* "+= operator"  */
  YYSYMBOL_MINUS_EQUALS = 60,              /* "-= operator"  */
  YYSYMBOL_AND_EQUALS = 61,                /* "&= operator"  */
  YYSYMBOL_OR_EQUALS = 62,                 /* "|= operator"  */
  YYSYMBOL_MODULA_EQUALS = 63,             /* "%= operator"  */
  YYSYMBOL_MULTIPLY_EQUALS = 64,           /* "*= operator"  */
  YYSYMBOL_DIVIDE_EQUALS = 65,             /* "/= operator"  */
  YYSYMBOL_XOR_EQUALS = 66,                /* "^= operator"  */
  YYSYMBOL_SHIFT_LEFT_EQUALS = 67,         /* "<<= operator"  */
  YYSYMBOL_SHIFT_RIGHT_EQUALS = 68,        /* ">>= operator"  */
  YYSYMBOL_TOK_UNSHIFT = 69,               /* "unshift"  */
  YYSYMBOL_TOK_PUSH = 70,                  /* "push"  */
  YYSYMBOL_TOK_POP = 71,                   /* "pop"  */
  YYSYMBOL_TOK_SHIFT = 72,                 /* "shift"  */
  YYSYMBOL_TOK_CHOMP = 73,                 /* "chomp"  */
  YYSYMBOL_TOK_TRIM = 74,                  /* "trim"  */
  YYSYMBOL_LOGICAL_AND = 75,               /* "&& operator"  */
  YYSYMBOL_LOGICAL_OR = 76,                /* "|| operator"  */
  YYSYMBOL_BROKEN_LOGICAL_OR = 77,         /* "|| operator (compat)"  */
  YYSYMBOL_BROKEN_BINARY_OR = 78,          /* "| operator (compat)"  */
  YYSYMBOL_BROKEN_BINARY_XOR = 79,         /* "^ operator (compat)"  */
  YYSYMBOL_LOGICAL_EQ = 80,                /* "== operator"  */
  YYSYMBOL_LOGICAL_NE = 81,                /* "!= operator"  */
  YYSYMBOL_LOGICAL_LE = 82,                /* "<= operator"  */
  YYSYMBOL_LOGICAL_GE = 83,                /* ">= operator"  */
  YYSYMBOL_LOGICAL_CMP = 84,               /* "<=> operator"  */
  YYSYMBOL_ABSOLUTE_EQ = 85,               /* "=== operator"  */
  YYSYMBOL_ABSOLUTE_NE = 86,               /* "!== operator"  */
  YYSYMBOL_REGEX_MATCH = 87,               /* "=~ operator"  */
  YYSYMBOL_REGEX_NMATCH = 88,              /* "!~ operator"  */
  YYSYMBOL_TOK_EXISTS = 89,                /* "exists"  */
  YYSYMBOL_TOK_INSTANCEOF = 90,            /* "instanceof"  */
  YYSYMBOL_SHIFT_RIGHT = 91,               /* ">> operator"  */
  YYSYMBOL_SHIFT_LEFT = 92,                /* "<< operator"  */
  YYSYMBOL_TOK_ELEMENTS = 93,              /* "elements"  */
  YYSYMBOL_TOK_KEYS = 94,                  /* "keys"  */
  YYSYMBOL_TOK_NEW = 95,                   /* "new"  */
  YYSYMBOL_TOK_BACKGROUND = 96,            /* "background"  */
  YYSYMBOL_TOK_ON_EXIT = 97,               /* "on_exit"  */
  YYSYMBOL_TOK_ON_SUCCESS = 98,            /* "on_success"  */
  YYSYMBOL_TOK_ON_ERROR = 99,              /* "on_error"  */
  YYSYMBOL_TOK_MAP = 100,                  /* "map"  */
  YYSYMBOL_TOK_FOLDR = 101,                /* "foldr"  */
  YYSYMBOL_TOK_FOLDL = 102,                /* "foldl"  */
  YYSYMBOL_TOK_SELECT = 103,               /* "select"  */
  YYSYMBOL_TOK_SPLICE = 104,               /* "splice"  */
  YYSYMBOL_TOK_EXTRACT = 105,              /* "extract"  */
  YYSYMBOL_IMPLICIT_ELEMENT = 106,         /* "$# operator"  */
  YYSYMBOL_NULL_COALESCING = 107,          /* "?? operator"  */
  YYSYMBOL_VALUE_COALESCING = 108,         /* "?* operator"  */
  YYSYMBOL_WEAK_ASSIGNMENT = 109,          /* ":= operator"  */
  YYSYMBOL_RANGE = 110,                    /* ".. operator"  */
  YYSYMBOL_ELLIPSES = 111,                 /* "... marker"  */
  YYSYMBOL_INTEGER = 112,                  /* "integer value"  */
  YYSYMBOL_QFLOAT = 113,                   /* "floating-point value"  */
  YYSYMBOL_NUMBER = 114,                   /* "arbitrary-precision number"  */
  YYSYMBOL_IDENTIFIER = 115,               /* "identifier"  */
  YYSYMBOL_HASHDECL_IDENTIFIER_OPENCURLY = 116, /* "typed hash identifier"  */
  YYSYMBOL_ANGLE_IDENTIFIER = 117,         /* "complex type identifier"  */
  YYSYMBOL_VAR_REF = 118,                  /* "variable reference"  */
  YYSYMBOL_BACKQUOTE = 119,                /* "backquote expression"  */
  YYSYMBOL_SELF_REF = 120,                 /* "in-object member reference"  */
  YYSYMBOL_KW_IDENTIFIER_OPENPAREN = 121,  /* "identifier or keyword used as function or method identifier"  */
  YYSYMBOL_SCOPED_REF = 122,               /* "namespace or class-scoped reference"  */
  YYSYMBOL_SCOPED_VREF = 123,              /* "namespace-scoped global variable reference"  */
  YYSYMBOL_CONTEXT_REF = 124,              /* "context reference"  */
  YYSYMBOL_COMPLEX_CONTEXT_REF = 125,      /* "named context reference"  */
  YYSYMBOL_QORE_CAST = 126,                /* "cast operator"  */
  YYSYMBOL_QORE_OR_NOTHING_CAST = 127,     /* "cast (or nothing) operator"  */
  YYSYMBOL_CLASS_STRING = 128,             /* "simple class declaration"  */
  YYSYMBOL_DATETIME = 129,                 /* "date/time value"  */
  YYSYMBOL_QUOTED_WORD = 130,              /* "quoted string"  */
  YYSYMBOL_BINARY = 131,                   /* "binary constant value"  */
  YYSYMBOL_REGEX_SUBST = 132,              /* "regular expression substitution expression"  */
  YYSYMBOL_REGEX_TRANS = 133,              /* "transliteration expression"  */
  YYSYMBOL_CLASS_SCOPED_REF = 134,         /* "scoped class declaration"  */
  YYSYMBOL_BASE_CLASS_CALL = 135,          /* "call to base class method"  */
  YYSYMBOL_REGEX = 136,                    /* "regular expression"  */
  YYSYMBOL_REGEX_EXTRACT = 137,            /* "regular expression extraction expression"  */
  YYSYMBOL_IMPLICIT_ARG_REF = 138,         /* "implicit argument reference"  */
  YYSYMBOL_DOT_KW_IDENTIFIER = 139,        /* "keyword used as hash key or object member reference"  */
  YYSYMBOL_TRY_MODULE_ERROR = 140,         /* "%try-module error token"  */
  YYSYMBOL_IFX = 141,                      /* IFX  */
  YYSYMBOL_142_ = 142,                     /* ','  */
  YYSYMBOL_143_ = 143,                     /* '='  */
  YYSYMBOL_144_ = 144,                     /* '?'  */
  YYSYMBOL_145_ = 145,                     /* ':'  */
  YYSYMBOL_146_ = 146,                     /* '|'  */
  YYSYMBOL_147_ = 147,                     /* '^'  */
  YYSYMBOL_148_ = 148,                     /* '&'  */
  YYSYMBOL_149_ = 149,                     /* '<'  */
  YYSYMBOL_150_ = 150,                     /* '>'  */
  YYSYMBOL_151_ = 151,                     /* '+'  */
  YYSYMBOL_152_ = 152,                     /* '-'  */
  YYSYMBOL_153_ = 153,                     /* '%'  */
  YYSYMBOL_154_ = 154,                     /* '*'  */
  YYSYMBOL_155_ = 155,                     /* '/'  */
  YYSYMBOL_NEG = 156,                      /* NEG  */
  YYSYMBOL_UPLUS = 157,                    /* UPLUS  */
  YYSYMBOL_158_ = 158,                     /* '~'  */
  YYSYMBOL_159_ = 159,                     /* '\\'  */
  YYSYMBOL_160_ = 160,                     /* '!'  */
  YYSYMBOL_161_ = 161,                     /* '{'  */
  YYSYMBOL_162_ = 162,                     /* '['  */
  YYSYMBOL_163_ = 163,                     /* '.'  */
  YYSYMBOL_164_ = 164,                     /* '('  */
  YYSYMBOL_165_ = 165,                     /* '}'  */
  YYSYMBOL_166_ = 166,                     /* ';'  */
  YYSYMBOL_167_ = 167,                     /* ')'  */
  YYSYMBOL_168_ = 168,                     /* ']'  */
  YYSYMBOL_YYACCEPT = 169,                 /* $accept  */
  YYSYMBOL_top_level_commands = 170,       /* top_level_commands  */
  YYSYMBOL_top_level_command = 171,        /* top_level_command  */
  YYSYMBOL_module_decls = 172,             /* module_decls  */
  YYSYMBOL_module_decl = 173,              /* module_decl  */
  YYSYMBOL_ppub = 174,                     /* ppub  */
  YYSYMBOL_gvardecl = 175,                 /* gvardecl  */
  YYSYMBOL_top_namespace_decl = 176,       /* top_namespace_decl  */
  YYSYMBOL_namespace_decls = 177,          /* namespace_decls  */
  YYSYMBOL_namespace_decl = 178,           /* namespace_decl  */
  YYSYMBOL_unscoped_const_decl = 179,      /* unscoped_const_decl  */
  YYSYMBOL_scoped_const_decl = 180,        /* scoped_const_decl  */
  YYSYMBOL_block = 181,                    /* block  */
  YYSYMBOL_statement_or_block = 182,       /* statement_or_block  */
  YYSYMBOL_statements = 183,               /* statements  */
  YYSYMBOL_optname = 184,                  /* optname  */
  YYSYMBOL_statement = 185,                /* statement  */
  YYSYMBOL_context_mods = 186,             /* context_mods  */
  YYSYMBOL_context_mod = 187,              /* context_mod  */
  YYSYMBOL_return_statement = 188,         /* return_statement  */
  YYSYMBOL_switch_statement = 189,         /* switch_statement  */
  YYSYMBOL_case_block = 190,               /* case_block  */
  YYSYMBOL_case_code = 191,                /* case_code  */
  YYSYMBOL_try_statement = 192,            /* try_statement  */
  YYSYMBOL_myexp = 193,                    /* myexp  */
  YYSYMBOL_hashdecl_def = 194,             /* hashdecl_def  */
  YYSYMBOL_class_def = 195,                /* class_def  */
  YYSYMBOL_inheritance_list = 196,         /* inheritance_list  */
  YYSYMBOL_superclass_list = 197,          /* superclass_list  */
  YYSYMBOL_superclass = 198,               /* superclass  */
  YYSYMBOL_hashdecl_attrs = 199,           /* hashdecl_attrs  */
  YYSYMBOL_hashdecl_member = 200,          /* hashdecl_member  */
  YYSYMBOL_class_attributes = 201,         /* class_attributes  */
  YYSYMBOL_uncqtypedef = 202,              /* uncqtypedef  */
  YYSYMBOL_qtypedef = 203,                 /* qtypedef  */
  YYSYMBOL_internal_member_list = 204,     /* internal_member_list  */
  YYSYMBOL_private_member_list = 205,      /* private_member_list  */
  YYSYMBOL_public_member_list = 206,       /* public_member_list  */
  YYSYMBOL_classvardecl = 207,             /* classvardecl  */
  YYSYMBOL_member2 = 208,                  /* member2  */
  YYSYMBOL_transient_member2 = 209,        /* transient_member2  */
  YYSYMBOL_member = 210,                   /* member  */
  YYSYMBOL_transient_member = 211,         /* transient_member  */
  YYSYMBOL_member_list = 212,              /* member_list  */
  YYSYMBOL_member_list2 = 213,             /* member_list2  */
  YYSYMBOL_ident_openparen = 214,          /* ident_openparen  */
  YYSYMBOL_inline_methoddef = 215,         /* inline_methoddef  */
  YYSYMBOL_outofline_methoddef = 216,      /* outofline_methoddef  */
  YYSYMBOL_base_constructor_list = 217,    /* base_constructor_list  */
  YYSYMBOL_base_constructors = 218,        /* base_constructors  */
  YYSYMBOL_base_constructor = 219,         /* base_constructor  */
  YYSYMBOL_nsc_modifiers = 220,            /* nsc_modifiers  */
  YYSYMBOL_method_modifiers = 221,         /* method_modifiers  */
  YYSYMBOL_method_modifier = 222,          /* method_modifier  */
  YYSYMBOL_return_value = 223,             /* return_value  */
  YYSYMBOL_sub_def = 224,                  /* sub_def  */
  YYSYMBOL_scoped_sub_def = 225,           /* scoped_sub_def  */
  YYSYMBOL_list = 226,                     /* list  */
  YYSYMBOL_list_n = 227,                   /* list_n  */
  YYSYMBOL_hash = 228,                     /* hash  */
  YYSYMBOL_hash_element = 229,             /* hash_element  */
  YYSYMBOL_alt_hash = 230,                 /* alt_hash  */
  YYSYMBOL_immediate_typed_hash = 231,     /* immediate_typed_hash  */
  YYSYMBOL_exp_c = 232,                    /* exp_c  */
  YYSYMBOL_exp = 233,                      /* exp  */
  YYSYMBOL_exp_n = 234,                    /* exp_n  */
  YYSYMBOL_string = 235,                   /* string  */
  YYSYMBOL_scalar = 236                    /* scalar  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;


/* Second part of user prologue.  */
#line 1593 "parser.ypp"

#define LEX_PARAMETERS YYSTYPE *lvalp, YYLTYPE *loc, yyscan_t scanner

DLLLOCAL int yylex(LEX_PARAMETERS);

DLLLOCAL void yyerror(YYLTYPE* loc, yyscan_t scanner, const char* str) {
    //printd(5, "yyerror() location: %d:%d - %d:%d \"%s\"\n", loc->first_line, loc->first_col, loc->last_line, loc->last_col, str);
    const QoreProgramLocation* qloc = qore_program_private::get(*getProgram())->getLocation(loc->first_line, loc->last_line);
    parse_error(*qloc, "%s", str);
}

#line 2279 "parser.cpp"


#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  217
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   14228

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  169
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  68
/* YYNRULES -- Number of rules.  */
#define YYNRULES  449
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  960

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   398


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   160,     2,     2,     2,   153,   148,     2,
     164,   167,   154,   151,   142,   152,   163,   155,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   145,   166,
     149,   143,   150,   144,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   162,   159,   168,   147,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   161,   146,   165,   158,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   156,   157
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,  1856,  1856,  1857,  1861,  1864,  1869,  1877,  1881,  1887,
    1891,  1896,  1904,  1905,  1909,  1916,  1926,  1951,  1953,  1958,
    1972,  1973,  1979,  1988,  1995,  2002,  2007,  2016,  2023,  2028,
    2037,  2044,  2051,  2056,  2065,  2072,  2080,  2089,  2096,  2106,
    2111,  2119,  2124,  2127,  2135,  2138,  2141,  2146,  2149,  2157,
    2163,  2166,  2172,  2175,  2181,  2184,  2189,  2192,  2197,  2199,
    2201,  2203,  2209,  2210,  2214,  2215,  2245,  2252,  2254,  2257,
    2260,  2263,  2266,  2269,  2272,  2275,  2278,  2281,  2284,  2287,
    2290,  2293,  2296,  2299,  2300,  2308,  2311,  2314,  2315,  2320,
    2321,  2332,  2334,  2336,  2341,  2343,  2347,  2356,  2360,  2368,
    2374,  2380,  2386,  2392,  2398,  2404,  2410,  2416,  2422,  2428,
    2433,  2438,  2443,  2448,  2453,  2458,  2464,  2470,  2475,  2483,
    2531,  2532,  2533,  2537,  2543,  2552,  2559,  2568,  2577,  2588,
    2597,  2611,  2614,  2620,  2623,  2630,  2634,  2638,  2642,  2646,
    2650,  2654,  2658,  2662,  2666,  2673,  2681,  2697,  2702,  2707,
    2734,  2738,  2744,  2750,  2756,  2762,  2766,  2771,  2776,  2781,
    2790,  2793,  2796,  2800,  2803,  2806,  2814,  2815,  2821,  2822,
    2823,  2827,  2828,  2829,  2830,  2831,  2832,  2836,  2837,  2838,
    2842,  2847,  2851,  2857,  2861,  2884,  2892,  2900,  2925,  2932,
    2939,  2963,  2969,  2975,  2978,  2988,  2995,  3001,  3010,  3017,
    3020,  3023,  3027,  3034,  3037,  3040,  3044,  3051,  3054,  3057,
    3063,  3075,  3091,  3099,  3114,  3125,  3138,  3144,  3153,  3157,
    3167,  3170,  3176,  3179,  3186,  3190,  3198,  3199,  3204,  3205,
    3215,  3216,  3217,  3218,  3219,  3220,  3221,  3222,  3223,  3227,
    3244,  3250,  3256,  3266,  3278,  3296,  3302,  3312,  3324,  3342,
    3347,  3366,  3371,  3385,  3390,  3394,  3399,  3404,  3414,  3423,
    3432,  3434,  3436,  3438,  3443,  3458,  3470,  3477,  3486,  3497,
    3514,  3549,  3552,  3560,  3565,  3570,  3575,  3580,  3585,  3590,
    3594,  3608,  3612,  3626,  3630,  3634,  3638,  3661,  3687,  3715,
    3731,  3747,  3763,  3767,  3771,  3779,  3785,  3792,  3799,  3804,
    3808,  3812,  3843,  3850,  3857,  3864,  3878,  3884,  3901,  3907,
    3912,  3920,  3929,  3942,  3946,  3950,  3954,  3958,  3962,  3969,
    3970,  3971,  3972,  3973,  3974,  3975,  3976,  3977,  3978,  3979,
    3980,  3981,  3982,  3983,  3984,  3987,  3995,  4002,  4003,  4004,
    4005,  4006,  4007,  4008,  4013,  4014,  4015,  4016,  4021,  4022,
    4028,  4029,  4030,  4031,  4032,  4033,  4034,  4035,  4036,  4037,
    4038,  4039,  4040,  4041,  4042,  4043,  4044,  4045,  4046,  4047,
    4048,  4049,  4050,  4051,  4052,  4056,  4070,  4071,  4072,  4073,
    4077,  4078,  4079,  4080,  4081,  4082,  4083,  4084,  4085,  4086,
    4087,  4088,  4089,  4092,  4100,  4107,  4108,  4109,  4110,  4111,
    4112,  4113,  4118,  4119,  4120,  4121,  4126,  4127,  4133,  4134,
    4135,  4136,  4137,  4138,  4139,  4140,  4141,  4142,  4143,  4144,
    4145,  4146,  4147,  4148,  4149,  4150,  4151,  4152,  4153,  4154,
    4155,  4156,  4157,  4162,  4177,  4178,  4179,  4180,  4184,  4187,
    4195,  4196,  4197,  4198,  4199,  4200,  4201,  4202,  4203,  4204
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "\"return\"",
  "\"returns\"", "\"thread_local\"", "\"my\"", "\"do\"", "\"try\"",
  "\"throw\"", "\"catch\"", "\"where\"", "\"while\"", "\"if\"", "\"for\"",
  "\"sub\"", "\"thread_exit\"", "\"break\"", "\"continue\"", "\"%%\"",
  "\"find\"", "\"foreach\"", "\"in\"", "\"delete\"", "\"remove\"",
  "\"private\"", "\"private:internal\"", "\"private:hierarchy\"",
  "\"public\"", "\"synchronized\"", "\"deprecated\"", "\"context\"",
  "\"sortBy\"", "\"sortDescendingBy\"", "\"subcontext\"", "\"const\"",
  "\"summarize\"", "\"by\"", "\"our\"", "\"rethrow\"", "\"switch\"",
  "\"case\"", "\"default\"", "\"inherits\"", "\"else\"", "\"static\"",
  "\"namespace\"", "\"module\"", "\"final\"", "\"abstract\"",
  "\"hashdecl\"", "\"transient\"", "\"NULL\"", "\"NOTHING\"", "\"True\"",
  "\"False\"", "\"unreference\"", "\"++ operator\"", "\"-- operator\"",
  "\"+= operator\"", "\"-= operator\"", "\"&= operator\"",
  "\"|= operator\"", "\"%= operator\"", "\"*= operator\"",
  "\"/= operator\"", "\"^= operator\"", "\"<<= operator\"",
  "\">>= operator\"", "\"unshift\"", "\"push\"", "\"pop\"", "\"shift\"",
  "\"chomp\"", "\"trim\"", "\"&& operator\"", "\"|| operator\"",
  "\"|| operator (compat)\"", "\"| operator (compat)\"",
  "\"^ operator (compat)\"", "\"== operator\"", "\"!= operator\"",
  "\"<= operator\"", "\">= operator\"", "\"<=> operator\"",
  "\"=== operator\"", "\"!== operator\"", "\"=~ operator\"",
  "\"!~ operator\"", "\"exists\"", "\"instanceof\"", "\">> operator\"",
  "\"<< operator\"", "\"elements\"", "\"keys\"", "\"new\"",
  "\"background\"", "\"on_exit\"", "\"on_success\"", "\"on_error\"",
  "\"map\"", "\"foldr\"", "\"foldl\"", "\"select\"", "\"splice\"",
  "\"extract\"", "\"$# operator\"", "\"?? operator\"", "\"?* operator\"",
  "\":= operator\"", "\".. operator\"", "\"... marker\"",
  "\"integer value\"", "\"floating-point value\"",
  "\"arbitrary-precision number\"", "\"identifier\"",
  "\"typed hash identifier\"", "\"complex type identifier\"",
  "\"variable reference\"", "\"backquote expression\"",
  "\"in-object member reference\"",
  "\"identifier or keyword used as function or method identifier\"",
  "\"namespace or class-scoped reference\"",
  "\"namespace-scoped global variable reference\"",
  "\"context reference\"", "\"named context reference\"",
  "\"cast operator\"", "\"cast (or nothing) operator\"",
  "\"simple class declaration\"", "\"date/time value\"",
  "\"quoted string\"", "\"binary constant value\"",
  "\"regular expression substitution expression\"",
  "\"transliteration expression\"", "\"scoped class declaration\"",
  "\"call to base class method\"", "\"regular expression\"",
  "\"regular expression extraction expression\"",
  "\"implicit argument reference\"",
  "\"keyword used as hash key or object member reference\"",
  "\"%try-module error token\"", "IFX", "','", "'='", "'?'", "':'", "'|'",
  "'^'", "'&'", "'<'", "'>'", "'+'", "'-'", "'%'", "'*'", "'/'", "NEG",
  "UPLUS", "'~'", "'\\\\'", "'!'", "'{'", "'['", "'.'", "'('", "'}'",
  "';'", "')'", "']'", "$accept", "top_level_commands",
  "top_level_command", "module_decls", "module_decl", "ppub", "gvardecl",
  "top_namespace_decl", "namespace_decls", "namespace_decl",
  "unscoped_const_decl", "scoped_const_decl", "block",
  "statement_or_block", "statements", "optname", "statement",
  "context_mods", "context_mod", "return_statement", "switch_statement",
  "case_block", "case_code", "try_statement", "myexp", "hashdecl_def",
  "class_def", "inheritance_list", "superclass_list", "superclass",
  "hashdecl_attrs", "hashdecl_member", "class_attributes", "uncqtypedef",
  "qtypedef", "internal_member_list", "private_member_list",
  "public_member_list", "classvardecl", "member2", "transient_member2",
  "member", "transient_member", "member_list", "member_list2",
  "ident_openparen", "inline_methoddef", "outofline_methoddef",
  "base_constructor_list", "base_constructors", "base_constructor",
  "nsc_modifiers", "method_modifiers", "method_modifier", "return_value",
  "sub_def", "scoped_sub_def", "list", "list_n", "hash", "hash_element",
  "alt_hash", "immediate_typed_hash", "exp_c", "exp", "exp_n", "string",
  "scalar", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-693)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-227)

#define yytable_value_is_error(Yyn) \
  ((Yyn) == YYTABLE_NINF)

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    1543,  -115,  6901,   577,  5851,  5851,  8130,   -17,     8,    12,
     258,   -32,    -4,    16,  -693,  8130,  8130,  8130,  8130,  -693,
    -693,  -693,    54,  -693,  -693,    77,  -693,   174,    77,  7051,
      65,  -693,   100,  -693,  -693,  -693,  -693,  -693,  -693,  8130,
    8130,  8130,  8130,  8130,  8130,  8130,  8130,  8130,  8130,  8130,
     347,  8130,  5851,  5851,  5851,  8130,  8130,  8130,  8130,  8130,
    8130,  -693,  -693,  -693,  -693,  -693,    46,  -693,  -693,  -693,
    1378,    10,  -693,  -693,   130,   202,  -693,   191,  -693,   233,
    -693,  -693,  8130,  8130,   468,  8130,  8130,  8130,  5187,  6751,
    -693,  1216,  -693,    57,  -693,  -693,  -693,  -693,  -693,   242,
    -693,  -693,  -693,  -693,    79,   244,  -693,   157,   637,  -693,
    -693,  -693,  -693,  -693, 10684,  -693,  -693,  -693,   261,    68,
    7395,    95,  7542,    35,   996,  -693,  -693,  -693,  -693, 13414,
       4,  -693,  8130,   297,   310,    20,  5353,  -693,   433,  -693,
     436, 10794,  8130,  8130,  6013,   294,   304,  -693,   306,  1378,
    1378,  -693,  -693,  -693,  8355,  8463,    69,    69,   270,  -693,
     307,  1705,   313,   351,   331,  -693, 10904,  8130,   390,   288,
     288, 13414, 13414,    69,    69,    69,    69,  8209,    69,    69,
     342,   352,   366,    69,  -693,  -693,  -693, 13414, 13414, 13414,
   13414, 13414, 13414,  -693,   341, 13414,  1378,  8130,  8130,  -693,
    1378,    69,    69,  -693,  -693,  -693,    69,    69,    69,  -693,
    -693,  5519,  -693,  -693,   -31,  -693,  9019,  -693,  -693,   578,
     705,  -693,   369,  -693,   376,  -693,  -693,   237,   279,   499,
     499,   416,  -693,  -693,   395,    15,  -693,  -693,  -693,  8130,
    8130,  8130,  8130,  8130,  8130,  8130,  8130,  8130,  8130,  8130,
    8130,  8130,  8130,  8130,  8130,  8130,  8130,  8130,  8130,  8130,
    8130,   524,   425,   370,  8130,  8130,  8130,  8130,  8130,  8130,
    -693,  7248,  8130,  8130,  8130,  8130,  8130,  8130,  8130,  8130,
    8130,  8130,  8130,  8130,  8130,  7836,  8130,  1378,  -693,  -693,
     -74, 12442,  -693,   -26,   407,   411,   567,  -693,  -693,  8130,
    8130,  8130,  8130,  8130,  8130,  8130,  8130,  8130,  8130,  8130,
    8130,  8130,  8130,  8130,  8130,  8130,  8130,  8130,  8130,  8130,
    8130,   631,   450,   370,  8130,  8130,  8130,  8130,  8130,  8130,
    -693,  7248,  8130,  8130,  8130,  8130,  8130,  8130,  8130,  8130,
    8130,  8130,  8130,  8130,  8130,  7983,  8130,  1378,   430, 13414,
    -693,  -693,  1378,  -693,  5685,   434,   446,  -693,  9130,  9241,
     445,  -693,  -693,  1378,   464,   467,  8130,   471,   511,   531,
    8130,   486,   494,   513,  -693,  -693,  8130,  8130,  8130,  -693,
    9352,   532,   -51,  -693,  1378,  1378,  1378,  -693,   520,  9463,
    9574,   521,  -693,  -693,  -693,  7248,  -693,  8130,  -693,    99,
     232,  8130,   292,   483,    99,   232,  8130,   302,   501,   541,
    1378,  1378,  1378,   474,  -693,   528,   557,   333,   507,   582,
     556,  1378,  1378,  1378,   457,   563, 13522, 13522, 13522, 13522,
   13522, 13522, 13522, 13522, 13522, 13522, 13891, 13855, 13891, 14064,
   14064,  8209,  8209,  8209,  8209,  8209,  8209,  8209,  -693,  -693,
    -693,  -693,  -693,  -693,   939,   939, 13756, 13756, 13522, 13720,
   13522, 13522, 12550, 13978, 14014, 14064,  8209,  8209,   655,   655,
     722,    69,    69, 12224,  6163,  8571,  -693,   554,  -693,  -693,
     569, 13522, 13522, 13522, 13522, 13522, 13522, 13522, 13522, 13522,
   13522, 13891, 13855, 13891, 14064, 14064,  8209,  8209,  8209,  8209,
    8209,  8209,  8209,  -693,  -693,  -693,  -693,  -693,  -693,   939,
     939, 13756, 13756, 13522, 13720, 13522, 13522, 12658, 13978, 14014,
   14064,  8209,  8209,   655,   655,   722,    69,    69, 12333,  6310,
    8683,  -693,   572,  -693,   584,  -693,  8130,  1378,  5851,  5851,
    6013,   590,   732,   732,  8247,  8130,  8130,  8130,  9685,  8130,
    8130,  8130, 11014, 11124,  9796,   597,  8130,  -693,  -693,   614,
     620,   623,    43,  -693,  -693,  -693,  -693, 13522,   625,  -693,
    -693,  -693,  -693,   626,  -693,  -693,  -693,  -693,  1378,   638,
     645,   654,   262,   612,  -693,   659,  -693,  7193,  -693,  -693,
    -693,  -693,  -693,    45,  -693,  1032,  -693,  -693,   370,   370,
     344,   406,   414,   424,  -693,  -693,   636,  -693,   361,  -693,
     412,  -693,  1378,   665,   666,   668,   675,  1378,  1378,  1378,
    8130,  -693,  -693,  8795,  6457,  -693,  -693,  8130,  -693,  -693,
    8907,  6604,  -693,  -693,   678,  9907,   679,  -693,   803,   683,
     732,   370,   690,   690,   686, 10018, 11234, 11344,  -693, 10129,
   10240, 10351,  -693,  -693,   815,   340, 11454,  -693,  -693,  -693,
     435,  -693,   732,  -693,  -693,   688,   690,   690,   708,  1378,
    -693,  -693,  -693,   487,   505,    59,   248,  -693,   741,   515,
    -693,  -693,  -693,  -693,  -693,  -693,  -693,  -693,   333,   -30,
     -15,    -3,    28,   742,  -693,  -693,   448,  -693,  -693,  -693,
    -693,   719,   941,  -693,   539,   691,   732,   732,   708,  1378,
     693,   695,   696, 13621,  -693,  -693, 13621,  -693,  -693,   699,
    5851,  5851,  1378,   690,  -693,  -693,  -693,  -693,  8130,  5851,
    -693,  -693,  1705,  -693,  -693,  -693,   702,  7689,   723,    -8,
    -693,  -693,   703,   706,   729,  -693,   690,   690,  -693,  -693,
     690,   711,   607,  -693,  -693,   205,  -693,  -693,   755,   758,
      37,  -693,  -693,   -43,    58,    13,   490,    94,   766,   525,
     153,  -693,  -693,  -693,  -693,  -693,  -693,   304,    30,  1378,
    -693,   732,   690,   690,   732,   721,   690,   690,   708,  -693,
    -693,  -693,   725,  -693, 10462,  -693,  -693,  8130,  8130,  8130,
    8130,   753,   757,   750,  8130,  8130, 12766,  1867,  -693,  -693,
    1378,  1378,   435,  -693,  -693,  -693,   708,  8130,  1378,  -693,
    -693,  -693,   862,   561,   398,   -22,  -693,  -693,   784,   780,
    -693,  -693,  -693,   608,    50,  -693,  -693,   689,  -693,  -693,
     779,  -693,  -693,  1038,  -693,  1378,   735,   690,  -693,  -693,
     594,   690,  -693,  -693,   600,  5851,  -693, 10573, 12874, 12982,
   13090,   761,   762,  2033, 13198, 13306,  2199,  2365,   743,   747,
    -693, 11564,   748,   206,   793,  -693,  8130,  -693,   257,   268,
    -693,  -693,  -693,  -693,  -693,  -693,  -693,  -693,   751,   708,
    -693,  -693,  -693,  -693,  -693,  -693,  -693,  -693,  2531,  2697,
    2863,  3029,  3195,  3361,  3527,  3693,  3859,  -693,  -693,  -693,
     754,  8130,  -693,   301, 11674,  8130,  1378,  -693,  8130,  1378,
    -693,   708,   732,  1705,  4025,  4191,  4357,  4523,  4689,  4855,
    5021,  -693, 11784,  8130,  1378,  -693,  -693, 11894,   752, 12004,
     765,   609,   611,  -693,  -693, 12114,   767,  -693,   771,  -693,
     773,  -693,  -693,  -693,  -693,  -693,   777,  -693,  -693,  -693
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       0,     0,    20,   166,     0,     0,    20,     0,     0,     0,
       0,     0,     0,     0,   274,    20,    20,    20,    20,   230,
     232,   231,   236,   234,   235,    62,    89,     0,    62,    20,
       0,   233,     0,   237,   238,   446,   445,   447,   448,    20,
      20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
       0,    20,     0,     0,     0,    20,    20,    20,    20,    20,
      20,   314,   449,   441,   440,   444,   272,   162,   306,   296,
       0,   263,   273,   275,     0,     0,   443,   438,   261,     0,
     313,    16,    20,    20,     0,    20,    20,    20,     0,    20,
      64,     0,     2,     0,   271,    14,     9,     8,    11,     0,
      87,    67,     7,     6,   167,     0,    10,     0,   227,   228,
       4,     5,   381,   380,     0,   442,   260,    88,     0,   236,
      20,   263,    20,   167,     0,   320,   321,   322,   319,    95,
     268,   161,    20,   167,     0,   263,     0,    57,     0,    56,
       0,     0,    20,    20,     0,     0,     0,   209,     0,     0,
       0,    84,    85,    86,     0,     0,   315,   316,     0,    63,
       0,     0,     0,     0,     0,    68,     0,    20,     0,   292,
     293,   280,   282,   283,   281,   284,   285,   277,   278,   279,
       0,     0,     0,   305,    71,    72,    73,   288,   289,   290,
     291,   286,   287,   122,     0,   121,     0,    20,    20,   439,
       0,   298,   297,   163,   165,   164,   299,   301,   300,    12,
      59,     0,    58,   308,     0,   253,     0,     1,     3,   166,
     166,    83,     0,   266,     0,   264,   265,     0,     0,   132,
     132,     0,   236,   160,   161,     0,   229,   398,   399,    20,
      20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
      20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
      20,     0,     0,     0,    20,    20,    20,    20,    20,    20,
     437,   252,    20,    20,    20,    20,    20,    20,    20,    20,
      20,    20,    20,    20,    20,    20,    20,     0,    65,   259,
       0,     0,   323,     0,     0,     0,     0,   340,   341,    20,
      20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
      20,    20,    20,    20,    20,    20,    20,    20,    20,    20,
      20,     0,     0,     0,    20,    20,    20,    20,    20,    20,
     379,   250,    20,    20,    20,    20,    20,    20,    20,    20,
      20,    20,    20,    20,    20,    20,    20,     0,   320,     0,
     267,   269,     0,    55,     0,     0,     0,    70,     0,     0,
       0,   208,   207,     0,     0,     0,    20,     0,     0,     0,
      20,     0,     0,     0,    74,    90,    20,    20,    20,    69,
       0,     0,     0,    17,     0,     0,     0,   295,     0,     0,
       0,     0,    13,    60,    61,   255,   262,    20,   307,    32,
      30,    20,   167,     0,    25,    23,    20,   167,     0,     0,
       0,     0,     0,   226,    37,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   382,   383,   384,   385,
     386,   387,   388,   389,   390,   391,   401,   402,   403,   404,
     405,   417,   420,   421,   422,   416,   418,   419,   411,   412,
     409,   413,   410,   394,   424,   423,   395,   396,   393,   435,
     251,   392,     0,   406,   408,   407,   415,   414,   425,   426,
     427,   429,   428,     0,    20,     0,   436,     0,   258,   257,
       0,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   343,   344,   345,   346,   347,   359,   362,   363,   364,
     358,   360,   361,   353,   354,   351,   355,   352,   336,   366,
     365,   337,   338,   335,   377,   249,   334,     0,   348,   350,
     349,   357,   356,   367,   368,   369,   371,   370,     0,    20,
       0,   378,     0,   270,     0,    54,    20,     0,     0,     0,
       0,     0,   240,   240,     0,    20,    20,    20,     0,    20,
      20,    20,     0,     0,     0,     0,    20,    15,    18,     0,
       0,     0,   221,   317,   318,   294,   254,   256,   320,    31,
      29,    34,    33,   320,    24,    22,    27,    26,     0,     0,
       0,     0,     0,   161,    38,     0,    48,   226,    39,    42,
      41,    44,    43,     0,    49,   227,    45,    46,     0,     0,
       0,     0,     0,     0,   135,   136,   131,   133,   226,   127,
     226,   128,     0,     0,     0,     0,     0,     0,     0,     0,
      20,   434,   432,     0,    20,   433,   400,    20,   376,   374,
       0,    20,   375,   342,     0,     0,     0,    79,    77,     0,
     240,   166,     0,     0,     0,     0,     0,     0,    89,     0,
       0,     0,    50,    52,     0,     0,     0,   302,   304,   303,
       0,    66,   240,    35,    28,     0,     0,     0,   221,     0,
      47,    36,    40,     0,     0,     0,     0,   145,     0,     0,
     139,   140,   143,   144,   141,   142,   137,   138,     0,   230,
     232,   231,   236,     0,   129,   154,   226,   151,   152,   153,
     150,     0,   227,   130,   226,     0,   240,   240,   221,     0,
       0,     0,     0,   397,   431,   430,   339,   373,   372,     0,
       0,     0,     0,     0,   167,   239,   309,   241,    20,     0,
      51,    53,     0,    91,    92,    93,     0,    20,     0,     0,
      97,    19,     0,     0,   220,   222,     0,     0,   310,   242,
       0,     0,     0,   123,   146,     0,   124,   134,     0,   196,
     166,   199,   200,     0,   166,     0,   166,     0,     0,   166,
       0,   125,   159,   156,   157,   158,   155,   160,     0,     0,
     126,   240,     0,     0,   240,     0,     0,     0,   221,    80,
     119,    78,     0,   245,     0,    82,    76,    20,    20,    20,
      20,     0,     0,     0,    20,    20,     0,     0,    96,    98,
       0,     0,     0,   218,   246,   219,   221,    20,     0,   147,
     198,   197,     0,     0,   166,   160,   173,   194,   167,     0,
     193,   203,   204,   166,     0,   171,   170,   166,   168,   176,
     166,   174,   179,   166,   177,     0,     0,     0,   311,   243,
       0,     0,   312,   244,     0,     0,   276,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     223,     0,     0,   160,     0,   195,    20,   191,     0,     0,
     172,   205,   206,   201,   202,   169,   175,   178,     0,   221,
     247,   216,   214,   248,   217,   215,    81,    89,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   224,   225,   148,
       0,    20,   181,     0,     0,    20,     0,   188,    20,     0,
     185,   221,   240,     0,     0,     0,     0,     0,     0,     0,
       0,   149,     0,    20,     0,   180,   192,     0,     0,     0,
       0,     0,     0,    75,   183,     0,     0,   189,     0,   186,
       0,   213,   211,   212,   210,   182,     0,   190,   187,   184
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -693,  -693,   826,  -693,   564,  -693,  -410,  -404,  -693,   334,
       6,  -401,   269,    17,  -116,   917,    75,  -638,  -693,  -693,
    -693,  -693,   218,  -693,   286,  -394,  -390,   728,  -693,   271,
     362,  -523,   353,     5,   196,  -596,  -477,  -476,  -693,  -326,
    -192,  -692,   138,   109,   -50,  -220,  -470,  -387,  -601,  -693,
     152,  -506,     7,  -107,  -491,  -382,  -381,  -114,  -693,   231,
     587,  -693,  -693,    24,    -2,  -693,   906,  -693
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,    91,    92,   382,   383,    93,    94,    95,   587,   588,
     827,    97,   137,   138,   211,   160,   139,   161,   375,    99,
     100,   739,   740,   101,   194,   102,   103,   418,   606,   607,
     676,   677,   696,   123,   105,   697,   698,   699,   830,   831,
     832,   761,   762,   763,   833,   150,   700,   106,   662,   744,
     745,   107,   124,   109,   642,   110,   111,   125,   112,   214,
     215,   126,   127,   128,   195,   114,   115,   116
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     129,   236,   411,   585,   141,   104,    96,   108,   133,   586,
     732,   422,   590,   154,   155,   156,   157,   236,   348,   591,
     354,   758,   140,   592,   113,  -161,   594,   166,   113,   113,
     424,   596,   597,   737,   738,  -161,   758,   169,   170,   171,
     172,   173,   174,   175,   176,   177,   178,   179,   758,   183,
     294,   117,   643,   187,   188,   189,   190,   191,   192,   -21,
     673,  -160,   219,   768,   381,   822,   820,   750,   395,   184,
     185,   186,   693,   -21,   752,    98,   113,   113,   113,   758,
     201,   202,   823,   206,   207,   208,   822,   216,   824,   158,
     759,   478,   -21,   693,   222,   220,   104,    96,   108,   834,
     773,   758,   701,   823,   701,   759,   -21,   784,   773,   824,
    -161,   395,   113,   235,   557,   113,   395,   759,   291,  -160,
     291,   876,  -160,   835,   145,  -161,   297,   298,  -161,   296,
     349,   760,  -161,  -161,   151,  -161,   396,   425,  -161,   479,
     358,   359,   883,  -161,   877,   146,   764,   142,   759,   723,
     223,   147,   825,   754,    67,   834,   754,   808,   766,   131,
     113,  -160,   152,   212,  -160,   380,    98,   224,  -160,  -160,
     759,   746,   143,   825,   196,    67,   144,   585,   374,   838,
     131,   425,   153,   586,   352,   113,   590,   854,   660,   769,
     701,    84,   159,   591,   223,   389,   390,   592,   701,   134,
     594,   224,   826,   227,   618,   596,   597,   228,   330,   661,
    -161,   212,    84,  -161,  -160,   782,   783,  -160,  -161,   774,
     775,  -160,  -160,   836,   402,   407,   776,   774,   775,   167,
     344,   345,   346,   347,   776,   113,   834,   426,   427,   428,
     429,   430,   431,   432,   433,   434,   435,   436,   437,   438,
     439,   440,   441,   442,   443,   444,   445,   446,   447,   923,
     841,   168,   454,   455,   456,   457,   458,   459,   453,   460,
     461,   462,   463,   464,   465,   466,   467,   468,   469,   470,
     471,   472,   473,   475,   476,   229,   394,   568,   922,   162,
     847,   230,   573,   850,   197,   834,   163,   481,   482,   483,
     484,   485,   486,   487,   488,   489,   490,   491,   492,   493,
     494,   495,   496,   497,   498,   499,   500,   501,   502,   844,
     941,    77,   509,   510,   511,   512,   513,   514,   508,   515,
     516,   517,   518,   519,   520,   521,   522,   523,   524,   525,
     526,   527,   528,   530,   531,  -227,  -227,  -161,   817,   911,
    -161,   290,   145,   293,  -161,  -161,   145,   210,   600,   601,
     602,   603,   225,   233,   544,    67,   198,   226,   548,   818,
     131,   819,   912,   146,   552,   553,   554,   146,   113,   147,
     148,   737,   738,   147,   148,   368,   689,   690,   691,   692,
      23,    24,   369,   291,   415,   567,   693,   200,   413,   349,
     915,   416,    84,   414,   349,   210,    31,   569,   221,    33,
      34,   918,   350,   753,   570,   403,   408,   574,   593,   589,
     595,   916,   149,   917,   575,   149,   822,   330,   351,   394,
     360,   942,   919,   693,   920,   364,   365,   689,   690,   691,
     692,    23,    24,   823,   933,   355,   356,   693,   604,   344,
     345,   346,   347,   411,   422,   605,   376,    31,   361,   680,
      33,    34,   180,   145,   181,   934,   681,   935,   362,   182,
     363,   370,   623,   689,   690,   691,   692,    23,    24,   -20,
     393,   779,   388,   693,   146,   233,   391,    67,   236,   582,
     147,   409,   131,    31,   377,   378,    33,    34,   875,    19,
      20,    21,    22,    23,    24,   381,   384,   881,   387,    27,
     145,   881,   -20,   825,   881,    67,   385,   881,   822,    31,
     131,   682,    33,    34,    84,   693,   694,   630,   683,   684,
     386,   146,   618,   410,   635,   823,   685,   147,   420,   686,
     412,   824,   417,   645,   646,   647,   687,   649,   650,   651,
     742,   145,    84,   822,   656,   637,   638,   743,   845,   423,
     693,   452,   113,   113,   689,   690,   691,   692,    23,    24,
     823,   410,   146,   477,   693,   421,   824,   703,   147,   616,
     421,   145,   480,   203,    31,   204,   507,    33,    34,   233,
     205,    67,   593,   589,   595,   236,   583,   533,   536,   145,
     675,   571,   146,   678,   678,   825,   572,    67,   147,   409,
     537,   540,   131,   771,   695,   702,   695,   702,   713,   576,
     146,   617,   514,   393,   577,   716,   147,   420,    84,   514,
     233,   542,    67,   532,   543,   545,   822,   131,   534,   584,
     825,   882,    67,   693,    84,   882,   724,   131,   882,   541,
     549,   882,   231,   823,   546,   839,   448,   449,   550,   824,
     450,   451,    19,    20,    21,   232,    23,    24,   608,    84,
     559,   560,   561,   609,   547,   556,   873,   551,    67,    84,
     756,   678,    31,   131,   678,    33,    34,   562,   565,   598,
     842,   867,   130,   399,    67,    67,   579,   580,   581,   131,
     400,   145,   772,   702,   780,   578,   778,   613,   614,   615,
     772,   702,   297,   298,   837,    84,   840,   822,   599,   843,
     612,   626,   146,   825,   693,    67,   794,   619,   147,   616,
     131,    84,    84,   617,   823,   806,   641,   790,   791,   633,
     824,   132,   401,   610,   113,   113,   795,   903,   611,   796,
     906,   634,   233,   113,    67,   136,   113,   640,   655,   234,
     891,   136,    84,   503,   504,   828,   894,   505,   506,   828,
     136,   828,   136,   880,   828,   951,   669,   953,   688,   297,
     298,   657,   924,   925,   926,   927,   928,   658,   929,   930,
     659,    84,   663,   664,   330,   857,   858,   859,   860,   765,
     767,   770,   864,   865,   825,   666,    67,   822,   341,   342,
     343,   131,   667,   145,   693,   871,   344,   345,   346,   347,
     404,   668,    67,   636,   823,   670,   639,   405,   874,   828,
     824,   113,   706,   707,   777,   708,    67,   725,   828,   709,
     147,   131,   828,    84,   661,   828,   720,   721,   828,   722,
     728,   136,   736,   660,   885,   747,   755,   162,   781,    84,
     786,   330,   787,   788,   665,   789,   797,   810,   807,   406,
     811,   812,   896,    84,   914,   759,   342,   343,   816,   113,
     821,   368,   212,   344,   345,   346,   347,   113,   851,   861,
     113,   113,   855,   862,   825,   863,    67,   768,   705,   878,
     879,   131,   889,   710,   711,   712,   901,   902,   913,   932,
     907,   726,   727,   937,   908,   910,   939,   218,   921,   948,
     931,   672,   113,   113,   113,   113,   113,   113,   113,   113,
     113,   945,   950,    84,   956,   748,   749,   957,   212,   958,
     943,   212,   394,   959,   886,   164,   558,   113,   113,   113,
     113,   113,   113,   113,   113,   751,   829,   809,   419,   757,
     829,   679,   829,   704,   870,   829,    19,    20,    21,   232,
      23,    24,   884,   212,   212,   212,   212,   212,   394,   212,
     212,   394,   566,   199,     0,     0,    31,     0,     0,    33,
      34,     0,   793,     0,     0,   785,   297,   298,     0,   394,
     394,   394,   394,   394,   394,   394,     0,     0,   792,     0,
       0,   295,     0,     0,     0,   813,   814,     0,     0,   815,
     829,    19,    20,    21,   232,    23,    24,     0,     0,   829,
       0,     0,     0,   829,     0,     0,   829,     0,     0,   829,
       0,    31,     0,     0,    33,    34,     0,   674,     0,     0,
       0,   848,   849,     0,     0,   852,   853,    19,    20,    21,
     232,    23,    24,     0,     0,   846,   822,     0,     0,     0,
       0,     0,     0,   693,     0,     0,   210,    31,   330,     0,
      33,    34,     0,   823,     0,     0,     0,     0,     0,   824,
     339,   340,   341,   342,   343,     0,   868,   869,     0,     0,
     344,   345,   346,   347,   872,     0,     0,     0,     0,     0,
       0,   233,     0,    67,     0,     0,   890,     0,   131,   892,
     893,     0,     0,   895,     0,     0,     0,     0,     0,     0,
       0,   888,   210,     0,     0,   210,   393,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   233,     0,    67,
      84,     0,     0,   825,   234,    67,     0,     0,     0,     0,
     131,     0,     0,     0,     0,     0,     0,   210,   210,   210,
     210,   210,   393,   210,   210,   393,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    84,     0,     0,     0,
       0,     0,    84,   393,   393,   393,   393,   393,   393,   393,
       0,     0,   938,   887,     0,   940,     0,     0,     0,     0,
     952,   954,     0,     0,     0,     0,   217,     1,     0,     2,
     946,   -20,     3,     4,     5,     6,     0,     0,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    16,     0,    17,
      18,    19,    20,    21,    22,    23,    24,    25,     0,     0,
      26,    27,    28,     0,   -20,    29,    30,     0,     0,     0,
       0,    31,  -226,    32,    33,    34,  -226,     0,    35,    36,
      37,    38,     0,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    41,    42,    43,    44,    45,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,     0,     0,     0,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
      59,    60,    61,     0,     0,     0,     0,    62,    63,    64,
      65,    66,     0,    67,  -166,    68,    69,    70,    71,  -166,
      72,    73,    74,    75,  -226,    76,    77,    78,     0,     0,
    -226,    79,     0,     0,    80,     0,    81,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    82,    83,     0,
      84,     0,     0,     0,    85,    86,    87,    88,     0,   193,
      89,     0,    90,   -20,     3,     0,     0,     0,     0,     0,
       0,     0,     0,   118,     0,     0,     0,    14,    15,     0,
       0,    17,    18,    19,    20,    21,   119,    23,    24,     0,
       0,     0,     0,     0,     0,     0,   -20,     0,     0,     0,
       0,     0,     0,    31,     0,     0,    33,    34,     0,     0,
      35,    36,    37,    38,     0,    39,    40,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    41,    42,    43,
      44,    45,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,     0,
       0,    48,    49,    50,    51,     0,     0,     0,    55,    56,
      57,    58,    59,    60,    61,     0,     0,     0,     0,    62,
      63,    64,    65,    66,   120,    67,  -166,    68,    69,    70,
     121,  -166,    72,    73,    74,    75,     0,    76,    77,    78,
       0,     0,     0,    79,     0,     0,    80,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    82,
      83,     0,    84,     0,     0,     0,    85,    86,    87,   122,
       0,     0,    89,     0,     1,  -120,     2,     0,   -20,     3,
       4,     5,     6,     0,     0,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,    22,    23,    24,    25,     0,     0,    26,    27,    28,
       0,   -20,    29,    30,     0,     0,     0,     0,    31,  -226,
      32,    33,    34,  -226,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,     0,    62,    63,    64,    65,    66,     0,
      67,  -166,    68,    69,    70,    71,  -166,    72,    73,    74,
      75,  -226,    76,    77,    78,     0,     0,  -226,    79,     0,
       0,    80,     0,    81,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    82,    83,     0,    84,     0,     0,
       0,    85,    86,    87,    88,     0,     1,    89,     2,    90,
     -20,     3,     4,     5,     6,     0,   371,     7,     8,     9,
     118,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   119,    23,    24,    25,   372,   373,    26,
       0,    28,     0,   -20,    29,    30,     0,     0,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
      66,     0,    67,  -166,    68,    69,    70,   135,  -166,    72,
      73,    74,    75,     0,    76,    77,    78,     0,     0,     0,
      79,     0,     0,    80,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    82,    83,     0,    84,
       0,     0,     0,    85,    86,    87,   136,     0,     1,    89,
       2,    90,   -20,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   118,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   119,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,  -118,  -118,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,    66,     0,    67,  -166,    68,    69,    70,   135,
    -166,    72,    73,    74,    75,     0,    76,    77,    78,     0,
       0,     0,    79,     0,     0,    80,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    82,    83,
       0,    84,     0,     0,     0,    85,    86,    87,   136,     0,
       0,    89,  -118,    90,     1,     0,     2,     0,   -20,     3,
       4,     5,     6,     0,     0,     7,     8,     9,   118,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,   119,    23,    24,    25,     0,     0,    26,     0,    28,
       0,   -20,    29,    30,  -114,  -114,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,     0,    62,    63,    64,    65,    66,     0,
      67,  -166,    68,    69,    70,   135,  -166,    72,    73,    74,
      75,     0,    76,    77,    78,     0,     0,     0,    79,     0,
       0,    80,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    82,    83,     0,    84,     0,     0,
       0,    85,    86,    87,   136,     0,     0,    89,  -114,    90,
       1,     0,     2,     0,   -20,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   118,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,    20,    21,   119,    23,    24,
      25,     0,     0,    26,     0,    28,     0,   -20,    29,    30,
    -116,  -116,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,    37,    38,     0,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,    42,
      43,    44,    45,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,     0,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,     0,     0,     0,     0,
      62,    63,    64,    65,    66,     0,    67,  -166,    68,    69,
      70,   135,  -166,    72,    73,    74,    75,     0,    76,    77,
      78,     0,     0,     0,    79,     0,     0,    80,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      82,    83,     0,    84,     0,     0,     0,    85,    86,    87,
     136,     0,     0,    89,  -116,    90,     1,     0,     2,     0,
     -20,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     118,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   119,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,  -117,  -117,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
      66,     0,    67,  -166,    68,    69,    70,   135,  -166,    72,
      73,    74,    75,     0,    76,    77,    78,     0,     0,     0,
      79,     0,     0,    80,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    82,    83,     0,    84,
       0,     0,     0,    85,    86,    87,   136,     0,     0,    89,
    -117,    90,     1,     0,     2,     0,   -20,     3,     4,     5,
       6,     0,     0,     7,     8,     9,   118,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,    20,    21,   119,
      23,    24,    25,     0,     0,    26,     0,    28,     0,   -20,
      29,    30,  -104,  -104,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,    37,    38,     0,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,    42,    43,    44,    45,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,     0,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,     0,     0,
       0,     0,    62,    63,    64,    65,    66,     0,    67,  -166,
      68,    69,    70,   135,  -166,    72,    73,    74,    75,     0,
      76,    77,    78,     0,     0,     0,    79,     0,     0,    80,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    82,    83,     0,    84,     0,     0,     0,    85,
      86,    87,   136,     0,     0,    89,  -104,    90,     1,     0,
       2,     0,   -20,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   118,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   119,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,  -102,  -102,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,    66,     0,    67,  -166,    68,    69,    70,   135,
    -166,    72,    73,    74,    75,     0,    76,    77,    78,     0,
       0,     0,    79,     0,     0,    80,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    82,    83,
       0,    84,     0,     0,     0,    85,    86,    87,   136,     0,
       0,    89,  -102,    90,     1,     0,     2,     0,   -20,     3,
       4,     5,     6,     0,     0,     7,     8,     9,   118,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,   119,    23,    24,    25,     0,     0,    26,     0,    28,
       0,   -20,    29,    30,  -100,  -100,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,     0,    62,    63,    64,    65,    66,     0,
      67,  -166,    68,    69,    70,   135,  -166,    72,    73,    74,
      75,     0,    76,    77,    78,     0,     0,     0,    79,     0,
       0,    80,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    82,    83,     0,    84,     0,     0,
       0,    85,    86,    87,   136,     0,     0,    89,  -100,    90,
       1,     0,     2,     0,   -20,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   118,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,    20,    21,   119,    23,    24,
      25,     0,     0,    26,     0,    28,     0,   -20,    29,    30,
    -110,  -110,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,    37,    38,     0,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,    42,
      43,    44,    45,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,     0,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,     0,     0,     0,     0,
      62,    63,    64,    65,    66,     0,    67,  -166,    68,    69,
      70,   135,  -166,    72,    73,    74,    75,     0,    76,    77,
      78,     0,     0,     0,    79,     0,     0,    80,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      82,    83,     0,    84,     0,     0,     0,    85,    86,    87,
     136,     0,     0,    89,  -110,    90,     1,     0,     2,     0,
     -20,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     118,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   119,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,  -112,  -112,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
      66,     0,    67,  -166,    68,    69,    70,   135,  -166,    72,
      73,    74,    75,     0,    76,    77,    78,     0,     0,     0,
      79,     0,     0,    80,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    82,    83,     0,    84,
       0,     0,     0,    85,    86,    87,   136,     0,     0,    89,
    -112,    90,     1,     0,     2,     0,   -20,     3,     4,     5,
       6,     0,     0,     7,     8,     9,   118,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,    20,    21,   119,
      23,    24,    25,     0,     0,    26,     0,    28,     0,   -20,
      29,    30,  -113,  -113,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,    37,    38,     0,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,    42,    43,    44,    45,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,     0,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,     0,     0,
       0,     0,    62,    63,    64,    65,    66,     0,    67,  -166,
      68,    69,    70,   135,  -166,    72,    73,    74,    75,     0,
      76,    77,    78,     0,     0,     0,    79,     0,     0,    80,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    82,    83,     0,    84,     0,     0,     0,    85,
      86,    87,   136,     0,     0,    89,  -113,    90,     1,     0,
       2,     0,   -20,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   118,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   119,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,  -106,  -106,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,    66,     0,    67,  -166,    68,    69,    70,   135,
    -166,    72,    73,    74,    75,     0,    76,    77,    78,     0,
       0,     0,    79,     0,     0,    80,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    82,    83,
       0,    84,     0,     0,     0,    85,    86,    87,   136,     0,
       0,    89,  -106,    90,     1,     0,     2,     0,   -20,     3,
       4,     5,     6,     0,     0,     7,     8,     9,   118,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,   119,    23,    24,    25,     0,     0,    26,     0,    28,
       0,   -20,    29,    30,  -108,  -108,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,     0,    62,    63,    64,    65,    66,     0,
      67,  -166,    68,    69,    70,   135,  -166,    72,    73,    74,
      75,     0,    76,    77,    78,     0,     0,     0,    79,     0,
       0,    80,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    82,    83,     0,    84,     0,     0,
       0,    85,    86,    87,   136,     0,     0,    89,  -108,    90,
       1,     0,     2,     0,   -20,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   118,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,    20,    21,   119,    23,    24,
      25,     0,     0,    26,     0,    28,     0,   -20,    29,    30,
    -115,  -115,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,    37,    38,     0,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,    42,
      43,    44,    45,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,     0,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,     0,     0,     0,     0,
      62,    63,    64,    65,    66,     0,    67,  -166,    68,    69,
      70,   135,  -166,    72,    73,    74,    75,     0,    76,    77,
      78,     0,     0,     0,    79,     0,     0,    80,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      82,    83,     0,    84,     0,     0,     0,    85,    86,    87,
     136,     0,     0,    89,  -115,    90,     1,     0,     2,     0,
     -20,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     118,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   119,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,  -103,  -103,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
      66,     0,    67,  -166,    68,    69,    70,   135,  -166,    72,
      73,    74,    75,     0,    76,    77,    78,     0,     0,     0,
      79,     0,     0,    80,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    82,    83,     0,    84,
       0,     0,     0,    85,    86,    87,   136,     0,     0,    89,
    -103,    90,     1,     0,     2,     0,   -20,     3,     4,     5,
       6,     0,     0,     7,     8,     9,   118,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,    20,    21,   119,
      23,    24,    25,     0,     0,    26,     0,    28,     0,   -20,
      29,    30,  -101,  -101,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,    37,    38,     0,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,    42,    43,    44,    45,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,     0,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,     0,     0,
       0,     0,    62,    63,    64,    65,    66,     0,    67,  -166,
      68,    69,    70,   135,  -166,    72,    73,    74,    75,     0,
      76,    77,    78,     0,     0,     0,    79,     0,     0,    80,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    82,    83,     0,    84,     0,     0,     0,    85,
      86,    87,   136,     0,     0,    89,  -101,    90,     1,     0,
       2,     0,   -20,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   118,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   119,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,   -99,   -99,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,    66,     0,    67,  -166,    68,    69,    70,   135,
    -166,    72,    73,    74,    75,     0,    76,    77,    78,     0,
       0,     0,    79,     0,     0,    80,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    82,    83,
       0,    84,     0,     0,     0,    85,    86,    87,   136,     0,
       0,    89,   -99,    90,     1,     0,     2,     0,   -20,     3,
       4,     5,     6,     0,     0,     7,     8,     9,   118,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,   119,    23,    24,    25,     0,     0,    26,     0,    28,
       0,   -20,    29,    30,  -109,  -109,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,     0,    62,    63,    64,    65,    66,     0,
      67,  -166,    68,    69,    70,   135,  -166,    72,    73,    74,
      75,     0,    76,    77,    78,     0,     0,     0,    79,     0,
       0,    80,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    82,    83,     0,    84,     0,     0,
       0,    85,    86,    87,   136,     0,     0,    89,  -109,    90,
       1,     0,     2,     0,   -20,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   118,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,    20,    21,   119,    23,    24,
      25,     0,     0,    26,     0,    28,     0,   -20,    29,    30,
    -111,  -111,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,    37,    38,     0,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,    42,
      43,    44,    45,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,     0,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,     0,     0,     0,     0,
      62,    63,    64,    65,    66,     0,    67,  -166,    68,    69,
      70,   135,  -166,    72,    73,    74,    75,     0,    76,    77,
      78,     0,     0,     0,    79,     0,     0,    80,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      82,    83,     0,    84,     0,     0,     0,    85,    86,    87,
     136,     0,     0,    89,  -111,    90,     1,     0,     2,     0,
     -20,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     118,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   119,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,  -105,  -105,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
      66,     0,    67,  -166,    68,    69,    70,   135,  -166,    72,
      73,    74,    75,     0,    76,    77,    78,     0,     0,     0,
      79,     0,     0,    80,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    82,    83,     0,    84,
       0,     0,     0,    85,    86,    87,   136,     0,     0,    89,
    -105,    90,     1,     0,     2,     0,   -20,     3,     4,     5,
       6,     0,     0,     7,     8,     9,   118,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,    20,    21,   119,
      23,    24,    25,     0,     0,    26,     0,    28,     0,   -20,
      29,    30,  -107,  -107,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,    37,    38,     0,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,    42,    43,    44,    45,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,     0,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,     0,     0,
       0,     0,    62,    63,    64,    65,    66,     0,    67,  -166,
      68,    69,    70,   135,  -166,    72,    73,    74,    75,     0,
      76,    77,    78,     0,     0,     0,    79,     0,     0,    80,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    82,    83,     0,    84,     0,     0,     0,    85,
      86,    87,   136,     0,     0,    89,  -107,    90,     1,     0,
       2,     0,   -20,     3,     4,     5,     6,     0,     0,     7,
       8,     9,   118,    11,    12,    13,    14,    15,    16,     0,
      17,    18,    19,    20,    21,   119,    23,    24,    25,     0,
       0,    26,     0,    28,     0,   -20,    29,    30,     0,     0,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,    66,     0,    67,  -166,    68,    69,    70,   135,
    -166,    72,    73,    74,    75,     0,    76,    77,    78,     0,
       0,     0,    79,     0,     0,    80,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    82,    83,
       0,    84,     0,     0,     0,    85,    86,    87,   136,     0,
       0,    89,   209,    90,     1,     0,     2,     0,   -20,     3,
       4,     5,     6,     0,     0,     7,     8,     9,   118,    11,
      12,    13,    14,    15,    16,     0,    17,    18,    19,    20,
      21,   119,    23,    24,    25,     0,     0,    26,     0,    28,
       0,   -20,    29,    30,     0,     0,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,     0,    62,    63,    64,    65,    66,     0,
      67,  -166,    68,    69,    70,   135,  -166,    72,    73,    74,
      75,     0,    76,    77,    78,     0,     0,     0,    79,     0,
       0,    80,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    82,    83,     0,    84,     0,     0,
       0,    85,    86,    87,   136,     0,     0,    89,   353,    90,
       1,     0,     2,     0,   -20,     3,     4,     5,     6,     0,
       0,     7,     8,     9,   118,    11,    12,    13,    14,    15,
      16,     0,    17,    18,    19,    20,    21,   119,    23,    24,
      25,     0,     0,    26,     0,    28,     0,   -20,    29,    30,
       0,     0,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,    37,    38,     0,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,    42,
      43,    44,    45,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,     0,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    61,     0,     0,     0,     0,
      62,    63,    64,    65,    66,     0,    67,  -166,    68,    69,
      70,   135,  -166,    72,    73,    74,    75,     0,    76,    77,
      78,     0,     0,     0,    79,     0,     0,    80,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      82,    83,     0,    84,     0,     0,     0,    85,    86,    87,
     136,     0,     0,    89,   392,    90,     1,     0,     2,     0,
     -20,     3,     4,     5,     6,     0,     0,     7,     8,     9,
     118,    11,    12,    13,    14,    15,    16,     0,    17,    18,
      19,    20,    21,   119,    23,    24,    25,     0,     0,    26,
       0,    28,     0,   -20,    29,    30,     0,     0,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
      66,     0,    67,  -166,    68,    69,    70,   135,  -166,    72,
      73,    74,    75,     0,    76,    77,    78,     0,     0,     0,
      79,     0,     0,    80,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    82,    83,     0,    84,
       0,     0,     0,    85,    86,    87,   136,     0,     0,    89,
     535,    90,     1,     0,     2,     0,   -20,     3,     4,     5,
       6,     0,     0,     7,     8,     9,   118,    11,    12,    13,
      14,    15,    16,     0,    17,    18,    19,    20,    21,   119,
      23,    24,    25,     0,     0,    26,     0,    28,     0,   -20,
      29,    30,     0,     0,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,    37,    38,     0,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,    42,    43,    44,    45,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,     0,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,     0,     0,
       0,     0,    62,    63,    64,    65,    66,     0,    67,  -166,
      68,    69,    70,   135,  -166,    72,    73,    74,    75,     0,
      76,    77,    78,     0,     0,     0,    79,     0,     0,    80,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    82,    83,     0,    84,     0,     0,     0,    85,
      86,    87,   136,     0,   193,    89,     0,    90,   -20,     3,
       0,     0,     0,     0,     0,     0,     0,     0,   118,     0,
       0,     0,    14,    15,     0,     0,    17,    18,    19,    20,
      21,   119,    23,    24,     0,     0,     0,     0,     0,     0,
       0,   -20,     0,     0,     0,     0,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
       0,     0,     0,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,     0,    62,    63,    64,    65,    66,   120,
      67,  -166,    68,    69,    70,   121,  -166,    72,    73,    74,
      75,     0,    76,    77,    78,     0,     0,     0,    79,     0,
       0,    80,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    82,    83,     0,    84,     0,     3,
       0,    85,    86,    87,   122,     0,     0,    89,   118,  -120,
       0,     0,    14,    15,     0,     0,    17,    18,    19,    20,
      21,   119,    23,    24,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
       0,     0,     0,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,     0,    62,    63,    64,    65,    66,   120,
      67,  -166,    68,    69,    70,   121,  -166,    72,    73,    74,
      75,     0,    76,    77,    78,     0,     0,     0,    79,     0,
       0,    80,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    82,    83,     3,    84,     0,     0,
       0,    85,    86,    87,   122,   118,     0,    89,     0,    14,
      15,   622,     0,    17,    18,    19,    20,    21,   119,    23,
      24,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    31,     0,     0,    33,    34,
       0,     0,    35,    36,    37,    38,     0,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,    48,    49,    50,    51,     0,     0,     0,
      55,    56,    57,    58,    59,    60,    61,     0,     0,     0,
       0,    62,    63,    64,    65,    66,   120,    67,  -166,    68,
      69,    70,   121,  -166,    72,    73,    74,    75,     0,    76,
      77,    78,     0,     0,     0,    79,     0,     0,    80,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    82,    83,     3,    84,     0,     0,     0,    85,    86,
      87,   122,   118,     0,    89,     0,    14,    15,   629,     0,
      17,    18,    19,    20,    21,   119,    23,    24,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    31,     0,     0,    33,    34,     0,     0,    35,
      36,    37,    38,     0,    39,    40,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    41,    42,    43,    44,
      45,    46,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
      48,    49,    50,    51,     0,     0,     0,    55,    56,    57,
      58,    59,    60,    61,     0,     0,     0,     0,    62,    63,
      64,    65,    66,   120,    67,  -166,    68,    69,    70,   121,
    -166,    72,    73,    74,    75,     0,    76,    77,    78,     0,
       0,     0,    79,     0,     0,    80,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    82,    83,
       3,    84,     0,     0,     0,    85,    86,    87,   122,   118,
       0,    89,     0,    14,    15,   715,     0,    17,    18,    19,
      20,    21,   119,    23,    24,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    31,
       0,     0,    33,    34,     0,     0,    35,    36,    37,    38,
       0,    39,    40,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    41,    42,    43,    44,    45,    46,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    47,     0,     0,     0,    48,    49,    50,
      51,     0,     0,     0,    55,    56,    57,    58,    59,    60,
      61,     0,     0,     0,     0,    62,    63,    64,    65,    66,
     120,    67,  -166,    68,    69,    70,   121,  -166,    72,    73,
      74,    75,     0,    76,    77,    78,     0,     0,     0,    79,
       0,     0,    80,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    82,    83,     3,    84,     0,
       0,     0,    85,    86,    87,   122,   118,     0,    89,     0,
      14,    15,   718,     0,    17,    18,    19,    20,    21,   119,
      23,    24,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,    37,    38,     0,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,    42,    43,    44,    45,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,     0,    48,    49,    50,    51,     0,     0,
       0,    55,    56,    57,    58,    59,    60,    61,     0,     0,
       0,     0,    62,    63,    64,    65,    66,   120,    67,  -166,
      68,    69,    70,   121,  -166,    72,    73,    74,    75,     0,
      76,    77,    78,     0,     0,     0,    79,     0,     0,    80,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    82,    83,     0,    84,     0,     3,     0,    85,
      86,    87,   122,     0,     0,    89,   118,     0,   213,     0,
      14,    15,     0,     0,    17,    18,    19,    20,    21,   119,
      23,    24,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,    37,    38,     0,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,    42,    43,    44,    45,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,     0,    48,    49,    50,    51,     0,     0,
       0,    55,    56,    57,    58,    59,    60,    61,     0,     0,
       0,     0,    62,    63,    64,    65,    66,   120,    67,  -166,
      68,    69,    70,   121,  -166,    72,    73,    74,    75,     0,
      76,    77,    78,     0,     0,     0,    79,     0,     0,    80,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    82,    83,     0,    84,     0,     3,     0,    85,
      86,    87,   122,     0,     0,    89,   118,   -94,     0,     0,
      14,    15,     0,     0,    17,    18,    19,    20,    21,   119,
      23,    24,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    31,     0,     0,    33,
      34,     0,     0,    35,    36,    37,    38,     0,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      41,    42,    43,    44,    45,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,     0,    48,    49,    50,    51,     0,     0,
       0,    55,    56,    57,    58,    59,    60,    61,     0,     0,
       0,     0,    62,    63,    64,    65,    66,   120,    67,  -166,
      68,    69,    70,   121,  -166,    72,    73,    74,    75,     0,
      76,    77,    78,     0,     0,     0,    79,     0,     0,    80,
       0,     0,     0,     0,     0,     0,     0,     0,   -20,     0,
       0,     0,    82,    83,     0,    84,     0,     0,   582,    85,
      86,    87,   122,     0,     0,    89,     0,   165,    19,    20,
      21,    22,    23,    24,     0,     0,     0,     0,    27,     0,
       0,   -20,     0,     0,     0,     0,     0,     0,    31,     0,
       0,    33,    34,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   -20,     3,     0,     0,     0,     0,     0,
       0,     0,     0,   118,     0,     0,     0,    14,    15,     0,
       0,    17,    18,    19,    20,    21,   119,    23,    24,     0,
       0,     0,     0,     0,     0,     0,   -20,     0,     0,     0,
       0,     0,     0,    31,     0,     0,    33,    34,     0,     0,
      35,    36,    37,    38,     0,    39,    40,     0,   233,     0,
      67,     0,     0,     0,     0,   583,     0,    41,    42,    43,
      44,    45,    46,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,     0,
       0,    48,    49,    50,    51,     0,     0,    84,    55,    56,
      57,    58,    59,    60,    61,     0,     0,     0,   671,    62,
      63,    64,    65,    66,   120,    67,  -166,    68,    69,    70,
     121,  -166,    72,    73,    74,    75,     0,    76,    77,    78,
       0,     0,     0,    79,     0,     0,    80,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    82,
      83,     3,    84,     0,     0,     0,    85,    86,    87,   122,
     118,     0,    89,     0,    14,    15,     0,     0,    17,    18,
      19,    20,    21,   119,    23,    24,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      31,     0,     0,    33,    34,     0,     0,    35,    36,    37,
      38,     0,    39,    40,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    41,    42,    43,    44,    45,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,    48,    49,
      50,    51,     0,     0,     0,    55,    56,    57,    58,    59,
      60,    61,     0,     0,     0,     0,    62,    63,    64,    65,
      66,   120,    67,  -166,    68,    69,    70,   121,  -166,    72,
      73,    74,    75,     0,    76,    77,    78,     0,     0,     0,
      79,     0,     0,    80,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    82,    83,     3,    84,
       0,     0,     0,    85,    86,    87,   122,   118,     0,    89,
     289,    14,    15,     0,     0,    17,    18,    19,    20,    21,
     119,    23,    24,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    31,     0,     0,
      33,    34,     0,     0,    35,    36,    37,    38,     0,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    41,    42,    43,    44,    45,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,    48,    49,    50,    51,     0,
       0,     0,    55,    56,    57,    58,    59,    60,    61,     0,
       0,     0,     0,    62,    63,    64,    65,    66,   120,    67,
    -166,    68,    69,    70,   121,  -166,    72,    73,    74,    75,
       0,    76,    77,    78,     0,     0,     0,    79,     0,     0,
      80,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    82,    83,     3,    84,     0,     0,     0,
      85,    86,    87,   122,   118,     0,    89,   292,    14,    15,
       0,     0,    17,    18,    19,    20,    21,   119,    23,    24,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    31,     0,     0,    33,    34,     0,
       0,    35,    36,    37,    38,     0,    39,    40,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    41,    42,
      43,    44,    45,    46,     0,     0,     0,     0,     0,   798,
       0,   799,   800,     0,     0,     0,   801,   802,    47,     0,
       0,     0,    48,    49,    50,    51,     0,     0,     0,    55,
      56,    57,    58,    59,    60,    61,     0,     0,     0,     0,
      62,    63,    64,    65,    66,   120,    67,  -166,    68,    69,
      70,   121,  -166,    72,    73,    74,    75,     0,    76,    77,
      78,     0,     0,     0,    79,   803,     0,    80,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   804,   805,
      82,    83,     3,    84,     0,     0,     0,    85,    86,    87,
     122,   118,     0,    89,     0,    14,    15,     0,     0,    17,
      18,    19,    20,    21,   119,    23,    24,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    31,     0,     0,    33,    34,     0,     0,    35,    36,
      37,    38,     0,    39,    40,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    41,    42,    43,    44,    45,
      46,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,     0,     0,     0,    48,
      49,    50,    51,     0,     0,     0,    55,    56,    57,    58,
      59,    60,    61,     0,     0,     0,   474,    62,    63,    64,
      65,    66,   120,    67,  -166,    68,    69,    70,   121,  -166,
      72,    73,    74,    75,     0,    76,    77,    78,     0,     0,
       0,    79,     0,     0,    80,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    82,    83,     3,
      84,     0,     0,     0,    85,    86,    87,   122,   118,     0,
      89,     0,    14,    15,     0,     0,    17,    18,    19,    20,
      21,   119,    23,    24,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    31,     0,
       0,    33,    34,     0,     0,    35,    36,    37,    38,     0,
      39,    40,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    41,    42,    43,    44,    45,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    47,     0,     0,     0,    48,    49,    50,    51,
       0,     0,     0,    55,    56,    57,    58,    59,    60,    61,
       0,     0,     0,   529,    62,    63,    64,    65,    66,   120,
      67,  -166,    68,    69,    70,   121,  -166,    72,    73,    74,
      75,     0,    76,    77,    78,     0,     0,     0,    79,     0,
       0,    80,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    82,    83,     3,    84,     0,     0,
       0,    85,    86,    87,   122,   118,     0,    89,     0,    14,
      15,     0,     0,    17,    18,    19,    20,    21,   119,    23,
      24,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    31,     0,     0,    33,    34,
       0,     0,    35,    36,    37,    38,     0,    39,    40,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
      42,    43,    44,    45,    46,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,    48,    49,    50,    51,     0,     0,     0,
      55,    56,    57,    58,    59,    60,    61,     0,     0,     0,
       0,    62,    63,    64,    65,    66,   120,    67,  -166,    68,
      69,    70,   121,  -166,    72,    73,    74,    75,   644,    76,
      77,    78,     0,     0,     0,    79,   297,   298,    80,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    82,    83,     0,    84,     0,     0,     0,    85,    86,
      87,   122,     0,     0,    89,     0,     0,     0,     0,   323,
     324,   325,     0,     0,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,     0,     0,     0,     0,
       0,     0,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,     0,   323,   324,   325,
       0,     0,     0,     0,     0,     0,     0,     0,   330,     0,
       0,     0,     0,     0,   326,   327,   328,   329,     0,     0,
     339,   340,   341,   342,   343,     0,     0,     0,     0,     0,
     344,   345,   346,   347,     0,     0,     0,   366,     0,     0,
       0,     0,     0,     0,     0,     0,   330,     0,     0,   331,
     332,   333,     0,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,     0,     0,     0,     0,     0,   344,   345,
     346,   347,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,     0,     0,     0,     0,     0,     0,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,     0,   323,   324,   325,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   326,   327,   328,   329,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   367,     0,     0,     0,     0,
       0,     0,     0,     0,   330,     0,     0,   331,   332,   333,
       0,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,     0,     0,     0,     0,     0,   344,   345,   346,   347,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,     0,     0,     0,     0,     0,     0,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,     0,   323,   324,   325,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     326,   327,   328,   329,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   330,     0,     0,   331,   332,   333,     0,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,     0,
       0,     0,     0,     0,   344,   345,   346,   347,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
       0,     0,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
       0,   323,   324,   325,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   326,   327,
     328,   624,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     330,     0,     0,   331,   332,   333,     0,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,     0,     0,     0,
       0,     0,   344,   345,   346,   347,     0,     0,     0,   625,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,     0,     0,     0,     0,     0,     0,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,     0,   323,   324,   325,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     326,   327,   328,   631,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   330,     0,     0,   331,   332,   333,     0,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,     0,
       0,     0,     0,     0,   344,   345,   346,   347,     0,     0,
       0,   632,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,     0,     0,     0,     0,     0,     0,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,     0,   323,   324,   325,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   326,   327,   328,   329,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   330,     0,     0,   331,   332,   333,
       0,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,     0,     0,     0,     0,     0,   344,   345,   346,   347,
       0,     0,     0,   714,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,     0,     0,     0,     0,
       0,     0,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,     0,   323,   324,   325,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   326,   327,   328,   329,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   330,     0,     0,   331,
     332,   333,     0,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,     0,     0,     0,     0,     0,   344,   345,
     346,   347,     0,     0,     0,   717,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,     0,     0,
       0,     0,     0,     0,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,     0,   323,
     324,   325,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   326,   327,   328,   329,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   330,     0,
       0,   331,   332,   333,   397,   334,   335,   336,   337,   338,
     339,   340,   341,   342,   343,     0,     0,     0,     0,     0,
     344,   345,   346,   347,     0,     0,   398,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,     0,
       0,     0,     0,     0,     0,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,     0,
     323,   324,   325,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   326,   327,   328,
     329,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   330,
       0,     0,   331,   332,   333,     0,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,     0,     0,     0,     0,
       0,   344,   345,   346,   347,     0,     0,   538,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
       0,     0,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
       0,   323,   324,   325,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   326,   327,
     328,   329,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     330,     0,     0,   331,   332,   333,     0,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,     0,     0,     0,
       0,     0,   344,   345,   346,   347,     0,     0,   539,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,     0,     0,     0,     0,     0,     0,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,     0,   323,   324,   325,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   326,
     327,   328,   329,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   330,     0,     0,   331,   332,   333,     0,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,     0,     0,
       0,     0,     0,   344,   345,   346,   347,     0,     0,   555,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,     0,     0,     0,     0,     0,     0,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,     0,   323,   324,   325,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     326,   327,   328,   329,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   330,     0,     0,   331,   332,   333,     0,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,     0,
       0,     0,     0,     0,   344,   345,   346,   347,     0,     0,
     563,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,     0,     0,     0,     0,     0,     0,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,     0,   323,   324,   325,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   326,   327,   328,   329,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   330,     0,     0,   331,   332,   333,     0,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,     0,     0,     0,   344,   345,   346,   347,     0,
       0,   564,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,     0,     0,     0,     0,     0,     0,
     309,   310,   311,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,     0,   323,   324,   325,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   326,   327,   328,   329,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   330,     0,     0,   331,   332,   333,
       0,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,     0,     0,     0,     0,     0,   344,   345,   346,   347,
       0,     0,   648,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,     0,     0,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,     0,   323,   324,   325,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   326,   327,   328,   329,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   330,     0,     0,   331,   332,
     333,     0,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,     0,     0,     0,     0,     0,   344,   345,   346,
     347,     0,     0,   654,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,     0,     0,     0,     0,
       0,     0,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,     0,   323,   324,   325,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   326,   327,   328,   329,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   330,     0,     0,   331,
     332,   333,     0,   334,   335,   336,   337,   338,   339,   340,
     341,   342,   343,     0,     0,     0,     0,     0,   344,   345,
     346,   347,     0,     0,   719,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,     0,     0,     0,
       0,     0,     0,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,     0,   323,   324,
     325,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   326,   327,   328,   329,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   330,     0,     0,
     331,   332,   333,     0,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,     0,     0,     0,     0,     0,   344,
     345,   346,   347,     0,     0,   729,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,     0,     0,
       0,     0,     0,     0,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,     0,   323,
     324,   325,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   326,   327,   328,   329,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   330,     0,
       0,   331,   332,   333,     0,   334,   335,   336,   337,   338,
     339,   340,   341,   342,   343,     0,     0,     0,     0,     0,
     344,   345,   346,   347,     0,     0,   733,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,     0,
       0,     0,     0,     0,     0,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,     0,
     323,   324,   325,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   326,   327,   328,
     329,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   330,
       0,     0,   331,   332,   333,     0,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,     0,     0,     0,     0,
       0,   344,   345,   346,   347,     0,     0,   734,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
       0,     0,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
       0,   323,   324,   325,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   326,   327,
     328,   329,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     330,     0,     0,   331,   332,   333,     0,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,     0,     0,     0,
       0,     0,   344,   345,   346,   347,     0,     0,   735,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,     0,     0,     0,     0,     0,     0,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,     0,   323,   324,   325,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   326,
     327,   328,   329,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   330,     0,     0,   331,   332,   333,     0,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,     0,     0,
       0,     0,     0,   344,   345,   346,   347,     0,     0,   856,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,     0,     0,     0,     0,     0,     0,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,     0,   323,   324,   325,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     326,   327,   328,   329,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   330,     0,     0,   331,   332,   333,     0,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,     0,
       0,     0,     0,     0,   344,   345,   346,   347,     0,     0,
     897,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,     0,     0,     0,     0,     0,     0,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,     0,   263,   264,   265,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   266,   267,   268,   269,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   270,     0,     0,   271,   272,   273,     0,
     274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
       0,     0,     0,     0,     0,   284,   285,   286,   287,     0,
     288,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,     0,     0,     0,     0,     0,     0,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,     0,   323,   324,   325,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   326,   327,   328,   329,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   330,     0,     0,   331,   332,   333,     0,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,     0,     0,     0,   344,   345,   346,   347,     0,
     357,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,     0,     0,     0,     0,     0,     0,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,     0,   323,   324,   325,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   326,   327,   328,   329,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   330,     0,     0,   331,   332,   333,     0,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,     0,     0,     0,   344,   345,   346,   347,     0,
     379,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,     0,     0,     0,     0,     0,     0,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,     0,   323,   324,   325,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   326,   327,   328,   329,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   330,     0,     0,   331,   332,   333,     0,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,     0,     0,     0,   344,   345,   346,   347,     0,
     652,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,     0,     0,     0,     0,     0,     0,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,     0,   323,   324,   325,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   326,   327,   328,   329,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   330,     0,     0,   331,   332,   333,     0,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,     0,     0,     0,   344,   345,   346,   347,     0,
     653,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,     0,     0,     0,     0,     0,     0,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,     0,   323,   324,   325,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   326,   327,   328,   329,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   330,     0,     0,   331,   332,   333,     0,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,     0,     0,     0,   344,   345,   346,   347,     0,
     730,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,     0,     0,     0,     0,     0,     0,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,     0,   323,   324,   325,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   326,   327,   328,   329,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   330,     0,     0,   331,   332,   333,     0,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,     0,     0,     0,   344,   345,   346,   347,     0,
     731,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,     0,     0,     0,     0,     0,     0,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,     0,   323,   324,   325,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   326,   327,   328,   329,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   330,     0,     0,   331,   332,   333,     0,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,     0,     0,     0,   344,   345,   346,   347,     0,
     741,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,     0,     0,     0,     0,     0,     0,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,     0,   323,   324,   325,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   326,   327,   328,   329,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   330,     0,     0,   331,   332,   333,     0,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,     0,     0,     0,   344,   345,   346,   347,     0,
     909,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,     0,     0,     0,     0,     0,     0,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,     0,   323,   324,   325,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   326,   327,   328,   329,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   330,     0,     0,   331,   332,   333,     0,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,     0,     0,     0,   344,   345,   346,   347,     0,
     936,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,     0,     0,     0,     0,     0,     0,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,     0,   323,   324,   325,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   326,   327,   328,   329,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   330,     0,     0,   331,   332,   333,     0,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,     0,     0,     0,   344,   345,   346,   347,     0,
     944,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,     0,     0,     0,     0,     0,     0,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,     0,   323,   324,   325,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   326,   327,   328,   329,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   330,     0,     0,   331,   332,   333,     0,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,     0,     0,     0,   344,   345,   346,   347,     0,
     947,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,     0,     0,     0,     0,     0,     0,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,     0,   323,   324,   325,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   326,   327,   328,   329,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   330,     0,     0,   331,   332,   333,     0,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,     0,     0,     0,   344,   345,   346,   347,     0,
     949,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,     0,     0,     0,     0,     0,     0,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,     0,   323,   324,   325,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   326,   327,   328,   329,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   330,     0,     0,   331,   332,   333,     0,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,     0,     0,     0,   344,   345,   346,   347,     0,
     955,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,     0,     0,     0,     0,     0,     0,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,     0,   323,   324,   325,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   326,   327,   328,   329,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   330,     0,     0,   331,   332,   333,     0,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,     0,     0,     0,   344,   345,   346,   347,   621,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,     0,     0,     0,     0,     0,     0,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,     0,   323,   324,   325,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     326,   327,   328,   329,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   330,     0,     0,   331,   332,   333,     0,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,     0,
       0,     0,     0,     0,   344,   345,   346,   347,   628,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,     0,     0,     0,     0,     0,     0,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,     0,   323,   324,   325,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   326,
     327,   328,   329,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   330,     0,     0,   331,   332,   333,   397,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,     0,     0,
       0,     0,     0,   344,   345,   346,   347,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,     0,
       0,     0,     0,     0,     0,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,     0,
     323,   324,   325,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   326,   327,   328,
     329,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   330,
       0,     0,   331,   332,   333,   620,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,     0,     0,     0,     0,
       0,   344,   345,   346,   347,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,     0,     0,     0,
       0,     0,     0,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,     0,   323,   324,
     325,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   326,   327,   328,   329,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   330,     0,     0,
     331,   332,   333,   627,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,     0,     0,     0,     0,     0,   344,
     345,   346,   347,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,     0,     0,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,     0,   323,   324,   325,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   326,   327,   328,   329,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   330,     0,     0,   331,   332,
     333,   866,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,     0,     0,     0,     0,     0,   344,   345,   346,
     347,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,     0,     0,     0,     0,     0,     0,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,     0,   323,   324,   325,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   326,   327,   328,   329,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   330,     0,     0,   331,   332,   333,   898,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,     0,     0,     0,   344,   345,   346,   347,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,     0,     0,     0,     0,     0,     0,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,     0,   323,   324,   325,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   326,
     327,   328,   329,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   330,     0,     0,   331,   332,   333,   899,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,     0,     0,
       0,     0,     0,   344,   345,   346,   347,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,     0,
       0,     0,     0,     0,     0,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,     0,
     323,   324,   325,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   326,   327,   328,
     329,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   330,
       0,     0,   331,   332,   333,   900,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,     0,     0,     0,     0,
       0,   344,   345,   346,   347,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,     0,     0,     0,
       0,     0,     0,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,     0,   323,   324,
     325,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   326,   327,   328,   329,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   330,     0,     0,
     331,   332,   333,   904,   334,   335,   336,   337,   338,   339,
     340,   341,   342,   343,     0,     0,     0,     0,     0,   344,
     345,   346,   347,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,     0,     0,     0,     0,     0,
       0,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,     0,   323,   324,   325,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   326,   327,   328,   329,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   330,     0,     0,   331,   332,
     333,   905,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,     0,     0,     0,     0,     0,   344,   345,   346,
     347,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,     0,     0,     0,     0,     0,     0,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,     0,   323,   324,   325,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   326,   327,   328,   329,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   330,     0,     0,   331,   332,   333,     0,
     334,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,     0,     0,     0,   344,   345,   346,   347,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,     0,     0,     0,     0,     0,     0,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   321,
     322,     0,   323,   324,   325,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   326,
     327,   328,   329,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   330,     0,     0,     0,   332,   333,     0,   334,   335,
     336,   337,   338,   339,   340,   341,   342,   343,   297,   298,
       0,     0,     0,   344,   345,   346,   347,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
       0,   323,   324,   325,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   326,   327,
       0,   329,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     330,     0,     0,     0,     0,   333,     0,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,   297,   298,     0,
       0,     0,   344,   345,   346,   347,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   309,   310,   311,   312,   313,
     314,   315,   316,   317,   318,   319,   320,   321,   322,     0,
     323,   324,   325,   297,   298,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   326,   327,     0,
    -227,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,     0,   323,   324,   325,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   330,
       0,     0,     0,   326,   327,     0,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,     0,     0,     0,     0,
       0,   344,   345,   346,   347,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   330,     0,     0,     0,     0,
       0,     0,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   297,   298,     0,     0,     0,   344,   345,   346,
     347,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     309,     0,   311,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,     0,   323,   324,   325,   297,   298,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
       0,   323,   324,   325,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   330,     0,     0,     0,     0,     0,
       0,   334,   335,   336,   337,   338,   339,   340,   341,   342,
     343,     0,     0,     0,     0,     0,   344,   345,   346,   347,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     330,     0,     0,     0,     0,   297,   298,   334,   335,   336,
     337,   338,   339,   340,   341,   342,   343,     0,     0,     0,
       0,     0,   344,   345,   346,   347,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,     0,   323,   324,
     325,   297,   298,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,     0,   323,   324,   325,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   330,     0,     0,
       0,   297,   298,     0,     0,   335,   336,   337,   338,   339,
     340,   341,   342,   343,     0,     0,     0,     0,     0,   344,
     345,   346,   347,     0,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   330,   323,   324,   325,     0,     0,     0,
       0,     0,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,     0,     0,     0,   344,   345,   346,   347,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   330,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   337,   338,   339,   340,   341,   342,   343,
       0,     0,     0,     0,     0,   344,   345,   346,   347
};

static const yytype_int16 yycheck[] =
{
       2,   108,   222,   413,     6,     0,     0,     0,     3,   413,
     648,   231,   413,    15,    16,    17,    18,   124,   132,   413,
     136,    51,     5,   413,     0,    15,   413,    29,     4,     5,
      15,   413,   413,    41,    42,    15,    51,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    51,    51,
      15,   166,   543,    55,    56,    57,    58,    59,    60,     5,
      15,    15,     5,    35,   115,    28,   758,   668,   142,    52,
      53,    54,    35,     5,    15,     0,    52,    53,    54,    51,
      82,    83,    45,    85,    86,    87,    28,    89,    51,    35,
     120,   165,    38,    35,    15,    38,    91,    91,    91,   142,
     696,    51,   608,    45,   610,   120,    38,   708,   704,    51,
      15,   142,    88,   108,   165,    91,   142,   120,   120,   115,
     122,   143,   118,   166,    94,   115,    57,    58,   118,   124,
     132,   161,   122,   123,   166,   115,   167,   122,   118,   165,
     142,   143,   834,   123,   166,   115,   161,   164,   120,   640,
     115,   121,   115,   676,   117,   142,   679,   165,   161,   122,
     136,   115,   166,    88,   118,   167,    91,   122,   122,   123,
     120,   662,   164,   115,   164,   117,   164,   587,   161,   166,
     122,   122,   166,   587,   164,   161,   587,   788,   145,   161,
     696,   154,   115,   587,   115,   197,   198,   587,   704,     3,
     587,   122,   165,    46,   424,   587,   587,    50,   139,   166,
     115,   136,   154,   118,   115,   706,   707,   118,   123,   696,
     696,   122,   123,   165,   219,   220,   696,   704,   704,   164,
     161,   162,   163,   164,   704,   211,   142,   239,   240,   241,
     242,   243,   244,   245,   246,   247,   248,   249,   250,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   897,
     166,   161,   264,   265,   266,   267,   268,   269,   263,   271,
     272,   273,   274,   275,   276,   277,   278,   279,   280,   281,
     282,   283,   284,   285,   286,   128,   211,   401,   889,   115,
     781,   134,   406,   784,   164,   142,   122,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,   317,   318,   319,   320,   166,
     921,   130,   324,   325,   326,   327,   328,   329,   323,   331,
     332,   333,   334,   335,   336,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,    57,    58,   115,   143,   143,
     118,   120,    94,   122,   122,   123,    94,    88,    25,    26,
      27,    28,   118,   115,   366,   117,   164,   123,   370,   164,
     122,   166,   166,   115,   376,   377,   378,   115,   354,   121,
     122,    41,    42,   121,   122,   115,    25,    26,    27,    28,
      29,    30,   122,   395,   115,   397,    35,   164,   161,   401,
     143,   122,   154,   166,   406,   136,    45,   115,   166,    48,
      49,   143,   115,   165,   122,   219,   220,   115,   413,   413,
     413,   164,   164,   166,   122,   164,    28,   139,   118,   354,
     144,   922,   164,    35,   166,   149,   150,    25,    26,    27,
      28,    29,    30,    45,   143,    12,    10,    35,   115,   161,
     162,   163,   164,   673,   674,   122,   143,    45,   164,   115,
      48,    49,   115,    94,   117,   164,   122,   166,   164,   122,
     164,   164,   474,    25,    26,    27,    28,    29,    30,     5,
     211,   701,   196,    35,   115,   115,   200,   117,   595,    15,
     121,   122,   122,    45,   143,   164,    48,    49,   824,    25,
      26,    27,    28,    29,    30,   115,   164,   833,   167,    35,
      94,   837,    38,   115,   840,   117,   164,   843,    28,    45,
     122,   115,    48,    49,   154,    35,   165,   529,   122,   115,
     164,   115,   752,   164,   536,    45,   122,   121,   122,   115,
     164,    51,    43,   545,   546,   547,   122,   549,   550,   551,
     115,    94,   154,    28,   556,   538,   539,   122,   778,   164,
      35,   136,   538,   539,    25,    26,    27,    28,    29,    30,
      45,   164,   115,   287,    35,   164,    51,   165,   121,   122,
     164,    94,    15,   115,    45,   117,   136,    48,    49,   115,
     122,   117,   587,   587,   587,   702,   122,   167,   164,    94,
     595,   118,   115,   598,   599,   115,   123,   117,   121,   122,
     164,   166,   122,   165,   608,   608,   610,   610,   620,   118,
     115,   164,   624,   354,   123,   627,   121,   122,   154,   631,
     115,   167,   117,   347,   167,   164,    28,   122,   352,   165,
     115,   833,   117,    35,   154,   837,   641,   122,   840,   363,
     164,   843,    15,    45,   143,   165,   132,   133,   164,    51,
     136,   137,    25,    26,    27,    28,    29,    30,   161,   154,
     384,   385,   386,   166,   143,   143,   115,   164,   117,   154,
     165,   676,    45,   122,   679,    48,    49,   167,   167,   161,
     165,   807,   115,   115,   117,   117,   410,   411,   412,   122,
     122,    94,   696,   696,   165,   164,   701,   421,   422,   423,
     704,   704,    57,    58,   764,   154,   766,    28,   161,   769,
     164,   167,   115,   115,    35,   117,   728,   164,   121,   122,
     122,   154,   154,   164,    45,   737,     4,   720,   721,   167,
      51,   164,   164,   161,   720,   721,   729,   863,   166,   732,
     866,   167,   115,   729,   117,   161,   732,   167,   161,   122,
     166,   161,   154,   132,   133,   760,   166,   136,   137,   764,
     161,   766,   161,   165,   769,   166,   164,   166,   142,    57,
      58,   167,   898,   899,   900,   901,   902,   167,   904,   905,
     167,   154,   167,   167,   139,   797,   798,   799,   800,   690,
     691,   692,   804,   805,   115,   167,   117,    28,   153,   154,
     155,   122,   167,    94,    35,   817,   161,   162,   163,   164,
     115,   167,   117,   537,    45,   166,   540,   122,   823,   824,
      51,   807,   167,   167,   115,   167,   117,   641,   833,   164,
     121,   122,   837,   154,   166,   840,   167,    44,   843,   166,
     164,   161,    37,   145,   165,   167,   115,   115,   167,   154,
     167,   139,   167,   167,   578,   166,   164,   164,   145,   164,
     164,   142,   855,   154,   876,   120,   154,   155,   167,   855,
     122,   115,   807,   161,   162,   163,   164,   863,   167,   136,
     866,   867,   167,   136,   115,   145,   117,    35,   612,   115,
     120,   122,   167,   617,   618,   619,   145,   145,   115,   911,
     167,   642,   643,   915,   167,   167,   918,    91,   167,   167,
     166,   587,   898,   899,   900,   901,   902,   903,   904,   905,
     906,   933,   167,   154,   167,   666,   667,   166,   863,   166,
     923,   866,   867,   166,   165,    28,   382,   923,   924,   925,
     926,   927,   928,   929,   930,   669,   760,   739,   230,   688,
     764,   599,   766,   610,   812,   769,    25,    26,    27,    28,
      29,    30,   834,   898,   899,   900,   901,   902,   903,   904,
     905,   906,   395,    77,    -1,    -1,    45,    -1,    -1,    48,
      49,    -1,   723,    -1,    -1,   709,    57,    58,    -1,   924,
     925,   926,   927,   928,   929,   930,    -1,    -1,   722,    -1,
      -1,    15,    -1,    -1,    -1,   746,   747,    -1,    -1,   750,
     824,    25,    26,    27,    28,    29,    30,    -1,    -1,   833,
      -1,    -1,    -1,   837,    -1,    -1,   840,    -1,    -1,   843,
      -1,    45,    -1,    -1,    48,    49,    -1,    15,    -1,    -1,
      -1,   782,   783,    -1,    -1,   786,   787,    25,    26,    27,
      28,    29,    30,    -1,    -1,   779,    28,    -1,    -1,    -1,
      -1,    -1,    -1,    35,    -1,    -1,   807,    45,   139,    -1,
      48,    49,    -1,    45,    -1,    -1,    -1,    -1,    -1,    51,
     151,   152,   153,   154,   155,    -1,   810,   811,    -1,    -1,
     161,   162,   163,   164,   818,    -1,    -1,    -1,    -1,    -1,
      -1,   115,    -1,   117,    -1,    -1,   847,    -1,   122,   850,
     851,    -1,    -1,   854,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   845,   863,    -1,    -1,   866,   867,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   115,    -1,   117,
     154,    -1,    -1,   115,   122,   117,    -1,    -1,    -1,    -1,
     122,    -1,    -1,    -1,    -1,    -1,    -1,   898,   899,   900,
     901,   902,   903,   904,   905,   906,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   154,    -1,    -1,    -1,
      -1,    -1,   154,   924,   925,   926,   927,   928,   929,   930,
      -1,    -1,   916,   165,    -1,   919,    -1,    -1,    -1,    -1,
     941,   942,    -1,    -1,    -1,    -1,     0,     1,    -1,     3,
     934,     5,     6,     7,     8,     9,    -1,    -1,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    -1,
      34,    35,    36,    -1,    38,    39,    40,    -1,    -1,    -1,
      -1,    45,    46,    47,    48,    49,    50,    -1,    52,    53,
      54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,
      74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,
      94,    95,    96,    97,    98,    99,   100,   101,   102,   103,
     104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,
     114,   115,    -1,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,    -1,    -1,
     134,   135,    -1,    -1,   138,    -1,   140,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,   152,    -1,
     154,    -1,    -1,    -1,   158,   159,   160,   161,    -1,     1,
     164,    -1,   166,     5,     6,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    15,    -1,    -1,    -1,    19,    20,    -1,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    38,    -1,    -1,    -1,
      -1,    -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,
      52,    53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,
      72,    73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,
      -1,    93,    94,    95,    96,    -1,    -1,    -1,   100,   101,
     102,   103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,    -1,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,
     152,    -1,   154,    -1,    -1,    -1,   158,   159,   160,   161,
      -1,    -1,   164,    -1,     1,   167,     3,    -1,     5,     6,
       7,     8,     9,    -1,    -1,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    -1,    34,    35,    36,
      -1,    38,    39,    40,    -1,    -1,    -1,    -1,    45,    46,
      47,    48,    49,    50,    -1,    52,    53,    54,    55,    -1,
      57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,   113,   114,   115,    -1,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,    -1,    -1,   134,   135,    -1,
      -1,   138,    -1,   140,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   151,   152,    -1,   154,    -1,    -1,
      -1,   158,   159,   160,   161,    -1,     1,   164,     3,   166,
       5,     6,     7,     8,     9,    -1,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      -1,    36,    -1,    38,    39,    40,    -1,    -1,    -1,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
     115,    -1,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,    -1,   129,   130,   131,    -1,    -1,    -1,
     135,    -1,    -1,   138,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   151,   152,    -1,   154,
      -1,    -1,    -1,   158,   159,   160,   161,    -1,     1,   164,
       3,   166,     5,     6,     7,     8,     9,    -1,    -1,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      -1,    34,    -1,    36,    -1,    38,    39,    40,    41,    42,
      -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,   115,    -1,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,    -1,   129,   130,   131,    -1,
      -1,    -1,   135,    -1,    -1,   138,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,   152,
      -1,   154,    -1,    -1,    -1,   158,   159,   160,   161,    -1,
      -1,   164,   165,   166,     1,    -1,     3,    -1,     5,     6,
       7,     8,     9,    -1,    -1,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    -1,    34,    -1,    36,
      -1,    38,    39,    40,    41,    42,    -1,    -1,    45,    -1,
      -1,    48,    49,    -1,    -1,    52,    53,    54,    55,    -1,
      57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,   113,   114,   115,    -1,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,    -1,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   151,   152,    -1,   154,    -1,    -1,
      -1,   158,   159,   160,   161,    -1,    -1,   164,   165,   166,
       1,    -1,     3,    -1,     5,     6,     7,     8,     9,    -1,
      -1,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    -1,    34,    -1,    36,    -1,    38,    39,    40,
      41,    42,    -1,    -1,    45,    -1,    -1,    48,    49,    -1,
      -1,    52,    53,    54,    55,    -1,    57,    58,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    -1,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,    -1,    -1,    -1,    -1,
     111,   112,   113,   114,   115,    -1,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,    -1,   129,   130,
     131,    -1,    -1,    -1,   135,    -1,    -1,   138,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     151,   152,    -1,   154,    -1,    -1,    -1,   158,   159,   160,
     161,    -1,    -1,   164,   165,   166,     1,    -1,     3,    -1,
       5,     6,     7,     8,     9,    -1,    -1,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    -1,    34,
      -1,    36,    -1,    38,    39,    40,    41,    42,    -1,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
     115,    -1,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,    -1,   129,   130,   131,    -1,    -1,    -1,
     135,    -1,    -1,   138,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   151,   152,    -1,   154,
      -1,    -1,    -1,   158,   159,   160,   161,    -1,    -1,   164,
     165,   166,     1,    -1,     3,    -1,     5,     6,     7,     8,
       9,    -1,    -1,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    -1,    -1,    34,    -1,    36,    -1,    38,
      39,    40,    41,    42,    -1,    -1,    45,    -1,    -1,    48,
      49,    -1,    -1,    52,    53,    54,    55,    -1,    57,    58,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      89,    -1,    -1,    -1,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,    -1,    -1,
      -1,    -1,   111,   112,   113,   114,   115,    -1,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,    -1,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   151,   152,    -1,   154,    -1,    -1,    -1,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,     1,    -1,
       3,    -1,     5,     6,     7,     8,     9,    -1,    -1,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      -1,    34,    -1,    36,    -1,    38,    39,    40,    41,    42,
      -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,   115,    -1,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,    -1,   129,   130,   131,    -1,
      -1,    -1,   135,    -1,    -1,   138,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,   152,
      -1,   154,    -1,    -1,    -1,   158,   159,   160,   161,    -1,
      -1,   164,   165,   166,     1,    -1,     3,    -1,     5,     6,
       7,     8,     9,    -1,    -1,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    -1,    34,    -1,    36,
      -1,    38,    39,    40,    41,    42,    -1,    -1,    45,    -1,
      -1,    48,    49,    -1,    -1,    52,    53,    54,    55,    -1,
      57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,   113,   114,   115,    -1,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,    -1,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   151,   152,    -1,   154,    -1,    -1,
      -1,   158,   159,   160,   161,    -1,    -1,   164,   165,   166,
       1,    -1,     3,    -1,     5,     6,     7,     8,     9,    -1,
      -1,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    -1,    34,    -1,    36,    -1,    38,    39,    40,
      41,    42,    -1,    -1,    45,    -1,    -1,    48,    49,    -1,
      -1,    52,    53,    54,    55,    -1,    57,    58,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    -1,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,    -1,    -1,    -1,    -1,
     111,   112,   113,   114,   115,    -1,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,    -1,   129,   130,
     131,    -1,    -1,    -1,   135,    -1,    -1,   138,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     151,   152,    -1,   154,    -1,    -1,    -1,   158,   159,   160,
     161,    -1,    -1,   164,   165,   166,     1,    -1,     3,    -1,
       5,     6,     7,     8,     9,    -1,    -1,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    -1,    34,
      -1,    36,    -1,    38,    39,    40,    41,    42,    -1,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
     115,    -1,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,    -1,   129,   130,   131,    -1,    -1,    -1,
     135,    -1,    -1,   138,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   151,   152,    -1,   154,
      -1,    -1,    -1,   158,   159,   160,   161,    -1,    -1,   164,
     165,   166,     1,    -1,     3,    -1,     5,     6,     7,     8,
       9,    -1,    -1,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    -1,    -1,    34,    -1,    36,    -1,    38,
      39,    40,    41,    42,    -1,    -1,    45,    -1,    -1,    48,
      49,    -1,    -1,    52,    53,    54,    55,    -1,    57,    58,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      89,    -1,    -1,    -1,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,    -1,    -1,
      -1,    -1,   111,   112,   113,   114,   115,    -1,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,    -1,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   151,   152,    -1,   154,    -1,    -1,    -1,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,     1,    -1,
       3,    -1,     5,     6,     7,     8,     9,    -1,    -1,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      -1,    34,    -1,    36,    -1,    38,    39,    40,    41,    42,
      -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,   115,    -1,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,    -1,   129,   130,   131,    -1,
      -1,    -1,   135,    -1,    -1,   138,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,   152,
      -1,   154,    -1,    -1,    -1,   158,   159,   160,   161,    -1,
      -1,   164,   165,   166,     1,    -1,     3,    -1,     5,     6,
       7,     8,     9,    -1,    -1,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    -1,    34,    -1,    36,
      -1,    38,    39,    40,    41,    42,    -1,    -1,    45,    -1,
      -1,    48,    49,    -1,    -1,    52,    53,    54,    55,    -1,
      57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,   113,   114,   115,    -1,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,    -1,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   151,   152,    -1,   154,    -1,    -1,
      -1,   158,   159,   160,   161,    -1,    -1,   164,   165,   166,
       1,    -1,     3,    -1,     5,     6,     7,     8,     9,    -1,
      -1,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    -1,    34,    -1,    36,    -1,    38,    39,    40,
      41,    42,    -1,    -1,    45,    -1,    -1,    48,    49,    -1,
      -1,    52,    53,    54,    55,    -1,    57,    58,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    -1,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,    -1,    -1,    -1,    -1,
     111,   112,   113,   114,   115,    -1,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,    -1,   129,   130,
     131,    -1,    -1,    -1,   135,    -1,    -1,   138,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     151,   152,    -1,   154,    -1,    -1,    -1,   158,   159,   160,
     161,    -1,    -1,   164,   165,   166,     1,    -1,     3,    -1,
       5,     6,     7,     8,     9,    -1,    -1,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    -1,    34,
      -1,    36,    -1,    38,    39,    40,    41,    42,    -1,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
     115,    -1,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,    -1,   129,   130,   131,    -1,    -1,    -1,
     135,    -1,    -1,   138,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   151,   152,    -1,   154,
      -1,    -1,    -1,   158,   159,   160,   161,    -1,    -1,   164,
     165,   166,     1,    -1,     3,    -1,     5,     6,     7,     8,
       9,    -1,    -1,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    -1,    -1,    34,    -1,    36,    -1,    38,
      39,    40,    41,    42,    -1,    -1,    45,    -1,    -1,    48,
      49,    -1,    -1,    52,    53,    54,    55,    -1,    57,    58,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      89,    -1,    -1,    -1,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,    -1,    -1,
      -1,    -1,   111,   112,   113,   114,   115,    -1,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,    -1,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   151,   152,    -1,   154,    -1,    -1,    -1,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,     1,    -1,
       3,    -1,     5,     6,     7,     8,     9,    -1,    -1,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      -1,    34,    -1,    36,    -1,    38,    39,    40,    41,    42,
      -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,   115,    -1,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,    -1,   129,   130,   131,    -1,
      -1,    -1,   135,    -1,    -1,   138,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,   152,
      -1,   154,    -1,    -1,    -1,   158,   159,   160,   161,    -1,
      -1,   164,   165,   166,     1,    -1,     3,    -1,     5,     6,
       7,     8,     9,    -1,    -1,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    -1,    34,    -1,    36,
      -1,    38,    39,    40,    41,    42,    -1,    -1,    45,    -1,
      -1,    48,    49,    -1,    -1,    52,    53,    54,    55,    -1,
      57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,   113,   114,   115,    -1,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,    -1,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   151,   152,    -1,   154,    -1,    -1,
      -1,   158,   159,   160,   161,    -1,    -1,   164,   165,   166,
       1,    -1,     3,    -1,     5,     6,     7,     8,     9,    -1,
      -1,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    -1,    34,    -1,    36,    -1,    38,    39,    40,
      41,    42,    -1,    -1,    45,    -1,    -1,    48,    49,    -1,
      -1,    52,    53,    54,    55,    -1,    57,    58,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    -1,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,    -1,    -1,    -1,    -1,
     111,   112,   113,   114,   115,    -1,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,    -1,   129,   130,
     131,    -1,    -1,    -1,   135,    -1,    -1,   138,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     151,   152,    -1,   154,    -1,    -1,    -1,   158,   159,   160,
     161,    -1,    -1,   164,   165,   166,     1,    -1,     3,    -1,
       5,     6,     7,     8,     9,    -1,    -1,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    -1,    34,
      -1,    36,    -1,    38,    39,    40,    41,    42,    -1,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
     115,    -1,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,    -1,   129,   130,   131,    -1,    -1,    -1,
     135,    -1,    -1,   138,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   151,   152,    -1,   154,
      -1,    -1,    -1,   158,   159,   160,   161,    -1,    -1,   164,
     165,   166,     1,    -1,     3,    -1,     5,     6,     7,     8,
       9,    -1,    -1,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    -1,    -1,    34,    -1,    36,    -1,    38,
      39,    40,    41,    42,    -1,    -1,    45,    -1,    -1,    48,
      49,    -1,    -1,    52,    53,    54,    55,    -1,    57,    58,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      89,    -1,    -1,    -1,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,    -1,    -1,
      -1,    -1,   111,   112,   113,   114,   115,    -1,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,    -1,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   151,   152,    -1,   154,    -1,    -1,    -1,   158,
     159,   160,   161,    -1,    -1,   164,   165,   166,     1,    -1,
       3,    -1,     5,     6,     7,     8,     9,    -1,    -1,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      -1,    34,    -1,    36,    -1,    38,    39,    40,    -1,    -1,
      -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      93,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,   115,    -1,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,    -1,   129,   130,   131,    -1,
      -1,    -1,   135,    -1,    -1,   138,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,   152,
      -1,   154,    -1,    -1,    -1,   158,   159,   160,   161,    -1,
      -1,   164,   165,   166,     1,    -1,     3,    -1,     5,     6,
       7,     8,     9,    -1,    -1,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    -1,    34,    -1,    36,
      -1,    38,    39,    40,    -1,    -1,    -1,    -1,    45,    -1,
      -1,    48,    49,    -1,    -1,    52,    53,    54,    55,    -1,
      57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,   113,   114,   115,    -1,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,    -1,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   151,   152,    -1,   154,    -1,    -1,
      -1,   158,   159,   160,   161,    -1,    -1,   164,   165,   166,
       1,    -1,     3,    -1,     5,     6,     7,     8,     9,    -1,
      -1,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    -1,    34,    -1,    36,    -1,    38,    39,    40,
      -1,    -1,    -1,    -1,    45,    -1,    -1,    48,    49,    -1,
      -1,    52,    53,    54,    55,    -1,    57,    58,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,
      -1,    -1,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,    -1,    -1,    -1,    -1,
     111,   112,   113,   114,   115,    -1,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,    -1,   129,   130,
     131,    -1,    -1,    -1,   135,    -1,    -1,   138,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     151,   152,    -1,   154,    -1,    -1,    -1,   158,   159,   160,
     161,    -1,    -1,   164,   165,   166,     1,    -1,     3,    -1,
       5,     6,     7,     8,     9,    -1,    -1,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    -1,    34,
      -1,    36,    -1,    38,    39,    40,    -1,    -1,    -1,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
     115,    -1,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,    -1,   129,   130,   131,    -1,    -1,    -1,
     135,    -1,    -1,   138,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   151,   152,    -1,   154,
      -1,    -1,    -1,   158,   159,   160,   161,    -1,    -1,   164,
     165,   166,     1,    -1,     3,    -1,     5,     6,     7,     8,
       9,    -1,    -1,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    -1,    -1,    34,    -1,    36,    -1,    38,
      39,    40,    -1,    -1,    -1,    -1,    45,    -1,    -1,    48,
      49,    -1,    -1,    52,    53,    54,    55,    -1,    57,    58,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      89,    -1,    -1,    -1,    93,    94,    95,    96,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,    -1,    -1,
      -1,    -1,   111,   112,   113,   114,   115,    -1,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,    -1,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   151,   152,    -1,   154,    -1,    -1,    -1,   158,
     159,   160,   161,    -1,     1,   164,    -1,   166,     5,     6,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    15,    -1,
      -1,    -1,    19,    20,    -1,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    38,    -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,
      -1,    48,    49,    -1,    -1,    52,    53,    54,    55,    -1,
      57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,
      -1,    -1,    -1,   100,   101,   102,   103,   104,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,    -1,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   151,   152,    -1,   154,    -1,     6,
      -1,   158,   159,   160,   161,    -1,    -1,   164,    15,   166,
      -1,    -1,    19,    20,    -1,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,
      -1,    48,    49,    -1,    -1,    52,    53,    54,    55,    -1,
      57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,
      -1,    -1,    -1,   100,   101,   102,   103,   104,   105,   106,
      -1,    -1,    -1,    -1,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,    -1,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   151,   152,     6,   154,    -1,    -1,
      -1,   158,   159,   160,   161,    15,    -1,   164,    -1,    19,
      20,   168,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    45,    -1,    -1,    48,    49,
      -1,    -1,    52,    53,    54,    55,    -1,    57,    58,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,
      70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    -1,    93,    94,    95,    96,    -1,    -1,    -1,
     100,   101,   102,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,    -1,   129,
     130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   151,   152,     6,   154,    -1,    -1,    -1,   158,   159,
     160,   161,    15,    -1,   164,    -1,    19,    20,   168,    -1,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,
      53,    54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,
      73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,
      93,    94,    95,    96,    -1,    -1,    -1,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,   111,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,    -1,   129,   130,   131,    -1,
      -1,    -1,   135,    -1,    -1,   138,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,   152,
       6,   154,    -1,    -1,    -1,   158,   159,   160,   161,    15,
      -1,   164,    -1,    19,    20,   168,    -1,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    45,
      -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,    55,
      -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    69,    70,    71,    72,    73,    74,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,    95,
      96,    -1,    -1,    -1,   100,   101,   102,   103,   104,   105,
     106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,    -1,   129,   130,   131,    -1,    -1,    -1,   135,
      -1,    -1,   138,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   151,   152,     6,   154,    -1,
      -1,    -1,   158,   159,   160,   161,    15,    -1,   164,    -1,
      19,    20,   168,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,    -1,    48,
      49,    -1,    -1,    52,    53,    54,    55,    -1,    57,    58,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      89,    -1,    -1,    -1,    93,    94,    95,    96,    -1,    -1,
      -1,   100,   101,   102,   103,   104,   105,   106,    -1,    -1,
      -1,    -1,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,    -1,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   151,   152,    -1,   154,    -1,     6,    -1,   158,
     159,   160,   161,    -1,    -1,   164,    15,    -1,   167,    -1,
      19,    20,    -1,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,    -1,    48,
      49,    -1,    -1,    52,    53,    54,    55,    -1,    57,    58,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      89,    -1,    -1,    -1,    93,    94,    95,    96,    -1,    -1,
      -1,   100,   101,   102,   103,   104,   105,   106,    -1,    -1,
      -1,    -1,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,    -1,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   151,   152,    -1,   154,    -1,     6,    -1,   158,
     159,   160,   161,    -1,    -1,   164,    15,   166,    -1,    -1,
      19,    20,    -1,    -1,    23,    24,    25,    26,    27,    28,
      29,    30,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,    -1,    48,
      49,    -1,    -1,    52,    53,    54,    55,    -1,    57,    58,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      69,    70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      89,    -1,    -1,    -1,    93,    94,    95,    96,    -1,    -1,
      -1,   100,   101,   102,   103,   104,   105,   106,    -1,    -1,
      -1,    -1,   111,   112,   113,   114,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,    -1,
     129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,   138,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,
      -1,    -1,   151,   152,    -1,   154,    -1,    -1,    15,   158,
     159,   160,   161,    -1,    -1,   164,    -1,   166,    25,    26,
      27,    28,    29,    30,    -1,    -1,    -1,    -1,    35,    -1,
      -1,    38,    -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,
      -1,    48,    49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     5,     6,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    15,    -1,    -1,    -1,    19,    20,    -1,
      -1,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    38,    -1,    -1,    -1,
      -1,    -1,    -1,    45,    -1,    -1,    48,    49,    -1,    -1,
      52,    53,    54,    55,    -1,    57,    58,    -1,   115,    -1,
     117,    -1,    -1,    -1,    -1,   122,    -1,    69,    70,    71,
      72,    73,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,
      -1,    93,    94,    95,    96,    -1,    -1,   154,   100,   101,
     102,   103,   104,   105,   106,    -1,    -1,    -1,   165,   111,
     112,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,    -1,   129,   130,   131,
      -1,    -1,    -1,   135,    -1,    -1,   138,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,
     152,     6,   154,    -1,    -1,    -1,   158,   159,   160,   161,
      15,    -1,   164,    -1,    19,    20,    -1,    -1,    23,    24,
      25,    26,    27,    28,    29,    30,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,    54,
      55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,    74,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,    94,
      95,    96,    -1,    -1,    -1,   100,   101,   102,   103,   104,
     105,   106,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,    -1,   129,   130,   131,    -1,    -1,    -1,
     135,    -1,    -1,   138,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   151,   152,     6,   154,
      -1,    -1,    -1,   158,   159,   160,   161,    15,    -1,   164,
     165,    19,    20,    -1,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,    -1,
      48,    49,    -1,    -1,    52,    53,    54,    55,    -1,    57,
      58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    70,    71,    72,    73,    74,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,    -1,
      -1,    -1,   100,   101,   102,   103,   104,   105,   106,    -1,
      -1,    -1,    -1,   111,   112,   113,   114,   115,   116,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
      -1,   129,   130,   131,    -1,    -1,    -1,   135,    -1,    -1,
     138,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   151,   152,     6,   154,    -1,    -1,    -1,
     158,   159,   160,   161,    15,    -1,   164,   165,    19,    20,
      -1,    -1,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    45,    -1,    -1,    48,    49,    -1,
      -1,    52,    53,    54,    55,    -1,    57,    58,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,    70,
      71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,    80,
      -1,    82,    83,    -1,    -1,    -1,    87,    88,    89,    -1,
      -1,    -1,    93,    94,    95,    96,    -1,    -1,    -1,   100,
     101,   102,   103,   104,   105,   106,    -1,    -1,    -1,    -1,
     111,   112,   113,   114,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,    -1,   129,   130,
     131,    -1,    -1,    -1,   135,   136,    -1,   138,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,   150,
     151,   152,     6,   154,    -1,    -1,    -1,   158,   159,   160,
     161,    15,    -1,   164,    -1,    19,    20,    -1,    -1,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    45,    -1,    -1,    48,    49,    -1,    -1,    52,    53,
      54,    55,    -1,    57,    58,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    69,    70,    71,    72,    73,
      74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    89,    -1,    -1,    -1,    93,
      94,    95,    96,    -1,    -1,    -1,   100,   101,   102,   103,
     104,   105,   106,    -1,    -1,    -1,   110,   111,   112,   113,
     114,   115,   116,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,    -1,   129,   130,   131,    -1,    -1,
      -1,   135,    -1,    -1,   138,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   151,   152,     6,
     154,    -1,    -1,    -1,   158,   159,   160,   161,    15,    -1,
     164,    -1,    19,    20,    -1,    -1,    23,    24,    25,    26,
      27,    28,    29,    30,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    45,    -1,
      -1,    48,    49,    -1,    -1,    52,    53,    54,    55,    -1,
      57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    69,    70,    71,    72,    73,    74,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    89,    -1,    -1,    -1,    93,    94,    95,    96,
      -1,    -1,    -1,   100,   101,   102,   103,   104,   105,   106,
      -1,    -1,    -1,   110,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,    -1,   129,   130,   131,    -1,    -1,    -1,   135,    -1,
      -1,   138,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   151,   152,     6,   154,    -1,    -1,
      -1,   158,   159,   160,   161,    15,    -1,   164,    -1,    19,
      20,    -1,    -1,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    45,    -1,    -1,    48,    49,
      -1,    -1,    52,    53,    54,    55,    -1,    57,    58,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    69,
      70,    71,    72,    73,    74,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    89,
      -1,    -1,    -1,    93,    94,    95,    96,    -1,    -1,    -1,
     100,   101,   102,   103,   104,   105,   106,    -1,    -1,    -1,
      -1,   111,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,    11,   129,
     130,   131,    -1,    -1,    -1,   135,    57,    58,   138,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   151,   152,    -1,   154,    -1,    -1,    -1,   158,   159,
     160,   161,    -1,    -1,   164,    -1,    -1,    -1,    -1,    90,
      91,    92,    -1,    -1,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    92,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   139,    -1,
      -1,    -1,    -1,    -1,   107,   108,   109,   110,    -1,    -1,
     151,   152,   153,   154,   155,    -1,    -1,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,    -1,    -1,    22,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   139,    -1,    -1,   142,
     143,   144,    -1,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,    -1,    -1,    -1,    -1,    -1,   161,   162,
     163,   164,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    -1,    90,    91,    92,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    22,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,
      -1,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,    -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   139,    -1,    -1,   142,   143,   144,    -1,   146,
     147,   148,   149,   150,   151,   152,   153,   154,   155,    -1,
      -1,    -1,    -1,    -1,   161,   162,   163,   164,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,
     109,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     139,    -1,    -1,   142,   143,   144,    -1,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,    -1,    -1,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,    -1,    -1,   168,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   139,    -1,    -1,   142,   143,   144,    -1,   146,
     147,   148,   149,   150,   151,   152,   153,   154,   155,    -1,
      -1,    -1,    -1,    -1,   161,   162,   163,   164,    -1,    -1,
      -1,   168,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    -1,    90,    91,    92,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,
      -1,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,    -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,    -1,    -1,   168,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    92,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   107,   108,   109,   110,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   139,    -1,    -1,   142,
     143,   144,    -1,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,    -1,    -1,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,    -1,    -1,   168,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    90,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,   110,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   139,    -1,
      -1,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,    -1,    -1,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,    -1,   167,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   139,
      -1,    -1,   142,   143,   144,    -1,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,    -1,    -1,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,    -1,   167,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,
     109,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     139,    -1,    -1,   142,   143,   144,    -1,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,    -1,    -1,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,    -1,   167,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   139,    -1,    -1,   142,   143,   144,    -1,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,    -1,    -1,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,    -1,   167,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   139,    -1,    -1,   142,   143,   144,    -1,   146,
     147,   148,   149,   150,   151,   152,   153,   154,   155,    -1,
      -1,    -1,    -1,    -1,   161,   162,   163,   164,    -1,    -1,
     167,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,    -1,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
      -1,   167,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    -1,    90,    91,    92,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,
      -1,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,    -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,    -1,   167,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    90,    91,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   107,   108,   109,   110,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   139,    -1,    -1,   142,   143,
     144,    -1,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,    -1,    -1,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,    -1,   167,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,
      -1,    -1,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    -1,    90,    91,    92,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   107,   108,   109,   110,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   139,    -1,    -1,   142,
     143,   144,    -1,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   155,    -1,    -1,    -1,    -1,    -1,   161,   162,
     163,   164,    -1,    -1,   167,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    90,    91,
      92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   107,   108,   109,   110,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   139,    -1,    -1,
     142,   143,   144,    -1,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,    -1,    -1,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,    -1,   167,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,    67,    68,    -1,    -1,
      -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    -1,    90,
      91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,   110,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   139,    -1,
      -1,   142,   143,   144,    -1,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,    -1,    -1,    -1,    -1,    -1,
     161,   162,   163,   164,    -1,    -1,   167,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   139,
      -1,    -1,   142,   143,   144,    -1,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,    -1,    -1,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,    -1,   167,    57,    58,
      59,    60,    61,    62,    63,    64,    65,    66,    67,    68,
      -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,
     109,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     139,    -1,    -1,   142,   143,   144,    -1,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,    -1,    -1,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,    -1,   167,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   139,    -1,    -1,   142,   143,   144,    -1,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,    -1,    -1,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,    -1,   167,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   139,    -1,    -1,   142,   143,   144,    -1,   146,
     147,   148,   149,   150,   151,   152,   153,   154,   155,    -1,
      -1,    -1,    -1,    -1,   161,   162,   163,   164,    -1,    -1,
     167,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,    -1,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,    -1,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,    -1,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,    -1,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,    -1,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,    -1,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,    -1,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,    -1,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,    -1,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,    -1,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,    -1,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,    -1,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,    -1,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,    -1,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
     166,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,    -1,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164,   165,
      57,    58,    59,    60,    61,    62,    63,    64,    65,    66,
      67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   139,    -1,    -1,   142,   143,   144,    -1,   146,
     147,   148,   149,   150,   151,   152,   153,   154,   155,    -1,
      -1,    -1,    -1,    -1,   161,   162,   163,   164,   165,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   139,    -1,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,    -1,    -1,
      -1,    -1,    -1,   161,   162,   163,   164,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   139,
      -1,    -1,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,    -1,    -1,    -1,    -1,
      -1,   161,   162,   163,   164,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    90,    91,
      92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   107,   108,   109,   110,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   139,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,    -1,    -1,    -1,    -1,    -1,   161,
     162,   163,   164,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    90,    91,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   107,   108,   109,   110,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   139,    -1,    -1,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,    -1,    -1,    -1,    -1,    -1,   161,   162,   163,
     164,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   139,    -1,    -1,   142,   143,   144,   145,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,    -1,    -1,
      -1,    -1,    -1,   161,   162,   163,   164,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,   109,
     110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   139,
      -1,    -1,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,    -1,    -1,    -1,    -1,
      -1,   161,   162,   163,   164,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    -1,    -1,    -1,
      -1,    -1,    -1,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    90,    91,
      92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   107,   108,   109,   110,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   139,    -1,    -1,
     142,   143,   144,   145,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,    -1,    -1,    -1,    -1,    -1,   161,
     162,   163,   164,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    -1,    -1,    -1,    -1,    -1,
      -1,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    90,    91,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   107,   108,   109,   110,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   139,    -1,    -1,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,    -1,    -1,    -1,    -1,    -1,   161,   162,   163,
     164,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    67,    68,    -1,    -1,    -1,    -1,    -1,    -1,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   107,   108,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,    -1,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164,    57,
      58,    59,    60,    61,    62,    63,    64,    65,    66,    67,
      68,    -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,
     108,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   139,    -1,    -1,    -1,   143,   144,    -1,   146,   147,
     148,   149,   150,   151,   152,   153,   154,   155,    57,    58,
      -1,    -1,    -1,   161,   162,   163,   164,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,
      -1,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     139,    -1,    -1,    -1,    -1,   144,    -1,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,    57,    58,    -1,
      -1,    -1,   161,   162,   163,   164,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    -1,
      90,    91,    92,    57,    58,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   107,   108,    -1,
     110,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    -1,    90,    91,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   139,
      -1,    -1,    -1,   107,   108,    -1,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,    -1,    -1,    -1,    -1,
      -1,   161,   162,   163,   164,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   139,    -1,    -1,    -1,    -1,
      -1,    -1,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,    57,    58,    -1,    -1,    -1,   161,   162,   163,
     164,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    -1,    90,    91,    92,    57,    58,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      -1,    90,    91,    92,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   139,    -1,    -1,    -1,    -1,    -1,
      -1,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,    -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     139,    -1,    -1,    -1,    -1,    57,    58,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,    -1,    -1,    -1,
      -1,    -1,   161,   162,   163,   164,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    -1,    90,    91,
      92,    57,    58,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    -1,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   139,    -1,    -1,
      -1,    57,    58,    -1,    -1,   147,   148,   149,   150,   151,
     152,   153,   154,   155,    -1,    -1,    -1,    -1,    -1,   161,
     162,   163,   164,    -1,    80,    81,    82,    83,    84,    85,
      86,    87,    88,   139,    90,    91,    92,    -1,    -1,    -1,
      -1,    -1,   148,   149,   150,   151,   152,   153,   154,   155,
      -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   139,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   149,   150,   151,   152,   153,   154,   155,
      -1,    -1,    -1,    -1,    -1,   161,   162,   163,   164
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,     1,     3,     6,     7,     8,     9,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    34,    35,    36,    39,
      40,    45,    47,    48,    49,    52,    53,    54,    55,    57,
      58,    69,    70,    71,    72,    73,    74,    89,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   111,   112,   113,   114,   115,   117,   119,   120,
     121,   122,   124,   125,   126,   127,   129,   130,   131,   135,
     138,   140,   151,   152,   154,   158,   159,   160,   161,   164,
     166,   170,   171,   174,   175,   176,   179,   180,   185,   188,
     189,   192,   194,   195,   202,   203,   216,   220,   221,   222,
     224,   225,   227,   232,   234,   235,   236,   166,    15,    28,
     116,   122,   161,   202,   221,   226,   230,   231,   232,   233,
     115,   122,   164,   202,   203,   122,   161,   181,   182,   185,
     182,   233,   164,   164,   164,    94,   115,   121,   122,   164,
     214,   166,   166,   166,   233,   233,   233,   233,    35,   115,
     184,   186,   115,   122,   184,   166,   233,   164,   161,   233,
     233,   233,   233,   233,   233,   233,   233,   233,   233,   233,
     115,   117,   122,   233,   182,   182,   182,   233,   233,   233,
     233,   233,   233,     1,   193,   233,   164,   164,   164,   235,
     164,   233,   233,   115,   117,   122,   233,   233,   233,   165,
     181,   183,   185,   167,   228,   229,   233,     0,   171,     5,
      38,   166,    15,   115,   122,   118,   123,    46,    50,   128,
     134,    15,    28,   115,   122,   202,   222,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    90,    91,    92,   107,   108,   109,   110,
     139,   142,   143,   144,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   161,   162,   163,   164,   166,   165,
     228,   233,   165,   228,    15,    15,   202,    57,    58,    59,
      60,    61,    62,    63,    64,    65,    66,    67,    68,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    90,    91,    92,   107,   108,   109,   110,
     139,   142,   143,   144,   146,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   161,   162,   163,   164,   226,   233,
     115,   118,   164,   165,   183,    12,    10,   166,   233,   233,
     193,   164,   164,   164,   193,   193,    22,    22,   115,   122,
     164,    11,    32,    33,   182,   187,   143,   143,   164,   166,
     233,   115,   172,   173,   164,   164,   164,   167,   193,   233,
     233,   193,   165,   181,   185,   142,   167,   145,   167,   115,
     122,   164,   202,   203,   115,   122,   164,   202,   203,   122,
     164,   214,   164,   161,   166,   115,   122,    43,   196,   196,
     122,   164,   214,   164,    15,   122,   233,   233,   233,   233,
     233,   233,   233,   233,   233,   233,   233,   233,   233,   233,
     233,   233,   233,   233,   233,   233,   233,   233,   132,   133,
     136,   137,   136,   202,   233,   233,   233,   233,   233,   233,
     233,   233,   233,   233,   233,   233,   233,   233,   233,   233,
     233,   233,   233,   233,   110,   233,   233,   193,   165,   165,
      15,   233,   233,   233,   233,   233,   233,   233,   233,   233,
     233,   233,   233,   233,   233,   233,   233,   233,   233,   233,
     233,   233,   233,   132,   133,   136,   137,   136,   202,   233,
     233,   233,   233,   233,   233,   233,   233,   233,   233,   233,
     233,   233,   233,   233,   233,   233,   233,   233,   233,   110,
     233,   233,   193,   167,   193,   165,   164,   164,   167,   167,
     166,   193,   167,   167,   233,   164,   143,   143,   233,   164,
     164,   164,   233,   233,   233,   167,   143,   165,   173,   193,
     193,   193,   167,   167,   167,   167,   229,   233,   226,   115,
     122,   118,   123,   226,   115,   122,   118,   123,   164,   193,
     193,   193,    15,   122,   165,   175,   176,   177,   178,   179,
     180,   194,   195,   202,   216,   221,   224,   225,   161,   161,
      25,    26,    27,    28,   115,   122,   197,   198,   161,   166,
     161,   166,   164,   193,   193,   193,   122,   164,   214,   164,
     145,   165,   168,   233,   110,   168,   167,   145,   165,   168,
     233,   110,   168,   167,   167,   233,   193,   182,   182,   193,
     167,     4,   223,   223,    11,   233,   233,   233,   167,   233,
     233,   233,   166,   166,   167,   161,   233,   167,   167,   167,
     145,   166,   217,   167,   167,   193,   167,   167,   167,   164,
     166,   165,   178,    15,    15,   202,   199,   200,   202,   199,
     115,   122,   115,   122,   115,   122,   115,   122,   142,    25,
      26,    27,    28,    35,   165,   179,   201,   204,   205,   206,
     215,   220,   221,   165,   201,   193,   167,   167,   167,   164,
     193,   193,   193,   233,   168,   168,   233,   168,   168,   167,
     167,    44,   166,   223,   202,   203,   181,   181,   164,   167,
     166,   166,   186,   167,   167,   167,    37,    41,    42,   190,
     191,   166,   115,   122,   218,   219,   223,   167,   181,   181,
     217,   193,    15,   165,   200,   115,   165,   198,    51,   120,
     161,   210,   211,   212,   161,   212,   161,   212,    35,   161,
     212,   165,   179,   204,   205,   206,   215,   115,   202,   214,
     165,   167,   223,   223,   217,   193,   167,   167,   167,   166,
     182,   182,   193,   181,   233,   182,   182,   164,    80,    82,
      83,    87,    88,   136,   149,   150,   233,   145,   165,   191,
     164,   164,   142,   181,   181,   181,   167,   143,   164,   166,
     210,   122,    28,    45,    51,   115,   165,   179,   202,   203,
     207,   208,   209,   213,   142,   166,   165,   213,   166,   165,
     213,   166,   165,   213,   166,   214,   193,   223,   181,   181,
     223,   167,   181,   181,   217,   167,   167,   233,   233,   233,
     233,   136,   136,   145,   233,   233,   145,   183,   193,   193,
     219,   233,   193,   115,   202,   208,   143,   166,   115,   120,
     165,   208,   209,   210,   211,   165,   165,   165,   193,   167,
     181,   166,   181,   181,   166,   181,   182,   167,   145,   145,
     145,   145,   145,   183,   145,   145,   183,   167,   167,   166,
     167,   143,   166,   115,   233,   143,   164,   166,   143,   164,
     166,   167,   217,   186,   183,   183,   183,   183,   183,   183,
     183,   166,   233,   143,   164,   166,   166,   233,   193,   233,
     193,   217,   223,   182,   166,   233,   193,   166,   167,   166,
     167,   166,   181,   166,   181,   166,   167,   166,   166,   166
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_uint8 yyr1[] =
{
       0,   169,   170,   170,   171,   171,   171,   171,   171,   171,
     171,   171,   171,   171,   171,   171,   171,   172,   172,   173,
     174,   174,   175,   175,   175,   175,   175,   175,   175,   175,
     175,   175,   175,   175,   175,   175,   176,   176,   176,   177,
     177,   178,   178,   178,   178,   178,   178,   178,   178,   178,
     179,   179,   180,   180,   181,   181,   182,   182,   183,   183,
     183,   183,   184,   184,   185,   185,   185,   185,   185,   185,
     185,   185,   185,   185,   185,   185,   185,   185,   185,   185,
     185,   185,   185,   185,   185,   185,   185,   185,   185,   186,
     186,   187,   187,   187,   188,   188,   189,   190,   190,   191,
     191,   191,   191,   191,   191,   191,   191,   191,   191,   191,
     191,   191,   191,   191,   191,   191,   191,   191,   191,   192,
     193,   193,   193,   194,   194,   195,   195,   195,   195,   195,
     195,   196,   196,   197,   197,   198,   198,   198,   198,   198,
     198,   198,   198,   198,   198,   199,   199,   200,   200,   200,
     201,   201,   201,   201,   201,   201,   201,   201,   201,   201,
     202,   202,   202,   202,   202,   202,   203,   203,   204,   204,
     204,   205,   205,   205,   205,   205,   205,   206,   206,   206,
     207,   207,   207,   207,   207,   208,   208,   208,   208,   208,
     208,   208,   208,   208,   208,   209,   210,   210,   211,   212,
     212,   212,   212,   213,   213,   213,   213,   214,   214,   214,
     215,   215,   215,   215,   216,   216,   216,   216,   216,   216,
     217,   217,   218,   218,   219,   219,   220,   220,   221,   221,
     222,   222,   222,   222,   222,   222,   222,   222,   222,   223,
     223,   224,   224,   224,   224,   225,   225,   225,   225,   226,
     226,   227,   227,   228,   228,   228,   229,   230,   231,   231,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   232,
     232,   232,   232,   232,   232,   232,   232,   232,   232,   233,
     233,   233,   233,   233,   233,   233,   233,   233,   233,   233,
     233,   233,   233,   233,   233,   233,   233,   233,   233,   233,
     233,   233,   233,   233,   233,   233,   233,   233,   233,   233,
     233,   233,   233,   233,   233,   233,   233,   233,   233,   233,
     233,   233,   233,   233,   233,   233,   233,   233,   233,   233,
     233,   233,   233,   233,   233,   233,   233,   233,   233,   233,
     234,   234,   234,   234,   234,   234,   234,   234,   234,   234,
     234,   234,   234,   234,   234,   234,   234,   234,   234,   234,
     234,   234,   234,   234,   234,   234,   234,   234,   234,   234,
     234,   234,   234,   234,   234,   234,   234,   234,   234,   234,
     234,   234,   234,   234,   234,   234,   234,   234,   234,   234,
     234,   234,   234,   234,   234,   234,   234,   234,   235,   235,
     236,   236,   236,   236,   236,   236,   236,   236,   236,   236
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     3,     1,     4,     1,     1,     2,     4,
       0,     1,     4,     3,     4,     3,     4,     4,     5,     4,
       3,     4,     3,     4,     4,     5,     5,     3,     4,     1,
       2,     1,     1,     1,     1,     1,     1,     2,     1,     1,
       5,     6,     5,     6,     3,     2,     1,     1,     1,     1,
       2,     2,     0,     1,     1,     2,     5,     1,     2,     3,
       3,     2,     2,     2,     3,    11,     7,     5,     7,     5,
       7,     9,     7,     2,     2,     2,     2,     1,     2,     0,
       2,     4,     4,     4,     1,     2,     7,     1,     2,     5,
       4,     5,     4,     5,     4,     5,     4,     5,     4,     5,
       4,     5,     4,     4,     3,     4,     3,     3,     2,     7,
       0,     1,     1,     6,     6,     6,     6,     4,     4,     5,
       5,     2,     0,     1,     3,     1,     1,     2,     2,     2,
       2,     2,     2,     2,     2,     1,     2,     3,     5,     6,
       1,     1,     1,     1,     1,     2,     2,     2,     2,     2,
       1,     1,     1,     2,     2,     2,     0,     1,     3,     4,
       3,     3,     4,     3,     3,     4,     3,     3,     4,     3,
       4,     3,     6,     5,     7,     3,     5,     6,     3,     5,
       6,     2,     4,     1,     1,     2,     1,     2,     2,     1,
       1,     3,     3,     1,     1,     2,     2,     2,     2,     1,
       7,     7,     7,     7,     8,     8,     8,     8,     7,     7,
       2,     0,     1,     3,     4,     4,     0,     1,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       0,     6,     6,     7,     7,     7,     7,     8,     8,     3,
       2,     3,     2,     1,     3,     2,     3,     3,     3,     2,
       1,     1,     3,     1,     2,     2,     2,     3,     2,     3,
       4,     1,     1,     1,     1,     1,     8,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     4,     3,     1,     2,     2,     2,
       2,     2,     5,     5,     5,     2,     1,     3,     2,     6,
       6,     7,     7,     1,     1,     2,     2,     4,     4,     1,
       1,     1,     1,     2,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     5,
       2,     2,     4,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     5,     5,     4,     4,     4,     3,     3,     2,
       1,     1,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     5,     2,     2,
       4,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       5,     5,     4,     4,     4,     3,     3,     2,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (&yylloc, yyscanner, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF

/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YYLOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

# ifndef YYLOCATION_PRINT

#  if defined YY_LOCATION_PRINT

   /* Temporary convenience wrapper in case some people defined the
      undocumented and private YY_LOCATION_PRINT macros.  */
#   define YYLOCATION_PRINT(File, Loc)  YY_LOCATION_PRINT(File, *(Loc))

#  elif defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
}

#   define YYLOCATION_PRINT  yy_location_print_

    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT(File, Loc)  YYLOCATION_PRINT(File, &(Loc))

#  else

#   define YYLOCATION_PRINT(File, Loc) ((void) 0)
    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT  YYLOCATION_PRINT

#  endif
# endif /* !defined YYLOCATION_PRINT */


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, Location, yyscanner); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (yylocationp);
  YY_USE (yyscanner);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  YYLOCATION_PRINT (yyo, yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yykind, yyvaluep, yylocationp, yyscanner);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp,
                 int yyrule, yyscan_t yyscanner)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)],
                       &(yylsp[(yyi + 1) - (yynrhs)]), yyscanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule, yyscanner); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
  YYLTYPE *yylloc;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, yyscan_t yyscanner)
{
  YY_USE (yyvaluep);
  YY_USE (yylocationp);
  YY_USE (yyscanner);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yykind)
    {
    case YYSYMBOL_IDENTIFIER: /* "identifier"  */
#line 1850 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6673 "parser.cpp"
        break;

    case YYSYMBOL_HASHDECL_IDENTIFIER_OPENCURLY: /* "typed hash identifier"  */
#line 1850 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6679 "parser.cpp"
        break;

    case YYSYMBOL_ANGLE_IDENTIFIER: /* "complex type identifier"  */
#line 1850 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6685 "parser.cpp"
        break;

    case YYSYMBOL_VAR_REF: /* "variable reference"  */
#line 1850 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6691 "parser.cpp"
        break;

    case YYSYMBOL_BACKQUOTE: /* "backquote expression"  */
#line 1850 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6697 "parser.cpp"
        break;

    case YYSYMBOL_SELF_REF: /* "in-object member reference"  */
#line 1850 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6703 "parser.cpp"
        break;

    case YYSYMBOL_KW_IDENTIFIER_OPENPAREN: /* "identifier or keyword used as function or method identifier"  */
#line 1850 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6709 "parser.cpp"
        break;

    case YYSYMBOL_SCOPED_REF: /* "namespace or class-scoped reference"  */
#line 1850 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6715 "parser.cpp"
        break;

    case YYSYMBOL_SCOPED_VREF: /* "namespace-scoped global variable reference"  */
#line 1850 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6721 "parser.cpp"
        break;

    case YYSYMBOL_CONTEXT_REF: /* "context reference"  */
#line 1850 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6727 "parser.cpp"
        break;

    case YYSYMBOL_COMPLEX_CONTEXT_REF: /* "named context reference"  */
#line 1850 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6733 "parser.cpp"
        break;

    case YYSYMBOL_QORE_CAST: /* "cast operator"  */
#line 1850 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6739 "parser.cpp"
        break;

    case YYSYMBOL_QORE_OR_NOTHING_CAST: /* "cast (or nothing) operator"  */
#line 1850 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6745 "parser.cpp"
        break;

    case YYSYMBOL_CLASS_STRING: /* "simple class declaration"  */
#line 1850 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6751 "parser.cpp"
        break;

    case YYSYMBOL_DATETIME: /* "date/time value"  */
#line 1851 "parser.ypp"
            { if (((*yyvaluep).datetime)) ((*yyvaluep).datetime)->deref(); }
#line 6757 "parser.cpp"
        break;

    case YYSYMBOL_QUOTED_WORD: /* "quoted string"  */
#line 1851 "parser.ypp"
            { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); }
#line 6763 "parser.cpp"
        break;

    case YYSYMBOL_BINARY: /* "binary constant value"  */
#line 1851 "parser.ypp"
            { if (((*yyvaluep).binary)) ((*yyvaluep).binary)->deref(); }
#line 6769 "parser.cpp"
        break;

    case YYSYMBOL_REGEX_SUBST: /* "regular expression substitution expression"  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).RegexSubst); }
#line 6775 "parser.cpp"
        break;

    case YYSYMBOL_REGEX_TRANS: /* "transliteration expression"  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).Trans); }
#line 6781 "parser.cpp"
        break;

    case YYSYMBOL_CLASS_SCOPED_REF: /* "scoped class declaration"  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).nscope); }
#line 6787 "parser.cpp"
        break;

    case YYSYMBOL_BASE_CLASS_CALL: /* "call to base class method"  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).nscope); }
#line 6793 "parser.cpp"
        break;

    case YYSYMBOL_REGEX: /* "regular expression"  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).Regex); }
#line 6799 "parser.cpp"
        break;

    case YYSYMBOL_REGEX_EXTRACT: /* "regular expression extraction expression"  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).Regex); }
#line 6805 "parser.cpp"
        break;

    case YYSYMBOL_IMPLICIT_ARG_REF: /* "implicit argument reference"  */
#line 1851 "parser.ypp"
            { if (((*yyvaluep).implicit_arg)) ((*yyvaluep).implicit_arg)->deref(); }
#line 6811 "parser.cpp"
        break;

    case YYSYMBOL_DOT_KW_IDENTIFIER: /* "keyword used as hash key or object member reference"  */
#line 1851 "parser.ypp"
            { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); }
#line 6817 "parser.cpp"
        break;

    case YYSYMBOL_TRY_MODULE_ERROR: /* "%try-module error token"  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).trymod); }
#line 6823 "parser.cpp"
        break;

    case YYSYMBOL_gvardecl: /* gvardecl  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).gv); }
#line 6829 "parser.cpp"
        break;

    case YYSYMBOL_top_namespace_decl: /* top_namespace_decl  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).ns); }
#line 6835 "parser.cpp"
        break;

    case YYSYMBOL_namespace_decls: /* namespace_decls  */
#line 1851 "parser.ypp"
            { if (((*yyvaluep).nsnlist)) ((*yyvaluep).nsnlist)->deref(); }
#line 6841 "parser.cpp"
        break;

    case YYSYMBOL_namespace_decl: /* namespace_decl  */
#line 1851 "parser.ypp"
            { if (((*yyvaluep).nsn)) ((*yyvaluep).nsn)->deref(); }
#line 6847 "parser.cpp"
        break;

    case YYSYMBOL_unscoped_const_decl: /* unscoped_const_decl  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).constnode); }
#line 6853 "parser.cpp"
        break;

    case YYSYMBOL_scoped_const_decl: /* scoped_const_decl  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).constnode); }
#line 6859 "parser.cpp"
        break;

    case YYSYMBOL_block: /* block  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).sblock); }
#line 6865 "parser.cpp"
        break;

    case YYSYMBOL_statement_or_block: /* statement_or_block  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).sblock); }
#line 6871 "parser.cpp"
        break;

    case YYSYMBOL_statements: /* statements  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).sblock); }
#line 6877 "parser.cpp"
        break;

    case YYSYMBOL_optname: /* optname  */
#line 1850 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 6883 "parser.cpp"
        break;

    case YYSYMBOL_statement: /* statement  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).statement); }
#line 6889 "parser.cpp"
        break;

    case YYSYMBOL_context_mods: /* context_mods  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).cmods); }
#line 6895 "parser.cpp"
        break;

    case YYSYMBOL_context_mod: /* context_mod  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).cmod); }
#line 6901 "parser.cpp"
        break;

    case YYSYMBOL_return_statement: /* return_statement  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).statement); }
#line 6907 "parser.cpp"
        break;

    case YYSYMBOL_switch_statement: /* switch_statement  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).statement); }
#line 6913 "parser.cpp"
        break;

    case YYSYMBOL_case_block: /* case_block  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).switchstmt); }
#line 6919 "parser.cpp"
        break;

    case YYSYMBOL_case_code: /* case_code  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).casenode); }
#line 6925 "parser.cpp"
        break;

    case YYSYMBOL_try_statement: /* try_statement  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).statement); }
#line 6931 "parser.cpp"
        break;

    case YYSYMBOL_myexp: /* myexp  */
#line 1853 "parser.ypp"
            { ((*yyvaluep).qv).discard(nullptr); }
#line 6937 "parser.cpp"
        break;

    case YYSYMBOL_hashdecl_def: /* hashdecl_def  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).hashdecldef); }
#line 6943 "parser.cpp"
        break;

    case YYSYMBOL_class_def: /* class_def  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).classdef); }
#line 6949 "parser.cpp"
        break;

    case YYSYMBOL_inheritance_list: /* inheritance_list  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).sclist); }
#line 6955 "parser.cpp"
        break;

    case YYSYMBOL_superclass_list: /* superclass_list  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).sclist); }
#line 6961 "parser.cpp"
        break;

    case YYSYMBOL_superclass: /* superclass  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).sclnode); }
#line 6967 "parser.cpp"
        break;

    case YYSYMBOL_hashdecl_attrs: /* hashdecl_attrs  */
#line 1851 "parser.ypp"
            { if (((*yyvaluep).hashdeclpriv)) ((*yyvaluep).hashdeclpriv)->deref(); }
#line 6973 "parser.cpp"
        break;

    case YYSYMBOL_hashdecl_member: /* hashdecl_member  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).memberinfo); }
#line 6979 "parser.cpp"
        break;

    case YYSYMBOL_class_attributes: /* class_attributes  */
#line 1849 "parser.ypp"
            { qore_class_private::get(*((*yyvaluep).qoreclass))->deref(true, true); }
#line 6985 "parser.cpp"
        break;

    case YYSYMBOL_uncqtypedef: /* uncqtypedef  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).parsertype); }
#line 6991 "parser.cpp"
        break;

    case YYSYMBOL_qtypedef: /* qtypedef  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).parsertype); }
#line 6997 "parser.cpp"
        break;

    case YYSYMBOL_internal_member_list: /* internal_member_list  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).memberlist); }
#line 7003 "parser.cpp"
        break;

    case YYSYMBOL_private_member_list: /* private_member_list  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).memberlist); }
#line 7009 "parser.cpp"
        break;

    case YYSYMBOL_public_member_list: /* public_member_list  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).memberlist); }
#line 7015 "parser.cpp"
        break;

    case YYSYMBOL_classvardecl: /* classvardecl  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).classvarinfo); }
#line 7021 "parser.cpp"
        break;

    case YYSYMBOL_member2: /* member2  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).memberinfo); }
#line 7027 "parser.cpp"
        break;

    case YYSYMBOL_transient_member2: /* transient_member2  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).memberinfo); }
#line 7033 "parser.cpp"
        break;

    case YYSYMBOL_member: /* member  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).memberinfo); }
#line 7039 "parser.cpp"
        break;

    case YYSYMBOL_transient_member: /* transient_member  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).memberinfo); }
#line 7045 "parser.cpp"
        break;

    case YYSYMBOL_member_list: /* member_list  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).memberlist); }
#line 7051 "parser.cpp"
        break;

    case YYSYMBOL_member_list2: /* member_list2  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).memberlist); }
#line 7057 "parser.cpp"
        break;

    case YYSYMBOL_ident_openparen: /* ident_openparen  */
#line 1850 "parser.ypp"
            { free(((*yyvaluep).string)); }
#line 7063 "parser.cpp"
        break;

    case YYSYMBOL_inline_methoddef: /* inline_methoddef  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).methodnode); }
#line 7069 "parser.cpp"
        break;

    case YYSYMBOL_outofline_methoddef: /* outofline_methoddef  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).methoddef); }
#line 7075 "parser.cpp"
        break;

    case YYSYMBOL_base_constructor_list: /* base_constructor_list  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).bcalist); }
#line 7081 "parser.cpp"
        break;

    case YYSYMBOL_base_constructors: /* base_constructors  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).bcalist); }
#line 7087 "parser.cpp"
        break;

    case YYSYMBOL_base_constructor: /* base_constructor  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).bcanode); }
#line 7093 "parser.cpp"
        break;

    case YYSYMBOL_return_value: /* return_value  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).returnTypeInfo); }
#line 7099 "parser.cpp"
        break;

    case YYSYMBOL_sub_def: /* sub_def  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).parsefunc); }
#line 7105 "parser.cpp"
        break;

    case YYSYMBOL_scoped_sub_def: /* scoped_sub_def  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).sparsefunc); }
#line 7111 "parser.cpp"
        break;

    case YYSYMBOL_list: /* list  */
#line 1851 "parser.ypp"
            { if (((*yyvaluep).parse_list)) ((*yyvaluep).parse_list)->deref(); }
#line 7117 "parser.cpp"
        break;

    case YYSYMBOL_list_n: /* list_n  */
#line 1851 "parser.ypp"
            { if (((*yyvaluep).parse_list)) ((*yyvaluep).parse_list)->deref(); }
#line 7123 "parser.cpp"
        break;

    case YYSYMBOL_hash: /* hash  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).hash); }
#line 7129 "parser.cpp"
        break;

    case YYSYMBOL_hash_element: /* hash_element  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).hashelement); }
#line 7135 "parser.cpp"
        break;

    case YYSYMBOL_alt_hash: /* alt_hash  */
#line 1848 "parser.ypp"
            { delete ((*yyvaluep).hash); }
#line 7141 "parser.cpp"
        break;

    case YYSYMBOL_immediate_typed_hash: /* immediate_typed_hash  */
#line 1852 "parser.ypp"
            { if (((*yyvaluep).node)) ((*yyvaluep).node)->deref(nullptr); }
#line 7147 "parser.cpp"
        break;

    case YYSYMBOL_exp_c: /* exp_c  */
#line 1853 "parser.ypp"
            { ((*yyvaluep).qv).discard(nullptr); }
#line 7153 "parser.cpp"
        break;

    case YYSYMBOL_exp: /* exp  */
#line 1853 "parser.ypp"
            { ((*yyvaluep).qv).discard(nullptr); }
#line 7159 "parser.cpp"
        break;

    case YYSYMBOL_exp_n: /* exp_n  */
#line 1853 "parser.ypp"
            { ((*yyvaluep).qv).discard(nullptr); }
#line 7165 "parser.cpp"
        break;

    case YYSYMBOL_string: /* string  */
#line 1851 "parser.ypp"
            { if (((*yyvaluep).String)) ((*yyvaluep).String)->deref(); }
#line 7171 "parser.cpp"
        break;

    case YYSYMBOL_scalar: /* scalar  */
#line 1853 "parser.ypp"
            { ((*yyvaluep).qv).discard(nullptr); }
#line 7177 "parser.cpp"
        break;

      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (yyscan_t yyscanner)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static YYLTYPE yyloc_default
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs = 0;

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

    /* The location stack: array, bottom, top.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls = yylsa;
    YYLTYPE *yylsp = yyls;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[3];

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, &yylloc, yyscanner);
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      yyerror_range[1] = yylloc;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 4: /* top_level_command: sub_def  */
#line 1861 "parser.ypp"
                {
           (yyvsp[0].parsefunc)->add(*(qore_ns_private::get(*(getRootNS()))));
        }
#line 7485 "parser.cpp"
    break;

  case 5: /* top_level_command: scoped_sub_def  */
#line 1864 "parser.ypp"
                         {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[0].sparsefunc)->loc, "function", (yyvsp[0].sparsefunc)->name.ostr);
           (yyvsp[0].sparsefunc)->add(*(qore_ns_private::get(*(getRootNS()))));
        }
#line 7495 "parser.cpp"
    break;

  case 6: /* top_level_command: class_def  */
#line 1869 "parser.ypp"
                    {
           qore_root_ns_private::parseAddClass((yyvsp[0].classdef)->loc, *((yyvsp[0].classdef)->name), (yyvsp[0].classdef)->oc);

           // see if class definitions are allowed
           if (parse_check_parse_option(PO_NO_CLASS_DEFS))
              parse_error(*(yyvsp[0].classdef)->loc, "illegal class definition \"%s\" (conflicts with parse option NO_CLASS_DEFS)", (yyvsp[0].classdef)->oc->getName());
           delete (yyvsp[0].classdef);
        }
#line 7508 "parser.cpp"
    break;

  case 7: /* top_level_command: hashdecl_def  */
#line 1877 "parser.ypp"
                       {
           qore_root_ns_private::parseAddHashDecl((yyvsp[0].hashdecldef)->loc, *((yyvsp[0].hashdecldef)->name), (yyvsp[0].hashdecldef)->takeHashDecl());
           delete (yyvsp[0].hashdecldef);
        }
#line 7517 "parser.cpp"
    break;

  case 8: /* top_level_command: scoped_const_decl  */
#line 1881 "parser.ypp"
                            {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[0].constnode)->loc, "constant", (yyvsp[0].constnode)->name.ostr);
           qore_root_ns_private::parseAddConstant((yyvsp[0].constnode)->loc, *getRootNS(), (yyvsp[0].constnode)->name, (yyvsp[0].constnode)->value, (yyvsp[0].constnode)->pub);
           delete (yyvsp[0].constnode);
        }
#line 7528 "parser.cpp"
    break;

  case 9: /* top_level_command: unscoped_const_decl  */
#line 1887 "parser.ypp"
                              {
           qore_root_ns_private::parseAddConstant((yyvsp[0].constnode)->loc, *getRootNS(), (yyvsp[0].constnode)->name, (yyvsp[0].constnode)->value, (yyvsp[0].constnode)->pub);
           delete (yyvsp[0].constnode);
        }
#line 7537 "parser.cpp"
    break;

  case 10: /* top_level_command: outofline_methoddef  */
#line 1891 "parser.ypp"
                              {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[0].methoddef)->loc, "method", (yyvsp[0].methoddef)->name.ostr);
           (yyvsp[0].methoddef)->parseAddToClassAndDel();
        }
#line 7547 "parser.cpp"
    break;

  case 11: /* top_level_command: statement  */
#line 1896 "parser.ypp"
                    {
           if ((yyvsp[0].statement)) {
              if ((yyvsp[0].statement)->isParseDeclaration())
                 delete (yyvsp[0].statement);
              else
                 qore_program_private::addStatement(*(getProgram()), (yyvsp[0].statement));
           }
        }
#line 7560 "parser.cpp"
    break;

  case 13: /* top_level_command: '{' statements '}'  */
#line 1905 "parser.ypp"
                             {
            (yyvsp[-1].sblock)->finalizeBlock((yylsp[-2]).first_line, (yylsp[-1]).last_line);
            qore_program_private::addStatement(*(getProgram()), (yyvsp[-1].sblock));
        }
#line 7569 "parser.cpp"
    break;

  case 14: /* top_level_command: top_namespace_decl  */
#line 1909 "parser.ypp"
                             {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            qore_root_ns_private::parseAddNamespace((yyvsp[0].ns));
            // see if ns declaration is legal
            if (parse_check_parse_option(PO_NO_NAMESPACE_DEFS))
                parse_error(*loc, "illegal namespace definition \"%s\" (conflicts with parse option PO_NO_NAMESPACE_DEFINITION)", (yyvsp[0].ns)->getName());
        }
#line 7581 "parser.cpp"
    break;

  case 15: /* top_level_command: "module" '{' module_decls '}'  */
#line 1916 "parser.ypp"
                                          {
            QoreModuleDefContext* qmd = get_module_def_context();
            if (!qmd)
                qore_program_private::makeParseWarning(getProgram(), *qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line), QP_WARN_MODULE_ONLY, "MODULE-ONLY", "module definitions are ignored when not defining a module");
            else {
                QoreUserModuleDefContextHelper* uqmd = static_cast<QoreUserModuleDefContextHelper*>(qmd);
                uqmd->close();
            }
            // registered internally
        }
#line 7596 "parser.cpp"
    break;

  case 16: /* top_level_command: "%try-module error token"  */
#line 1926 "parser.ypp"
                           {
            bool has_dollar = (yyvsp[0].trymod)->var[0] == '$';
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            if (!has_dollar) {
                if (!parse_check_parse_option(PO_ALLOW_BARE_REFS)) {
                    parse_error(*loc, "%%try-module variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[0].trymod)->var);
                }
            } else {
                (yyvsp[0].trymod)->fixName();
                if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                    parse_error(*loc, "%%try-module variable '%s' declared with '$' prefix, but parse option 'allow-bare-refs' is set", (yyvsp[0].trymod)->var);
            }

            if (parse_check_parse_option(PO_NO_TOP_LEVEL_STATEMENTS)) {
                parse_error(*loc, "'%%try-module' with exception variable cannot be used with parse option NO_TOP_LEVEL_STATEMENTS; use %%try-module without an exception variable instead");
            } else {
                VarRefTryModuleErrorNode* left = new VarRefTryModuleErrorNode(loc, (yyvsp[0].trymod)->takeName());
                QoreAssignmentOperatorNode* exp = new QoreAssignmentOperatorNode(loc, left, (yyvsp[0].trymod)->takeExceptionHash());
                qore_program_private::addStatement(*(getProgram()), new ExpressionStatement(loc, exp));
            }
            delete (yyvsp[0].trymod);
        }
#line 7623 "parser.cpp"
    break;

  case 17: /* module_decls: module_decl  */
#line 1951 "parser.ypp"
                    {
        }
#line 7630 "parser.cpp"
    break;

  case 18: /* module_decls: module_decls module_decl  */
#line 1953 "parser.ypp"
                                   {
        }
#line 7637 "parser.cpp"
    break;

  case 19: /* module_decl: "identifier" '=' exp ';'  */
#line 1958 "parser.ypp"
                               {
            QoreModuleDefContext* qmd = get_module_def_context();
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[-1]).last_line);
            if (!qmd)
                qore_program_private::makeParseWarning(getProgram(), *loc, QP_WARN_MODULE_ONLY, "MODULE-ONLY", "cannot add module tag '%s' = <%s> when not defining a module", (yyvsp[-3].string), (yyvsp[-1].qv).getTypeName());
            else
                qmd->set(loc, (yyvsp[-3].string), (yyvsp[-1].qv));

            free((yyvsp[-3].string));
            (yyvsp[-1].qv).discard(nullptr);
        }
#line 7653 "parser.cpp"
    break;

  case 20: /* ppub: %empty  */
#line 1972 "parser.ypp"
        { (yyval.b) = false; }
#line 7659 "parser.cpp"
    break;

  case 21: /* ppub: "public"  */
#line 1973 "parser.ypp"
                     {
           (yyval.b) = true;
        }
#line 7667 "parser.cpp"
    break;

  case 22: /* gvardecl: ppub "our" uncqtypedef "namespace or class-scoped reference"  */
#line 1979 "parser.ypp"
                                            {
            fix_start_location((yyvsp[-3].b), (yyloc), (yylsp[-2]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].b) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "global variable", (yyvsp[0].string));
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)), (yyvsp[-3].b), true);
            delete (yyvsp[-1].parsertype);
        }
#line 7681 "parser.cpp"
    break;

  case 23: /* gvardecl: ppub "our" "namespace or class-scoped reference"  */
#line 1988 "parser.ypp"
                                  {
            fix_start_location((yyvsp[-2].b), (yyloc), (yylsp[-1]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-2].b) ? (yylsp[-2]).first_line : (yylsp[-1]).first_line, (yylsp[0]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "global variable", (yyvsp[0].string));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), 0, 0, (yyvsp[-2].b), true);
        }
#line 7693 "parser.cpp"
    break;

  case 24: /* gvardecl: ppub "our" uncqtypedef "identifier"  */
#line 1995 "parser.ypp"
                                              {
            fix_start_location((yyvsp[-3].b), (yyloc), (yylsp[-2]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].b) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)), (yyvsp[-3].b), true);
            delete (yyvsp[-1].parsertype);
        }
#line 7705 "parser.cpp"
    break;

  case 25: /* gvardecl: ppub "our" "identifier"  */
#line 2002 "parser.ypp"
                                  {
            fix_start_location((yyvsp[-2].b), (yyloc), (yylsp[-1]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-2].b) ? (yylsp[-2]).first_line : (yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), 0, 0, (yyvsp[-2].b), true);
        }
#line 7715 "parser.cpp"
    break;

  case 26: /* gvardecl: ppub "our" qtypedef "namespace-scoped global variable reference"  */
#line 2007 "parser.ypp"
                                            {
            fix_start_location((yyvsp[-3].b), (yyloc), (yylsp[-2]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].b) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "global variable", (yyvsp[0].string));
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)), (yyvsp[-3].b), false);
            delete (yyvsp[-1].parsertype);
        }
#line 7729 "parser.cpp"
    break;

  case 27: /* gvardecl: ppub "our" qtypedef "variable reference"  */
#line 2016 "parser.ypp"
                                        {
            fix_start_location((yyvsp[-3].b), (yyloc), (yylsp[-2]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].b) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)), (yyvsp[-3].b), false);
            delete (yyvsp[-1].parsertype);
        }
#line 7741 "parser.cpp"
    break;

  case 28: /* gvardecl: ppub "our" '(' list ')'  */
#line 2023 "parser.ypp"
                                    {
            fix_start_location((yyvsp[-4].b), (yyloc), (yylsp[-3]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-4].b) ? (yylsp[-4]).first_line : (yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.gv) = new GVarListDecl(loc, (yyvsp[-1].parse_list), (yyvsp[-4].b));
        }
#line 7751 "parser.cpp"
    break;

  case 29: /* gvardecl: ppub "thread_local" uncqtypedef "namespace or class-scoped reference"  */
#line 2028 "parser.ypp"
                                                       {
            fix_start_location((yyvsp[-3].b), (yyloc), (yylsp[-2]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].b) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "thread_local variable", (yyvsp[0].string));
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)), (yyvsp[-3].b), true, VT_THREAD_LOCAL);
            delete (yyvsp[-1].parsertype);
        }
#line 7765 "parser.cpp"
    break;

  case 30: /* gvardecl: ppub "thread_local" "namespace or class-scoped reference"  */
#line 2037 "parser.ypp"
                                           {
            fix_start_location((yyvsp[-2].b), (yyloc), (yylsp[-1]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-2].b) ? (yylsp[-2]).first_line : (yylsp[-1]).first_line, (yylsp[0]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "thread_local variable", (yyvsp[0].string));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), 0, 0, (yyvsp[-2].b), true, VT_THREAD_LOCAL);
        }
#line 7777 "parser.cpp"
    break;

  case 31: /* gvardecl: ppub "thread_local" uncqtypedef "identifier"  */
#line 2044 "parser.ypp"
                                                       {
            fix_start_location((yyvsp[-3].b), (yyloc), (yylsp[-2]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].b) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)), (yyvsp[-3].b), true, VT_THREAD_LOCAL);
            delete (yyvsp[-1].parsertype);
        }
#line 7789 "parser.cpp"
    break;

  case 32: /* gvardecl: ppub "thread_local" "identifier"  */
#line 2051 "parser.ypp"
                                           {
            fix_start_location((yyvsp[-2].b), (yyloc), (yylsp[-1]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-2].b) ? (yylsp[-2]).first_line : (yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), 0, 0, (yyvsp[-2].b), true, VT_THREAD_LOCAL);
        }
#line 7799 "parser.cpp"
    break;

  case 33: /* gvardecl: ppub "thread_local" qtypedef "namespace-scoped global variable reference"  */
#line 2056 "parser.ypp"
                                                     {
            fix_start_location((yyvsp[-3].b), (yyloc), (yylsp[-2]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].b) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "thread_local variable", (yyvsp[0].string));
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)), (yyvsp[-3].b), false, VT_THREAD_LOCAL);
            delete (yyvsp[-1].parsertype);
        }
#line 7813 "parser.cpp"
    break;

  case 34: /* gvardecl: ppub "thread_local" qtypedef "variable reference"  */
#line 2065 "parser.ypp"
                                                 {
            fix_start_location((yyvsp[-3].b), (yyloc), (yylsp[-2]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].b) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype));
            (yyval.gv) = new GVarSingleDecl(loc, (yyvsp[0].string), t, t ? 0 : ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)), (yyvsp[-3].b), false, VT_THREAD_LOCAL);
            delete (yyvsp[-1].parsertype);
        }
#line 7825 "parser.cpp"
    break;

  case 35: /* gvardecl: ppub "thread_local" '(' list ')'  */
#line 2072 "parser.ypp"
                                             {
            fix_start_location((yyvsp[-4].b), (yyloc), (yylsp[-3]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-4].b) ? (yylsp[-4]).first_line : (yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.gv) = new GVarListDecl(loc, (yyvsp[-1].parse_list), (yyvsp[-4].b), VT_THREAD_LOCAL);
        }
#line 7835 "parser.cpp"
    break;

  case 36: /* top_namespace_decl: nsc_modifiers "namespace" '{' namespace_decls '}'  */
#line 2080 "parser.ypp"
                                                            {
            fix_start_location((yyvsp[-4].i4), (yyloc), (yylsp[-3]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-4].i4) ? (yylsp[-4]).first_line : (yylsp[-3]).first_line, (yylsp[0]).last_line);
            qore_ns_private* p = new qore_ns_private(loc);
            check_nsmod(loc, (yyvsp[-4].i4), *p);
            (yyvsp[-1].nsnlist)->add(*p);
            delete (yyvsp[-1].nsnlist);
            (yyval.ns) = p->ns;
        }
#line 7849 "parser.cpp"
    break;

  case 37: /* top_namespace_decl: nsc_modifiers "namespace" ';'  */
#line 2089 "parser.ypp"
                                          {
            fix_start_location((yyvsp[-2].i4), (yyloc), (yylsp[-1]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-2].i4) ? (yylsp[-2]).first_line : (yylsp[-1]).first_line, (yylsp[-1]).last_line);
            qore_ns_private* p = new qore_ns_private(loc);
            check_nsmod(loc, (yyvsp[-2].i4), *p);
            (yyval.ns) = p->ns;
        }
#line 7861 "parser.cpp"
    break;

  case 38: /* top_namespace_decl: nsc_modifiers "namespace" '{' '}'  */
#line 2096 "parser.ypp"
                                              {
            fix_start_location((yyvsp[-3].i4), (yyloc), (yylsp[-2]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].i4) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[0]).last_line);
            qore_ns_private* p = new qore_ns_private(loc);
            check_nsmod(loc, (yyvsp[-3].i4), *p);
            (yyval.ns) = p->ns;
        }
#line 7873 "parser.cpp"
    break;

  case 39: /* namespace_decls: namespace_decl  */
#line 2106 "parser.ypp"
                       {
           (yyval.nsnlist) = new NSNodeList;
           if ((yyvsp[0].nsn))
              (yyval.nsnlist)->push_back((yyvsp[0].nsn));
        }
#line 7883 "parser.cpp"
    break;

  case 40: /* namespace_decls: namespace_decls namespace_decl  */
#line 2111 "parser.ypp"
                                         {
           (yyval.nsnlist) = (yyvsp[-1].nsnlist);
           if ((yyvsp[0].nsn))
              (yyval.nsnlist)->push_back((yyvsp[0].nsn));
        }
#line 7893 "parser.cpp"
    break;

  case 41: /* namespace_decl: scoped_const_decl  */
#line 2119 "parser.ypp"
                          {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[0].constnode)->loc, "constant", (yyvsp[0].constnode)->name.ostr);
           (yyval.nsn) = new NSNode((yyvsp[0].constnode));
        }
#line 7903 "parser.cpp"
    break;

  case 42: /* namespace_decl: unscoped_const_decl  */
#line 2124 "parser.ypp"
                              {
           (yyval.nsn) = new NSNode((yyvsp[0].constnode));
        }
#line 7911 "parser.cpp"
    break;

  case 43: /* namespace_decl: class_def  */
#line 2127 "parser.ypp"
                    {
            (yyval.nsn) = new NSNode((yyvsp[0].classdef));
            // see if class definitions are allowed
            if (parse_check_parse_option(PO_NO_CLASS_DEFS)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
                parse_error(*loc, "illegal class definition \"%s\" (conflicts with parse option PO_NO_CLASS_DEFS)", (yyvsp[0].classdef)->oc->getName());
            }
        }
#line 7924 "parser.cpp"
    break;

  case 44: /* namespace_decl: hashdecl_def  */
#line 2135 "parser.ypp"
                       {
           (yyval.nsn) = new NSNode((yyvsp[0].hashdecldef));
        }
#line 7932 "parser.cpp"
    break;

  case 45: /* namespace_decl: sub_def  */
#line 2138 "parser.ypp"
                  {
           (yyval.nsn) = new NSNode((yyvsp[0].parsefunc));
        }
#line 7940 "parser.cpp"
    break;

  case 46: /* namespace_decl: scoped_sub_def  */
#line 2141 "parser.ypp"
                         {
           // see if strong encapsulation is enabled
           check_strong_encapsulation((yyvsp[0].sparsefunc)->loc, "function", (yyvsp[0].sparsefunc)->name.ostr);
           (yyval.nsn) = new NSNode((yyvsp[0].sparsefunc));
        }
#line 7950 "parser.cpp"
    break;

  case 47: /* namespace_decl: gvardecl ';'  */
#line 2146 "parser.ypp"
                       {
           (yyval.nsn) = new NSNode((yyvsp[-1].gv));
        }
#line 7958 "parser.cpp"
    break;

  case 48: /* namespace_decl: top_namespace_decl  */
#line 2149 "parser.ypp"
                             {
            (yyval.nsn) = new NSNode((yyvsp[0].ns));
            // see if ns declaration is legal
            if (parse_check_parse_option(PO_NO_NAMESPACE_DEFS)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
                parse_error(*loc, "illegal namespace definition \"%s\" (conflicts with parse option PO_NO_NAMESPACE_DEFINITION)", (yyvsp[0].ns)->getName());
            }
        }
#line 7971 "parser.cpp"
    break;

  case 49: /* namespace_decl: outofline_methoddef  */
#line 2157 "parser.ypp"
                              {
           (yyval.nsn) = new NSNode((yyvsp[0].methoddef));
        }
#line 7979 "parser.cpp"
    break;

  case 50: /* unscoped_const_decl: "const" "identifier" '=' exp ';'  */
#line 2163 "parser.ypp"
                                         {
           (yyval.constnode) = new ConstNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].string), (yyvsp[-1].qv));
        }
#line 7987 "parser.cpp"
    break;

  case 51: /* unscoped_const_decl: "public" "const" "identifier" '=' exp ';'  */
#line 2166 "parser.ypp"
                                                      {
           (yyval.constnode) = new ConstNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].string), (yyvsp[-1].qv), true);
        }
#line 7995 "parser.cpp"
    break;

  case 52: /* scoped_const_decl: "const" "namespace or class-scoped reference" '=' exp ';'  */
#line 2172 "parser.ypp"
                                         {
           (yyval.constnode) = new ConstNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].string), (yyvsp[-1].qv));
        }
#line 8003 "parser.cpp"
    break;

  case 53: /* scoped_const_decl: "public" "const" "namespace or class-scoped reference" '=' exp ';'  */
#line 2175 "parser.ypp"
                                                      {
           (yyval.constnode) = new ConstNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].string), (yyvsp[-1].qv), true);
        }
#line 8011 "parser.cpp"
    break;

  case 54: /* block: '{' statements '}'  */
#line 2182 "parser.ypp"
        { (yyval.sblock) = (yyvsp[-1].sblock); }
#line 8017 "parser.cpp"
    break;

  case 55: /* block: '{' '}'  */
#line 2185 "parser.ypp"
        { (yyval.sblock) = new StatementBlock((yylsp[-1]).first_line, (yylsp[-1]).last_line); }
#line 8023 "parser.cpp"
    break;

  case 56: /* statement_or_block: statement  */
#line 2190 "parser.ypp"
        { (yyval.sblock) = new StatementBlock((yylsp[0]).first_line, (yylsp[0]).last_line, (yyvsp[0].statement)); }
#line 8029 "parser.cpp"
    break;

  case 57: /* statement_or_block: block  */
#line 2193 "parser.ypp"
        { (yyval.sblock) = (yyvsp[0].sblock); }
#line 8035 "parser.cpp"
    break;

  case 58: /* statements: statement  */
#line 2198 "parser.ypp"
        { (yyval.sblock) = new StatementBlock((yylsp[0]).first_line, (yylsp[0]).last_line, (yyvsp[0].statement)); }
#line 8041 "parser.cpp"
    break;

  case 59: /* statements: block  */
#line 2200 "parser.ypp"
        { (yyval.sblock) = new StatementBlock((yylsp[0]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock)); }
#line 8047 "parser.cpp"
    break;

  case 60: /* statements: statements block  */
#line 2202 "parser.ypp"
        { (yyvsp[-1].sblock)->addStatement((yyvsp[0].sblock)); (yyval.sblock) = (yyvsp[-1].sblock); }
#line 8053 "parser.cpp"
    break;

  case 61: /* statements: statements statement  */
#line 2204 "parser.ypp"
        { (yyvsp[-1].sblock)->addStatement((yyvsp[0].statement)); (yyval.sblock) = (yyvsp[-1].sblock); }
#line 8059 "parser.cpp"
    break;

  case 62: /* optname: %empty  */
#line 2209 "parser.ypp"
        { (yyval.string) = 0; }
#line 8065 "parser.cpp"
    break;

  case 63: /* optname: "identifier"  */
#line 2210 "parser.ypp"
                     { (yyval.string) = (yyvsp[0].string); }
#line 8071 "parser.cpp"
    break;

  case 64: /* statement: ';'  */
#line 2214 "parser.ypp"
            { (yyval.statement) = new StatementBlock((yylsp[0]).first_line, (yylsp[0]).last_line); }
#line 8077 "parser.cpp"
    break;

  case 65: /* statement: exp_n ';'  */
#line 2215 "parser.ypp"
                    {
            qore_program_private* pgm = qore_program_private::get(*getProgram());
            // if the expression has no effect and it's not a variable declaration
            qore_type_t t = (yyvsp[-1].qv).getType();
            bool ok = false;
            if (t == NT_PARSE_LIST) {
                QoreParseListNode* l = (yyvsp[-1].qv).get<QoreParseListNode>();
                // rewrite expression if it's a list without parentheses under certain conditions
                (yyvsp[-1].qv).set(check_rewrite_list(l));

                if (l->isVariableList())
                    ok = true;
            }

            const QoreProgramLocation* loc = pgm->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);

            if (!ok) {
                if (!value_has_effect_as_root((yyvsp[-1].qv)) && (t != NT_VARREF || !(yyvsp[-1].qv).get<VarRefNode>()->parseIsDecl())) {
                    if (!parse_check_parse_option(PO_ALLOW_STATEMENT_NO_EFFECT)) {
                        parse_error(*loc, "expression has no effect as a statement (%s)", (yyvsp[-1].qv).getTypeName());
                    }
                } else if (!(yyvsp[-1].qv).hasEffect() && (t != NT_VARREF || !(yyvsp[-1].qv).get<VarRefNode>()->parseIsDecl())) {
                    parse_error(*loc, "statement has no effect (%s)", (yyvsp[-1].qv).getTypeName());
                }
            }

            ignore_return_value((yyvsp[-1].qv));
            (yyval.statement) = new ExpressionStatement(loc, (yyvsp[-1].qv));
        }
#line 8111 "parser.cpp"
    break;

  case 66: /* statement: "namespace or class-scoped reference" '(' myexp ')' ';'  */
#line 2245 "parser.ypp"
                                       {
            NamedScope *ns = new NamedScope((yyvsp[-4].string));
            assert(ns->size() > 1);
            printd(5, "statement: parsing static method call: %s() size=%d\n", ns->ostr, ns->size());
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[-1]).last_line);
            (yyval.statement) = new ExpressionStatement(loc, new StaticMethodCallNode(loc, ns, make_args(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line), (yyvsp[-2].qv))));
        }
#line 8123 "parser.cpp"
    break;

  case 67: /* statement: try_statement  */
#line 2253 "parser.ypp"
        { (yyval.statement) = (yyvsp[0].statement); }
#line 8129 "parser.cpp"
    break;

  case 68: /* statement: "rethrow" ';'  */
#line 2254 "parser.ypp"
                          {
           (yyval.statement) = new RethrowStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line);
        }
#line 8137 "parser.cpp"
    break;

  case 69: /* statement: "rethrow" exp ';'  */
#line 2257 "parser.ypp"
                              {
           (yyval.statement) = new RethrowStatement((yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-1].qv));
        }
#line 8145 "parser.cpp"
    break;

  case 70: /* statement: "throw" exp ';'  */
#line 2260 "parser.ypp"
                            {
           (yyval.statement) = new ThrowStatement((yylsp[-2]).first_line, (yylsp[-1]).last_line, (yyvsp[-1].qv));
        }
#line 8153 "parser.cpp"
    break;

  case 71: /* statement: "on_exit" statement_or_block  */
#line 2263 "parser.ypp"
                                         {
           (yyval.statement) = new OnBlockExitStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock), OBE_Unconditional);
        }
#line 8161 "parser.cpp"
    break;

  case 72: /* statement: "on_success" statement_or_block  */
#line 2266 "parser.ypp"
                                            {
           (yyval.statement) = new OnBlockExitStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock), OBE_Success);
        }
#line 8169 "parser.cpp"
    break;

  case 73: /* statement: "on_error" statement_or_block  */
#line 2269 "parser.ypp"
                                          {
           (yyval.statement) = new OnBlockExitStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].sblock), OBE_Error);
        }
#line 8177 "parser.cpp"
    break;

  case 74: /* statement: "subcontext" context_mods statement_or_block  */
#line 2272 "parser.ypp"
                                                          {
           (yyval.statement) = new ContextStatement((yylsp[-2]).first_line, (yylsp[0]).last_line, 0, 0, (yyvsp[-1].cmods), (yyvsp[0].sblock));
        }
#line 8185 "parser.cpp"
    break;

  case 75: /* statement: "summarize" optname '(' exp ')' "by" '(' exp ')' context_mods statement_or_block  */
#line 2275 "parser.ypp"
                                                                                               {
           (yyval.statement) = new SummarizeStatement((yylsp[-10]).first_line, (yylsp[0]).last_line, (yyvsp[-9].string), (yyvsp[-7].qv), (yyvsp[-1].cmods), (yyvsp[0].sblock), (yyvsp[-3].qv));
        }
#line 8193 "parser.cpp"
    break;

  case 76: /* statement: "context" optname '(' exp ')' context_mods statement_or_block  */
#line 2278 "parser.ypp"
                                                                          {
           (yyval.statement) = new ContextStatement((yylsp[-6]).first_line, (yylsp[0]).last_line, (yyvsp[-5].string), (yyvsp[-3].qv), (yyvsp[-1].cmods), (yyvsp[0].sblock));
        }
#line 8201 "parser.cpp"
    break;

  case 77: /* statement: "if" '(' exp ')' statement_or_block  */
#line 2281 "parser.ypp"
                                                          {
           (yyval.statement) = new IfStatement((yylsp[-4]).first_line, (yylsp[0]).last_line, (yyvsp[-2].qv), (yyvsp[0].sblock));
        }
#line 8209 "parser.cpp"
    break;

  case 78: /* statement: "if" '(' exp ')' statement_or_block "else" statement_or_block  */
#line 2284 "parser.ypp"
                                                                            {
           (yyval.statement) = new IfStatement((yylsp[-6]).first_line, (yylsp[0]).last_line, (yyvsp[-4].qv), (yyvsp[-2].sblock), (yyvsp[0].sblock));
        }
#line 8217 "parser.cpp"
    break;

  case 79: /* statement: "while" '(' exp ')' statement_or_block  */
#line 2287 "parser.ypp"
                                                   {
           (yyval.statement) = new WhileStatement((yylsp[-4]).first_line, (yylsp[0]).last_line, (yyvsp[-2].qv), (yyvsp[0].sblock));
        }
#line 8225 "parser.cpp"
    break;

  case 80: /* statement: "do" statement_or_block "while" '(' exp ')' ';'  */
#line 2290 "parser.ypp"
                                                              {
           (yyval.statement) = new DoWhileStatement((yylsp[-6]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].qv), (yyvsp[-5].sblock));
        }
#line 8233 "parser.cpp"
    break;

  case 81: /* statement: "for" '(' myexp ';' myexp ';' myexp ')' statement_or_block  */
#line 2293 "parser.ypp"
                                                                       {
           (yyval.statement) = new ForStatement((yylsp[-8]).first_line, (yylsp[0]).last_line, (yyvsp[-6].qv), (yyvsp[-4].qv), (yyvsp[-2].qv), (yyvsp[0].sblock));
        }
#line 8241 "parser.cpp"
    break;

  case 82: /* statement: "foreach" exp "in" '(' exp ')' statement_or_block  */
#line 2296 "parser.ypp"
                                                                {
           (yyval.statement) = new ForEachStatement((yylsp[-6]).first_line, (yylsp[0]).last_line, (yyvsp[-5].qv), (yyvsp[-2].qv), (yyvsp[0].sblock));
        }
#line 8249 "parser.cpp"
    break;

  case 83: /* statement: return_statement ';'  */
#line 2299 "parser.ypp"
                               { (yyval.statement) = (yyvsp[-1].statement); }
#line 8255 "parser.cpp"
    break;

  case 84: /* statement: "thread_exit" ';'  */
#line 2300 "parser.ypp"
                              {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
            // see if thread exit is allowed
            if (parse_check_parse_option(PO_NO_THREAD_CONTROL)) {
                parse_error(*loc, "illegal use of \"thread_exit\" (conflicts with parse option PO_NO_THREAD_CONTROL)");
            }
            (yyval.statement) = new ThreadExitStatement(loc);
        }
#line 8268 "parser.cpp"
    break;

  case 85: /* statement: "break" ';'  */
#line 2308 "parser.ypp"
                        {
            (yyval.statement) = new BreakStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line);
        }
#line 8276 "parser.cpp"
    break;

  case 86: /* statement: "continue" ';'  */
#line 2311 "parser.ypp"
                           {
            (yyval.statement) = new ContinueStatement((yylsp[-1]).first_line, (yylsp[-1]).last_line);
        }
#line 8284 "parser.cpp"
    break;

  case 87: /* statement: switch_statement  */
#line 2314 "parser.ypp"
                           { (yyval.statement) = (yyvsp[0].statement); }
#line 8290 "parser.cpp"
    break;

  case 88: /* statement: error ';'  */
#line 2315 "parser.ypp"
                           { (yyval.statement) = 0; }
#line 8296 "parser.cpp"
    break;

  case 89: /* context_mods: %empty  */
#line 2320 "parser.ypp"
        { (yyval.cmods) = 0; }
#line 8302 "parser.cpp"
    break;

  case 90: /* context_mods: context_mods context_mod  */
#line 2321 "parser.ypp"
                                   {
           if (!(yyvsp[-1].cmods))
              (yyval.cmods) = new ContextModList((yyvsp[0].cmod));
           else {
              (yyvsp[-1].cmods)->addContextMod((yyvsp[0].cmod));
              (yyval.cmods) = (yyvsp[-1].cmods);
           }
        }
#line 8315 "parser.cpp"
    break;

  case 91: /* context_mod: "where" '(' exp ')'  */
#line 2333 "parser.ypp"
        { (yyval.cmod) = new ContextMod(CM_WHERE_NODE, (yyvsp[-1].qv)); }
#line 8321 "parser.cpp"
    break;

  case 92: /* context_mod: "sortBy" '(' exp ')'  */
#line 2335 "parser.ypp"
        { (yyval.cmod) = new ContextMod(CM_SORT_ASCENDING, (yyvsp[-1].qv)); }
#line 8327 "parser.cpp"
    break;

  case 93: /* context_mod: "sortDescendingBy" '(' exp ')'  */
#line 2337 "parser.ypp"
        { (yyval.cmod) = new ContextMod(CM_SORT_DESCENDING, (yyvsp[-1].qv)); }
#line 8333 "parser.cpp"
    break;

  case 94: /* return_statement: "return"  */
#line 2341 "parser.ypp"
                       { (yyval.statement) = new ReturnStatement((yylsp[0]).first_line, (yylsp[0]).last_line); }
#line 8339 "parser.cpp"
    break;

  case 95: /* return_statement: "return" exp  */
#line 2343 "parser.ypp"
                       { (yyval.statement) = new ReturnStatement((yylsp[-1]).first_line, (yylsp[0]).last_line, (yyvsp[0].qv)); }
#line 8345 "parser.cpp"
    break;

  case 96: /* switch_statement: "switch" '(' exp ')' '{' case_block '}'  */
#line 2348 "parser.ypp"
        {
           (yyvsp[-1].switchstmt)->setSwitch((yyvsp[-4].qv));
           (yyval.statement) = (yyvsp[-1].switchstmt);
           (yyval.statement)->finalizeBlock((yylsp[-6]).first_line, (yylsp[0]).last_line);
        }
#line 8355 "parser.cpp"
    break;

  case 97: /* case_block: case_code  */
#line 2357 "parser.ypp"
        {
           (yyval.switchstmt) = new SwitchStatement((yyvsp[0].casenode));
        }
#line 8363 "parser.cpp"
    break;

  case 98: /* case_block: case_block case_code  */
#line 2361 "parser.ypp"
        {
           (yyvsp[-1].switchstmt)->addCase((yyvsp[0].casenode));
           (yyval.switchstmt) = (yyvsp[-1].switchstmt);
        }
#line 8372 "parser.cpp"
    break;

  case 99: /* case_code: "case" ">= operator" exp ':' statements  */
#line 2369 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_case(loc, ">=", (yyvsp[-2].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-2].qv), (yyvsp[0].sblock), QoreLogicalGreaterThanOrEqualsOperatorNode::doGreaterThanOrEquals);
        }
#line 8382 "parser.cpp"
    break;

  case 100: /* case_code: "case" ">= operator" exp ':'  */
#line 2375 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            check_case(loc, ">=", (yyvsp[-1].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-1].qv), nullptr, QoreLogicalGreaterThanOrEqualsOperatorNode::doGreaterThanOrEquals);
        }
#line 8392 "parser.cpp"
    break;

  case 101: /* case_code: "case" "<= operator" exp ':' statements  */
#line 2381 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_case(loc, "<=", (yyvsp[-2].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-2].qv), (yyvsp[0].sblock), QoreLogicalLessThanOrEqualsOperatorNode::doLessThanOrEquals);
        }
#line 8402 "parser.cpp"
    break;

  case 102: /* case_code: "case" "<= operator" exp ':'  */
#line 2387 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            check_case(loc, "<=", (yyvsp[-1].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-1].qv), nullptr, QoreLogicalLessThanOrEqualsOperatorNode::doLessThanOrEquals);
        }
#line 8412 "parser.cpp"
    break;

  case 103: /* case_code: "case" "== operator" exp ':' statements  */
#line 2393 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_case(loc, "==", (yyvsp[-2].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-2].qv), (yyvsp[0].sblock), QoreLogicalEqualsOperatorNode::softEqual);
        }
#line 8422 "parser.cpp"
    break;

  case 104: /* case_code: "case" "== operator" exp ':'  */
#line 2399 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            check_case(loc, "==", (yyvsp[-1].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-1].qv), nullptr, QoreLogicalEqualsOperatorNode::softEqual);
        }
#line 8432 "parser.cpp"
    break;

  case 105: /* case_code: "case" '<' exp ':' statements  */
#line 2405 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_case(loc, "<", (yyvsp[-2].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-2].qv), (yyvsp[0].sblock), QoreLogicalLessThanOperatorNode::doLessThan);
        }
#line 8442 "parser.cpp"
    break;

  case 106: /* case_code: "case" '<' exp ':'  */
#line 2411 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            check_case(loc, "<", (yyvsp[-1].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-1].qv), nullptr, QoreLogicalLessThanOperatorNode::doLessThan);
        }
#line 8452 "parser.cpp"
    break;

  case 107: /* case_code: "case" '>' exp ':' statements  */
#line 2417 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_case(loc, ">", (yyvsp[-2].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-2].qv), (yyvsp[0].sblock), QoreLogicalGreaterThanOperatorNode::doGreaterThan);
        }
#line 8462 "parser.cpp"
    break;

  case 108: /* case_code: "case" '>' exp ':'  */
#line 2423 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            check_case(loc, ">", (yyvsp[-1].qv));
            (yyval.casenode) = new CaseNodeWithOperator(loc, (yyvsp[-1].qv), nullptr, QoreLogicalGreaterThanOperatorNode::doGreaterThan);
        }
#line 8472 "parser.cpp"
    break;

  case 109: /* case_code: "case" "=~ operator" "regular expression" ':' statements  */
#line 2429 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[-2].Regex), (yyvsp[0].sblock));
        }
#line 8481 "parser.cpp"
    break;

  case 110: /* case_code: "case" "=~ operator" "regular expression" ':'  */
#line 2434 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[-1].Regex), nullptr);
        }
#line 8490 "parser.cpp"
    break;

  case 111: /* case_code: "case" "!~ operator" "regular expression" ':' statements  */
#line 2439 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNodeNegRegex(loc, (yyvsp[-2].Regex), (yyvsp[0].sblock));
        }
#line 8499 "parser.cpp"
    break;

  case 112: /* case_code: "case" "!~ operator" "regular expression" ':'  */
#line 2444 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNodeNegRegex(loc, (yyvsp[-1].Regex), nullptr);
        }
#line 8508 "parser.cpp"
    break;

  case 113: /* case_code: "case" "regular expression" ':' statements  */
#line 2449 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[-2].Regex), (yyvsp[0].sblock));
        }
#line 8517 "parser.cpp"
    break;

  case 114: /* case_code: "case" "regular expression" ':'  */
#line 2454 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNodeRegex(loc, (yyvsp[-1].Regex), nullptr);
        }
#line 8526 "parser.cpp"
    break;

  case 115: /* case_code: "case" exp ':' statements  */
#line 2459 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            check_case(loc, 0, (yyvsp[-2].qv));
            (yyval.casenode) = new CaseNode(loc, (yyvsp[-2].qv), (yyvsp[0].sblock));
        }
#line 8536 "parser.cpp"
    break;

  case 116: /* case_code: "case" exp ':'  */
#line 2465 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
            check_case(loc, 0, (yyvsp[-1].qv));
            (yyval.casenode) = new CaseNode(loc, (yyvsp[-1].qv), nullptr);
        }
#line 8546 "parser.cpp"
    break;

  case 117: /* case_code: "default" ':' statements  */
#line 2471 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNode(loc, QoreValue(), (yyvsp[0].sblock), true);
        }
#line 8555 "parser.cpp"
    break;

  case 118: /* case_code: "default" ':'  */
#line 2476 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.casenode) = new CaseNode(loc, QoreValue(), nullptr, true);
        }
#line 8564 "parser.cpp"
    break;

  case 119: /* try_statement: "try" statement_or_block "catch" '(' myexp ')' statement_or_block  */
#line 2483 "parser.ypp"
                                                                              {
            char* param = 0;
            const QoreTypeInfo* typeInfo = nullptr;
            QoreParseTypeInfo* parseTypeInfo = nullptr;
            const QoreProgramLocation* loc =
                qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            bool missing_type_decl = true;
            if ((yyvsp[-2].qv).getType() == NT_VARREF) {
                VarRefNode* varRefNode = (yyvsp[-2].qv).get<VarRefNode>();
                param = varRefNode->takeName();
                if (varRefNode->isDecl()) {
                    VarRefDeclNode* varRefDeclNode = static_cast<VarRefDeclNode*>(varRefNode);
                    parseTypeInfo = varRefDeclNode->takeParseTypeInfo();
                    if (!parseTypeInfo)
                        typeInfo = varRefDeclNode->getTypeInfo();
                    missing_type_decl = false;
                }
            } else if ((yyvsp[-2].qv).getType() == NT_BAREWORD) {
                param = (yyvsp[-2].qv).get<BarewordNode>()->takeString();
                if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                    parse_error(*loc, "local variable '%s' in catch parameter list declared without '$' prefix, but " \
                        "parse option 'allow-bare-refs' is not set", param);
            } else if ((yyvsp[-2].qv)) {
                parse_error(*loc, "only one parameter accepted in catch block for exception hash");
                missing_type_decl = false;
            }
            if ((yyvsp[-2].qv) && missing_type_decl) {
                int64 po = parse_get_parse_options();
                if (po & (PO_STRICT_TYPES|PO_REQUIRE_TYPES)) {
                    SimpleRefHolder<QoreStringNode> desc(new QoreStringNodeMaker("the catch block is missing a " \
                        "type declaration; the exception argument should be declared as 'hash<ExceptionInfo>' or " \
                        "with a compatible type"));
                    // issue #2943: raise an error for mixing string and non-scalar values with %strict-types
                    if (po & PO_STRICT_TYPES) {
                        desc->concat("; this is an error when %strict-types is in effect");
                        qore_program_private::makeParseException(getProgram(), *loc, "PARSE-TYPE-ERROR", desc.release());
                    } else {
                        qore_program_private::makeParseWarning(getProgram(), *loc, QP_WARN_INVALID_CATCH,
                            "INVALID-CATCH", desc.release());
                    }
                }
            }
            (yyvsp[-2].qv).discard(nullptr);
            const QoreProgramLocation* vloc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-2].qv) ? (yylsp[-2]).first_line : 0, (yyvsp[-2].qv) ? (yylsp[-2]).last_line : 0);
            (yyval.statement) = new TryStatement(loc, (yyvsp[-5].sblock), (yyvsp[0].sblock), param, typeInfo, parseTypeInfo, vloc);
        }
#line 8615 "parser.cpp"
    break;

  case 120: /* myexp: %empty  */
#line 2531 "parser.ypp"
                     { (yyval.qv).set(nullptr); }
#line 8621 "parser.cpp"
    break;

  case 121: /* myexp: exp  */
#line 2532 "parser.ypp"
                     { (yyval.qv).set((yyvsp[0].qv)); }
#line 8627 "parser.cpp"
    break;

  case 122: /* myexp: error  */
#line 2533 "parser.ypp"
                     { (yyval.qv).set(nullptr); }
#line 8633 "parser.cpp"
    break;

  case 123: /* hashdecl_def: nsc_modifiers "hashdecl" "identifier" '{' hashdecl_attrs '}'  */
#line 2537 "parser.ypp"
                                                                     {
            fix_start_location((yyvsp[-5].i4), (yyloc), (yylsp[-4]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-5].i4) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_hashdeclmod(loc, (yyvsp[-5].i4), *((yyvsp[-1].hashdeclpriv)));
            (yyval.hashdecldef) = new HashDeclDef(loc, (yyvsp[-3].string), (yyvsp[-1].hashdeclpriv));
        }
#line 8644 "parser.cpp"
    break;

  case 124: /* hashdecl_def: nsc_modifiers "hashdecl" "namespace or class-scoped reference" '{' hashdecl_attrs '}'  */
#line 2543 "parser.ypp"
                                                                       {
            fix_start_location((yyvsp[-5].i4), (yyloc), (yylsp[-4]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-5].i4) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_hashdeclmod(loc, (yyvsp[-5].i4), *((yyvsp[-1].hashdeclpriv)));
            (yyval.hashdecldef) = new HashDeclDef(loc, (yyvsp[-3].string), (yyvsp[-1].hashdeclpriv));
        }
#line 8655 "parser.cpp"
    break;

  case 125: /* class_def: nsc_modifiers "simple class declaration" inheritance_list '{' class_attributes '}'  */
#line 2552 "parser.ypp"
                                                                             {
            fix_start_location((yyvsp[-5].i4), (yyloc), (yylsp[-4]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-5].i4) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[0]).last_line);
            check_classmod(loc, (yyvsp[-5].i4), *((yyvsp[-1].qoreclass)));
            qore_class_private::parseSetBaseClassList(*((yyvsp[-1].qoreclass)), (yyvsp[-3].sclist));
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-4].string), (yyvsp[-1].qoreclass));
        }
#line 8667 "parser.cpp"
    break;

  case 126: /* class_def: nsc_modifiers "scoped class declaration" inheritance_list '{' class_attributes '}'  */
#line 2559 "parser.ypp"
                                                                                   {
            fix_start_location((yyvsp[-5].i4), (yyloc), (yylsp[-4]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-5].i4) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[0]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "class", (yyvsp[-4].nscope)->ostr);
            check_classmod(loc, (yyvsp[-5].i4), *((yyvsp[-1].qoreclass)));
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-4].nscope), (yyvsp[-1].qoreclass));
            qore_class_private::parseSetBaseClassList(*((yyvsp[-1].qoreclass)), (yyvsp[-3].sclist));
        }
#line 8681 "parser.cpp"
    break;

  case 127: /* class_def: nsc_modifiers "simple class declaration" inheritance_list ';'  */
#line 2568 "parser.ypp"
                                                          {
            fix_start_location((yyvsp[-3].i4), (yyloc), (yylsp[-2]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].i4) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[-1]).last_line);
            // class name is set automatically from name saved in scanner
            QoreClass* qc = new QoreParseClass(loc);
            check_classmod(loc, (yyvsp[-3].i4), *qc);
            qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-1].sclist));
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-2].string), qc);
        }
#line 8695 "parser.cpp"
    break;

  case 128: /* class_def: nsc_modifiers "scoped class declaration" inheritance_list ';'  */
#line 2577 "parser.ypp"
                                                              {
            fix_start_location((yyvsp[-3].i4), (yyloc), (yylsp[-2]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-3].i4) ? (yylsp[-3]).first_line : (yylsp[-2]).first_line, (yylsp[-1]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "class", (yyvsp[-2].nscope)->ostr);
            // class name is set automatically from name saved in scanner
            QoreClass* qc = new QoreParseClass(loc);
            check_classmod(loc, (yyvsp[-3].i4), *qc);
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-2].nscope), qc);
            qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-1].sclist));
        }
#line 8711 "parser.cpp"
    break;

  case 129: /* class_def: nsc_modifiers "simple class declaration" inheritance_list '{' '}'  */
#line 2588 "parser.ypp"
                                                              {
            fix_start_location((yyvsp[-4].i4), (yyloc), (yylsp[-3]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-4].i4) ? (yylsp[-4]).first_line : (yylsp[-3]).first_line, (yylsp[0]).last_line);
            // class name is set automatically from name saved in scanner
            QoreClass* qc = new QoreParseClass(loc);
            check_classmod(loc, (yyvsp[-4].i4), *qc);
            qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-2].sclist));
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-3].string), qc);
        }
#line 8725 "parser.cpp"
    break;

  case 130: /* class_def: nsc_modifiers "scoped class declaration" inheritance_list '{' '}'  */
#line 2597 "parser.ypp"
                                                                  {
            fix_start_location((yyvsp[-4].i4), (yyloc), (yylsp[-3]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-4].i4) ? (yylsp[-4]).first_line : (yylsp[-3]).first_line, (yylsp[0]).last_line);
            // see if strong encapsulation is enabled
            check_strong_encapsulation(loc, "class", (yyvsp[-3].nscope)->ostr);
            // class name is set automatically from name saved in scanner
            QoreClass* qc = new QoreParseClass(loc);
            check_classmod(loc, (yyvsp[-4].i4), *qc);
            (yyval.classdef) = new ObjClassDef(loc, (yyvsp[-3].nscope), qc);
            qore_class_private::parseSetBaseClassList(*qc, (yyvsp[-2].sclist));
        }
#line 8741 "parser.cpp"
    break;

  case 131: /* inheritance_list: "inherits" superclass_list  */
#line 2611 "parser.ypp"
                                     {
           (yyval.sclist) = (yyvsp[0].sclist);
        }
#line 8749 "parser.cpp"
    break;

  case 132: /* inheritance_list: %empty  */
#line 2614 "parser.ypp"
          { // NOTHING
           (yyval.sclist) = 0;
        }
#line 8757 "parser.cpp"
    break;

  case 133: /* superclass_list: superclass  */
#line 2620 "parser.ypp"
                   {
           (yyval.sclist) = new BCList((yyvsp[0].sclnode));
        }
#line 8765 "parser.cpp"
    break;

  case 134: /* superclass_list: superclass_list ',' superclass  */
#line 2623 "parser.ypp"
                                         {
           (yyvsp[-2].sclist)->push_back((yyvsp[0].sclnode));
           (yyval.sclist) = (yyvsp[-2].sclist);
        }
#line 8774 "parser.cpp"
    break;

  case 135: /* superclass: "identifier"  */
#line 2630 "parser.ypp"
                   {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[0].string), Public);
        }
#line 8783 "parser.cpp"
    break;

  case 136: /* superclass: "namespace or class-scoped reference"  */
#line 2634 "parser.ypp"
                     {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[0].string)), Public);
        }
#line 8792 "parser.cpp"
    break;

  case 137: /* superclass: "public" "identifier"  */
#line 2638 "parser.ypp"
                                {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[0].string), Public);
        }
#line 8801 "parser.cpp"
    break;

  case 138: /* superclass: "public" "namespace or class-scoped reference"  */
#line 2642 "parser.ypp"
                                {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[0].string)), Public);
        }
#line 8810 "parser.cpp"
    break;

  case 139: /* superclass: "private" "identifier"  */
#line 2646 "parser.ypp"
                                 {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[0].string), Private);
        }
#line 8819 "parser.cpp"
    break;

  case 140: /* superclass: "private" "namespace or class-scoped reference"  */
#line 2650 "parser.ypp"
                                 {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[0].string)), Private);
        }
#line 8828 "parser.cpp"
    break;

  case 141: /* superclass: "private:hierarchy" "identifier"  */
#line 2654 "parser.ypp"
                                          {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[0].string), Private);
        }
#line 8837 "parser.cpp"
    break;

  case 142: /* superclass: "private:hierarchy" "namespace or class-scoped reference"  */
#line 2658 "parser.ypp"
                                          {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[0].string)), Private);
        }
#line 8846 "parser.cpp"
    break;

  case 143: /* superclass: "private:internal" "identifier"  */
#line 2662 "parser.ypp"
                                         {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, (yyvsp[0].string), Internal);
        }
#line 8855 "parser.cpp"
    break;

  case 144: /* superclass: "private:internal" "namespace or class-scoped reference"  */
#line 2666 "parser.ypp"
                                         {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.sclnode) = new BCNode(loc, new NamedScope((yyvsp[0].string)), Internal);
        }
#line 8864 "parser.cpp"
    break;

  case 145: /* hashdecl_attrs: hashdecl_member  */
#line 2673 "parser.ypp"
                        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.hashdeclpriv) = new typed_hash_decl_private(loc);
            if ((yyvsp[0].memberinfo)) {
                (yyval.hashdeclpriv)->parseAdd((yyvsp[0].memberinfo)->getHashMemPair());
                delete (yyvsp[0].memberinfo);
            }
        }
#line 8877 "parser.cpp"
    break;

  case 146: /* hashdecl_attrs: hashdecl_attrs hashdecl_member  */
#line 2681 "parser.ypp"
                                         {
            if ((yyvsp[0].memberinfo)) {
                if ((yyvsp[-1].hashdeclpriv)->hasMember((yyvsp[0].memberinfo)->name)) {
                    parse_error(*(yyvsp[0].memberinfo)->loc, "duplicate hashdecl member declaration '%s'", (yyvsp[0].memberinfo)->name);
                } else {
                    // add new member to list
                    (yyvsp[-1].hashdeclpriv)->parseAdd((yyvsp[0].memberinfo)->getHashMemPair());
                }
                delete (yyvsp[0].memberinfo);
            }

            (yyval.hashdeclpriv) = (yyvsp[-1].hashdeclpriv);
        }
#line 8895 "parser.cpp"
    break;

  case 147: /* hashdecl_member: uncqtypedef "identifier" ';'  */
#line 2697 "parser.ypp"
                                   {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new HashDeclMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-2].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-2].parsertype))));
            delete (yyvsp[-2].parsertype);
        }
#line 8905 "parser.cpp"
    break;

  case 148: /* hashdecl_member: uncqtypedef "identifier" '=' exp ';'  */
#line 2702 "parser.ypp"
                                             {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-3].string), new HashDeclMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-4].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-4].parsertype)), (yyvsp[-1].qv)));
            delete (yyvsp[-4].parsertype);
        }
#line 8915 "parser.cpp"
    break;

  case 149: /* hashdecl_member: uncqtypedef "identifier" '(' myexp ')' ';'  */
#line 2707 "parser.ypp"
                                                   {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-5].parsertype) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[-1]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype));
            AbstractQoreNode* new_call = nullptr;
            QoreParseTypeInfo* pti = ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype));

            if (!(yyvsp[-5].parsertype))
                parse_error(*loc, "cannot call constructor without declaring the class");
            else if (t)
                parse_error(*loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
            else {
                const QoreProgramLocation* aloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
                if (pti->subtypes.size()) {
                    new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(aloc, (yyvsp[-2].qv)));
                }
                else {
                    new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(aloc, (yyvsp[-2].qv)));
                }
            }

            (yyval.memberinfo) = new MemberInfo((yyvsp[-4].string), new HashDeclMemberInfo(loc, t, pti, new_call));

            delete (yyvsp[-5].parsertype);
        }
#line 8944 "parser.cpp"
    break;

  case 150: /* class_attributes: inline_methoddef  */
#line 2734 "parser.ypp"
                         {
           (yyval.qoreclass) = new QoreParseClass((yyvsp[0].methodnode)->getLoc());
           (yyvsp[0].methodnode)->addAndDelete((yyval.qoreclass));
        }
#line 8953 "parser.cpp"
    break;

  case 151: /* class_attributes: internal_member_list  */
#line 2738 "parser.ypp"
                               {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qoreclass) = new QoreParseClass(loc);
            (yyvsp[0].memberlist)->merge((yyval.qoreclass), Internal);
            delete (yyvsp[0].memberlist);
        }
#line 8964 "parser.cpp"
    break;

  case 152: /* class_attributes: private_member_list  */
#line 2744 "parser.ypp"
                              {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qoreclass) = new QoreParseClass(loc);
            (yyvsp[0].memberlist)->merge((yyval.qoreclass), Private);
            delete (yyvsp[0].memberlist);
        }
#line 8975 "parser.cpp"
    break;

  case 153: /* class_attributes: public_member_list  */
#line 2750 "parser.ypp"
                             {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qoreclass) = new QoreParseClass(loc);
            (yyvsp[0].memberlist)->merge((yyval.qoreclass), Public);
            delete (yyvsp[0].memberlist);
        }
#line 8986 "parser.cpp"
    break;

  case 154: /* class_attributes: unscoped_const_decl  */
#line 2756 "parser.ypp"
                              {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qoreclass) = new QoreParseClass(loc);
            qore_class_private::parseAddConstant(*((yyval.qoreclass)), loc, (yyvsp[0].constnode)->getName(), (yyvsp[0].constnode)->takeValue(), Public);
            delete (yyvsp[0].constnode);
        }
#line 8997 "parser.cpp"
    break;

  case 155: /* class_attributes: class_attributes inline_methoddef  */
#line 2762 "parser.ypp"
                                            {
            (yyvsp[0].methodnode)->addAndDelete((yyvsp[-1].qoreclass));
            (yyval.qoreclass) = (yyvsp[-1].qoreclass);
        }
#line 9006 "parser.cpp"
    break;

  case 156: /* class_attributes: class_attributes internal_member_list  */
#line 2766 "parser.ypp"
                                                {
            (yyvsp[0].memberlist)->merge((yyvsp[-1].qoreclass), Internal);
            (yyval.qoreclass) = (yyvsp[-1].qoreclass);
            delete (yyvsp[0].memberlist);
        }
#line 9016 "parser.cpp"
    break;

  case 157: /* class_attributes: class_attributes private_member_list  */
#line 2771 "parser.ypp"
                                               {
            (yyvsp[0].memberlist)->merge((yyvsp[-1].qoreclass), Private);
            (yyval.qoreclass) = (yyvsp[-1].qoreclass);
            delete (yyvsp[0].memberlist);
        }
#line 9026 "parser.cpp"
    break;

  case 158: /* class_attributes: class_attributes public_member_list  */
#line 2776 "parser.ypp"
                                              {
            (yyvsp[0].memberlist)->merge((yyvsp[-1].qoreclass), Public);
            (yyval.qoreclass) = (yyvsp[-1].qoreclass);
            delete (yyvsp[0].memberlist);
        }
#line 9036 "parser.cpp"
    break;

  case 159: /* class_attributes: class_attributes unscoped_const_decl  */
#line 2781 "parser.ypp"
                                               {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            qore_class_private::parseAddConstant(*((yyval.qoreclass)), loc, (yyvsp[0].constnode)->getName(), (yyvsp[0].constnode)->takeValue(), Public);
            (yyval.qoreclass) = (yyvsp[-1].qoreclass);
            delete (yyvsp[0].constnode);
        }
#line 9047 "parser.cpp"
    break;

  case 160: /* uncqtypedef: "identifier"  */
#line 2790 "parser.ypp"
                   {
            (yyval.parsertype) = new ParserTypeStruct((yyvsp[0].string), false);
        }
#line 9055 "parser.cpp"
    break;

  case 161: /* uncqtypedef: "namespace or class-scoped reference"  */
#line 2793 "parser.ypp"
                     {
            (yyval.parsertype) = new ParserTypeStruct(new QoreParseTypeInfo((yyvsp[0].string), false));
        }
#line 9063 "parser.cpp"
    break;

  case 162: /* uncqtypedef: "complex type identifier"  */
#line 2796 "parser.ypp"
                           {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.parsertype) = ParserTypeStruct::getType(loc, (yyvsp[0].string), false);
        }
#line 9072 "parser.cpp"
    break;

  case 163: /* uncqtypedef: '*' "identifier"  */
#line 2800 "parser.ypp"
                         {
            (yyval.parsertype) = new ParserTypeStruct((yyvsp[0].string), true);
        }
#line 9080 "parser.cpp"
    break;

  case 164: /* uncqtypedef: '*' "namespace or class-scoped reference"  */
#line 2803 "parser.ypp"
                         {
            (yyval.parsertype) = new ParserTypeStruct(new QoreParseTypeInfo((yyvsp[0].string), true));
        }
#line 9088 "parser.cpp"
    break;

  case 165: /* uncqtypedef: '*' "complex type identifier"  */
#line 2806 "parser.ypp"
                               {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.parsertype) = ParserTypeStruct::getType(loc, (yyvsp[0].string), true);
        }
#line 9097 "parser.cpp"
    break;

  case 166: /* qtypedef: %empty  */
#line 2814 "parser.ypp"
        { (yyval.parsertype) = 0; }
#line 9103 "parser.cpp"
    break;

  case 167: /* qtypedef: uncqtypedef  */
#line 2815 "parser.ypp"
                      {
           (yyval.parsertype) = (yyvsp[0].parsertype);
        }
#line 9111 "parser.cpp"
    break;

  case 168: /* internal_member_list: "private:internal" member_list ';'  */
#line 2821 "parser.ypp"
                                                          { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 9117 "parser.cpp"
    break;

  case 169: /* internal_member_list: "private:internal" '{' member_list2 '}'  */
#line 2822 "parser.ypp"
                                                          { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 9123 "parser.cpp"
    break;

  case 170: /* internal_member_list: "private:internal" '{' '}'  */
#line 2823 "parser.ypp"
                                                          { (yyval.memberlist) = new EmptyMemberList; }
#line 9129 "parser.cpp"
    break;

  case 171: /* private_member_list: "private" member_list ';'  */
#line 2827 "parser.ypp"
                                                  { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 9135 "parser.cpp"
    break;

  case 172: /* private_member_list: "private" '{' member_list2 '}'  */
#line 2828 "parser.ypp"
                                                  { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 9141 "parser.cpp"
    break;

  case 173: /* private_member_list: "private" '{' '}'  */
#line 2829 "parser.ypp"
                                                  { (yyval.memberlist) = new EmptyMemberList; }
#line 9147 "parser.cpp"
    break;

  case 174: /* private_member_list: "private:hierarchy" member_list ';'  */
#line 2830 "parser.ypp"
                                                  { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 9153 "parser.cpp"
    break;

  case 175: /* private_member_list: "private:hierarchy" '{' member_list2 '}'  */
#line 2831 "parser.ypp"
                                                  { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 9159 "parser.cpp"
    break;

  case 176: /* private_member_list: "private:hierarchy" '{' '}'  */
#line 2832 "parser.ypp"
                                                  { (yyval.memberlist) = new EmptyMemberList; }
#line 9165 "parser.cpp"
    break;

  case 177: /* public_member_list: "public" member_list ';'  */
#line 2836 "parser.ypp"
                                            { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 9171 "parser.cpp"
    break;

  case 178: /* public_member_list: "public" '{' member_list2 '}'  */
#line 2837 "parser.ypp"
                                            { (yyval.memberlist) = (yyvsp[-1].memberlist); }
#line 9177 "parser.cpp"
    break;

  case 179: /* public_member_list: "public" '{' '}'  */
#line 2838 "parser.ypp"
                                            { (yyval.memberlist) = new EmptyMemberList; }
#line 9183 "parser.cpp"
    break;

  case 180: /* classvardecl: "static" uncqtypedef "identifier" ';'  */
#line 2842 "parser.ypp"
                                              {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[-1]).last_line);
            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-1].string), new QoreVarInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-2].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-2].parsertype))));
            delete (yyvsp[-2].parsertype);
        }
#line 9193 "parser.cpp"
    break;

  case 181: /* classvardecl: "static" "identifier" ';'  */
#line 2847 "parser.ypp"
                                    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-1]).last_line);
            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-1].string), new QoreVarInfo(loc));
        }
#line 9202 "parser.cpp"
    break;

  case 182: /* classvardecl: "static" uncqtypedef "identifier" '=' exp ';'  */
#line 2851 "parser.ypp"
                                                        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[-1]).last_line);
            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-3].string), new QoreVarInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-4].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-4].parsertype)), (yyvsp[-1].qv)));
            //printd(5, "new QoreVarInfo = %p (empty: %d)\n", $$->u.varInfo, $$->u.varInfo->empty());
            delete (yyvsp[-4].parsertype);
        }
#line 9213 "parser.cpp"
    break;

  case 183: /* classvardecl: "static" "identifier" '=' exp ';'  */
#line 2857 "parser.ypp"
                                            {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[-1]).last_line);
            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-3].string), new QoreVarInfo(loc, nullptr, nullptr, (yyvsp[-1].qv)));
        }
#line 9222 "parser.cpp"
    break;

  case 184: /* classvardecl: "static" uncqtypedef "identifier" '(' myexp ')' ';'  */
#line 2861 "parser.ypp"
                                                              {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[-1]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype));
            AbstractQoreNode* new_call = nullptr;
            QoreParseTypeInfo* pti = ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype));

            if (t)
                parse_error(*loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
            else {
                const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
                if (pti->subtypes.size())
                    new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(argsloc, (yyvsp[-2].qv)));
                else
                    new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(argsloc, (yyvsp[-2].qv)));
            }

            (yyval.classvarinfo) = new ClassVarInfo((yyvsp[-4].string), new QoreVarInfo(loc, t, pti, new_call));

            delete (yyvsp[-5].parsertype);
        }
#line 9247 "parser.cpp"
    break;

  case 185: /* member2: qtypedef "in-object member reference" ';'  */
#line 2884 "parser.ypp"
                              {
            fix_start_location((yyvsp[-2].parsertype), (yyloc), (yylsp[-1]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-2].parsertype) ? (yylsp[-2]).first_line : (yylsp[-1]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-2].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-2].parsertype))));
            delete (yyvsp[-2].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-1].string));
        }
#line 9260 "parser.cpp"
    break;

  case 186: /* member2: qtypedef "in-object member reference" '=' exp ';'  */
#line 2892 "parser.ypp"
                                        {
            fix_start_location((yyvsp[-4].parsertype), (yyloc), (yylsp[-3]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-4].parsertype) ? (yylsp[-4]).first_line : (yylsp[-3]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-3].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-4].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-4].parsertype)), (yyvsp[-1].qv)));
            delete (yyvsp[-4].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-3].string));
        }
#line 9273 "parser.cpp"
    break;

  case 187: /* member2: qtypedef "in-object member reference" '(' myexp ')' ';'  */
#line 2900 "parser.ypp"
                                              {
            fix_start_location((yyvsp[-5].parsertype), (yyloc), (yylsp[-4]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-5].parsertype) ? (yylsp[-5]).first_line : (yylsp[-4]).first_line, (yylsp[-1]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype));
            AbstractQoreNode* new_call = nullptr;
            QoreParseTypeInfo* pti = (yyvsp[-5].parsertype) ? ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)) : nullptr;

            if (!(yyvsp[-5].parsertype))
                parse_error(*loc, "cannot call constructor without declaring the class");
            else if (t)
                parse_error(*loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
            else {
                const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
                if (pti && pti->subtypes.size())
                    new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(argsloc, (yyvsp[-2].qv)));
                else
                    new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(argsloc, (yyvsp[-2].qv)));
            }

            (yyval.memberinfo) = new MemberInfo((yyvsp[-4].string), new QoreMemberInfo(loc, t, pti, new_call));

            delete (yyvsp[-5].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-4].string));
        }
#line 9303 "parser.cpp"
    break;

  case 188: /* member2: uncqtypedef "identifier" ';'  */
#line 2925 "parser.ypp"
                                     {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-2].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-2].parsertype))));
            delete (yyvsp[-2].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-1].string));
        }
#line 9315 "parser.cpp"
    break;

  case 189: /* member2: uncqtypedef "identifier" '=' exp ';'  */
#line 2932 "parser.ypp"
                                             {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-3].string), new QoreMemberInfo(loc, ParserTypeStruct::getTypeInfo((yyvsp[-4].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-4].parsertype)), (yyvsp[-1].qv)));
            delete (yyvsp[-4].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-3].string));
        }
#line 9327 "parser.cpp"
    break;

  case 190: /* member2: uncqtypedef "identifier" '(' myexp ')' ';'  */
#line 2939 "parser.ypp"
                                                   {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[-1]).last_line);
            const QoreTypeInfo* t = ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype));
            AbstractQoreNode* new_call = nullptr;
            QoreParseTypeInfo* pti = ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype));

            if (!(yyvsp[-5].parsertype))
                parse_error(*loc, "cannot call constructor without declaring the class");
            else if (t)
                parse_error(*loc, "cannot call constructor for non-class base type '%s'", QoreTypeInfo::getName(t));
            else {
                const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
                if (pti->subtypes.size())
                    new_call = new ParseNewComplexTypeNode(loc, new QoreParseTypeInfo(*pti), make_args(argsloc, (yyvsp[-2].qv)));
                else
                    new_call = new ScopedObjectCallNode(loc, new NamedScope(strdup(pti->cscope->ostr)), make_args(argsloc, (yyvsp[-2].qv)));
            }

            (yyval.memberinfo) = new MemberInfo((yyvsp[-4].string), new QoreMemberInfo(loc, t, pti, new_call));

            delete (yyvsp[-5].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-4].string));
        }
#line 9356 "parser.cpp"
    break;

  case 191: /* member2: "identifier" ';'  */
#line 2963 "parser.ypp"
                         {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo(loc));
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-1].string));
        }
#line 9367 "parser.cpp"
    break;

  case 192: /* member2: "identifier" '=' exp ';'  */
#line 2969 "parser.ypp"
                                 {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[-1]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-3].string), new QoreMemberInfo(loc, nullptr, nullptr, (yyvsp[-1].qv)));
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "member '%s' declared without '$.' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[-3].string));
        }
#line 9378 "parser.cpp"
    break;

  case 193: /* member2: classvardecl  */
#line 2975 "parser.ypp"
                       {
            (yyval.memberinfo) = (yyvsp[0].classvarinfo);
        }
#line 9386 "parser.cpp"
    break;

  case 194: /* member2: unscoped_const_decl  */
#line 2978 "parser.ypp"
                              {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            if ((yyvsp[0].constnode)->pub)
                parse_error(*loc, "cannot change class constant scope for constant '%s' within a public or private declaration block", (yyvsp[0].constnode)->name.ostr);
            (yyval.memberinfo) = new MemberInfo(loc, (yyvsp[0].constnode)->name.takeName(), (yyvsp[0].constnode)->value);
            delete (yyvsp[0].constnode);
        }
#line 9398 "parser.cpp"
    break;

  case 195: /* transient_member2: "transient" member2  */
#line 2988 "parser.ypp"
                              {
            (yyval.memberinfo) = (yyvsp[0].memberinfo);
            (yyval.memberinfo)->setTransient();
        }
#line 9407 "parser.cpp"
    break;

  case 196: /* member: "in-object member reference"  */
#line 2995 "parser.ypp"
                 {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[0].string), new QoreMemberInfo(loc));
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
        }
#line 9418 "parser.cpp"
    break;

  case 197: /* member: "in-object member reference" "namespace or class-scoped reference"  */
#line 3001 "parser.ypp"
                              {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.memberinfo) = new MemberInfo((yyvsp[-1].string), new QoreMemberInfo(loc, nullptr, new QoreParseTypeInfo((yyvsp[0].string))));
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[-1].string));
        }
#line 9429 "parser.cpp"
    break;

  case 198: /* transient_member: "transient" member  */
#line 3010 "parser.ypp"
                             {
            (yyval.memberinfo) = (yyvsp[0].memberinfo);
            (yyval.memberinfo)->setTransient();
        }
#line 9438 "parser.cpp"
    break;

  case 199: /* member_list: member  */
#line 3017 "parser.ypp"
               {
           (yyval.memberlist) = new MemberList((yyvsp[0].memberinfo));
        }
#line 9446 "parser.cpp"
    break;

  case 200: /* member_list: transient_member  */
#line 3020 "parser.ypp"
                           {
           (yyval.memberlist) = new MemberList((yyvsp[0].memberinfo));
        }
#line 9454 "parser.cpp"
    break;

  case 201: /* member_list: member_list ',' member  */
#line 3023 "parser.ypp"
                                 {
           (yyvsp[-2].memberlist)->add((yyvsp[0].memberinfo));
           (yyval.memberlist) = (yyvsp[-2].memberlist);
        }
#line 9463 "parser.cpp"
    break;

  case 202: /* member_list: member_list ',' transient_member  */
#line 3027 "parser.ypp"
                                           {
           (yyvsp[-2].memberlist)->add((yyvsp[0].memberinfo));
           (yyval.memberlist) = (yyvsp[-2].memberlist);
        }
#line 9472 "parser.cpp"
    break;

  case 203: /* member_list2: member2  */
#line 3034 "parser.ypp"
                {
           (yyval.memberlist) = new MemberList((yyvsp[0].memberinfo));
        }
#line 9480 "parser.cpp"
    break;

  case 204: /* member_list2: transient_member2  */
#line 3037 "parser.ypp"
                            {
           (yyval.memberlist) = new MemberList((yyvsp[0].memberinfo));
        }
#line 9488 "parser.cpp"
    break;

  case 205: /* member_list2: member_list2 member2  */
#line 3040 "parser.ypp"
                               {
           (yyvsp[-1].memberlist)->add((yyvsp[0].memberinfo));
           (yyval.memberlist) = (yyvsp[-1].memberlist);
        }
#line 9497 "parser.cpp"
    break;

  case 206: /* member_list2: member_list2 transient_member2  */
#line 3044 "parser.ypp"
                                         {
           (yyvsp[-1].memberlist)->add((yyvsp[0].memberinfo));
           (yyval.memberlist) = (yyvsp[-1].memberlist);
        }
#line 9506 "parser.cpp"
    break;

  case 207: /* ident_openparen: "identifier" '('  */
#line 3051 "parser.ypp"
                       {
           (yyval.string) = (yyvsp[-1].string);
        }
#line 9514 "parser.cpp"
    break;

  case 208: /* ident_openparen: "keys" '('  */
#line 3054 "parser.ypp"
                       {
           (yyval.string) = strdup("keys");
        }
#line 9522 "parser.cpp"
    break;

  case 209: /* ident_openparen: "identifier or keyword used as function or method identifier"  */
#line 3057 "parser.ypp"
                                  {
           (yyval.string) = (yyvsp[0].string);
        }
#line 9530 "parser.cpp"
    break;

  case 210: /* inline_methoddef: nsc_modifiers ident_openparen myexp ')' base_constructor_list return_value block  */
#line 3063 "parser.ypp"
                                                                                         {
            fix_start_location((yyvsp[-6].i4), (yyloc), (yylsp[-5]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-6].i4) ? (yylsp[-6]).first_line : (yylsp[-5]).first_line, (yylsp[0]).last_line);
            if ((yyvsp[-6].i4) & OFM_ABSTRACT) {
                if ((yyvsp[0].sblock))
                    parse_error(*loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
                else
                    parse_error(*loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
            }
            check_method(loc, (yyvsp[-5].string), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo));
            (yyval.methodnode) = new MethodNode((yyvsp[-5].string), new_method_variant(loc, (yyvsp[-5].string), (yyvsp[-6].i4), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].qv), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), (yyvsp[0].sblock)), (yyvsp[-6].i4) & OFM_STATIC);
        }
#line 9547 "parser.cpp"
    break;

  case 211: /* inline_methoddef: nsc_modifiers uncqtypedef ident_openparen myexp ')' base_constructor_list block  */
#line 3075 "parser.ypp"
                                                                                          {
            fix_start_location((yyvsp[-6].i4), (yyloc), (yylsp[-5]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-6].i4) ? (yylsp[-6]).first_line : (yylsp[-5]).first_line, (yylsp[0]).last_line);
            if ((yyvsp[-6].i4) & OFM_ABSTRACT) {
                if ((yyvsp[0].sblock))
                    parse_error(*loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
                else
                    parse_error(*loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
            }
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
            delete (yyvsp[-5].parsertype);

            check_method(loc, (yyvsp[-4].string), (yyvsp[-1].bcalist), rt);

            (yyval.methodnode) = new MethodNode((yyvsp[-4].string), new_method_variant(loc, (yyvsp[-4].string), (yyvsp[-6].i4), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].bcalist), rt, (yyvsp[0].sblock)), (yyvsp[-6].i4) & OFM_STATIC);
        }
#line 9568 "parser.cpp"
    break;

  case 212: /* inline_methoddef: nsc_modifiers ident_openparen myexp ')' base_constructor_list return_value ';'  */
#line 3091 "parser.ypp"
                                                                                         {
            fix_start_location((yyvsp[-6].i4), (yyloc), (yylsp[-5]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-6].i4) ? (yylsp[-6]).first_line : (yylsp[-5]).first_line, (yylsp[-1]).last_line);
            if (!((yyvsp[-6].i4) & OFM_ABSTRACT))
                parse_error(*loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
            check_method(loc, (yyvsp[-5].string), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo));
            (yyval.methodnode) = new MethodNode((yyvsp[-5].string), new_method_variant(loc, (yyvsp[-5].string), (yyvsp[-6].i4), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].qv), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), 0), (yyvsp[-6].i4) & OFM_STATIC);
        }
#line 9581 "parser.cpp"
    break;

  case 213: /* inline_methoddef: nsc_modifiers uncqtypedef ident_openparen myexp ')' base_constructor_list ';'  */
#line 3099 "parser.ypp"
                                                                                        {
            fix_start_location((yyvsp[-6].i4), (yyloc), (yylsp[-5]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-6].i4) ? (yylsp[-6]).first_line : (yylsp[-5]).first_line, (yylsp[-1]).last_line);
            if (!((yyvsp[-6].i4) & OFM_ABSTRACT))
                parse_error(*loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
            delete (yyvsp[-5].parsertype);

            check_method(loc, (yyvsp[-4].string), (yyvsp[-1].bcalist), rt);

            (yyval.methodnode) = new MethodNode((yyvsp[-4].string), new_method_variant(loc, (yyvsp[-4].string), (yyvsp[-6].i4), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].bcalist), rt, 0), (yyvsp[-6].i4) & OFM_STATIC);
        }
#line 9598 "parser.cpp"
    break;

  case 214: /* outofline_methoddef: method_modifiers "namespace or class-scoped reference" '(' myexp ')' base_constructor_list return_value block  */
#line 3114 "parser.ypp"
                                                                                           {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-7]).first_line, (yylsp[0]).last_line);
            if ((yyvsp[-7].i4) & OFM_ABSTRACT) {
                if ((yyvsp[0].sblock))
                    parse_error(*loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
                else
                    parse_error(*loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
            }

            (yyval.methoddef) = new MethodDef(loc, (yyvsp[-7].i4), (yyvsp[-6].string), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].qv), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), (yyvsp[0].sblock));
        }
#line 9614 "parser.cpp"
    break;

  case 215: /* outofline_methoddef: method_modifiers uncqtypedef "namespace or class-scoped reference" '(' myexp ')' base_constructor_list block  */
#line 3125 "parser.ypp"
                                                                                            {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-7]).first_line, (yylsp[0]).last_line);
            if ((yyvsp[-7].i4) & OFM_ABSTRACT) {
                if ((yyvsp[0].sblock))
                    parse_error(*loc, "'abstract' can only be used with no implementation (remove the body and terminate the declaration with ';' or remove the 'abstract')");
                else
                    parse_error(*loc, "'abstract' can only be used with no implementation (terminate the declaration with ';' instead of '{}')");
            }
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-6].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-6].parsertype)));
            delete (yyvsp[-6].parsertype);

            (yyval.methoddef) = new MethodDef(loc, (yyvsp[-7].i4), (yyvsp[-5].string), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].bcalist), rt, (yyvsp[0].sblock));
        }
#line 9632 "parser.cpp"
    break;

  case 216: /* outofline_methoddef: method_modifiers "namespace or class-scoped reference" '(' myexp ')' base_constructor_list return_value ';'  */
#line 3138 "parser.ypp"
                                                                                           {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-7]).first_line, (yylsp[-1]).last_line);
            if (!((yyvsp[-7].i4) & OFM_ABSTRACT))
                parse_error(*loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
            (yyval.methoddef) = new MethodDef(loc, (yyvsp[-7].i4), (yyvsp[-6].string), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].qv), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), 0);
        }
#line 9643 "parser.cpp"
    break;

  case 217: /* outofline_methoddef: method_modifiers uncqtypedef "namespace or class-scoped reference" '(' myexp ')' base_constructor_list ';'  */
#line 3144 "parser.ypp"
                                                                                          {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-7]).first_line, (yylsp[-1]).last_line);
            if (!((yyvsp[-7].i4) & OFM_ABSTRACT))
                parse_error(*loc, "non-abstract method declared without any body; either declare the method 'abstract' or declare an empty method body with '{}'");
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-6].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-6].parsertype)));
            delete (yyvsp[-6].parsertype);

            (yyval.methoddef) = new MethodDef(loc, (yyvsp[-7].i4), (yyvsp[-5].string), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].bcalist), rt, 0);
        }
#line 9657 "parser.cpp"
    break;

  case 218: /* outofline_methoddef: "namespace or class-scoped reference" '(' myexp ')' base_constructor_list return_value block  */
#line 3153 "parser.ypp"
                                                                            {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            (yyval.methoddef) = new MethodDef(loc, 0, (yyvsp[-6].string), (yylsp[-4]).first_line, (yylsp[-4]).last_line, (yyvsp[-4].qv), (yyvsp[-2].bcalist), (yyvsp[-1].returnTypeInfo), (yyvsp[0].sblock));
        }
#line 9666 "parser.cpp"
    break;

  case 219: /* outofline_methoddef: uncqtypedef "namespace or class-scoped reference" '(' myexp ')' base_constructor_list block  */
#line 3157 "parser.ypp"
                                                                           {
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-6].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-6].parsertype)));
            delete (yyvsp[-6].parsertype);

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            (yyval.methoddef) = new MethodDef(loc, 0, (yyvsp[-5].string), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].bcalist), rt, (yyvsp[0].sblock));
        }
#line 9678 "parser.cpp"
    break;

  case 220: /* base_constructor_list: ':' base_constructors  */
#line 3167 "parser.ypp"
                              {
           (yyval.bcalist) = (yyvsp[0].bcalist);
        }
#line 9686 "parser.cpp"
    break;

  case 221: /* base_constructor_list: %empty  */
#line 3170 "parser.ypp"
          { // nothing
           (yyval.bcalist) = 0;
        }
#line 9694 "parser.cpp"
    break;

  case 222: /* base_constructors: base_constructor  */
#line 3176 "parser.ypp"
                         {
           (yyval.bcalist) = new BCAList((yyvsp[0].bcanode));
        }
#line 9702 "parser.cpp"
    break;

  case 223: /* base_constructors: base_constructors ',' base_constructor  */
#line 3179 "parser.ypp"
                                                 {
           (yyvsp[-2].bcalist)->push_back((yyvsp[0].bcanode));
           (yyval.bcalist) = (yyvsp[-2].bcalist);
        }
#line 9711 "parser.cpp"
    break;

  case 224: /* base_constructor: "identifier" '(' myexp ')'  */
#line 3186 "parser.ypp"
                                 {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.bcanode) = new BCANode((yyvsp[-3].string), make_args(loc, (yyvsp[-1].qv)), loc);
        }
#line 9720 "parser.cpp"
    break;

  case 225: /* base_constructor: "namespace or class-scoped reference" '(' myexp ')'  */
#line 3190 "parser.ypp"
                                   {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.bcanode) = new BCANode(new NamedScope((yyvsp[-3].string)), make_args(loc, (yyvsp[-1].qv)), loc);
        }
#line 9729 "parser.cpp"
    break;

  case 226: /* nsc_modifiers: %empty  */
#line 3198 "parser.ypp"
        { (yyval.i4) = 0; }
#line 9735 "parser.cpp"
    break;

  case 227: /* nsc_modifiers: method_modifiers  */
#line 3199 "parser.ypp"
                           {
           (yyval.i4) = (yyvsp[0].i4);
        }
#line 9743 "parser.cpp"
    break;

  case 228: /* method_modifiers: method_modifier  */
#line 3204 "parser.ypp"
                        { (yyval.i4) = (yyvsp[0].i4); }
#line 9749 "parser.cpp"
    break;

  case 229: /* method_modifiers: method_modifiers method_modifier  */
#line 3205 "parser.ypp"
                                           {
            if (((yyvsp[-1].i4) | (yyvsp[0].i4)) == (yyvsp[-1].i4)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
                parse_error(*loc, "modifier given twice");
            }
            (yyval.i4) = (yyvsp[-1].i4) | (yyvsp[0].i4);
        }
#line 9761 "parser.cpp"
    break;

  case 230: /* method_modifier: "private"  */
#line 3215 "parser.ypp"
                    { (yyval.i4) = OFM_PRIVATE; }
#line 9767 "parser.cpp"
    break;

  case 231: /* method_modifier: "private:hierarchy"  */
#line 3216 "parser.ypp"
                               { (yyval.i4) = OFM_PRIVATE; }
#line 9773 "parser.cpp"
    break;

  case 232: /* method_modifier: "private:internal"  */
#line 3217 "parser.ypp"
                              { (yyval.i4) = OFM_INTERNAL; }
#line 9779 "parser.cpp"
    break;

  case 233: /* method_modifier: "static"  */
#line 3218 "parser.ypp"
                     { (yyval.i4) = OFM_STATIC; }
#line 9785 "parser.cpp"
    break;

  case 234: /* method_modifier: "synchronized"  */
#line 3219 "parser.ypp"
                           { (yyval.i4) = OFM_SYNCED; }
#line 9791 "parser.cpp"
    break;

  case 235: /* method_modifier: "deprecated"  */
#line 3220 "parser.ypp"
                         { (yyval.i4) = OFM_DEPRECATED; }
#line 9797 "parser.cpp"
    break;

  case 236: /* method_modifier: "public"  */
#line 3221 "parser.ypp"
                     { (yyval.i4) = OFM_PUBLIC; }
#line 9803 "parser.cpp"
    break;

  case 237: /* method_modifier: "final"  */
#line 3222 "parser.ypp"
                    { (yyval.i4) = OFM_FINAL; }
#line 9809 "parser.cpp"
    break;

  case 238: /* method_modifier: "abstract"  */
#line 3223 "parser.ypp"
                       { (yyval.i4) = OFM_ABSTRACT; }
#line 9815 "parser.cpp"
    break;

  case 239: /* return_value: "returns" qtypedef  */
#line 3227 "parser.ypp"
                             {
            // see if the deprecated "returns" keyword can be used
            if (!parse_check_parse_option(PO_ALLOW_RETURNS)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
                parse_error(*loc, "illegal use of the deprecated \"returns\" keyword (enable by setting parse option PO_ALLOW_RETURNS)");
            }

            if (!(yyvsp[0].parsertype)) {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
                parse_error(*loc, "missing type declaration after 'returns'");
                (yyval.returnTypeInfo) = 0;
            } else {
                (yyval.returnTypeInfo) = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[0].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[0].parsertype)));
                delete (yyvsp[0].parsertype);
            }
        }
#line 9836 "parser.cpp"
    break;

  case 240: /* return_value: %empty  */
#line 3244 "parser.ypp"
        {
            (yyval.returnTypeInfo) = 0;
        }
#line 9844 "parser.cpp"
    break;

  case 241: /* sub_def: "sub" ident_openparen myexp ')' return_value block  */
#line 3250 "parser.ypp"
                                                             {
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[0]).last_line);
            (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].returnTypeInfo), false, flags));
        }
#line 9855 "parser.cpp"
    break;

  case 242: /* sub_def: uncqtypedef "sub" ident_openparen myexp ')' block  */
#line 3256 "parser.ypp"
                                                              {
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
            delete (yyvsp[-5].parsertype);

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[0]).last_line);
            (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[-3].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].qv), rt, false, flags));
        }
#line 9870 "parser.cpp"
    break;

  case 243: /* sub_def: method_modifiers "sub" ident_openparen myexp ')' return_value block  */
#line 3266 "parser.ypp"
                                                                                {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            check_funcmod(loc, (yyvsp[-6].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[-6].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;

            (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].returnTypeInfo), (yyvsp[-6].i4) & OFM_SYNCED, flags));
            if ((yyvsp[-6].i4) & OFM_PUBLIC)
                (yyval.parsefunc)->setPublic();
        }
#line 9887 "parser.cpp"
    break;

  case 244: /* sub_def: method_modifiers uncqtypedef "sub" ident_openparen myexp ')' block  */
#line 3278 "parser.ypp"
                                                                               {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            check_funcmod(loc, (yyvsp[-6].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[-6].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
            delete (yyvsp[-5].parsertype);

            (yyval.parsefunc) = new ParseUserFunction(loc, (yyvsp[-3].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].qv), rt, (yyvsp[-6].i4) & OFM_SYNCED, flags));
            if ((yyvsp[-6].i4) & OFM_PUBLIC)
                (yyval.parsefunc)->setPublic();
        }
#line 9907 "parser.cpp"
    break;

  case 245: /* scoped_sub_def: "sub" "namespace or class-scoped reference" '(' myexp ')' return_value block  */
#line 3296 "parser.ypp"
                                                            {
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[-5].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].returnTypeInfo), false, flags));
        }
#line 9918 "parser.cpp"
    break;

  case 246: /* scoped_sub_def: uncqtypedef "sub" "namespace or class-scoped reference" '(' myexp ')' block  */
#line 3302 "parser.ypp"
                                                             {
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-6].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-6].parsertype)));
            delete (yyvsp[-6].parsertype);

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].qv), rt, false, flags));
        }
#line 9933 "parser.cpp"
    break;

  case 247: /* scoped_sub_def: method_modifiers "sub" "namespace or class-scoped reference" '(' myexp ')' return_value block  */
#line 3312 "parser.ypp"
                                                                               {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-7]).first_line, (yylsp[0]).last_line);
            check_funcmod(loc, (yyvsp[-7].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[-7].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;

            (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[-5].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].returnTypeInfo), (yyvsp[-7].i4) & OFM_SYNCED, flags));
            if ((yyvsp[-7].i4) & OFM_PUBLIC)
                (yyval.sparsefunc)->setPublic();
        }
#line 9950 "parser.cpp"
    break;

  case 248: /* scoped_sub_def: method_modifiers uncqtypedef "sub" "namespace or class-scoped reference" '(' myexp ')' block  */
#line 3324 "parser.ypp"
                                                                              {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-7]).first_line, (yylsp[0]).last_line);
            check_funcmod(loc, (yyvsp[-7].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[-7].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-6].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-6].parsertype)));
            delete (yyvsp[-6].parsertype);

            (yyval.sparsefunc) = new ParseScopedUserFunction(loc, (yyvsp[-4].string), new UserFunctionVariant((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].qv), rt, (yyvsp[-7].i4) & OFM_SYNCED, flags));
            if ((yyvsp[-7].i4) & OFM_PUBLIC)
                (yyval.sparsefunc)->setPublic();
        }
#line 9970 "parser.cpp"
    break;

  case 249: /* list: exp ',' exp  */
#line 3342 "parser.ypp"
                    {
            const QoreProgramLocation* loc1 = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
            const QoreProgramLocation* loc3 = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
            (yyval.parse_list) = splice_expressions((yyvsp[-2].qv), (yyvsp[0].qv), loc1, loc3);
        }
#line 9980 "parser.cpp"
    break;

  case 250: /* list: exp ','  */
#line 3347 "parser.ypp"
                  {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
            QoreParseListNode* l;
            if ((yyvsp[-1].qv).getType() == NT_PARSE_LIST) {
                l = (yyvsp[-1].qv).get<QoreParseListNode>();
                if (l->isFinalized()) {
                    QoreParseListNode* nl = new QoreParseListNode(loc);
                    nl->add(l, loc);
                    l = nl;
                }
            } else {
                l = new QoreParseListNode(loc);
                l->add((yyvsp[-1].qv), loc);
            }
            (yyval.parse_list) = l;
        }
#line 10001 "parser.cpp"
    break;

  case 251: /* list_n: exp_n ',' exp  */
#line 3366 "parser.ypp"
                      {
            const QoreProgramLocation* loc1 = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
            const QoreProgramLocation* loc3 = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[-2]).last_line);
            (yyval.parse_list) = splice_expressions((yyvsp[-2].qv), (yyvsp[0].qv), loc1, loc3);
        }
#line 10011 "parser.cpp"
    break;

  case 252: /* list_n: exp_n ','  */
#line 3371 "parser.ypp"
                    {
            QoreParseListNode* l;
            if ((yyvsp[-1].qv).getType() == NT_PARSE_LIST)
                l = (yyvsp[-1].qv).get<QoreParseListNode>();
            else {
                const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
                l = new QoreParseListNode(loc);
                l->add((yyvsp[-1].qv), loc);
            }
            (yyval.parse_list) = l;
        }
#line 10027 "parser.cpp"
    break;

  case 253: /* hash: hash_element  */
#line 3385 "parser.ypp"
                     {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.hash) = new QoreParseHashNode(loc);
            (yyvsp[0].hashelement)->addDelete((yyval.hash));
        }
#line 10037 "parser.cpp"
    break;

  case 254: /* hash: hash ',' hash_element  */
#line 3390 "parser.ypp"
                                {
            (yyvsp[0].hashelement)->addDelete((yyvsp[-2].hash));
            (yyval.hash) = (yyvsp[-2].hash);
        }
#line 10046 "parser.cpp"
    break;

  case 255: /* hash: hash ','  */
#line 3395 "parser.ypp"
        { /* empty ',' on end of hash */ (yyval.hash) = (yyvsp[-1].hash); }
#line 10052 "parser.cpp"
    break;

  case 256: /* hash_element: exp ':' exp  */
#line 3400 "parser.ypp"
        { (yyval.hashelement) = new HashElement((yyvsp[-2].qv), (yyvsp[0].qv), (yylsp[-2]).first_line, (yylsp[0]).last_line); }
#line 10058 "parser.cpp"
    break;

  case 257: /* alt_hash: '{' hash '}'  */
#line 3404 "parser.ypp"
                     {
            // mark for the curly-bracket version of a literal parse hash expression for the hash version of the map operator
            (yyvsp[-1].hash)->setCurly();
            (yyvsp[-1].hash)->finalizeBlock((yylsp[-2]).first_line, (yylsp[0]).last_line);

            (yyval.hash) = (yyvsp[-1].hash);
        }
#line 10070 "parser.cpp"
    break;

  case 258: /* immediate_typed_hash: "typed hash identifier" hash '}'  */
#line 3414 "parser.ypp"
                                               {
            // mark for the curly-bracket version of a literal parse hash expression for the hash version of the map operator
            (yyvsp[-1].hash)->setCurly();

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
            QoreStringMaker fake_cast("hash<%s>", (yyvsp[-2].string));
            free((yyvsp[-2].string));
            (yyval.node) = new QoreParseCastOperatorNode(loc, ParserTypeStruct::getParseType(loc, fake_cast.giveBuffer(), false), (yyvsp[-1].hash));
        }
#line 10084 "parser.cpp"
    break;

  case 259: /* immediate_typed_hash: "typed hash identifier" '}'  */
#line 3423 "parser.ypp"
                                            {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            QoreStringMaker fake_cast("hash<%s>", (yyvsp[-1].string));
            free((yyvsp[-1].string));
            (yyval.node) = new QoreParseCastOperatorNode(loc, ParserTypeStruct::getParseType(loc, fake_cast.giveBuffer(), false), new QoreParseHashNode(loc, true));
        }
#line 10095 "parser.cpp"
    break;

  case 260: /* exp_c: scalar  */
#line 3433 "parser.ypp"
        { (yyval.qv).set((yyvsp[0].qv)); }
#line 10101 "parser.cpp"
    break;

  case 261: /* exp_c: "binary constant value"  */
#line 3435 "parser.ypp"
        { (yyval.qv).set((yyvsp[0].binary)); }
#line 10107 "parser.cpp"
    break;

  case 262: /* exp_c: '(' hash ')'  */
#line 3437 "parser.ypp"
        { (yyval.qv).set((yyvsp[-1].hash)); }
#line 10113 "parser.cpp"
    break;

  case 263: /* exp_c: "namespace or class-scoped reference"  */
#line 3439 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new ScopedRefNode(loc, (yyvsp[0].string)));
        }
#line 10122 "parser.cpp"
    break;

  case 264: /* exp_c: qtypedef "variable reference"  */
#line 3443 "parser.ypp"
                           {
            fix_start_location((yyvsp[-1].parsertype), (yyloc), (yylsp[0]));
            if (!(yyvsp[-1].parsertype) && !strcmp((yyvsp[0].string), "argv"))
                inc_argv_ref();

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-1].parsertype) ? (yylsp[-1]).first_line : (yylsp[0]).first_line, (yylsp[0]).last_line);
            if ((yyvsp[-1].parsertype))
                (yyval.qv).set(new VarRefDeclNode(loc, (yyvsp[0].string), get_var_type(), ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype))));
            else
                (yyval.qv).set(new VarRefNode(loc, (yyvsp[0].string), get_var_type()));

            delete (yyvsp[-1].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to variable '%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
        }
#line 10142 "parser.cpp"
    break;

  case 265: /* exp_c: qtypedef "namespace-scoped global variable reference"  */
#line 3458 "parser.ypp"
                               {
            fix_start_location((yyvsp[-1].parsertype), (yyloc), (yylsp[0]));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yyvsp[-1].parsertype) ? (yylsp[-1]).first_line : (yylsp[0]).first_line, (yylsp[0]).last_line);
            if ((yyvsp[-1].parsertype))
                (yyval.qv).set(new VarRefDeclNode(loc, (yyvsp[0].string), get_var_type(), ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype))));
            else
                (yyval.qv).set(new VarRefNode(loc, (yyvsp[0].string), get_var_type()));

            delete (yyvsp[-1].parsertype);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to variable '%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
        }
#line 10159 "parser.cpp"
    break;

  case 266: /* exp_c: uncqtypedef "identifier"  */
#line 3470 "parser.ypp"
                                 {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new VarRefDeclNode(loc, (yyvsp[0].string), get_var_type(), ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype))));
            delete (yyvsp[-1].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[0].string));
        }
#line 10171 "parser.cpp"
    break;

  case 267: /* exp_c: "my" uncqtypedef "identifier"  */
#line 3477 "parser.ypp"
                                        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
            VarRefDeclNode* v = new VarRefDeclNode(loc, (yyvsp[0].string), VT_LOCAL, ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)));
            v->setExplicitScope();
            (yyval.qv).set(v);
            delete (yyvsp[-1].parsertype);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[0].string));
        }
#line 10185 "parser.cpp"
    break;

  case 268: /* exp_c: "my" "identifier"  */
#line 3486 "parser.ypp"
                            {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            // see if types are required
            if (parse_check_parse_option(PO_REQUIRE_TYPES))
                parse_error(*loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", (yyvsp[0].string));
            VarRefNode* v = new VarRefNode(loc, (yyvsp[0].string), VT_LOCAL);
            v->setExplicitScope();
            (yyval.qv).set(v);
            if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "local variable '%s' declared without '$' prefix, but parse option 'allow-bare-refs' is not set", (yyvsp[0].string));
        }
#line 10201 "parser.cpp"
    break;

  case 269: /* exp_c: "my" qtypedef "variable reference"  */
#line 3497 "parser.ypp"
                                  {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
            VarRefNode* v;
            if ((yyvsp[-1].parsertype)) {
                v = new VarRefDeclNode(loc, (yyvsp[0].string), VT_LOCAL, ParserTypeStruct::getTypeInfo((yyvsp[-1].parsertype)), ParserTypeStruct::getParseTypeInfo((yyvsp[-1].parsertype)));
                delete (yyvsp[-1].parsertype);
            } else {
                // see if types are required
                if (parse_check_parse_option(PO_REQUIRE_TYPES))
                    parse_error(*loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", (yyvsp[0].string));
                v = new VarRefNode(loc, (yyvsp[0].string), VT_LOCAL);
            }
            v->setExplicitScope();
            (yyval.qv).set(v);
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to variable '$%s' with the '$' sign is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
        }
#line 10223 "parser.cpp"
    break;

  case 270: /* exp_c: "my" '(' list ')'  */
#line 3514 "parser.ypp"
                              {
            (yyvsp[-1].parse_list)->setVariableList();
            QoreParseListNode::nvec_t& vl = (yyvsp[-1].parse_list)->getValues();
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            for (unsigned i = 0; i < vl.size(); ++i) {
                QoreValue& n = vl[i];
                qore_type_t t = n.getType();
                if (t == NT_BAREWORD) {
                    BarewordNode* b = n.get<BarewordNode>();
                    if (parse_check_parse_option(PO_REQUIRE_TYPES))
                        parse_error(*loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", b->str);
                    if (!parse_check_parse_option(PO_ALLOW_BARE_REFS))
                        parse_error(*loc, "local variable '%s' in local variable declaration list declared without '$' prefix, but parse option 'allow-bare-refs' is not set", b->str);
                    VarRefNode* v = new VarRefNode(loc, b->takeString(), VT_LOCAL);
                    v->setExplicitScope();
                    b->deref();
                    n = v;
                } else if (t == NT_VARREF) {
                    VarRefNode* v = n.get<VarRefNode>();
                    // see if types are required
                    if (parse_check_parse_option(PO_REQUIRE_TYPES) && !v->isDecl())
                        parse_error(*loc, "local variable '%s' declared without type information, but parse options require all declarations to have type information", v->getName());
                    if (v->explicitScope()) {
                        if (v->getType() == VT_LOCAL)
                            parse_error(*loc, "illegal use of 'my %s' in local variable declaration list", v->getName());
                        else if (v->getType() == VT_GLOBAL)
                            parse_error(*loc, "illegal use of 'our %s' in local variable declaration list", v->getName());
                    } else
                        v->makeLocal();
                    v->setExplicitScope();
                } else
                    parse_error(*loc, "element %d in list following 'my' is not a variable reference (%s)", i, n.getTypeName());
            }
            (yyval.qv).set((yyvsp[-1].parse_list));
        }
#line 10263 "parser.cpp"
    break;

  case 271: /* exp_c: gvardecl  */
#line 3549 "parser.ypp"
                   {
            (yyval.qv).set((yyvsp[0].gv)->makeVar());
        }
#line 10271 "parser.cpp"
    break;

  case 272: /* exp_c: "identifier"  */
#line 3553 "parser.ypp"
        {
            if (parse_check_parse_option(PO_ASSUME_LOCAL & PO_ALLOW_BARE_REFS) && !strcmp((yyvsp[0].string), "argv"))
                inc_argv_ref();

            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new BarewordNode(loc, (yyvsp[0].string)));
        }
#line 10283 "parser.cpp"
    break;

  case 273: /* exp_c: "context reference"  */
#line 3561 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new ContextrefNode(loc, (yyvsp[0].string)));
        }
#line 10292 "parser.cpp"
    break;

  case 274: /* exp_c: "%%"  */
#line 3566 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new ContextRowNode(loc));
        }
#line 10301 "parser.cpp"
    break;

  case 275: /* exp_c: "named context reference"  */
#line 3571 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new ComplexContextrefNode(loc, (yyvsp[0].string)));
        }
#line 10310 "parser.cpp"
    break;

  case 276: /* exp_c: "find" exp "in" exp "where" '(' exp ')'  */
#line 3576 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-7]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new FindNode(loc, (yyvsp[-6].qv), (yyvsp[-4].qv), (yyvsp[-1].qv)));
        }
#line 10319 "parser.cpp"
    break;

  case 277: /* exp_c: "exists" exp  */
#line 3581 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreExistsOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10328 "parser.cpp"
    break;

  case 278: /* exp_c: "elements" exp  */
#line 3586 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreElementsOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10337 "parser.cpp"
    break;

  case 279: /* exp_c: "keys" exp  */
#line 3590 "parser.ypp"
                       {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreKeysOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10346 "parser.cpp"
    break;

  case 280: /* exp_c: "unshift" exp  */
#line 3594 "parser.ypp"
                          {  // unshift list, element
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to unshift, expected: lvalue, expression (%s)", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue lv = l->shift();
                (yyval.qv).set(new QoreUnshiftOperatorNode(loc, lv, l->shift()));
                (yyvsp[0].qv).discard(nullptr);
            }
        }
#line 10365 "parser.cpp"
    break;

  case 281: /* exp_c: "shift" exp  */
#line 3608 "parser.ypp"
                        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreShiftOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10374 "parser.cpp"
    break;

  case 282: /* exp_c: "push" exp  */
#line 3612 "parser.ypp"
                       {  // push lvalue-list, element
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to push, expected: lvalue, expression (%s)", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue lv = l->shift();
                (yyval.qv).set(new QorePushOperatorNode(loc, lv, l->shift()));
                (yyvsp[0].qv).discard(nullptr);
            }
        }
#line 10393 "parser.cpp"
    break;

  case 283: /* exp_c: "pop" exp  */
#line 3626 "parser.ypp"
                      {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QorePopOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10402 "parser.cpp"
    break;

  case 284: /* exp_c: "chomp" exp  */
#line 3630 "parser.ypp"
                        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreChompOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10411 "parser.cpp"
    break;

  case 285: /* exp_c: "trim" exp  */
#line 3634 "parser.ypp"
                       {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreTrimOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10420 "parser.cpp"
    break;

  case 286: /* exp_c: "splice" exp  */
#line 3638 "parser.ypp"
                         {  // splice lvalue-list, offset, [length, list]
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            if (!l) {
                parse_error(*loc, "invalid arguments to splice, expected: lvalue, offset exp[, length exp[, list exp]] (got %s)", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            } else if (l->size() < 2) {
                parse_error(*loc, "too few arguments to splice, expected at least 2 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            } else if (l->size() > 4) {
                parse_error(*loc, "too many arguments to splice, expected maximum 4 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            } else {
                QoreValue lv = l->shift();
                QoreValue offset = l->shift();
                QoreValue length = l->shift();
                (yyval.qv).set(new QoreSpliceOperatorNode(loc, lv, offset, length, l->shift()));
                discard(l, 0);
            }
        }
#line 10448 "parser.cpp"
    break;

  case 287: /* exp_c: "extract" exp  */
#line 3661 "parser.ypp"
                          {  // extract lvalue-list, offset, [length, list]
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            if (!l) {
                parse_error(*loc, "invalid arguments to extract, expected: lvalue, offset exp[, length exp[, list exp]] (got %s)", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else if (l->size() < 2) {
                parse_error(*loc, "too few arguments to extract, expected at least 2 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else if (l->size() > 4) {
                parse_error(*loc, "too many arguments to extract, expected maximum 4 arguments as follows: lvalue, offset exp[, length exp[, list exp]] (got %d arguments)", l->size());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue lv = l->shift();
                QoreValue offset = l->shift();
                QoreValue length = l->shift();
                (yyval.qv).set(new QoreExtractOperatorNode(loc, lv, offset, length, l->shift()));
                discard(l, 0);
            }
        }
#line 10479 "parser.cpp"
    break;

  case 288: /* exp_c: "map" exp  */
#line 3687 "parser.ypp"
                      {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            pop_ignore_numeric_argv_ref();
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            int len = l ? (int)l->size() : 0;
            if (!l || len < 2 || len > 3) {
                parse_error(*loc, "invalid arguments to map operator, expected: 2 or 3 element list (code expression, list argument, [select expression]), got: '%s'", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            } else {
                // get first expression from list
                QoreValue exp = l->shift();
                qore_type_t t = exp.getType();
                (yyval.qv).set(nullptr);
                bool is_curly = false;
                if (t == NT_PARSE_HASH) {
                    QoreParseHashNode* phn = exp.get<QoreParseHashNode>();
                    if (phn->isCurly()) {
                        is_curly = true;
                        (yyval.qv).set(parse_hash_map(loc, phn, l));
                    }
                }

                if (!(yyval.qv) && !is_curly) {
                    (yyval.qv).set(parse_map(loc, exp, l));
                }
            }
        }
#line 10512 "parser.cpp"
    break;

  case 289: /* exp_c: "foldr" exp  */
#line 3715 "parser.ypp"
                        {
            pop_ignore_numeric_argv_ref();
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to foldr operator, expected: 2-element list expected: 2-element list (fold expression and list expression), got: '%s'", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue code_exp = l->shift();
                QoreValue arg = l->shift();
                (yyval.qv).set(new QoreFoldrOperatorNode(loc, code_exp, arg));
                (yyvsp[0].qv).discard(nullptr);
            }
        }
#line 10533 "parser.cpp"
    break;

  case 290: /* exp_c: "foldl" exp  */
#line 3731 "parser.ypp"
                        {
            pop_ignore_numeric_argv_ref();
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to foldl operator, expected: 2-element list (fold expression and list expression), got: '%s'", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue code_exp = l->shift();
                QoreValue arg = l->shift();
                (yyval.qv).set(new QoreFoldlOperatorNode(loc, code_exp, arg));
                (yyvsp[0].qv).discard(nullptr);
            }
        }
#line 10554 "parser.cpp"
    break;

  case 291: /* exp_c: "select" exp  */
#line 3747 "parser.ypp"
                         {
            pop_ignore_numeric_argv_ref();
            QoreParseListNode* l = (yyvsp[0].qv).getType() == NT_PARSE_LIST ? (yyvsp[0].qv).get<QoreParseListNode>() : nullptr;
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            if (!l || l->size() != 2) {
                parse_error(*loc, "invalid arguments to select operator, expected: 2-element list (list expression and select expression) got: '%s'", (yyvsp[0].qv).getTypeName());
                (yyvsp[0].qv).discard(nullptr);
                (yyval.qv).set(nullptr);
            }
            else {
                QoreValue arg = l->shift();
                QoreValue select_exp = l->shift();
                (yyval.qv).set(new QoreSelectOperatorNode(loc, arg, select_exp));
                (yyvsp[0].qv).discard(nullptr);
            }
        }
#line 10575 "parser.cpp"
    break;

  case 292: /* exp_c: "++ operator" exp  */
#line 3763 "parser.ypp"
                          {  // pre-increment
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QorePreIncrementOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10584 "parser.cpp"
    break;

  case 293: /* exp_c: "-- operator" exp  */
#line 3767 "parser.ypp"
                          {  // pre-decrement
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QorePreDecrementOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10593 "parser.cpp"
    break;

  case 294: /* exp_c: "call to base class method" '(' myexp ')'  */
#line 3771 "parser.ypp"
                                        {
            printd(5, "parsing in-object base class method call %s()\n", (yyvsp[-3].nscope)->ostr);
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            if (!strcmp((yyvsp[-3].nscope)->getIdentifier(), "copy"))
                parse_error(*loc, "illegal call to base class copy method '%s'", (yyvsp[-3].nscope)->ostr);

            (yyval.qv).set(new SelfFunctionCallNode(loc, (yyvsp[-3].nscope), make_args(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line), (yyvsp[-1].qv))));
        }
#line 10606 "parser.cpp"
    break;

  case 295: /* exp_c: "identifier or keyword used as function or method identifier" myexp ')'  */
#line 3779 "parser.ypp"
                                            {
            printd(5, "parsing call %s()\n", (yyvsp[-2].string));
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
            const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
            (yyval.qv).set(new FunctionCallNode(loc, (yyvsp[-2].string), make_args(argsloc, (yyvsp[-1].qv))));
        }
#line 10617 "parser.cpp"
    break;

  case 296: /* exp_c: "in-object member reference"  */
#line 3786 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new SelfVarrefNode(loc, (yyvsp[0].string)));
            if (parse_check_parse_option(PO_ALLOW_BARE_REFS))
                parse_error(*loc, "reference to '$.%s' with the '$.' prefix is not allowed when parse option 'allow-bare-refs' is set", (yyvsp[0].string));
        }
#line 10628 "parser.cpp"
    break;

  case 297: /* exp_c: '-' exp  */
#line 3792 "parser.ypp"
                            {
            // FIXME: need to expand constant expression checking to determine
            //        if the expression can throw an exception at run-time
            // first check for constant expressions
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreUnaryMinusOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10640 "parser.cpp"
    break;

  case 298: /* exp_c: '+' exp  */
#line 3800 "parser.ypp"
        {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreUnaryPlusOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10649 "parser.cpp"
    break;

  case 299: /* exp_c: '~' exp  */
#line 3804 "parser.ypp"
                  {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreBinaryNotOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10658 "parser.cpp"
    break;

  case 300: /* exp_c: '!' exp  */
#line 3808 "parser.ypp"
                  {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreLogicalNotOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10667 "parser.cpp"
    break;

  case 301: /* exp_c: '\\' exp  */
#line 3812 "parser.ypp"
                   {
            qore_type_t t = (yyvsp[0].qv).getType();
            //printd(5, "backslash exp line %d, type %s\n", @2.first_line, $2.getTypeName());

            if (t == NT_FUNCTION_CALL || t == NT_PROGRAM_FUNC_CALL) {
                (yyval.qv).set((yyvsp[0].qv).get<FunctionCallNode>()->makeReferenceNodeAndDeref());
            }
            else if (t == NT_SELF_CALL) {
                (yyval.qv).set((yyvsp[0].qv).get<SelfFunctionCallNode>()->makeReferenceNodeAndDeref());
            }
            else if (t == NT_STATIC_METHOD_CALL) {
                (yyval.qv).set((yyvsp[0].qv).get<StaticMethodCallNode>()->makeReferenceNodeAndDeref());
            }
            else {
                bool make_ref = true;

                if (t == NT_OPERATOR) {
                    QoreDotEvalOperatorNode* deon = dynamic_cast<QoreDotEvalOperatorNode*>((yyvsp[0].qv).getInternalNode());
                    if (deon) {
                        (yyval.qv).set(deon->makeCallReference());
                        make_ref = false;
                    }
                }

                if (make_ref) {
                    const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
                    //printd(5, "type=%s\n", $2.getTypeName());
                    (yyval.qv).set(new ParseReferenceNode(loc, (yyvsp[0].qv)));
                }
            }
        }
#line 10703 "parser.cpp"
    break;

  case 302: /* exp_c: "new" "identifier" '(' myexp ')'  */
#line 3843 "parser.ypp"
                                           {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
            (yyval.qv).set(new ScopedObjectCallNode(loc, new NamedScope((yyvsp[-3].string)), make_args(argsloc, (yyvsp[-1].qv))));
            if (parse_check_parse_option(PO_NO_NEW))
                parse_error(*loc, "illegal use of the 'new' operator (conflicts with parse option PO_NO_NEW)");
        }
#line 10715 "parser.cpp"
    break;

  case 303: /* exp_c: "new" "namespace or class-scoped reference" '(' myexp ')'  */
#line 3850 "parser.ypp"
                                           {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
            (yyval.qv).set(new ScopedObjectCallNode(loc, new NamedScope((yyvsp[-3].string)), make_args(argsloc, (yyvsp[-1].qv))));
            if (parse_check_parse_option(PO_NO_NEW))
                parse_error(*loc, "illegal use of the 'new' operator (conflicts with parse option PO_NO_NEW)");
        }
#line 10727 "parser.cpp"
    break;

  case 304: /* exp_c: "new" "complex type identifier" '(' myexp ')'  */
#line 3857 "parser.ypp"
                                                 {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line);
            const QoreProgramLocation* argsloc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line);
            (yyval.qv).set(new ParseNewComplexTypeNode(loc, ParserTypeStruct::getParseType(loc, (yyvsp[-3].string), false), make_args(argsloc, (yyvsp[-1].qv))));
            if (parse_check_parse_option(PO_NO_NEW))
                parse_error(*loc, "illegal use of the 'new' operator (conflicts with parse option PO_NO_NEW)");
        }
#line 10739 "parser.cpp"
    break;

  case 305: /* exp_c: "background" exp  */
#line 3864 "parser.ypp"
                             {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreBackgroundOperatorNode(loc, (yyvsp[0].qv)));
            // check to see if the expression is legal
            if (parse_check_parse_option(PO_NO_THREAD_CONTROL))
                parse_error(*loc, "illegal use of 'background' operator (conflicts with parse option PO_NO_THREAD_CONTROL)");
            else if (!value_has_effect_as_root((yyvsp[0].qv))) {
                if (!parse_check_parse_option(PO_ALLOW_STATEMENT_NO_EFFECT)) {
                    parse_error(*loc, "argument to background operator (%s) has no effect", (yyvsp[0].qv).getTypeName());
                }
            } else if (!(yyvsp[0].qv).hasEffect()) {
                parse_error(*loc, "argument to background operator (%s) has no effect", (yyvsp[0].qv).getTypeName());
            }
        }
#line 10758 "parser.cpp"
    break;

  case 306: /* exp_c: "backquote expression"  */
#line 3878 "parser.ypp"
                    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new BackquoteNode(loc, (yyvsp[0].string)));
            if (parse_check_parse_option(PO_NO_EXTERNAL_PROCESS))
                parse_error(*loc, "illegal use of backquote operator (conflicts with parse option PO_NO_EXTERNAL_PROCESS)");
        }
#line 10769 "parser.cpp"
    break;

  case 307: /* exp_c: '(' exp ')'  */
#line 3884 "parser.ypp"
                      {
            (yyval.qv).set((yyvsp[-1].qv));
            switch ((yyvsp[-1].qv).getType()) {
                case NT_PARSE_LIST:
                    (yyvsp[-1].qv).get<QoreParseListNode>()->setFinalized();
                    break;
                case NT_FUNCTION_CALL:
                    (yyvsp[-1].qv).get<FunctionCallNode>()->setFinalized();
                    break;
                case NT_BAREWORD:
                    (yyvsp[-1].qv).get<BarewordNode>()->setFinalized();
                    break;
                case NT_OPERATOR:
                    (yyvsp[-1].qv).get<QoreOperatorNode>()->setInParentheses();
                    break;
            }
        }
#line 10791 "parser.cpp"
    break;

  case 308: /* exp_c: '(' ')'  */
#line 3901 "parser.ypp"
                  {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            QoreParseListNode* l = new QoreParseListNode(loc);
            l->setFinalized();
            (yyval.qv).set(l);
        }
#line 10802 "parser.cpp"
    break;

  case 309: /* exp_c: "sub" '(' myexp ')' return_value block  */
#line 3907 "parser.ypp"
                                                   {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[0]).last_line);
            int ar = get_pop_argv_ref();
            (yyval.qv).set(new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].returnTypeInfo), false, ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS)));
        }
#line 10812 "parser.cpp"
    break;

  case 310: /* exp_c: uncqtypedef "sub" '(' myexp ')' block  */
#line 3912 "parser.ypp"
                                                  {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-5]).first_line, (yylsp[0]).last_line);
            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
            delete (yyvsp[-5].parsertype);

            int ar = get_pop_argv_ref();
            (yyval.qv).set(new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].qv), rt, false, ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS)));
        }
#line 10825 "parser.cpp"
    break;

  case 311: /* exp_c: method_modifiers "sub" '(' myexp ')' return_value block  */
#line 3920 "parser.ypp"
                                                                    {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            check_funcmod(loc, (yyvsp[-6].i4));
            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[-6].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;
            (yyval.qv).set(new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[0].sblock), (yylsp[-3]).first_line, (yylsp[-3]).last_line, (yyvsp[-3].qv), (yyvsp[-1].returnTypeInfo), (yyvsp[-6].i4) | OFM_SYNCED, flags)));
        }
#line 10839 "parser.cpp"
    break;

  case 312: /* exp_c: method_modifiers uncqtypedef "sub" '(' myexp ')' block  */
#line 3929 "parser.ypp"
                                                                   {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-6]).first_line, (yylsp[0]).last_line);
            check_funcmod(loc, (yyvsp[-6].i4));

            RetTypeInfo* rt = new RetTypeInfo(ParserTypeStruct::getParseTypeInfo((yyvsp[-5].parsertype)), ParserTypeStruct::getTypeInfo((yyvsp[-5].parsertype)));
            delete (yyvsp[-5].parsertype);

            int ar = get_pop_argv_ref();
            int64 flags = ar > 0 ? QCF_USES_EXTRA_ARGS : QCF_NO_FLAGS;
            if ((yyvsp[-6].i4) & OFM_DEPRECATED)
                flags |= QCF_DEPRECATED;
            (yyval.qv).set(new QoreClosureParseNode(loc, new UserClosureFunction((yyvsp[0].sblock), (yylsp[-2]).first_line, (yylsp[-2]).last_line, (yyvsp[-2].qv), rt, (yyvsp[-6].i4) | OFM_SYNCED, flags)));
        }
#line 10857 "parser.cpp"
    break;

  case 313: /* exp_c: "implicit argument reference"  */
#line 3942 "parser.ypp"
                           {
            (yyval.qv).set((yyvsp[0].implicit_arg));
            inc_numeric_argv_ref();
        }
#line 10866 "parser.cpp"
    break;

  case 314: /* exp_c: "$# operator"  */
#line 3946 "parser.ypp"
                           {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreImplicitElementNode(loc));
        }
#line 10875 "parser.cpp"
    break;

  case 315: /* exp_c: "delete" exp  */
#line 3950 "parser.ypp"
                         {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreDeleteOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10884 "parser.cpp"
    break;

  case 316: /* exp_c: "remove" exp  */
#line 3954 "parser.ypp"
                         {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreRemoveOperatorNode(loc, (yyvsp[0].qv)));
        }
#line 10893 "parser.cpp"
    break;

  case 317: /* exp_c: "cast operator" '(' exp ')'  */
#line 3958 "parser.ypp"
                                {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreParseCastOperatorNode(loc, ParserTypeStruct::getParseType(loc, (yyvsp[-3].string), false), (yyvsp[-1].qv)));
        }
#line 10902 "parser.cpp"
    break;

  case 318: /* exp_c: "cast (or nothing) operator" '(' exp ')'  */
#line 3962 "parser.ypp"
                                           {
            const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
            (yyval.qv).set(new QoreParseCastOperatorNode(loc, ParserTypeStruct::getParseType(loc, (yyvsp[-3].string), true), (yyvsp[-1].qv)));
        }
#line 10911 "parser.cpp"
    break;

  case 319: /* exp: exp_c  */
#line 3969 "parser.ypp"
                                        { (yyval.qv).set((yyvsp[0].qv)); }
#line 10917 "parser.cpp"
    break;

  case 320: /* exp: list  */
#line 3970 "parser.ypp"
                                        { (yyval.qv).set((yyvsp[0].parse_list)); }
#line 10923 "parser.cpp"
    break;

  case 321: /* exp: alt_hash  */
#line 3971 "parser.ypp"
                                        { (yyval.qv).set((yyvsp[0].hash)); }
#line 10929 "parser.cpp"
    break;

  case 322: /* exp: immediate_typed_hash  */
#line 3972 "parser.ypp"
                                        { (yyval.qv).set((yyvsp[0].node)); }
#line 10935 "parser.cpp"
    break;

  case 323: /* exp: '{' '}'  */
#line 3973 "parser.ypp"
                                        { (yyval.qv).set(new QoreParseHashNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), true)); }
#line 10941 "parser.cpp"
    break;

  case 324: /* exp: exp "+= operator" exp  */
#line 3974 "parser.ypp"
                                        { (yyval.qv).set(new QorePlusEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10947 "parser.cpp"
    break;

  case 325: /* exp: exp "-= operator" exp  */
#line 3975 "parser.ypp"
                                        { (yyval.qv).set(new QoreMinusEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10953 "parser.cpp"
    break;

  case 326: /* exp: exp "&= operator" exp  */
#line 3976 "parser.ypp"
                                        { (yyval.qv).set(new QoreAndEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10959 "parser.cpp"
    break;

  case 327: /* exp: exp "|= operator" exp  */
#line 3977 "parser.ypp"
                                        { (yyval.qv).set(new QoreOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10965 "parser.cpp"
    break;

  case 328: /* exp: exp "%= operator" exp  */
#line 3978 "parser.ypp"
                                        { (yyval.qv).set(new QoreModuloEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10971 "parser.cpp"
    break;

  case 329: /* exp: exp "*= operator" exp  */
#line 3979 "parser.ypp"
                                        { (yyval.qv).set(new QoreMultiplyEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10977 "parser.cpp"
    break;

  case 330: /* exp: exp "/= operator" exp  */
#line 3980 "parser.ypp"
                                        { (yyval.qv).set(new QoreDivideEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10983 "parser.cpp"
    break;

  case 331: /* exp: exp "^= operator" exp  */
#line 3981 "parser.ypp"
                                        { (yyval.qv).set(new QoreXorEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10989 "parser.cpp"
    break;

  case 332: /* exp: exp "<<= operator" exp  */
#line 3982 "parser.ypp"
                                        { (yyval.qv).set(new QoreShiftLeftEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 10995 "parser.cpp"
    break;

  case 333: /* exp: exp ">>= operator" exp  */
#line 3983 "parser.ypp"
                                        { (yyval.qv).set(new QoreShiftRightEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11001 "parser.cpp"
    break;

  case 334: /* exp: exp '=' exp  */
#line 3984 "parser.ypp"
                                        {
        (yyval.qv).set(process_assignment((yylsp[-2]).first_line, (yylsp[0]).last_line, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 11009 "parser.cpp"
    break;

  case 335: /* exp: exp ":= operator" exp  */
#line 3987 "parser.ypp"
                                        {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        // see if the use of the weak assignment operator is allowed
        if (!parse_check_parse_option(PO_ALLOW_WEAK_REFERENCES))
            parse_error(*loc, "unauthorized use of the weak reference assignment operator \":=\" (parse option PO_ALLOW_WEAK_REFERENCES is not set)");

        (yyval.qv).set(process_weak_assignment(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 11022 "parser.cpp"
    break;

  case 336: /* exp: exp "instanceof" uncqtypedef  */
#line 3995 "parser.ypp"
                                        {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        (yyval.qv).set((yyvsp[0].parsertype)->getTypeInfo()
            ? new QoreInstanceOfOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].parsertype)->getTypeInfo())
            : new QoreInstanceOfOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].parsertype)->getParseTypeInfo()));
        delete (yyvsp[0].parsertype);
    }
#line 11034 "parser.cpp"
    break;

  case 337: /* exp: exp "?? operator" exp  */
#line 4002 "parser.ypp"
                                        { (yyval.qv).set(new QoreNullCoalescingOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11040 "parser.cpp"
    break;

  case 338: /* exp: exp "?* operator" exp  */
#line 4003 "parser.ypp"
                                        { (yyval.qv).set(new QoreValueCoalescingOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11046 "parser.cpp"
    break;

  case 339: /* exp: exp '?' exp ':' exp  */
#line 4004 "parser.ypp"
                                        { (yyval.qv).set(new QoreQuestionMarkOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].qv), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11052 "parser.cpp"
    break;

  case 340: /* exp: exp "++ operator"  */
#line 4005 "parser.ypp"
                                        { (yyval.qv).set(new QorePostIncrementOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].qv))); }
#line 11058 "parser.cpp"
    break;

  case 341: /* exp: exp "-- operator"  */
#line 4006 "parser.ypp"
                                        { (yyval.qv).set(new QorePostDecrementOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].qv))); }
#line 11064 "parser.cpp"
    break;

  case 342: /* exp: exp '(' myexp ')'  */
#line 4007 "parser.ypp"
                                        { (yyval.qv).set(processCall((yylsp[-3]).first_line, (yylsp[0]).last_line, (yyvsp[-3].qv), (yyvsp[-1].qv), qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line))); }
#line 11070 "parser.cpp"
    break;

  case 343: /* exp: exp "&& operator" exp  */
#line 4008 "parser.ypp"
                                        {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        check_operator_log_or(loc, (yyvsp[-2].qv), "logical AND");
        (yyval.qv).set(new QoreLogicalAndOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 11080 "parser.cpp"
    break;

  case 344: /* exp: exp "|| operator" exp  */
#line 4013 "parser.ypp"
                                        { (yyval.qv).set(new QoreLogicalOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11086 "parser.cpp"
    break;

  case 345: /* exp: exp "|| operator (compat)" exp  */
#line 4014 "parser.ypp"
                                        { (yyval.qv).set(new QoreLogicalOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11092 "parser.cpp"
    break;

  case 346: /* exp: exp "| operator (compat)" exp  */
#line 4015 "parser.ypp"
                                        { (yyval.qv).set(new QoreBinaryOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11098 "parser.cpp"
    break;

  case 347: /* exp: exp "^ operator (compat)" exp  */
#line 4016 "parser.ypp"
                                        {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        check_operator_bin_or(loc, (yyvsp[-2].qv), "binary XOR");
        (yyval.qv).set(new QoreBinaryXorOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 11108 "parser.cpp"
    break;

  case 348: /* exp: exp '|' exp  */
#line 4021 "parser.ypp"
                                        { (yyval.qv).set(new QoreBinaryOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11114 "parser.cpp"
    break;

  case 349: /* exp: exp '&' exp  */
#line 4022 "parser.ypp"
                                        {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        check_operator_bin_or(loc, (yyvsp[-2].qv), "binary AND");
        check_operator_bin_xor(loc, (yyvsp[-2].qv), "binary AND");
        (yyval.qv).set(new QoreBinaryAndOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 11125 "parser.cpp"
    break;

  case 350: /* exp: exp '^' exp  */
#line 4028 "parser.ypp"
                                        { (yyval.qv).set(new QoreBinaryXorOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11131 "parser.cpp"
    break;

  case 351: /* exp: exp "=~ operator" "regular expression"  */
#line 4029 "parser.ypp"
                                        { (yyval.qv).set(new QoreRegexMatchOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Regex))); }
#line 11137 "parser.cpp"
    break;

  case 352: /* exp: exp "!~ operator" "regular expression"  */
#line 4030 "parser.ypp"
                                        { (yyval.qv).set(new QoreRegexNMatchOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Regex))); }
#line 11143 "parser.cpp"
    break;

  case 353: /* exp: exp "=~ operator" "regular expression substitution expression"  */
#line 4031 "parser.ypp"
                                        { (yyval.qv).set(new QoreRegexSubstOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].RegexSubst))); }
#line 11149 "parser.cpp"
    break;

  case 354: /* exp: exp "=~ operator" "transliteration expression"  */
#line 4032 "parser.ypp"
                                        { (yyval.qv).set(new QoreTransliterationOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Trans))); }
#line 11155 "parser.cpp"
    break;

  case 355: /* exp: exp "=~ operator" "regular expression extraction expression"  */
#line 4033 "parser.ypp"
                                        { (yyval.qv).set(new QoreRegexExtractOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Regex))); }
#line 11161 "parser.cpp"
    break;

  case 356: /* exp: exp '>' exp  */
#line 4034 "parser.ypp"
                                        { (yyval.qv).set(new QoreLogicalGreaterThanOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11167 "parser.cpp"
    break;

  case 357: /* exp: exp '<' exp  */
#line 4035 "parser.ypp"
                                        { (yyval.qv).set(new QoreLogicalLessThanOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11173 "parser.cpp"
    break;

  case 358: /* exp: exp "<=> operator" exp  */
#line 4036 "parser.ypp"
                                        { (yyval.qv).set(new QoreLogicalComparisonOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11179 "parser.cpp"
    break;

  case 359: /* exp: exp "== operator" exp  */
#line 4037 "parser.ypp"
                                        { (yyval.qv).set(new QoreLogicalEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11185 "parser.cpp"
    break;

  case 360: /* exp: exp "=== operator" exp  */
#line 4038 "parser.ypp"
                                        { (yyval.qv).set(new QoreLogicalAbsoluteEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11191 "parser.cpp"
    break;

  case 361: /* exp: exp "!== operator" exp  */
#line 4039 "parser.ypp"
                                        { (yyval.qv).set(new QoreLogicalAbsoluteNotEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11197 "parser.cpp"
    break;

  case 362: /* exp: exp "!= operator" exp  */
#line 4040 "parser.ypp"
                                        { (yyval.qv).set(new QoreLogicalNotEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11203 "parser.cpp"
    break;

  case 363: /* exp: exp "<= operator" exp  */
#line 4041 "parser.ypp"
                                        { (yyval.qv).set(new QoreLogicalLessThanOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11209 "parser.cpp"
    break;

  case 364: /* exp: exp ">= operator" exp  */
#line 4042 "parser.ypp"
                                        { (yyval.qv).set(new QoreLogicalGreaterThanOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11215 "parser.cpp"
    break;

  case 365: /* exp: exp "<< operator" exp  */
#line 4043 "parser.ypp"
                                        { (yyval.qv).set(new QoreShiftLeftOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11221 "parser.cpp"
    break;

  case 366: /* exp: exp ">> operator" exp  */
#line 4044 "parser.ypp"
                                        { (yyval.qv).set(new QoreShiftRightOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11227 "parser.cpp"
    break;

  case 367: /* exp: exp '+' exp  */
#line 4045 "parser.ypp"
                                        { (yyval.qv).set(new QorePlusOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11233 "parser.cpp"
    break;

  case 368: /* exp: exp '-' exp  */
#line 4046 "parser.ypp"
                                        { (yyval.qv).set(new QoreMinusOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11239 "parser.cpp"
    break;

  case 369: /* exp: exp '%' exp  */
#line 4047 "parser.ypp"
                                        { (yyval.qv).set(new QoreModuloOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11245 "parser.cpp"
    break;

  case 370: /* exp: exp '/' exp  */
#line 4048 "parser.ypp"
                                        { (yyval.qv).set(new QoreDivisionOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11251 "parser.cpp"
    break;

  case 371: /* exp: exp '*' exp  */
#line 4049 "parser.ypp"
                                        { (yyval.qv).set(new QoreMultiplicationOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11257 "parser.cpp"
    break;

  case 372: /* exp: exp '[' exp ".. operator" ']'  */
#line 4050 "parser.ypp"
                                        { (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].qv), (yyvsp[-2].qv), QoreValue())); }
#line 11263 "parser.cpp"
    break;

  case 373: /* exp: exp '[' ".. operator" exp ']'  */
#line 4051 "parser.ypp"
                                        { (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].qv), QoreValue(), (yyvsp[-1].qv))); }
#line 11269 "parser.cpp"
    break;

  case 374: /* exp: exp '[' ".. operator" ']'  */
#line 4052 "parser.ypp"
                                        {
        parse_error(*qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line), "illegal range without start or end expressions; at least start or end must be given for a range");
        (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line), (yyvsp[-3].qv), QoreValue(), QoreValue()));
    }
#line 11278 "parser.cpp"
    break;

  case 375: /* exp: exp '[' exp ']'  */
#line 4056 "parser.ypp"
                                        {
        (yyval.qv).set(nullptr);
        // issue #2198: if we have a range between square brackets, we need to return a QoreSquareBracketsRangeOperatorNode
        if ((yyvsp[-1].qv).getType() == NT_OPERATOR) {
            QoreRangeOperatorNode* ron = dynamic_cast<QoreRangeOperatorNode*>((yyvsp[-1].qv).getInternalNode());
            if (ron) {
                std::unique_ptr<QoreRangeOperatorNode> holder(ron);
                (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line), (yyvsp[-3].qv), ron->swapLeft(QoreValue()), ron->swapRight(QoreValue())));
            }
        }
        if (!(yyval.qv)) {
            (yyval.qv).set(new QoreSquareBracketsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].qv), (yyvsp[-1].qv)));
        }
    }
#line 11297 "parser.cpp"
    break;

  case 376: /* exp: exp '{' exp '}'  */
#line 4070 "parser.ypp"
                                        { (yyval.qv).set(new QoreHashObjectDereferenceOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].qv), (yyvsp[-1].qv))); }
#line 11303 "parser.cpp"
    break;

  case 377: /* exp: exp ".. operator" exp  */
#line 4071 "parser.ypp"
                                        { (yyval.qv).set(new QoreRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11309 "parser.cpp"
    break;

  case 378: /* exp: exp '.' exp  */
#line 4072 "parser.ypp"
                                        { (yyval.qv).set(process_dot((yylsp[-2]).first_line, (yylsp[0]).last_line, (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11315 "parser.cpp"
    break;

  case 379: /* exp: exp "keyword used as hash key or object member reference"  */
#line 4073 "parser.ypp"
                                        { (yyval.qv).set(new QoreHashObjectDereferenceOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].qv), (yyvsp[0].String))); }
#line 11321 "parser.cpp"
    break;

  case 380: /* exp_n: exp_c  */
#line 4077 "parser.ypp"
                                          { (yyval.qv).set((yyvsp[0].qv)); }
#line 11327 "parser.cpp"
    break;

  case 381: /* exp_n: list_n  */
#line 4078 "parser.ypp"
                                          { (yyval.qv).set((yyvsp[0].parse_list)); }
#line 11333 "parser.cpp"
    break;

  case 382: /* exp_n: exp_n "+= operator" exp  */
#line 4079 "parser.ypp"
                                          { (yyval.qv).set(new QorePlusEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11339 "parser.cpp"
    break;

  case 383: /* exp_n: exp_n "-= operator" exp  */
#line 4080 "parser.ypp"
                                          { (yyval.qv).set(new QoreMinusEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11345 "parser.cpp"
    break;

  case 384: /* exp_n: exp_n "&= operator" exp  */
#line 4081 "parser.ypp"
                                          { (yyval.qv).set(new QoreAndEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11351 "parser.cpp"
    break;

  case 385: /* exp_n: exp_n "|= operator" exp  */
#line 4082 "parser.ypp"
                                          { (yyval.qv).set(new QoreOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11357 "parser.cpp"
    break;

  case 386: /* exp_n: exp_n "%= operator" exp  */
#line 4083 "parser.ypp"
                                          { (yyval.qv).set(new QoreModuloEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11363 "parser.cpp"
    break;

  case 387: /* exp_n: exp_n "*= operator" exp  */
#line 4084 "parser.ypp"
                                          { (yyval.qv).set(new QoreMultiplyEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11369 "parser.cpp"
    break;

  case 388: /* exp_n: exp_n "/= operator" exp  */
#line 4085 "parser.ypp"
                                          { (yyval.qv).set(new QoreDivideEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11375 "parser.cpp"
    break;

  case 389: /* exp_n: exp_n "^= operator" exp  */
#line 4086 "parser.ypp"
                                          { (yyval.qv).set(new QoreXorEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11381 "parser.cpp"
    break;

  case 390: /* exp_n: exp_n "<<= operator" exp  */
#line 4087 "parser.ypp"
                                          { (yyval.qv).set(new QoreShiftLeftEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11387 "parser.cpp"
    break;

  case 391: /* exp_n: exp_n ">>= operator" exp  */
#line 4088 "parser.ypp"
                                          { (yyval.qv).set(new QoreShiftRightEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11393 "parser.cpp"
    break;

  case 392: /* exp_n: exp_n '=' exp  */
#line 4089 "parser.ypp"
                                          {
        (yyval.qv).set(process_assignment((yylsp[-2]).first_line, (yylsp[0]).last_line, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 11401 "parser.cpp"
    break;

  case 393: /* exp_n: exp_n ":= operator" exp  */
#line 4092 "parser.ypp"
                                          {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        // see if the use of the weak assignment operator is allowed
        if (!parse_check_parse_option(PO_ALLOW_WEAK_REFERENCES))
            parse_error(*loc, "unauthorized use of the weak reference assignment operator \":=\" (parse option PO_ALLOW_WEAK_REFERENCES is not set)");

        (yyval.qv).set(process_weak_assignment(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 11414 "parser.cpp"
    break;

  case 394: /* exp_n: exp_n "instanceof" uncqtypedef  */
#line 4100 "parser.ypp"
                                          {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        (yyval.qv).set((yyvsp[0].parsertype)->getTypeInfo()
            ? new QoreInstanceOfOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].parsertype)->getTypeInfo())
            : new QoreInstanceOfOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].parsertype)->getParseTypeInfo()));
        delete (yyvsp[0].parsertype);
    }
#line 11426 "parser.cpp"
    break;

  case 395: /* exp_n: exp_n "?? operator" exp  */
#line 4107 "parser.ypp"
                                          { (yyval.qv).set(new QoreNullCoalescingOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11432 "parser.cpp"
    break;

  case 396: /* exp_n: exp_n "?* operator" exp  */
#line 4108 "parser.ypp"
                                          { (yyval.qv).set(new QoreValueCoalescingOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11438 "parser.cpp"
    break;

  case 397: /* exp_n: exp_n '?' exp ':' exp  */
#line 4109 "parser.ypp"
                                          { (yyval.qv).set(new QoreQuestionMarkOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].qv), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11444 "parser.cpp"
    break;

  case 398: /* exp_n: exp_n "++ operator"  */
#line 4110 "parser.ypp"
                                          { (yyval.qv).set(new QorePostIncrementOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].qv))); }
#line 11450 "parser.cpp"
    break;

  case 399: /* exp_n: exp_n "-- operator"  */
#line 4111 "parser.ypp"
                                          { (yyval.qv).set(new QorePostDecrementOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].qv))); }
#line 11456 "parser.cpp"
    break;

  case 400: /* exp_n: exp_n '(' myexp ')'  */
#line 4112 "parser.ypp"
                                          { (yyval.qv).set(processCall((yylsp[-3]).first_line, (yylsp[0]).last_line, (yyvsp[-3].qv), (yyvsp[-1].qv), qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[-1]).last_line))); }
#line 11462 "parser.cpp"
    break;

  case 401: /* exp_n: exp_n "&& operator" exp  */
#line 4113 "parser.ypp"
                                          {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        check_operator_log_or(loc, (yyvsp[-2].qv), "logical AND");
        (yyval.qv).set(new QoreLogicalAndOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 11472 "parser.cpp"
    break;

  case 402: /* exp_n: exp_n "|| operator" exp  */
#line 4118 "parser.ypp"
                                          { (yyval.qv).set(new QoreLogicalOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11478 "parser.cpp"
    break;

  case 403: /* exp_n: exp_n "|| operator (compat)" exp  */
#line 4119 "parser.ypp"
                                          { (yyval.qv).set(new QoreLogicalOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11484 "parser.cpp"
    break;

  case 404: /* exp_n: exp_n "| operator (compat)" exp  */
#line 4120 "parser.ypp"
                                          { (yyval.qv).set(new QoreBinaryOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11490 "parser.cpp"
    break;

  case 405: /* exp_n: exp_n "^ operator (compat)" exp  */
#line 4121 "parser.ypp"
                                          {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        check_operator_bin_or(loc, (yyvsp[-2].qv), "binary XOR");
        (yyval.qv).set(new QoreBinaryXorOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 11500 "parser.cpp"
    break;

  case 406: /* exp_n: exp_n '|' exp  */
#line 4126 "parser.ypp"
                                          { (yyval.qv).set(new QoreBinaryOrOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11506 "parser.cpp"
    break;

  case 407: /* exp_n: exp_n '&' exp  */
#line 4127 "parser.ypp"
                                          {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line);
        check_operator_bin_or(loc, (yyvsp[-2].qv), "binary AND");
        check_operator_bin_xor(loc, (yyvsp[-2].qv), "binary AND");
        (yyval.qv).set(new QoreBinaryAndOperatorNode(loc, (yyvsp[-2].qv), (yyvsp[0].qv)));
    }
#line 11517 "parser.cpp"
    break;

  case 408: /* exp_n: exp_n '^' exp  */
#line 4133 "parser.ypp"
                                          { (yyval.qv).set(new QoreBinaryXorOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11523 "parser.cpp"
    break;

  case 409: /* exp_n: exp_n "=~ operator" "regular expression"  */
#line 4134 "parser.ypp"
                                          { (yyval.qv).set(new QoreRegexMatchOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Regex))); }
#line 11529 "parser.cpp"
    break;

  case 410: /* exp_n: exp_n "!~ operator" "regular expression"  */
#line 4135 "parser.ypp"
                                          { (yyval.qv).set(new QoreRegexNMatchOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Regex))); }
#line 11535 "parser.cpp"
    break;

  case 411: /* exp_n: exp_n "=~ operator" "regular expression substitution expression"  */
#line 4136 "parser.ypp"
                                          { (yyval.qv).set(new QoreRegexSubstOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].RegexSubst))); }
#line 11541 "parser.cpp"
    break;

  case 412: /* exp_n: exp_n "=~ operator" "transliteration expression"  */
#line 4137 "parser.ypp"
                                          { (yyval.qv).set(new QoreTransliterationOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Trans))); }
#line 11547 "parser.cpp"
    break;

  case 413: /* exp_n: exp_n "=~ operator" "regular expression extraction expression"  */
#line 4138 "parser.ypp"
                                          { (yyval.qv).set(new QoreRegexExtractOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].Regex))); }
#line 11553 "parser.cpp"
    break;

  case 414: /* exp_n: exp_n '>' exp  */
#line 4139 "parser.ypp"
                                          { (yyval.qv).set(new QoreLogicalGreaterThanOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11559 "parser.cpp"
    break;

  case 415: /* exp_n: exp_n '<' exp  */
#line 4140 "parser.ypp"
                                          { (yyval.qv).set(new QoreLogicalLessThanOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11565 "parser.cpp"
    break;

  case 416: /* exp_n: exp_n "<=> operator" exp  */
#line 4141 "parser.ypp"
                                          { (yyval.qv).set(new QoreLogicalComparisonOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11571 "parser.cpp"
    break;

  case 417: /* exp_n: exp_n "== operator" exp  */
#line 4142 "parser.ypp"
                                          { (yyval.qv).set(new QoreLogicalEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11577 "parser.cpp"
    break;

  case 418: /* exp_n: exp_n "=== operator" exp  */
#line 4143 "parser.ypp"
                                          { (yyval.qv).set(new QoreLogicalAbsoluteEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11583 "parser.cpp"
    break;

  case 419: /* exp_n: exp_n "!== operator" exp  */
#line 4144 "parser.ypp"
                                          { (yyval.qv).set(new QoreLogicalAbsoluteNotEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11589 "parser.cpp"
    break;

  case 420: /* exp_n: exp_n "!= operator" exp  */
#line 4145 "parser.ypp"
                                          { (yyval.qv).set(new QoreLogicalNotEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11595 "parser.cpp"
    break;

  case 421: /* exp_n: exp_n "<= operator" exp  */
#line 4146 "parser.ypp"
                                          { (yyval.qv).set(new QoreLogicalLessThanOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11601 "parser.cpp"
    break;

  case 422: /* exp_n: exp_n ">= operator" exp  */
#line 4147 "parser.ypp"
                                          { (yyval.qv).set(new QoreLogicalGreaterThanOrEqualsOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11607 "parser.cpp"
    break;

  case 423: /* exp_n: exp_n "<< operator" exp  */
#line 4148 "parser.ypp"
                                          { (yyval.qv).set(new QoreShiftLeftOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11613 "parser.cpp"
    break;

  case 424: /* exp_n: exp_n ">> operator" exp  */
#line 4149 "parser.ypp"
                                          { (yyval.qv).set(new QoreShiftRightOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11619 "parser.cpp"
    break;

  case 425: /* exp_n: exp_n '+' exp  */
#line 4150 "parser.ypp"
                                          { (yyval.qv).set(new QorePlusOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11625 "parser.cpp"
    break;

  case 426: /* exp_n: exp_n '-' exp  */
#line 4151 "parser.ypp"
                                          { (yyval.qv).set(new QoreMinusOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11631 "parser.cpp"
    break;

  case 427: /* exp_n: exp_n '%' exp  */
#line 4152 "parser.ypp"
                                          { (yyval.qv).set(new QoreModuloOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11637 "parser.cpp"
    break;

  case 428: /* exp_n: exp_n '/' exp  */
#line 4153 "parser.ypp"
                                          { (yyval.qv).set(new QoreDivisionOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11643 "parser.cpp"
    break;

  case 429: /* exp_n: exp_n '*' exp  */
#line 4154 "parser.ypp"
                                          { (yyval.qv).set(new QoreMultiplicationOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11649 "parser.cpp"
    break;

  case 430: /* exp_n: exp_n '[' exp ".. operator" ']'  */
#line 4155 "parser.ypp"
                                          { (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].qv), (yyvsp[-2].qv), QoreValue())); }
#line 11655 "parser.cpp"
    break;

  case 431: /* exp_n: exp_n '[' ".. operator" exp ']'  */
#line 4156 "parser.ypp"
                                          { (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-4]).first_line, (yylsp[0]).last_line), (yyvsp[-4].qv), QoreValue(), (yyvsp[-1].qv))); }
#line 11661 "parser.cpp"
    break;

  case 432: /* exp_n: exp_n '[' ".. operator" ']'  */
#line 4157 "parser.ypp"
                                          {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
        parse_error(*loc, "illegal range without start or end expressions; at least start or end must be given for a range");
        (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(loc, (yyvsp[-3].qv), QoreValue(), QoreValue()));
    }
#line 11671 "parser.cpp"
    break;

  case 433: /* exp_n: exp_n '[' exp ']'  */
#line 4162 "parser.ypp"
                                          {
        const QoreProgramLocation* loc = qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[0]).last_line);
        (yyval.qv).set(nullptr);
        // issue #2198: if we have a range between square brackets, we need to return a QoreSquareBracketsRangeOperatorNode
        if ((yyvsp[-1].qv).getType() == NT_OPERATOR) {
            QoreRangeOperatorNode* ron = dynamic_cast<QoreRangeOperatorNode*>((yyvsp[-1].qv).getInternalNode());
            if (ron) {
                std::unique_ptr<QoreRangeOperatorNode> holder(ron);
                (yyval.qv).set(new QoreSquareBracketsRangeOperatorNode(loc, (yyvsp[-3].qv), ron->swapLeft(QoreValue()), ron->swapRight(QoreValue())));
            }
        }
        if (!(yyval.qv)) {
            (yyval.qv).set(new QoreSquareBracketsOperatorNode(loc, (yyvsp[-3].qv), (yyvsp[-1].qv)));
        }
    }
#line 11691 "parser.cpp"
    break;

  case 434: /* exp_n: exp_n '{' exp '}'  */
#line 4177 "parser.ypp"
                                          { (yyval.qv).set(new QoreHashObjectDereferenceOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-3]).first_line, (yylsp[-1]).last_line), (yyvsp[-3].qv), (yyvsp[-1].qv))); }
#line 11697 "parser.cpp"
    break;

  case 435: /* exp_n: exp_n ".. operator" exp  */
#line 4178 "parser.ypp"
                                          { (yyval.qv).set(new QoreRangeOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-2]).first_line, (yylsp[0]).last_line), (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11703 "parser.cpp"
    break;

  case 436: /* exp_n: exp_n '.' exp  */
#line 4179 "parser.ypp"
                                          { (yyval.qv).set(process_dot((yylsp[-2]).first_line, (yylsp[0]).last_line, (yyvsp[-2].qv), (yyvsp[0].qv))); }
#line 11709 "parser.cpp"
    break;

  case 437: /* exp_n: exp_n "keyword used as hash key or object member reference"  */
#line 4180 "parser.ypp"
                                          { (yyval.qv).set(new QoreHashObjectDereferenceOperatorNode(qore_program_private::get(*getProgram())->getLocation((yylsp[-1]).first_line, (yylsp[0]).last_line), (yyvsp[-1].qv), (yyvsp[0].String))); }
#line 11715 "parser.cpp"
    break;

  case 438: /* string: "quoted string"  */
#line 4184 "parser.ypp"
                    {
           (yyval.String) = (yyvsp[0].String);
        }
#line 11723 "parser.cpp"
    break;

  case 439: /* string: "quoted string" string  */
#line 4187 "parser.ypp"
                             {
            (yyval.String) = (yyvsp[-1].String);
            (yyval.String)->concat((yyvsp[0].String));
            (yyvsp[0].String)->deref();
        }
#line 11733 "parser.cpp"
    break;

  case 440: /* scalar: "floating-point value"  */
#line 4195 "parser.ypp"
                      { (yyval.qv).set((yyvsp[0].decimal)); }
#line 11739 "parser.cpp"
    break;

  case 441: /* scalar: "integer value"  */
#line 4196 "parser.ypp"
                      { (yyval.qv).set((yyvsp[0].integer)); }
#line 11745 "parser.cpp"
    break;

  case 442: /* scalar: string  */
#line 4197 "parser.ypp"
                      { (yyval.qv).set((yyvsp[0].String)); }
#line 11751 "parser.cpp"
    break;

  case 443: /* scalar: "date/time value"  */
#line 4198 "parser.ypp"
                      { (yyval.qv).set((yyvsp[0].datetime)); }
#line 11757 "parser.cpp"
    break;

  case 444: /* scalar: "arbitrary-precision number"  */
#line 4199 "parser.ypp"
                      { (yyval.qv).set((yyvsp[0].num)); }
#line 11763 "parser.cpp"
    break;

  case 445: /* scalar: "NOTHING"  */
#line 4200 "parser.ypp"
                      { (yyval.qv).set(nullptr); }
#line 11769 "parser.cpp"
    break;

  case 446: /* scalar: "NULL"  */
#line 4201 "parser.ypp"
                      { (yyval.qv).set(&Null); }
#line 11775 "parser.cpp"
    break;

  case 447: /* scalar: "True"  */
#line 4202 "parser.ypp"
                      { (yyval.qv).set(true); }
#line 11781 "parser.cpp"
    break;

  case 448: /* scalar: "False"  */
#line 4203 "parser.ypp"
                      { (yyval.qv).set(false); }
#line 11787 "parser.cpp"
    break;

  case 449: /* scalar: "... marker"  */
#line 4204 "parser.ypp"
                      {
            (yyval.qv).set(new QoreEllipsesNode(
                qore_program_private::get(*getProgram())->getLocation((yylsp[0]).first_line, (yylsp[0]).last_line))
            );
        }
#line 11797 "parser.cpp"
    break;


#line 11801 "parser.cpp"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yytoken, &yylloc};
        char const *yymsgp = YY_("syntax error");
        int yysyntax_error_status;
        yysyntax_error_status = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
        if (yysyntax_error_status == 0)
          yymsgp = yymsg;
        else if (yysyntax_error_status == -1)
          {
            if (yymsg != yymsgbuf)
              YYSTACK_FREE (yymsg);
            yymsg = YY_CAST (char *,
                             YYSTACK_ALLOC (YY_CAST (YYSIZE_T, yymsg_alloc)));
            if (yymsg)
              {
                yysyntax_error_status
                  = yysyntax_error (&yymsg_alloc, &yymsg, &yyctx);
                yymsgp = yymsg;
              }
            else
              {
                yymsg = yymsgbuf;
                yymsg_alloc = sizeof yymsgbuf;
                yysyntax_error_status = YYENOMEM;
              }
          }
        yyerror (&yylloc, yyscanner, yymsgp);
        if (yysyntax_error_status == YYENOMEM)
          YYNOMEM;
      }
    }

  yyerror_range[1] = yylloc;
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc, yyscanner);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  ++yylsp;
  YYLLOC_DEFAULT (*yylsp, yyerror_range, 2);

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, yyscanner, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc, yyscanner);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
  return yyresult;
}

#line 4211 "parser.ypp"

