/* -*- mode: c++; indent-tabs-mode: nil -*- */
/** @file QC_AbstractXmlIoInputCallback.qpp defines the AbstractXmlIoInputCallback class */
/*
  QC_AbstractXmlIoInputCallback.qpp

  Qore Programming Language

  Copyright (C) 2003 - 2022 Qore Technologies, s.r.o.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "QC_AbstractXmlIoInputCallback.h"
/* Qore class Qore::Xml::AbstractXmlIoInputCallback */

qore_classid_t CID_ABSTRACTXMLIOINPUTCALLBACK;
QoreClass* QC_ABSTRACTXMLIOINPUTCALLBACK;

// AbstractXmlIoInputCallback::constructor() {}
static void AbstractXmlIoInputCallback_constructor(QoreObject* self, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 36 "QC_AbstractXmlIoInputCallback.qpp"
self->setPrivate(CID_ABSTRACTXMLIOINPUTCALLBACK, new AbstractXmlIoInputCallback(self));
}

DLLLOCAL void preinitAbstractXmlIoInputCallbackClass() {
    QC_ABSTRACTXMLIOINPUTCALLBACK = new QoreClass("AbstractXmlIoInputCallback", "::Qore::Xml::AbstractXmlIoInputCallback", QDOM_DEFAULT);
    CID_ABSTRACTXMLIOINPUTCALLBACK = QC_ABSTRACTXMLIOINPUTCALLBACK->getID();
    QC_ABSTRACTXMLIOINPUTCALLBACK->setSystem();
}

DLLLOCAL QoreClass* initAbstractXmlIoInputCallbackClass(QoreNamespace& ns) {
    if (!QC_ABSTRACTXMLIOINPUTCALLBACK)
        preinitAbstractXmlIoInputCallbackClass();

    // AbstractXmlIoInputCallback::constructor() {}
    QC_ABSTRACTXMLIOINPUTCALLBACK->addConstructor(AbstractXmlIoInputCallback_constructor, Public, QCF_NO_FLAGS, QDOM_DEFAULT);

    // *InputStream AbstractXmlIoInputCallback::open(string url);
    QC_ABSTRACTXMLIOINPUTCALLBACK->addAbstractMethod("open", Public, QCF_NO_FLAGS, QC_INPUTSTREAM->getOrNothingTypeInfo(), 1, stringTypeInfo, QORE_PARAM_NO_ARG, "url");

    return QC_ABSTRACTXMLIOINPUTCALLBACK;
}
