# Every update requires an update of these hashes and the version within the control file of each of the 32 ports.
# So it is probably better to have a central location for these hashes and let the ports update via a script
set(QT_MAJOR_MINOR_VER 5.15)
set(QT_PATCH_VER 11)
set(QT_UPDATE_VERSION 0) # Switch to update qt and not build qt. Creates a file cmake/qt_new_hashes.cmake in qt5-base with the new hashes.

set(QT_PORT_LIST base 3d activeqt charts connectivity datavis3d declarative gamepad graphicaleffects imageformats location macextras mqtt multimedia networkauth
                 purchasing quickcontrols quickcontrols2 remoteobjects script scxml sensors serialport speech svg tools virtualkeyboard webchannel websockets
                 webview winextras xmlpatterns doc x11extras androidextras translations serialbus webengine webglplugin wayland)

set(QT_HASH_qt5-3d               34362aafbff5352786e87d98362e8961d4e2d9ad4ddd0c76ec7771375eb3f9c6f23b681c2697752ee9dad228f04e377e0a934859f70e6020dd9613b6ee760f1c)
set(QT_HASH_qt5-activeqt         33e441e56e0d59215c2884f75fbea104c2089e2b7571025f045cd03a8f5db1cf318f7f0bd7107ff2e414ddd0de13e16fbd49ad6c75ae1cef4cc4049429d3fba0)
set(QT_HASH_qt5-androidextras    6524e13c255f8350c0ac4abe8ea6a424daed60b3dc05c2aa66ecdcceace47fe4733a386dd4faf883c1014791e11f7f34633c6189907fbf8da31e81b027ef4003)
set(QT_HASH_qt5-base             4136092eec7bdceba661eee0187b7952ed6ba819148295979c0fd0392c17b0178165fa20136bdf460509a815c96f43892403294ba6e5322c54c51459c358fb7f)
set(QT_HASH_qt5-charts           fe6f32b9d42a6fb6c26d4f860489be18643b1f5b32d5be348f7529fa029cfaea79af0c8493d8d26b0a9d91ebdbdc8ac0d80a3912ee40b36bed863cc5356370bf)
set(QT_HASH_qt5-connectivity     f1bddff89b45352c9f98c7f94be9c5226588219036474d3be1e35b6f0c9327dcb1e8ca4e52e342863ff2e3052014eb7abbed1f9d4381174e326e3c70eebc1306)
set(QT_HASH_qt5-datavis3d        43ca0e5aa9af59d80a05166bb6cf29ab0d1a7421474d7dc974cb960dd3100d417456a2614208ccfca900e2203fd9becea12af6c15dd93107c196ebe17ad47559)
set(QT_HASH_qt5-declarative      08f76c5a1253d6014e48ef8d8c53f65d3087efea0f614f36aa03f37882c6947109b17398ac491157c4fbd0c954762e819c2f074fa5a71e6990f16a54ec7224ae)
set(QT_HASH_qt5-doc              8c7777446ca83fc7a4f2ef33b0f7e032268f67284855fd97900e07e1f7e0b7173bfb980cba206d010c489630719a5f8f08c42b222784a426b0800c4c34f097da)
set(QT_HASH_qt5-gamepad          4aa21aa51d854edd365e21e6f8f195c70998223c2a70603518b00a0efbeddf5ed9c60c33e665c1bb2dbed73e3d9b113b7fbf47287789ea54ba2a1d5c65b72c33)
set(QT_HASH_qt5-graphicaleffects 9e46eb1d985fdde3571f0327229a973b9ba4e3da360c3a890aa9c658a4cd82c20485a46ffbdbfd10c7fe4d6e3c45476682ee561ce3345f1eddebbf97eee162b0)
set(QT_HASH_qt5-imageformats     a41f2adec9470433914a634e3dc79a70e2eda5713be5884029f8ef5eae3c5b2cea4c6de795907ddc69268635aef194325b047cddf84c8be4cf59668d172a89fa)
set(QT_HASH_qt5-location         d439d03ff9044fc70165d1ceb5def9ec3290beec56b3e893409a24cd355651a4317e0eadff0266d38203ff84429a5fb8659a200f094669716579b6791a1a0f6d)
set(QT_HASH_qt5-macextras        5a9427c5dc21ecaac45097c731fcb3cb5c8397f0391e3da52f8aee30a6ba919b4697e6a20008b358c0086e98cb47fec678a2ed421a44c5107425432b5bc59e9a)
set(QT_HASH_qt5-mqtt             7bc1c4f3fa0097c057ffa72fd7ac68a3f7df35b1c0b93a54d53568c4743041887f3e2739c0281fcfad49909c926e9353c0a6523fd2bac62f539e4390044151fe)
set(QT_HASH_qt5-multimedia       1d72f79fe83cc955037ec6c5348058369697889a9a40b9fbaee9f3ad0cb74fe5f97062e026254e3512f0861e67cca8a36eaa19c1b3ffbea32d6b3cde2163b484)
set(QT_HASH_qt5-networkauth      a7e4fcb5d5d5f80640444ae42896920c3e713df887244fbb42ce8de920270204fde1be12664ae24c075cdeea5d98da8f13aa4114524516cd9e3e5f2c68bd016f)
set(QT_HASH_qt5-purchasing       89b2d03528c4902ce2011817246f691902314383e0401638dc06c3bef4664a3d5a37edfe6f290fd7117168fa7862217b67b9a2340353b883b6e2b3741af658a8)
set(QT_HASH_qt5-quickcontrols    0779f9eb1b7b78a9f7662f5c2f7754882c0b85efbfff6e922d044757d1bc47f4c8ba0adb14b1a1347c32abd8086b6031d77c50cf534206f1988c4ce616e4953c)
set(QT_HASH_qt5-quickcontrols2   2621ae1d0c8ebb38ec2c9a0ff28b9bdb3a7aebfd2b6477d145a9772002abdae832aa7daeb8843a8372b32ebe476262650ba23cc977257fd5932499cde796eb32)
set(QT_HASH_qt5-remoteobjects    ae5910c4b4da95cb927389137c2def0e75030024f5139a7634d009f9ebcc81c3f7171e6d0b3a5f3e0201a93eb8fad4d346b70fcc0aefbb1c6c69afc13c6d4848)
set(QT_HASH_qt5-script           116dc95c804fcd78082100d67c51c68c045a17754c8591cb885925c3b3541439317ae79ba7eefc1102ce12d2f544dc502fd67c4d8724f4d7f1347099cda3f744)
set(QT_HASH_qt5-scxml            7b6b9a13e8a142cbb3d10b879877dcffdcf99a815db8149f7ff869c1b967a39620b8fd0bbb5e07832b9aeb91b6152ea5b8413b25020d73531e560041525a7842)
set(QT_HASH_qt5-sensors          94c3ae48a8423fd6af5c984ae99a51cba49d396a6d7032ba29008aa9bea461199986d52449f838278285a98aa3c0a95bb62868368bdc5879ca696273608a74d6)
set(QT_HASH_qt5-serialbus        2f51b449242a05a50cdf761f639dc9fa178eca5531cc520fdd22a1a18e3bac7244acc5a4b596f1ca11dbf7bff38181b451f6cb8de6fcee63165316a5b09956d8)
set(QT_HASH_qt5-serialport       ff863b20283f36f865dbcf363faff5555234438ac29f475f98f2a351bbcac320fb1764ecc42f0cdcc729b6b6a64792ca86f35cfa2567d9ade5ef72ff2e493e2f)
set(QT_HASH_qt5-speech           658eb9d24ea2f2bf39c6f4cd6dc75677067c8058cae694b53e665e28a273d2f730ab0dd4744ca8f8db224e52bb014fd145af1abd1667e3cd37f74c51bf96ebf4)
set(QT_HASH_qt5-svg              ac04197aa69342aa403f476e41a8ea7b1895187812577afe32536130d5605fb1dc7f99c0aef368ccbacb673f8b41efe44a200643b905e4674379aa951a48cf59)
set(QT_HASH_qt5-tools            7aa66964dfc4bd144ee828a5c278b3127c5b269c6fb0e5363e7d2377ba19165e04719636659cb30fee471de26740d3d8692068459e1764d9f84a7737f24c4884)
set(QT_HASH_qt5-translations     bb1d5c353932566b3daccc8b4d9ad957d3c4ea130e67eb933c0a7e49b99d2f9cac2860201a12e37ea51e46ae772a75a4be80d71e3a8afa59f5e14d3e02dd1ce2)
set(QT_HASH_qt5-virtualkeyboard  771088a6f847c901f59c14e32225410a4b174d2e9eb026928acba41e7dc2f658ad09d054846a06efb262fe198c1ddfbaf1014a61257856014c6ca2498747cc0e)
set(QT_HASH_qt5-wayland          b47a3358bc37f52dde0839940431e8049abfaa827722e6d57362b07547c35fe9fb422d28fd28c69a13f5773c24efc3eeea1e584372737a0151ed94bf4c5b9980)
set(QT_HASH_qt5-webchannel       499e67d83d08476ee4b9da6c331a459b595ace3c6a7cbc7e1d8660b551cc0a87ef50e5d9d69a7783614c67db46df7802fdb4a2e79edb76012f6d26ceb3417eeb)
set(QT_HASH_qt5-webengine        cebda17b9023348c85e9397fce5ad0f8ee16cfe821b8e79cea7ce92f7bb00e7fe59594107ac9f9411df1bb2e675eb6ecbfe3366df67a05b45fe12ead97cdc76c)
set(QT_HASH_qt5-webglplugin      cbbab9ac54b38dfaa3f492ded0796ea942c24534d001980f71f5d1f35786c7c455de8a187608caa9ec4d9d1a0ed7dba19dc03de00414ac69efec48ff8c69f2ed)
set(QT_HASH_qt5-websockets       644182da57f0b3b77a434abcfe67731178cb0e62bc8743c85bda24e137f2fe686728b10a73f5030d8f357cc616c2e681de15598bedf4d01d4cb705482235bbcd)
set(QT_HASH_qt5-webview          7a741b3bb79b9aeaca05130ad8346a2dc704a203654754c73953d37a88d4c923375c3db44ddc22ea0b9856abedb7daf99e89d4f387014dfe8fbb31aaea6a7e38)
set(QT_HASH_qt5-winextras        a387da6da092267545c78caff54dd95958be1840913f8ebe66320d35d8328ced2bb2b0cc85f0e2f7138f937fd828141e573d45c805e2da47c7b050bf961f2fb5)
set(QT_HASH_qt5-x11extras        e1135ed8d1800d59f039e82ce33f3c84ac87df29ad61a60b2a0d25d78e4e38e2e1800406513d45abd3af79a2821698ca5d71161d6ad1f3b05deb3fad7599f654)
set(QT_HASH_qt5-xmlpatterns      73326aaa7fef65e00e3a585952d06841bba0905c1cb9a753b6c636e01fd7bf8cc66dadbe962ed962523f234c7461463ed893b045a7e3c2f0fbfb5e9aecf7a802)

if(QT_UPDATE_VERSION)
    message(STATUS "Running Qt in automatic version port update mode!")
    set(_VCPKG_INTERNAL_NO_HASH_CHECK 1)
    if("${PORT}" MATCHES "qt5-base")
        function(update_qt_version_in_manifest _port_name)
            set(_current_control "${VCPKG_ROOT_DIR}/ports/${_port_name}/vcpkg.json")
            file(READ ${_current_control} _control_contents)
            #message(STATUS "Before: \n${_control_contents}")
            string(REGEX REPLACE "\"version.*\": \"[0-9]+\.[0-9]+\.[0-9]+\",\n" "\"version\": \"${QT_MAJOR_MINOR_VER}.${QT_PATCH_VER}\",\n" _control_contents "${_control_contents}")
            string(REGEX REPLACE "\n  \"port-version\": [0-9]+," "" _control_contents "${_control_contents}")
            #message(STATUS "After: \n${_control_contents}")
            file(WRITE ${_current_control} "${_control_contents}")
            configure_file("${_current_control}" "${_current_control}" @ONLY NEWLINE_STYLE LF)
        endfunction()

        update_qt_version_in_manifest("qt5")
        foreach(_current_qt_port_basename ${QT_PORT_LIST})
            update_qt_version_in_manifest("qt5-${_current_qt_port_basename}")
        endforeach()
    endif()
endif()
