struct cpuinfo_mock_file filesystem[] = {
	{
		.path = "/proc/cpuinfo",
		.size = 1121,
		.content = "Processor\t: ARMv7 Processor rev 5 (v7l)\n"
			   "processor\t: 0\n"
			   "model name\t: ARMv7 Processor rev 5 (v7l)\n"
			   "BogoMIPS\t: 2603.41\n"
			   "Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 \n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: 7\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xc07\n"
			   "CPU revision\t: 5\n"
			   "\n"
			   "processor\t: 1\n"
			   "model name\t: ARMv7 Processor rev 5 (v7l)\n"
			   "BogoMIPS\t: 2609.97\n"
			   "Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 \n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: 7\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xc07\n"
			   "CPU revision\t: 5\n"
			   "\n"
			   "processor\t: 2\n"
			   "model name\t: ARMv7 Processor rev 5 (v7l)\n"
			   "BogoMIPS\t: 2609.97\n"
			   "Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 \n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: 7\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xc07\n"
			   "CPU revision\t: 5\n"
			   "\n"
			   "processor\t: 3\n"
			   "model name\t: ARMv7 Processor rev 5 (v7l)\n"
			   "BogoMIPS\t: 2609.97\n"
			   "Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 \n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: 7\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xc07\n"
			   "CPU revision\t: 5\n"
			   "\n"
			   "Hardware\t: sc8830\n"
			   "Revision\t: 0004\n"
			   "Serial\t\t: 4200ddccd2da6300\n",
	},
	{
		.path = "/system/build.prop",
		.size = 5350,
		.content =
			"\n"
			"# begin build properties\n"
			"# autogenerated by buildinfo.sh\n"
			"ro.build.id=LMY48B\n"
			"ro.build.display.id=LMY48B.G531HUBU0APE2\n"
			"ro.build.version.incremental=G531HUBU0APE2\n"
			"ro.build.version.sdk=22\n"
			"ro.build.version.codename=REL\n"
			"ro.build.version.all_codenames=REL\n"
			"ro.build.version.release=5.1.1\n"
			"ro.build.version.security_patch=2016-06-01\n"
			"ro.build.version.base_os=\n"
			"ro.build.date=Tue May 31 14:49:04 KST 2016\n"
			"ro.build.date.utc=1464673744\n"
			"ro.build.type=user\n"
			"ro.build.user=dpi\n"
			"ro.build.host=SWHC3703\n"
			"ro.build.tags=release-keys\n"
			"ro.build.flavor=grandprimeve3gub-user\n"
			"ro.product.model=SM-G531H\n"
			"ro.product.brand=samsung\n"
			"ro.product.name=grandprimeve3gub\n"
			"ro.product.device=grandprimeve3g\n"
			"ro.product.board=SC7730SE\n"
			"# ro.product.cpu.abi and ro.product.cpu.abi2 are obsolete,\n"
			"# use ro.product.cpu.abilist instead.\n"
			"ro.product.cpu.abi=armeabi-v7a\n"
			"ro.product.cpu.abi2=armeabi\n"
			"ro.product.cpu.abilist=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist32=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist64=\n"
			"ro.product.manufacturer=samsung\n"
			"ro.product.locale.language=en\n"
			"ro.product.locale.region=US\n"
			"ro.wifi.channels=\n"
			"ro.board.platform=sc8830\n"
			"# ro.build.product is obsolete; use ro.product.device\n"
			"ro.build.product=grandprimeve3g\n"
			"# Do not try to parse description, fingerprint, or thumbprint\n"
			"ro.build.description=grandprimeve3gub-user 5.1.1 LMY48B G531HUBU0APE2 release-keys\n"
			"ro.build.fingerprint=samsung/grandprimeve3gub/grandprimeve3g:5.1.1/LMY48B/G531HUBU0APE2:user/release-keys\n"
			"ro.build.characteristics=default\n"
			"# Samsung Specific Properties\n"
			"ro.build.PDA=G531HUBU0APE2\n"
			"ro.build.hidden_ver=G531HUBU0APE2\n"
			"ro.config.rm_preload_enabled=0\n"
			"ro.build.changelist=1045439\n"
			"ro.product_ship=true\n"
			"ro.chipname=SC7730SE\n"
			"# end build properties\n"
			"#\n"
			"# from device/samsung/grandprimeve3g/system.prop\n"
			"#\n"
			"\n"
			"ro.sf.lcd_density=240\n"
			"ro.sf.lcd_width=154\n"
			"ro.sf.lcd_height=90\n"
			"ro.opengles.version=131072\n"
			"ro.product.hardware=TSHARK2TABE_V1.0.0\n"
			"\n"
			"debug.hwui.render_dirty_regions=false\n"
			"\n"
			"# Bluetooth OPP low speed for save power\n"
			"debug.bt.lowspeed=true\n"
			"\n"
			"persist.ttydev=ttyVUART0\n"
			"\n"
			"# delay for ConnectivityChange broadcast (ms)\n"
			"conn.connectivity_change_delay = 0\n"
			"\n"
			"ro.product.partitionpath=/dev/block/platform/sdio_emmc/by-name/\n"
			"\n"
			"# Default ecclist\n"
			"ro.ril.ecclist=112,911,#911,*911\n"
			"\n"
			"persist.modem.w.enable=1\n"
			"persist.modem.w.nvp=w\n"
			"ro.modem.w.dev=/proc/cpw/\n"
			"ro.modem.w.tty=/dev/stty_w\n"
			"ro.modem.w.eth=rmnet\n"
			"ro.modem.w.snd=1\n"
			"ro.modem.w.diag=/dev/slog_w\n"
			"ro.modem.w.loop=/dev/spipe_w0\n"
			"ro.modem.w.nv=/dev/spipe_w1\n"
			"ro.modem.w.assert=/dev/spipe_w2\n"
			"ro.modem.w.vbc=/dev/spipe_w6\n"
			"ro.modem.w.id=0\n"
			"ro.modem.w.fixnv_size=0x40000\n"
			"ro.modem.w.runnv_size=0x60000\n"
			"\n"
			"ro.modem.wcn.enable=1\n"
			"ro.modem.wcn.dev=/dev/cpwcn\n"
			"ro.modem.wcn.tty=/deiv/stty_wcn\n"
			"ro.modem.wcn.diag=/dev/slog_wcn\n"
			"ro.modem.wcn.assert=/dev/spipe_wcn2\n"
			"ro.modem.wcn.id=1\n"
			"ro.modem.wcn.count=1\n"
			"ro.digital.fm.support=1\n"
			"\n"
			"persist.sys.engpc.disable=0\n"
			"\n"
			"ro.config.ksm.support=true\n"
			"\n"
			"#zram config\n"
			"#ro.config.zram.support=true\n"
			"#ro.board_ram_size=mid\n"
			"\n"
			"# SPRD: add low cost low memory\n"
			"ro.config.low_ram=true\n"
			"\n"
			"#if our product not support drm,set as false\n"
			"drm.service.enabled=true\n"
			"\n"
			"# hotspot development\n"
			"ro.hotspot.enabled=1\n"
			"\n"
			"# this product does not support bt and softap coexist\n"
			"ro.btwifisoftap.coexist=false\n"
			"# SPRD: add support hwrotation\n"
			"ro.sf.hwrotation=0\n"
			"\n"
			"# System property for storage_preload\n"
			"persist.sys.storage_preload=1\n"
			"\n"
			"# SAMP_SPCM\n"
			"sys.config.samp_spcm_enable=true\n"
			"sys.config.spcm_db_enable=true\n"
			"sys.config.spcm_db_launcher=true\n"
			"sys.config.spcm_preload_enable=true\n"
			"\n"
			"#\n"
			"# ADDITIONAL_BUILD_PROPERTIES\n"
			"#\n"
			"ro.com.android.dateformat=MM-dd-yyyy\n"
			"ro.carrier=unknown\n"
			"ro.com.google.clientidbase=android-samsung\n"
			"ro.security.icd.flagmode=single\n"
			"drm.service.enabled=true\n"
			"ro.modem.wcn.enable=1\n"
			"ro.modem.wcn.dev=/dev/cpwcn\n"
			"ro.modem.wcn.tty=/deiv/stty_wcn\n"
			"ro.modem.wcn.diag=/dev/slog_wcn\n"
			"ro.modem.wcn.assert=/dev/spipe_wcn2\n"
			"ro.modem.wcn.id=1\n"
			"ro.modem.wcn.count=1\n"
			"camera.disable_zsl_mode=1\n"
			"ro.digital.fm.support=1\n"
			"persist.sys.sprd.modemreset=1\n"
			"ro.adb.secure=1\n"
			"persist.sys.sprd.wcnreset=1\n"
			"ro.storage.flash_type=2\n"
			"persist.storage.type=2\n"
			"sys.tempsd.enable=0\n"
			"sys.internal.emulated=1\n"
			"ro.storage.install2internal=0\n"
			"keyguard.no_require_sim=true\n"
			"ro.com.android.dataroaming=false\n"
			"ro.msms.phone_count=2\n"
			"persist.msms.phone_count=2\n"
			"persist.msms.phone_default=0\n"
			"ro.modem.w.count=2\n"
			"persist.sys.modem.diag=,gser\n"
			"sys.usb.gser.count=4\n"
			"lmk.autocalc=false\n"
			"dalvik.vm.heapstartsize=8m\n"
			"dalvik.vm.heapgrowthlimit=96m\n"
			"dalvik.vm.heapsize=256m\n"
			"dalvik.vm.heaptargetutilization=0.75\n"
			"dalvik.vm.heapminfree=2m\n"
			"dalvik.vm.heapmaxfree=8m\n"
			"ro.build.scafe=americano\n"
			"ro.build.scafe.size=short\n"
			"ro.build.scafe.cream=white\n"
			"ro.build.scafe.shot=single\n"
			"ro.sec.fle.encryption=true\n"
			"ro.error.receiver.default=com.samsung.receiver.error\n"
			"sys.config.samp_ppm_enable=false\n"
			"ro.config.oomminfree=49152,61440,73728,86016,98304,122880\n"
			"ro.config.sdha_default_margin=25\n"
			"ro.config.is_lowend_samp=true\n"
			"ro.multisim.simslotcount=2\n"
			"ro.config.ringtone_2=Basic_Bell.ogg\n"
			"ro.config.notification_sound_2=S_Charming_Bell.ogg\n"
			"ro.config.ringtone=Over_the_horizon.ogg\n"
			"ro.config.notification_sound=S_Whistle.ogg\n"
			"ro.config.alarm_alert=Morning_flower.ogg\n"
			"ro.config.media_sound=Media_preview_Touch_the_light.ogg\n"
			"ro.frp.pst=/dev/block/persistent\n"
			"ro.com.google.gmsversion=5.1_r3\n"
			"ro.setupwizard.mode=DISABLED\n"
			"persist.sys.dalvik.vm.lib.2=libart.so\n"
			"dalvik.vm.isa.arm.features=div\n"
			"ro.build.selinux=1\n"
			"ro.config.knox=v00\n"
			"ro.kernel.qemu=0\n"
			"net.bt.name=Android\n"
			"dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			"\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 1,
		.content = "\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/all_time_in_state",
		.size = 130,
		.content = "freq\t\tcpu0\t\tcpu1\t\tcpu2\t\tcpu3\t\t\n"
			   "768000\t\t0\t\t0\t\t0\t\t0\t\t\n"
			   "1000000\t\t0\t\t0\t\t0\t\t0\t\t\n"
			   "1200000\t\t0\t\t0\t\t0\t\t0\t\t\n"
			   "1300000\t\t2191\t\t2191\t\t2191\t\t2191\t\t\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_driver",
		.size = 11,
		.content = "sc_cpuidle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_governor_ro",
		.size = 5,
		.content = "menu\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "768000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 6,
		.content = "50000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 32,
		.content = "1300000 1200000 1000000 768000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 25,
		.content = "interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 5,
		.content = "sprd\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "768000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 42,
		.content = "1300000 2275\n"
			   "1200000 0\n"
			   "1000000 0\n"
			   "768000 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 3,
		.content = "15\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "768000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_transition_latency",
		.size = 6,
		.content = "50000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_frequencies",
		.size = 32,
		.content = "1300000 1200000 1000000 768000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_governors",
		.size = 25,
		.content = "interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_driver",
		.size = 5,
		.content = "sprd\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "768000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/time_in_state",
		.size = 42,
		.content = "1300000 2506\n"
			   "1200000 0\n"
			   "1000000 0\n"
			   "768000 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/total_trans",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/physical_package_id",
		.size = 3,
		.content = "15\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "768000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_transition_latency",
		.size = 6,
		.content = "50000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_frequencies",
		.size = 32,
		.content = "1300000 1200000 1000000 768000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_governors",
		.size = 25,
		.content = "interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_driver",
		.size = 5,
		.content = "sprd\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "768000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/time_in_state",
		.size = 42,
		.content = "1300000 2707\n"
			   "1200000 0\n"
			   "1000000 0\n"
			   "768000 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/total_trans",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/physical_package_id",
		.size = 3,
		.content = "15\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_id",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings_list",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings",
		.size = 2,
		.content = "4\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "768000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_transition_latency",
		.size = 6,
		.content = "50000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_frequencies",
		.size = 32,
		.content = "1300000 1200000 1000000 768000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_governors",
		.size = 25,
		.content = "interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1300000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_driver",
		.size = 5,
		.content = "sprd\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "768000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/time_in_state",
		.size = 42,
		.content = "1300000 2902\n"
			   "1200000 0\n"
			   "1000000 0\n"
			   "768000 0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/total_trans",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/physical_package_id",
		.size = 3,
		.content = "15\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings",
		.size = 2,
		.content = "f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_id",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings_list",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings",
		.size = 2,
		.content = "8\n",
	},
	{NULL},
};

#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "audioflinger.bootsnd",
		.value = "0",
	},
	{
		.key = "boot.sfbootcomplete",
		.value = "0",
	},
	{
		.key = "camera.disable_zsl_mode",
		.value = "1",
	},
	{
		.key = "conn.connectivity_change_delay",
		.value = "0",
	},
	{
		.key = "dalvik.vm.dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.dex2oat-Xmx",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "96m",
	},
	{
		.key = "dalvik.vm.heapmaxfree",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heapminfree",
		.value = "2m",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "256m",
	},
	{
		.key = "dalvik.vm.heapstartsize",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heaptargetutilization",
		.value = "0.75",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xmx",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.isa.arm.features",
		.value = "div",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "debug.bt.lowspeed",
		.value = "true",
	},
	{
		.key = "debug.force_rtl",
		.value = "0",
	},
	{
		.key = "debug.hwui.render_dirty_regions",
		.value = "false",
	},
	{
		.key = "debug.sf.layerdump",
		.value = "0",
	},
	{
		.key = "dev.MDPLimitCondition",
		.value = "0",
	},
	{
		.key = "dev.bootcomplete",
		.value = "1",
	},
	{
		.key = "dev.kies.sommode",
		.value = "TRUE",
	},
	{
		.key = "dev.kiessupport",
		.value = "TRUE",
	},
	{
		.key = "dev.ssrm.appsync3p",
		.value = "true",
	},
	{
		.key = "drm.service.enabled",
		.value = "true",
	},
	{
		.key = "gsm.current.phone-type",
		.value = "1",
	},
	{
		.key = "gsm.network.type",
		.value = "Unknown",
	},
	{
		.key = "gsm.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.operator.iso-country",
		.value = "",
	},
	{
		.key = "gsm.operator.isroaming",
		.value = "false",
	},
	{
		.key = "gsm.operator.numeric",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.iso-country",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.numeric",
		.value = "",
	},
	{
		.key = "gsm.sim.state",
		.value = "ABSENT",
	},
	{
		.key = "gsm.version.baseband",
		.value = "G531HUBU0APF2",
	},
	{
		.key = "gsm.version.ril-impl",
		.value = "android reference-ril 1.0",
	},
	{
		.key = "init.svc.BCS-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.DR-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.SMD-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.apanic_rename",
		.value = "stopped",
	},
	{
		.key = "init.svc.at_distributor",
		.value = "running",
	},
	{
		.key = "init.svc.auditd",
		.value = "running",
	},
	{
		.key = "init.svc.batterysrv",
		.value = "running",
	},
	{
		.key = "init.svc.bootanim",
		.value = "stopped",
	},
	{
		.key = "init.svc.bootchecker",
		.value = "running",
	},
	{
		.key = "init.svc.cmd_services",
		.value = "stopped",
	},
	{
		.key = "init.svc.copy_cp_imgs",
		.value = "stopped",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.drsd",
		.value = "running",
	},
	{
		.key = "init.svc.engpcclientw",
		.value = "running",
	},
	{
		.key = "init.svc.flash_recovery",
		.value = "stopped",
	},
	{
		.key = "init.svc.gpsd",
		.value = "running",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.lmkd",
		.value = "running",
	},
	{
		.key = "init.svc.logd",
		.value = "running",
	},
	{
		.key = "init.svc.macloader",
		.value = "stopped",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.mobex-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.modem_control",
		.value = "stopped",
	},
	{
		.key = "init.svc.modemd",
		.value = "running",
	},
	{
		.key = "init.svc.napa_ts",
		.value = "stopped",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.nvitemd_w",
		.value = "running",
	},
	{
		.key = "init.svc.phoneserver_w",
		.value = "running",
	},
	{
		.key = "init.svc.powersnd",
		.value = "stopped",
	},
	{
		.key = "init.svc.prepare_param",
		.value = "stopped",
	},
	{
		.key = "init.svc.refnotify_w",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.scs",
		.value = "stopped",
	},
	{
		.key = "init.svc.sdcard",
		.value = "stopped",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.slog",
		.value = "running",
	},
	{
		.key = "init.svc.smd_symlink",
		.value = "stopped",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.swapon",
		.value = "stopped",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "installd.sdcard_manipulate_done",
		.value = "1",
	},
	{
		.key = "keyguard.no_require_sim",
		.value = "true",
	},
	{
		.key = "lmk.autocalc",
		.value = "false",
	},
	{
		.key = "logd.auditd",
		.value = "false",
	},
	{
		.key = "media.dump.path",
		.value = "/data/local/media/",
	},
	{
		.key = "media.dump.switch",
		.value = "0x0",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.qtaguid_enabled",
	},
	{
		.key = "net.hostname",
		.value = "android-c7c14ac6539e9f14",
	},
	{
		.key = "net.knoxscep.version",
		.value = "2.0.1",
	},
	{
		.key = "net.knoxsso.version",
		.value = "2.4.0",
	},
	{
		.key = "net.knoxvpn.version",
		.value = "2.2.0",
	},
	{
		.key = "net.qtaguid_enabled",
		.value = "1",
	},
	{
		.key = "net.tcp.default_init_rwnd",
		.value = "60",
	},
	{
		.key = "persist.audio.allsoundmute",
		.value = "0",
	},
	{
		.key = "persist.audio.globaleffect",
		.value = "0",
	},
	{
		.key = "persist.audio.headsetsysvolume",
		.value = "9",
	},
	{
		.key = "persist.audio.hphonesysvolume",
		.value = "9",
	},
	{
		.key = "persist.audio.mpseek",
		.value = "0",
	},
	{
		.key = "persist.audio.mysound",
		.value = "0",
	},
	{
		.key = "persist.audio.ringermode",
		.value = "2",
	},
	{
		.key = "persist.audio.soundalivefxsec",
		.value = "1",
	},
	{
		.key = "persist.audio.stereospeaker",
		.value = "0",
	},
	{
		.key = "persist.audio.sysvolume",
		.value = "9",
	},
	{
		.key = "persist.audio.uhqa",
		.value = "0",
	},
	{
		.key = "persist.bluetooth_fw_ver",
		.value = "BCM43430A1_V0025.0070.hcd",
	},
	{
		.key = "persist.logd.size",
		.value = "",
	},
	{
		.key = "persist.modem.w.enable",
		.value = "1",
	},
	{
		.key = "persist.modem.w.nvp",
		.value = "w",
	},
	{
		.key = "persist.msms.phone_count",
		.value = "2",
	},
	{
		.key = "persist.msms.phone_default",
		.value = "0",
	},
	{
		.key = "persist.radio.gprsattachmode",
		.value = "1",
	},
	{
		.key = "persist.radio.initphone-type",
		.value = "1",
	},
	{
		.key = "persist.radio.plmnname_1",
		.value = "",
	},
	{
		.key = "persist.radio.plmnname_2",
		.value = "",
	},
	{
		.key = "persist.radio.singlesim.network",
		.value = "1",
	},
	{
		.key = "persist.security.ams.enforcing",
		.value = "1",
	},
	{
		.key = "persist.service.bdroid.version",
		.value = "4.1",
	},
	{
		.key = "persist.storage.type",
		.value = "2",
	},
	{
		.key = "persist.sys.cmdservice.enable",
		.value = "disable",
	},
	{
		.key = "persist.sys.country",
		.value = "US",
	},
	{
		.key = "persist.sys.dalvik.vm.lib.2",
		.value = "libart.so",
	},
	{
		.key = "persist.sys.drs.date",
		.value = "Tue May 31 14:49:04 KST 2016",
	},
	{
		.key = "persist.sys.engpc.disable",
		.value = "0",
	},
	{
		.key = "persist.sys.language",
		.value = "en",
	},
	{
		.key = "persist.sys.localevar",
		.value = "",
	},
	{
		.key = "persist.sys.media.use-awesome",
		.value = "true",
	},
	{
		.key = "persist.sys.modem.diag",
		.value = ",gser",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.setupwizard",
		.value = "FINISH",
	},
	{
		.key = "persist.sys.sprd.modemreset",
		.value = "1",
	},
	{
		.key = "persist.sys.sprd.wcnreset",
		.value = "1",
	},
	{
		.key = "persist.sys.ssrm_unbox_cnt",
		.value = "2",
	},
	{
		.key = "persist.sys.storage_preload",
		.value = "2",
	},
	{
		.key = "persist.sys.timezone",
		.value = "Pacific/Majuro",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "ptp,adb",
	},
	{
		.key = "persist.ttydev",
		.value = "ttyVUART0",
	},
	{
		.key = "ril.ICC_TYPE",
		.value = "0",
	},
	{
		.key = "ril.MSIMM",
		.value = "0",
	},
	{
		.key = "ril.RildInit",
		.value = "1",
	},
	{
		.key = "ril.SIMSLOT_EXCHANGED",
		.value = "0",
	},
	{
		.key = "ril.atd_status",
		.value = "1_0_0",
	},
	{
		.key = "ril.cp_ver",
		.value = "G531HUBU0APF2",
	},
	{
		.key = "ril.deviceOffRes",
		.value = "1",
	},
	{
		.key = "ril.ecclist00",
		.value = "112,911,999,000,08,110,118,119",
	},
	{
		.key = "ril.hw_ver",
		.value = "MP 0.300",
	},
	{
		.key = "ril.modem.board",
		.value = "SC7730SE",
	},
	{
		.key = "ril.product_code",
		.value = "SM-G531HZDATPA",
	},
	{
		.key = "ril.rfcal_date",
		.value = "20160920",
	},
	{
		.key = "ril.serialnumber",
		.value = "R51H90R1BPX",
	},
	{
		.key = "ril.servicestate",
		.value = "3",
	},
	{
		.key = "ril.subinfo",
		.value = "0:2147483643",
	},
	{
		.key = "ril.sw_ver",
		.value = "G531HUBU0APF2",
	},
	{
		.key = "ril.valid_certsig1",
		.value = "true",
	},
	{
		.key = "ril.valid_certsig2",
		.value = "false",
	},
	{
		.key = "ril.w.sim.power",
		.value = "1",
	},
	{
		.key = "ro.SecEDS.enable",
		.value = "false",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.baseband",
		.value = "unknown",
	},
	{
		.key = "ro.board.platform",
		.value = "sc8830",
	},
	{
		.key = "ro.boot.bootloader",
		.value = "G531HUBU0APE2",
	},
	{
		.key = "ro.boot.debug_level",
		.value = "0x4f4c",
	},
	{
		.key = "ro.boot.emmc_checksum",
		.value = "0",
	},
	{
		.key = "ro.boot.serialno",
		.value = "4200ddccd2da6300",
	},
	{
		.key = "ro.bootloader",
		.value = "G531HUBU0APE2",
	},
	{
		.key = "ro.bootmode",
		.value = "unknown",
	},
	{
		.key = "ro.bt.bdaddr_path",
		.value = "/efs/bluetooth/bt_addr",
	},
	{
		.key = "ro.btwifisoftap.coexist",
		.value = "false",
	},
	{
		.key = "ro.build.PDA",
		.value = "G531HUBU0APE2",
	},
	{
		.key = "ro.build.changelist",
		.value = "1045439",
	},
	{
		.key = "ro.build.characteristics",
		.value = "default",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1464673744",
	},
	{
		.key = "ro.build.date",
		.value = "Tue May 31 14:49:04 KST 2016",
	},
	{
		.key = "ro.build.description",
		.value = "grandprimeve3gub-user 5.1.1 LMY48B G531HUBU0APE2 release-keys",
	},
	{
		.key = "ro.build.display.id",
		.value = "LMY48B.G531HUBU0APE2",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "samsung/grandprimeve3gub/grandprimeve3g:5.1.1/LMY48B/G531HUBU0APE2:user/release-keys",
	},
	{
		.key = "ro.build.flavor",
		.value = "grandprimeve3gub-user",
	},
	{
		.key = "ro.build.hidden_ver",
		.value = "G531HUBU0APE2",
	},
	{
		.key = "ro.build.host",
		.value = "SWHC3703",
	},
	{
		.key = "ro.build.id",
		.value = "LMY48B",
	},
	{
		.key = "ro.build.product",
		.value = "grandprimeve3g",
	},
	{
		.key = "ro.build.scafe.cream",
		.value = "white",
	},
	{
		.key = "ro.build.scafe.shot",
		.value = "single",
	},
	{
		.key = "ro.build.scafe.size",
		.value = "short",
	},
	{
		.key = "ro.build.scafe",
		.value = "americano",
	},
	{
		.key = "ro.build.selinux.enforce",
		.value = "1",
	},
	{
		.key = "ro.build.selinux",
		.value = "1",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "dpi",
	},
	{
		.key = "ro.build.version.all_codenames",
		.value = "REL",
	},
	{
		.key = "ro.build.version.base_os",
		.value = "",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "G531HUBU0APE2",
	},
	{
		.key = "ro.build.version.release",
		.value = "5.1.1",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "22",
	},
	{
		.key = "ro.build.version.security_patch",
		.value = "2016-06-01",
	},
	{
		.key = "ro.carrier",
		.value = "unknown",
	},
	{
		.key = "ro.chipname",
		.value = "SC7730SE",
	},
	{
		.key = "ro.com.android.dataroaming",
		.value = "false",
	},
	{
		.key = "ro.com.android.dateformat",
		.value = "MM-dd-yyyy",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-samsung",
	},
	{
		.key = "ro.com.google.gmsversion",
		.value = "5.1_r3",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "Morning_flower.ogg",
	},
	{
		.key = "ro.config.is_lowend_samp",
		.value = "true",
	},
	{
		.key = "ro.config.knox",
		.value = "v00",
	},
	{
		.key = "ro.config.ksm.support",
		.value = "true",
	},
	{
		.key = "ro.config.low_ram",
		.value = "true",
	},
	{
		.key = "ro.config.media_sound",
		.value = "Media_preview_Touch_the_light.ogg",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "S_Whistle.ogg",
	},
	{
		.key = "ro.config.notification_sound_2",
		.value = "S_Charming_Bell.ogg",
	},
	{
		.key = "ro.config.oomminfree",
		.value = "49152,61440,73728,86016,98304,122880",
	},
	{
		.key = "ro.config.ringtone",
		.value = "Over_the_horizon.ogg",
	},
	{
		.key = "ro.config.ringtone_2",
		.value = "Basic_Bell.ogg",
	},
	{
		.key = "ro.config.rm_preload_enabled",
		.value = "0",
	},
	{
		.key = "ro.config.sdha_default_margin",
		.value = "25",
	},
	{
		.key = "ro.crypto.fuse_sdcard",
		.value = "true",
	},
	{
		.key = "ro.crypto.state",
		.value = "unencrypted",
	},
	{
		.key = "ro.csc.country_code",
		.value = "PANAMA",
	},
	{
		.key = "ro.csc.countryiso_code",
		.value = "PA",
	},
	{
		.key = "ro.csc.sales_code",
		.value = "TPA",
	},
	{
		.key = "ro.dalvik.vm.native.bridge",
		.value = "0",
	},
	{
		.key = "ro.debug_level",
		.value = "0x4f4c",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.digital.fm.support",
		.value = "1",
	},
	{
		.key = "ro.error.receiver.default",
		.value = "com.samsung.receiver.error",
	},
	{
		.key = "ro.factorytest",
		.value = "0",
	},
	{
		.key = "ro.frp.pst",
		.value = "/dev/block/persistent",
	},
	{
		.key = "ro.hardware",
		.value = "sc8830",
	},
	{
		.key = "ro.hotspot.enabled",
		.value = "1",
	},
	{
		.key = "ro.kernel.qemu",
		.value = "0",
	},
	{
		.key = "ro.modem.w.assert",
		.value = "/dev/spipe_w2",
	},
	{
		.key = "ro.modem.w.count",
		.value = "1",
	},
	{
		.key = "ro.modem.w.dev",
		.value = "/proc/cpw/",
	},
	{
		.key = "ro.modem.w.diag",
		.value = "/dev/slog_w",
	},
	{
		.key = "ro.modem.w.eth",
		.value = "rmnet",
	},
	{
		.key = "ro.modem.w.fixnv_size",
		.value = "0x40000",
	},
	{
		.key = "ro.modem.w.id",
		.value = "0",
	},
	{
		.key = "ro.modem.w.loop",
		.value = "/dev/spipe_w0",
	},
	{
		.key = "ro.modem.w.nv",
		.value = "/dev/spipe_w1",
	},
	{
		.key = "ro.modem.w.runnv_size",
		.value = "0x60000",
	},
	{
		.key = "ro.modem.w.snd",
		.value = "1",
	},
	{
		.key = "ro.modem.w.tty",
		.value = "/dev/stty_w",
	},
	{
		.key = "ro.modem.w.vbc",
		.value = "/dev/spipe_w6",
	},
	{
		.key = "ro.modem.wcn.assert",
		.value = "/dev/spipe_wcn2",
	},
	{
		.key = "ro.modem.wcn.count",
		.value = "1",
	},
	{
		.key = "ro.modem.wcn.dev",
		.value = "/dev/cpwcn",
	},
	{
		.key = "ro.modem.wcn.diag",
		.value = "/dev/slog_wcn",
	},
	{
		.key = "ro.modem.wcn.enable",
		.value = "1",
	},
	{
		.key = "ro.modem.wcn.id",
		.value = "1",
	},
	{
		.key = "ro.modem.wcn.tty",
		.value = "/deiv/stty_wcn",
	},
	{
		.key = "ro.msms.phone_count",
		.value = "1",
	},
	{
		.key = "ro.multisim.simslotcount",
		.value = "1",
	},
	{
		.key = "ro.opengles.version",
		.value = "131072",
	},
	{
		.key = "ro.product.board",
		.value = "SC7730SE",
	},
	{
		.key = "ro.product.brand",
		.value = "samsung",
	},
	{
		.key = "ro.product.cpu.abi2",
		.value = "armeabi",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "armeabi-v7a",
	},
	{
		.key = "ro.product.cpu.abilist32",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist64",
		.value = "",
	},
	{
		.key = "ro.product.cpu.abilist",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.device",
		.value = "grandprimeve3g",
	},
	{
		.key = "ro.product.hardware",
		.value = "TSHARK2TABE_V1.0.0",
	},
	{
		.key = "ro.product.locale.language",
		.value = "en",
	},
	{
		.key = "ro.product.locale.region",
		.value = "US",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "samsung",
	},
	{
		.key = "ro.product.model",
		.value = "SM-G531H",
	},
	{
		.key = "ro.product.name",
		.value = "grandprimeve3gub",
	},
	{
		.key = "ro.product.partitionpath",
		.value = "/dev/block/platform/sdio_emmc/by-name/",
	},
	{
		.key = "ro.product_ship",
		.value = "true",
	},
	{
		.key = "ro.radio.noril",
		.value = "no",
	},
	{
		.key = "ro.revision",
		.value = "4",
	},
	{
		.key = "ro.ril.ecclist",
		.value = "112,911,#911,*911",
	},
	{
		.key = "ro.sec.fle.encryption",
		.value = "true",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.security.icd.flagmode",
		.value = "single",
	},
	{
		.key = "ro.serialno",
		.value = "4200ddccd2da6300",
	},
	{
		.key = "ro.setupwizard.mode",
		.value = "DISABLED",
	},
	{
		.key = "ro.sf.hwrotation",
		.value = "0",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "240",
	},
	{
		.key = "ro.sf.lcd_height",
		.value = "90",
	},
	{
		.key = "ro.sf.lcd_width",
		.value = "154",
	},
	{
		.key = "ro.storage.flash_type",
		.value = "2",
	},
	{
		.key = "ro.storage.install2internal",
		.value = "0",
	},
	{
		.key = "ro.telephony.call_ring.multiple",
		.value = "0",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "ro.zygote",
		.value = "zygote32",
	},
	{
		.key = "selinux.policy_version",
		.value = "SEPF_SM-G531H_5.1.1_0048",
	},
	{
		.key = "selinux.reload_policy",
		.value = "1",
	},
	{
		.key = "selinux.sec.restorecon",
		.value = "1",
	},
	{
		.key = "service.bootanim.exit",
		.value = "0",
	},
	{
		.key = "service.brcm.fm.set_blndmute",
		.value = "1",
	},
	{
		.key = "service.brcm.fm.start_mute",
		.value = "8",
	},
	{
		.key = "service.brcm.fm.start_snr",
		.value = "37",
	},
	{
		.key = "service.media.powersnd",
		.value = "1",
	},
	{
		.key = "slog.reload",
		.value = "0",
	},
	{
		.key = "status.battery.level",
		.value = "10",
	},
	{
		.key = "status.battery.level_raw",
		.value = "100",
	},
	{
		.key = "status.battery.level_scale",
		.value = "10",
	},
	{
		.key = "status.battery.state",
		.value = "Slow",
	},
	{
		.key = "storage.mmc.size",
		.value = "7818182656",
	},
	{
		.key = "storage.preload.complete",
		.value = "1",
	},
	{
		.key = "sys.boot_completed",
		.value = "1",
	},
	{
		.key = "sys.config.samp_ppm_enable",
		.value = "false",
	},
	{
		.key = "sys.config.samp_spcm_enable",
		.value = "true",
	},
	{
		.key = "sys.config.spcm_db_enable",
		.value = "true",
	},
	{
		.key = "sys.config.spcm_db_launcher",
		.value = "true",
	},
	{
		.key = "sys.config.spcm_preload_enable",
		.value = "true",
	},
	{
		.key = "sys.enterprise.billing.version",
		.value = "1.1.0",
	},
	{
		.key = "sys.internal.emulated",
		.value = "1",
	},
	{
		.key = "sys.onemodem.start.enable",
		.value = "1",
	},
	{
		.key = "sys.settings_system_version",
		.value = "7",
	},
	{
		.key = "sys.symlink.umts_router",
		.value = "/dev/pts/7  /dev/umts_router",
	},
	{
		.key = "sys.sysctl.extra_free_kbytes",
		.value = "6075",
	},
	{
		.key = "sys.tempsd.enable",
		.value = "0",
	},
	{
		.key = "sys.usb.config",
		.value = "ptp,adb",
	},
	{
		.key = "sys.usb.gser.count",
		.value = "4",
	},
	{
		.key = "sys.usb.state",
		.value = "ptp,adb",
	},
	{
		.key = "vold.pfe",
		.value = "deactivated",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wlan.driver.status",
		.value = "unloaded",
	},
	{
		.key = "wlan.wfd.status",
		.value = "disconnected",
	},
	{NULL},
};
#endif /* __ANDROID__ */
