import { ReadonlyPartialJSONValue, Token } from '@lumino/coreutils';
import { IDataConnector } from './interfaces';
/**
 * The default state database token.
 */
export declare const IStateDB: Token<IStateDB<ReadonlyPartialJSONValue>>;
/**
 * The description of a state database.
 */
export interface IStateDB<T extends ReadonlyPartialJSONValue = ReadonlyPartialJSONValue> extends IDataConnector<T> {
    /**
     * Return a serialized copy of the state database's entire contents.
     *
     * @returns A promise that bears the database contents as JSON.
     */
    toJSON(): Promise<{
        [id: string]: T;
    }>;
}
