#-----------------------------------------------------------------------------
# Copyright (c) Anaconda, Inc., and Bokeh Contributors.
# All rights reserved.
#
# The full license is in the file LICENSE.txt, distributed with this software.
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# Boilerplate
#-----------------------------------------------------------------------------
from __future__ import annotations

import logging # isort:skip
log = logging.getLogger(__name__)

#-----------------------------------------------------------------------------
# Imports
#-----------------------------------------------------------------------------

# Standard library imports
from typing import Any

# Bokeh imports
from bokeh.settings import PrioritizedSetting, settings

#-----------------------------------------------------------------------------
# Globals and constants
#-----------------------------------------------------------------------------

__all__ = (
    "get_all_settings",
)

#-----------------------------------------------------------------------------
# General API
#-----------------------------------------------------------------------------

def get_all_settings() -> dict[str, PrioritizedSetting[Any]]:
    """ Return all settings as a dictionary """
    return {
        name: descriptor
        for name, descriptor in settings.__class__.__dict__.items()
        if isinstance(descriptor, PrioritizedSetting)
    }

#-----------------------------------------------------------------------------
# Legacy API
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# Dev API
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# Private API
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# Code
#-----------------------------------------------------------------------------
