<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/portcheck/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/portcheck/metadata.yaml"
sidebar_label: "TCP/UDP Endpoints"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Synthetic Checks"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# TCP/UDP Endpoints


<img src="https://netdata.cloud/img/globe.svg" width="150"/>


Plugin: go.d.plugin
Module: portcheck

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Collector for monitoring service availability and response time. It can be used to check if specific ports are open or reachable on a target system.

It supports both TCP and UDP protocols over IPv4 and IPv6 networks.

| Protocol | Check Description                                                                                                           |
|----------|-----------------------------------------------------------------------------------------------------------------------------|
| TCP      | Attempts to establish a TCP connection to the specified ports on the target system.                                         |
| UDP      | Sends a 0-byte UDP packet to the specified ports on the target system and analyzes ICMP responses to determine port status. |

Possible TCP statuses:

| TCP Status | Description                                                 |
|------------|-------------------------------------------------------------|
| success    | Connection established successfully.                        |
| timeout    | Connection timed out after waiting for configured duration. |
| failed     | An error occurred during the connection attempt.            |

Possible UDP statuses:

| UDP Status    | Description                                                                                                                                                           |
|---------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| open/filtered | No response received within the configured timeout. This status indicates the port is either open or filtered, but the exact state cannot be determined definitively. |
| closed        | Received an ICMP Destination Unreachable message, indicating the port is closed.                                                                                      |




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per TCP endpoint

These metrics refer to the TCP endpoint.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| host | The hostname or IP address of the target system, as specified in the configuration. |
| port | The TCP port being monitored, as defined in the 'ports' configuration parameter. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| portcheck.status | success, failed, timeout | boolean |
| portcheck.state_duration | time | seconds |
| portcheck.latency | time | ms |

### Per UDP endpoint

These metrics refer to the UDP endpoint.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| host | The hostname or IP address of the target system, as specified in the configuration. |
| port | The UDP port being monitored, as defined in the 'udp_ports' configuration parameter. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| portcheck.udp_port_status | open/filtered, closed | status |
| portcheck.udp_port_status_duration | time | seconds |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ portcheck_service_reachable ](https://github.com/netdata/netdata/blob/master/src/health/health.d/portcheck.conf) | portcheck.status | TCP host ${label:host} port ${label:port} liveness status |
| [ portcheck_connection_timeouts ](https://github.com/netdata/netdata/blob/master/src/health/health.d/portcheck.conf) | portcheck.status | percentage of timed-out TCP connections to host ${label:host} port ${label:port} in the last 5 minutes |
| [ portcheck_connection_fails ](https://github.com/netdata/netdata/blob/master/src/health/health.d/portcheck.conf) | portcheck.status | percentage of failed TCP connections to host ${label:host} port ${label:port} in the last 5 minutes |


## Setup


You can configure the **portcheck** collector in two ways:

| Method                | Best for                                                                                 | How to                                                                                                                                 |
|-----------------------|------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------|
| [**UI**](#via-ui)     | Fast setup without editing files                                                         | Go to **Nodes → Configure this node → Collectors → Jobs**, search for **portcheck**, then click **+** to add a job. |
| [**File**](#via-file) | If you prefer configuring via file, or need to automate deployments (e.g., with Ansible) | Edit `go.d/portcheck.conf` and add a job.                                                                        |

:::important

UI configuration requires paid Netdata Cloud plan.

:::


### Prerequisites

No action required.

### Configuration

#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>



| Group | Option | Description | Default | Required |
|:------|:-----|:------------|:--------|:---------:|
| **Collection** | update_every | Data collection frequency (seconds). | 5 | no |
|  | autodetection_retry | Autodetection retry interval (seconds). Set 0 to disable. | 0 | no |
| **Target** | host | Remote host address (IPv4, IPv6, or DNS name). |  | yes |
|  | ports | List of TCP ports to check (numeric format). | [] | no |
|  | udp_ports | List of UDP ports to check (numeric format). | [] | no |
|  | timeout | Port check timeout (seconds). | 2 | no |
| **Virtual Node** | vnode | Associates this data collection job with a [Virtual Node](https://learn.netdata.cloud/docs/netdata-agent/configuration/organize-systems-metrics-and-alerts#virtual-nodes). |  | no |


</details>


#### via UI

Configure the **portcheck** collector from the Netdata web interface:

1. Go to **Nodes**.
2. Select the node **where you want the portcheck data-collection job to run** and click the :gear: (**Configure this node**). That node will run the data collection.
3. The **Collectors → Jobs** view opens by default.
4. In the Search box, type _portcheck_ (or scroll the list) to locate the **portcheck** collector.
5. Click the **+** next to the **portcheck** collector to add a new job.
6. Fill in the job fields, then click **Test** to verify the configuration and **Submit** to save.
    - **Test** runs the job with the provided settings and shows whether data can be collected.
    - If it fails, an error message appears with details (for example, connection refused, timeout, or command execution errors), so you can adjust and retest.


#### via File

The configuration file name for this integration is `go.d/portcheck.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name2
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/portcheck.conf
```

##### Examples

###### Check TCP ports (IPv4)

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    host: 127.0.0.1
    ports:
      - 22
      - 23

```
</details>

###### Check TCP ports (IPv6)

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    host: "[2001:DB8::1]"
    ports:
      - 80
      - 8080

```
</details>

###### Check UDP ports (IPv4)

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    host: 127.0.0.1
    udp_ports:
      - 3120
      - 3121

```
</details>

###### Check UDP ports (IPv6)

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    host: [::1]
    udp_ports:
      - 3120
      - 3121

```
</details>

###### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Multiple instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: server1
    host: 127.0.0.1
    ports:
      - 22
      - 23

  - name: server2
    host: 203.0.113.10
    ports:
      - 22
      - 23

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `portcheck` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m portcheck
  ```

  To debug a specific job:

  ```bash
  ./go.d.plugin -d -m portcheck -j jobName
  ```

### Getting Logs

If you're encountering problems with the `portcheck` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep portcheck
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep portcheck /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep portcheck
```


