<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/proc.plugin/integrations/memory_statistics.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/proc.plugin/metadata.yaml"
sidebar_label: "Memory Statistics"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Linux Systems/Memory"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Memory Statistics


<img src="https://netdata.cloud/img/linuxserver.svg" width="150"/>


Plugin: proc.plugin
Module: /proc/vmstat

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Linux Virtual memory subsystem.

Information about memory management, indicating how effectively the kernel allocates and frees
memory resources in response to system demands.

Monitors page faults, which occur when a process requests a portion of its memory that isn't
immediately available. Monitoring these events can help diagnose inefficiencies in memory management and
provide insights into application behavior.

Tracks swapping activity — a vital aspect of memory management where the kernel moves data from RAM to
swap space, and vice versa, based on memory demand and usage. It also monitors the utilization of zswap,
a compressed cache for swap pages, and provides insights into its usage and performance implications.

In the context of virtualized environments, it tracks the ballooning mechanism which is used to balance
memory resources between host and guest systems.

For systems using NUMA architecture, it provides insights into the local and remote memory accesses, which
can impact the performance based on the memory access times.

The collector also watches for 'Out of Memory' kills, a drastic measure taken by the system when it runs out
of memory resources.




This collector is only supported on the following platforms:

- linux

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Memory Statistics instance



This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| mem.swapio | in, out | KiB/s |
| system.pgpgio | in, out | KiB/s |
| system.pgfaults | minor, major | faults/s |
| mem.balloon | inflate, deflate, migrate | KiB/s |
| mem.zswapio | in, out | KiB/s |
| mem.ksm_cow | swapin, write | KiB/s |
| mem.thp_faults | alloc, fallback, fallback_charge | events/s |
| mem.thp_file | alloc, fallback, mapped, fallback_charge | events/s |
| mem.thp_zero | alloc, failed | events/s |
| mem.thp_collapse | alloc, failed | events/s |
| mem.thp_split | split, failed, split_pmd, split_deferred | events/s |
| mem.thp_swapout | swapout, fallback | events/s |
| mem.thp_compact | success, fail, stall | events/s |
| mem.oom_kill | kills | kills/s |
| mem.numa | local, foreign, interleave, other, pte_updates, huge_pte_updates, hint_faults, hint_faults_local, pages_migrated | events/s |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ 30min_ram_swapped_out ](https://github.com/netdata/netdata/blob/master/src/health/health.d/swap.conf) | mem.swapio | percentage of the system RAM swapped in the last 30 minutes |
| [ oom_kill ](https://github.com/netdata/netdata/blob/master/src/health/health.d/ram.conf) | mem.oom_kill | number of out of memory kills in the last 30 minutes |


## Setup


### Prerequisites

No action required.

### Configuration

#### Options



There are no configuration options.



#### via File

There is no configuration file.

##### Examples
There are no configuration examples.


