/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.filter.prefixes;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.aether.repository.RemoteRepository;

public interface PrefixesSource {
    public RemoteRepository origin();

    public Path path();

    public String message();

    public boolean valid();

    public List<String> entries();

    public static PrefixesSource of(RemoteRepository origin, Path path) {
        Objects.requireNonNull(origin, "origin is null");
        Objects.requireNonNull(path, "path is null");
        return new Parser(origin, path).parse();
    }

    public static final class Parser {
        private static final String PREFIX_MAGIC = "## repository-prefixes/2.0";
        private static final String PREFIX_LEGACY_MAGIC = "# Prefix file generated by Sonatype Nexus";
        private static final String PREFIX_UNSUPPORTED = "@ unsupported";
        private static final int MAX_ENTRIES = 100000;
        private static final int MAX_LINE_LENGTH = 250;
        private final RemoteRepository origin;
        private final Path path;

        private Parser(RemoteRepository origin, Path path) {
            this.origin = origin;
            this.path = path;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private PrefixesSource parse() {
            try (BufferedReader reader = Files.newBufferedReader(this.path, StandardCharsets.UTF_8);){
                ArrayList<String> entries = new ArrayList<String>();
                String line = reader.readLine();
                if (!(PREFIX_MAGIC.equals(line) || PREFIX_LEGACY_MAGIC.equals(line) || PREFIX_UNSUPPORTED.equals(line))) {
                    PrefixesSource prefixesSource = Parser.invalid(this.origin, this.path, "No expected magic in file");
                    return prefixesSource;
                }
                while (line != null) {
                    if (PREFIX_UNSUPPORTED.equals(line = line.trim())) {
                        PrefixesSource prefixesSource = Parser.invalid(this.origin, this.path, "Declares itself unsupported");
                        return prefixesSource;
                    }
                    if (!line.startsWith("#") && !line.isEmpty()) {
                        if (line.length() > 250) {
                            PrefixesSource prefixesSource = Parser.invalid(this.origin, this.path, "Contains too long line");
                            return prefixesSource;
                        }
                        if (!line.chars().allMatch(c -> c < 128)) {
                            PrefixesSource prefixesSource = Parser.invalid(this.origin, this.path, "Contains non-ASCII characters");
                            return prefixesSource;
                        }
                        if (line.contains(":") || line.contains("<") || line.contains(">") || line.contains("\\") || line.contains("//")) {
                            PrefixesSource prefixesSource = Parser.invalid(this.origin, this.path, "Contains forbidden characters");
                            return prefixesSource;
                        }
                        while (line.startsWith(".")) {
                            line = line.substring(1);
                        }
                        entries.add(line);
                    }
                    line = reader.readLine();
                    if (entries.size() <= 100000) continue;
                    PrefixesSource prefixesSource = Parser.invalid(this.origin, this.path, "Contains too many entries");
                    return prefixesSource;
                }
                Impl impl = new Impl(this.origin, this.path, "OK", true, Collections.unmodifiableList(entries));
                return impl;
            }
            catch (NoSuchFileException e) {
                return Parser.invalid(this.origin, this.path, "No such file");
            }
            catch (IOException e) {
                return Parser.invalid(this.origin, this.path, "Could not read the file: " + e.getMessage());
            }
        }

        private static PrefixesSource invalid(RemoteRepository origin, Path path, String message) {
            return new Impl(origin, path, message, false, Collections.emptyList());
        }

        private static class Impl
        implements PrefixesSource {
            private final RemoteRepository origin;
            private final Path path;
            private final String message;
            private final boolean valid;
            private final List<String> entries;

            private Impl(RemoteRepository origin, Path path, String message, boolean valid, List<String> entries) {
                this.origin = Objects.requireNonNull(origin);
                this.path = Objects.requireNonNull(path);
                this.message = message;
                this.valid = valid;
                this.entries = entries;
            }

            @Override
            public RemoteRepository origin() {
                return this.origin;
            }

            @Override
            public Path path() {
                return this.path;
            }

            @Override
            public String message() {
                return this.message;
            }

            @Override
            public boolean valid() {
                return this.valid;
            }

            @Override
            public List<String> entries() {
                return this.entries;
            }
        }
    }
}

