// Code generated by github.com/99designs/gqlgen, DO NOT EDIT.

package model

import (
	"bytes"
	"fmt"
	"io"
	"strconv"

	"github.com/kubetail-org/kubetail/modules/shared/logs"
	"k8s.io/apimachinery/pkg/watch"
)

type LogRecordsQueryResponse struct {
	Records    []*logs.LogRecord `json:"records"`
	NextCursor *string           `json:"nextCursor,omitempty"`
}

type LogSourceFilter struct {
	Region    []string `json:"region,omitempty"`
	Zone      []string `json:"zone,omitempty"`
	Os        []string `json:"os,omitempty"`
	Arch      []string `json:"arch,omitempty"`
	Node      []string `json:"node,omitempty"`
	Container []string `json:"container,omitempty"`
}

type LogSourceWatchEvent struct {
	Type   watch.EventType `json:"type"`
	Object *logs.LogSource `json:"object,omitempty"`
}

type PageInfo struct {
	// When paginating forwards, the cursor to continue.
	EndCursor *string `json:"endCursor,omitempty"`
	// When paginating forwards, are there more items?
	HasNextPage bool `json:"hasNextPage"`
	// When paginating backwards, are there more items?
	HasPreviousPage bool `json:"hasPreviousPage"`
	// When paginating backwards, the cursor to continue.
	StartCursor *string `json:"startCursor,omitempty"`
}

type PodLogQueryResponse struct {
	Results  []*logs.LogRecord `json:"results"`
	PageInfo *PageInfo         `json:"pageInfo"`
}

type Subscription struct {
}

type LogRecordsQueryMode string

const (
	LogRecordsQueryModeHead LogRecordsQueryMode = "HEAD"
	LogRecordsQueryModeTail LogRecordsQueryMode = "TAIL"
)

var AllLogRecordsQueryMode = []LogRecordsQueryMode{
	LogRecordsQueryModeHead,
	LogRecordsQueryModeTail,
}

func (e LogRecordsQueryMode) IsValid() bool {
	switch e {
	case LogRecordsQueryModeHead, LogRecordsQueryModeTail:
		return true
	}
	return false
}

func (e LogRecordsQueryMode) String() string {
	return string(e)
}

func (e *LogRecordsQueryMode) UnmarshalGQL(v any) error {
	str, ok := v.(string)
	if !ok {
		return fmt.Errorf("enums must be strings")
	}

	*e = LogRecordsQueryMode(str)
	if !e.IsValid() {
		return fmt.Errorf("%s is not a valid LogRecordsQueryMode", str)
	}
	return nil
}

func (e LogRecordsQueryMode) MarshalGQL(w io.Writer) {
	fmt.Fprint(w, strconv.Quote(e.String()))
}

func (e *LogRecordsQueryMode) UnmarshalJSON(b []byte) error {
	s, err := strconv.Unquote(string(b))
	if err != nil {
		return err
	}
	return e.UnmarshalGQL(s)
}

func (e LogRecordsQueryMode) MarshalJSON() ([]byte, error) {
	var buf bytes.Buffer
	e.MarshalGQL(&buf)
	return buf.Bytes(), nil
}
