/* automatically generated by rust-bindgen 0.59.2 */

#[doc = "<\\brief Send this to shutdown the agent."]
#[doc = " Use NULL for event data."]
pub const iJIT_jvm_event_iJVM_EVENT_TYPE_SHUTDOWN: iJIT_jvm_event = 2;
#[doc = "<\\brief Send when dynamic code is"]
#[doc = " JIT compiled and loaded into"]
#[doc = " memory by the JIT engine, but"]
#[doc = " before the code is executed."]
#[doc = " Use iJIT_Method_Load as event"]
#[doc = " data."]
pub const iJIT_jvm_event_iJVM_EVENT_TYPE_METHOD_LOAD_FINISHED: iJIT_jvm_event = 13;
#[doc = "<\\brief Send when compiled dynamic"]
#[doc = " code is being unloaded from memory."]
#[doc = " Use iJIT_Method_Load as event data."]
pub const iJIT_jvm_event_iJVM_EVENT_TYPE_METHOD_UNLOAD_START: iJIT_jvm_event = 14;
#[doc = "<\\brief Send to provide new content for"]
#[doc = " a previously reported dynamic code."]
#[doc = " The previous content will be invalidated"]
#[doc = " starting from the time of the notification."]
#[doc = " Use iJIT_Method_Load as event data but"]
#[doc = " required fields are following:"]
#[doc = " - method_id    identify the code to update."]
#[doc = " - method_load_address    specify start address"]
#[doc = "                          within identified code range"]
#[doc = "                          where update should be started."]
#[doc = " - method_size            specify length of updated code"]
#[doc = "                          range."]
pub const iJIT_jvm_event_iJVM_EVENT_TYPE_METHOD_UPDATE: iJIT_jvm_event = 15;
#[doc = "<\\brief Send when an inline dynamic"]
#[doc = " code is JIT compiled and loaded"]
#[doc = " into memory by the JIT engine,"]
#[doc = " but before the parent code region"]
#[doc = " starts executing."]
#[doc = " Use iJIT_Method_Inline_Load as event data."]
pub const iJIT_jvm_event_iJVM_EVENT_TYPE_METHOD_INLINE_LOAD_FINISHED: iJIT_jvm_event = 16;
#[doc = " @cond exclude_from_documentation"]
pub const iJIT_jvm_event_iJVM_EVENT_TYPE_METHOD_UPDATE_V2: iJIT_jvm_event = 17;
#[doc = "<\\brief Send when a dynamic code is"]
#[doc = " JIT compiled and loaded into"]
#[doc = " memory by the JIT engine, but"]
#[doc = " before the code is executed."]
#[doc = " Use iJIT_Method_Load_V2 as event data."]
pub const iJIT_jvm_event_iJVM_EVENT_TYPE_METHOD_LOAD_FINISHED_V2: iJIT_jvm_event = 21;
#[doc = "<\\brief Send when a dynamic code is"]
#[doc = " JIT compiled and loaded into"]
#[doc = " memory by the JIT engine, but"]
#[doc = " before the code is executed."]
#[doc = " Use iJIT_Method_Load_V3 as event data."]
pub const iJIT_jvm_event_iJVM_EVENT_TYPE_METHOD_LOAD_FINISHED_V3: iJIT_jvm_event = 22;
#[doc = " @brief Enumerator for the types of notifications"]
pub type iJIT_jvm_event = ::std::os::raw::c_int;
#[doc = " @brief Enumerator for the types of notifications"]
pub use self::iJIT_jvm_event as iJIT_JVM_EVENT;
#[doc = "<\\brief The agent is not running;"]
#[doc = " iJIT_NotifyEvent calls will"]
#[doc = " not be processed."]
pub const _iJIT_IsProfilingActiveFlags_iJIT_NOTHING_RUNNING: _iJIT_IsProfilingActiveFlags = 0;
#[doc = "<\\brief The agent is running and"]
#[doc = " ready to process notifications."]
pub const _iJIT_IsProfilingActiveFlags_iJIT_SAMPLING_ON: _iJIT_IsProfilingActiveFlags = 1;
#[doc = " @brief Enumerator for the agent's mode"]
pub type _iJIT_IsProfilingActiveFlags = ::std::os::raw::c_int;
#[doc = " @brief Enumerator for the agent's mode"]
pub use self::_iJIT_IsProfilingActiveFlags as iJIT_IsProfilingActiveFlags;
#[doc = " @brief Description of a single entry in the line number information of a code region."]
#[doc = " @details A table of line number entries gives information about how the reported code region"]
#[doc = " is mapped to source file."]
#[doc = " Intel(R) VTune(TM) Amplifier uses line number information to attribute"]
#[doc = " the samples (virtual address) to a line number. \\n"]
#[doc = " It is acceptable to report different code addresses for the same source line:"]
#[doc = " @code"]
#[doc = "   Offset LineNumber"]
#[doc = "      1       2"]
#[doc = "      12      4"]
#[doc = "      15      2"]
#[doc = "      18      1"]
#[doc = "      21      30"]
#[doc = ""]
#[doc = "  VTune Amplifier constructs the following table using the client data"]
#[doc = ""]
#[doc = "   Code subrange  Line number"]
#[doc = "      0-1             2"]
#[doc = "      1-12            4"]
#[doc = "      12-15           2"]
#[doc = "      15-18           1"]
#[doc = "      18-21           30"]
#[doc = " @endcode"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _LineNumberInfo {
    #[doc = "<\\brief Offset from the begining of the code region."]
    pub Offset: ::std::os::raw::c_uint,
    #[doc = "<\\brief Matching source line number offset (from beginning of source file)."]
    pub LineNumber: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout__LineNumberInfo() {
    assert_eq!(
        ::std::mem::size_of::<_LineNumberInfo>(),
        8usize,
        concat!("Size of: ", stringify!(_LineNumberInfo))
    );
    assert_eq!(
        ::std::mem::align_of::<_LineNumberInfo>(),
        4usize,
        concat!("Alignment of ", stringify!(_LineNumberInfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_LineNumberInfo>())).Offset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_LineNumberInfo),
            "::",
            stringify!(Offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_LineNumberInfo>())).LineNumber as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_LineNumberInfo),
            "::",
            stringify!(LineNumber)
        )
    );
}
#[doc = " @brief Description of a single entry in the line number information of a code region."]
#[doc = " @details A table of line number entries gives information about how the reported code region"]
#[doc = " is mapped to source file."]
#[doc = " Intel(R) VTune(TM) Amplifier uses line number information to attribute"]
#[doc = " the samples (virtual address) to a line number. \\n"]
#[doc = " It is acceptable to report different code addresses for the same source line:"]
#[doc = " @code"]
#[doc = "   Offset LineNumber"]
#[doc = "      1       2"]
#[doc = "      12      4"]
#[doc = "      15      2"]
#[doc = "      18      1"]
#[doc = "      21      30"]
#[doc = ""]
#[doc = "  VTune Amplifier constructs the following table using the client data"]
#[doc = ""]
#[doc = "   Code subrange  Line number"]
#[doc = "      0-1             2"]
#[doc = "      1-12            4"]
#[doc = "      12-15           2"]
#[doc = "      15-18           1"]
#[doc = "      18-21           30"]
#[doc = " @endcode"]
pub type pLineNumberInfo = *mut _LineNumberInfo;
#[doc = " @brief Description of a single entry in the line number information of a code region."]
#[doc = " @details A table of line number entries gives information about how the reported code region"]
#[doc = " is mapped to source file."]
#[doc = " Intel(R) VTune(TM) Amplifier uses line number information to attribute"]
#[doc = " the samples (virtual address) to a line number. \\n"]
#[doc = " It is acceptable to report different code addresses for the same source line:"]
#[doc = " @code"]
#[doc = "   Offset LineNumber"]
#[doc = "      1       2"]
#[doc = "      12      4"]
#[doc = "      15      2"]
#[doc = "      18      1"]
#[doc = "      21      30"]
#[doc = ""]
#[doc = "  VTune Amplifier constructs the following table using the client data"]
#[doc = ""]
#[doc = "   Code subrange  Line number"]
#[doc = "      0-1             2"]
#[doc = "      1-12            4"]
#[doc = "      12-15           2"]
#[doc = "      15-18           1"]
#[doc = "      18-21           30"]
#[doc = " @endcode"]
pub type LineNumberInfo = _LineNumberInfo;
#[doc = "<\\brief Native to the process architecture that is calling it."]
pub const _iJIT_CodeArchitecture_iJIT_CA_NATIVE: _iJIT_CodeArchitecture = 0;
#[doc = "<\\brief 32-bit machine code."]
pub const _iJIT_CodeArchitecture_iJIT_CA_32: _iJIT_CodeArchitecture = 1;
#[doc = "<\\brief 64-bit machine code."]
pub const _iJIT_CodeArchitecture_iJIT_CA_64: _iJIT_CodeArchitecture = 2;
#[doc = " @brief Enumerator for the code architecture."]
pub type _iJIT_CodeArchitecture = ::std::os::raw::c_int;
#[doc = " @brief Enumerator for the code architecture."]
pub use self::_iJIT_CodeArchitecture as iJIT_CodeArchitecture;
#[doc = " @brief Description of a JIT-compiled method"]
#[doc = " @details When you use the iJIT_Method_Load structure to describe"]
#[doc = "  the JIT compiled method, use iJVM_EVENT_TYPE_METHOD_LOAD_FINISHED"]
#[doc = "  as an event type to report it."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _iJIT_Method_Load {
    #[doc = "<\\brief Unique method ID. Cannot be 0."]
    #[doc = "  You must either use the API function"]
    #[doc = "  iJIT_GetNewMethodID to get a valid and unique"]
    #[doc = "  method ID, or else manage ID uniqueness"]
    #[doc = "  and correct range by yourself.\\n"]
    #[doc = "  You must use the same method ID for all code"]
    #[doc = "  regions of the same method, otherwise different"]
    #[doc = "  method IDs specify different methods."]
    pub method_id: ::std::os::raw::c_uint,
    #[doc = "<\\brief The name of the method. It can be optionally"]
    #[doc = "  prefixed with its class name and appended with"]
    #[doc = "  its complete signature. Can't be NULL."]
    pub method_name: *mut ::std::os::raw::c_char,
    #[doc = "<\\brief The start virtual address of the method code"]
    #[doc = "  region. If NULL, data provided with"]
    #[doc = "  event are not accepted."]
    pub method_load_address: *mut ::std::os::raw::c_void,
    #[doc = "<\\brief The code size of the method in memory."]
    #[doc = "  If 0, then data provided with the event are not"]
    #[doc = "  accepted."]
    pub method_size: ::std::os::raw::c_uint,
    #[doc = "<\\brief The number of entries in the line number"]
    #[doc = "  table.0 if none."]
    pub line_number_size: ::std::os::raw::c_uint,
    #[doc = "<\\brief Pointer to the line numbers info"]
    #[doc = "  array. Can be NULL if"]
    #[doc = "  line_number_size is 0. See"]
    #[doc = "  LineNumberInfo Structure for a"]
    #[doc = "  description of a single entry in"]
    #[doc = "  the line number info array"]
    pub line_number_table: pLineNumberInfo,
    #[doc = "<\\brief This field is obsolete."]
    pub class_id: ::std::os::raw::c_uint,
    #[doc = "<\\brief Class name. Can be NULL."]
    pub class_file_name: *mut ::std::os::raw::c_char,
    #[doc = "<\\brief Source file name. Can be NULL."]
    pub source_file_name: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout__iJIT_Method_Load() {
    assert_eq!(
        ::std::mem::size_of::<_iJIT_Method_Load>(),
        64usize,
        concat!("Size of: ", stringify!(_iJIT_Method_Load))
    );
    assert_eq!(
        ::std::mem::align_of::<_iJIT_Method_Load>(),
        8usize,
        concat!("Alignment of ", stringify!(_iJIT_Method_Load))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_iJIT_Method_Load>())).method_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load),
            "::",
            stringify!(method_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_iJIT_Method_Load>())).method_name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load),
            "::",
            stringify!(method_name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Load>())).method_load_address as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load),
            "::",
            stringify!(method_load_address)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_iJIT_Method_Load>())).method_size as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load),
            "::",
            stringify!(method_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Load>())).line_number_size as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load),
            "::",
            stringify!(line_number_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Load>())).line_number_table as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load),
            "::",
            stringify!(line_number_table)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_iJIT_Method_Load>())).class_id as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load),
            "::",
            stringify!(class_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Load>())).class_file_name as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load),
            "::",
            stringify!(class_file_name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Load>())).source_file_name as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load),
            "::",
            stringify!(source_file_name)
        )
    );
}
#[doc = " @brief Description of a JIT-compiled method"]
#[doc = " @details When you use the iJIT_Method_Load structure to describe"]
#[doc = "  the JIT compiled method, use iJVM_EVENT_TYPE_METHOD_LOAD_FINISHED"]
#[doc = "  as an event type to report it."]
pub type piJIT_Method_Load = *mut _iJIT_Method_Load;
#[doc = " @brief Description of a JIT-compiled method"]
#[doc = " @details When you use the iJIT_Method_Load structure to describe"]
#[doc = "  the JIT compiled method, use iJVM_EVENT_TYPE_METHOD_LOAD_FINISHED"]
#[doc = "  as an event type to report it."]
pub type iJIT_Method_Load = _iJIT_Method_Load;
#[doc = " @brief Description of a JIT-compiled method"]
#[doc = " @details When you use the iJIT_Method_Load_V2 structure to describe"]
#[doc = "  the JIT compiled method, use iJVM_EVENT_TYPE_METHOD_LOAD_FINISHED_V2"]
#[doc = "  as an event type to report it."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _iJIT_Method_Load_V2 {
    #[doc = "<\\brief Unique method ID. Cannot be 0."]
    #[doc = "  You must either use the API function"]
    #[doc = "  iJIT_GetNewMethodID to get a valid and unique"]
    #[doc = "  method ID, or else manage ID uniqueness"]
    #[doc = "  and correct range by yourself.\\n"]
    #[doc = "  You must use the same method ID for all code"]
    #[doc = "  regions of the same method, otherwise different"]
    #[doc = "  method IDs specify different methods."]
    pub method_id: ::std::os::raw::c_uint,
    #[doc = "<\\brief The name of the method. It can be optionally"]
    #[doc = "  prefixed with its class name and appended with"]
    #[doc = "  its complete signature. Can't be  NULL."]
    pub method_name: *mut ::std::os::raw::c_char,
    #[doc = "<\\brief The start virtual address of the method code"]
    #[doc = "  region. If NULL, then data provided with the"]
    #[doc = "  event are not accepted."]
    pub method_load_address: *mut ::std::os::raw::c_void,
    #[doc = "<\\brief The code size of the method in memory."]
    #[doc = "  If 0, then data provided with the event are not"]
    #[doc = "  accepted."]
    pub method_size: ::std::os::raw::c_uint,
    #[doc = "<\\brief The number of entries in the line number"]
    #[doc = "  table. 0 if none."]
    pub line_number_size: ::std::os::raw::c_uint,
    #[doc = "<\\brief Pointer to the line numbers info"]
    #[doc = "  array. Can be NULL if"]
    #[doc = "  line_number_size is 0. See"]
    #[doc = "  LineNumberInfo Structure for a"]
    #[doc = "  description of a single entry in"]
    #[doc = "  the line number info array."]
    pub line_number_table: pLineNumberInfo,
    #[doc = "<\\brief Class name. Can be NULL."]
    pub class_file_name: *mut ::std::os::raw::c_char,
    #[doc = "<\\brief Source file name. Can be NULL."]
    pub source_file_name: *mut ::std::os::raw::c_char,
    #[doc = "<\\brief Module name. Can be NULL."]
    #[doc = "The module name can be useful for distinguishing among"]
    #[doc = "different JIT engines. VTune Amplifier will display"]
    #[doc = "reported methods grouped by specific module."]
    pub module_name: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout__iJIT_Method_Load_V2() {
    assert_eq!(
        ::std::mem::size_of::<_iJIT_Method_Load_V2>(),
        64usize,
        concat!("Size of: ", stringify!(_iJIT_Method_Load_V2))
    );
    assert_eq!(
        ::std::mem::align_of::<_iJIT_Method_Load_V2>(),
        8usize,
        concat!("Alignment of ", stringify!(_iJIT_Method_Load_V2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_iJIT_Method_Load_V2>())).method_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load_V2),
            "::",
            stringify!(method_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Load_V2>())).method_name as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load_V2),
            "::",
            stringify!(method_name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Load_V2>())).method_load_address as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load_V2),
            "::",
            stringify!(method_load_address)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Load_V2>())).method_size as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load_V2),
            "::",
            stringify!(method_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Load_V2>())).line_number_size as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load_V2),
            "::",
            stringify!(line_number_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Load_V2>())).line_number_table as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load_V2),
            "::",
            stringify!(line_number_table)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Load_V2>())).class_file_name as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load_V2),
            "::",
            stringify!(class_file_name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Load_V2>())).source_file_name as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load_V2),
            "::",
            stringify!(source_file_name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Load_V2>())).module_name as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load_V2),
            "::",
            stringify!(module_name)
        )
    );
}
#[doc = " @brief Description of a JIT-compiled method"]
#[doc = " @details When you use the iJIT_Method_Load_V2 structure to describe"]
#[doc = "  the JIT compiled method, use iJVM_EVENT_TYPE_METHOD_LOAD_FINISHED_V2"]
#[doc = "  as an event type to report it."]
pub type piJIT_Method_Load_V2 = *mut _iJIT_Method_Load_V2;
#[doc = " @brief Description of a JIT-compiled method"]
#[doc = " @details When you use the iJIT_Method_Load_V2 structure to describe"]
#[doc = "  the JIT compiled method, use iJVM_EVENT_TYPE_METHOD_LOAD_FINISHED_V2"]
#[doc = "  as an event type to report it."]
pub type iJIT_Method_Load_V2 = _iJIT_Method_Load_V2;
#[doc = " @brief Description of a JIT-compiled method"]
#[doc = " @details The iJIT_Method_Load_V3 structure is the same as iJIT_Method_Load_V2"]
#[doc = "  with a newly introduced 'arch' field that specifies architecture of the code region."]
#[doc = "  When you use the iJIT_Method_Load_V3 structure to describe"]
#[doc = "  the JIT compiled method, use iJVM_EVENT_TYPE_METHOD_LOAD_FINISHED_V3"]
#[doc = "  as an event type to report it."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _iJIT_Method_Load_V3 {
    #[doc = "<\\brief Unique method ID. Cannot be 0."]
    #[doc = "  You must either use the API function"]
    #[doc = "  iJIT_GetNewMethodID to get a valid and unique"]
    #[doc = "  method ID, or manage ID uniqueness"]
    #[doc = "  and correct range by yourself.\\n"]
    #[doc = "  You must use the same method ID for all code"]
    #[doc = "  regions of the same method, otherwise they are"]
    #[doc = "  treated as regions of different methods."]
    pub method_id: ::std::os::raw::c_uint,
    #[doc = "<\\brief The name of the method. It can be optionally"]
    #[doc = "  prefixed with its class name and appended with"]
    #[doc = "  its complete signature. Cannot be  NULL."]
    pub method_name: *mut ::std::os::raw::c_char,
    #[doc = "<\\brief The start virtual address of the method code"]
    #[doc = "  region. If NULL, then data provided with the"]
    #[doc = "  event are not accepted."]
    pub method_load_address: *mut ::std::os::raw::c_void,
    #[doc = "<\\brief The code size of the method in memory."]
    #[doc = "  If 0, then data provided with the event are not"]
    #[doc = "  accepted."]
    pub method_size: ::std::os::raw::c_uint,
    #[doc = "<\\brief The number of entries in the line number"]
    #[doc = "  table. 0 if none."]
    pub line_number_size: ::std::os::raw::c_uint,
    #[doc = "<\\brief Pointer to the line numbers info"]
    #[doc = "  array. Can be NULL if"]
    #[doc = "  line_number_size is 0. See"]
    #[doc = "  LineNumberInfo Structure for a"]
    #[doc = "  description of a single entry in"]
    #[doc = "  the line number info array."]
    pub line_number_table: pLineNumberInfo,
    #[doc = "<\\brief Class name. Can be NULL."]
    pub class_file_name: *mut ::std::os::raw::c_char,
    #[doc = "<\\brief Source file name. Can be NULL."]
    pub source_file_name: *mut ::std::os::raw::c_char,
    #[doc = "<\\brief Module name. Can be NULL."]
    #[doc = "  The module name can be useful for distinguishing among"]
    #[doc = "  different JIT engines. VTune Amplifier will display"]
    #[doc = "  reported methods grouped by specific module."]
    pub module_name: *mut ::std::os::raw::c_char,
    #[doc = "<\\brief Architecture of the method's code region."]
    #[doc = "  By default, it is the same as the process"]
    #[doc = "  architecture that is calling it."]
    #[doc = "  For example, you can use it if your 32-bit JIT"]
    #[doc = "  engine generates 64-bit code."]
    #[doc = ""]
    #[doc = "  If JIT engine reports both 32-bit and 64-bit types"]
    #[doc = "  of methods then VTune Amplifier splits the methods"]
    #[doc = "  with the same module name but with different"]
    #[doc = "  architectures in two different modules. VTune Amplifier"]
    #[doc = "  modifies the original name provided with a 64-bit method"]
    #[doc = "  version by ending it with '(64)'"]
    pub module_arch: iJIT_CodeArchitecture,
}
#[test]
fn bindgen_test_layout__iJIT_Method_Load_V3() {
    assert_eq!(
        ::std::mem::size_of::<_iJIT_Method_Load_V3>(),
        72usize,
        concat!("Size of: ", stringify!(_iJIT_Method_Load_V3))
    );
    assert_eq!(
        ::std::mem::align_of::<_iJIT_Method_Load_V3>(),
        8usize,
        concat!("Alignment of ", stringify!(_iJIT_Method_Load_V3))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_iJIT_Method_Load_V3>())).method_id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load_V3),
            "::",
            stringify!(method_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Load_V3>())).method_name as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load_V3),
            "::",
            stringify!(method_name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Load_V3>())).method_load_address as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load_V3),
            "::",
            stringify!(method_load_address)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Load_V3>())).method_size as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load_V3),
            "::",
            stringify!(method_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Load_V3>())).line_number_size as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load_V3),
            "::",
            stringify!(line_number_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Load_V3>())).line_number_table as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load_V3),
            "::",
            stringify!(line_number_table)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Load_V3>())).class_file_name as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load_V3),
            "::",
            stringify!(class_file_name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Load_V3>())).source_file_name as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load_V3),
            "::",
            stringify!(source_file_name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Load_V3>())).module_name as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load_V3),
            "::",
            stringify!(module_name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Load_V3>())).module_arch as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Load_V3),
            "::",
            stringify!(module_arch)
        )
    );
}
#[doc = " @brief Description of a JIT-compiled method"]
#[doc = " @details The iJIT_Method_Load_V3 structure is the same as iJIT_Method_Load_V2"]
#[doc = "  with a newly introduced 'arch' field that specifies architecture of the code region."]
#[doc = "  When you use the iJIT_Method_Load_V3 structure to describe"]
#[doc = "  the JIT compiled method, use iJVM_EVENT_TYPE_METHOD_LOAD_FINISHED_V3"]
#[doc = "  as an event type to report it."]
pub type piJIT_Method_Load_V3 = *mut _iJIT_Method_Load_V3;
#[doc = " @brief Description of a JIT-compiled method"]
#[doc = " @details The iJIT_Method_Load_V3 structure is the same as iJIT_Method_Load_V2"]
#[doc = "  with a newly introduced 'arch' field that specifies architecture of the code region."]
#[doc = "  When you use the iJIT_Method_Load_V3 structure to describe"]
#[doc = "  the JIT compiled method, use iJVM_EVENT_TYPE_METHOD_LOAD_FINISHED_V3"]
#[doc = "  as an event type to report it."]
pub type iJIT_Method_Load_V3 = _iJIT_Method_Load_V3;
#[doc = " @brief Description of an inline JIT-compiled method"]
#[doc = " @details When you use the_iJIT_Method_Inline_Load structure to describe"]
#[doc = "  the JIT compiled method, use iJVM_EVENT_TYPE_METHOD_INLINE_LOAD_FINISHED"]
#[doc = "  as an event type to report it."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _iJIT_Method_Inline_Load {
    #[doc = "<\\brief Unique method ID. Cannot be 0."]
    #[doc = "  You must either use the API function"]
    #[doc = "  iJIT_GetNewMethodID to get a valid and unique"]
    #[doc = "  method ID, or else manage ID uniqueness"]
    #[doc = "  and correct range by yourself."]
    pub method_id: ::std::os::raw::c_uint,
    #[doc = "<\\brief Unique immediate parent's method ID."]
    #[doc = "  Cannot be 0."]
    #[doc = "  You must either use the API function"]
    #[doc = "  iJIT_GetNewMethodID to get a valid and unique"]
    #[doc = "  method ID, or else manage ID uniqueness"]
    #[doc = "  and correct range by yourself."]
    pub parent_method_id: ::std::os::raw::c_uint,
    #[doc = "<\\brief The name of the method. It can be optionally"]
    #[doc = "  prefixed with its class name and appended with"]
    #[doc = "  its complete signature. Can't be NULL."]
    pub method_name: *mut ::std::os::raw::c_char,
    pub method_load_address: *mut ::std::os::raw::c_void,
    #[doc = "<\\brief The code size of the method in memory."]
    #[doc = "  If 0, then data provided with the event are not"]
    #[doc = "  accepted."]
    pub method_size: ::std::os::raw::c_uint,
    #[doc = "<\\brief The number of entries in the line number"]
    #[doc = "  table. 0 if none."]
    pub line_number_size: ::std::os::raw::c_uint,
    #[doc = "<\\brief Pointer to the line numbers info"]
    #[doc = "  array. Can be NULL if"]
    #[doc = "  line_number_size is 0. See"]
    #[doc = "  LineNumberInfo Structure for a"]
    #[doc = "  description of a single entry in"]
    #[doc = "  the line number info array"]
    pub line_number_table: pLineNumberInfo,
    #[doc = "<\\brief Class name. Can be NULL."]
    pub class_file_name: *mut ::std::os::raw::c_char,
    #[doc = "<\\brief Source file name. Can be NULL."]
    pub source_file_name: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout__iJIT_Method_Inline_Load() {
    assert_eq!(
        ::std::mem::size_of::<_iJIT_Method_Inline_Load>(),
        56usize,
        concat!("Size of: ", stringify!(_iJIT_Method_Inline_Load))
    );
    assert_eq!(
        ::std::mem::align_of::<_iJIT_Method_Inline_Load>(),
        8usize,
        concat!("Alignment of ", stringify!(_iJIT_Method_Inline_Load))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Inline_Load>())).method_id as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Inline_Load),
            "::",
            stringify!(method_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Inline_Load>())).parent_method_id as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Inline_Load),
            "::",
            stringify!(parent_method_id)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Inline_Load>())).method_name as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Inline_Load),
            "::",
            stringify!(method_name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Inline_Load>())).method_load_address as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Inline_Load),
            "::",
            stringify!(method_load_address)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Inline_Load>())).method_size as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Inline_Load),
            "::",
            stringify!(method_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Inline_Load>())).line_number_size as *const _
                as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Inline_Load),
            "::",
            stringify!(line_number_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Inline_Load>())).line_number_table as *const _
                as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Inline_Load),
            "::",
            stringify!(line_number_table)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Inline_Load>())).class_file_name as *const _
                as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Inline_Load),
            "::",
            stringify!(class_file_name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Inline_Load>())).source_file_name as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Inline_Load),
            "::",
            stringify!(source_file_name)
        )
    );
}
#[doc = " @brief Description of an inline JIT-compiled method"]
#[doc = " @details When you use the_iJIT_Method_Inline_Load structure to describe"]
#[doc = "  the JIT compiled method, use iJVM_EVENT_TYPE_METHOD_INLINE_LOAD_FINISHED"]
#[doc = "  as an event type to report it."]
pub type piJIT_Method_Inline_Load = *mut _iJIT_Method_Inline_Load;
#[doc = " @brief Description of an inline JIT-compiled method"]
#[doc = " @details When you use the_iJIT_Method_Inline_Load structure to describe"]
#[doc = "  the JIT compiled method, use iJVM_EVENT_TYPE_METHOD_INLINE_LOAD_FINISHED"]
#[doc = "  as an event type to report it."]
pub type iJIT_Method_Inline_Load = _iJIT_Method_Inline_Load;
pub const _iJIT_SegmentType_iJIT_CT_UNKNOWN: _iJIT_SegmentType = 0;
#[doc = "<\\brief Executable code."]
pub const _iJIT_SegmentType_iJIT_CT_CODE: _iJIT_SegmentType = 1;
#[doc = "<\\brief Data (not executable code)."]
#[doc = " VTune Amplifier uses the format string"]
#[doc = " (see iJIT_Method_Update) to represent"]
#[doc = " this data in the VTune Amplifier GUI"]
pub const _iJIT_SegmentType_iJIT_CT_DATA: _iJIT_SegmentType = 2;
#[doc = "<\\brief Use the previous markup for the trace."]
#[doc = " Can be used for the following"]
#[doc = " iJVM_EVENT_TYPE_METHOD_UPDATE_V2 events,"]
#[doc = " if the type of the previously reported segment"]
#[doc = " type is the same."]
pub const _iJIT_SegmentType_iJIT_CT_KEEP: _iJIT_SegmentType = 3;
pub const _iJIT_SegmentType_iJIT_CT_EOF: _iJIT_SegmentType = 4;
#[doc = " @cond exclude_from_documentation */"]
#[doc = " @brief Description of a segment type"]
#[doc = " @details Use the segment type to specify a type of data supplied"]
#[doc = " with the iJVM_EVENT_TYPE_METHOD_UPDATE_V2 event to be applied to"]
#[doc = " a certain code trace."]
pub type _iJIT_SegmentType = ::std::os::raw::c_int;
#[doc = " @cond exclude_from_documentation */"]
#[doc = " @brief Description of a segment type"]
#[doc = " @details Use the segment type to specify a type of data supplied"]
#[doc = " with the iJVM_EVENT_TYPE_METHOD_UPDATE_V2 event to be applied to"]
#[doc = " a certain code trace."]
pub use self::_iJIT_SegmentType as iJIT_SegmentType;
#[doc = " @brief Description of a dynamic update of the content within JIT-compiled method"]
#[doc = " @details The JIT engine may generate the methods that are updated at runtime"]
#[doc = " partially by mixed (data + executable code) content. When you use the iJIT_Method_Update"]
#[doc = " structure to describe the update of the content within a JIT-compiled method,"]
#[doc = " use iJVM_EVENT_TYPE_METHOD_UPDATE_V2 as an event type to report it."]
#[doc = ""]
#[doc = " On the first Update event, VTune Amplifier copies the original code range reported by"]
#[doc = " the iJVM_EVENT_TYPE_METHOD_LOAD event, then modifies it with the supplied bytes and"]
#[doc = " adds the modified range to the original method. For next update events, VTune Amplifier"]
#[doc = " does the same but it uses the latest modified version of a code region for update."]
#[doc = " Eventually, VTune Amplifier GUI displays multiple code ranges for the method reported by"]
#[doc = " the iJVM_EVENT_TYPE_METHOD_LOAD event."]
#[doc = " Notes:"]
#[doc = " - Multiple update events with different types for the same trace are allowed"]
#[doc = "   but they must be reported for the same code ranges."]
#[doc = "   Example,"]
#[doc = " @code"]
#[doc = "                      [-- data---]        Allowed"]
#[doc = "          [-- code --]                    Allowed"]
#[doc = "        [code]                            Ignored"]
#[doc = "                      [-- data---]        Allowed"]
#[doc = "          [-- code --]                    Allowed"]
#[doc = "      [------------ trace ---------]"]
#[doc = " @endcode"]
#[doc = " - The types of previously reported events can be changed but they must be reported"]
#[doc = "   for the same code ranges."]
#[doc = "   Example,"]
#[doc = " @code"]
#[doc = "          [-- data---]                    Allowed"]
#[doc = "          [-- code --]                    Allowed"]
#[doc = "          [-- data---]                    Allowed"]
#[doc = "          [-- code --]                    Allowed"]
#[doc = "      [------------ trace ---------]"]
#[doc = " @endcode"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _iJIT_Method_Update {
    #[doc = "<\\brief Start address of the update within a method"]
    pub load_address: *mut ::std::os::raw::c_void,
    #[doc = "<\\brief The update size"]
    pub size: ::std::os::raw::c_uint,
    #[doc = "<\\brief Type of the update"]
    pub type_: iJIT_SegmentType,
    #[doc = "<\\brief C string that contains a format string"]
    #[doc = " that follows the same specifications as format in printf."]
    #[doc = " The format string is used for iJIT_CT_CODE only"]
    #[doc = " and cannot be NULL."]
    #[doc = " Format can be changed on the fly."]
    pub data_format: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout__iJIT_Method_Update() {
    assert_eq!(
        ::std::mem::size_of::<_iJIT_Method_Update>(),
        24usize,
        concat!("Size of: ", stringify!(_iJIT_Method_Update))
    );
    assert_eq!(
        ::std::mem::align_of::<_iJIT_Method_Update>(),
        8usize,
        concat!("Alignment of ", stringify!(_iJIT_Method_Update))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_iJIT_Method_Update>())).load_address as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Update),
            "::",
            stringify!(load_address)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_iJIT_Method_Update>())).size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Update),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_iJIT_Method_Update>())).type_ as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Update),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_iJIT_Method_Update>())).data_format as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_iJIT_Method_Update),
            "::",
            stringify!(data_format)
        )
    );
}
#[doc = " @brief Description of a dynamic update of the content within JIT-compiled method"]
#[doc = " @details The JIT engine may generate the methods that are updated at runtime"]
#[doc = " partially by mixed (data + executable code) content. When you use the iJIT_Method_Update"]
#[doc = " structure to describe the update of the content within a JIT-compiled method,"]
#[doc = " use iJVM_EVENT_TYPE_METHOD_UPDATE_V2 as an event type to report it."]
#[doc = ""]
#[doc = " On the first Update event, VTune Amplifier copies the original code range reported by"]
#[doc = " the iJVM_EVENT_TYPE_METHOD_LOAD event, then modifies it with the supplied bytes and"]
#[doc = " adds the modified range to the original method. For next update events, VTune Amplifier"]
#[doc = " does the same but it uses the latest modified version of a code region for update."]
#[doc = " Eventually, VTune Amplifier GUI displays multiple code ranges for the method reported by"]
#[doc = " the iJVM_EVENT_TYPE_METHOD_LOAD event."]
#[doc = " Notes:"]
#[doc = " - Multiple update events with different types for the same trace are allowed"]
#[doc = "   but they must be reported for the same code ranges."]
#[doc = "   Example,"]
#[doc = " @code"]
#[doc = "                      [-- data---]        Allowed"]
#[doc = "          [-- code --]                    Allowed"]
#[doc = "        [code]                            Ignored"]
#[doc = "                      [-- data---]        Allowed"]
#[doc = "          [-- code --]                    Allowed"]
#[doc = "      [------------ trace ---------]"]
#[doc = " @endcode"]
#[doc = " - The types of previously reported events can be changed but they must be reported"]
#[doc = "   for the same code ranges."]
#[doc = "   Example,"]
#[doc = " @code"]
#[doc = "          [-- data---]                    Allowed"]
#[doc = "          [-- code --]                    Allowed"]
#[doc = "          [-- data---]                    Allowed"]
#[doc = "          [-- code --]                    Allowed"]
#[doc = "      [------------ trace ---------]"]
#[doc = " @endcode"]
pub type piJIT_Method_Update = *mut _iJIT_Method_Update;
#[doc = " @brief Description of a dynamic update of the content within JIT-compiled method"]
#[doc = " @details The JIT engine may generate the methods that are updated at runtime"]
#[doc = " partially by mixed (data + executable code) content. When you use the iJIT_Method_Update"]
#[doc = " structure to describe the update of the content within a JIT-compiled method,"]
#[doc = " use iJVM_EVENT_TYPE_METHOD_UPDATE_V2 as an event type to report it."]
#[doc = ""]
#[doc = " On the first Update event, VTune Amplifier copies the original code range reported by"]
#[doc = " the iJVM_EVENT_TYPE_METHOD_LOAD event, then modifies it with the supplied bytes and"]
#[doc = " adds the modified range to the original method. For next update events, VTune Amplifier"]
#[doc = " does the same but it uses the latest modified version of a code region for update."]
#[doc = " Eventually, VTune Amplifier GUI displays multiple code ranges for the method reported by"]
#[doc = " the iJVM_EVENT_TYPE_METHOD_LOAD event."]
#[doc = " Notes:"]
#[doc = " - Multiple update events with different types for the same trace are allowed"]
#[doc = "   but they must be reported for the same code ranges."]
#[doc = "   Example,"]
#[doc = " @code"]
#[doc = "                      [-- data---]        Allowed"]
#[doc = "          [-- code --]                    Allowed"]
#[doc = "        [code]                            Ignored"]
#[doc = "                      [-- data---]        Allowed"]
#[doc = "          [-- code --]                    Allowed"]
#[doc = "      [------------ trace ---------]"]
#[doc = " @endcode"]
#[doc = " - The types of previously reported events can be changed but they must be reported"]
#[doc = "   for the same code ranges."]
#[doc = "   Example,"]
#[doc = " @code"]
#[doc = "          [-- data---]                    Allowed"]
#[doc = "          [-- code --]                    Allowed"]
#[doc = "          [-- data---]                    Allowed"]
#[doc = "          [-- code --]                    Allowed"]
#[doc = "      [------------ trace ---------]"]
#[doc = " @endcode"]
pub type iJIT_Method_Update = _iJIT_Method_Update;
extern "C" {
    #[doc = " @brief Generates a new unique method ID."]
    #[doc = ""]
    #[doc = " You must use this API to obtain unique and valid method IDs for methods or"]
    #[doc = " traces reported to the agent if you don't have your own mechanism to generate"]
    #[doc = " unique method IDs."]
    #[doc = ""]
    #[doc = " @return a new unique method ID. When out of unique method IDs, this API"]
    #[doc = " returns 0, which is not an accepted value."]
    pub fn iJIT_GetNewMethodID() -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = " @brief Returns the current mode of the agent."]
    #[doc = ""]
    #[doc = " @return iJIT_SAMPLING_ON, indicating that agent is running, or"]
    #[doc = " iJIT_NOTHING_RUNNING if no agent is running."]
    pub fn iJIT_IsProfilingActive() -> iJIT_IsProfilingActiveFlags;
}
extern "C" {
    #[doc = " @brief Reports infomation about JIT-compiled code to the agent."]
    #[doc = ""]
    #[doc = " The reported information is used to attribute samples obtained from any"]
    #[doc = " Intel(R) VTune(TM) Amplifier collector. This API needs to be called"]
    #[doc = " after JIT compilation and before the first entry into the JIT-compiled"]
    #[doc = " code."]
    #[doc = ""]
    #[doc = " @param[in] event_type - type of the data sent to the agent"]
    #[doc = " @param[in] EventSpecificData - pointer to event-specific data"]
    #[doc = ""]
    #[doc = " @returns 1 on success, otherwise 0."]
    pub fn iJIT_NotifyEvent(
        event_type: iJIT_JVM_EVENT,
        EventSpecificData: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
