/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.NumericUtils;
import software.amazon.awssdk.utils.Validate;

@SdkProtectedApi
public class LengthAwareInputStream
extends FilterInputStream {
    private static final Logger LOG = Logger.loggerFor(LengthAwareInputStream.class);
    private final long length;
    private long remaining;
    private long markedRemaining;

    public LengthAwareInputStream(InputStream in, long length) {
        super(in);
        this.markedRemaining = this.remaining = (this.length = Validate.isNotNegative(length, "length"));
    }

    @Override
    public final int read() throws IOException {
        if (!this.hasMoreBytes()) {
            LOG.debug(() -> String.format("Specified InputStream length of %d has been reached. Returning EOF.", this.length));
            return -1;
        }
        int read = super.read();
        if (read != -1) {
            --this.remaining;
        }
        if (read == -1 && this.remaining > 0L) {
            throw new IllegalStateException("The request content has fewer bytes than the specified content-length: " + this.length + " bytes.");
        }
        return read;
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        if (!this.hasMoreBytes()) {
            LOG.debug(() -> String.format("Specified InputStream length of %d has been reached. Returning EOF.", this.length));
            return -1;
        }
        int readLen = Math.min(len, NumericUtils.saturatedCast(this.remaining));
        int read = super.read(b, off, readLen);
        if (read != -1) {
            this.remaining -= (long)read;
        }
        if (read == -1 && this.remaining > 0L) {
            throw new IllegalStateException("The request content has fewer bytes than the specified content-length: " + this.length + " bytes.");
        }
        return read;
    }

    @Override
    public final long skip(long requestedBytesToSkip) throws IOException {
        requestedBytesToSkip = Math.min(requestedBytesToSkip, this.remaining);
        long skippedActual = super.skip(requestedBytesToSkip);
        this.remaining -= skippedActual;
        return skippedActual;
    }

    @Override
    public final int available() throws IOException {
        int streamAvailable = super.available();
        return Math.min(streamAvailable, NumericUtils.saturatedCast(this.remaining));
    }

    @Override
    public final void mark(int readlimit) {
        super.mark(readlimit);
        this.markedRemaining = this.remaining;
    }

    @Override
    public final void reset() throws IOException {
        super.reset();
        this.remaining = this.markedRemaining;
    }

    public final long remaining() {
        return this.remaining;
    }

    private boolean hasMoreBytes() {
        return this.remaining > 0L;
    }
}

