/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitytoken.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.PolicyDescriptorType;
import com.amazonaws.services.securitytoken.model.ProvidedContext;
import com.amazonaws.services.securitytoken.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class AssumeRoleRequestMarshaller
implements Marshaller<Request<AssumeRoleRequest>, AssumeRoleRequest> {
    public Request<AssumeRoleRequest> marshall(AssumeRoleRequest assumeRoleRequest) {
        if (assumeRoleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)assumeRoleRequest, "AWSSecurityTokenService");
        request.addParameter("Action", "AssumeRole");
        request.addParameter("Version", "2011-06-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (assumeRoleRequest.getRoleArn() != null) {
            request.addParameter("RoleArn", StringUtils.fromString((String)assumeRoleRequest.getRoleArn()));
        }
        if (assumeRoleRequest.getRoleSessionName() != null) {
            request.addParameter("RoleSessionName", StringUtils.fromString((String)assumeRoleRequest.getRoleSessionName()));
        }
        if (assumeRoleRequest.getPolicyArns() != null) {
            List<PolicyDescriptorType> policyArnsList = assumeRoleRequest.getPolicyArns();
            if (policyArnsList.isEmpty()) {
                request.addParameter("PolicyArns", "");
            } else {
                int policyArnsListIndex = 1;
                for (PolicyDescriptorType policyArnsListValue : policyArnsList) {
                    if (policyArnsListValue != null && policyArnsListValue.getArn() != null) {
                        request.addParameter("PolicyArns.member." + policyArnsListIndex + ".arn", StringUtils.fromString((String)policyArnsListValue.getArn()));
                    }
                    ++policyArnsListIndex;
                }
            }
        }
        if (assumeRoleRequest.getPolicy() != null) {
            request.addParameter("Policy", StringUtils.fromString((String)assumeRoleRequest.getPolicy()));
        }
        if (assumeRoleRequest.getDurationSeconds() != null) {
            request.addParameter("DurationSeconds", StringUtils.fromInteger((Integer)assumeRoleRequest.getDurationSeconds()));
        }
        if (assumeRoleRequest.getTags() != null) {
            List<Tag> tagsList = assumeRoleRequest.getTags();
            if (tagsList.isEmpty()) {
                request.addParameter("Tags", "");
            } else {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue != null) {
                        if (tagsListValue.getKey() != null) {
                            request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                        }
                        if (tagsListValue.getValue() != null) {
                            request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                        }
                    }
                    ++tagsListIndex;
                }
            }
        }
        if (assumeRoleRequest.getTransitiveTagKeys() != null) {
            List<String> transitiveTagKeysList = assumeRoleRequest.getTransitiveTagKeys();
            if (transitiveTagKeysList.isEmpty()) {
                request.addParameter("TransitiveTagKeys", "");
            } else {
                int transitiveTagKeysListIndex = 1;
                for (String transitiveTagKeysListValue : transitiveTagKeysList) {
                    if (transitiveTagKeysListValue != null) {
                        request.addParameter("TransitiveTagKeys.member." + transitiveTagKeysListIndex, StringUtils.fromString((String)transitiveTagKeysListValue));
                    }
                    ++transitiveTagKeysListIndex;
                }
            }
        }
        if (assumeRoleRequest.getExternalId() != null) {
            request.addParameter("ExternalId", StringUtils.fromString((String)assumeRoleRequest.getExternalId()));
        }
        if (assumeRoleRequest.getSerialNumber() != null) {
            request.addParameter("SerialNumber", StringUtils.fromString((String)assumeRoleRequest.getSerialNumber()));
        }
        if (assumeRoleRequest.getTokenCode() != null) {
            request.addParameter("TokenCode", StringUtils.fromString((String)assumeRoleRequest.getTokenCode()));
        }
        if (assumeRoleRequest.getSourceIdentity() != null) {
            request.addParameter("SourceIdentity", StringUtils.fromString((String)assumeRoleRequest.getSourceIdentity()));
        }
        if (assumeRoleRequest.getProvidedContexts() != null) {
            List<ProvidedContext> providedContextsList = assumeRoleRequest.getProvidedContexts();
            if (providedContextsList.isEmpty()) {
                request.addParameter("ProvidedContexts", "");
            } else {
                int providedContextsListIndex = 1;
                for (ProvidedContext providedContextsListValue : providedContextsList) {
                    if (providedContextsListValue != null) {
                        if (providedContextsListValue.getProviderArn() != null) {
                            request.addParameter("ProvidedContexts.member." + providedContextsListIndex + ".ProviderArn", StringUtils.fromString((String)providedContextsListValue.getProviderArn()));
                        }
                        if (providedContextsListValue.getContextAssertion() != null) {
                            request.addParameter("ProvidedContexts.member." + providedContextsListIndex + ".ContextAssertion", StringUtils.fromString((String)providedContextsListValue.getContextAssertion()));
                        }
                    }
                    ++providedContextsListIndex;
                }
            }
        }
        return request;
    }
}

