/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.util.Comparator;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;

public class Pair<A, B> {
    public final A first;
    @Nls
    public final B second;
    private static final Pair EMPTY = Pair.create(null, null);

    @NotNull
    public static <A, B> Pair<A, B> create(A first, B second) {
        return new Pair<A, B>(first, second);
    }

    @NotNull
    public static <A, B> NonNull<A, B> createNonNull(@NotNull A first, @NotNull B second) {
        if (first == null) {
            Pair.$$$reportNull$$$0(0);
        }
        if (second == null) {
            Pair.$$$reportNull$$$0(1);
        }
        return new NonNull<A, B>(first, second);
    }

    @NotNull
    public static <A, B> Pair<A, B> pair(A first, B second) {
        return new Pair<A, B>(first, second);
    }

    public static <T> T getFirst(@Nullable Pair<T, ?> pair) {
        return pair != null ? (T)pair.first : null;
    }

    public static <T> T getSecond(@Nullable Pair<?, T> pair) {
        return pair != null ? (T)pair.second : null;
    }

    @NotNull
    public static <A, B> Pair<A, B> empty() {
        Pair pair = EMPTY;
        if (pair == null) {
            Pair.$$$reportNull$$$0(2);
        }
        return pair;
    }

    public Pair(A first, B second) {
        this.first = first;
        this.second = second;
    }

    public final A getFirst() {
        return this.first;
    }

    public final B getSecond() {
        return this.second;
    }

    public final boolean equals(Object o2) {
        return o2 instanceof Pair && Comparing.equal(this.first, ((Pair)o2).first) && Comparing.equal(this.second, ((Pair)o2).second);
    }

    public int hashCode() {
        int result2 = this.first != null ? this.first.hashCode() : 0;
        result2 = 31 * result2 + (this.second != null ? this.second.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "<" + this.first + "," + this.second + ">";
    }

    public static <A extends Comparable<? super A>, B> Comparator<Pair<A, B>> comparingByFirst() {
        return new Comparator<Pair<A, B>>(){

            @Override
            public int compare(Pair<A, B> o1, Pair<A, B> o2) {
                return ((Comparable)o1.first).compareTo(o2.first);
            }
        };
    }

    public static <A, B extends Comparable<? super B>> Comparator<Pair<A, B>> comparingBySecond() {
        return new Comparator<Pair<A, B>>(){

            @Override
            public int compare(Pair<A, B> o1, Pair<A, B> o2) {
                return ((Comparable)o1.second).compareTo(o2.second);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/Pair";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/Pair";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createNonNull";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NonNull<A, B>
    extends Pair<A, B> {
        public NonNull(@NotNull A first, @NotNull B second) {
            if (first == null) {
                NonNull.$$$reportNull$$$0(0);
            }
            if (second == null) {
                NonNull.$$$reportNull$$$0(1);
            }
            super(first, second);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "first";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "second";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/Pair$NonNull";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

