"""Generated client library for biglake version delta_v1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.biglake.delta_v1 import biglake_delta_v1_messages as messages


class BiglakeDeltaV1(base_api.BaseApiClient):
  """Generated client library for service biglake version delta_v1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://biglake.googleapis.com/'
  MTLS_BASE_URL = 'https://biglake.mtls.googleapis.com/'

  _PACKAGE = 'biglake'
  _SCOPES = ['https://www.googleapis.com/auth/bigquery', 'https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'delta_v1'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'BiglakeDeltaV1'
  _URL_VERSION = 'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new biglake handle."""
    url = url or self.BASE_URL
    super(BiglakeDeltaV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.deltasharing_v1_projects_catalogs = self.DeltasharingV1ProjectsCatalogsService(self)
    self.deltasharing_v1_projects = self.DeltasharingV1ProjectsService(self)
    self.deltasharing_v1 = self.DeltasharingV1Service(self)
    self.deltasharing = self.DeltasharingService(self)

  class DeltasharingV1ProjectsCatalogsService(base_api.BaseApiService):
    """Service class for the deltasharing_v1_projects_catalogs resource."""

    _NAME = 'deltasharing_v1_projects_catalogs'

    def __init__(self, client):
      super(BiglakeDeltaV1.DeltasharingV1ProjectsCatalogsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new DeltaSharing catalog.

      Args:
        request: (BiglakeDeltasharingV1ProjectsCatalogsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DeltaSharingCatalog) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='deltasharing/v1/projects/{projectsId}/catalogs',
        http_method='POST',
        method_id='biglake.deltasharing.v1.projects.catalogs.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['deltaSharingCatalogId'],
        relative_path='deltasharing/v1/{+parent}/catalogs',
        request_field='deltaSharingCatalog',
        request_type_name='BiglakeDeltasharingV1ProjectsCatalogsCreateRequest',
        response_type_name='DeltaSharingCatalog',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an existing DeltaSharing catalog specified by the resource name.

      Args:
        request: (BiglakeDeltasharingV1ProjectsCatalogsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='deltasharing/v1/projects/{projectsId}/catalogs/{catalogsId}',
        http_method='DELETE',
        method_id='biglake.deltasharing.v1.projects.catalogs.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='deltasharing/v1/{+name}',
        request_field='',
        request_type_name='BiglakeDeltasharingV1ProjectsCatalogsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the catalog specified by the resource name.

      Args:
        request: (BiglakeDeltasharingV1ProjectsCatalogsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DeltaSharingCatalog) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='deltasharing/v1/projects/{projectsId}/catalogs/{catalogsId}',
        http_method='GET',
        method_id='biglake.deltasharing.v1.projects.catalogs.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='deltasharing/v1/{+name}',
        request_field='',
        request_type_name='BiglakeDeltasharingV1ProjectsCatalogsGetRequest',
        response_type_name='DeltaSharingCatalog',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List all DeltaSharing catalogs in a specified project.

      Args:
        request: (BiglakeDeltasharingV1ProjectsCatalogsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDeltaSharingCatalogsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='deltasharing/v1/projects/{projectsId}/catalogs',
        http_method='GET',
        method_id='biglake.deltasharing.v1.projects.catalogs.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='deltasharing/v1/{+parent}/catalogs',
        request_field='',
        request_type_name='BiglakeDeltasharingV1ProjectsCatalogsListRequest',
        response_type_name='ListDeltaSharingCatalogsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an existing DeltaSharing catalog.

      Args:
        request: (BiglakeDeltasharingV1ProjectsCatalogsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DeltaSharingCatalog) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='deltasharing/v1/projects/{projectsId}/catalogs/{catalogsId}',
        http_method='PATCH',
        method_id='biglake.deltasharing.v1.projects.catalogs.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='deltasharing/v1/{+name}',
        request_field='deltaSharingCatalog',
        request_type_name='BiglakeDeltasharingV1ProjectsCatalogsPatchRequest',
        response_type_name='DeltaSharingCatalog',
        supports_download=False,
    )

  class DeltasharingV1ProjectsService(base_api.BaseApiService):
    """Service class for the deltasharing_v1_projects resource."""

    _NAME = 'deltasharing_v1_projects'

    def __init__(self, client):
      super(BiglakeDeltaV1.DeltasharingV1ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

  class DeltasharingV1Service(base_api.BaseApiService):
    """Service class for the deltasharing_v1 resource."""

    _NAME = 'deltasharing_v1'

    def __init__(self, client):
      super(BiglakeDeltaV1.DeltasharingV1Service, self).__init__(client)
      self._upload_configs = {
          }

  class DeltasharingService(base_api.BaseApiService):
    """Service class for the deltasharing resource."""

    _NAME = 'deltasharing'

    def __init__(self, client):
      super(BiglakeDeltaV1.DeltasharingService, self).__init__(client)
      self._upload_configs = {
          }
