// Code generated by github.com/abhimanyu003/sttr/cmd/generate.go. DO NOT EDIT

package cmd

import (
	"fmt"
	"os"

	"github.com/abhimanyu003/sttr/processors"
	"github.com/abhimanyu003/sttr/utils"
	"github.com/spf13/cobra"
)

var (		
	escapeQuotes_flag_d bool		
	escapeQuotes_flag_s bool
)

func init() {	
	escapeQuotesCmd.Flags().BoolVarP(&escapeQuotes_flag_d, "double-quote", "d", true, "Escape double quote")	
	escapeQuotesCmd.Flags().BoolVarP(&escapeQuotes_flag_s, "single-quote", "s", true, "Escape single quote")
	rootCmd.AddCommand(escapeQuotesCmd)
}

var escapeQuotesCmd = &cobra.Command{
	Use:     "escape-quotes [string]",
	Short:   "Escapes single and double quotes by default",
	Aliases: []string{"esc-quotes", "escape-quotes"},
	Args:    cobra.MaximumNArgs(1),
	RunE: func(cmd *cobra.Command, args []string) error {
		var err error
		var out string

		flags := make([]processors.Flag, 0)
		p := processors.EscapeQuotes{}
		flags = append(flags, processors.Flag{Short: "d", Value: escapeQuotes_flag_d})
		flags = append(flags, processors.Flag{Short: "s", Value: escapeQuotes_flag_s})

		if len(args) == 0 {
			// Handle stdin/interactive input
			in := []byte(utils.ReadMultilineInput())
			out, err = p.Transform(in, flags...)
			if err != nil {
				return err
			}
		} else {
			// Check if it's a file
			if fi, err := os.Stat(args[0]); err == nil && !fi.IsDir() {
				// It's a file - check if we should use streaming
				const largeFileThreshold = 10 * 1024 * 1024 // 10MB
				
				// Use central streaming function for all processors
				if processors.CanStream(p) && (fi.Size() > largeFileThreshold || processors.PreferStream(p)) {
					// Use streaming
					file, err := os.Open(args[0])
					if err != nil {
						return err
					}
					defer file.Close()
					
					err = processors.TransformStream(p, file, os.Stdout, flags...)
					return err
				} else {
					// Use traditional method for small files
					d, err := os.ReadFile(args[0])
					if err != nil {
						return err
					}
					out, err = p.Transform(d, flags...)
					if err != nil {
						return err
					}
				}
			} else {
				// Not a file, treat as string input
				out, err = p.Transform([]byte(args[0]), flags...)
				if err != nil {
					return err
				}
			}
		}

		_, err = fmt.Fprint(os.Stdout, out)
		return err
	},
}
