<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw config`
Config management engine is common across all Scaleway developer tools (CLI, terraform, SDK, ... ). It allows to handle Scaleway config through two ways: environment variables and/or config file.
Default path for configuration file is based on the following priority order:

- $SCW_CONFIG_PATH
- $XDG_CONFIG_HOME/scw/config.yaml
- $HOME/.config/scw/config.yaml
- $USERPROFILE/.config/scw/config.yaml

In this CLI, environment variables have priority over the configuration file.

The following environment variables are supported:

|Environment Variable|Description|
|--|--|
|SCW_ACCESS_KEY|The access key of a token (create a token at https://console.scaleway.com/iam/api-keys)|
|SCW_SECRET_KEY|The secret key of a token (create a token at https://console.scaleway.com/iam/api-keys)|
|SCW_DEFAULT_ORGANIZATION_ID|The default organization ID (get your organization ID at https://console.scaleway.com/iam/api-keys)|
|SCW_DEFAULT_PROJECT_ID|The default project ID (get your project ID at https://console.scaleway.com/iam/api-keys)|
|SCW_DEFAULT_REGION|The default region|
|SCW_DEFAULT_ZONE|The default availability zone|
|SCW_API_URL|URL of the API|
|SCW_INSECURE|Set this to true to enable the insecure mode|
|SCW_PROFILE|Set the config profile to use|

Read more about the config management engine at https://github.com/scaleway/scaleway-sdk-go/tree/master/scw#scaleway-config
  
- [Destroy the config file](#destroy-the-config-file)
- [Dump the config file](#dump-the-config-file)
- [Edit the configuration file](#edit-the-configuration-file)
- [Get a value from the config file](#get-a-value-from-the-config-file)
- [Import configurations from another file](#import-configurations-from-another-file)
- [Get config values from the config file for the current profile](#get-config-values-from-the-config-file-for-the-current-profile)
- [Allows the activation and deletion of a profile from the config file](#allows-the-activation-and-deletion-of-a-profile-from-the-config-file)
  - [Mark a profile as active in the config file](#mark-a-profile-as-active-in-the-config-file)
  - [Delete a profile from the config file](#delete-a-profile-from-the-config-file)
  - [List all profiles in the config file](#list-all-profiles-in-the-config-file)
- [Reset the config](#reset-the-config)
- [Set a line from the config file](#set-a-line-from-the-config-file)
- [Unset a line from the config file](#unset-a-line-from-the-config-file)
- [Validate the config](#validate-the-config)

  
## Destroy the config file





**Usage:**

```
scw config destroy
```



## Dump the config file





**Usage:**

```
scw config dump
```



## Edit the configuration file

Edit the configuration file with the default editor

Edit the configuration file with the default editor

**Usage:**

```
scw config edit
```



## Get a value from the config file





**Usage:**

```
scw config get <key ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key | Required<br />One of: `access-key`, `secret-key`, `api-url`, `insecure`, `default-organization-id`, `default-project-id`, `default-region`, `default-zone`, `send-telemetry` | the key to get from the config |


**Examples:**


Get the default organization ID
```
scw config get default_organization_id
```

Get the default region of the profile 'prod'
```
scw -p prod config get default_region
```




## Import configurations from another file





**Usage:**

```
scw config import <file ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| file | Required | Path to the configuration file to import |



## Get config values from the config file for the current profile





**Usage:**

```
scw config info
```


**Examples:**


Get the default config values
```
scw config info
```

Get the config values of the profile 'prod'
```
scw -p prod config info
```




## Allows the activation and deletion of a profile from the config file




### Mark a profile as active in the config file



**Usage:**

```
scw config profile activate <profile-name ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| profile-name | Required |  |



### Delete a profile from the config file



**Usage:**

```
scw config profile delete <name ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Required |  |



### List all profiles in the config file



**Usage:**

```
scw config profile list
```



## Reset the config





**Usage:**

```
scw config reset
```



## Set a line from the config file

This commands overwrites the configuration file parameters with user input.
The only allowed attributes are access_key, secret_key, default_organization_id, default_region, default_zone, api_url, insecure

This commands overwrites the configuration file parameters with user input.
The only allowed attributes are access_key, secret_key, default_organization_id, default_region, default_zone, api_url, insecure

**Usage:**

```
scw config set [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| access-key |  | A Scaleway access key |
| secret-key |  | A Scaleway secret key |
| api-url |  | Scaleway API URL |
| insecure |  | Set to true to allow insecure HTTPS connections |
| default-organization-id |  | A default Scaleway organization id |
| default-project-id |  | A default Scaleway project id |
| default-region | One of: `fr-par`, `nl-ams`, `pl-waw` | A default Scaleway region |
| default-zone | One of: `fr-par-1`, `fr-par-2`, `fr-par-3`, `nl-ams-1`, `nl-ams-2`, `nl-ams-3`, `pl-waw-1`, `pl-waw-2`, `pl-waw-3` | A default Scaleway zone |
| send-telemetry |  | Set to false to disable telemetry |


**Examples:**


Update the default organization ID
```
scw config set default_organization_id=12903058-d0e8-4366-89c3-6e666abe1f6f
```

Update the default region of the profile 'prod'
```
scw -p prod config set default_region=nl-ams
```




## Unset a line from the config file





**Usage:**

```
scw config unset <key ...> [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| key | Required<br />One of: `access-key`, `secret-key`, `api-url`, `insecure`, `default-organization-id`, `default-project-id`, `default-region`, `default-zone`, `send-telemetry` | the config config key name to unset |



## Validate the config

This command validates the configuration of your Scaleway CLI tool.

It performs the following checks:

	- YAML syntax correctness: It checks whether your config file is a valid YAML file.
	- Field validity: It checks whether the fields present in the config file are valid and expected fields. This includes fields like AccessKey, SecretKey, DefaultOrganizationID, DefaultProjectID, DefaultRegion, DefaultZone, and APIURL.
	- Field values: For each of the fields mentioned above, it checks whether the value assigned to it is valid. For example, it checks if the AccessKey and SecretKey are non-empty and meet the format expectations.

The command goes through each profile present in the config file and validates it.

This command validates the configuration of your Scaleway CLI tool.

It performs the following checks:

	- YAML syntax correctness: It checks whether your config file is a valid YAML file.
	- Field validity: It checks whether the fields present in the config file are valid and expected fields. This includes fields like AccessKey, SecretKey, DefaultOrganizationID, DefaultProjectID, DefaultRegion, DefaultZone, and APIURL.
	- Field values: For each of the fields mentioned above, it checks whether the value assigned to it is valid. For example, it checks if the AccessKey and SecretKey are non-empty and meet the format expectations.

The command goes through each profile present in the config file and validates it.

**Usage:**

```
scw config validate
```



