// Copyright 2022 The CCGO Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package ccgo // import "modernc.org/ccgo/v4/lib"

var testExecKnownFails = map[string]struct{}{
	// ==== EXEC FAIL - compiles and builds but fails when executed.

	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20031003-1.c`:                                 {}, // EXEC FAIL: "assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20031003-1.c: libc_netbsd.go:1321:Xabort: TODOTODO "
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20101011-1.c`:                                 {}, // EXEC FAIL: "assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20101011-1.c: panic: runtime error: integer divide by zero"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/builtin-types-compatible-p.c`:                 {}, // EXEC FAIL: "assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/builtin-types-compatible-p.c: libc_netbsd.go:1321:Xabort: TODOTODO "
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/copysign1.c`:                             {}, // EXEC FAIL: "assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/copysign1.c: libc_netbsd.go:1321:Xabort: TODOTODO "
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/copysign2.c`:                             {}, // EXEC FAIL: "assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/copysign2.c: libc_netbsd.go:1321:Xabort: TODOTODO "
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20031003-1.c`:                 {}, // EXEC FAIL: "assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20031003-1.c: libc_netbsd.go:1321:Xabort: TODOTODO "
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20101011-1.c`:                 {}, // EXEC FAIL: "assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20101011-1.c: panic: runtime error: integer divide by zero"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/builtin-types-compatible-p.c`: {}, // EXEC FAIL: "assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/builtin-types-compatible-p.c: libc_netbsd.go:1321:Xabort: TODOTODO "
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/copysign1.c`:             {}, // EXEC FAIL: "assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/copysign1.c: libc_netbsd.go:1321:Xabort: TODOTODO "
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/copysign2.c`:             {}, // EXEC FAIL: "assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/copysign2.c: libc_netbsd.go:1321:Xabort: TODOTODO "

	// ==== BUILD FAIL - compiles but does not build.

	`assets/benchmarksgame-team.pages.debian.net/reverse-complement-4.c`: {}, // BUILD FAIL: "exit status 1"
	`assets/ccgo/bug/sqlite.c`: {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010122-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030128-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030323-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030811-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040308-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040411-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040709-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040709-2.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040709-3.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20060905-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20070614-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20080502-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20090113-2.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20090113-3.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20180921-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920728-1.c`:                          {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/950221-1.c`:                          {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/960405-1.c`:                          {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/991014-1.c`:                          {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/991112-1.c`:                          {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/align-nest.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/built-in-setjmp.c`:                   {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/builtin-bitops-1.c`:                  {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/cbrt.c`:                              {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/doloop-1.c`:                          {}, // BUILD FAIL: "exit status 2"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/frame-address.c`:                     {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/20010114-2.c`:                   {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/20030331-1.c`:                   {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/compare-fp-1.c`:                 {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4.c`:                     {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4f.c`:                    {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4l.c`:                    {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-5.c`:                     {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8.c`:                     {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8f.c`:                    {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8l.c`:                    {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/pr38016.c`:                      {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr17377.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr35456.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr37780.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr39228.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr42570.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr47237.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr53160.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr60003.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr66556.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr67037.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71631.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr79286.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr89195.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/strlen-6.c`:                          {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/va-arg-pack-1.c`:                     {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010122-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030128-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030323-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030811-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040308-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040411-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040709-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040709-2.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040709-3.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20060905-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20070614-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20080502-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20090113-2.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20090113-3.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20180921-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920728-1.c`:          {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/950221-1.c`:          {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/960405-1.c`:          {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/991014-1.c`:          {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/991112-1.c`:          {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/align-nest.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/built-in-setjmp.c`:   {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/builtin-bitops-1.c`:  {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/cbrt.c`:              {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/frame-address.c`:     {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/20010114-2.c`:   {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/20030331-1.c`:   {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/compare-fp-1.c`: {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4.c`:     {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4f.c`:    {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-4l.c`:    {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-5.c`:     {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8.c`:     {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8f.c`:    {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-8l.c`:    {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/pr38016.c`:      {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr17377.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr35456.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr37780.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr39228.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr42570.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr47237.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr53160.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr60003.c`:           {}, // BUILD FAIL: "exit status 1"

	// ==== COMPILE FAIL - does not compile.

	`assets/benchmarksgame-team.pages.debian.net/mandelbrot-3.c`:                                {}, // COMPILE FAIL: "\"mandelbrot-3.c:27:21: unsupported vector type: v2df (expr.go:537:expr0: expr.go:3905:primaryExpression: expr.go:4368:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:is..."
	`assets/benchmarksgame-team.pages.debian.net/mandelbrot-4.c`:                                {}, // COMPILE FAIL: "\"mandelbrot-4.c:19:21: unsupported vector type: v2df (expr.go:537:expr0: expr.go:3905:primaryExpression: expr.go:4368:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:is..."
	`assets/benchmarksgame-team.pages.debian.net/mandelbrot-8.c`:                                {}, // COMPILE FAIL: "\"mandelbrot-8.c:16:30: unsupported vector type: Vec (expr.go:1212:checkVolatileExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:1696:unaryExpression: type.go:407:isValidType: type.go:440:isValidType..."
	`assets/benchmarksgame-team.pages.debian.net/mandelbrot.c`:                                  {}, // COMPILE FAIL: "\"mandelbrot.c:23:15: unsupported vector type: v2df (expr.go:537:expr0: expr.go:3905:primaryExpression: expr.go:4368:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isVa..."
	`assets/benchmarksgame-team.pages.debian.net/nbody-4.c`:                                     {}, // COMPILE FAIL: "\"emmintrin.h:937:1: unsupported vector type: __m128d (stmt.go:48:statement: stmt.go:822:jumpStatement: decl.go:172:newAutovar: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/benchmarksgame-team.pages.debian.net/nbody-8.c`:                                     {}, // COMPILE FAIL: "\"nbody-8.c:119:24: unsupported vector type: __m128d (expr.go:535:expr0: expr.go:1970:postfixExpression: expr.go:1889:postfixExpressionIndex: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20000211-1.c`:                         {}, // COMPILE FAIL: "\"TODO (compile.go:433:compile: decl.go:297:externalDeclaration: decl.go:607:declaration: decl.go:746:initDeclarator: type.go:18:typedef: type.go:315:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20000326-2.c`:                         {}, // COMPILE FAIL: "\"20000326-2.c:7:3: label declarations not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:353:functionDefinition0: stmt.go:324:compoundState..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20000405-3.c`:                         {}, // COMPILE FAIL: "\"20000405-3.c:1:1: unsupported alignment 32 of struct foo {entry array of 40 pointer to void} (decl.go:297:externalDeclaration: decl.go:597:declaration: type.go:559:defineStructType: type.go:494:struc..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20000518-1.c`:                         {}, // COMPILE FAIL: "\"20000518-1.c:7:2: label declarations not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:353:functionDefinition0: stmt.go:324:compoundState..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20010202-1.c`:                         {}, // COMPILE FAIL: "\"20010202-1.c:3:5: incomplete type: array of array of char (decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:343:functionDefinition0: type.go:459:isValidType1: type.go:383:isVa..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20010226-1.c`:                         {}, // COMPILE FAIL: "\"20010226-1.c:16:12: nested functions not supported (stmt.go:360:blockItem: stmt.go:42:statement: stmt.go:392:selectionStatement: stmt.go:536:bracedStatement: stmt.go:545:unbracedStatement: stmt.go:36..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20010605-1.c`:                         {}, // COMPILE FAIL: "\"20010605-1.c:9:9: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStateme..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20010903-2.c`:                         {}, // COMPILE FAIL: "\"20010903-2.c:9:14: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20011023-1.c`:                         {}, // COMPILE FAIL: "\"20011023-1.c:8:8: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStateme..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20020309-1.c`:                         {}, // COMPILE FAIL: "\"20020309-1.c:8:5: nested functions not supported (decl.go:384:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:360:blockItem: stmt.go:26:statement: stmt.go:545:unbracedStatement: stmt.go:3..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20021108-1.c`:                         {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (expr.go:1192:additiveExpression: expr.go:1207:binopArgs: expr.go:1212:checkVolatileExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:1705:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20021204-1.c`:                         {}, // COMPILE FAIL: "\"20021204-1.c:8:7: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStateme..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030224-1.c`:                         {}, // COMPILE FAIL: "\"20030224-1.c:6:25: invalid type size: -1 (decl.go:384:functionDefinition0: stmt.go:261:compoundStatement: decl.go:236:declareLocals: type.go:42:typ: type.go:65:typ0: type.go:478:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030418-1.c`:                         {}, // COMPILE FAIL: "\"20030418-1.c:13:8: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030716-1.c`:                         {}, // COMPILE FAIL: "\"20030716-1.c:3:6: incomplete type: array of int (decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:343:functionDefinition0: type.go:459:isValidType1: type.go:383:isValidParamTy..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030903-1.c`:                         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:507:expr0: expr.go:3517:assignmentExpression: expr.go:101:expr: expr.go:543:expr0: expr.go:1731:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030910-1.c`:                         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:507:expr0: expr.go:3522:assignmentExpression: expr.go:101:expr: expr.go:543:expr0: expr.go:1731:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20031011-1.c`:                         {}, // COMPILE FAIL: "\"20031011-1.c:15:8: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040310-1.c`:                         {}, // COMPILE FAIL: "\"20040310-1.c:4:7: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStateme..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040317-1.c`:                         {}, // COMPILE FAIL: "\"20040317-1.c:1:5: incomplete type: array of array of char (decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:343:functionDefinition0: type.go:459:isValidType1: type.go:383:isVa..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040317-3.c`:                         {}, // COMPILE FAIL: "\"20040317-3.c:4:7: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStateme..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040323-1.c`:                         {}, // COMPILE FAIL: "\"20040323-1.c:10:16: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundState..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040614-1.c`:                         {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20050113-1.c`:                         {}, // COMPILE FAIL: "\"20050113-1.c:11:20: unsupported vector type: V2SF (expr.go:537:expr0: expr.go:3905:primaryExpression: expr.go:4368:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isVa..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20050119-1.c`:                         {}, // COMPILE FAIL: "\"20050119-1.c:7:8: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStateme..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20050122-2.c`:                         {}, // COMPILE FAIL: "\"20050122-2.c:10:3: label declarations not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:353:functionDefinition0: stmt.go:324:compoundStat..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20050510-1.c`:                         {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20070603-1.c`:                         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:1175:additiveExpression: expr.go:1207:binopArgs: expr.go:1212:checkVolatileExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:1731:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20070603-2.c`:                         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:1175:additiveExpression: expr.go:1207:binopArgs: expr.go:1212:checkVolatileExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:1731:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20070919-1.c`:                         {}, // COMPILE FAIL: "\"TODO exprUintptr (expr.go:101:expr: expr.go:543:expr0: expr.go:1619:unaryExpression: expr.go:101:expr: expr.go:535:expr0: expr.go:2133:postfixExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20090907-1.c`:                         {}, // COMPILE FAIL: "\"TODO (decl.go:297:externalDeclaration: decl.go:597:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263:typ0: type.go:315:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20110131-1.c`:                         {}, // COMPILE FAIL: "\"-: TODO (expr.go:1212:checkVolatileExpr: expr.go:101:expr: expr.go:519:expr0: expr.go:927:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20121107-1.c`:                         {}, // COMPILE FAIL: "\"-: TODO (expr.go:537:expr0: expr.go:3922:primaryExpression: expr.go:519:expr0: expr.go:927:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920301-1.c`:                           {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (init.go:265:initializerArray: init.go:93:initializer: expr.go:70:topExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:1705:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920415-1.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920428-3.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920501-1.c`:                           {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (init.go:265:initializerArray: init.go:93:initializer: expr.go:70:topExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:1705:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920501-7.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920502-1.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920826-1.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/920831-1.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/930118-1.c`:                           {}, // COMPILE FAIL: "\"930118-1.c:3:1: label declarations not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:353:functionDefinition0: stmt.go:324:compoundStateme..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/930506-2.c`:                           {}, // COMPILE FAIL: "\"930506-2.c:5:9: nested functions not supported (decl.go:384:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:360:blockItem: stmt.go:26:statement: stmt.go:545:unbracedStatement: stmt.go:363..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/941014-4.c`:                           {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (init.go:32:initializerOuter: init.go:93:initializer: expr.go:70:topExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:1705:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/950610-1.c`:                           {}, // COMPILE FAIL: "\"950610-1.c:1:1: incomplete type: array of array of int (decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:343:functionDefinition0: type.go:459:isValidType1: type.go:383:isValid..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/950613-1.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/950919-1.c`:                           {}, // COMPILE FAIL: "\"950919-1.c:2:10: assertions are a deprecated extension\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/951116-1.c`:                           {}, // COMPILE FAIL: "\"951116-1.c:7:7: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatement..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/981001-4.c`:                           {}, // COMPILE FAIL: "\"-: TODO (expr.go:537:expr0: expr.go:3922:primaryExpression: expr.go:519:expr0: expr.go:927:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/981006-1.c`:                           {}, // COMPILE FAIL: "\"981006-1.c:14:3: label declarations not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:353:functionDefinition0: stmt.go:324:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/981223-1.c`:                           {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:1280:equalityExpression: expr.go:1207:binopArgs: expr.go:1212:checkVolatileExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:1731:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/991213-1.c`:                           {}, // COMPILE FAIL: "\"TODO UnaryExpressionImag (expr.go:70:topExpr: expr.go:101:expr: expr.go:537:expr0: expr.go:3922:primaryExpression: expr.go:543:expr0: expr.go:1729:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/991213-3.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-1.c`:                          {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (expr.go:70:topExpr: expr.go:115:expr: expr.go:169:convert: expr.go:331:convertType: type.go:30:helper: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-2.c`:                          {}, // COMPILE FAIL: "\"TODO UnaryExpressionImag (expr.go:101:expr: expr.go:507:expr0: expr.go:3517:assignmentExpression: expr.go:101:expr: expr.go:543:expr0: expr.go:1729:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-3.c`:                          {}, // COMPILE FAIL: "\"TODO UnaryExpressionImag (expr.go:1175:additiveExpression: expr.go:1207:binopArgs: expr.go:1212:checkVolatileExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:1729:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-4.c`:                          {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:507:expr0: expr.go:3517:assignmentExpression: expr.go:101:expr: expr.go:543:expr0: expr.go:1731:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-5.c`:                          {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (expr.go:101:expr: expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4347:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-6.c`:                          {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (expr.go:101:expr: expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4347:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/ex.c`:                                 {}, // COMPILE FAIL: "\"ex.c:12:19: too few arguments to function 'foo', type 'function(int, int) returning int' in 'foo ()' (expr.go:3234:postfixExpressionCall: expr.go:70:topExpr: expr.go:101:expr: expr.go:535:expr0: expr..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/icfmatch.c`:                           {}, // COMPILE FAIL: "\"icfmatch.c:4:14: unsupported vector type: v4qi (expr.go:101:expr: expr.go:537:expr0: expr.go:3811:primaryExpression: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/labels-1.c`:                           {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (init.go:32:initializerOuter: init.go:93:initializer: expr.go:70:topExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:1705:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/labels-2.c`:                           {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (init.go:400:initializerStruct: init.go:93:initializer: expr.go:70:topExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:1705:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/labels-3.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/nested-1.c`:                           {}, // COMPILE FAIL: "\"nested-1.c:15:24: incomplete type: array of char (expr.go:101:expr: expr.go:543:expr0: expr.go:1672:unaryExpression: type.go:395:isValidType: type.go:407:isValidType: type.go:471:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/nested-2.c`:                           {}, // COMPILE FAIL: "\"nested-2.c:9:7: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatement..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/nested-3.c`:                           {}, // COMPILE FAIL: "\"nested-3.c:13:7: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatemen..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pass.c`:                               {}, // COMPILE FAIL: "\"pass.c:13:10: too many arguments to function 'foo', type 'function(int, int, int) returning int' in 'foo ((int) & q, q, w, e, q, (int) &w)' (stmt.go:841:jumpStatement: expr.go:1212:checkVolatileExpr:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pc44485.c`:                            {}, // COMPILE FAIL: "\"-: TODO (expr.go:1212:checkVolatileExpr: expr.go:101:expr: expr.go:519:expr0: expr.go:927:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr17913.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr18903.c`:                            {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (stmt.go:360:blockItem: stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:1705:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr21356.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr21728.c`:                            {}, // COMPILE FAIL: "\"pr21728.c:5:3: label declarations not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:353:functionDefinition0: stmt.go:324:compoundStatemen..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr22422.c`:                            {}, // COMPILE FAIL: "\"TODO pr22422.c:27:3: from pointer to int, exprUintptr to pointer to int exprVoid, src '&d->c [d->n]', buf '((((aad))+4)+(((ppuintptr(((*tsD)(iqunsafe.ppPointer((aad))).fdn))))*4))' (stmt.go:360:block..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr25224.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr27341-1.c`:                          {}, // COMPILE FAIL: "\"TODO UnaryExpressionImag (expr.go:101:expr: expr.go:507:expr0: expr.go:3517:assignmentExpression: expr.go:101:expr: expr.go:543:expr0: expr.go:1729:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr27863.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr27889.c`:                            {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:382:functionDefinition0: decl.go:571:signature: type.go:48:typ2: type.go:15..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr28489.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr29128.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr30984.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr32919.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr33382.c`:                            {}, // COMPILE FAIL: "\"-: TODO (expr.go:537:expr0: expr.go:3922:primaryExpression: expr.go:519:expr0: expr.go:927:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr33617.c`:                            {}, // COMPILE FAIL: "\".: unsupported vector type: V8SF (asm_amd64.s:1650:goexit: asm_amd64.s:1650:goexit: compile.go:481:compile: decl.go:532:signature: type.go:383:isValidParamType: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr34334.c`:                            {}, // COMPILE FAIL: "\"TODO (compile.go:433:compile: decl.go:297:externalDeclaration: decl.go:607:declaration: decl.go:746:initDeclarator: type.go:18:typedef: type.go:315:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr34856.c`:                            {}, // COMPILE FAIL: "\"pr34856.c:11:16: unsupported vector type: VU32 (expr.go:115:expr: expr.go:169:convert: expr.go:329:convertType: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr35006.c`:                            {}, // COMPILE FAIL: "\"pr35006.c:9:8: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatement:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr35431.c`:                            {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (expr.go:101:expr: expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4347:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr38360.c`:                            {}, // COMPILE FAIL: "\"pr38360.c:7:3: too few arguments to function 'fputs', type 'function(pointer to const char, pointer to void) returning int' in 'fputs (\\\"\\\")' (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:ex..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr38771.c`:                            {}, // COMPILE FAIL: "\"-: TODO (expr.go:537:expr0: expr.go:3922:primaryExpression: expr.go:519:expr0: expr.go:927:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr40233.c`:                            {}, // COMPILE FAIL: "\"pr40233.c:2:1: unsupported alignment 64 of struct Frame {i aligned} (decl.go:297:externalDeclaration: decl.go:597:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:65:typ0..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr41987.c`:                            {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex char _Complex char (expr.go:101:expr: expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4347:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42196-1.c`:                          {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:297:externalDeclaration: decl.go:599:declaration: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:312:typ0: type.go:159:typ0:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42196-2.c`:                          {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:297:externalDeclaration: decl.go:599:declaration: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:323:typ0: type.go:159:typ0:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42196-3.c`:                          {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:297:externalDeclaration: decl.go:599:declaration: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:323:typ0: type.go:159:typ0:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42559.c`:                            {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (init.go:32:initializerOuter: init.go:93:initializer: expr.go:70:topExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:1705:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42716.c`:                            {}, // COMPILE FAIL: "\"-: TODO (expr.go:1212:checkVolatileExpr: expr.go:101:expr: expr.go:519:expr0: expr.go:927:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42717.c`:                            {}, // COMPILE FAIL: "\"-: TODO (expr.go:1212:checkVolatileExpr: expr.go:101:expr: expr.go:519:expr0: expr.go:927:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr44119.c`:                            {}, // COMPILE FAIL: "\"-: TODO (expr.go:1212:checkVolatileExpr: expr.go:101:expr: expr.go:519:expr0: expr.go:927:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr46107.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr47428.c`:                            {}, // COMPILE FAIL: "\"pr47428.c:24:3: too few arguments to function 'fn', type 'function(const int, int) returning int' in 'fn (0)' (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:535:expr0: expr.go:2..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr48641.c`:                            {}, // COMPILE FAIL: "\"TODO \\\"(X__builtin_modfl(cgtls, (iqlibc.ppFloat64FromFloat64(1.5)), cgbp) != (*(*ppfloat64)(iqunsafe.ppPointer(cgbp))))\\\" int exprBool -> long double exprDefault (expr.go:521:expr0: expr.go:1283:equa..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr51354.c`:                            {}, // COMPILE FAIL: "\"pr51354.c:15:6: unsupported alignment 32 of ai (decl.go:384:functionDefinition0: stmt.go:261:compoundStatement: decl.go:227:declareLocals: type.go:42:typ: type.go:65:typ0: type.go:426:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr51495.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr51694.c`:                            {}, // COMPILE FAIL: "\"pr51694.c:14:3: too few arguments to function 'foo', type 'function(int, pointer to function())' in 'foo (x)' (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:535:expr0: expr.go:2..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr52750.c`:                            {}, // COMPILE FAIL: "\"pr52750.c:8:11: unsupported vector type: V (expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4347:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr53410-2.c`:                          {}, // COMPILE FAIL: "\"pr53410-2.c:9:3: unsupported vector type: V (expr.go:101:expr: expr.go:543:expr0: expr.go:1619:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr53748.c`:                            {}, // COMPILE FAIL: "\"pr53748.c:8:3: unsupported vector type: V (expr.go:101:expr: expr.go:543:expr0: expr.go:1619:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr54713-1.c`:                          {}, // COMPILE FAIL: "\"pr54713-1.c:15:3: unsupported vector type: V (expr.go:101:expr: expr.go:543:expr0: expr.go:1619:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr54713-2.c`:                          {}, // COMPILE FAIL: "\"pr54713-1.c:15:3: unsupported vector type: V (expr.go:101:expr: expr.go:543:expr0: expr.go:1619:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr54713-3.c`:                          {}, // COMPILE FAIL: "\"pr54713-1.c:15:3: unsupported vector type: V (expr.go:101:expr: expr.go:543:expr0: expr.go:1619:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr56571.c`:                            {}, // COMPILE FAIL: "\"-: TODO (expr.go:537:expr0: expr.go:3922:primaryExpression: expr.go:519:expr0: expr.go:927:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr58164.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr60502.c`:                            {}, // COMPILE FAIL: "\"pr60502.c:9:16: unsupported vector type: v16i8 (expr.go:115:expr: expr.go:169:convert: expr.go:329:convertType: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr70190.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr70199.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr70633.c`:                            {}, // COMPILE FAIL: "\"pr70633.c:10:5: unsupported vector type: V (decl.go:384:functionDefinition0: stmt.go:261:compoundStatement: decl.go:227:declareLocals: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr70916.c`:                            {}, // COMPILE FAIL: "\"-: TODO (expr.go:3522:assignmentExpression: expr.go:101:expr: expr.go:519:expr0: expr.go:927:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr71109.c`:                            {}, // COMPILE FAIL: "\"pr71109.c:15:7: too few arguments to function 'foo', type 'function(int, struct S, struct T)' in 'foo (bar, a)' (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:535:expr0: expr.go..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-1.c`:                          {}, // COMPILE FAIL: "\"pr77754-1.c:5:13: incomplete type: array of array of int (asm_amd64.s:1650:goexit: asm_amd64.s:1650:goexit: compile.go:481:compile: decl.go:532:signature: type.go:383:isValidParamType: type.go:471:is..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-2.c`:                          {}, // COMPILE FAIL: "\"pr77754-2.c:5:6: incomplete type: array of array of int (type.go:658:defineType0: type.go:658:defineType0: type.go:646:defineType0: type.go:459:isValidType1: type.go:383:isValidParamType: type.go:471..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-3.c`:                          {}, // COMPILE FAIL: "\"pr77754-3.c:5:14: incomplete type: array of array of int (type.go:642:defineType: type.go:658:defineType0: type.go:646:defineType0: type.go:459:isValidType1: type.go:383:isValidParamType: type.go:471..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-4.c`:                          {}, // COMPILE FAIL: "\"pr77754-4.c:5:14: incomplete type: array of array of int (type.go:642:defineType: type.go:658:defineType0: type.go:646:defineType0: type.go:459:isValidType1: type.go:383:isValidParamType: type.go:471..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-5.c`:                          {}, // COMPILE FAIL: "\"pr77754-5.c:6:6: incomplete type: array of array of int (decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:343:functionDefinition0: type.go:459:isValidType1: type.go:383:isVali..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr82052.c`:                            {}, // COMPILE FAIL: "\"-: TODO (expr.go:1212:checkVolatileExpr: expr.go:101:expr: expr.go:519:expr0: expr.go:927:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr82564.c`:                            {}, // COMPILE FAIL: "\"pr82564.c:9:5: invalid type size: -1 (decl.go:384:functionDefinition0: stmt.go:261:compoundStatement: decl.go:236:declareLocals: type.go:42:typ: type.go:65:typ0: type.go:478:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr84136.c`:                            {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (expr.go:507:expr0: expr.go:3476:assignmentExpression: expr.go:1212:checkVolatileExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:1705:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr84305.c`:                            {}, // COMPILE FAIL: "\"pr84305.c:3:34: TODO (expr.go:1887:postfixExpressionIndex: expr.go:101:expr: expr.go:535:expr0: expr.go:1970:postfixExpression: expr.go:1803:postfixExpressionIndex: expr.go:1753:mul:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr84960.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr85704.c`:                            {}, // COMPILE FAIL: "\"pr85704.c:9:26: TODO \\\"tsC{}\\\" from=struct C {c struct {}} struct 0 exprDefault -> to=struct D {d int; e struct C; f int} struct 8 exprDefault (pr85704.c:9:26:) (expr.go:535:expr0: expr.go:2243:postf..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr85945.c`:                            {}, // COMPILE FAIL: "\"pr85945.c:4:1: unsupported vector type: V (decl.go:599:declaration: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:323:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr86122.c`:                            {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (expr.go:101:expr: expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4347:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr86123.c`:                            {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex unsigned _Complex unsigned (expr.go:101:expr: expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4347:primaryExpressionIntConst: type.go:30:helper: type.go:15..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr89655.c`:                            {}, // COMPILE FAIL: "\"-: TODO (expr.go:537:expr0: expr.go:3922:primaryExpression: expr.go:519:expr0: expr.go:927:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr90139.c`:                            {}, // COMPILE FAIL: "\"pr90139.c:10:5: unsupported vector type: V (decl.go:384:functionDefinition0: stmt.go:261:compoundStatement: decl.go:236:declareLocals: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-1.c`:                             {}, // COMPILE FAIL: "\"simd-1.c:5:16: unsupported vector type: v2si (expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4330:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-2.c`:                             {}, // COMPILE FAIL: "\"simd-2.c:14:9: unsupported vector type: floatvect2 (expr.go:535:expr0: expr.go:2060:postfixExpression: expr.go:2623:postfixExpressionSelect: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-3.c`:                             {}, // COMPILE FAIL: "\"simd-3.c:19:9: unsupported vector type: floatvect2 (expr.go:535:expr0: expr.go:2060:postfixExpression: expr.go:2623:postfixExpressionSelect: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-4.c`:                             {}, // COMPILE FAIL: "\"simd-4.c:11:26: unsupported vector type: floatvect2 (expr.go:101:expr: expr.go:543:expr0: expr.go:1619:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-6.c`:                             {}, // COMPILE FAIL: "\"simd-6.c:5:11: unsupported vector type: vec (init.go:110:initializer: init.go:195:initializerArray: type.go:42:typ: type.go:337:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/sra-1.c`:                              {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:1309:relationExpression: expr.go:1207:binopArgs: expr.go:1212:checkVolatileExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:1731:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/struct-non-lval-2.c`:                  {}, // COMPILE FAIL: "\"TODO assertion failed (expr.go:101:expr: expr.go:535:expr0: expr.go:2060:postfixExpression: expr.go:2721:postfixExpressionSelect: expr.go:115:expr: expr.go:131:convert:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/struct-non-lval-3.c`:                  {}, // COMPILE FAIL: "\"TODO exprUintptr (expr.go:2721:postfixExpressionSelect: expr.go:101:expr: expr.go:537:expr0: expr.go:3922:primaryExpression: expr.go:507:expr0: expr.go:3527:assignmentExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/uuarg.c`:                              {}, // COMPILE FAIL: "\"uuarg.c:4:10: too few arguments to function 'foo', type 'function(int, int, int, int, int, int, int, int, int) returning int' in 'foo ()' (expr.go:1207:binopArgs: expr.go:1212:checkVolatileExpr: expr..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-1.c`:                           {}, // COMPILE FAIL: "\"vector-1.c:3:1: unsupported vector type: float (decl.go:597:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-2.c`:                           {}, // COMPILE FAIL: "\"vector-2.c:3:1: unsupported vector type: float (decl.go:597:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-4.c`:                           {}, // COMPILE FAIL: "\"vector-4.c:7:47: unsupported vector type: signed char (decl.go:297:externalDeclaration: decl.go:607:declaration: decl.go:776:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-align-1.c`:                     {}, // COMPILE FAIL: "\"vector-align-1.c:11:6: unsupported alignment 128 of char (decl.go:297:externalDeclaration: decl.go:607:declaration: decl.go:776:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:426:isValidTyp..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20000822-1.c`:                         {}, // COMPILE FAIL: "\"20000822-1.c:12:7: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010209-1.c`:                         {}, // COMPILE FAIL: "\"20010209-1.c:6:7: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStateme..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010605-1.c`:                         {}, // COMPILE FAIL: "\"20010605-1.c:5:14: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010605-2.c`:                         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:507:expr0: expr.go:3517:assignmentExpression: expr.go:101:expr: expr.go:543:expr0: expr.go:1731:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010904-1.c`:                         {}, // COMPILE FAIL: "\"20010904-1.c:12:3: unsupported alignment 32 of Y (decl.go:607:declaration: decl.go:776:initDeclarator: type.go:42:typ: type.go:337:typ0: type.go:65:typ0: type.go:426:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010904-2.c`:                         {}, // COMPILE FAIL: "\"20010904-2.c:12:3: unsupported alignment 32 of Y (decl.go:607:declaration: decl.go:776:initDeclarator: type.go:42:typ: type.go:337:typ0: type.go:65:typ0: type.go:426:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20020411-1.c`:                         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:507:expr0: expr.go:3517:assignmentExpression: expr.go:101:expr: expr.go:543:expr0: expr.go:1731:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20020412-1.c`:                         {}, // COMPILE FAIL: "\"20020412-1.c:31:7: invalid type size: -1 (expr.go:3922:primaryExpression: expr.go:543:expr0: expr.go:1600:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:478:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030330-1.c`:                         {}, // COMPILE FAIL: "20030330-1.o.go:26:4: undefined: \"link_error\" external (all_test.go:437:1: all_test.go:524:testExec1: ccgo.go:186:Main: ccgo.go:597:main: link.go:302:link: link.go:826:link:) (all_test.go:437:1: all_t..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030501-1.c`:                         {}, // COMPILE FAIL: "\"20030501-1.c:7:9: nested functions not supported (decl.go:384:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:360:blockItem: stmt.go:26:statement: stmt.go:545:unbracedStatement: stmt.go:3..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030910-1.c`:                         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:1571:unaryExpression: expr.go:101:expr: expr.go:537:expr0: expr.go:3922:primaryExpression: expr.go:543:expr0: expr.go:1731:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040302-1.c`:                         {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040423-1.c`:                         {}, // COMPILE FAIL: "\"20040423-1.c:13:22: incomplete type: array of int (expr.go:101:expr: expr.go:543:expr0: expr.go:1696:unaryExpression: type.go:395:isValidType: type.go:407:isValidType: type.go:471:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040520-1.c`:                         {}, // COMPILE FAIL: "\"20040520-1.c:6:13: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20041124-1.c`:                         {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex unsigned short _Complex unsigned short (decl.go:297:externalDeclaration: decl.go:597:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20041201-1.c`:                         {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex char _Complex char (decl.go:297:externalDeclaration: decl.go:607:declaration: decl.go:746:initDeclarator: type.go:18:typedef: type.go:263:typ0: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20041214-1.c`:                         {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20041218-2.c`:                         {}, // COMPILE FAIL: "\"20041218-2.c:7:17: incomplete type: array of char (expr.go:101:expr: expr.go:543:expr0: expr.go:1696:unaryExpression: type.go:395:isValidType: type.go:407:isValidType: type.go:471:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050121-1.c`:                         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:507:expr0: expr.go:3517:assignmentExpression: expr.go:101:expr: expr.go:543:expr0: expr.go:1731:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050316-1.c`:                         {}, // COMPILE FAIL: "\"20050316-1.c:15:29: unsupported vector type: V2SI (expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4347:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidTy..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050316-2.c`:                         {}, // COMPILE FAIL: "\"20050316-2.c:38:14: unsupported vector type: V2SF (expr.go:537:expr0: expr.go:3905:primaryExpression: expr.go:4368:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isVa..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050316-3.c`:                         {}, // COMPILE FAIL: "\"20050316-3.c:29:3: unsupported vector type: V2USI (expr.go:535:expr0: expr.go:2060:postfixExpression: expr.go:2623:postfixExpressionSelect: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050604-1.c`:                         {}, // COMPILE FAIL: "\"20050604-1.c:16:3: unsupported vector type: v4hi (decl.go:607:declaration: decl.go:776:initDeclarator: type.go:42:typ: type.go:323:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050607-1.c`:                         {}, // COMPILE FAIL: "\"20050607-1.c:12:32: unsupported vector type: V2SI (expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4330:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isVali..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20060420-1.c`:                         {}, // COMPILE FAIL: "\"20060420-1.c:8:19: unsupported vector type: v4flt (expr.go:1212:checkVolatileExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:1696:unaryExpression: type.go:407:isValidType: type.go:440:isValidType1..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20070919-1.c`:                         {}, // COMPILE FAIL: "\"20070919-1.c:31:7: invalid type size: -1 (expr.go:537:expr0: expr.go:3935:primaryExpression: decl.go:172:newAutovar: type.go:42:typ: type.go:65:typ0: type.go:478:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20071210-1.c`:                         {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20090219-1.c`:                         {}, // COMPILE FAIL: "\"20090219-1.c:12:8: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20171008-1.c`:                         {}, // COMPILE FAIL: "\"20171008-1.c:16:1: unsupported alignment 4 of function(void) returning struct S (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920302-1.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920415-1.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920428-2.c`:                           {}, // COMPILE FAIL: "\"920428-2.c:4:14: label declarations not supported (stmt.go:360:blockItem: stmt.go:42:statement: stmt.go:392:selectionStatement: stmt.go:536:bracedStatement: stmt.go:545:unbracedStatement: stmt.go:358..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920501-3.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920501-4.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920501-5.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920501-7.c`:                           {}, // COMPILE FAIL: "\"920501-7.c:13:3: label declarations not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:353:functionDefinition0: stmt.go:324:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920612-2.c`:                           {}, // COMPILE FAIL: "\"920612-2.c:6:7: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatement..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/920721-4.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/921017-1.c`:                           {}, // COMPILE FAIL: "\"921017-1.c:7:7: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatement..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/921215-1.c`:                           {}, // COMPILE FAIL: "\"921215-1.c:5:8: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatement..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/930406-1.c`:                           {}, // COMPILE FAIL: "\"TODO *cc.LabelDeclaration (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/931002-1.c`:                           {}, // COMPILE FAIL: "\"931002-1.c:10:8: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatemen..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/960416-1.c`:                           {}, // COMPILE FAIL: "\"960416-1.c:57:23: helper: unsupported type: t_be (expr.go:1109:castExpression: expr.go:101:expr: expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4347:primaryExpressionIntConst: type.go:28:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/970217-1.c`:                           {}, // COMPILE FAIL: "\"970217-1.c:1:1: incomplete type: array of int (decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:343:functionDefinition0: type.go:459:isValidType1: type.go:383:isValidParamType..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/980526-1.c`:                           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/980929-1.c`:                           {}, // COMPILE FAIL: "\"TODO 980929-1.c:17:5: from pointer to int, exprUintptr to pointer to int exprVoid, src '&n', buf 'ppuintptr(iqunsafe.ppPointer(&(aan)))' (stmt.go:360:blockItem: stmt.go:38:statement: expr.go:70:topEx..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/990208-1.c`:                           {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (expr.go:101:expr: expr.go:507:expr0: expr.go:3522:assignmentExpression: expr.go:101:expr: expr.go:543:expr0: expr.go:1705:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/align-3.c`:                            {}, // COMPILE FAIL: "\"align-3.c:5:6: unsupported alignment 256 of function(void) (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:343:functionDefin..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/builtin-prefetch-3.c`:                 {}, // COMPILE FAIL: "\"TODO exprUintptr (expr.go:543:expr0: expr.go:1571:unaryExpression: expr.go:101:expr: expr.go:535:expr0: expr.go:2060:postfixExpression: expr.go:2702:postfixExpressionSelect:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/comp-goto-1.c`:                        {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/comp-goto-2.c`:                        {}, // COMPILE FAIL: "\"comp-goto-2.c:15:3: label declarations not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:353:functionDefinition0: stmt.go:324:compoundSta..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/complex-1.c`:                          {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:2057:postfixExpression: expr.go:3234:postfixExpressionCall: expr.go:70:topExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:1731:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/complex-6.c`:                          {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:382:functionDefinition0: decl.go:550:signature: type.go:48:typ2: type.go:15..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/complex-7.c`:                          {}, // COMPILE FAIL: "\"TODO 2.2iL *cc.ComplexLongDoubleValue from=_Complex long t=long double mode=exprDefault (expr.go:1207:binopArgs: expr.go:1212:checkVolatileExpr: expr.go:101:expr: expr.go:537:expr0: expr.go:3905:prim..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/fprintf-2.c`:                          {}, // COMPILE FAIL: "fprintf-2.o.go:496:15: undefined: \"tmpnam\" external (all_test.go:437:1: all_test.go:524:testExec1: ccgo.go:186:Main: ccgo.go:597:main: link.go:302:link: link.go:826:link:) (all_test.go:437:1: all_test..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-7.c`:                      {}, // COMPILE FAIL: "fp-cmp-7.o.go:19:3: undefined: \"link_error\" external (all_test.go:437:1: all_test.go:524:testExec1: ccgo.go:186:Main: ccgo.go:597:main: link.go:302:link: link.go:826:link:) (all_test.go:437:1: all_tes..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/mzero4.c`:                        {}, // COMPILE FAIL: "mzero4.o.go:51:18: undefined: \"tanf\" external (all_test.go:437:1: all_test.go:524:testExec1: ccgo.go:186:Main: ccgo.go:597:main: link.go:302:link: link.go:826:link:)"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/pr72824-2.c`:                     {}, // COMPILE FAIL: "\"pr72824-2.c:17:17: unsupported vector type: V (expr.go:537:expr0: expr.go:3905:primaryExpression: expr.go:4378:primaryExpressionFloatConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidType..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/medce-1.c`:                            {}, // COMPILE FAIL: "medce-1.o.go:38:2: undefined: \"link_error\" external (all_test.go:437:1: all_test.go:524:testExec1: ccgo.go:186:Main: ccgo.go:597:main: link.go:302:link: link.go:826:link:) (all_test.go:437:1: all_test..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nest-align-1.c`:                       {}, // COMPILE FAIL: "\"nest-align-1.c:25:8: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStat..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nest-stdar-1.c`:                       {}, // COMPILE FAIL: "\"nest-stdar-1.c:5:10: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStat..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-1.c`:                         {}, // COMPILE FAIL: "\"nestfunc-1.c:15:7: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-2.c`:                         {}, // COMPILE FAIL: "\"nestfunc-2.c:13:7: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-3.c`:                         {}, // COMPILE FAIL: "\"nestfunc-3.c:12:8: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-5.c`:                         {}, // COMPILE FAIL: "\"nestfunc-5.c:8:3: label declarations not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:353:functionDefinition0: stmt.go:324:compoundState..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-6.c`:                         {}, // COMPILE FAIL: "\"nestfunc-6.c:13:3: label declarations not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:353:functionDefinition0: stmt.go:324:compoundStat..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-7.c`:                         {}, // COMPILE FAIL: "\"nestfunc-7.c:15:12: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundState..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr22061-1.c`:                          {}, // COMPILE FAIL: "\"pr22061-1.c:4:6: incomplete type: array of array of char (decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:343:functionDefinition0: type.go:459:isValidType1: type.go:383:isVal..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr22061-2.c`:                          {}, // COMPILE FAIL: "\"pr22061-2.c:2:13: incomplete type: array of array of char (decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:343:functionDefinition0: type.go:459:isValidType1: type.go:383:isVa..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr22061-3.c`:                          {}, // COMPILE FAIL: "\"pr22061-3.c:4:7: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatemen..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr22061-4.c`:                          {}, // COMPILE FAIL: "\"pr22061-4.c:5:8: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatemen..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr23135.c`:                            {}, // COMPILE FAIL: "\"pr23135.c:19:14: unsupported vector type: vecint (expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4330:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValid..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr23324.c`:                            {}, // COMPILE FAIL: "\"TODO (decl.go:831:initDeclarator: type.go:642:defineType: type.go:656:defineType0: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:315:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr23467.c`:                            {}, // COMPILE FAIL: "\"pr23467.c:3:1: unsupported alignment 8 of int (decl.go:597:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263:typ0: type.go:65:typ0: type.go:426:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr24135.c`:                            {}, // COMPILE FAIL: "\"pr24135.c:7:3: label declarations not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:353:functionDefinition0: stmt.go:324:compoundStatemen..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr34154.c`:                            {}, // COMPILE FAIL: "\"TODO SelectionStatementSwitch (decl.go:353:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:360:blockItem: stmt.go:42:statement: stmt.go:444:selectionStatement: stmt.go:512:selectionStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr36093.c`:                            {}, // COMPILE FAIL: "\"pr36093.c:13:5: unsupported alignment 128 of Foo (decl.go:607:declaration: decl.go:776:initDeclarator: type.go:42:typ: type.go:337:typ0: type.go:65:typ0: type.go:426:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr38151.c`:                            {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:297:externalDeclaration: decl.go:597:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263:typ0: type.go:159:typ..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr38969.c`:                            {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:507:expr0: expr.go:3517:assignmentExpression: expr.go:101:expr: expr.go:543:expr0: expr.go:1731:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr41935.c`:                            {}, // COMPILE FAIL: "\"pr41935.c:10:10: TODO (expr.go:1919:postfixExpressionIndex: expr.go:101:expr: expr.go:535:expr0: expr.go:1970:postfixExpression: expr.go:1803:postfixExpressionIndex: expr.go:1753:mul:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr43783.c`:                            {}, // COMPILE FAIL: "\"pr43783.c:8:9: unsupported alignment 16 of UINT192 (decl.go:607:declaration: decl.go:776:initDeclarator: type.go:42:typ: type.go:337:typ0: type.go:65:typ0: type.go:426:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr49218.c`:                            {}, // COMPILE FAIL: "\"pr49218.c:11:9: unsupported alignment 16 of L (expr.go:101:expr: expr.go:537:expr0: expr.go:3811:primaryExpression: type.go:60:verifyTyp: type.go:65:typ0: type.go:426:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr51447.c`:                            {}, // COMPILE FAIL: "\"pr51447.c:16:3: label declarations not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:353:functionDefinition0: stmt.go:324:compoundStateme..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr53645-2.c`:                          {}, // COMPILE FAIL: "\"pr53645-2.c:41:1: unsupported vector type: UV (expr.go:101:expr: expr.go:543:expr0: expr.go:1619:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr53645.c`:                            {}, // COMPILE FAIL: "\"pr53645.c:41:1: unsupported vector type: UV (expr.go:101:expr: expr.go:543:expr0: expr.go:1619:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr54471.c`:                            {}, // COMPILE FAIL: "\"pr54471.c:13:1: unsupported alignment 16 of unsigned __int128 (decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:343:functionDefinition0: type.go:454:isValidType1: type.go:407:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr56837.c`:                            {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:297:externalDeclaration: decl.go:607:declaration: decl.go:776:initDeclarator: type.go:42:typ: type.go:337:typ0: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr60960.c`:                            {}, // COMPILE FAIL: "\"pr60960.c:26:14: unsupported vector type: v4qi (expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4336:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidTy..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr61375.c`:                            {}, // COMPILE FAIL: "\"pr61375.c:15:1: unsupported alignment 16 of unsigned __int128 (decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:343:functionDefinition0: type.go:459:isValidType1: type.go:383:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr63302.c`:                            {}, // COMPILE FAIL: "\"pr63302.c:14:1: unsupported alignment 16 of __int128 (decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:343:functionDefinition0: type.go:459:isValidType1: type.go:383:isValidPa..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr65170.c`:                            {}, // COMPILE FAIL: "\"pr65170.c:12:1: unsupported alignment 16 of V (decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:343:functionDefinition0: type.go:459:isValidType1: type.go:383:isValidParamType..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr65427.c`:                            {}, // COMPILE FAIL: "\"pr65427.c:4:3: unsupported vector type: V (decl.go:297:externalDeclaration: decl.go:607:declaration: decl.go:776:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr68249.c`:                            {}, // COMPILE FAIL: "\"-: TODO (expr.go:3522:assignmentExpression: expr.go:101:expr: expr.go:519:expr0: expr.go:927:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr68381.c`:                            {}, // COMPILE FAIL: "\"TODO unsigned short * unsigned short -> int (stmt.go:42:statement: stmt.go:391:selectionStatement: expr.go:101:expr: expr.go:535:expr0: expr.go:2029:postfixExpression: expr.go:2282:mulOverflow:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr70460.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr70903.c`:                            {}, // COMPILE FAIL: "\"TODO (expr.go:3234:postfixExpressionCall: expr.go:70:topExpr: expr.go:101:expr: expr.go:535:expr0: expr.go:2243:postfixExpression: init.go:60:initializer:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71494.c`:                            {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71554.c`:                            {}, // COMPILE FAIL: "\"TODO unsigned * int -> int (stmt.go:42:statement: stmt.go:391:selectionStatement: expr.go:101:expr: expr.go:535:expr0: expr.go:2029:postfixExpression: expr.go:2282:mulOverflow:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71626-1.c`:                          {}, // COMPILE FAIL: "\"TODO PostfixExpressionIndex (expr.go:1283:equalityExpression: expr.go:1207:binopArgs: expr.go:1212:checkVolatileExpr: expr.go:101:expr: expr.go:535:expr0: expr.go:1977:postfixExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71626-2.c`:                          {}, // COMPILE FAIL: "\"TODO PostfixExpressionIndex (expr.go:1283:equalityExpression: expr.go:1207:binopArgs: expr.go:1212:checkVolatileExpr: expr.go:101:expr: expr.go:535:expr0: expr.go:1977:postfixExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr77767.c`:                            {}, // COMPILE FAIL: "\"pr77767.c:4:1: incomplete type: array of int (decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:343:functionDefinition0: type.go:459:isValidType1: type.go:383:isValidParamType:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr82210.c`:                            {}, // COMPILE FAIL: "\"pr82210.c:14:5: unsupported alignment 16 of struct T {c short} (expr.go:535:expr0: expr.go:1970:postfixExpression: expr.go:1887:postfixExpressionIndex: type.go:42:typ: type.go:65:typ0: type.go:426:is..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr84169.c`:                            {}, // COMPILE FAIL: "\"pr84169.c:9:3: unsupported alignment 16 of T (decl.go:297:externalDeclaration: decl.go:607:declaration: decl.go:776:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:426:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr84748.c`:                            {}, // COMPILE FAIL: "\"pr84748.c:6:6: unsupported alignment 16 of u128 (decl.go:297:externalDeclaration: decl.go:607:declaration: decl.go:776:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:426:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr85169.c`:                            {}, // COMPILE FAIL: "\"pr85169.c:8:9: unsupported vector type: V (expr.go:101:expr: expr.go:543:expr0: expr.go:1619:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr85331.c`:                            {}, // COMPILE FAIL: "\"pr85331.c:9:11: unsupported vector type: V (expr.go:537:expr0: expr.go:3905:primaryExpression: expr.go:4368:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr85582-2.c`:                          {}, // COMPILE FAIL: "\"pr85582-2.c:12:1: unsupported alignment 16 of S (decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:343:functionDefinition0: type.go:454:isValidType1: type.go:407:isValidType: t..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr85582-3.c`:                          {}, // COMPILE FAIL: "\"pr85582-3.c:12:1: unsupported alignment 16 of U (decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:343:functionDefinition0: type.go:454:isValidType1: type.go:407:isValidType: t..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr88739.c`:                            {}, // COMPILE FAIL: "\"TODO exprUintptr (expr.go:2060:postfixExpression: expr.go:2602:postfixExpressionSelect: expr.go:101:expr: expr.go:535:expr0: expr.go:2060:postfixExpression: expr.go:2702:postfixExpressionSelect:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr89434.c`:                            {}, // COMPILE FAIL: "\"TODO int * long -> unsigned (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:535:expr0: expr.go:2029:postfixExpression: expr.go:2282:mulOverflow:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/printf-2.c`:                           {}, // COMPILE FAIL: "printf-2.o.go:509:15: undefined: \"tmpnam\" external (all_test.go:437:1: all_test.go:524:testExec1: ccgo.go:186:Main: ccgo.go:597:main: link.go:302:link: link.go:826:link:)"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/scal-to-vec1.c`:                       {}, // COMPILE FAIL: "scal-to-vec1.o.go:19:17: undefined: \"main\" external (all_test.go:437:1: all_test.go:524:testExec1: ccgo.go:186:Main: ccgo.go:597:main: link.go:302:link: link.go:826:link:) (all_test.go:437:1: all_test..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/scal-to-vec2.c`:                       {}, // COMPILE FAIL: "scal-to-vec2.o.go:33:17: undefined: \"main\" external (all_test.go:437:1: all_test.go:524:testExec1: ccgo.go:186:Main: ccgo.go:597:main: link.go:302:link: link.go:826:link:) (all_test.go:437:1: all_test..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/scal-to-vec3.c`:                       {}, // COMPILE FAIL: "scal-to-vec3.o.go:17:17: undefined: \"main\" external (all_test.go:437:1: all_test.go:524:testExec1: ccgo.go:186:Main: ccgo.go:597:main: link.go:302:link: link.go:826:link:) (all_test.go:437:1: all_test..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/simd-1.c`:                             {}, // COMPILE FAIL: "\"simd-1.c:10:14: unsupported vector type: vecint (expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4347:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidType..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/simd-2.c`:                             {}, // COMPILE FAIL: "\"simd-2.c:8:14: unsupported vector type: vecint (expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4347:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidType1..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/simd-4.c`:                             {}, // COMPILE FAIL: "\"simd-4.c:17:34: unsupported vector type: v2si (expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4330:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidTyp..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/simd-5.c`:                             {}, // COMPILE FAIL: "\"simd-5.c:5:9: unsupported vector type: Q (expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4330:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/simd-6.c`:                             {}, // COMPILE FAIL: "\"simd-6.c:13:14: unsupported vector type: v8qi (expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4336:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidTyp..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/string-opt-18.c`:                      {}, // COMPILE FAIL: "string-opt-18.o.go:27:5: undefined: \"mempcpy\" external (all_test.go:437:1: all_test.go:524:testExec1: ccgo.go:186:Main: ccgo.go:597:main: link.go:302:link: link.go:826:link:) (all_test.go:437:1: all_t..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/user-printf.c`:                        {}, // COMPILE FAIL: "user-printf.o.go:507:15: undefined: \"tmpnam\" external (all_test.go:437:1: all_test.go:524:testExec1: ccgo.go:186:Main: ccgo.go:597:main: link.go:302:link: link.go:826:link:)"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/zero-struct-2.c`:                      {}, // COMPILE FAIL: "\"zero-struct-2.c:15:48: TODO \\\"Xone_raw_spinlock(cgtls)\\\" from=raw_spinlock_t struct 0 exprDefault -> to=spinlock_t struct 0 exprDefault (zero-struct-2.c:15:48:) (expr.go:535:expr0: expr.go:2243:postf..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20000822-1.c`:         {}, // COMPILE FAIL: "\"20000822-1.c:12:7: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatem..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010209-1.c`:         {}, // COMPILE FAIL: "\"20010209-1.c:6:7: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStateme..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010605-1.c`:         {}, // COMPILE FAIL: "\"20010605-1.c:5:14: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatem..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010605-2.c`:         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:507:expr0: expr.go:3517:assignmentExpression: expr.go:101:expr: expr.go:543:expr0: expr.go:1731:unaryExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010904-1.c`:         {}, // COMPILE FAIL: "\"20010904-1.c:12:3: unsupported alignment 32 of Y (decl.go:607:declaration: decl.go:776:initDeclarator: type.go:42:typ: type.go:337:typ0: type.go:65:typ0: type.go:426:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010904-2.c`:         {}, // COMPILE FAIL: "\"20010904-2.c:12:3: unsupported alignment 32 of Y (decl.go:607:declaration: decl.go:776:initDeclarator: type.go:42:typ: type.go:337:typ0: type.go:65:typ0: type.go:426:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20020411-1.c`:         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:507:expr0: expr.go:3517:assignmentExpression: expr.go:101:expr: expr.go:543:expr0: expr.go:1731:unaryExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20020412-1.c`:         {}, // COMPILE FAIL: "\"20020412-1.c:31:7: invalid type size: -1 (expr.go:3922:primaryExpression: expr.go:543:expr0: expr.go:1600:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:478:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030330-1.c`:         {}, // COMPILE FAIL: "20030330-1.o.go:26:4: undefined: \"link_error\" external (all_test.go:437:1: all_test.go:524:testExec1: ccgo.go:186:Main: ccgo.go:597:main: link.go:302:link: link.go:826:link:) (all_test.go:437:1: all_t..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030501-1.c`:         {}, // COMPILE FAIL: "\"20030501-1.c:7:9: nested functions not supported (decl.go:384:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:360:blockItem: stmt.go:26:statement: stmt.go:545:unbracedStatement: stmt.go:3..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030910-1.c`:         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:1571:unaryExpression: expr.go:101:expr: expr.go:537:expr0: expr.go:3922:primaryExpression: expr.go:543:expr0: expr.go:1731:unaryExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040302-1.c`:         {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040423-1.c`:         {}, // COMPILE FAIL: "\"20040423-1.c:13:22: incomplete type: array of int (expr.go:101:expr: expr.go:543:expr0: expr.go:1696:unaryExpression: type.go:395:isValidType: type.go:407:isValidType: type.go:471:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040520-1.c`:         {}, // COMPILE FAIL: "\"20040520-1.c:6:13: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatem..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20041124-1.c`:         {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex unsigned short _Complex unsigned short (decl.go:297:externalDeclaration: decl.go:597:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20041201-1.c`:         {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex char _Complex char (decl.go:297:externalDeclaration: decl.go:607:declaration: decl.go:746:initDeclarator: type.go:18:typedef: type.go:263:typ0: type.go:159:typ0:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20041214-1.c`:         {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20041218-2.c`:         {}, // COMPILE FAIL: "\"20041218-2.c:7:17: incomplete type: array of char (expr.go:101:expr: expr.go:543:expr0: expr.go:1696:unaryExpression: type.go:395:isValidType: type.go:407:isValidType: type.go:471:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050121-1.c`:         {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:507:expr0: expr.go:3517:assignmentExpression: expr.go:101:expr: expr.go:543:expr0: expr.go:1731:unaryExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050316-1.c`:         {}, // COMPILE FAIL: "\"20050316-1.c:15:29: unsupported vector type: V2SI (expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4347:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidTy..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050316-2.c`:         {}, // COMPILE FAIL: "\"20050316-2.c:38:14: unsupported vector type: V2SF (expr.go:537:expr0: expr.go:3905:primaryExpression: expr.go:4368:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isVa..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050316-3.c`:         {}, // COMPILE FAIL: "\"20050316-3.c:29:3: unsupported vector type: V2USI (expr.go:535:expr0: expr.go:2060:postfixExpression: expr.go:2623:postfixExpressionSelect: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050604-1.c`:         {}, // COMPILE FAIL: "\"20050604-1.c:16:3: unsupported vector type: v4hi (decl.go:607:declaration: decl.go:776:initDeclarator: type.go:42:typ: type.go:323:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050607-1.c`:         {}, // COMPILE FAIL: "\"20050607-1.c:12:32: unsupported vector type: V2SI (expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4330:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isVali..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20060420-1.c`:         {}, // COMPILE FAIL: "\"20060420-1.c:8:19: unsupported vector type: v4flt (expr.go:1212:checkVolatileExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:1696:unaryExpression: type.go:407:isValidType: type.go:440:isValidType1..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20070919-1.c`:         {}, // COMPILE FAIL: "\"20070919-1.c:31:7: invalid type size: -1 (expr.go:537:expr0: expr.go:3935:primaryExpression: decl.go:172:newAutovar: type.go:42:typ: type.go:65:typ0: type.go:478:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20071210-1.c`:         {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20090219-1.c`:         {}, // COMPILE FAIL: "\"20090219-1.c:12:8: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatem..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20171008-1.c`:         {}, // COMPILE FAIL: "\"20171008-1.c:16:1: unsupported alignment 4 of function(void) returning struct S (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920302-1.c`:           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920415-1.c`:           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920428-2.c`:           {}, // COMPILE FAIL: "\"920428-2.c:4:14: label declarations not supported (stmt.go:360:blockItem: stmt.go:42:statement: stmt.go:392:selectionStatement: stmt.go:536:bracedStatement: stmt.go:545:unbracedStatement: stmt.go:358..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920501-3.c`:           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920501-4.c`:           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920501-5.c`:           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920501-7.c`:           {}, // COMPILE FAIL: "\"920501-7.c:13:3: label declarations not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:353:functionDefinition0: stmt.go:324:compoundStatem..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920612-2.c`:           {}, // COMPILE FAIL: "\"920612-2.c:6:7: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatement..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/920721-4.c`:           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/921017-1.c`:           {}, // COMPILE FAIL: "\"921017-1.c:7:7: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatement..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/921215-1.c`:           {}, // COMPILE FAIL: "\"921215-1.c:5:8: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatement..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/930406-1.c`:           {}, // COMPILE FAIL: "\"TODO *cc.LabelDeclaration (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/931002-1.c`:           {}, // COMPILE FAIL: "\"931002-1.c:10:8: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatemen..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/960416-1.c`:           {}, // COMPILE FAIL: "\"gcc.c-torture/execute/960416-1.c:57:23: helper: unsupported type: t_be (expr.go:1109:castExpression: expr.go:101:expr: expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4347:primaryExpressio..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/970217-1.c`:           {}, // COMPILE FAIL: "\"970217-1.c:1:1: incomplete type: array of int (decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:343:functionDefinition0: type.go:459:isValidType1: type.go:383:isValidParamType..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/980526-1.c`:           {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/980929-1.c`:           {}, // COMPILE FAIL: "\"TODO 980929-1.c:17:5: from pointer to int, exprUintptr to pointer to int exprVoid, src '&n', buf 'ppuintptr(iqunsafe.ppPointer(&(aan)))' (stmt.go:360:blockItem: stmt.go:38:statement: expr.go:70:topEx..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/990208-1.c`:           {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (expr.go:101:expr: expr.go:507:expr0: expr.go:3522:assignmentExpression: expr.go:101:expr: expr.go:543:expr0: expr.go:1705:unaryExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/align-3.c`:            {}, // COMPILE FAIL: "\"align-3.c:5:6: unsupported alignment 256 of function(void) (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:343:functionDefin..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/builtin-prefetch-3.c`: {}, // COMPILE FAIL: "\"TODO exprUintptr (expr.go:543:expr0: expr.go:1571:unaryExpression: expr.go:101:expr: expr.go:535:expr0: expr.go:2060:postfixExpression: expr.go:2702:postfixExpressionSelect:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/comp-goto-1.c`:        {}, // COMPILE FAIL: "\"TODO <nil> (asm_amd64.s:1650:goexit: compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:345:functionDefinition0: decl.go:102:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/comp-goto-2.c`:        {}, // COMPILE FAIL: "\"comp-goto-2.c:15:3: label declarations not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:353:functionDefinition0: stmt.go:324:compoundSta..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/complex-1.c`:          {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:2057:postfixExpression: expr.go:3234:postfixExpressionCall: expr.go:70:topExpr: expr.go:101:expr: expr.go:543:expr0: expr.go:1731:unaryExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/complex-6.c`:          {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:382:functionDefinition0: decl.go:550:signature: type.go:48:typ2: type.go:15..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/complex-7.c`:          {}, // COMPILE FAIL: "\"TODO 2.2iL *cc.ComplexLongDoubleValue from=_Complex long t=long double mode=exprDefault (expr.go:1207:binopArgs: expr.go:1212:checkVolatileExpr: expr.go:101:expr: expr.go:537:expr0: expr.go:3905:prim..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/fprintf-2.c`:          {}, // COMPILE FAIL: "fprintf-2.o.go:496:15: undefined: \"tmpnam\" external (all_test.go:437:1: all_test.go:524:testExec1: ccgo.go:186:Main: ccgo.go:597:main: link.go:302:link: link.go:826:link:) (all_test.go:437:1: all_test..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-7.c`:      {}, // COMPILE FAIL: "fp-cmp-7.o.go:19:3: undefined: \"link_error\" external (all_test.go:437:1: all_test.go:524:testExec1: ccgo.go:186:Main: ccgo.go:597:main: link.go:302:link: link.go:826:link:) (all_test.go:437:1: all_tes..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/mzero4.c`:        {}, // COMPILE FAIL: "mzero4.o.go:51:18: undefined: \"tanf\" external (all_test.go:437:1: all_test.go:524:testExec1: ccgo.go:186:Main: ccgo.go:597:main: link.go:302:link: link.go:826:link:)"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/pr72824-2.c`:     {}, // COMPILE FAIL: "\"pr72824-2.c:17:17: unsupported vector type: V (expr.go:537:expr0: expr.go:3905:primaryExpression: expr.go:4378:primaryExpressionFloatConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidType..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/medce-1.c`:            {}, // COMPILE FAIL: "medce-1.o.go:38:2: undefined: \"link_error\" external (all_test.go:437:1: all_test.go:524:testExec1: ccgo.go:186:Main: ccgo.go:597:main: link.go:302:link: link.go:826:link:) (all_test.go:437:1: all_test..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nest-align-1.c`:       {}, // COMPILE FAIL: "\"nest-align-1.c:25:8: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStat..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nest-stdar-1.c`:       {}, // COMPILE FAIL: "\"nest-stdar-1.c:5:10: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStat..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-1.c`:         {}, // COMPILE FAIL: "\"nestfunc-1.c:15:7: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatem..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-2.c`:         {}, // COMPILE FAIL: "\"nestfunc-2.c:13:7: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatem..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-3.c`:         {}, // COMPILE FAIL: "\"nestfunc-3.c:12:8: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatem..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-5.c`:         {}, // COMPILE FAIL: "\"nestfunc-5.c:8:3: label declarations not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:353:functionDefinition0: stmt.go:324:compoundState..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-6.c`:         {}, // COMPILE FAIL: "\"nestfunc-6.c:13:3: label declarations not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:353:functionDefinition0: stmt.go:324:compoundStat..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-7.c`:         {}, // COMPILE FAIL: "\"nestfunc-7.c:15:12: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundState..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr22061-1.c`:          {}, // COMPILE FAIL: "\"pr22061-1.c:4:6: incomplete type: array of array of char (decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:343:functionDefinition0: type.go:459:isValidType1: type.go:383:isVal..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr22061-2.c`:          {}, // COMPILE FAIL: "\"pr22061-2.c:2:13: incomplete type: array of array of char (decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:343:functionDefinition0: type.go:459:isValidType1: type.go:383:isVa..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr22061-3.c`:          {}, // COMPILE FAIL: "\"pr22061-3.c:4:7: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatemen..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr22061-4.c`:          {}, // COMPILE FAIL: "\"pr22061-4.c:5:8: nested functions not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:384:functionDefinition0: stmt.go:324:compoundStatemen..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr23135.c`:            {}, // COMPILE FAIL: "\"pr23135.c:19:14: unsupported vector type: vecint (expr.go:537:expr0: expr.go:3903:primaryExpression: expr.go:4330:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValid..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr23324.c`:            {}, // COMPILE FAIL: "\"TODO (decl.go:831:initDeclarator: type.go:642:defineType: type.go:656:defineType0: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:315:typ0:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr23467.c`:            {}, // COMPILE FAIL: "\"pr23467.c:3:1: unsupported alignment 8 of int (decl.go:597:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263:typ0: type.go:65:typ0: type.go:426:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr24135.c`:            {}, // COMPILE FAIL: "\"pr24135.c:7:3: label declarations not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:353:functionDefinition0: stmt.go:324:compoundStatemen..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr34154.c`:            {}, // COMPILE FAIL: "\"TODO SelectionStatementSwitch (decl.go:353:functionDefinition0: stmt.go:324:compoundStatement: stmt.go:360:blockItem: stmt.go:42:statement: stmt.go:444:selectionStatement: stmt.go:512:selectionStatem..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr38151.c`:            {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:297:externalDeclaration: decl.go:597:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263:typ0: type.go:159:typ..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr38969.c`:            {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:507:expr0: expr.go:3517:assignmentExpression: expr.go:101:expr: expr.go:543:expr0: expr.go:1731:unaryExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr41935.c`:            {}, // COMPILE FAIL: "\"pr41935.c:10:10: TODO (expr.go:1919:postfixExpressionIndex: expr.go:101:expr: expr.go:535:expr0: expr.go:1970:postfixExpression: expr.go:1803:postfixExpressionIndex: expr.go:1753:mul:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr49218.c`:            {}, // COMPILE FAIL: "\"pr49218.c:11:9: unsupported alignment 16 of L (expr.go:101:expr: expr.go:537:expr0: expr.go:3811:primaryExpression: type.go:60:verifyTyp: type.go:65:typ0: type.go:426:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr51447.c`:            {}, // COMPILE FAIL: "\"pr51447.c:16:3: label declarations not supported (compile.go:433:compile: decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:353:functionDefinition0: stmt.go:324:compoundStateme..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr53645-2.c`:          {}, // COMPILE FAIL: "\"pr53645-2.c:41:1: unsupported vector type: UV (expr.go:101:expr: expr.go:543:expr0: expr.go:1619:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr53645.c`:            {}, // COMPILE FAIL: "\"pr53645.c:41:1: unsupported vector type: UV (expr.go:101:expr: expr.go:543:expr0: expr.go:1619:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr54471.c`:            {}, // COMPILE FAIL: "\"pr54471.c:13:1: unsupported alignment 16 of unsigned __int128 (decl.go:295:externalDeclaration: decl.go:323:functionDefinition: decl.go:343:functionDefinition0: type.go:454:isValidType1: type.go:407:..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr56837.c`:            {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:297:externalDeclaration: decl.go:607:declaration: decl.go:776:initDeclarator: type.go:42:typ: type.go:337:typ0: type.go:159:typ0:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr60960.c`:            {}, // COMPILE FAIL: "\"pr60960.c:26:14: unsupported vector type: v4qi (expr.go:541:expr0: expr.go:4172:primaryExpression: expr.go:4614:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidTy..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr61375.c`:            {}, // COMPILE FAIL: "\"pr61375.c:15:1: unsupported alignment 16 of unsigned __int128
}
