# v1.3 - Commander Key

![](./v1.3/banner.png)

Command Prompt is Toast!

## Cmd

Experimental support for [Cmd](https://en.wikipedia.org/wiki/Cmd.exe) through [Clink](https://chrisant996.github.io/clink/).

```lua
# ~/AppData/Local/clink/carapace.lua
load(io.popen('carapace _carapace cmd-clink'):read("*a"))()
```

![](./v1.3/cmd.png)

> Very early version with a lot of fundamental features not yet working.

## Fish

With [4.0b1](https://github.com/fish-shell/fish-shell/releases/tag/4.0b1) onwards the following workaround is **not** needed anymore:
```sh
mkdir -p ~/.config/fish/completions
carapace --list | awk '{print $1}' | xargs -I{} touch ~/.config/fish/completions/{}.fish # disable auto-loaded completions (#185)
```
see [fish-shell/fish#6716](https://github.com/fish-shell/fish-shell/issues/6716)

> Remove the leftover placeholders in `~/.config/fish/completions/`.

## Bridge

- Switched to [`$fish_complete_path`](https://fishshell.com/docs/current/completions.html#where-to-put-completions) to list available completions in the Fish bridge.
  > This should fix `nix`-based installations.
- Added another call to `compinit` to [adopt changes](https://www.reddit.com/r/zsh/comments/gk2c91/comment/kpjmntg/) to `fpath` in the Zsh bridge.
  > At this point it should not be neccessary to call `compinit` in the `.zshrc`.

## Git

Added [reflog](https://www.youtube.com/watch?v=cp2eGmWy9UI&t=158s) completion.

![](./v1.3/reflog.cast)

## Freckles

Added [Freckles](https://freckles.carapace.sh) as example project.
