// Code generated by smithy-go-codegen DO NOT EDIT.

package synthetics

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/synthetics/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Use this operation to start a dry run for a canary that has already been created
func (c *Client) StartCanaryDryRun(ctx context.Context, params *StartCanaryDryRunInput, optFns ...func(*Options)) (*StartCanaryDryRunOutput, error) {
	if params == nil {
		params = &StartCanaryDryRunInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartCanaryDryRun", params, optFns, c.addOperationStartCanaryDryRunMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartCanaryDryRunOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartCanaryDryRunInput struct {

	// The name of the canary that you want to dry run. To find canary names, use [DescribeCanaries].
	//
	// [DescribeCanaries]: https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html
	//
	// This member is required.
	Name *string

	// A structure that contains the configuration for canary artifacts, including the
	// encryption-at-rest settings for artifacts that the canary uploads to Amazon S3.
	ArtifactConfig *types.ArtifactConfigInput

	// The location in Amazon S3 where Synthetics stores artifacts from the test runs
	// of this
	//
	// canary. Artifacts include the log file, screenshots, and HAR files. The name of
	// the Amazon S3 bucket can't include a period (.).
	ArtifactS3Location *string

	// A structure that specifies the browser type to use for a canary run. CloudWatch
	// Synthetics supports running canaries on both CHROME and FIREFOX browsers.
	//
	// If not specified, browserConfigs defaults to Chrome.
	BrowserConfigs []types.BrowserConfig

	// Use this structure to input your script code for the canary. This structure
	// contains the Lambda handler with the location where the canary should start
	// running the script. If the script is stored in an Amazon S3 bucket, the bucket
	// name, key, and version are also included. If the script was passed into the
	// canary directly, the script code is contained in the value of Zipfile .
	//
	// If you are uploading your canary scripts with an Amazon S3 bucket, your zip
	// file should include your script in a certain folder structure.
	//
	//   - For Node.js canaries, the folder structure must be
	//   nodejs/node_modules/myCanaryFilename.js For more information, see [Packaging your Node.js canary files]
	//
	//   - For Python canaries, the folder structure must be
	//   python/myCanaryFilename.py or python/myFolder/myCanaryFilename.py For more
	//   information, see [Packaging your Python canary files]
	//
	// [Packaging your Node.js canary files]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_WritingCanary_Nodejs.html#CloudWatch_Synthetics_Canaries_package
	// [Packaging your Python canary files]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_WritingCanary_Python.html#CloudWatch_Synthetics_Canaries_WritingCanary_Python_package
	Code *types.CanaryCodeInput

	// The ARN of the IAM role to be used to run the canary. This role must already
	// exist, and must include lambda.amazonaws.com as a principal in the trust
	// policy. The role must also have the following permissions:
	ExecutionRoleArn *string

	// The number of days to retain data about failed runs of this canary. If you omit
	// this field, the default of 31 days is used. The valid range is 1 to 455 days.
	//
	// This setting affects the range of information returned by [GetCanaryRuns], as well as the
	// range of information displayed in the Synthetics console.
	//
	// [GetCanaryRuns]: https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_GetCanaryRuns.html
	FailureRetentionPeriodInDays *int32

	// Specifies whether to also delete the Lambda functions and layers used by this
	// canary when the canary is deleted. If you omit this parameter, the default of
	// AUTOMATIC is used, which means
	//
	// that the Lambda functions and layers will be deleted when the canary is deleted.
	//
	// If the value of this parameter is OFF , then the value of the DeleteLambda
	// parameter of the [DeleteCanary]operation determines whether the Lambda functions and layers
	// will be deleted.
	//
	// [DeleteCanary]: https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DeleteCanary.html
	ProvisionedResourceCleanup types.ProvisionedResourceCleanupSetting

	// A structure that contains input information for a canary run.
	RunConfig *types.CanaryRunConfigInput

	// Specifies the runtime version to use for the canary. For a list of valid
	// runtime versions and for more information about runtime versions, see [Canary Runtime Versions].
	//
	// [Canary Runtime Versions]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html
	RuntimeVersion *string

	// The number of days to retain data about successful runs of this canary. If you
	// omit this field, the default of 31 days is used. The valid range is 1 to 455
	// days.
	//
	// This setting affects the range of information returned by [GetCanaryRuns], as well as the
	// range of information displayed in the Synthetics console.
	//
	// [GetCanaryRuns]: https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_GetCanaryRuns.html
	SuccessRetentionPeriodInDays *int32

	// An object that specifies what screenshots to use as a baseline for visual
	// monitoring by this canary. It can optionally also specify parts of the
	// screenshots to ignore during the visual monitoring comparison.
	//
	// Visual monitoring is supported only on canaries running the
	// syn-puppeteer-node-3.2 runtime or later. For more information, see [Visual monitoring]and [Visual monitoring blueprint]
	//
	// [Visual monitoring]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_SyntheticsLogger_VisualTesting.html
	// [Visual monitoring blueprint]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Blueprints_VisualTesting.html
	VisualReference *types.VisualReferenceInput

	// A list of visual reference configurations for the canary, one for each browser
	// type that the canary is configured to run on. Visual references are used for
	// visual monitoring comparisons.
	//
	// syn-nodejs-puppeteer-11.0 and above, and syn-nodejs-playwright-3.0 and above,
	// only supports visualReferences . visualReference field is not supported.
	//
	// Versions older than syn-nodejs-puppeteer-11.0 supports both visualReference and
	// visualReferences for backward compatibility. It is recommended to use
	// visualReferences for consistency and future compatibility.
	VisualReferences []types.VisualReferenceInput

	// If this canary is to test an endpoint in a VPC, this structure contains
	// information about the subnets and security groups of the VPC endpoint. For more
	// information, see [Running a Canary in a VPC].
	//
	// [Running a Canary in a VPC]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html
	VpcConfig *types.VpcConfigInput

	noSmithyDocumentSerde
}

type StartCanaryDryRunOutput struct {

	// Returns the dry run configurations for a canary.
	DryRunConfig *types.DryRunConfigOutput

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartCanaryDryRunMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartCanaryDryRun{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartCanaryDryRun{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartCanaryDryRun"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpStartCanaryDryRunValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartCanaryDryRun(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartCanaryDryRun(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartCanaryDryRun",
	}
}
