// Code generated by smithy-go-codegen DO NOT EDIT.

package socialmessaging

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/socialmessaging/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists WhatsApp message templates for a specific WhatsApp Business Account.
func (c *Client) ListWhatsAppMessageTemplates(ctx context.Context, params *ListWhatsAppMessageTemplatesInput, optFns ...func(*Options)) (*ListWhatsAppMessageTemplatesOutput, error) {
	if params == nil {
		params = &ListWhatsAppMessageTemplatesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListWhatsAppMessageTemplates", params, optFns, c.addOperationListWhatsAppMessageTemplatesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListWhatsAppMessageTemplatesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListWhatsAppMessageTemplatesInput struct {

	// The ID of the WhatsApp Business Account to list templates for.
	//
	// This member is required.
	Id *string

	// The maximum number of results to return per page (1-100).
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListWhatsAppMessageTemplatesOutput struct {

	// The token to retrieve the next page of results, if any.
	NextToken *string

	// A list of template summaries.
	Templates []types.TemplateSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListWhatsAppMessageTemplatesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListWhatsAppMessageTemplates{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListWhatsAppMessageTemplates{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListWhatsAppMessageTemplates"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListWhatsAppMessageTemplatesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListWhatsAppMessageTemplates(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListWhatsAppMessageTemplatesPaginatorOptions is the paginator options for
// ListWhatsAppMessageTemplates
type ListWhatsAppMessageTemplatesPaginatorOptions struct {
	// The maximum number of results to return per page (1-100).
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListWhatsAppMessageTemplatesPaginator is a paginator for
// ListWhatsAppMessageTemplates
type ListWhatsAppMessageTemplatesPaginator struct {
	options   ListWhatsAppMessageTemplatesPaginatorOptions
	client    ListWhatsAppMessageTemplatesAPIClient
	params    *ListWhatsAppMessageTemplatesInput
	nextToken *string
	firstPage bool
}

// NewListWhatsAppMessageTemplatesPaginator returns a new
// ListWhatsAppMessageTemplatesPaginator
func NewListWhatsAppMessageTemplatesPaginator(client ListWhatsAppMessageTemplatesAPIClient, params *ListWhatsAppMessageTemplatesInput, optFns ...func(*ListWhatsAppMessageTemplatesPaginatorOptions)) *ListWhatsAppMessageTemplatesPaginator {
	if params == nil {
		params = &ListWhatsAppMessageTemplatesInput{}
	}

	options := ListWhatsAppMessageTemplatesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListWhatsAppMessageTemplatesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListWhatsAppMessageTemplatesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListWhatsAppMessageTemplates page.
func (p *ListWhatsAppMessageTemplatesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListWhatsAppMessageTemplatesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListWhatsAppMessageTemplates(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListWhatsAppMessageTemplatesAPIClient is a client that implements the
// ListWhatsAppMessageTemplates operation.
type ListWhatsAppMessageTemplatesAPIClient interface {
	ListWhatsAppMessageTemplates(context.Context, *ListWhatsAppMessageTemplatesInput, ...func(*Options)) (*ListWhatsAppMessageTemplatesOutput, error)
}

var _ ListWhatsAppMessageTemplatesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListWhatsAppMessageTemplates(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListWhatsAppMessageTemplates",
	}
}
