// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This action allows users to retrieve a list of Engagement records from Partner
// Central. This action can be used to manage and track various engagements across
// different stages of the partner selling process.
func (c *Client) ListEngagements(ctx context.Context, params *ListEngagementsInput, optFns ...func(*Options)) (*ListEngagementsOutput, error) {
	if params == nil {
		params = &ListEngagementsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListEngagements", params, optFns, c.addOperationListEngagementsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListEngagementsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListEngagementsInput struct {

	//  Specifies the catalog related to the request.
	//
	// This member is required.
	Catalog *string

	//  A list of AWS account IDs. When specified, the response includes engagements
	// created by these accounts. This filter is useful for finding engagements created
	// by specific team members.
	CreatedBy []string

	// An array of strings representing engagement identifiers to retrieve.
	EngagementIdentifier []string

	// An array of strings representing AWS Account IDs. Use this to exclude
	// engagements created by specific users.
	ExcludeCreatedBy []string

	// The maximum number of results to return in a single call.
	MaxResults *int32

	// The token for the next set of results. This value is returned from a previous
	// call.
	NextToken *string

	// Specifies the sorting parameters for listing Engagements.
	Sort *types.EngagementSort

	noSmithyDocumentSerde
}

type ListEngagementsOutput struct {

	// An array of engagement summary objects.
	//
	// This member is required.
	EngagementSummaryList []types.EngagementSummary

	// The token to retrieve the next set of results. This field will be null if there
	// are no more results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListEngagementsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListEngagements{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListEngagements{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListEngagements"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListEngagementsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListEngagements(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListEngagementsPaginatorOptions is the paginator options for ListEngagements
type ListEngagementsPaginatorOptions struct {
	// The maximum number of results to return in a single call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListEngagementsPaginator is a paginator for ListEngagements
type ListEngagementsPaginator struct {
	options   ListEngagementsPaginatorOptions
	client    ListEngagementsAPIClient
	params    *ListEngagementsInput
	nextToken *string
	firstPage bool
}

// NewListEngagementsPaginator returns a new ListEngagementsPaginator
func NewListEngagementsPaginator(client ListEngagementsAPIClient, params *ListEngagementsInput, optFns ...func(*ListEngagementsPaginatorOptions)) *ListEngagementsPaginator {
	if params == nil {
		params = &ListEngagementsInput{}
	}

	options := ListEngagementsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListEngagementsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListEngagementsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListEngagements page.
func (p *ListEngagementsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListEngagementsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListEngagements(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListEngagementsAPIClient is a client that implements the ListEngagements
// operation.
type ListEngagementsAPIClient interface {
	ListEngagements(context.Context, *ListEngagementsInput, ...func(*Options)) (*ListEngagementsOutput, error)
}

var _ ListEngagementsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListEngagements(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListEngagements",
	}
}
