// Code generated by smithy-go-codegen DO NOT EDIT.

package organizations

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/organizations/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all the accounts in an organization that have invalid effective policies.
// An invalid effective policy is an [effective policy]that fails validation checks, resulting in
// the effective policy not being fully enforced on all the intended accounts
// within an organization.
//
// This operation can be called only from the organization's management account or
// by a member account that is a delegated administrator.
//
// [effective policy]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_effective.html
func (c *Client) ListAccountsWithInvalidEffectivePolicy(ctx context.Context, params *ListAccountsWithInvalidEffectivePolicyInput, optFns ...func(*Options)) (*ListAccountsWithInvalidEffectivePolicyOutput, error) {
	if params == nil {
		params = &ListAccountsWithInvalidEffectivePolicyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAccountsWithInvalidEffectivePolicy", params, optFns, c.addOperationListAccountsWithInvalidEffectivePolicyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAccountsWithInvalidEffectivePolicyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAccountsWithInvalidEffectivePolicyInput struct {

	// The type of policy that you want information about. You can specify one of the
	// following values:
	//
	// [DECLARATIVE_POLICY_EC2]
	//
	// [BACKUP_POLICY]
	//
	// [TAG_POLICY]
	//
	// [CHATBOT_POLICY]
	//
	// [AISERVICES_OPT_OUT_POLICY]
	//
	// [SECURITYHUB_POLICY]
	//
	// [AISERVICES_OPT_OUT_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html
	// [SECURITYHUB_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html
	// [BACKUP_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html
	// [CHATBOT_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html
	// [TAG_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html
	// [DECLARATIVE_POLICY_EC2]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html
	//
	// This member is required.
	PolicyType types.EffectivePolicyType

	// The total number of results that you want included on each page of the
	// response. If you do not include this parameter, it defaults to a value that is
	// specific to the operation. If additional items exist beyond the maximum you
	// specify, the NextToken response element is present and has a value (is not
	// null). Include that value as the NextToken request parameter in the next call
	// to the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that you
	// receive all of the results.
	MaxResults *int32

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more output
	// is available. Set this parameter to the value of the previous call's NextToken
	// response to indicate where the output should continue from.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAccountsWithInvalidEffectivePolicyOutput struct {

	// The accounts in the organization which have an invalid effective policy for the
	// specified policy type.
	Accounts []types.Account

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You should
	// repeat this until the NextToken response element comes back as null .
	NextToken *string

	// The specified policy type. One of the following values:
	//
	// [DECLARATIVE_POLICY_EC2]
	//
	// [BACKUP_POLICY]
	//
	// [TAG_POLICY]
	//
	// [CHATBOT_POLICY]
	//
	// [AISERVICES_OPT_OUT_POLICY]
	//
	// [SECURITYHUB_POLICY]
	//
	// [AISERVICES_OPT_OUT_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html
	// [SECURITYHUB_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_security_hub.html
	// [BACKUP_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html
	// [CHATBOT_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html
	// [TAG_POLICY]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html
	// [DECLARATIVE_POLICY_EC2]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html
	PolicyType types.EffectivePolicyType

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAccountsWithInvalidEffectivePolicyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListAccountsWithInvalidEffectivePolicy{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListAccountsWithInvalidEffectivePolicy{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAccountsWithInvalidEffectivePolicy"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAccountsWithInvalidEffectivePolicyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAccountsWithInvalidEffectivePolicy(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListAccountsWithInvalidEffectivePolicyPaginatorOptions is the paginator options
// for ListAccountsWithInvalidEffectivePolicy
type ListAccountsWithInvalidEffectivePolicyPaginatorOptions struct {
	// The total number of results that you want included on each page of the
	// response. If you do not include this parameter, it defaults to a value that is
	// specific to the operation. If additional items exist beyond the maximum you
	// specify, the NextToken response element is present and has a value (is not
	// null). Include that value as the NextToken request parameter in the next call
	// to the operation to get the next part of the results. Note that Organizations
	// might return fewer results than the maximum even when there are more results
	// available. You should check NextToken after every operation to ensure that you
	// receive all of the results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAccountsWithInvalidEffectivePolicyPaginator is a paginator for
// ListAccountsWithInvalidEffectivePolicy
type ListAccountsWithInvalidEffectivePolicyPaginator struct {
	options   ListAccountsWithInvalidEffectivePolicyPaginatorOptions
	client    ListAccountsWithInvalidEffectivePolicyAPIClient
	params    *ListAccountsWithInvalidEffectivePolicyInput
	nextToken *string
	firstPage bool
}

// NewListAccountsWithInvalidEffectivePolicyPaginator returns a new
// ListAccountsWithInvalidEffectivePolicyPaginator
func NewListAccountsWithInvalidEffectivePolicyPaginator(client ListAccountsWithInvalidEffectivePolicyAPIClient, params *ListAccountsWithInvalidEffectivePolicyInput, optFns ...func(*ListAccountsWithInvalidEffectivePolicyPaginatorOptions)) *ListAccountsWithInvalidEffectivePolicyPaginator {
	if params == nil {
		params = &ListAccountsWithInvalidEffectivePolicyInput{}
	}

	options := ListAccountsWithInvalidEffectivePolicyPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAccountsWithInvalidEffectivePolicyPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAccountsWithInvalidEffectivePolicyPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAccountsWithInvalidEffectivePolicy page.
func (p *ListAccountsWithInvalidEffectivePolicyPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAccountsWithInvalidEffectivePolicyOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAccountsWithInvalidEffectivePolicy(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAccountsWithInvalidEffectivePolicyAPIClient is a client that implements the
// ListAccountsWithInvalidEffectivePolicy operation.
type ListAccountsWithInvalidEffectivePolicyAPIClient interface {
	ListAccountsWithInvalidEffectivePolicy(context.Context, *ListAccountsWithInvalidEffectivePolicyInput, ...func(*Options)) (*ListAccountsWithInvalidEffectivePolicyOutput, error)
}

var _ ListAccountsWithInvalidEffectivePolicyAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAccountsWithInvalidEffectivePolicy(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAccountsWithInvalidEffectivePolicy",
	}
}
