// Code generated by smithy-go-codegen DO NOT EDIT.

package mpa

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mpa/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of policies for a resource.
func (c *Client) ListResourcePolicies(ctx context.Context, params *ListResourcePoliciesInput, optFns ...func(*Options)) (*ListResourcePoliciesOutput, error) {
	if params == nil {
		params = &ListResourcePoliciesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListResourcePolicies", params, optFns, c.addOperationListResourcePoliciesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListResourcePoliciesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListResourcePoliciesInput struct {

	// Amazon Resource Name (ARN) for the resource.
	//
	// This member is required.
	ResourceArn *string

	// The maximum number of items to return in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response so
	// that you can retrieve the remaining results.
	MaxResults *int32

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a next
	// call to the operation to get more output. You can repeat this until the
	// NextToken response element returns null .
	NextToken *string

	noSmithyDocumentSerde
}

type ListResourcePoliciesOutput struct {

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a next
	// call to the operation to get more output. You can repeat this until the
	// NextToken response element returns null .
	NextToken *string

	// An array of ListResourcePoliciesResponseResourcePolicy objects. Contains
	// details about the policy for the resource.
	ResourcePolicies []types.ListResourcePoliciesResponseResourcePolicy

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListResourcePoliciesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListResourcePolicies{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListResourcePolicies{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListResourcePolicies"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListResourcePoliciesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListResourcePolicies(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListResourcePoliciesPaginatorOptions is the paginator options for
// ListResourcePolicies
type ListResourcePoliciesPaginatorOptions struct {
	// The maximum number of items to return in the response. If more results exist
	// than the specified MaxResults value, a token is included in the response so
	// that you can retrieve the remaining results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListResourcePoliciesPaginator is a paginator for ListResourcePolicies
type ListResourcePoliciesPaginator struct {
	options   ListResourcePoliciesPaginatorOptions
	client    ListResourcePoliciesAPIClient
	params    *ListResourcePoliciesInput
	nextToken *string
	firstPage bool
}

// NewListResourcePoliciesPaginator returns a new ListResourcePoliciesPaginator
func NewListResourcePoliciesPaginator(client ListResourcePoliciesAPIClient, params *ListResourcePoliciesInput, optFns ...func(*ListResourcePoliciesPaginatorOptions)) *ListResourcePoliciesPaginator {
	if params == nil {
		params = &ListResourcePoliciesInput{}
	}

	options := ListResourcePoliciesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListResourcePoliciesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListResourcePoliciesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListResourcePolicies page.
func (p *ListResourcePoliciesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListResourcePoliciesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListResourcePolicies(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListResourcePoliciesAPIClient is a client that implements the
// ListResourcePolicies operation.
type ListResourcePoliciesAPIClient interface {
	ListResourcePolicies(context.Context, *ListResourcePoliciesInput, ...func(*Options)) (*ListResourcePoliciesOutput, error)
}

var _ ListResourcePoliciesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListResourcePolicies(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListResourcePolicies",
	}
}
