// Code generated by smithy-go-codegen DO NOT EDIT.

package iotevents

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/iotevents/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpCreateAlarmModel struct {
}

func (*awsRestjson1_serializeOpCreateAlarmModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateAlarmModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAlarmModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/alarm-models")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateAlarmModelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateAlarmModelInput(v *CreateAlarmModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateAlarmModelInput(v *CreateAlarmModelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AlarmCapabilities != nil {
		ok := object.Key("alarmCapabilities")
		if err := awsRestjson1_serializeDocumentAlarmCapabilities(v.AlarmCapabilities, ok); err != nil {
			return err
		}
	}

	if v.AlarmEventActions != nil {
		ok := object.Key("alarmEventActions")
		if err := awsRestjson1_serializeDocumentAlarmEventActions(v.AlarmEventActions, ok); err != nil {
			return err
		}
	}

	if v.AlarmModelDescription != nil {
		ok := object.Key("alarmModelDescription")
		ok.String(*v.AlarmModelDescription)
	}

	if v.AlarmModelName != nil {
		ok := object.Key("alarmModelName")
		ok.String(*v.AlarmModelName)
	}

	if v.AlarmNotification != nil {
		ok := object.Key("alarmNotification")
		if err := awsRestjson1_serializeDocumentAlarmNotification(v.AlarmNotification, ok); err != nil {
			return err
		}
	}

	if v.AlarmRule != nil {
		ok := object.Key("alarmRule")
		if err := awsRestjson1_serializeDocumentAlarmRule(v.AlarmRule, ok); err != nil {
			return err
		}
	}

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Severity != nil {
		ok := object.Key("severity")
		ok.Integer(*v.Severity)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateDetectorModel struct {
}

func (*awsRestjson1_serializeOpCreateDetectorModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDetectorModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDetectorModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/detector-models")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDetectorModelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDetectorModelInput(v *CreateDetectorModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDetectorModelInput(v *CreateDetectorModelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DetectorModelDefinition != nil {
		ok := object.Key("detectorModelDefinition")
		if err := awsRestjson1_serializeDocumentDetectorModelDefinition(v.DetectorModelDefinition, ok); err != nil {
			return err
		}
	}

	if v.DetectorModelDescription != nil {
		ok := object.Key("detectorModelDescription")
		ok.String(*v.DetectorModelDescription)
	}

	if v.DetectorModelName != nil {
		ok := object.Key("detectorModelName")
		ok.String(*v.DetectorModelName)
	}

	if len(v.EvaluationMethod) > 0 {
		ok := object.Key("evaluationMethod")
		ok.String(string(v.EvaluationMethod))
	}

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateInput struct {
}

func (*awsRestjson1_serializeOpCreateInput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateInput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateInputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/inputs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateInputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateInputInput(v *CreateInputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateInputInput(v *CreateInputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputDefinition != nil {
		ok := object.Key("inputDefinition")
		if err := awsRestjson1_serializeDocumentInputDefinition(v.InputDefinition, ok); err != nil {
			return err
		}
	}

	if v.InputDescription != nil {
		ok := object.Key("inputDescription")
		ok.String(*v.InputDescription)
	}

	if v.InputName != nil {
		ok := object.Key("inputName")
		ok.String(*v.InputName)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteAlarmModel struct {
}

func (*awsRestjson1_serializeOpDeleteAlarmModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteAlarmModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAlarmModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/alarm-models/{alarmModelName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteAlarmModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteAlarmModelInput(v *DeleteAlarmModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AlarmModelName == nil || len(*v.AlarmModelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member alarmModelName must not be empty")}
	}
	if v.AlarmModelName != nil {
		if err := encoder.SetURI("alarmModelName").String(*v.AlarmModelName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDetectorModel struct {
}

func (*awsRestjson1_serializeOpDeleteDetectorModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDetectorModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDetectorModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/detector-models/{detectorModelName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDetectorModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDetectorModelInput(v *DeleteDetectorModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DetectorModelName == nil || len(*v.DetectorModelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member detectorModelName must not be empty")}
	}
	if v.DetectorModelName != nil {
		if err := encoder.SetURI("detectorModelName").String(*v.DetectorModelName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteInput struct {
}

func (*awsRestjson1_serializeOpDeleteInput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteInput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteInputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/inputs/{inputName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteInputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteInputInput(v *DeleteInputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InputName == nil || len(*v.InputName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member inputName must not be empty")}
	}
	if v.InputName != nil {
		if err := encoder.SetURI("inputName").String(*v.InputName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeAlarmModel struct {
}

func (*awsRestjson1_serializeOpDescribeAlarmModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeAlarmModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAlarmModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/alarm-models/{alarmModelName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeAlarmModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeAlarmModelInput(v *DescribeAlarmModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AlarmModelName == nil || len(*v.AlarmModelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member alarmModelName must not be empty")}
	}
	if v.AlarmModelName != nil {
		if err := encoder.SetURI("alarmModelName").String(*v.AlarmModelName); err != nil {
			return err
		}
	}

	if v.AlarmModelVersion != nil {
		encoder.SetQuery("version").String(*v.AlarmModelVersion)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDetectorModel struct {
}

func (*awsRestjson1_serializeOpDescribeDetectorModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDetectorModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDetectorModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/detector-models/{detectorModelName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDetectorModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDetectorModelInput(v *DescribeDetectorModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DetectorModelName == nil || len(*v.DetectorModelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member detectorModelName must not be empty")}
	}
	if v.DetectorModelName != nil {
		if err := encoder.SetURI("detectorModelName").String(*v.DetectorModelName); err != nil {
			return err
		}
	}

	if v.DetectorModelVersion != nil {
		encoder.SetQuery("version").String(*v.DetectorModelVersion)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDetectorModelAnalysis struct {
}

func (*awsRestjson1_serializeOpDescribeDetectorModelAnalysis) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDetectorModelAnalysis) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDetectorModelAnalysisInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/analysis/detector-models/{analysisId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDetectorModelAnalysisInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDetectorModelAnalysisInput(v *DescribeDetectorModelAnalysisInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AnalysisId == nil || len(*v.AnalysisId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member analysisId must not be empty")}
	}
	if v.AnalysisId != nil {
		if err := encoder.SetURI("analysisId").String(*v.AnalysisId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeInput struct {
}

func (*awsRestjson1_serializeOpDescribeInput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeInput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeInputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/inputs/{inputName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeInputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeInputInput(v *DescribeInputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InputName == nil || len(*v.InputName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member inputName must not be empty")}
	}
	if v.InputName != nil {
		if err := encoder.SetURI("inputName").String(*v.InputName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeLoggingOptions struct {
}

func (*awsRestjson1_serializeOpDescribeLoggingOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeLoggingOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLoggingOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/logging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeLoggingOptionsInput(v *DescribeLoggingOptionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpGetDetectorModelAnalysisResults struct {
}

func (*awsRestjson1_serializeOpGetDetectorModelAnalysisResults) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDetectorModelAnalysisResults) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDetectorModelAnalysisResultsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/analysis/detector-models/{analysisId}/results")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDetectorModelAnalysisResultsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDetectorModelAnalysisResultsInput(v *GetDetectorModelAnalysisResultsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AnalysisId == nil || len(*v.AnalysisId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member analysisId must not be empty")}
	}
	if v.AnalysisId != nil {
		if err := encoder.SetURI("analysisId").String(*v.AnalysisId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListAlarmModels struct {
}

func (*awsRestjson1_serializeOpListAlarmModels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAlarmModels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAlarmModelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/alarm-models")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAlarmModelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAlarmModelsInput(v *ListAlarmModelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListAlarmModelVersions struct {
}

func (*awsRestjson1_serializeOpListAlarmModelVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAlarmModelVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAlarmModelVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/alarm-models/{alarmModelName}/versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAlarmModelVersionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAlarmModelVersionsInput(v *ListAlarmModelVersionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AlarmModelName == nil || len(*v.AlarmModelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member alarmModelName must not be empty")}
	}
	if v.AlarmModelName != nil {
		if err := encoder.SetURI("alarmModelName").String(*v.AlarmModelName); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListDetectorModels struct {
}

func (*awsRestjson1_serializeOpListDetectorModels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDetectorModels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDetectorModelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/detector-models")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDetectorModelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDetectorModelsInput(v *ListDetectorModelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListDetectorModelVersions struct {
}

func (*awsRestjson1_serializeOpListDetectorModelVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDetectorModelVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDetectorModelVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/detector-models/{detectorModelName}/versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDetectorModelVersionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDetectorModelVersionsInput(v *ListDetectorModelVersionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DetectorModelName == nil || len(*v.DetectorModelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member detectorModelName must not be empty")}
	}
	if v.DetectorModelName != nil {
		if err := encoder.SetURI("detectorModelName").String(*v.DetectorModelName); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListInputRoutings struct {
}

func (*awsRestjson1_serializeOpListInputRoutings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListInputRoutings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListInputRoutingsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/input-routings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListInputRoutingsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListInputRoutingsInput(v *ListInputRoutingsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListInputRoutingsInput(v *ListInputRoutingsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputIdentifier != nil {
		ok := object.Key("inputIdentifier")
		if err := awsRestjson1_serializeDocumentInputIdentifier(v.InputIdentifier, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListInputs struct {
}

func (*awsRestjson1_serializeOpListInputs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListInputs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListInputsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/inputs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListInputsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListInputsInput(v *ListInputsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn != nil {
		encoder.SetQuery("resourceArn").String(*v.ResourceArn)
	}

	return nil
}

type awsRestjson1_serializeOpPutLoggingOptions struct {
}

func (*awsRestjson1_serializeOpPutLoggingOptions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutLoggingOptions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutLoggingOptionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/logging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutLoggingOptionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutLoggingOptionsInput(v *PutLoggingOptionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutLoggingOptionsInput(v *PutLoggingOptionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LoggingOptions != nil {
		ok := object.Key("loggingOptions")
		if err := awsRestjson1_serializeDocumentLoggingOptions(v.LoggingOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartDetectorModelAnalysis struct {
}

func (*awsRestjson1_serializeOpStartDetectorModelAnalysis) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartDetectorModelAnalysis) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartDetectorModelAnalysisInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/analysis/detector-models")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartDetectorModelAnalysisInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartDetectorModelAnalysisInput(v *StartDetectorModelAnalysisInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartDetectorModelAnalysisInput(v *StartDetectorModelAnalysisInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DetectorModelDefinition != nil {
		ok := object.Key("detectorModelDefinition")
		if err := awsRestjson1_serializeDocumentDetectorModelDefinition(v.DetectorModelDefinition, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn != nil {
		encoder.SetQuery("resourceArn").String(*v.ResourceArn)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn != nil {
		encoder.SetQuery("resourceArn").String(*v.ResourceArn)
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateAlarmModel struct {
}

func (*awsRestjson1_serializeOpUpdateAlarmModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateAlarmModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAlarmModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/alarm-models/{alarmModelName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateAlarmModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateAlarmModelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateAlarmModelInput(v *UpdateAlarmModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AlarmModelName == nil || len(*v.AlarmModelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member alarmModelName must not be empty")}
	}
	if v.AlarmModelName != nil {
		if err := encoder.SetURI("alarmModelName").String(*v.AlarmModelName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateAlarmModelInput(v *UpdateAlarmModelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AlarmCapabilities != nil {
		ok := object.Key("alarmCapabilities")
		if err := awsRestjson1_serializeDocumentAlarmCapabilities(v.AlarmCapabilities, ok); err != nil {
			return err
		}
	}

	if v.AlarmEventActions != nil {
		ok := object.Key("alarmEventActions")
		if err := awsRestjson1_serializeDocumentAlarmEventActions(v.AlarmEventActions, ok); err != nil {
			return err
		}
	}

	if v.AlarmModelDescription != nil {
		ok := object.Key("alarmModelDescription")
		ok.String(*v.AlarmModelDescription)
	}

	if v.AlarmNotification != nil {
		ok := object.Key("alarmNotification")
		if err := awsRestjson1_serializeDocumentAlarmNotification(v.AlarmNotification, ok); err != nil {
			return err
		}
	}

	if v.AlarmRule != nil {
		ok := object.Key("alarmRule")
		if err := awsRestjson1_serializeDocumentAlarmRule(v.AlarmRule, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Severity != nil {
		ok := object.Key("severity")
		ok.Integer(*v.Severity)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDetectorModel struct {
}

func (*awsRestjson1_serializeOpUpdateDetectorModel) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDetectorModel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDetectorModelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/detector-models/{detectorModelName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDetectorModelInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDetectorModelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDetectorModelInput(v *UpdateDetectorModelInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DetectorModelName == nil || len(*v.DetectorModelName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member detectorModelName must not be empty")}
	}
	if v.DetectorModelName != nil {
		if err := encoder.SetURI("detectorModelName").String(*v.DetectorModelName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDetectorModelInput(v *UpdateDetectorModelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DetectorModelDefinition != nil {
		ok := object.Key("detectorModelDefinition")
		if err := awsRestjson1_serializeDocumentDetectorModelDefinition(v.DetectorModelDefinition, ok); err != nil {
			return err
		}
	}

	if v.DetectorModelDescription != nil {
		ok := object.Key("detectorModelDescription")
		ok.String(*v.DetectorModelDescription)
	}

	if len(v.EvaluationMethod) > 0 {
		ok := object.Key("evaluationMethod")
		ok.String(string(v.EvaluationMethod))
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateInput struct {
}

func (*awsRestjson1_serializeOpUpdateInput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateInput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateInputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/inputs/{inputName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateInputInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateInputInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateInputInput(v *UpdateInputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.InputName == nil || len(*v.InputName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member inputName must not be empty")}
	}
	if v.InputName != nil {
		if err := encoder.SetURI("inputName").String(*v.InputName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateInputInput(v *UpdateInputInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputDefinition != nil {
		ok := object.Key("inputDefinition")
		if err := awsRestjson1_serializeDocumentInputDefinition(v.InputDefinition, ok); err != nil {
			return err
		}
	}

	if v.InputDescription != nil {
		ok := object.Key("inputDescription")
		ok.String(*v.InputDescription)
	}

	return nil
}

func awsRestjson1_serializeDocumentAcknowledgeFlow(v *types.AcknowledgeFlow, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled != nil {
		ok := object.Key("enabled")
		ok.Boolean(*v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentAction(v *types.Action, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClearTimer != nil {
		ok := object.Key("clearTimer")
		if err := awsRestjson1_serializeDocumentClearTimerAction(v.ClearTimer, ok); err != nil {
			return err
		}
	}

	if v.DynamoDB != nil {
		ok := object.Key("dynamoDB")
		if err := awsRestjson1_serializeDocumentDynamoDBAction(v.DynamoDB, ok); err != nil {
			return err
		}
	}

	if v.DynamoDBv2 != nil {
		ok := object.Key("dynamoDBv2")
		if err := awsRestjson1_serializeDocumentDynamoDBv2Action(v.DynamoDBv2, ok); err != nil {
			return err
		}
	}

	if v.Firehose != nil {
		ok := object.Key("firehose")
		if err := awsRestjson1_serializeDocumentFirehoseAction(v.Firehose, ok); err != nil {
			return err
		}
	}

	if v.IotEvents != nil {
		ok := object.Key("iotEvents")
		if err := awsRestjson1_serializeDocumentIotEventsAction(v.IotEvents, ok); err != nil {
			return err
		}
	}

	if v.IotSiteWise != nil {
		ok := object.Key("iotSiteWise")
		if err := awsRestjson1_serializeDocumentIotSiteWiseAction(v.IotSiteWise, ok); err != nil {
			return err
		}
	}

	if v.IotTopicPublish != nil {
		ok := object.Key("iotTopicPublish")
		if err := awsRestjson1_serializeDocumentIotTopicPublishAction(v.IotTopicPublish, ok); err != nil {
			return err
		}
	}

	if v.Lambda != nil {
		ok := object.Key("lambda")
		if err := awsRestjson1_serializeDocumentLambdaAction(v.Lambda, ok); err != nil {
			return err
		}
	}

	if v.ResetTimer != nil {
		ok := object.Key("resetTimer")
		if err := awsRestjson1_serializeDocumentResetTimerAction(v.ResetTimer, ok); err != nil {
			return err
		}
	}

	if v.SetTimer != nil {
		ok := object.Key("setTimer")
		if err := awsRestjson1_serializeDocumentSetTimerAction(v.SetTimer, ok); err != nil {
			return err
		}
	}

	if v.SetVariable != nil {
		ok := object.Key("setVariable")
		if err := awsRestjson1_serializeDocumentSetVariableAction(v.SetVariable, ok); err != nil {
			return err
		}
	}

	if v.Sns != nil {
		ok := object.Key("sns")
		if err := awsRestjson1_serializeDocumentSNSTopicPublishAction(v.Sns, ok); err != nil {
			return err
		}
	}

	if v.Sqs != nil {
		ok := object.Key("sqs")
		if err := awsRestjson1_serializeDocumentSqsAction(v.Sqs, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentActions(v []types.Action, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAction(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAlarmAction(v *types.AlarmAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DynamoDB != nil {
		ok := object.Key("dynamoDB")
		if err := awsRestjson1_serializeDocumentDynamoDBAction(v.DynamoDB, ok); err != nil {
			return err
		}
	}

	if v.DynamoDBv2 != nil {
		ok := object.Key("dynamoDBv2")
		if err := awsRestjson1_serializeDocumentDynamoDBv2Action(v.DynamoDBv2, ok); err != nil {
			return err
		}
	}

	if v.Firehose != nil {
		ok := object.Key("firehose")
		if err := awsRestjson1_serializeDocumentFirehoseAction(v.Firehose, ok); err != nil {
			return err
		}
	}

	if v.IotEvents != nil {
		ok := object.Key("iotEvents")
		if err := awsRestjson1_serializeDocumentIotEventsAction(v.IotEvents, ok); err != nil {
			return err
		}
	}

	if v.IotSiteWise != nil {
		ok := object.Key("iotSiteWise")
		if err := awsRestjson1_serializeDocumentIotSiteWiseAction(v.IotSiteWise, ok); err != nil {
			return err
		}
	}

	if v.IotTopicPublish != nil {
		ok := object.Key("iotTopicPublish")
		if err := awsRestjson1_serializeDocumentIotTopicPublishAction(v.IotTopicPublish, ok); err != nil {
			return err
		}
	}

	if v.Lambda != nil {
		ok := object.Key("lambda")
		if err := awsRestjson1_serializeDocumentLambdaAction(v.Lambda, ok); err != nil {
			return err
		}
	}

	if v.Sns != nil {
		ok := object.Key("sns")
		if err := awsRestjson1_serializeDocumentSNSTopicPublishAction(v.Sns, ok); err != nil {
			return err
		}
	}

	if v.Sqs != nil {
		ok := object.Key("sqs")
		if err := awsRestjson1_serializeDocumentSqsAction(v.Sqs, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAlarmActions(v []types.AlarmAction, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAlarmAction(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAlarmCapabilities(v *types.AlarmCapabilities, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AcknowledgeFlow != nil {
		ok := object.Key("acknowledgeFlow")
		if err := awsRestjson1_serializeDocumentAcknowledgeFlow(v.AcknowledgeFlow, ok); err != nil {
			return err
		}
	}

	if v.InitializationConfiguration != nil {
		ok := object.Key("initializationConfiguration")
		if err := awsRestjson1_serializeDocumentInitializationConfiguration(v.InitializationConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAlarmEventActions(v *types.AlarmEventActions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AlarmActions != nil {
		ok := object.Key("alarmActions")
		if err := awsRestjson1_serializeDocumentAlarmActions(v.AlarmActions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAlarmNotification(v *types.AlarmNotification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NotificationActions != nil {
		ok := object.Key("notificationActions")
		if err := awsRestjson1_serializeDocumentNotificationActions(v.NotificationActions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAlarmRule(v *types.AlarmRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SimpleRule != nil {
		ok := object.Key("simpleRule")
		if err := awsRestjson1_serializeDocumentSimpleRule(v.SimpleRule, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetPropertyTimestamp(v *types.AssetPropertyTimestamp, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OffsetInNanos != nil {
		ok := object.Key("offsetInNanos")
		ok.String(*v.OffsetInNanos)
	}

	if v.TimeInSeconds != nil {
		ok := object.Key("timeInSeconds")
		ok.String(*v.TimeInSeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetPropertyValue(v *types.AssetPropertyValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Quality != nil {
		ok := object.Key("quality")
		ok.String(*v.Quality)
	}

	if v.Timestamp != nil {
		ok := object.Key("timestamp")
		if err := awsRestjson1_serializeDocumentAssetPropertyTimestamp(v.Timestamp, ok); err != nil {
			return err
		}
	}

	if v.Value != nil {
		ok := object.Key("value")
		if err := awsRestjson1_serializeDocumentAssetPropertyVariant(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssetPropertyVariant(v *types.AssetPropertyVariant, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BooleanValue != nil {
		ok := object.Key("booleanValue")
		ok.String(*v.BooleanValue)
	}

	if v.DoubleValue != nil {
		ok := object.Key("doubleValue")
		ok.String(*v.DoubleValue)
	}

	if v.IntegerValue != nil {
		ok := object.Key("integerValue")
		ok.String(*v.IntegerValue)
	}

	if v.StringValue != nil {
		ok := object.Key("stringValue")
		ok.String(*v.StringValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentAttribute(v *types.Attribute, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JsonPath != nil {
		ok := object.Key("jsonPath")
		ok.String(*v.JsonPath)
	}

	return nil
}

func awsRestjson1_serializeDocumentAttributes(v []types.Attribute, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAttribute(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentClearTimerAction(v *types.ClearTimerAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TimerName != nil {
		ok := object.Key("timerName")
		ok.String(*v.TimerName)
	}

	return nil
}

func awsRestjson1_serializeDocumentDetectorDebugOption(v *types.DetectorDebugOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DetectorModelName != nil {
		ok := object.Key("detectorModelName")
		ok.String(*v.DetectorModelName)
	}

	if v.KeyValue != nil {
		ok := object.Key("keyValue")
		ok.String(*v.KeyValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentDetectorDebugOptions(v []types.DetectorDebugOption, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDetectorDebugOption(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDetectorModelDefinition(v *types.DetectorModelDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InitialStateName != nil {
		ok := object.Key("initialStateName")
		ok.String(*v.InitialStateName)
	}

	if v.States != nil {
		ok := object.Key("states")
		if err := awsRestjson1_serializeDocumentStates(v.States, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDynamoDBAction(v *types.DynamoDBAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.HashKeyField != nil {
		ok := object.Key("hashKeyField")
		ok.String(*v.HashKeyField)
	}

	if v.HashKeyType != nil {
		ok := object.Key("hashKeyType")
		ok.String(*v.HashKeyType)
	}

	if v.HashKeyValue != nil {
		ok := object.Key("hashKeyValue")
		ok.String(*v.HashKeyValue)
	}

	if v.Operation != nil {
		ok := object.Key("operation")
		ok.String(*v.Operation)
	}

	if v.Payload != nil {
		ok := object.Key("payload")
		if err := awsRestjson1_serializeDocumentPayload(v.Payload, ok); err != nil {
			return err
		}
	}

	if v.PayloadField != nil {
		ok := object.Key("payloadField")
		ok.String(*v.PayloadField)
	}

	if v.RangeKeyField != nil {
		ok := object.Key("rangeKeyField")
		ok.String(*v.RangeKeyField)
	}

	if v.RangeKeyType != nil {
		ok := object.Key("rangeKeyType")
		ok.String(*v.RangeKeyType)
	}

	if v.RangeKeyValue != nil {
		ok := object.Key("rangeKeyValue")
		ok.String(*v.RangeKeyValue)
	}

	if v.TableName != nil {
		ok := object.Key("tableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsRestjson1_serializeDocumentDynamoDBv2Action(v *types.DynamoDBv2Action, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Payload != nil {
		ok := object.Key("payload")
		if err := awsRestjson1_serializeDocumentPayload(v.Payload, ok); err != nil {
			return err
		}
	}

	if v.TableName != nil {
		ok := object.Key("tableName")
		ok.String(*v.TableName)
	}

	return nil
}

func awsRestjson1_serializeDocumentEmailConfiguration(v *types.EmailConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Content != nil {
		ok := object.Key("content")
		if err := awsRestjson1_serializeDocumentEmailContent(v.Content, ok); err != nil {
			return err
		}
	}

	if v.From != nil {
		ok := object.Key("from")
		ok.String(*v.From)
	}

	if v.Recipients != nil {
		ok := object.Key("recipients")
		if err := awsRestjson1_serializeDocumentEmailRecipients(v.Recipients, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEmailConfigurations(v []types.EmailConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentEmailConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEmailContent(v *types.EmailContent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalMessage != nil {
		ok := object.Key("additionalMessage")
		ok.String(*v.AdditionalMessage)
	}

	if v.Subject != nil {
		ok := object.Key("subject")
		ok.String(*v.Subject)
	}

	return nil
}

func awsRestjson1_serializeDocumentEmailRecipients(v *types.EmailRecipients, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.To != nil {
		ok := object.Key("to")
		if err := awsRestjson1_serializeDocumentRecipientDetails(v.To, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEvent(v *types.Event, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("actions")
		if err := awsRestjson1_serializeDocumentActions(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.Condition != nil {
		ok := object.Key("condition")
		ok.String(*v.Condition)
	}

	if v.EventName != nil {
		ok := object.Key("eventName")
		ok.String(*v.EventName)
	}

	return nil
}

func awsRestjson1_serializeDocumentEvents(v []types.Event, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentEvent(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFirehoseAction(v *types.FirehoseAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeliveryStreamName != nil {
		ok := object.Key("deliveryStreamName")
		ok.String(*v.DeliveryStreamName)
	}

	if v.Payload != nil {
		ok := object.Key("payload")
		if err := awsRestjson1_serializeDocumentPayload(v.Payload, ok); err != nil {
			return err
		}
	}

	if v.Separator != nil {
		ok := object.Key("separator")
		ok.String(*v.Separator)
	}

	return nil
}

func awsRestjson1_serializeDocumentInitializationConfiguration(v *types.InitializationConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisabledOnInitialization != nil {
		ok := object.Key("disabledOnInitialization")
		ok.Boolean(*v.DisabledOnInitialization)
	}

	return nil
}

func awsRestjson1_serializeDocumentInputDefinition(v *types.InputDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsRestjson1_serializeDocumentAttributes(v.Attributes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInputIdentifier(v *types.InputIdentifier, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IotEventsInputIdentifier != nil {
		ok := object.Key("iotEventsInputIdentifier")
		if err := awsRestjson1_serializeDocumentIotEventsInputIdentifier(v.IotEventsInputIdentifier, ok); err != nil {
			return err
		}
	}

	if v.IotSiteWiseInputIdentifier != nil {
		ok := object.Key("iotSiteWiseInputIdentifier")
		if err := awsRestjson1_serializeDocumentIotSiteWiseInputIdentifier(v.IotSiteWiseInputIdentifier, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIotEventsAction(v *types.IotEventsAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputName != nil {
		ok := object.Key("inputName")
		ok.String(*v.InputName)
	}

	if v.Payload != nil {
		ok := object.Key("payload")
		if err := awsRestjson1_serializeDocumentPayload(v.Payload, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIotEventsInputIdentifier(v *types.IotEventsInputIdentifier, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InputName != nil {
		ok := object.Key("inputName")
		ok.String(*v.InputName)
	}

	return nil
}

func awsRestjson1_serializeDocumentIotSiteWiseAction(v *types.IotSiteWiseAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AssetId != nil {
		ok := object.Key("assetId")
		ok.String(*v.AssetId)
	}

	if v.EntryId != nil {
		ok := object.Key("entryId")
		ok.String(*v.EntryId)
	}

	if v.PropertyAlias != nil {
		ok := object.Key("propertyAlias")
		ok.String(*v.PropertyAlias)
	}

	if v.PropertyId != nil {
		ok := object.Key("propertyId")
		ok.String(*v.PropertyId)
	}

	if v.PropertyValue != nil {
		ok := object.Key("propertyValue")
		if err := awsRestjson1_serializeDocumentAssetPropertyValue(v.PropertyValue, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIotSiteWiseAssetModelPropertyIdentifier(v *types.IotSiteWiseAssetModelPropertyIdentifier, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AssetModelId != nil {
		ok := object.Key("assetModelId")
		ok.String(*v.AssetModelId)
	}

	if v.PropertyId != nil {
		ok := object.Key("propertyId")
		ok.String(*v.PropertyId)
	}

	return nil
}

func awsRestjson1_serializeDocumentIotSiteWiseInputIdentifier(v *types.IotSiteWiseInputIdentifier, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IotSiteWiseAssetModelPropertyIdentifier != nil {
		ok := object.Key("iotSiteWiseAssetModelPropertyIdentifier")
		if err := awsRestjson1_serializeDocumentIotSiteWiseAssetModelPropertyIdentifier(v.IotSiteWiseAssetModelPropertyIdentifier, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIotTopicPublishAction(v *types.IotTopicPublishAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MqttTopic != nil {
		ok := object.Key("mqttTopic")
		ok.String(*v.MqttTopic)
	}

	if v.Payload != nil {
		ok := object.Key("payload")
		if err := awsRestjson1_serializeDocumentPayload(v.Payload, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentLambdaAction(v *types.LambdaAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FunctionArn != nil {
		ok := object.Key("functionArn")
		ok.String(*v.FunctionArn)
	}

	if v.Payload != nil {
		ok := object.Key("payload")
		if err := awsRestjson1_serializeDocumentPayload(v.Payload, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentLoggingOptions(v *types.LoggingOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DetectorDebugOptions != nil {
		ok := object.Key("detectorDebugOptions")
		if err := awsRestjson1_serializeDocumentDetectorDebugOptions(v.DetectorDebugOptions, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	if len(v.Level) > 0 {
		ok := object.Key("level")
		ok.String(string(v.Level))
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentNotificationAction(v *types.NotificationAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Action != nil {
		ok := object.Key("action")
		if err := awsRestjson1_serializeDocumentNotificationTargetActions(v.Action, ok); err != nil {
			return err
		}
	}

	if v.EmailConfigurations != nil {
		ok := object.Key("emailConfigurations")
		if err := awsRestjson1_serializeDocumentEmailConfigurations(v.EmailConfigurations, ok); err != nil {
			return err
		}
	}

	if v.SmsConfigurations != nil {
		ok := object.Key("smsConfigurations")
		if err := awsRestjson1_serializeDocumentSMSConfigurations(v.SmsConfigurations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNotificationActions(v []types.NotificationAction, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentNotificationAction(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentNotificationTargetActions(v *types.NotificationTargetActions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LambdaAction != nil {
		ok := object.Key("lambdaAction")
		if err := awsRestjson1_serializeDocumentLambdaAction(v.LambdaAction, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOnEnterLifecycle(v *types.OnEnterLifecycle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Events != nil {
		ok := object.Key("events")
		if err := awsRestjson1_serializeDocumentEvents(v.Events, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOnExitLifecycle(v *types.OnExitLifecycle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Events != nil {
		ok := object.Key("events")
		if err := awsRestjson1_serializeDocumentEvents(v.Events, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOnInputLifecycle(v *types.OnInputLifecycle, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Events != nil {
		ok := object.Key("events")
		if err := awsRestjson1_serializeDocumentEvents(v.Events, ok); err != nil {
			return err
		}
	}

	if v.TransitionEvents != nil {
		ok := object.Key("transitionEvents")
		if err := awsRestjson1_serializeDocumentTransitionEvents(v.TransitionEvents, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPayload(v *types.Payload, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ContentExpression != nil {
		ok := object.Key("contentExpression")
		ok.String(*v.ContentExpression)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentRecipientDetail(v *types.RecipientDetail, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SsoIdentity != nil {
		ok := object.Key("ssoIdentity")
		if err := awsRestjson1_serializeDocumentSSOIdentity(v.SsoIdentity, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRecipientDetails(v []types.RecipientDetail, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRecipientDetail(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentResetTimerAction(v *types.ResetTimerAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TimerName != nil {
		ok := object.Key("timerName")
		ok.String(*v.TimerName)
	}

	return nil
}

func awsRestjson1_serializeDocumentSetTimerAction(v *types.SetTimerAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DurationExpression != nil {
		ok := object.Key("durationExpression")
		ok.String(*v.DurationExpression)
	}

	if v.Seconds != nil {
		ok := object.Key("seconds")
		ok.Integer(*v.Seconds)
	}

	if v.TimerName != nil {
		ok := object.Key("timerName")
		ok.String(*v.TimerName)
	}

	return nil
}

func awsRestjson1_serializeDocumentSetVariableAction(v *types.SetVariableAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	if v.VariableName != nil {
		ok := object.Key("variableName")
		ok.String(*v.VariableName)
	}

	return nil
}

func awsRestjson1_serializeDocumentSimpleRule(v *types.SimpleRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ComparisonOperator) > 0 {
		ok := object.Key("comparisonOperator")
		ok.String(string(v.ComparisonOperator))
	}

	if v.InputProperty != nil {
		ok := object.Key("inputProperty")
		ok.String(*v.InputProperty)
	}

	if v.Threshold != nil {
		ok := object.Key("threshold")
		ok.String(*v.Threshold)
	}

	return nil
}

func awsRestjson1_serializeDocumentSMSConfiguration(v *types.SMSConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalMessage != nil {
		ok := object.Key("additionalMessage")
		ok.String(*v.AdditionalMessage)
	}

	if v.Recipients != nil {
		ok := object.Key("recipients")
		if err := awsRestjson1_serializeDocumentRecipientDetails(v.Recipients, ok); err != nil {
			return err
		}
	}

	if v.SenderId != nil {
		ok := object.Key("senderId")
		ok.String(*v.SenderId)
	}

	return nil
}

func awsRestjson1_serializeDocumentSMSConfigurations(v []types.SMSConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSMSConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSNSTopicPublishAction(v *types.SNSTopicPublishAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Payload != nil {
		ok := object.Key("payload")
		if err := awsRestjson1_serializeDocumentPayload(v.Payload, ok); err != nil {
			return err
		}
	}

	if v.TargetArn != nil {
		ok := object.Key("targetArn")
		ok.String(*v.TargetArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentSqsAction(v *types.SqsAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Payload != nil {
		ok := object.Key("payload")
		if err := awsRestjson1_serializeDocumentPayload(v.Payload, ok); err != nil {
			return err
		}
	}

	if v.QueueUrl != nil {
		ok := object.Key("queueUrl")
		ok.String(*v.QueueUrl)
	}

	if v.UseBase64 != nil {
		ok := object.Key("useBase64")
		ok.Boolean(*v.UseBase64)
	}

	return nil
}

func awsRestjson1_serializeDocumentSSOIdentity(v *types.SSOIdentity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IdentityStoreId != nil {
		ok := object.Key("identityStoreId")
		ok.String(*v.IdentityStoreId)
	}

	if v.UserId != nil {
		ok := object.Key("userId")
		ok.String(*v.UserId)
	}

	return nil
}

func awsRestjson1_serializeDocumentState(v *types.State, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.OnEnter != nil {
		ok := object.Key("onEnter")
		if err := awsRestjson1_serializeDocumentOnEnterLifecycle(v.OnEnter, ok); err != nil {
			return err
		}
	}

	if v.OnExit != nil {
		ok := object.Key("onExit")
		if err := awsRestjson1_serializeDocumentOnExitLifecycle(v.OnExit, ok); err != nil {
			return err
		}
	}

	if v.OnInput != nil {
		ok := object.Key("onInput")
		if err := awsRestjson1_serializeDocumentOnInputLifecycle(v.OnInput, ok); err != nil {
			return err
		}
	}

	if v.StateName != nil {
		ok := object.Key("stateName")
		ok.String(*v.StateName)
	}

	return nil
}

func awsRestjson1_serializeDocumentStates(v []types.State, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentState(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentTags(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTransitionEvent(v *types.TransitionEvent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("actions")
		if err := awsRestjson1_serializeDocumentActions(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.Condition != nil {
		ok := object.Key("condition")
		ok.String(*v.Condition)
	}

	if v.EventName != nil {
		ok := object.Key("eventName")
		ok.String(*v.EventName)
	}

	if v.NextState != nil {
		ok := object.Key("nextState")
		ok.String(*v.NextState)
	}

	return nil
}

func awsRestjson1_serializeDocumentTransitionEvents(v []types.TransitionEvent, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTransitionEvent(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}
