// Code generated by smithy-go-codegen DO NOT EDIT.

package georoutes

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/georoutes/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// CalculateRoutes computes routes given the following required parameters: Origin
// and Destination .
func (c *Client) CalculateRoutes(ctx context.Context, params *CalculateRoutesInput, optFns ...func(*Options)) (*CalculateRoutesOutput, error) {
	if params == nil {
		params = &CalculateRoutesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CalculateRoutes", params, optFns, c.addOperationCalculateRoutesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CalculateRoutesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CalculateRoutesInput struct {

	// The final position for the route. In the World Geodetic System (WGS 84) format:
	// [longitude, latitude] .
	//
	// This member is required.
	Destination []float64

	// The start position for the route.
	//
	// This member is required.
	Origin []float64

	// Features that are allowed while calculating a route.
	Allow *types.RouteAllowOptions

	// Time of arrival at the destination.
	//
	// Time format: YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm
	//
	// Examples:
	//
	//     2020-04-22T17:57:24Z
	//
	//     2020-04-22T17:57:24+02:00
	ArrivalTime *string

	// Features that are avoided while calculating a route. Avoidance is on a
	// best-case basis. If an avoidance can't be satisfied for a particular case, it
	// violates the avoidance and the returned response produces a notice for the
	// violation.
	Avoid *types.RouteAvoidanceOptions

	// Uses the current time as the time of departure.
	DepartNow *bool

	// Time of departure from thr origin.
	//
	// Time format: YYYY-MM-DDThh:mm:ss.sssZ | YYYY-MM-DDThh:mm:ss.sss+hh:mm
	//
	// Examples:
	//
	//     2020-04-22T17:57:24Z
	//
	//     2020-04-22T17:57:24+02:00
	DepartureTime *string

	// Destination related options.
	DestinationOptions *types.RouteDestinationOptions

	// Driver related options.
	Driver *types.RouteDriverOptions

	// Features to be strictly excluded while calculating the route.
	Exclude *types.RouteExclusionOptions

	// Measurement system to be used for instructions within steps in the response.
	InstructionsMeasurementSystem types.MeasurementSystem

	// Optional: The API key to be used for authorization. Either an API key or valid
	// SigV4 signature must be provided when making a request.
	Key *string

	// List of languages for instructions within steps in the response.
	//
	// Instructions in the requested language are returned only if they are available.
	Languages []string

	// A list of optional additional parameters such as timezone that can be requested
	// for each result.
	//
	//   - Elevation : Retrieves the elevation information for each location.
	//
	//   - Incidents : Provides information on traffic incidents along the route.
	//
	//   - PassThroughWaypoints : Indicates waypoints that are passed through without
	//   stopping.
	//
	//   - Summary : Returns a summary of the route, including distance and duration.
	//
	//   - Tolls : Supplies toll cost information along the route.
	//
	//   - TravelStepInstructions : Provides step-by-step instructions for travel along
	//   the route.
	//
	//   - TruckRoadTypes : Returns information about road types suitable for trucks.
	//
	//   - TypicalDuration : Gives typical travel duration based on historical data.
	//
	//   - Zones : Specifies the time zone information for each waypoint.
	LegAdditionalFeatures []types.RouteLegAdditionalFeature

	// Specifies the format of the geometry returned for each leg of the route. You
	// can choose between two different geometry encoding formats.
	//
	// FlexiblePolyline : A compact and precise encoding format for the leg geometry.
	// For more information on the format, see the GitHub repository for [FlexiblePolyline]
	// FlexiblePolyline .
	//
	// Simple : A less compact encoding, which is easier to decode but may be less
	// precise and result in larger payloads.
	//
	// [FlexiblePolyline]: https://github.com/heremaps/flexible-polyline
	LegGeometryFormat types.GeometryFormat

	// Maximum number of alternative routes to be provided in the response, if
	// available.
	MaxAlternatives *int32

	// Specifies the optimization criteria for calculating a route.
	//
	// Default Value: FastestRoute
	OptimizeRoutingFor types.RoutingObjective

	// Origin related options.
	OriginOptions *types.RouteOriginOptions

	// A list of optional features such as SpeedLimit that can be requested for a
	// Span. A span is a section of a Leg for which the requested features have the
	// same values.
	SpanAdditionalFeatures []types.RouteSpanAdditionalFeature

	// Toll related options.
	Tolls *types.RouteTollOptions

	// Traffic related options.
	Traffic *types.RouteTrafficOptions

	// Specifies the mode of transport when calculating a route. Used in estimating
	// the speed of travel and road compatibility.
	//
	// Default Value: Car
	TravelMode types.RouteTravelMode

	// Travel mode related options for the provided travel mode.
	TravelModeOptions *types.RouteTravelModeOptions

	// Type of step returned by the response. Default provides basic steps intended
	// for web based applications. TurnByTurn provides detailed instructions with more
	// granularity intended for a turn based navigation system.
	TravelStepType types.RouteTravelStepType

	// List of waypoints between the Origin and Destination.
	Waypoints []types.RouteWaypoint

	noSmithyDocumentSerde
}

type CalculateRoutesOutput struct {

	// Specifies the format of the geometry returned for each leg of the route.
	//
	// This member is required.
	LegGeometryFormat types.GeometryFormat

	// Notices are additional information returned that indicate issues that occurred
	// during route calculation.
	//
	// This member is required.
	Notices []types.RouteResponseNotice

	// The pricing bucket for which the query is charged at.
	//
	// This member is required.
	PricingBucket *string

	// The path from the origin to the destination.
	//
	// This member is required.
	Routes []types.Route

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCalculateRoutesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCalculateRoutes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCalculateRoutes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CalculateRoutes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCalculateRoutesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCalculateRoutes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCalculateRoutes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CalculateRoutes",
	}
}
