// Code generated by smithy-go-codegen DO NOT EDIT.

package emrserverless

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/emrserverless/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all attempt of a job run.
func (c *Client) ListJobRunAttempts(ctx context.Context, params *ListJobRunAttemptsInput, optFns ...func(*Options)) (*ListJobRunAttemptsOutput, error) {
	if params == nil {
		params = &ListJobRunAttemptsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListJobRunAttempts", params, optFns, c.addOperationListJobRunAttemptsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListJobRunAttemptsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListJobRunAttemptsInput struct {

	// The ID of the application for which to list job runs.
	//
	// This member is required.
	ApplicationId *string

	// The ID of the job run to list.
	//
	// This member is required.
	JobRunId *string

	// The maximum number of job run attempts to list.
	MaxResults *int32

	// The token for the next set of job run attempt results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListJobRunAttemptsOutput struct {

	// The array of the listed job run attempt objects.
	//
	// This member is required.
	JobRunAttempts []types.JobRunAttemptSummary

	// The output displays the token for the next set of application results. This is
	// required for pagination and is available as a response of the previous request.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListJobRunAttemptsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListJobRunAttempts{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListJobRunAttempts{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListJobRunAttempts"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListJobRunAttemptsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListJobRunAttempts(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListJobRunAttemptsPaginatorOptions is the paginator options for
// ListJobRunAttempts
type ListJobRunAttemptsPaginatorOptions struct {
	// The maximum number of job run attempts to list.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListJobRunAttemptsPaginator is a paginator for ListJobRunAttempts
type ListJobRunAttemptsPaginator struct {
	options   ListJobRunAttemptsPaginatorOptions
	client    ListJobRunAttemptsAPIClient
	params    *ListJobRunAttemptsInput
	nextToken *string
	firstPage bool
}

// NewListJobRunAttemptsPaginator returns a new ListJobRunAttemptsPaginator
func NewListJobRunAttemptsPaginator(client ListJobRunAttemptsAPIClient, params *ListJobRunAttemptsInput, optFns ...func(*ListJobRunAttemptsPaginatorOptions)) *ListJobRunAttemptsPaginator {
	if params == nil {
		params = &ListJobRunAttemptsInput{}
	}

	options := ListJobRunAttemptsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListJobRunAttemptsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListJobRunAttemptsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListJobRunAttempts page.
func (p *ListJobRunAttemptsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListJobRunAttemptsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListJobRunAttempts(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListJobRunAttemptsAPIClient is a client that implements the ListJobRunAttempts
// operation.
type ListJobRunAttemptsAPIClient interface {
	ListJobRunAttempts(context.Context, *ListJobRunAttemptsInput, ...func(*Options)) (*ListJobRunAttemptsOutput, error)
}

var _ ListJobRunAttemptsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListJobRunAttempts(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListJobRunAttempts",
	}
}
