// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// A summary of the properties of a cluster.
type ClusterSummary struct {

	// The ARN of the cluster.
	//
	// This member is required.
	Arn *string

	// The ID of the cluster.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

// Configuration details about encryption for the cluster including the KMS key
// ARN, encryption type, and encryption status.
type EncryptionDetails struct {

	// The status of encryption for the cluster.
	//
	// This member is required.
	EncryptionStatus EncryptionStatus

	// The type of encryption that protects the data on your cluster.
	//
	// This member is required.
	EncryptionType EncryptionType

	// The ARN of the KMS key that encrypts data in the cluster.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// Defines the structure for multi-Region cluster configurations, containing the
// witness region and linked cluster settings.
type MultiRegionProperties struct {

	// The set of linked clusters that form the multi-Region cluster configuration.
	// Each linked cluster represents a database instance in a different Region.
	Clusters []string

	// The that serves as the witness region for a multi-Region cluster. The witness
	// region helps maintain cluster consistency and quorum.
	WitnessRegion *string

	noSmithyDocumentSerde
}

// Stores information about a field passed inside a request that resulted in an
// validation error.
type ValidationExceptionField struct {

	// A message describing why this field failed validation.
	//
	// This member is required.
	Message *string

	// The name of the field.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
