// Code generated by smithy-go-codegen DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// A user pool domain hosts managed login, an authorization server and web server
// for authentication in your application. This operation creates a new user pool
// prefix domain or custom domain and sets the managed login branding version. Set
// the branding version to 1 for hosted UI (classic) or 2 for managed login. When
// you choose a custom domain, you must provide an SSL certificate in the US East
// (N. Virginia) Amazon Web Services Region in your request.
//
// Your prefix domain might take up to one minute to take effect. Your custom
// domain is online within five minutes, but it can take up to one hour to
// distribute your SSL certificate.
//
// For more information about adding a custom domain to your user pool, see [Configuring a user pool domain].
//
// Amazon Cognito evaluates Identity and Access Management (IAM) policies in
// requests for this API operation. For this operation, you must use IAM
// credentials to authorize requests, and you must grant yourself the corresponding
// IAM permission in a policy.
//
// # Learn more
//
// [Signing Amazon Web Services API Requests]
//
// [Using the Amazon Cognito user pools API and user pool endpoints]
//
// [Using the Amazon Cognito user pools API and user pool endpoints]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html
// [Configuring a user pool domain]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html
// [Signing Amazon Web Services API Requests]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html
func (c *Client) CreateUserPoolDomain(ctx context.Context, params *CreateUserPoolDomainInput, optFns ...func(*Options)) (*CreateUserPoolDomainOutput, error) {
	if params == nil {
		params = &CreateUserPoolDomainInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateUserPoolDomain", params, optFns, c.addOperationCreateUserPoolDomainMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateUserPoolDomainOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateUserPoolDomainInput struct {

	// The domain string. For custom domains, this is the fully-qualified domain name,
	// such as auth.example.com . For prefix domains, this is the prefix alone, such as
	// myprefix . A prefix value of myprefix for a user pool in the us-east-1 Region
	// results in a domain of myprefix.auth.us-east-1.amazoncognito.com .
	//
	// This member is required.
	Domain *string

	// The ID of the user pool where you want to add a domain.
	//
	// This member is required.
	UserPoolId *string

	// The configuration for a custom domain. Configures your domain with an
	// Certificate Manager certificate in the us-east-1 Region.
	//
	// Provide this parameter only if you want to use a [custom domain] for your user pool.
	// Otherwise, you can omit this parameter and use a [prefix domain]instead.
	//
	// When you create a custom domain, the passkey RP ID defaults to the custom
	// domain. If you had a prefix domain active, this will cause passkey integration
	// for your prefix domain to stop working due to a mismatch in RP ID. To keep the
	// prefix domain passkey integration working, you can explicitly set RP ID to the
	// prefix domain.
	//
	// [custom domain]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html
	// [prefix domain]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain-prefix.html
	CustomDomainConfig *types.CustomDomainConfigType

	// The version of managed login branding that you want to apply to your domain. A
	// value of 1 indicates hosted UI (classic) and a version of 2 indicates managed
	// login.
	//
	// Managed login requires that your user pool be configured for any [feature plan] other than
	// Lite .
	//
	// [feature plan]: https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-sign-in-feature-plans.html
	ManagedLoginVersion *int32

	noSmithyDocumentSerde
}

type CreateUserPoolDomainOutput struct {

	// The fully-qualified domain name (FQDN) of the Amazon CloudFront distribution
	// that hosts your managed login or classic hosted UI pages. Your domain-name
	// authority must have an alias record that points requests for your custom domain
	// to this FQDN. Amazon Cognito returns this value if you set a custom domain with
	// CustomDomainConfig . If you set an Amazon Cognito prefix domain, this parameter
	// returns null.
	CloudFrontDomain *string

	// The version of managed login branding applied your domain. A value of 1
	// indicates hosted UI (classic) and a version of 2 indicates managed login.
	ManagedLoginVersion *int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateUserPoolDomainMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateUserPoolDomain{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateUserPoolDomain{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateUserPoolDomain"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateUserPoolDomainValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateUserPoolDomain(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateUserPoolDomain(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateUserPoolDomain",
	}
}
