// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagent

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagent/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists knowledge bases associated with an agent and information about each one.
func (c *Client) ListAgentKnowledgeBases(ctx context.Context, params *ListAgentKnowledgeBasesInput, optFns ...func(*Options)) (*ListAgentKnowledgeBasesOutput, error) {
	if params == nil {
		params = &ListAgentKnowledgeBasesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAgentKnowledgeBases", params, optFns, c.addOperationListAgentKnowledgeBasesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAgentKnowledgeBasesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAgentKnowledgeBasesInput struct {

	// The unique identifier of the agent for which to return information about
	// knowledge bases associated with it.
	//
	// This member is required.
	AgentId *string

	// The version of the agent for which to return information about knowledge bases
	// associated with it.
	//
	// This member is required.
	AgentVersion *string

	// The maximum number of results to return in the response. If the total number of
	// results is greater than this value, use the token returned in the response in
	// the nextToken field when making another request to return the next batch of
	// results.
	MaxResults *int32

	// If the total number of results is greater than the maxResults value provided in
	// the request, enter the token returned in the nextToken field in the response in
	// this field to return the next batch of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAgentKnowledgeBasesOutput struct {

	// A list of objects, each of which contains information about a knowledge base
	// associated with the agent.
	//
	// This member is required.
	AgentKnowledgeBaseSummaries []types.AgentKnowledgeBaseSummary

	// If the total number of results is greater than the maxResults value provided in
	// the request, use this token when making another request in the nextToken field
	// to return the next batch of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAgentKnowledgeBasesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAgentKnowledgeBases{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAgentKnowledgeBases{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAgentKnowledgeBases"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAgentKnowledgeBasesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAgentKnowledgeBases(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListAgentKnowledgeBasesPaginatorOptions is the paginator options for
// ListAgentKnowledgeBases
type ListAgentKnowledgeBasesPaginatorOptions struct {
	// The maximum number of results to return in the response. If the total number of
	// results is greater than this value, use the token returned in the response in
	// the nextToken field when making another request to return the next batch of
	// results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAgentKnowledgeBasesPaginator is a paginator for ListAgentKnowledgeBases
type ListAgentKnowledgeBasesPaginator struct {
	options   ListAgentKnowledgeBasesPaginatorOptions
	client    ListAgentKnowledgeBasesAPIClient
	params    *ListAgentKnowledgeBasesInput
	nextToken *string
	firstPage bool
}

// NewListAgentKnowledgeBasesPaginator returns a new
// ListAgentKnowledgeBasesPaginator
func NewListAgentKnowledgeBasesPaginator(client ListAgentKnowledgeBasesAPIClient, params *ListAgentKnowledgeBasesInput, optFns ...func(*ListAgentKnowledgeBasesPaginatorOptions)) *ListAgentKnowledgeBasesPaginator {
	if params == nil {
		params = &ListAgentKnowledgeBasesInput{}
	}

	options := ListAgentKnowledgeBasesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAgentKnowledgeBasesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAgentKnowledgeBasesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAgentKnowledgeBases page.
func (p *ListAgentKnowledgeBasesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAgentKnowledgeBasesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAgentKnowledgeBases(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAgentKnowledgeBasesAPIClient is a client that implements the
// ListAgentKnowledgeBases operation.
type ListAgentKnowledgeBasesAPIClient interface {
	ListAgentKnowledgeBases(context.Context, *ListAgentKnowledgeBasesInput, ...func(*Options)) (*ListAgentKnowledgeBasesOutput, error)
}

var _ ListAgentKnowledgeBasesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAgentKnowledgeBases(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAgentKnowledgeBases",
	}
}
