// Code generated by smithy-go-codegen DO NOT EDIT.

package arczonalshift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/arczonalshift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Cancel an in-progress practice run zonal shift in Amazon Application Recovery
// Controller.
func (c *Client) CancelPracticeRun(ctx context.Context, params *CancelPracticeRunInput, optFns ...func(*Options)) (*CancelPracticeRunOutput, error) {
	if params == nil {
		params = &CancelPracticeRunInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CancelPracticeRun", params, optFns, c.addOperationCancelPracticeRunMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CancelPracticeRunOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CancelPracticeRunInput struct {

	// The identifier of a practice run zonal shift in Amazon Application Recovery
	// Controller that you want to cancel.
	//
	// This member is required.
	ZonalShiftId *string

	noSmithyDocumentSerde
}

type CancelPracticeRunOutput struct {

	// The Availability Zone (for example, use1-az1 ) that traffic was moved away from
	// for a resource that you specified for the practice run.
	//
	// This member is required.
	AwayFrom *string

	// The initial comment that you entered about the practice run. Be aware that this
	// comment can be overwritten by Amazon Web Services if the automatic check for
	// balanced capacity fails. For more information, see [Capacity checks for practice runs]in the Amazon Application
	// Recovery Controller Developer Guide.
	//
	// [Capacity checks for practice runs]: https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.capacity-check.html
	//
	// This member is required.
	Comment *string

	// The expiry time (expiration time) for an on-demand practice run zonal shift is
	// 30 minutes from the time when you start the practice run, unless you cancel it
	// before that time. However, be aware that the expiryTime field for practice run
	// zonal shifts always has a value of 1 minute.
	//
	// This member is required.
	ExpiryTime *time.Time

	// The identifier for the resource that you canceled a practice run zonal shift
	// for. The identifier is the Amazon Resource Name (ARN) for the resource.
	//
	// This member is required.
	ResourceIdentifier *string

	// The time (UTC) when the zonal shift starts.
	//
	// This member is required.
	StartTime *time.Time

	// A status for the practice run that you canceled (expected status is CANCELED).
	//
	// The Status for a practice run zonal shift can have one of the following values:
	//
	// This member is required.
	Status types.ZonalShiftStatus

	// The identifier of the practice run zonal shift in Amazon Application Recovery
	// Controller that was canceled.
	//
	// This member is required.
	ZonalShiftId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCancelPracticeRunMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCancelPracticeRun{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCancelPracticeRun{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CancelPracticeRun"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCancelPracticeRunValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCancelPracticeRun(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCancelPracticeRun(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CancelPracticeRun",
	}
}
