//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armresourcehealth

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SecurityAdvisoryImpactedResourcesClient contains the methods for the SecurityAdvisoryImpactedResources group.
// Don't use this type directly, use NewSecurityAdvisoryImpactedResourcesClient() instead.
type SecurityAdvisoryImpactedResourcesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewSecurityAdvisoryImpactedResourcesClient creates a new instance of SecurityAdvisoryImpactedResourcesClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewSecurityAdvisoryImpactedResourcesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*SecurityAdvisoryImpactedResourcesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &SecurityAdvisoryImpactedResourcesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// NewListBySubscriptionIDAndEventIDPager - Lists impacted resources in the subscription by an event (Security Advisory).
//
// Generated from API version 2023-10-01-preview
//   - eventTrackingID - Event Id which uniquely identifies ServiceHealth event.
//   - options - SecurityAdvisoryImpactedResourcesClientListBySubscriptionIDAndEventIDOptions contains the optional parameters
//     for the SecurityAdvisoryImpactedResourcesClient.NewListBySubscriptionIDAndEventIDPager method.
func (client *SecurityAdvisoryImpactedResourcesClient) NewListBySubscriptionIDAndEventIDPager(eventTrackingID string, options *SecurityAdvisoryImpactedResourcesClientListBySubscriptionIDAndEventIDOptions) *runtime.Pager[SecurityAdvisoryImpactedResourcesClientListBySubscriptionIDAndEventIDResponse] {
	return runtime.NewPager(runtime.PagingHandler[SecurityAdvisoryImpactedResourcesClientListBySubscriptionIDAndEventIDResponse]{
		More: func(page SecurityAdvisoryImpactedResourcesClientListBySubscriptionIDAndEventIDResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SecurityAdvisoryImpactedResourcesClientListBySubscriptionIDAndEventIDResponse) (SecurityAdvisoryImpactedResourcesClientListBySubscriptionIDAndEventIDResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SecurityAdvisoryImpactedResourcesClient.NewListBySubscriptionIDAndEventIDPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySubscriptionIDAndEventIDCreateRequest(ctx, eventTrackingID, options)
			}, nil)
			if err != nil {
				return SecurityAdvisoryImpactedResourcesClientListBySubscriptionIDAndEventIDResponse{}, err
			}
			return client.listBySubscriptionIDAndEventIDHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySubscriptionIDAndEventIDCreateRequest creates the ListBySubscriptionIDAndEventID request.
func (client *SecurityAdvisoryImpactedResourcesClient) listBySubscriptionIDAndEventIDCreateRequest(ctx context.Context, eventTrackingID string, options *SecurityAdvisoryImpactedResourcesClientListBySubscriptionIDAndEventIDOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.ResourceHealth/events/{eventTrackingId}/listSecurityAdvisoryImpactedResources"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if eventTrackingID == "" {
		return nil, errors.New("parameter eventTrackingID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{eventTrackingId}", url.PathEscape(eventTrackingID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	reqQP.Set("api-version", "2023-10-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionIDAndEventIDHandleResponse handles the ListBySubscriptionIDAndEventID response.
func (client *SecurityAdvisoryImpactedResourcesClient) listBySubscriptionIDAndEventIDHandleResponse(resp *http.Response) (SecurityAdvisoryImpactedResourcesClientListBySubscriptionIDAndEventIDResponse, error) {
	result := SecurityAdvisoryImpactedResourcesClientListBySubscriptionIDAndEventIDResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EventImpactedResourceListResult); err != nil {
		return SecurityAdvisoryImpactedResourcesClientListBySubscriptionIDAndEventIDResponse{}, err
	}
	return result, nil
}

// NewListByTenantIDAndEventIDPager - Lists impacted resources in the tenant by an event (Security Advisory).
//
// Generated from API version 2023-10-01-preview
//   - eventTrackingID - Event Id which uniquely identifies ServiceHealth event.
//   - options - SecurityAdvisoryImpactedResourcesClientListByTenantIDAndEventIDOptions contains the optional parameters for the
//     SecurityAdvisoryImpactedResourcesClient.NewListByTenantIDAndEventIDPager method.
func (client *SecurityAdvisoryImpactedResourcesClient) NewListByTenantIDAndEventIDPager(eventTrackingID string, options *SecurityAdvisoryImpactedResourcesClientListByTenantIDAndEventIDOptions) *runtime.Pager[SecurityAdvisoryImpactedResourcesClientListByTenantIDAndEventIDResponse] {
	return runtime.NewPager(runtime.PagingHandler[SecurityAdvisoryImpactedResourcesClientListByTenantIDAndEventIDResponse]{
		More: func(page SecurityAdvisoryImpactedResourcesClientListByTenantIDAndEventIDResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SecurityAdvisoryImpactedResourcesClientListByTenantIDAndEventIDResponse) (SecurityAdvisoryImpactedResourcesClientListByTenantIDAndEventIDResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SecurityAdvisoryImpactedResourcesClient.NewListByTenantIDAndEventIDPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByTenantIDAndEventIDCreateRequest(ctx, eventTrackingID, options)
			}, nil)
			if err != nil {
				return SecurityAdvisoryImpactedResourcesClientListByTenantIDAndEventIDResponse{}, err
			}
			return client.listByTenantIDAndEventIDHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByTenantIDAndEventIDCreateRequest creates the ListByTenantIDAndEventID request.
func (client *SecurityAdvisoryImpactedResourcesClient) listByTenantIDAndEventIDCreateRequest(ctx context.Context, eventTrackingID string, options *SecurityAdvisoryImpactedResourcesClientListByTenantIDAndEventIDOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.ResourceHealth/events/{eventTrackingId}/listSecurityAdvisoryImpactedResources"
	if eventTrackingID == "" {
		return nil, errors.New("parameter eventTrackingID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{eventTrackingId}", url.PathEscape(eventTrackingID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	reqQP.Set("api-version", "2023-10-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByTenantIDAndEventIDHandleResponse handles the ListByTenantIDAndEventID response.
func (client *SecurityAdvisoryImpactedResourcesClient) listByTenantIDAndEventIDHandleResponse(resp *http.Response) (SecurityAdvisoryImpactedResourcesClientListByTenantIDAndEventIDResponse, error) {
	result := SecurityAdvisoryImpactedResourcesClientListByTenantIDAndEventIDResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EventImpactedResourceListResult); err != nil {
		return SecurityAdvisoryImpactedResourcesClientListByTenantIDAndEventIDResponse{}, err
	}
	return result, nil
}
