//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armquota

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// GroupQuotaLocationSettingsClient contains the methods for the GroupQuotaLocationSettings group.
// Don't use this type directly, use NewGroupQuotaLocationSettingsClient() instead.
type GroupQuotaLocationSettingsClient struct {
	internal *arm.Client
}

// NewGroupQuotaLocationSettingsClient creates a new instance of GroupQuotaLocationSettingsClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewGroupQuotaLocationSettingsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*GroupQuotaLocationSettingsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &GroupQuotaLocationSettingsClient{
		internal: cl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Enables the GroupQuotas enforcement for the resource provider and the location specified. The resource
// provider will start using the group quotas as the overall quota for the subscriptions included in
// the GroupQuota. The subscriptions cannot request quota at subscription level. The subscriptions share the GroupQuotaLimits
// assigned to the GroupQuota. If the GroupQuotaLimits is used, then submit a
// groupQuotaLimit request for the specific resource - provider/location/resource. Once the GroupQuota Enforcement is enabled
// then, it cannot be deleted or reverted back. To disable GroupQuota
// Enforcement -
// 1. Remove all the subscriptions from the groupQuota using the delete API for Subscriptions (Check the example - GroupQuotaSubscriptions_Delete).
// 2. Ten delete the GroupQuota (Check the example - GroupQuotas_Delete).
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
//   - managementGroupID - Management Group Id.
//   - groupQuotaName - The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
//   - resourceProviderName - The resource provider name, such as - Microsoft.Compute. Currently only Microsoft.Compute resource
//     provider supports this API.
//   - location - The name of the Azure region.
//   - options - GroupQuotaLocationSettingsClientBeginCreateOrUpdateOptions contains the optional parameters for the GroupQuotaLocationSettingsClient.BeginCreateOrUpdate
//     method.
func (client *GroupQuotaLocationSettingsClient) BeginCreateOrUpdate(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, location string, options *GroupQuotaLocationSettingsClientBeginCreateOrUpdateOptions) (*runtime.Poller[GroupQuotaLocationSettingsClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, managementGroupID, groupQuotaName, resourceProviderName, location, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[GroupQuotaLocationSettingsClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[GroupQuotaLocationSettingsClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdate - Enables the GroupQuotas enforcement for the resource provider and the location specified. The resource
// provider will start using the group quotas as the overall quota for the subscriptions included in
// the GroupQuota. The subscriptions cannot request quota at subscription level. The subscriptions share the GroupQuotaLimits
// assigned to the GroupQuota. If the GroupQuotaLimits is used, then submit a
// groupQuotaLimit request for the specific resource - provider/location/resource. Once the GroupQuota Enforcement is enabled
// then, it cannot be deleted or reverted back. To disable GroupQuota
// Enforcement -
// 1. Remove all the subscriptions from the groupQuota using the delete API for Subscriptions (Check the example - GroupQuotaSubscriptions_Delete).
// 2. Ten delete the GroupQuota (Check the example - GroupQuotas_Delete).
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
func (client *GroupQuotaLocationSettingsClient) createOrUpdate(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, location string, options *GroupQuotaLocationSettingsClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "GroupQuotaLocationSettingsClient.BeginCreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, managementGroupID, groupQuotaName, resourceProviderName, location, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *GroupQuotaLocationSettingsClient) createOrUpdateCreateRequest(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, location string, options *GroupQuotaLocationSettingsClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/locationSettings/{location}"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if groupQuotaName == "" {
		return nil, errors.New("parameter groupQuotaName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{groupQuotaName}", url.PathEscape(groupQuotaName))
	if resourceProviderName == "" {
		return nil, errors.New("parameter resourceProviderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderName}", url.PathEscape(resourceProviderName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.LocationSettings != nil {
		if err := runtime.MarshalAsJSON(req, *options.LocationSettings); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// Get - Gets the GroupQuotas enforcement settings for the ResourceProvider/location. The locations, where GroupQuota enforcement
// is not enabled will return Not Found.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
//   - managementGroupID - Management Group Id.
//   - groupQuotaName - The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
//   - resourceProviderName - The resource provider name, such as - Microsoft.Compute. Currently only Microsoft.Compute resource
//     provider supports this API.
//   - location - The name of the Azure region.
//   - options - GroupQuotaLocationSettingsClientGetOptions contains the optional parameters for the GroupQuotaLocationSettingsClient.Get
//     method.
func (client *GroupQuotaLocationSettingsClient) Get(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, location string, options *GroupQuotaLocationSettingsClientGetOptions) (GroupQuotaLocationSettingsClientGetResponse, error) {
	var err error
	const operationName = "GroupQuotaLocationSettingsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, managementGroupID, groupQuotaName, resourceProviderName, location, options)
	if err != nil {
		return GroupQuotaLocationSettingsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GroupQuotaLocationSettingsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GroupQuotaLocationSettingsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *GroupQuotaLocationSettingsClient) getCreateRequest(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, location string, options *GroupQuotaLocationSettingsClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/locationSettings/{location}"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if groupQuotaName == "" {
		return nil, errors.New("parameter groupQuotaName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{groupQuotaName}", url.PathEscape(groupQuotaName))
	if resourceProviderName == "" {
		return nil, errors.New("parameter resourceProviderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderName}", url.PathEscape(resourceProviderName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *GroupQuotaLocationSettingsClient) getHandleResponse(resp *http.Response) (GroupQuotaLocationSettingsClientGetResponse, error) {
	result := GroupQuotaLocationSettingsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GroupQuotasEnforcementResponse); err != nil {
		return GroupQuotaLocationSettingsClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Returns only the list of the Azure regions settings, where the GroupQuotas enforcement is enabled. The locations
// not included in GroupQuota Enforcement will not be listed, the regions in failed status
// with listed as status Failed.
//
// Generated from API version 2023-06-01-preview
//   - managementGroupID - Management Group Id.
//   - groupQuotaName - The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
//   - resourceProviderName - The resource provider name, such as - Microsoft.Compute. Currently only Microsoft.Compute resource
//     provider supports this API.
//   - options - GroupQuotaLocationSettingsClientListOptions contains the optional parameters for the GroupQuotaLocationSettingsClient.NewListPager
//     method.
func (client *GroupQuotaLocationSettingsClient) NewListPager(managementGroupID string, groupQuotaName string, resourceProviderName string, options *GroupQuotaLocationSettingsClientListOptions) *runtime.Pager[GroupQuotaLocationSettingsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[GroupQuotaLocationSettingsClientListResponse]{
		More: func(page GroupQuotaLocationSettingsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *GroupQuotaLocationSettingsClientListResponse) (GroupQuotaLocationSettingsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "GroupQuotaLocationSettingsClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, managementGroupID, groupQuotaName, resourceProviderName, options)
			}, nil)
			if err != nil {
				return GroupQuotaLocationSettingsClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *GroupQuotaLocationSettingsClient) listCreateRequest(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, options *GroupQuotaLocationSettingsClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/locationSettings"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if groupQuotaName == "" {
		return nil, errors.New("parameter groupQuotaName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{groupQuotaName}", url.PathEscape(groupQuotaName))
	if resourceProviderName == "" {
		return nil, errors.New("parameter resourceProviderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderName}", url.PathEscape(resourceProviderName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *GroupQuotaLocationSettingsClient) listHandleResponse(resp *http.Response) (GroupQuotaLocationSettingsClientListResponse, error) {
	result := GroupQuotaLocationSettingsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GroupQuotasEnforcementListResponse); err != nil {
		return GroupQuotaLocationSettingsClientListResponse{}, err
	}
	return result, nil
}

// BeginUpdate - Enables the GroupQuotas enforcement for the resource provider and the location specified. The resource provider
// will start using the group quotas as the overall quota for the subscriptions included in
// the GroupQuota. The subscriptions cannot request quota at subscription level. The subscriptions share the GroupQuotaLimits
// assigned to the GroupQuota. If the GroupQuotaLimits is used, then submit a
// groupQuotaLimit request for the specific resource - provider/location/resource. Once the GroupQuota Enforcement is enabled
// then, it cannot be deleted or reverted back. To disable GroupQuota
// Enforcement -
// 1. Remove all the subscriptions from the groupQuota using the delete API for Subscriptions (Check the example - GroupQuotaSubscriptions_Delete).
// 2. Ten delete the GroupQuota (Check the example - GroupQuotas_Delete).
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
//   - managementGroupID - Management Group Id.
//   - groupQuotaName - The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
//   - resourceProviderName - The resource provider name, such as - Microsoft.Compute. Currently only Microsoft.Compute resource
//     provider supports this API.
//   - location - The name of the Azure region.
//   - options - GroupQuotaLocationSettingsClientBeginUpdateOptions contains the optional parameters for the GroupQuotaLocationSettingsClient.BeginUpdate
//     method.
func (client *GroupQuotaLocationSettingsClient) BeginUpdate(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, location string, options *GroupQuotaLocationSettingsClientBeginUpdateOptions) (*runtime.Poller[GroupQuotaLocationSettingsClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, managementGroupID, groupQuotaName, resourceProviderName, location, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[GroupQuotaLocationSettingsClientUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[GroupQuotaLocationSettingsClientUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Update - Enables the GroupQuotas enforcement for the resource provider and the location specified. The resource provider
// will start using the group quotas as the overall quota for the subscriptions included in
// the GroupQuota. The subscriptions cannot request quota at subscription level. The subscriptions share the GroupQuotaLimits
// assigned to the GroupQuota. If the GroupQuotaLimits is used, then submit a
// groupQuotaLimit request for the specific resource - provider/location/resource. Once the GroupQuota Enforcement is enabled
// then, it cannot be deleted or reverted back. To disable GroupQuota
// Enforcement -
// 1. Remove all the subscriptions from the groupQuota using the delete API for Subscriptions (Check the example - GroupQuotaSubscriptions_Delete).
// 2. Ten delete the GroupQuota (Check the example - GroupQuotas_Delete).
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
func (client *GroupQuotaLocationSettingsClient) update(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, location string, options *GroupQuotaLocationSettingsClientBeginUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "GroupQuotaLocationSettingsClient.BeginUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, managementGroupID, groupQuotaName, resourceProviderName, location, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateCreateRequest creates the Update request.
func (client *GroupQuotaLocationSettingsClient) updateCreateRequest(ctx context.Context, managementGroupID string, groupQuotaName string, resourceProviderName string, location string, options *GroupQuotaLocationSettingsClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}/resourceProviders/{resourceProviderName}/locationSettings/{location}"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if groupQuotaName == "" {
		return nil, errors.New("parameter groupQuotaName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{groupQuotaName}", url.PathEscape(groupQuotaName))
	if resourceProviderName == "" {
		return nil, errors.New("parameter resourceProviderName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderName}", url.PathEscape(resourceProviderName))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.LocationSettings != nil {
		if err := runtime.MarshalAsJSON(req, *options.LocationSettings); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}
