//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetwork_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/network/armnetwork/v5"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/ServiceTagInformationListResult.json
func ExampleServiceTagInformationClient_NewListPager_getListOfServiceTags() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServiceTagInformationClient().NewListPager("westeurope", &armnetwork.ServiceTagInformationClientListOptions{NoAddressPrefixes: nil,
		TagName: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ServiceTagInformationListResult = armnetwork.ServiceTagInformationListResult{
		// 	Value: []*armnetwork.ServiceTagInformation{
		// 		{
		// 			Name: to.Ptr("ApiManagement"),
		// 			ID: to.Ptr("ApiManagement"),
		// 			Properties: &armnetwork.ServiceTagInformationPropertiesFormat{
		// 				AddressPrefixes: []*string{
		// 					to.Ptr("13.64.39.16/32"),
		// 					to.Ptr("40.74.146.80/31"),
		// 					to.Ptr("40.74.147.32/28")},
		// 					ChangeNumber: to.Ptr("7"),
		// 					Region: to.Ptr(""),
		// 					SystemService: to.Ptr("AzureApiManagement"),
		// 				},
		// 			},
		// 			{
		// 				Name: to.Ptr("ApiManagement.AustraliaCentral"),
		// 				ID: to.Ptr("ApiManagement.AustraliaCentral"),
		// 				Properties: &armnetwork.ServiceTagInformationPropertiesFormat{
		// 					AddressPrefixes: []*string{
		// 						to.Ptr("20.36.106.68/31"),
		// 						to.Ptr("20.36.107.176/28")},
		// 						ChangeNumber: to.Ptr("2"),
		// 						Region: to.Ptr("australiacentral"),
		// 						SystemService: to.Ptr("AzureApiManagement"),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/ServiceTagInformationListResultWithNoAddressPrefixes.json
func ExampleServiceTagInformationClient_NewListPager_getListOfServiceTagsWithNoAddressPrefixes() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServiceTagInformationClient().NewListPager("westeurope", &armnetwork.ServiceTagInformationClientListOptions{NoAddressPrefixes: to.Ptr(true),
		TagName: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ServiceTagInformationListResult = armnetwork.ServiceTagInformationListResult{
		// 	Value: []*armnetwork.ServiceTagInformation{
		// 		{
		// 			Name: to.Ptr("ApiManagement"),
		// 			ID: to.Ptr("ApiManagement"),
		// 			Properties: &armnetwork.ServiceTagInformationPropertiesFormat{
		// 				AddressPrefixes: []*string{
		// 				},
		// 				ChangeNumber: to.Ptr("7"),
		// 				Region: to.Ptr(""),
		// 				SystemService: to.Ptr("AzureApiManagement"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("ApiManagement.AustraliaCentral"),
		// 			ID: to.Ptr("ApiManagement.AustraliaCentral"),
		// 			Properties: &armnetwork.ServiceTagInformationPropertiesFormat{
		// 				AddressPrefixes: []*string{
		// 				},
		// 				ChangeNumber: to.Ptr("2"),
		// 				Region: to.Ptr("australiacentral"),
		// 				SystemService: to.Ptr("AzureApiManagement"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d4205894880b989ede35d62d97c8e901ed14fb5a/specification/network/resource-manager/Microsoft.Network/stable/2023-09-01/examples/ServiceTagInformationListResultWithTagname.json
func ExampleServiceTagInformationClient_NewListPager_getListOfServiceTagsWithTagName() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServiceTagInformationClient().NewListPager("westeurope", &armnetwork.ServiceTagInformationClientListOptions{NoAddressPrefixes: nil,
		TagName: to.Ptr("ApiManagement"),
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ServiceTagInformationListResult = armnetwork.ServiceTagInformationListResult{
		// 	Value: []*armnetwork.ServiceTagInformation{
		// 		{
		// 			Name: to.Ptr("ApiManagement"),
		// 			ID: to.Ptr("ApiManagement"),
		// 			Properties: &armnetwork.ServiceTagInformationPropertiesFormat{
		// 				AddressPrefixes: []*string{
		// 					to.Ptr("13.64.39.16/32"),
		// 					to.Ptr("40.74.146.80/31"),
		// 					to.Ptr("40.74.147.32/28")},
		// 					ChangeNumber: to.Ptr("7"),
		// 					Region: to.Ptr(""),
		// 					SystemService: to.Ptr("AzureApiManagement"),
		// 				},
		// 		}},
		// 	}
	}
}
