//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmigrationdiscoverysap

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SapDiscoverySitesClient contains the methods for the SapDiscoverySites group.
// Don't use this type directly, use NewSapDiscoverySitesClient() instead.
type SapDiscoverySitesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewSapDiscoverySitesClient creates a new instance of SapDiscoverySitesClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewSapDiscoverySitesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*SapDiscoverySitesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &SapDiscoverySitesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreate - Creates a discovery site resource for SAP Migration. This resource will be used to run system discovery and
// assessment with Azure Migrate.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - sapDiscoverySiteName - The name of the discovery site resource for SAP Migration.
//   - resource - Resource create parameters.
//   - options - SapDiscoverySitesClientBeginCreateOptions contains the optional parameters for the SapDiscoverySitesClient.BeginCreate
//     method.
func (client *SapDiscoverySitesClient) BeginCreate(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, resource SAPDiscoverySite, options *SapDiscoverySitesClientBeginCreateOptions) (*runtime.Poller[SapDiscoverySitesClientCreateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.create(ctx, resourceGroupName, sapDiscoverySiteName, resource, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[SapDiscoverySitesClientCreateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[SapDiscoverySitesClientCreateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Create - Creates a discovery site resource for SAP Migration. This resource will be used to run system discovery and assessment
// with Azure Migrate.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01-preview
func (client *SapDiscoverySitesClient) create(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, resource SAPDiscoverySite, options *SapDiscoverySitesClientBeginCreateOptions) (*http.Response, error) {
	var err error
	const operationName = "SapDiscoverySitesClient.BeginCreate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, resourceGroupName, sapDiscoverySiteName, resource, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createCreateRequest creates the Create request.
func (client *SapDiscoverySitesClient) createCreateRequest(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, resource SAPDiscoverySite, options *SapDiscoverySitesClientBeginCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if sapDiscoverySiteName == "" {
		return nil, errors.New("parameter sapDiscoverySiteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sapDiscoverySiteName}", url.PathEscape(sapDiscoverySiteName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, resource); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDelete - Deletes a SAP Migration discovery site resource and its child resources, that is the associated SAP Instances
// and Server Instances.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - sapDiscoverySiteName - The name of the discovery site resource for SAP Migration.
//   - options - SapDiscoverySitesClientBeginDeleteOptions contains the optional parameters for the SapDiscoverySitesClient.BeginDelete
//     method.
func (client *SapDiscoverySitesClient) BeginDelete(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, options *SapDiscoverySitesClientBeginDeleteOptions) (*runtime.Poller[SapDiscoverySitesClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, sapDiscoverySiteName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[SapDiscoverySitesClientDeleteResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[SapDiscoverySitesClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Deletes a SAP Migration discovery site resource and its child resources, that is the associated SAP Instances
// and Server Instances.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01-preview
func (client *SapDiscoverySitesClient) deleteOperation(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, options *SapDiscoverySitesClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "SapDiscoverySitesClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, sapDiscoverySiteName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *SapDiscoverySitesClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, options *SapDiscoverySitesClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if sapDiscoverySiteName == "" {
		return nil, errors.New("parameter sapDiscoverySiteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sapDiscoverySiteName}", url.PathEscape(sapDiscoverySiteName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Gets a SAP Migration discovery site resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - sapDiscoverySiteName - The name of the discovery site resource for SAP Migration.
//   - options - SapDiscoverySitesClientGetOptions contains the optional parameters for the SapDiscoverySitesClient.Get method.
func (client *SapDiscoverySitesClient) Get(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, options *SapDiscoverySitesClientGetOptions) (SapDiscoverySitesClientGetResponse, error) {
	var err error
	const operationName = "SapDiscoverySitesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, sapDiscoverySiteName, options)
	if err != nil {
		return SapDiscoverySitesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SapDiscoverySitesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SapDiscoverySitesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *SapDiscoverySitesClient) getCreateRequest(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, options *SapDiscoverySitesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if sapDiscoverySiteName == "" {
		return nil, errors.New("parameter sapDiscoverySiteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sapDiscoverySiteName}", url.PathEscape(sapDiscoverySiteName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *SapDiscoverySitesClient) getHandleResponse(resp *http.Response) (SapDiscoverySitesClientGetResponse, error) {
	result := SapDiscoverySitesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SAPDiscoverySite); err != nil {
		return SapDiscoverySitesClientGetResponse{}, err
	}
	return result, nil
}

// BeginImportEntities - Import your SAP systems' inventory using the Discovery template [https://go.microsoft.com/fwlink/?linkid=2249111]
// into your SAP Migration discovery site resource and it's child resources, the SAP
// instances and Server instances.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - sapDiscoverySiteName - The name of the discovery site resource for SAP Migration.
//   - options - SapDiscoverySitesClientBeginImportEntitiesOptions contains the optional parameters for the SapDiscoverySitesClient.BeginImportEntities
//     method.
func (client *SapDiscoverySitesClient) BeginImportEntities(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, options *SapDiscoverySitesClientBeginImportEntitiesOptions) (*runtime.Poller[SapDiscoverySitesClientImportEntitiesResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.importEntities(ctx, resourceGroupName, sapDiscoverySiteName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[SapDiscoverySitesClientImportEntitiesResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[SapDiscoverySitesClientImportEntitiesResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// ImportEntities - Import your SAP systems' inventory using the Discovery template [https://go.microsoft.com/fwlink/?linkid=2249111]
// into your SAP Migration discovery site resource and it's child resources, the SAP
// instances and Server instances.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01-preview
func (client *SapDiscoverySitesClient) importEntities(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, options *SapDiscoverySitesClientBeginImportEntitiesOptions) (*http.Response, error) {
	var err error
	const operationName = "SapDiscoverySitesClient.BeginImportEntities"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.importEntitiesCreateRequest(ctx, resourceGroupName, sapDiscoverySiteName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// importEntitiesCreateRequest creates the ImportEntities request.
func (client *SapDiscoverySitesClient) importEntitiesCreateRequest(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, options *SapDiscoverySitesClientBeginImportEntitiesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}/importEntities"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if sapDiscoverySiteName == "" {
		return nil, errors.New("parameter sapDiscoverySiteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sapDiscoverySiteName}", url.PathEscape(sapDiscoverySiteName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// NewListByResourceGroupPager - Gets all SAP Migration discovery site resources in a Resource Group.
//
// Generated from API version 2023-10-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - SapDiscoverySitesClientListByResourceGroupOptions contains the optional parameters for the SapDiscoverySitesClient.NewListByResourceGroupPager
//     method.
func (client *SapDiscoverySitesClient) NewListByResourceGroupPager(resourceGroupName string, options *SapDiscoverySitesClientListByResourceGroupOptions) *runtime.Pager[SapDiscoverySitesClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[SapDiscoverySitesClientListByResourceGroupResponse]{
		More: func(page SapDiscoverySitesClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SapDiscoverySitesClientListByResourceGroupResponse) (SapDiscoverySitesClientListByResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SapDiscoverySitesClient.NewListByResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return SapDiscoverySitesClientListByResourceGroupResponse{}, err
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *SapDiscoverySitesClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *SapDiscoverySitesClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *SapDiscoverySitesClient) listByResourceGroupHandleResponse(resp *http.Response) (SapDiscoverySitesClientListByResourceGroupResponse, error) {
	result := SapDiscoverySitesClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SAPDiscoverySiteListResult); err != nil {
		return SapDiscoverySitesClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - Gets all SAP Migration discovery site resources in a Subscription.
//
// Generated from API version 2023-10-01-preview
//   - options - SapDiscoverySitesClientListBySubscriptionOptions contains the optional parameters for the SapDiscoverySitesClient.NewListBySubscriptionPager
//     method.
func (client *SapDiscoverySitesClient) NewListBySubscriptionPager(options *SapDiscoverySitesClientListBySubscriptionOptions) *runtime.Pager[SapDiscoverySitesClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[SapDiscoverySitesClientListBySubscriptionResponse]{
		More: func(page SapDiscoverySitesClientListBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SapDiscoverySitesClientListBySubscriptionResponse) (SapDiscoverySitesClientListBySubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SapDiscoverySitesClient.NewListBySubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySubscriptionCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return SapDiscoverySitesClientListBySubscriptionResponse{}, err
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *SapDiscoverySitesClient) listBySubscriptionCreateRequest(ctx context.Context, options *SapDiscoverySitesClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Workloads/sapDiscoverySites"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *SapDiscoverySitesClient) listBySubscriptionHandleResponse(resp *http.Response) (SapDiscoverySitesClientListBySubscriptionResponse, error) {
	result := SapDiscoverySitesClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SAPDiscoverySiteListResult); err != nil {
		return SapDiscoverySitesClientListBySubscriptionResponse{}, err
	}
	return result, nil
}

// Update - Updates a SAP Migration discovery site resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-10-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - sapDiscoverySiteName - The name of the discovery site resource for SAP Migration.
//   - properties - The resource properties to be updated.
//   - options - SapDiscoverySitesClientUpdateOptions contains the optional parameters for the SapDiscoverySitesClient.Update
//     method.
func (client *SapDiscoverySitesClient) Update(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, properties SAPDiscoverySiteTagsUpdate, options *SapDiscoverySitesClientUpdateOptions) (SapDiscoverySitesClientUpdateResponse, error) {
	var err error
	const operationName = "SapDiscoverySitesClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, sapDiscoverySiteName, properties, options)
	if err != nil {
		return SapDiscoverySitesClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SapDiscoverySitesClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SapDiscoverySitesClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *SapDiscoverySitesClient) updateCreateRequest(ctx context.Context, resourceGroupName string, sapDiscoverySiteName string, properties SAPDiscoverySiteTagsUpdate, options *SapDiscoverySitesClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Workloads/sapDiscoverySites/{sapDiscoverySiteName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if sapDiscoverySiteName == "" {
		return nil, errors.New("parameter sapDiscoverySiteName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sapDiscoverySiteName}", url.PathEscape(sapDiscoverySiteName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-10-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, properties); err != nil {
		return nil, err
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *SapDiscoverySitesClient) updateHandleResponse(resp *http.Response) (SapDiscoverySitesClientUpdateResponse, error) {
	result := SapDiscoverySitesClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SAPDiscoverySite); err != nil {
		return SapDiscoverySitesClientUpdateResponse{}, err
	}
	return result, nil
}
