//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armlogic_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/logic/armlogic"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccountPartners_List.json
func ExampleIntegrationAccountPartnersClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewIntegrationAccountPartnersClient().NewListPager("testResourceGroup", "testIntegrationAccount", &armlogic.IntegrationAccountPartnersClientListOptions{Top: nil,
		Filter: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.IntegrationAccountPartnerListResult = armlogic.IntegrationAccountPartnerListResult{
		// 	Value: []*armlogic.IntegrationAccountPartner{
		// 		{
		// 			Name: to.Ptr("IntegrationAccountPartner947"),
		// 			Type: to.Ptr("Microsoft.Logic/integrationAccounts/partners"),
		// 			ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testResourceGroup/providers/Microsoft.Logic/integrationAccounts/IntegrationAccount2431/partners/testIntegrationAccount"),
		// 			Properties: &armlogic.IntegrationAccountPartnerProperties{
		// 				ChangedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-06T19:42:59.198Z"); return t}()),
		// 				Content: &armlogic.PartnerContent{
		// 					B2B: &armlogic.B2BPartnerContent{
		// 						BusinessIdentities: []*armlogic.BusinessIdentity{
		// 							{
		// 								Qualifier: to.Ptr("AA"),
		// 								Value: to.Ptr("ZZ"),
		// 						}},
		// 					},
		// 				},
		// 				CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-06T19:42:59.197Z"); return t}()),
		// 				Metadata: map[string]any{
		// 				},
		// 				PartnerType: to.Ptr(armlogic.PartnerTypeB2B),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccountPartners_Get.json
func ExampleIntegrationAccountPartnersClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIntegrationAccountPartnersClient().Get(ctx, "testResourceGroup", "testIntegrationAccount", "testPartner", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.IntegrationAccountPartner = armlogic.IntegrationAccountPartner{
	// 	Name: to.Ptr("testIntegrationAccount"),
	// 	Type: to.Ptr("Microsoft.Logic/integrationAccounts/partners"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/testResourceGroup/providers/Microsoft.Logic/integrationAccounts/testIntegrationAccount/partners/testPartner"),
	// 	Properties: &armlogic.IntegrationAccountPartnerProperties{
	// 		ChangedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-06T20:01:24.052Z"); return t}()),
	// 		Content: &armlogic.PartnerContent{
	// 			B2B: &armlogic.B2BPartnerContent{
	// 				BusinessIdentities: []*armlogic.BusinessIdentity{
	// 					{
	// 						Qualifier: to.Ptr("AA"),
	// 						Value: to.Ptr("ZZ"),
	// 				}},
	// 			},
	// 		},
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-06T20:01:24.051Z"); return t}()),
	// 		Metadata: map[string]any{
	// 		},
	// 		PartnerType: to.Ptr(armlogic.PartnerTypeB2B),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccountPartners_CreateOrUpdate.json
func ExampleIntegrationAccountPartnersClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIntegrationAccountPartnersClient().CreateOrUpdate(ctx, "testResourceGroup", "testIntegrationAccount", "testPartner", armlogic.IntegrationAccountPartner{
		Location: to.Ptr("westus"),
		Tags:     map[string]*string{},
		Properties: &armlogic.IntegrationAccountPartnerProperties{
			Content: &armlogic.PartnerContent{
				B2B: &armlogic.B2BPartnerContent{
					BusinessIdentities: []*armlogic.BusinessIdentity{
						{
							Qualifier: to.Ptr("AA"),
							Value:     to.Ptr("ZZ"),
						}},
				},
			},
			Metadata:    map[string]any{},
			PartnerType: to.Ptr(armlogic.PartnerTypeB2B),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.IntegrationAccountPartner = armlogic.IntegrationAccountPartner{
	// 	Name: to.Ptr("testPartner"),
	// 	Type: to.Ptr("Microsoft.Logic/integrationAccounts/partners"),
	// 	ID: to.Ptr("/subscriptions/34adfa4f-cedf-4dc0-ba29-b6d1a69ab345/resourceGroups/flowrg/providers/Microsoft.Logic/integrationAccounts/testIntegrationAccount/partners/testPartner"),
	// 	Properties: &armlogic.IntegrationAccountPartnerProperties{
	// 		ChangedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-06T20:06:23.590Z"); return t}()),
	// 		Content: &armlogic.PartnerContent{
	// 			B2B: &armlogic.B2BPartnerContent{
	// 				BusinessIdentities: []*armlogic.BusinessIdentity{
	// 					{
	// 						Qualifier: to.Ptr("AA"),
	// 						Value: to.Ptr("ZZ"),
	// 				}},
	// 			},
	// 		},
	// 		CreatedTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-03-06T20:06:23.589Z"); return t}()),
	// 		Metadata: map[string]any{
	// 		},
	// 		PartnerType: to.Ptr(armlogic.PartnerTypeB2B),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccountPartners_Delete.json
func ExampleIntegrationAccountPartnersClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewIntegrationAccountPartnersClient().Delete(ctx, "testResourceGroup", "testIntegrationAccount", "testPartner", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/d55b8005f05b040b852c15e74a0f3e36494a15e1/specification/logic/resource-manager/Microsoft.Logic/stable/2019-05-01/examples/IntegrationAccountPartners_ListContentCallbackUrl.json
func ExampleIntegrationAccountPartnersClient_ListContentCallbackURL() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armlogic.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewIntegrationAccountPartnersClient().ListContentCallbackURL(ctx, "testResourceGroup", "testIntegrationAccount", "testPartner", armlogic.GetCallbackURLParameters{
		KeyType:  to.Ptr(armlogic.KeyTypePrimary),
		NotAfter: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-04-19T16:00:00.000Z"); return t }()),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.WorkflowTriggerCallbackURL = armlogic.WorkflowTriggerCallbackURL{
	// 	Method: to.Ptr("GET"),
	// 	BasePath: to.Ptr("https://prod-00.westus.logic.azure.com/integrationAccounts/0fdabc3a76514ca48dede71c73d9fe97/partners/testPartner/contents/Value"),
	// 	Queries: &armlogic.WorkflowTriggerListCallbackURLQueries{
	// 		APIVersion: to.Ptr("2015-08-01-preview"),
	// 	},
	// 	Value: to.Ptr("https://prod-00.westus.logic.azure.com:443/integrationAccounts/0fdabc3a76514ca48dede71c73d9fe97/partners/testPartner/contents/Value?api-version=2015-08-01-preview&sp=%2Fpartners%2FtestPartner%2Fread&sv=1.0&sig=VK_mbQPTHTa3ezhsrI8IctckwjlL3GdJmroQH_baYj4"),
	// }
}
