//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armiotfirmwaredefense_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/iotfirmwaredefense/armiotfirmwaredefense"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/PasswordHashes_ListByFirmware_MaximumSet_Gen.json
func ExamplePasswordHashesClient_NewListByFirmwarePager_passwordHashesListByFirmwareMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewPasswordHashesClient().NewListByFirmwarePager("FirmwareAnalysisRG", "default", "109a9886-50bf-85a8-9d75-000000000000", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PasswordHashListResult = armiotfirmwaredefense.PasswordHashListResult{
		// 	Value: []*armiotfirmwaredefense.PasswordHashResource{
		// 		{
		// 			Name: to.Ptr("d6c0397f-e52f-4808-a9df-000000000000"),
		// 			Type: to.Ptr("Microsoft.IoTFirmwareDefense/workspaces/firmwares/passwordHashes"),
		// 			ID: to.Ptr("/subscriptions/07aed47b-60ad-4d6e-a07a-000000000000/resourceGroups/FirmwareAnalysisRG/providers/Microsoft.IoTFirmwareDefense/workspaces/default/firmwares/109a9886-50bf-85a8-9d75-000000000000/passwordHashes/d6c0397f-e52f-4808-a9df-000000000000"),
		// 			Properties: &armiotfirmwaredefense.PasswordHash{
		// 				Algorithm: to.Ptr("MD5"),
		// 				Context: to.Ptr("anonymous:$1$A17c6z5w$5OsdHjBn1p000000000000:2:0:99999:7:0:99999:0"),
		// 				FilePath: to.Ptr("/GzipExtractor/1/decompressed.bin"),
		// 				Hash: to.Ptr("5OsdHjBn1p000000000000"),
		// 				PasswordHashID: to.Ptr("d6c0397f-e52f-4808-a9df-000000000000"),
		// 				Salt: to.Ptr("A17c6z5w"),
		// 				Username: to.Ptr("anonymous"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("7a4f58c4-8613-41be-8a08-000000000000"),
		// 			Type: to.Ptr("Microsoft.IoTFirmwareDefense/workspaces/firmwares/passwordHashes"),
		// 			ID: to.Ptr("/subscriptions/07aed47b-60ad-4d6e-a07a-000000000000/resourceGroups/FirmwareAnalysisRG/providers/Microsoft.IoTFirmwareDefense/workspaces/default/firmwares/109a9886-50bf-85a8-9d75-000000000000/passwordHashes/7a4f58c4-8613-41be-8a08-000000000000"),
		// 			Properties: &armiotfirmwaredefense.PasswordHash{
		// 				Algorithm: to.Ptr("DES"),
		// 				Context: to.Ptr("root:absxc000000000:0:0:root:/:/bin/sh"),
		// 				FilePath: to.Ptr("/GzipExtractor/1/decompressed.bin"),
		// 				Hash: to.Ptr("sxc000000000"),
		// 				PasswordHashID: to.Ptr("7a4f58c4-8613-41be-8a08-000000000000"),
		// 				Salt: to.Ptr("ab"),
		// 				Username: to.Ptr("root"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/cf5ad1932d00c7d15497705ad6b71171d3d68b1e/specification/fist/resource-manager/Microsoft.IoTFirmwareDefense/stable/2024-01-10/examples/PasswordHashes_ListByFirmware_MinimumSet_Gen.json
func ExamplePasswordHashesClient_NewListByFirmwarePager_passwordHashesListByFirmwareMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armiotfirmwaredefense.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewPasswordHashesClient().NewListByFirmwarePager("FirmwareAnalysisRG", "default", "109a9886-50bf-85a8-9d75-000000000000", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.PasswordHashListResult = armiotfirmwaredefense.PasswordHashListResult{
		// }
	}
}
