//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armhealthcareapis.ClientFactory type.
type ServerFactory struct {
	DicomServicesServer                       DicomServicesServer
	FhirDestinationsServer                    FhirDestinationsServer
	FhirServicesServer                        FhirServicesServer
	IotConnectorFhirDestinationServer         IotConnectorFhirDestinationServer
	IotConnectorsServer                       IotConnectorsServer
	OperationResultsServer                    OperationResultsServer
	OperationsServer                          OperationsServer
	PrivateEndpointConnectionsServer          PrivateEndpointConnectionsServer
	PrivateLinkResourcesServer                PrivateLinkResourcesServer
	ServicesServer                            ServicesServer
	WorkspacePrivateEndpointConnectionsServer WorkspacePrivateEndpointConnectionsServer
	WorkspacePrivateLinkResourcesServer       WorkspacePrivateLinkResourcesServer
	WorkspacesServer                          WorkspacesServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armhealthcareapis.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armhealthcareapis.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                         *ServerFactory
	trMu                                        sync.Mutex
	trDicomServicesServer                       *DicomServicesServerTransport
	trFhirDestinationsServer                    *FhirDestinationsServerTransport
	trFhirServicesServer                        *FhirServicesServerTransport
	trIotConnectorFhirDestinationServer         *IotConnectorFhirDestinationServerTransport
	trIotConnectorsServer                       *IotConnectorsServerTransport
	trOperationResultsServer                    *OperationResultsServerTransport
	trOperationsServer                          *OperationsServerTransport
	trPrivateEndpointConnectionsServer          *PrivateEndpointConnectionsServerTransport
	trPrivateLinkResourcesServer                *PrivateLinkResourcesServerTransport
	trServicesServer                            *ServicesServerTransport
	trWorkspacePrivateEndpointConnectionsServer *WorkspacePrivateEndpointConnectionsServerTransport
	trWorkspacePrivateLinkResourcesServer       *WorkspacePrivateLinkResourcesServerTransport
	trWorkspacesServer                          *WorkspacesServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "DicomServicesClient":
		initServer(s, &s.trDicomServicesServer, func() *DicomServicesServerTransport {
			return NewDicomServicesServerTransport(&s.srv.DicomServicesServer)
		})
		resp, err = s.trDicomServicesServer.Do(req)
	case "FhirDestinationsClient":
		initServer(s, &s.trFhirDestinationsServer, func() *FhirDestinationsServerTransport {
			return NewFhirDestinationsServerTransport(&s.srv.FhirDestinationsServer)
		})
		resp, err = s.trFhirDestinationsServer.Do(req)
	case "FhirServicesClient":
		initServer(s, &s.trFhirServicesServer, func() *FhirServicesServerTransport { return NewFhirServicesServerTransport(&s.srv.FhirServicesServer) })
		resp, err = s.trFhirServicesServer.Do(req)
	case "IotConnectorFhirDestinationClient":
		initServer(s, &s.trIotConnectorFhirDestinationServer, func() *IotConnectorFhirDestinationServerTransport {
			return NewIotConnectorFhirDestinationServerTransport(&s.srv.IotConnectorFhirDestinationServer)
		})
		resp, err = s.trIotConnectorFhirDestinationServer.Do(req)
	case "IotConnectorsClient":
		initServer(s, &s.trIotConnectorsServer, func() *IotConnectorsServerTransport {
			return NewIotConnectorsServerTransport(&s.srv.IotConnectorsServer)
		})
		resp, err = s.trIotConnectorsServer.Do(req)
	case "OperationResultsClient":
		initServer(s, &s.trOperationResultsServer, func() *OperationResultsServerTransport {
			return NewOperationResultsServerTransport(&s.srv.OperationResultsServer)
		})
		resp, err = s.trOperationResultsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "PrivateEndpointConnectionsClient":
		initServer(s, &s.trPrivateEndpointConnectionsServer, func() *PrivateEndpointConnectionsServerTransport {
			return NewPrivateEndpointConnectionsServerTransport(&s.srv.PrivateEndpointConnectionsServer)
		})
		resp, err = s.trPrivateEndpointConnectionsServer.Do(req)
	case "PrivateLinkResourcesClient":
		initServer(s, &s.trPrivateLinkResourcesServer, func() *PrivateLinkResourcesServerTransport {
			return NewPrivateLinkResourcesServerTransport(&s.srv.PrivateLinkResourcesServer)
		})
		resp, err = s.trPrivateLinkResourcesServer.Do(req)
	case "ServicesClient":
		initServer(s, &s.trServicesServer, func() *ServicesServerTransport { return NewServicesServerTransport(&s.srv.ServicesServer) })
		resp, err = s.trServicesServer.Do(req)
	case "WorkspacePrivateEndpointConnectionsClient":
		initServer(s, &s.trWorkspacePrivateEndpointConnectionsServer, func() *WorkspacePrivateEndpointConnectionsServerTransport {
			return NewWorkspacePrivateEndpointConnectionsServerTransport(&s.srv.WorkspacePrivateEndpointConnectionsServer)
		})
		resp, err = s.trWorkspacePrivateEndpointConnectionsServer.Do(req)
	case "WorkspacePrivateLinkResourcesClient":
		initServer(s, &s.trWorkspacePrivateLinkResourcesServer, func() *WorkspacePrivateLinkResourcesServerTransport {
			return NewWorkspacePrivateLinkResourcesServerTransport(&s.srv.WorkspacePrivateLinkResourcesServer)
		})
		resp, err = s.trWorkspacePrivateLinkResourcesServer.Do(req)
	case "WorkspacesClient":
		initServer(s, &s.trWorkspacesServer, func() *WorkspacesServerTransport { return NewWorkspacesServerTransport(&s.srv.WorkspacesServer) })
		resp, err = s.trWorkspacesServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
