//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/alertsmanagement/armalertsmanagement"
	"net/http"
	"net/url"
	"regexp"
)

// TenantActivityLogAlertsServer is a fake server for instances of the armalertsmanagement.TenantActivityLogAlertsClient type.
type TenantActivityLogAlertsServer struct {
	// CreateOrUpdate is the fake for method TenantActivityLogAlertsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, managementGroupName string, alertRuleName string, tenantActivityLogAlertRule armalertsmanagement.TenantActivityLogAlertResource, options *armalertsmanagement.TenantActivityLogAlertsClientCreateOrUpdateOptions) (resp azfake.Responder[armalertsmanagement.TenantActivityLogAlertsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method TenantActivityLogAlertsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, managementGroupName string, alertRuleName string, options *armalertsmanagement.TenantActivityLogAlertsClientDeleteOptions) (resp azfake.Responder[armalertsmanagement.TenantActivityLogAlertsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method TenantActivityLogAlertsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, managementGroupName string, alertRuleName string, options *armalertsmanagement.TenantActivityLogAlertsClientGetOptions) (resp azfake.Responder[armalertsmanagement.TenantActivityLogAlertsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByManagementGroupPager is the fake for method TenantActivityLogAlertsClient.NewListByManagementGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByManagementGroupPager func(managementGroupName string, options *armalertsmanagement.TenantActivityLogAlertsClientListByManagementGroupOptions) (resp azfake.PagerResponder[armalertsmanagement.TenantActivityLogAlertsClientListByManagementGroupResponse])

	// NewListByTenantPager is the fake for method TenantActivityLogAlertsClient.NewListByTenantPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByTenantPager func(options *armalertsmanagement.TenantActivityLogAlertsClientListByTenantOptions) (resp azfake.PagerResponder[armalertsmanagement.TenantActivityLogAlertsClientListByTenantResponse])

	// Update is the fake for method TenantActivityLogAlertsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, managementGroupName string, alertRuleName string, tenantActivityLogAlertRulePatch armalertsmanagement.TenantAlertRulePatchObject, options *armalertsmanagement.TenantActivityLogAlertsClientUpdateOptions) (resp azfake.Responder[armalertsmanagement.TenantActivityLogAlertsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewTenantActivityLogAlertsServerTransport creates a new instance of TenantActivityLogAlertsServerTransport with the provided implementation.
// The returned TenantActivityLogAlertsServerTransport instance is connected to an instance of armalertsmanagement.TenantActivityLogAlertsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewTenantActivityLogAlertsServerTransport(srv *TenantActivityLogAlertsServer) *TenantActivityLogAlertsServerTransport {
	return &TenantActivityLogAlertsServerTransport{
		srv:                           srv,
		newListByManagementGroupPager: newTracker[azfake.PagerResponder[armalertsmanagement.TenantActivityLogAlertsClientListByManagementGroupResponse]](),
		newListByTenantPager:          newTracker[azfake.PagerResponder[armalertsmanagement.TenantActivityLogAlertsClientListByTenantResponse]](),
	}
}

// TenantActivityLogAlertsServerTransport connects instances of armalertsmanagement.TenantActivityLogAlertsClient to instances of TenantActivityLogAlertsServer.
// Don't use this type directly, use NewTenantActivityLogAlertsServerTransport instead.
type TenantActivityLogAlertsServerTransport struct {
	srv                           *TenantActivityLogAlertsServer
	newListByManagementGroupPager *tracker[azfake.PagerResponder[armalertsmanagement.TenantActivityLogAlertsClientListByManagementGroupResponse]]
	newListByTenantPager          *tracker[azfake.PagerResponder[armalertsmanagement.TenantActivityLogAlertsClientListByTenantResponse]]
}

// Do implements the policy.Transporter interface for TenantActivityLogAlertsServerTransport.
func (t *TenantActivityLogAlertsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "TenantActivityLogAlertsClient.CreateOrUpdate":
		resp, err = t.dispatchCreateOrUpdate(req)
	case "TenantActivityLogAlertsClient.Delete":
		resp, err = t.dispatchDelete(req)
	case "TenantActivityLogAlertsClient.Get":
		resp, err = t.dispatchGet(req)
	case "TenantActivityLogAlertsClient.NewListByManagementGroupPager":
		resp, err = t.dispatchNewListByManagementGroupPager(req)
	case "TenantActivityLogAlertsClient.NewListByTenantPager":
		resp, err = t.dispatchNewListByTenantPager(req)
	case "TenantActivityLogAlertsClient.Update":
		resp, err = t.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (t *TenantActivityLogAlertsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if t.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<managementGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AlertsManagement/tenantActivityLogAlerts/(?P<alertRuleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armalertsmanagement.TenantActivityLogAlertResource](req)
	if err != nil {
		return nil, err
	}
	managementGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupName")])
	if err != nil {
		return nil, err
	}
	alertRuleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertRuleName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.CreateOrUpdate(req.Context(), managementGroupNameParam, alertRuleNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TenantActivityLogAlertResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TenantActivityLogAlertsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if t.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<managementGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AlertsManagement/tenantActivityLogAlerts/(?P<alertRuleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	managementGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupName")])
	if err != nil {
		return nil, err
	}
	alertRuleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertRuleName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Delete(req.Context(), managementGroupNameParam, alertRuleNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TenantActivityLogAlertsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if t.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<managementGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AlertsManagement/tenantActivityLogAlerts/(?P<alertRuleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	managementGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupName")])
	if err != nil {
		return nil, err
	}
	alertRuleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertRuleName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Get(req.Context(), managementGroupNameParam, alertRuleNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TenantActivityLogAlertResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (t *TenantActivityLogAlertsServerTransport) dispatchNewListByManagementGroupPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListByManagementGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByManagementGroupPager not implemented")}
	}
	newListByManagementGroupPager := t.newListByManagementGroupPager.get(req)
	if newListByManagementGroupPager == nil {
		const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<managementGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AlertsManagement/tenantActivityLogAlerts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		managementGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupName")])
		if err != nil {
			return nil, err
		}
		resp := t.srv.NewListByManagementGroupPager(managementGroupNameParam, nil)
		newListByManagementGroupPager = &resp
		t.newListByManagementGroupPager.add(req, newListByManagementGroupPager)
		server.PagerResponderInjectNextLinks(newListByManagementGroupPager, req, func(page *armalertsmanagement.TenantActivityLogAlertsClientListByManagementGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByManagementGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListByManagementGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByManagementGroupPager) {
		t.newListByManagementGroupPager.remove(req)
	}
	return resp, nil
}

func (t *TenantActivityLogAlertsServerTransport) dispatchNewListByTenantPager(req *http.Request) (*http.Response, error) {
	if t.srv.NewListByTenantPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByTenantPager not implemented")}
	}
	newListByTenantPager := t.newListByTenantPager.get(req)
	if newListByTenantPager == nil {
		resp := t.srv.NewListByTenantPager(nil)
		newListByTenantPager = &resp
		t.newListByTenantPager.add(req, newListByTenantPager)
		server.PagerResponderInjectNextLinks(newListByTenantPager, req, func(page *armalertsmanagement.TenantActivityLogAlertsClientListByTenantResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByTenantPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		t.newListByTenantPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByTenantPager) {
		t.newListByTenantPager.remove(req)
	}
	return resp, nil
}

func (t *TenantActivityLogAlertsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if t.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<managementGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AlertsManagement/tenantActivityLogAlerts/(?P<alertRuleName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armalertsmanagement.TenantAlertRulePatchObject](req)
	if err != nil {
		return nil, err
	}
	managementGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupName")])
	if err != nil {
		return nil, err
	}
	alertRuleNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertRuleName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := t.srv.Update(req.Context(), managementGroupNameParam, alertRuleNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).TenantActivityLogAlertResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
