!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubehistogram_xy2pp
  use cube_types 
  use cubetools_parameters
  use cubetools_structure
  use cubeadm_cubeid_types
  use cubeadm_cubeprod_types
  use cubetopology_cuberegion_types
  use cubehistogram_messaging
  !
  public :: xy2pp
  private
  !
  type :: xy2pp_comm_t
     type(option_t), pointer :: comm
!     type(cuberegion_comm_t) :: region
     type(cubeid_arg_t), pointer :: ppin
     type(cubeid_arg_t), pointer :: fromto
     type(cubeid_arg_t), pointer :: xy
     type(cube_prod_t),  pointer :: ppou
   contains
     procedure, public  :: register => cubehistogram_xy2pp_comm_register
     procedure, private :: parse    => cubehistogram_xy2pp_comm_parse
     procedure, private :: main     => cubehistogram_xy2pp_comm_main
  end type xy2pp_comm_t
  type(xy2pp_comm_t) :: xy2pp  
  !
  type xy2pp_user_t
     type(cubeid_user_t)           :: cubeids
!     type(cuberegion_user_t)      :: region
   contains
     procedure, private :: toprog => cubehistogram_xy2pp_user_toprog
  end type xy2pp_user_t
  !
  type xy2pp_prog_t
!     type(cuberegion_prog_t) :: region
     type(cube_t), pointer :: ppin
     type(cube_t), pointer :: fromto
     type(cube_t), pointer :: xy
     type(cube_t), pointer :: ppou
   contains
     procedure, private :: header => cubehistogram_xy2pp_prog_header
     procedure, private :: data   => cubehistogram_xy2pp_prog_data
     procedure, private :: loop   => cubehistogram_xy2pp_prog_loop
     procedure, private :: act    => cubehistogram_xy2pp_prog_act
  end type xy2pp_prog_t
  !
contains
  !
  subroutine cubehistogram_xy2pp_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(xy2pp_user_t) :: user
    character(len=*), parameter :: rname='XY2PP>COMMAND'
    !
    call cubehistogram_message(histogramseve%trace,rname,'Welcome')
    !
    call xy2pp%parse(line,user,error)
    if (error) return
    call xy2pp%main(user,error)
    if (error) continue
  end subroutine cubehistogram_xy2pp_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubehistogram_xy2pp_comm_register(comm,error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(xy2pp_comm_t), intent(inout) :: comm
    logical,                 intent(inout) :: error
    !
    type(cubeid_arg_t) :: incube
    type(cube_prod_t) :: oucube
    character(len=*), parameter :: rname='XY2PP>COMM>REGISTER'
    !
    call cubehistogram_message(histogramseve%trace,rname,'Welcome')
    !
    ! Syntax
    call cubetools_register_command(&
         'XY2PP','[ppinid fromtoid xyid]',&
         'Create a PP image from an XY histogram stacked values',&
         strg_id,&
         cubehistogram_xy2pp_command,&
         comm%comm,&
         error)
    if (error) return
    call incube%register(&
         'PPIN',&
         'Input Position-Position image',&
         strg_id,&
         code_arg_optional,&
         [flag_any],&
         code_read,&
         code_access_imaset,&
         comm%ppin,&
         error)
    if (error) return
    call incube%register(&
         'FROMTO',&
         'From PP to XY',&
         'Index image explaining how to go from a PP image to a bin of XY histogram stacked values',&
         code_arg_optional,&
         [flag_pointer],&
         code_read,&
         code_access_imaset,&
         comm%fromto,&
         error)
    if (error) return
    call incube%register(&
         'XY',&
         'Cube of 2D histogram stacked values',&
         strg_id,&
         code_arg_optional,&
         [flag_any],&
         code_read,&
         code_access_imaset,&
         comm%xy,&
         error)
    if (error) return
!    call comm%region%register(error)
!    if (error) return
    !
    ! Products
    call oucube%register(&
         'PPOU',&
         'Output Position-Position image',&
         strg_id,&
         [flag_cube],&
         comm%ppou,&
         error)
    if (error)  return
  end subroutine cubehistogram_xy2pp_comm_register
  !
  subroutine cubehistogram_xy2pp_comm_parse(comm,line,user,error)
    !----------------------------------------------------------------------
    ! XY2PP ppinid fromtoid xyid 
    !----------------------------------------------------------------------
    class(xy2pp_comm_t), intent(in)    :: comm
    character(len=*),    intent(in)    :: line
    type(xy2pp_user_t),  intent(out)   :: user
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='XY2PP>COMM>PARSE'
    !
    call cubehistogram_message(histogramseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,comm%comm,user%cubeids,error)
    if (error) return
!!$    call comm%region%parse(line,user%region,error)
!!$    if (error) return
  end subroutine cubehistogram_xy2pp_comm_parse
  !
  subroutine cubehistogram_xy2pp_comm_main(comm,user,error)
    use cubeadm_timing
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(xy2pp_comm_t), intent(in)    :: comm
    type(xy2pp_user_t),  intent(inout) :: user
    logical,             intent(inout) :: error
    !
    type(xy2pp_prog_t) :: prog
    character(len=*), parameter :: rname='XY2PP>MAIN'
    !
    call cubehistogram_message(histogramseve%trace,rname,'Welcome')
    !
    call user%toprog(comm,prog,error)
    if (error) return
    call prog%header(comm,error)
    if (error) return
    call cubeadm_timing_prepro2process()
    call prog%data(error)
    if (error) return
    call cubeadm_timing_process2postpro()
  end subroutine cubehistogram_xy2pp_comm_main
  !
  !----------------------------------------------------------------------
  !
  subroutine cubehistogram_xy2pp_user_toprog(user,comm,prog,error)
    use cubeadm_get
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(xy2pp_user_t), intent(in)    :: user
    type(xy2pp_comm_t),  intent(in)    :: comm
    type(xy2pp_prog_t),  intent(out)   :: prog
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='XY2PP>USER>TOPROG'
    !
    call cubehistogram_message(histogramseve%trace,rname,'Welcome')
    !
    call cubeadm_get_header(comm%ppin,user%cubeids,prog%ppin,error)
    if (error) return
    call cubeadm_get_header(comm%fromto,user%cubeids,prog%fromto,error)
    if (error) return
    call cubeadm_get_header(comm%xy,user%cubeids,prog%xy,error)
    if (error) return
!!$    call user%region%toprog(prog%ppin,prog%region,error)
!!$    if (error) return
    !
    ! User feedback about the interpretation of his command line
!!$    call prog%region%list(error)
!!$    if (error) return    
  end subroutine cubehistogram_xy2pp_user_toprog
  !
  !----------------------------------------------------------------------
  !
  subroutine cubehistogram_xy2pp_prog_header(prog,comm,error)
    use cubeadm_clone
    use cubetools_header_methods
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(xy2pp_prog_t), intent(inout) :: prog
    type(xy2pp_comm_t),  intent(in)    :: comm
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='XY2PP>PROG>HEADER'
    !
    call cubehistogram_message(histogramseve%trace,rname,'Welcome')
    !
    call cubeadm_clone_header(comm%ppou,prog%ppin,prog%ppou,error)
    if (error) return
!!$    call prog%region%header(prog%ppin,error)
!!$    if (error) return
  end subroutine cubehistogram_xy2pp_prog_header
  !
  subroutine cubehistogram_xy2pp_prog_data(prog,error)
    use cubeadm_opened
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(xy2pp_prog_t), intent(inout) :: prog
    logical,             intent(inout) :: error
    !
    type(cubeadm_iterator_t) :: iter
    character(len=*), parameter :: rname='XY2PP>PROG>DATA'
    !
    call cubehistogram_message(histogramseve%trace,rname,'Welcome')
    !
    call cubeadm_datainit_all(iter,error)
    if (error) return
    !$OMP PARALLEL DEFAULT(none) SHARED(prog,error) FIRSTPRIVATE(iter)
    !$OMP SINGLE
    do while (cubeadm_dataiterate_all(iter,error))
       if (error) exit
       !$OMP TASK SHARED(prog,error) FIRSTPRIVATE(iter)
       if (.not.error) &
         call prog%loop(iter,error)
       !$OMP END TASK
    enddo
    !$OMP END SINGLE
    !$OMP END PARALLEL
  end subroutine cubehistogram_xy2pp_prog_data
  !
  subroutine cubehistogram_xy2pp_prog_loop(prog,iter,error)
    use cubeadm_taskloop
    use cubetools_array_types
    use cubeadm_image_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(xy2pp_prog_t),      intent(inout) :: prog
    type(cubeadm_iterator_t), intent(inout) :: iter
    logical,                  intent(inout) :: error
    !
    type(image_t) :: ppin,ppou,fromto
    type(image_t) :: xy
    character(len=*), parameter :: rname='XY2PP>PROG>LOOP'
    !
    call ppin%associate('ppin',prog%ppin,iter,error)
    if (error) return
    call fromto%associate('fromto',prog%fromto,iter,error)
    if (error) return
    call xy%associate('xy',prog%xy,iter,error)
    if (error) return
    call ppou%allocate('ppou',prog%ppou,iter,error)
    if (error) return
    !
    do while (iter%iterate_entry(error))
      call prog%act(iter%ie,ppou,ppin,fromto,xy,error)
      if (error) return
    enddo ! ie
  end subroutine cubehistogram_xy2pp_prog_loop
  !
  subroutine cubehistogram_xy2pp_prog_act(prog,ie,ppou,ppin,fromto,xy,error)
    use cubetools_nan
    use cubetools_array_types
    use cubeadm_image_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(xy2pp_prog_t),  intent(inout) :: prog
    integer(kind=entr_k), intent(in)    :: ie
    type(image_t),        intent(inout) :: ppou
    type(image_t),        intent(inout) :: ppin
    type(image_t),        intent(inout) :: fromto
    type(image_t),        intent(inout) :: xy
    logical,              intent(inout) :: error
    !
    integer(kind=pixe_k) :: ix,iy
    integer(kind=pixe_k) :: jx,jy
    integer(kind=indx_k) :: index
    character(len=*), parameter :: rname='XY2PP>PROG>ACT'
    !
    call ppin%get(ie,error)
    if (error) return
    call fromto%get(ie,error)
    if (error) return
    call xy%get(ie,error)
    if (error) return
    ! Now replace ppou(ix,iy) = xy(jx,jy) for (jx,jy) = fromto%val(ix,iy)
    do iy=1,fromto%ny
       do ix=1,fromto%nx
          index = fromto%val(ix,iy)
          if ((ieee_is_nan(fromto%val(ix,iy))).or.(index.eq.0)) then
             ppou%val(ix,iy) = ppin%val(ix,iy)
          else
             jx = 1+mod(index-1,xy%nx)
             jy = 1+(index-jx)/xy%nx
             ! The user can provide an inconsistent set of fromto and xy images!
             if ((1.le.jx).and.(jx.le.xy%nx).and.(1.le.jy).and.(jy.le.xy%ny)) then
                ppou%val(ix,iy) = xy%val(jx,jy)
             else
                ! ***JP: Some shorter feedback to user? For instance counting
                ! ***JP: the number of points outside and stating it at the end?
                print *,jx,jy,xy%nx,xy%ny
             endif
          endif
       enddo ! ix
    enddo ! iy
    call ppou%put(ie,error)
    if (error) return
  end subroutine cubehistogram_xy2pp_prog_act
end module cubehistogram_xy2pp
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
