!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubesyntax_keyval_real_types
  use cubetools_parameters
  use cubetools_structure
  use cubesyntax_value_real_types
  use cubesyntax_messaging
  !
  public :: keyval_real_comm_t,keyval_real_user_t,keyval_real_prog_t
  private
  !
  type keyval_real_comm_t
     type(option_t), pointer :: key
     type(value_real_comm_t) :: value
   contains
     procedure, public :: register => cubesyntax_keyval_real_comm_register
     procedure, public :: parse    => cubesyntax_keyval_real_comm_parse
  end type keyval_real_comm_t
  !
  type keyval_real_user_t
     logical               :: do = .false.
     character(len=argu_l) :: val = strg_star
   contains
     procedure, public :: toprog => cubesyntax_keyval_real_user_toprog
     procedure, public :: list   => cubesyntax_keyval_real_user_list
  end type keyval_real_user_t
  !
  type keyval_real_prog_t
   contains
     procedure, public :: list   => cubesyntax_keyval_real_prog_list
  end type keyval_real_prog_t
  !
contains
  !
  subroutine cubesyntax_keyval_real_comm_register(comm,&
       keyname,keyabstract,valdefault,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(keyval_real_comm_t), intent(inout) :: comm
    character(len=*),          intent(in)    :: keyname
    character(len=*),          intent(in)    :: keyabstract
    real(kind=real_k),         intent(in)    :: valdefault
    logical,                   intent(inout) :: error
    !
    character(len=*), parameter :: rname='KEYVAL>REAL>COMM>REGISTER'
    !
    call cubesyntax_message(syntaxseve%trace,rname,'Welcome')
    !
    call cubetools_register_option(&
         keyname,&
         'value',&
         keyabstract,&
         strg_id,&
         comm%key,&
         error)
    if (error) return
    call comm%value%register(&
         keyname,&
         valdefault,&
         error)
    if (error) return
  end subroutine cubesyntax_keyval_real_comm_register
  !
  subroutine cubesyntax_keyval_real_comm_parse(comm,line,user,error)
    use cubetools_structure
    !----------------------------------------------------------------------
    ! /KEY value
    !----------------------------------------------------------------------
    class(keyval_real_comm_t), intent(in)    :: comm
    character(len=*),          intent(in)    :: line
    type(keyval_real_user_t),  intent(out)   :: user ! => Initialized!
    logical,                   intent(inout) :: error
    !
    integer(kind=argu_k), parameter :: ival=1
    character(len=*), parameter :: rname='KEYVAL>REAL>COMM>PARSE'
    !
    call cubesyntax_message(syntaxseve%trace,rname,'Welcome')
    !
    call comm%key%present(line,user%do,error)
    if (error) return
    if (user%do) then
       call cubetools_getarg(line,comm%key,ival,user%val,mandatory,error)
       if (error) return
    endif
  end subroutine cubesyntax_keyval_real_comm_parse
  !
  !------------------------------------------------------------------------
  !
  subroutine cubesyntax_keyval_real_user_toprog(user,comm,prog,error)
    use cubetools_unit
    use cubetools_user2prog
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(keyval_real_user_t), intent(in)    :: user
    type(keyval_real_comm_t),  intent(in)    :: comm
    real(kind=real_k),         intent(inout) :: prog
    logical,                   intent(inout) :: error
    !
    type(unit_user_t) :: nounit
    character(len=*), parameter :: rname='KEYVAL>REAL>USER>TOPROG'
    !
    call cubesyntax_message(syntaxseve%trace,rname,'Welcome')
    !
    ! *** JP This syntax seems very strange to me because we transfer a
    ! *** JP constant object named nounit!
    call nounit%get_from_code(code_unit_unk,error)
    if (error) return
    call cubetools_user2prog_resolve_star(user%val,nounit,comm%value%default,prog,error)
    if (error) return
  end subroutine cubesyntax_keyval_real_user_toprog
  !
  subroutine cubesyntax_keyval_real_user_list(user,error)
    !----------------------------------------------------------------------
    ! Mostly for debugging purpose
    !----------------------------------------------------------------------
    class(keyval_real_user_t), intent(in)    :: user 
    logical,                       intent(inout) :: error
    !
!    character(len=mess_l) :: mess
    character(len=*), parameter :: rname='KEYVAL>REAL>USER>LIST'
    !
    call cubesyntax_message(syntaxseve%trace,rname,'Welcome')
    !
  end subroutine cubesyntax_keyval_real_user_list
  !
  !------------------------------------------------------------------------
  !
  subroutine cubesyntax_keyval_real_prog_list(prog,comm,value,error)
    use cubesyntax_keyval_list_tool
    !-------------------------------------------------------------------
    ! List the information in a user friendly way
    !-------------------------------------------------------------------
    class(keyval_real_prog_t), intent(in)    :: prog
    type(keyval_real_comm_t),  intent(in)    :: comm
    real(kind=real_k),         intent(in)    :: value
    logical,                   intent(inout) :: error
    !
    character(len=*), parameter :: rname='KEYVAL>REAL>PROG>LIST'
    !
    call cubesyntax_message(syntaxseve%trace,rname,'Welcome')
    !
    call keyval%list(comm%key%name,value,error)
    if (error) return
  end subroutine cubesyntax_keyval_real_prog_list
end module cubesyntax_keyval_real_types
! 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
