subroutine ctrlc_check (error)
  use gbl_message
  use sic_dependencies_interfaces
  use sic_interfaces, except_this=>ctrlc_check
  use sic_structures
  !---------------------------------------------------------------------
  ! @ private
  !  Pause if ^C has been pressed and reset CONTROLC flag to false.
  !---------------------------------------------------------------------
  logical, intent(inout) :: error  !
  !
  if (.not.sic_ctrlc()) return
  if (mlire(nlire).eq.0) then  ! At the terminal prompt
    call sic_message(seve%i,'SIC','^C')
  elseif (nlire.lt.maxlev) then  ! During a command execution
    call sic_message(seve%i,'PAUSE','Generated by pressing ^C')
    if (error) then
      call sic_message(seve%w,'PAUSE','Error returned by aborted command '//  &
      'ignored')
      error = .false.
    endif
    call break
  else  ! During a command execution but too deep
    call sic_message(seve%w,'SIC','<^C> Ignored, level too deep')
  endif
end subroutine ctrlc_check
