/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { CommandKind } from './types.js';
import { clearCachedCredentialFile } from '@google/gemini-cli-core';
import { SettingScope } from '../../config/settings.js';
const authLoginCommand = {
    name: 'login',
    description: 'Login or change the auth method',
    kind: CommandKind.BUILT_IN,
    autoExecute: true,
    action: (_context, _args) => ({
        type: 'dialog',
        dialog: 'auth',
    }),
};
const authLogoutCommand = {
    name: 'logout',
    description: 'Log out and clear all cached credentials',
    kind: CommandKind.BUILT_IN,
    action: async (context, _args) => {
        await clearCachedCredentialFile();
        // Clear the selected auth type so user sees the auth selection menu
        context.services.settings.setValue(SettingScope.User, 'security.auth.selectedType', undefined);
        // Strip thoughts from history instead of clearing completely
        context.services.config?.getGeminiClient()?.stripThoughtsFromHistory();
        // Return logout action to signal explicit state change
        return {
            type: 'logout',
        };
    },
};
export const authCommand = {
    name: 'auth',
    description: 'Manage authentication',
    kind: CommandKind.BUILT_IN,
    subCommands: [authLoginCommand, authLogoutCommand],
    action: (context, args) => 
    // Default to login if no subcommand is provided
    authLoginCommand.action(context, args),
};
//# sourceMappingURL=authCommand.js.map