/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.BatchTransactionId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Partition;
import com.google.cloud.spanner.SpannerExceptionFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.Base64;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class PartitionId
implements Serializable {
    private static final long serialVersionUID = 239487275L;
    private final BatchTransactionId transactionId;
    private final Partition partition;

    public static PartitionId decodeFromString(String id) {
        PartitionId partitionId;
        final AtomicBoolean classNameVerified = new AtomicBoolean(false);
        ObjectInputStream objectInputStream = new ObjectInputStream(new GZIPInputStream(new ByteArrayInputStream(Base64.getUrlDecoder().decode(id)))){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                if (!classNameVerified.get()) {
                    if (desc.getName().equals(PartitionId.class.getName())) {
                        classNameVerified.set(true);
                    } else {
                        throw new InvalidClassException("The id does not contain a valid PartitionId instance", desc.getName());
                    }
                }
                return super.resolveClass(desc);
            }
        };
        try {
            partitionId = (PartitionId)objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    objectInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InvalidClassException invalidClassException) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, invalidClassException.getMessage(), invalidClassException);
            }
            catch (Exception exception) {
                throw SpannerExceptionFactory.newSpannerException(exception);
            }
        }
        objectInputStream.close();
        return partitionId;
    }

    public static String encodeToString(BatchTransactionId transactionId, Partition partition) {
        PartitionId id = new PartitionId(transactionId, partition);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(new GZIPOutputStream(byteArrayOutputStream));){
            objectOutputStream.writeObject(id);
        }
        catch (Exception exception) {
            throw SpannerExceptionFactory.newSpannerException(exception);
        }
        return Base64.getUrlEncoder().encodeToString(byteArrayOutputStream.toByteArray());
    }

    private PartitionId(BatchTransactionId transactionId, Partition partition) {
        this.transactionId = transactionId;
        this.partition = partition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartitionId)) {
            return false;
        }
        PartitionId other = (PartitionId)o;
        return Objects.equals(this.transactionId, other.transactionId) && Objects.equals(this.partition, other.partition);
    }

    public int hashCode() {
        return Objects.hash(this.transactionId, this.partition);
    }

    public BatchTransactionId getTransactionId() {
        return this.transactionId;
    }

    public Partition getPartition() {
        return this.partition;
    }
}

