/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.CredentialsService;
import com.google.cloud.spanner.connection.DdlInTransactionMode;
import com.google.cloud.spanner.connection.LocalConnectionChecker;
import com.google.cloud.spanner.connection.SpannerPool;
import com.google.cloud.spanner.connection.StatementExecutionInterceptor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import com.google.common.collect.Sets;
import com.google.spanner.v1.ExecuteSqlRequest;
import io.opentelemetry.api.OpenTelemetry;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@InternalApi
public class ConnectionOptions {
    private static final LocalConnectionChecker LOCAL_CONNECTION_CHECKER = new LocalConnectionChecker();
    private static final boolean DEFAULT_USE_PLAIN_TEXT = false;
    static final boolean DEFAULT_AUTOCOMMIT = true;
    static final boolean DEFAULT_READONLY = false;
    static final boolean DEFAULT_RETRY_ABORTS_INTERNALLY = true;
    static final boolean DEFAULT_USE_VIRTUAL_THREADS = false;
    static final boolean DEFAULT_USE_VIRTUAL_GRPC_TRANSPORT_THREADS = false;
    private static final String DEFAULT_CREDENTIALS = null;
    private static final String DEFAULT_OAUTH_TOKEN = null;
    private static final String DEFAULT_MIN_SESSIONS = null;
    private static final String DEFAULT_MAX_SESSIONS = null;
    private static final String DEFAULT_NUM_CHANNELS = null;
    static final String DEFAULT_ENDPOINT = null;
    private static final String DEFAULT_CHANNEL_PROVIDER = null;
    private static final String DEFAULT_DATABASE_ROLE = null;
    private static final String DEFAULT_USER_AGENT = null;
    private static final String DEFAULT_OPTIMIZER_VERSION = "";
    private static final String DEFAULT_OPTIMIZER_STATISTICS_PACKAGE = "";
    private static final Options.RpcPriority DEFAULT_RPC_PRIORITY = null;
    private static final DdlInTransactionMode DEFAULT_DDL_IN_TRANSACTION_MODE = DdlInTransactionMode.ALLOW_IN_EMPTY_TRANSACTION;
    private static final boolean DEFAULT_RETURN_COMMIT_STATS = false;
    private static final boolean DEFAULT_LENIENT = false;
    private static final boolean DEFAULT_ROUTE_TO_LEADER = true;
    private static final boolean DEFAULT_DELAY_TRANSACTION_START_UNTIL_FIRST_WRITE = false;
    private static final boolean DEFAULT_KEEP_TRANSACTION_ALIVE = false;
    private static final boolean DEFAULT_TRACK_SESSION_LEAKS = true;
    private static final boolean DEFAULT_TRACK_CONNECTION_LEAKS = true;
    private static final boolean DEFAULT_DATA_BOOST_ENABLED = false;
    private static final boolean DEFAULT_AUTO_PARTITION_MODE = false;
    private static final int DEFAULT_MAX_PARTITIONS = 0;
    private static final int DEFAULT_MAX_PARTITIONED_PARALLELISM = 1;
    private static final Boolean DEFAULT_ENABLE_EXTENDED_TRACING = null;
    private static final Boolean DEFAULT_ENABLE_API_TRACING = null;
    private static final String PLAIN_TEXT_PROTOCOL = "http:";
    private static final String HOST_PROTOCOL = "https:";
    private static final String DEFAULT_HOST = "https://spanner.googleapis.com";
    private static final String SPANNER_EMULATOR_HOST_ENV_VAR = "SPANNER_EMULATOR_HOST";
    private static final String DEFAULT_EMULATOR_HOST = "http://localhost:9010";
    private static final String USE_PLAIN_TEXT_PROPERTY_NAME = "usePlainText";
    public static final String AUTOCOMMIT_PROPERTY_NAME = "autocommit";
    public static final String READONLY_PROPERTY_NAME = "readonly";
    public static final String ROUTE_TO_LEADER_PROPERTY_NAME = "routeToLeader";
    public static final String RETRY_ABORTS_INTERNALLY_PROPERTY_NAME = "retryAbortsInternally";
    public static final String USE_VIRTUAL_THREADS_PROPERTY_NAME = "useVirtualThreads";
    public static final String USE_VIRTUAL_GRPC_TRANSPORT_THREADS_PROPERTY_NAME = "useVirtualGrpcTransportThreads";
    public static final String CREDENTIALS_PROPERTY_NAME = "credentials";
    public static final String ENCODED_CREDENTIALS_PROPERTY_NAME = "encodedCredentials";
    public static final String ENABLE_ENCODED_CREDENTIALS_SYSTEM_PROPERTY = "ENABLE_ENCODED_CREDENTIALS";
    public static final String CREDENTIALS_PROVIDER_PROPERTY_NAME = "credentialsProvider";
    public static final String ENABLE_CREDENTIALS_PROVIDER_SYSTEM_PROPERTY = "ENABLE_CREDENTIALS_PROVIDER";
    public static final String OAUTH_TOKEN_PROPERTY_NAME = "oauthToken";
    public static final String MIN_SESSIONS_PROPERTY_NAME = "minSessions";
    public static final String MAX_SESSIONS_PROPERTY_NAME = "maxSessions";
    public static final String NUM_CHANNELS_PROPERTY_NAME = "numChannels";
    public static final String ENDPOINT_PROPERTY_NAME = "endpoint";
    public static final String CHANNEL_PROVIDER_PROPERTY_NAME = "channelProvider";
    public static final String ENABLE_CHANNEL_PROVIDER_SYSTEM_PROPERTY = "ENABLE_CHANNEL_PROVIDER";
    private static final String USER_AGENT_PROPERTY_NAME = "userAgent";
    private static final String OPTIMIZER_VERSION_PROPERTY_NAME = "optimizerVersion";
    private static final String OPTIMIZER_STATISTICS_PACKAGE_PROPERTY_NAME = "optimizerStatisticsPackage";
    public static final String LENIENT_PROPERTY_NAME = "lenient";
    public static final String RPC_PRIORITY_NAME = "rpcPriority";
    public static final String DDL_IN_TRANSACTION_MODE_PROPERTY_NAME = "ddlInTransactionMode";
    private static final String DIALECT_PROPERTY_NAME = "dialect";
    public static final String DATABASE_ROLE_PROPERTY_NAME = "databaseRole";
    public static final String DELAY_TRANSACTION_START_UNTIL_FIRST_WRITE_NAME = "delayTransactionStartUntilFirstWrite";
    public static final String KEEP_TRANSACTION_ALIVE_PROPERTY_NAME = "keepTransactionAlive";
    public static final String TRACK_SESSION_LEAKS_PROPERTY_NAME = "trackSessionLeaks";
    public static final String TRACK_CONNECTION_LEAKS_PROPERTY_NAME = "trackConnectionLeaks";
    public static final String DATA_BOOST_ENABLED_PROPERTY_NAME = "dataBoostEnabled";
    public static final String AUTO_PARTITION_MODE_PROPERTY_NAME = "autoPartitionMode";
    public static final String MAX_PARTITIONS_PROPERTY_NAME = "maxPartitions";
    public static final String MAX_PARTITIONED_PARALLELISM_PROPERTY_NAME = "maxPartitionedParallelism";
    public static final String ENABLE_EXTENDED_TRACING_PROPERTY_NAME = "enableExtendedTracing";
    public static final String ENABLE_API_TRACING_PROPERTY_NAME = "enableApiTracing";
    private static final String GUARDED_CONNECTION_PROPERTY_ERROR_MESSAGE = "%s can only be used if the system property %s has been set to true. Start the application with the JVM command line option -D%s=true";
    public static final Set<ConnectionProperty> VALID_PROPERTIES = Collections.unmodifiableSet(new HashSet<ConnectionProperty>(Arrays.asList(ConnectionProperty.access$000("autocommit", "Should the connection start in autocommit (true/false)", true), ConnectionProperty.access$000("readonly", "Should the connection start in read-only mode (true/false)", false), ConnectionProperty.access$000("routeToLeader", "Should read/write transactions and partitioned DML be routed to leader region (true/false)", true), ConnectionProperty.access$000("retryAbortsInternally", "Should the connection automatically retry Aborted errors (true/false)", true), ConnectionProperty.access$000("useVirtualThreads", "Use a virtual thread instead of a platform thread for each connection (true/false). This option only has any effect if the application is running on Java 21 or higher. In all other cases, the option is ignored.", false), ConnectionProperty.access$000("useVirtualGrpcTransportThreads", "Use a virtual thread instead of a platform thread for the gRPC executor (true/false). This option only has any effect if the application is running on Java 21 or higher. In all other cases, the option is ignored.", false), ConnectionProperty.access$100("credentials", "The location of the credentials file to use for this connection. If neither this property or encoded credentials are set, the connection will use the default Google Cloud credentials for the runtime environment."), ConnectionProperty.access$100("encodedCredentials", "Base64-encoded credentials to use for this connection. If neither this property or a credentials location are set, the connection will use the default Google Cloud credentials for the runtime environment."), ConnectionProperty.access$100("credentialsProvider", "The class name of the com.google.api.gax.core.CredentialsProvider implementation that should be used to obtain credentials for connections."), ConnectionProperty.access$100("oauthToken", "A valid pre-existing OAuth token to use for authentication for this connection. Setting this property will take precedence over any value set for a credentials file."), ConnectionProperty.access$100("minSessions", "The minimum number of sessions in the backing session pool. The default is 100."), ConnectionProperty.access$100("maxSessions", "The maximum number of sessions in the backing session pool. The default is 400."), ConnectionProperty.access$100("numChannels", "The number of gRPC channels to use to communicate with Cloud Spanner. The default is 4."), ConnectionProperty.access$100("endpoint", "The endpoint that the JDBC driver should connect to. The default is the default Spanner production endpoint when autoConfigEmulator=false, and the default Spanner emulator endpoint (localhost:9010) when autoConfigEmulator=true. This property takes precedence over any host name at the start of the connection URL."), ConnectionProperty.access$100("channelProvider", "The name of the channel provider class. The name must reference an implementation of ExternalChannelProvider. If this property is not set, the connection will use the default grpc channel provider."), ConnectionProperty.access$000("usePlainText", "Use a plain text communication channel (i.e. non-TLS) for communicating with the server (true/false). Set this value to true for communication with the Cloud Spanner emulator.", false), ConnectionProperty.access$100("userAgent", "The custom user-agent property name to use when communicating with Cloud Spanner. This property is intended for internal library usage, and should not be set by applications."), ConnectionProperty.access$100("optimizerVersion", "Sets the default query optimizer version to use for this connection."), ConnectionProperty.access$100("optimizerStatisticsPackage", ""), ConnectionProperty.access$000("returnCommitStats", "", false), ConnectionProperty.access$100("maxCommitDelay", "The maximum commit delay in milliseconds that should be applied to commit requests from this connection."), ConnectionProperty.access$000("autoConfigEmulator", "Automatically configure the connection to try to connect to the Cloud Spanner emulator (true/false). The instance and database in the connection string will automatically be created if these do not yet exist on the emulator. Add dialect=postgresql to the connection string to make sure that the database that is created uses the PostgreSQL dialect.", false), ConnectionProperty.access$000("useAutoSavepointsForEmulator", "Automatically creates savepoints for each statement in a read/write transaction when using the Emulator. This is no longer needed when using Emulator version 1.5.23 or higher.", false), ConnectionProperty.access$000("lenient", "Silently ignore unknown properties in the connection string/properties (true/false)", false), ConnectionProperty.access$100("rpcPriority", "Sets the priority for all RPC invocations from this connection (HIGH/MEDIUM/LOW). The default is HIGH."), ConnectionProperty.access$100("ddlInTransactionMode", "Sets the behavior of a connection when a DDL statement is executed in a read/write transaction. The default is " + (Object)((Object)DEFAULT_DDL_IN_TRANSACTION_MODE) + "."), ConnectionProperty.access$100("dialect", "Sets the dialect to use for new databases that are created by this connection."), ConnectionProperty.access$100("databaseRole", "Sets the database role to use for this connection. The default is privileges assigned to IAM role"), ConnectionProperty.access$000("delayTransactionStartUntilFirstWrite", "Enabling this option will delay the actual start of a read/write transaction until the first write operation is seen in that transaction. All reads that happen before the first write in a transaction will instead be executed as if the connection was in auto-commit mode. Enabling this option will make read/write transactions lose their SERIALIZABLE isolation level. Read operations that are executed after the first write operation in a read/write transaction will be executed using the read/write transaction. Enabling this mode can reduce locking and improve performance for applications that can handle the lower transaction isolation semantics.", false), ConnectionProperty.access$000("keepTransactionAlive", "Enabling this option will trigger the connection to keep read/write transactions alive by executing a SELECT 1 query once every 10 seconds if no other statements are being executed. This option should be used with caution, as it can keep transactions alive and hold on to locks longer than intended. This option should typically be used for CLI-type application that might wait for user input for a longer period of time.", false), ConnectionProperty.access$000("trackSessionLeaks", "Capture the call stack of the thread that checked out a session of the session pool. This will pre-create a LeakedSessionException already when a session is checked out. This can be disabled, for example if a monitoring system logs the pre-created exception. If disabled, the LeakedSessionException will only be created when an actual session leak is detected. The stack trace of the exception will in that case not contain the call stack of when the session was checked out.", true), ConnectionProperty.access$000("trackConnectionLeaks", "Capture the call stack of the thread that created a connection. This will pre-create a LeakedConnectionException already when a connection is created. This can be disabled, for example if a monitoring system logs the pre-created exception. If disabled, the LeakedConnectionException will only be created when an actual connection leak is detected. The stack trace of the exception will in that case not contain the call stack of when the connection was created.", true), ConnectionProperty.access$000("dataBoostEnabled", "Enable data boost for all partitioned queries that are executed by this connection. This setting is only used for partitioned queries and is ignored by all other statements.", false), ConnectionProperty.access$000("autoPartitionMode", "Execute all queries on this connection as partitioned queries. Executing a query that cannot be partitioned will fail. Executing a query in a read/write transaction will also fail.", false), ConnectionProperty.access$200("maxPartitions", "The max partitions hint value to use for partitioned queries. Use 0 if you do not want to specify a hint.", 0), ConnectionProperty.access$200("maxPartitionedParallelism", "The maximum number of partitions that will be executed in parallel for partitioned queries on this connection. Set this value to 0 to dynamically use the number of processors available in the runtime.", 1), ConnectionProperty.access$000("enableExtendedTracing", "Include the SQL string in the OpenTelemetry traces that are generated by this connection. The SQL string is added as the standard OpenTelemetry attribute 'db.statement'.", DEFAULT_ENABLE_EXTENDED_TRACING), ConnectionProperty.access$000("enableApiTracing", "Add OpenTelemetry traces for each individual RPC call. Enable this to get a detailed view of each RPC that is being executed by your application, or if you want to debug potential latency problems caused by RPCs that are being retried.", DEFAULT_ENABLE_API_TRACING))));
    private static final Set<ConnectionProperty> INTERNAL_PROPERTIES = Collections.unmodifiableSet(new HashSet<ConnectionProperty>(Collections.singletonList(ConnectionProperty.access$100("userAgent", ""))));
    private static final Set<ConnectionProperty> INTERNAL_VALID_PROPERTIES = Sets.union(VALID_PROPERTIES, INTERNAL_PROPERTIES);
    private final String uri;
    private final String warnings;
    private final String credentialsUrl;
    private final String encodedCredentials;
    private final CredentialsProvider credentialsProvider;
    private final String oauthToken;
    private final Credentials fixedCredentials;
    private final boolean usePlainText;
    private final String host;
    private final String projectId;
    private final String instanceId;
    private final String databaseName;
    private final Credentials credentials;
    private final SessionPoolOptions sessionPoolOptions;
    private final Integer numChannels;
    private final String channelProvider;
    private final Integer minSessions;
    private final Integer maxSessions;
    private final String databaseRole;
    private final String userAgent;
    private final ExecuteSqlRequest.QueryOptions queryOptions;
    private final boolean returnCommitStats;
    private final Long maxCommitDelay;
    private final boolean autoConfigEmulator;
    private final boolean useAutoSavepointsForEmulator;
    private final Dialect dialect;
    private final Options.RpcPriority rpcPriority;
    private final DdlInTransactionMode ddlInTransactionMode;
    private final boolean delayTransactionStartUntilFirstWrite;
    private final boolean keepTransactionAlive;
    private final boolean trackSessionLeaks;
    private final boolean trackConnectionLeaks;
    private final boolean dataBoostEnabled;
    private final boolean autoPartitionMode;
    private final int maxPartitions;
    private final int maxPartitionedParallelism;
    private final boolean autocommit;
    private final boolean readOnly;
    private final boolean routeToLeader;
    private final boolean retryAbortsInternally;
    private final boolean useVirtualThreads;
    private final boolean useVirtualGrpcTransportThreads;
    private final OpenTelemetry openTelemetry;
    private final String tracingPrefix;
    private final Boolean enableExtendedTracing;
    private final Boolean enableApiTracing;
    private final List<StatementExecutionInterceptor> statementExecutionInterceptors;
    private final SpannerOptionsConfigurator configurator;

    private static String generateGuardedConnectionPropertyError(String systemPropertyName, String connectionPropertyName) {
        return String.format(GUARDED_CONNECTION_PROPERTY_ERROR_MESSAGE, connectionPropertyName, systemPropertyName, systemPropertyName);
    }

    public static String getDefaultProjectId(Credentials credentials) {
        String projectId = SpannerOptions.getDefaultProjectId();
        if (projectId == null && credentials != null && credentials instanceof ServiceAccountCredentials) {
            projectId = ((ServiceAccountCredentials)credentials).getProjectId();
        }
        return projectId;
    }

    public static void closeSpanner() {
        SpannerPool.INSTANCE.checkAndCloseSpanners();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private ConnectionOptions(Builder builder) {
        Matcher matcher = Builder.SPANNER_URI_PATTERN.matcher(builder.uri);
        Preconditions.checkArgument((boolean)matcher.find(), (Object)String.format("Invalid connection URI specified: %s", builder.uri));
        this.warnings = ConnectionOptions.checkValidProperties(builder.uri);
        this.uri = builder.uri;
        this.credentialsUrl = builder.credentialsUrl != null ? builder.credentialsUrl : ConnectionOptions.parseCredentials(builder.uri);
        this.encodedCredentials = ConnectionOptions.parseEncodedCredentials(builder.uri);
        this.credentialsProvider = ConnectionOptions.parseCredentialsProvider(builder.uri);
        this.oauthToken = builder.oauthToken != null ? builder.oauthToken : ConnectionOptions.parseOAuthToken(builder.uri);
        Preconditions.checkArgument((Stream.of(this.credentialsUrl, this.encodedCredentials, this.credentialsProvider, this.oauthToken).filter(Objects::nonNull).count() <= 1L ? 1 : 0) != 0, (Object)"Specify only one of credentialsUrl, encodedCredentials, credentialsProvider and OAuth token");
        this.fixedCredentials = builder.credentials;
        this.userAgent = ConnectionOptions.parseUserAgent(this.uri);
        ExecuteSqlRequest.QueryOptions.Builder queryOptionsBuilder = ExecuteSqlRequest.QueryOptions.newBuilder();
        queryOptionsBuilder.setOptimizerVersion(ConnectionOptions.parseOptimizerVersion(this.uri));
        queryOptionsBuilder.setOptimizerStatisticsPackage(ConnectionOptions.parseOptimizerStatisticsPackage(this.uri));
        this.queryOptions = queryOptionsBuilder.build();
        this.returnCommitStats = ConnectionOptions.parseReturnCommitStats(this.uri);
        this.maxCommitDelay = ConnectionOptions.parseMaxCommitDelay(this.uri);
        this.autoConfigEmulator = ConnectionOptions.parseAutoConfigEmulator(this.uri);
        this.useAutoSavepointsForEmulator = ConnectionOptions.parseUseAutoSavepointsForEmulator(this.uri);
        this.dialect = ConnectionOptions.parseDialect(this.uri);
        this.usePlainText = this.autoConfigEmulator || ConnectionOptions.parseUsePlainText(this.uri);
        this.host = ConnectionOptions.determineHost(matcher, ConnectionOptions.parseEndpoint(this.uri), this.autoConfigEmulator, this.usePlainText, System.getenv());
        this.rpcPriority = ConnectionOptions.parseRPCPriority(this.uri);
        this.ddlInTransactionMode = ConnectionOptions.parseDdlInTransactionMode(this.uri);
        this.delayTransactionStartUntilFirstWrite = ConnectionOptions.parseDelayTransactionStartUntilFirstWrite(this.uri);
        this.keepTransactionAlive = ConnectionOptions.parseKeepTransactionAlive(this.uri);
        this.trackSessionLeaks = ConnectionOptions.parseTrackSessionLeaks(this.uri);
        this.trackConnectionLeaks = ConnectionOptions.parseTrackConnectionLeaks(this.uri);
        this.dataBoostEnabled = ConnectionOptions.parseDataBoostEnabled(this.uri);
        this.autoPartitionMode = ConnectionOptions.parseAutoPartitionMode(this.uri);
        this.maxPartitions = ConnectionOptions.parseMaxPartitions(this.uri);
        this.maxPartitionedParallelism = ConnectionOptions.parseMaxPartitionedParallelism(this.uri);
        this.instanceId = matcher.group("INSTANCEGROUP");
        this.databaseName = matcher.group("DATABASEGROUP");
        if (this.fixedCredentials == null && this.credentialsUrl == null && this.encodedCredentials == null && this.credentialsProvider == null && this.oauthToken == null && this.usePlainText) {
            this.credentials = NoCredentials.getInstance();
        } else if (this.oauthToken != null) {
            this.credentials = new GoogleCredentials(new AccessToken(this.oauthToken, null));
        } else if (this.credentialsProvider != null) {
            try {
                this.credentials = this.credentialsProvider.getCredentials();
            }
            catch (IOException exception) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Failed to get credentials from CredentialsProvider: " + exception.getMessage(), exception);
            }
        } else {
            this.credentials = this.fixedCredentials != null ? this.fixedCredentials : (this.encodedCredentials != null ? this.getCredentialsService().decodeCredentials(this.encodedCredentials) : this.getCredentialsService().createCredentials(this.credentialsUrl));
        }
        this.minSessions = ConnectionOptions.parseIntegerProperty(MIN_SESSIONS_PROPERTY_NAME, ConnectionOptions.parseMinSessions(builder.uri));
        this.maxSessions = ConnectionOptions.parseIntegerProperty(MAX_SESSIONS_PROPERTY_NAME, ConnectionOptions.parseMaxSessions(builder.uri));
        this.numChannels = ConnectionOptions.parseIntegerProperty(NUM_CHANNELS_PROPERTY_NAME, ConnectionOptions.parseNumChannels(builder.uri));
        this.channelProvider = ConnectionOptions.parseChannelProvider(builder.uri);
        this.databaseRole = ConnectionOptions.parseDatabaseRole(this.uri);
        String projectId = matcher.group("PROJECTGROUP");
        if ("DEFAULT_PROJECT_ID".equalsIgnoreCase(projectId)) {
            projectId = ConnectionOptions.getDefaultProjectId(this.credentials);
        }
        this.projectId = projectId;
        this.autocommit = ConnectionOptions.parseAutocommit(this.uri);
        this.readOnly = ConnectionOptions.parseReadOnly(this.uri);
        this.routeToLeader = ConnectionOptions.parseRouteToLeader(this.uri);
        this.retryAbortsInternally = ConnectionOptions.parseRetryAbortsInternally(this.uri);
        this.useVirtualThreads = ConnectionOptions.parseUseVirtualThreads(this.uri);
        this.useVirtualGrpcTransportThreads = ConnectionOptions.parseUseVirtualGrpcTransportThreads(this.uri);
        this.openTelemetry = builder.openTelemetry;
        this.tracingPrefix = builder.tracingPrefix;
        this.enableExtendedTracing = ConnectionOptions.parseEnableExtendedTracing(this.uri);
        this.enableApiTracing = ConnectionOptions.parseEnableApiTracing(this.uri);
        this.statementExecutionInterceptors = Collections.unmodifiableList(builder.statementExecutionInterceptors);
        this.configurator = builder.configurator;
        if (this.minSessions != null || this.maxSessions != null || !this.trackSessionLeaks) {
            SessionPoolOptions.Builder sessionPoolOptionsBuilder = builder.sessionPoolOptions == null ? SessionPoolOptions.newBuilder() : builder.sessionPoolOptions.toBuilder();
            sessionPoolOptionsBuilder.setTrackStackTraceOfSessionCheckout(this.trackSessionLeaks);
            sessionPoolOptionsBuilder.setAutoDetectDialect(true);
            if (this.minSessions != null) {
                sessionPoolOptionsBuilder.setMinSessions(this.minSessions);
            }
            if (this.maxSessions != null) {
                sessionPoolOptionsBuilder.setMaxSessions(this.maxSessions);
            }
            this.sessionPoolOptions = sessionPoolOptionsBuilder.build();
        } else {
            this.sessionPoolOptions = builder.sessionPoolOptions != null ? builder.sessionPoolOptions : SessionPoolOptions.newBuilder().setAutoDetectDialect(true).build();
        }
    }

    @VisibleForTesting
    static String determineHost(Matcher matcher, String endpoint, boolean autoConfigEmulator, boolean usePlainText, Map<String, String> environment) {
        if (Objects.equals(endpoint, DEFAULT_ENDPOINT) && matcher.group("HOSTGROUP") == null) {
            if (autoConfigEmulator) {
                if (Strings.isNullOrEmpty((String)environment.get(SPANNER_EMULATOR_HOST_ENV_VAR))) {
                    return DEFAULT_EMULATOR_HOST;
                }
                return "http://" + environment.get(SPANNER_EMULATOR_HOST_ENV_VAR);
            }
            return DEFAULT_HOST;
        }
        String host = !Objects.equals(endpoint, DEFAULT_ENDPOINT) ? "//" + endpoint : matcher.group("HOSTGROUP");
        if (usePlainText) {
            return PLAIN_TEXT_PROTOCOL + host;
        }
        return HOST_PROTOCOL + host;
    }

    private static Integer parseIntegerProperty(String propertyName, String value) {
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, String.format("Invalid %s value specified: %s", propertyName, value), e);
            }
        }
        return null;
    }

    OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    String getTracingPrefix() {
        return this.tracingPrefix;
    }

    SpannerOptionsConfigurator getConfigurator() {
        return this.configurator;
    }

    @VisibleForTesting
    CredentialsService getCredentialsService() {
        return CredentialsService.INSTANCE;
    }

    @VisibleForTesting
    static boolean parseUsePlainText(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, USE_PLAIN_TEXT_PROPERTY_NAME);
        return value != null ? Boolean.parseBoolean(value) : false;
    }

    @VisibleForTesting
    static boolean parseAutocommit(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, AUTOCOMMIT_PROPERTY_NAME);
        return value != null ? Boolean.parseBoolean(value) : true;
    }

    @VisibleForTesting
    static boolean parseReadOnly(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, READONLY_PROPERTY_NAME);
        return value != null ? Boolean.parseBoolean(value) : false;
    }

    static boolean parseRouteToLeader(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, ROUTE_TO_LEADER_PROPERTY_NAME);
        return value != null ? Boolean.parseBoolean(value) : true;
    }

    @VisibleForTesting
    static boolean parseRetryAbortsInternally(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, RETRY_ABORTS_INTERNALLY_PROPERTY_NAME);
        return value != null ? Boolean.parseBoolean(value) : true;
    }

    @VisibleForTesting
    static boolean parseUseVirtualThreads(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, USE_VIRTUAL_THREADS_PROPERTY_NAME);
        return value != null ? Boolean.parseBoolean(value) : false;
    }

    @VisibleForTesting
    static boolean parseUseVirtualGrpcTransportThreads(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, USE_VIRTUAL_GRPC_TRANSPORT_THREADS_PROPERTY_NAME);
        return value != null ? Boolean.parseBoolean(value) : false;
    }

    @Nullable
    @VisibleForTesting
    static String parseCredentials(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, CREDENTIALS_PROPERTY_NAME);
        return value != null ? value : DEFAULT_CREDENTIALS;
    }

    @Nullable
    @VisibleForTesting
    static String parseEncodedCredentials(String uri) {
        String encodedCredentials = ConnectionOptions.parseUriProperty(uri, ENCODED_CREDENTIALS_PROPERTY_NAME);
        ConnectionOptions.checkGuardedProperty(encodedCredentials, ENABLE_ENCODED_CREDENTIALS_SYSTEM_PROPERTY, ENCODED_CREDENTIALS_PROPERTY_NAME);
        return encodedCredentials;
    }

    @Nullable
    @VisibleForTesting
    static CredentialsProvider parseCredentialsProvider(String uri) {
        String credentialsProviderName = ConnectionOptions.parseUriProperty(uri, CREDENTIALS_PROVIDER_PROPERTY_NAME);
        ConnectionOptions.checkGuardedProperty(credentialsProviderName, ENABLE_CREDENTIALS_PROVIDER_SYSTEM_PROPERTY, CREDENTIALS_PROVIDER_PROPERTY_NAME);
        if (!Strings.isNullOrEmpty((String)credentialsProviderName)) {
            try {
                Class<?> clazz = Class.forName(credentialsProviderName);
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                return (CredentialsProvider)constructor.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Unknown or invalid CredentialsProvider class name: " + credentialsProviderName, classNotFoundException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Credentials provider " + credentialsProviderName + " does not have a public no-arg constructor.", noSuchMethodException);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException exception) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Failed to create an instance of " + credentialsProviderName + ": " + exception.getMessage(), exception);
            }
        }
        return null;
    }

    private static void checkGuardedProperty(String value, String systemPropertyName, String connectionPropertyName) {
        if (!Strings.isNullOrEmpty((String)value) && !Boolean.parseBoolean(System.getProperty(systemPropertyName))) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, ConnectionOptions.generateGuardedConnectionPropertyError(systemPropertyName, connectionPropertyName));
        }
    }

    @Nullable
    @VisibleForTesting
    static String parseOAuthToken(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, OAUTH_TOKEN_PROPERTY_NAME);
        return value != null ? value : DEFAULT_OAUTH_TOKEN;
    }

    @VisibleForTesting
    static String parseMinSessions(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, MIN_SESSIONS_PROPERTY_NAME);
        return value != null ? value : DEFAULT_MIN_SESSIONS;
    }

    @VisibleForTesting
    static String parseMaxSessions(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, MAX_SESSIONS_PROPERTY_NAME);
        return value != null ? value : DEFAULT_MAX_SESSIONS;
    }

    @VisibleForTesting
    static String parseNumChannels(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, NUM_CHANNELS_PROPERTY_NAME);
        return value != null ? value : DEFAULT_NUM_CHANNELS;
    }

    private static String parseEndpoint(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, ENDPOINT_PROPERTY_NAME);
        return value != null ? value : DEFAULT_ENDPOINT;
    }

    @VisibleForTesting
    static String parseChannelProvider(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, CHANNEL_PROVIDER_PROPERTY_NAME);
        ConnectionOptions.checkGuardedProperty(value, ENABLE_CHANNEL_PROVIDER_SYSTEM_PROPERTY, CHANNEL_PROVIDER_PROPERTY_NAME);
        return value != null ? value : DEFAULT_CHANNEL_PROVIDER;
    }

    @VisibleForTesting
    static String parseDatabaseRole(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, DATABASE_ROLE_PROPERTY_NAME);
        return value != null ? value : DEFAULT_DATABASE_ROLE;
    }

    @VisibleForTesting
    static String parseUserAgent(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, USER_AGENT_PROPERTY_NAME);
        return value != null ? value : DEFAULT_USER_AGENT;
    }

    @VisibleForTesting
    static String parseOptimizerVersion(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, OPTIMIZER_VERSION_PROPERTY_NAME);
        return value != null ? value : "";
    }

    @VisibleForTesting
    static String parseOptimizerStatisticsPackage(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, OPTIMIZER_STATISTICS_PACKAGE_PROPERTY_NAME);
        return value != null ? value : "";
    }

    @VisibleForTesting
    static boolean parseReturnCommitStats(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, "returnCommitStats");
        return Boolean.parseBoolean(value);
    }

    @VisibleForTesting
    static Long parseMaxCommitDelay(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, "maxCommitDelay");
        try {
            Long millis;
            Long l = millis = value == null ? null : Long.valueOf(value);
            if (millis != null && millis < 0L) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "maxCommitDelay must be >=0");
            }
            return millis;
        }
        catch (NumberFormatException numberFormatException) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Invalid value for maxCommitDelay: " + value + "\nThe value must be a positive integer indicating the number of milliseconds to use as the max delay.");
        }
    }

    static boolean parseAutoConfigEmulator(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, "autoConfigEmulator");
        return Boolean.parseBoolean(value);
    }

    static boolean parseUseAutoSavepointsForEmulator(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, "useAutoSavepointsForEmulator");
        return Boolean.parseBoolean(value);
    }

    @VisibleForTesting
    static Dialect parseDialect(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, DIALECT_PROPERTY_NAME);
        return value != null ? Dialect.valueOf(value.toUpperCase()) : Dialect.GOOGLE_STANDARD_SQL;
    }

    @VisibleForTesting
    static boolean parseLenient(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, LENIENT_PROPERTY_NAME);
        return value != null ? Boolean.parseBoolean(value) : false;
    }

    @VisibleForTesting
    static boolean parseDelayTransactionStartUntilFirstWrite(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, DELAY_TRANSACTION_START_UNTIL_FIRST_WRITE_NAME);
        return value != null ? Boolean.parseBoolean(value) : false;
    }

    @VisibleForTesting
    static boolean parseKeepTransactionAlive(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, KEEP_TRANSACTION_ALIVE_PROPERTY_NAME);
        return value != null ? Boolean.parseBoolean(value) : false;
    }

    @VisibleForTesting
    static boolean parseTrackSessionLeaks(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, TRACK_SESSION_LEAKS_PROPERTY_NAME);
        return value != null ? Boolean.parseBoolean(value) : true;
    }

    @VisibleForTesting
    static boolean parseTrackConnectionLeaks(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, TRACK_CONNECTION_LEAKS_PROPERTY_NAME);
        return value != null ? Boolean.parseBoolean(value) : true;
    }

    @VisibleForTesting
    static boolean parseDataBoostEnabled(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, DATA_BOOST_ENABLED_PROPERTY_NAME);
        return value != null ? Boolean.parseBoolean(value) : false;
    }

    @VisibleForTesting
    static boolean parseAutoPartitionMode(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, AUTO_PARTITION_MODE_PROPERTY_NAME);
        return value != null ? Boolean.parseBoolean(value) : false;
    }

    @VisibleForTesting
    static int parseMaxPartitions(String uri) {
        String stringValue = ConnectionOptions.parseUriProperty(uri, MAX_PARTITIONS_PROPERTY_NAME);
        if (stringValue == null) {
            return 0;
        }
        try {
            int value = Integer.parseInt(stringValue);
            if (value < 0) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "maxPartitions must be >=0");
            }
            return value;
        }
        catch (NumberFormatException numberFormatException) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Invalid value for maxPartitions: " + stringValue);
        }
    }

    @VisibleForTesting
    static int parseMaxPartitionedParallelism(String uri) {
        String stringValue = ConnectionOptions.parseUriProperty(uri, MAX_PARTITIONED_PARALLELISM_PROPERTY_NAME);
        if (stringValue == null) {
            return 1;
        }
        try {
            int value = Integer.parseInt(stringValue);
            if (value < 0) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "maxPartitionedParallelism must be >=0");
            }
            return value;
        }
        catch (NumberFormatException numberFormatException) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Invalid value for maxPartitionedParallelism: " + stringValue);
        }
    }

    @VisibleForTesting
    static Options.RpcPriority parseRPCPriority(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, RPC_PRIORITY_NAME);
        return value != null ? Options.RpcPriority.valueOf(value) : DEFAULT_RPC_PRIORITY;
    }

    @VisibleForTesting
    static DdlInTransactionMode parseDdlInTransactionMode(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, DDL_IN_TRANSACTION_MODE_PROPERTY_NAME);
        return value != null ? DdlInTransactionMode.valueOf(value.toUpperCase()) : DEFAULT_DDL_IN_TRANSACTION_MODE;
    }

    @VisibleForTesting
    static Boolean parseEnableExtendedTracing(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, ENABLE_EXTENDED_TRACING_PROPERTY_NAME);
        return value != null ? Boolean.valueOf(value) : DEFAULT_ENABLE_EXTENDED_TRACING;
    }

    @VisibleForTesting
    static Boolean parseEnableApiTracing(String uri) {
        String value = ConnectionOptions.parseUriProperty(uri, ENABLE_API_TRACING_PROPERTY_NAME);
        return value != null ? Boolean.valueOf(value) : DEFAULT_ENABLE_API_TRACING;
    }

    @VisibleForTesting
    static String parseUriProperty(String uri, String property) {
        Pattern pattern = Pattern.compile(String.format("(?is)(?:;|\\?)%s=(.*?)(?:;|$)", property));
        Matcher matcher = pattern.matcher(uri);
        if (matcher.find() && matcher.groupCount() == 1) {
            return matcher.group(1);
        }
        return null;
    }

    @VisibleForTesting
    static String checkValidProperties(String uri) {
        String invalidProperties = "";
        List<String> properties = ConnectionOptions.parseProperties(uri);
        boolean lenient = ConnectionOptions.parseLenient(uri);
        for (String property : properties) {
            if (INTERNAL_VALID_PROPERTIES.contains(ConnectionProperty.createEmptyProperty(property))) continue;
            if (invalidProperties.length() > 0) {
                invalidProperties = invalidProperties + ", ";
            }
            invalidProperties = invalidProperties + property;
        }
        if (lenient) {
            return String.format("Invalid properties found in connection URI: %s", invalidProperties);
        }
        Preconditions.checkArgument((boolean)invalidProperties.isEmpty(), (Object)String.format("Invalid properties found in connection URI. Add lenient=true to the connection string to ignore unknown properties. Invalid properties: %s", invalidProperties));
        return null;
    }

    @VisibleForTesting
    static List<String> parseProperties(String uri) {
        Pattern pattern = Pattern.compile("(?is)(?:\\?|;)(?<PROPERTY>.*?)=(?:.*?)");
        Matcher matcher = pattern.matcher(uri);
        ArrayList<String> res = new ArrayList<String>();
        while (matcher.find() && matcher.group("PROPERTY") != null) {
            res.add(matcher.group("PROPERTY"));
        }
        return res;
    }

    static long tryParseLong(String value, long defaultValue) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ignore) {
            return defaultValue;
        }
    }

    public Connection getConnection() {
        LOCAL_CONNECTION_CHECKER.checkLocalConnection(this);
        return new ConnectionImpl(this);
    }

    public String getUri() {
        return this.uri;
    }

    public String getCredentialsUrl() {
        return this.credentialsUrl;
    }

    String getOAuthToken() {
        return this.oauthToken;
    }

    Credentials getFixedCredentials() {
        return this.fixedCredentials;
    }

    CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public SessionPoolOptions getSessionPoolOptions() {
        return this.sessionPoolOptions;
    }

    public Integer getMinSessions() {
        return this.minSessions;
    }

    public Integer getMaxSessions() {
        return this.maxSessions;
    }

    public Integer getNumChannels() {
        return this.numChannels;
    }

    public TransportChannelProvider getChannelProvider() {
        if (this.channelProvider == null) {
            return null;
        }
        try {
            URL url = new URL(this.host);
            ExternalChannelProvider provider = (ExternalChannelProvider)ExternalChannelProvider.class.cast(Class.forName(this.channelProvider).newInstance());
            return provider.getChannelProvider(url.getHost(), url.getPort());
        }
        catch (Exception e) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, String.format("%s : Failed to create channel with external provider: %s", e.toString(), this.channelProvider));
        }
    }

    public String getDatabaseRole() {
        return this.databaseRole;
    }

    public String getHost() {
        return this.host;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public DatabaseId getDatabaseId() {
        Preconditions.checkState((this.projectId != null ? 1 : 0) != 0, (Object)"Project ID is not specified");
        Preconditions.checkState((this.instanceId != null ? 1 : 0) != 0, (Object)"Instance ID is not specified");
        Preconditions.checkState((this.databaseName != null ? 1 : 0) != 0, (Object)"Database name is not specified");
        return DatabaseId.of(this.projectId, this.instanceId, this.databaseName);
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public boolean isAutocommit() {
        return this.autocommit;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isRouteToLeader() {
        return this.routeToLeader;
    }

    public boolean isRetryAbortsInternally() {
        return this.retryAbortsInternally;
    }

    public boolean isUseVirtualThreads() {
        return this.useVirtualThreads;
    }

    public boolean isUseVirtualGrpcTransportThreads() {
        return this.useVirtualGrpcTransportThreads;
    }

    @Nullable
    public String getWarnings() {
        return this.warnings;
    }

    boolean isUsePlainText() {
        return this.usePlainText;
    }

    String getUserAgent() {
        return this.userAgent;
    }

    ExecuteSqlRequest.QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    public boolean isReturnCommitStats() {
        return this.returnCommitStats;
    }

    public Duration getMaxCommitDelay() {
        return this.maxCommitDelay == null ? null : Duration.ofMillis(this.maxCommitDelay);
    }

    boolean usesEmulator() {
        return (Boolean)Suppliers.memoize(() -> this.autoConfigEmulator || !Strings.isNullOrEmpty((String)System.getenv(SPANNER_EMULATOR_HOST_ENV_VAR))).get();
    }

    public boolean isAutoConfigEmulator() {
        return this.autoConfigEmulator;
    }

    boolean useAutoSavepointsForEmulator() {
        return this.useAutoSavepointsForEmulator;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    Options.RpcPriority getRPCPriority() {
        return this.rpcPriority;
    }

    DdlInTransactionMode getDdlInTransactionMode() {
        return this.ddlInTransactionMode;
    }

    boolean isDelayTransactionStartUntilFirstWrite() {
        return this.delayTransactionStartUntilFirstWrite;
    }

    boolean isKeepTransactionAlive() {
        return this.keepTransactionAlive;
    }

    boolean isTrackConnectionLeaks() {
        return this.trackConnectionLeaks;
    }

    boolean isDataBoostEnabled() {
        return this.dataBoostEnabled;
    }

    boolean isAutoPartitionMode() {
        return this.autoPartitionMode;
    }

    int getMaxPartitions() {
        return this.maxPartitions;
    }

    int getMaxPartitionedParallelism() {
        return this.maxPartitionedParallelism;
    }

    Boolean isEnableExtendedTracing() {
        return this.enableExtendedTracing;
    }

    Boolean isEnableApiTracing() {
        return this.enableApiTracing;
    }

    List<StatementExecutionInterceptor> getStatementExecutionInterceptors() {
        return this.statementExecutionInterceptors;
    }

    public String toString() {
        return this.getUri();
    }

    public static class Builder {
        private String uri;
        private String credentialsUrl;
        private String oauthToken;
        private Credentials credentials;
        private SessionPoolOptions sessionPoolOptions;
        private List<StatementExecutionInterceptor> statementExecutionInterceptors = Collections.emptyList();
        private SpannerOptionsConfigurator configurator;
        private OpenTelemetry openTelemetry;
        private String tracingPrefix;
        public static final String SPANNER_URI_FORMAT = "(?:cloudspanner:)(?<HOSTGROUP>//[\\w.-]+(?:\\.[\\w\\.-]+)*[\\w\\-\\._~:/?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=.]+)?/projects/(?<PROJECTGROUP>(([a-z]|[-.:]|[0-9])+|(DEFAULT_PROJECT_ID)))(/instances/(?<INSTANCEGROUP>([a-z]|[-]|[0-9])+)(/databases/(?<DATABASEGROUP>([a-z]|[-]|[_]|[0-9])+))?)?(?:[?|;].*)?";
        private static final String SPANNER_URI_REGEX = "(?is)^(?:cloudspanner:)(?<HOSTGROUP>//[\\w.-]+(?:\\.[\\w\\.-]+)*[\\w\\-\\._~:/?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=.]+)?/projects/(?<PROJECTGROUP>(([a-z]|[-.:]|[0-9])+|(DEFAULT_PROJECT_ID)))(/instances/(?<INSTANCEGROUP>([a-z]|[-]|[0-9])+)(/databases/(?<DATABASEGROUP>([a-z]|[-]|[_]|[0-9])+))?)?(?:[?|;].*)?$";
        @VisibleForTesting
        static final Pattern SPANNER_URI_PATTERN = Pattern.compile("(?is)^(?:cloudspanner:)(?<HOSTGROUP>//[\\w.-]+(?:\\.[\\w\\.-]+)*[\\w\\-\\._~:/?#\\[\\]@!\\$&'\\(\\)\\*\\+,;=.]+)?/projects/(?<PROJECTGROUP>(([a-z]|[-.:]|[0-9])+|(DEFAULT_PROJECT_ID)))(/instances/(?<INSTANCEGROUP>([a-z]|[-]|[0-9])+)(/databases/(?<DATABASEGROUP>([a-z]|[-]|[_]|[0-9])+))?)?(?:[?|;].*)?$");
        private static final String HOST_GROUP = "HOSTGROUP";
        private static final String PROJECT_GROUP = "PROJECTGROUP";
        private static final String INSTANCE_GROUP = "INSTANCEGROUP";
        private static final String DATABASE_GROUP = "DATABASEGROUP";
        private static final String DEFAULT_PROJECT_ID_PLACEHOLDER = "DEFAULT_PROJECT_ID";

        private Builder() {
        }

        private boolean isValidUri(String uri) {
            return SPANNER_URI_PATTERN.matcher(uri).matches();
        }

        public Builder setUri(String uri) {
            Preconditions.checkArgument((boolean)this.isValidUri(uri), (Object)"The specified URI is not a valid Cloud Spanner connection URI. Please specify a URI in the format \"cloudspanner:[//host[:port]]/projects/project-id[/instances/instance-id[/databases/database-name]][\\?property-name=property-value[;property-name=property-value]*]?\"");
            ConnectionOptions.checkValidProperties(uri);
            this.uri = uri;
            return this;
        }

        public Builder setSessionPoolOptions(SessionPoolOptions sessionPoolOptions) {
            Preconditions.checkNotNull((Object)sessionPoolOptions);
            this.sessionPoolOptions = sessionPoolOptions;
            return this;
        }

        public Builder setCredentialsUrl(String credentialsUrl) {
            this.credentialsUrl = credentialsUrl;
            return this;
        }

        public Builder setOAuthToken(String oauthToken) {
            this.oauthToken = oauthToken;
            return this;
        }

        @VisibleForTesting
        Builder setStatementExecutionInterceptors(List<StatementExecutionInterceptor> interceptors) {
            this.statementExecutionInterceptors = interceptors;
            return this;
        }

        @VisibleForTesting
        Builder setConfigurator(SpannerOptionsConfigurator configurator) {
            this.configurator = (SpannerOptionsConfigurator)Preconditions.checkNotNull((Object)configurator);
            return this;
        }

        @VisibleForTesting
        Builder setCredentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public Builder setOpenTelemetry(OpenTelemetry openTelemetry) {
            this.openTelemetry = openTelemetry;
            return this;
        }

        public Builder setTracingPrefix(String tracingPrefix) {
            this.tracingPrefix = tracingPrefix;
            return this;
        }

        public ConnectionOptions build() {
            Preconditions.checkState((this.uri != null ? 1 : 0) != 0, (Object)"Connection URI is required");
            return new ConnectionOptions(this);
        }
    }

    @VisibleForTesting
    static interface SpannerOptionsConfigurator {
        public void configure(SpannerOptions.Builder var1);
    }

    public static class ConnectionProperty {
        private static final String[] BOOLEAN_VALUES = new String[]{"true", "false"};
        private final String name;
        private final String description;
        private final String defaultValue;
        private final String[] validValues;
        private final int hashCode;

        private static ConnectionProperty createStringProperty(String name, String description) {
            return new ConnectionProperty(name, description, "", null);
        }

        private static ConnectionProperty createBooleanProperty(String name, String description, Boolean defaultValue) {
            return new ConnectionProperty(name, description, defaultValue == null ? "" : String.valueOf(defaultValue), BOOLEAN_VALUES);
        }

        private static ConnectionProperty createIntProperty(String name, String description, int defaultValue) {
            return new ConnectionProperty(name, description, String.valueOf(defaultValue), null);
        }

        private static ConnectionProperty createEmptyProperty(String name) {
            return new ConnectionProperty(name, "", "", null);
        }

        private ConnectionProperty(String name, String description, String defaultValue, String[] validValues) {
            Preconditions.checkNotNull((Object)name);
            Preconditions.checkNotNull((Object)description);
            Preconditions.checkNotNull((Object)defaultValue);
            this.name = name;
            this.description = description;
            this.defaultValue = defaultValue;
            this.validValues = validValues;
            this.hashCode = name.toLowerCase().hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ConnectionProperty)) {
                return false;
            }
            return ((ConnectionProperty)o).name.equalsIgnoreCase(this.name);
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String[] getValidValues() {
            return this.validValues;
        }

        static /* synthetic */ ConnectionProperty access$000(String x0, String x1, Boolean x2) {
            return ConnectionProperty.createBooleanProperty(x0, x1, x2);
        }

        static /* synthetic */ ConnectionProperty access$100(String x0, String x1) {
            return ConnectionProperty.createStringProperty(x0, x1);
        }

        static /* synthetic */ ConnectionProperty access$200(String x0, String x1, int x2) {
            return ConnectionProperty.createIntProperty(x0, x1, x2);
        }
    }

    public static interface ExternalChannelProvider {
        public TransportChannelProvider getChannelProvider(String var1, int var2);
    }
}

